# Component Install Helper Scripts

## Introduction

We are providing an example helper script (called `install.ps1`) that can
be used to help install and configure some of the system requirements on
your Microsoft Windows server.

## Example Usage

It takes certain parameters that allow you to specify an environment according to your needs:

This set is designed to install ActiveMQ, OpenJDK, PostgreSQL, and Tomcat:
  ```
  .\install.ps1 -all -secret password
  ```

This set is designed to help install ActiveMQ, OpenJDK, and Tomcat:
  ```
  .\install.ps1 -idgov
  ```

This set is designed to help install OpenJDK and Tomcat:
  ```
  .\install.ps1 -base
  ```

## Component Versions

The script has been created to use variables, which allow for easy modification when necessary.
For Windows, the archive files for ActiveMQ, OpenJDK, and Tomcat are .zip.
If PostgreSQL will be installed the .exe file is required.
On Windows, the script will also create the necessary for Tomcat and ActiveMQ to run as a
Windows Service (`IDM Apps Tomcat Service`).
The service will be set to manual start by default.

Note: If installing PostgreSQL, the installer from EnterpriseDB will also create the necessary
for PostgreSQL to run as a Windows Service (`postgresql-x64-11`).

Refer to the System Requirements for Identity Governance 4.2 for the required versions of
Apache ActiveMQ, Apache Tomcat, Zulu OpenJDK from Azul, and the database server
(Microsoft SQL Server, Oracle, or PostgreSQL).

# Setup

Steps to utilize the Windows helper script.

1. Extract the zip to the Windows Server that you are going to install on.

2. a. You should have the following for Windows:
   - %base%\windows
   - %base%\windows\compressed
   - %base%\windows\install.ps1
   - %base%\windows\README.md
   - %base%\windows\Sample_code_EULA.txt
   - %base%\windows\untouched
   - %base%\windows\untouched\index.html
   - %base%\windows\untouched\start-tomcat.bat
   - %base%\windows\untouched\stop-tomcat.bat
   - %base%\windows\untouched\TomcatService.exe

   b. Put the necessary .zip or .exe files in the compressed folder.
   For Example:
   - apache-activemq-5.17.6-bin.zip
   - apache-tomcat-9.0.83-windows-x64.zip
   - postgresql-14.9-1-windows-x64.exe
   - zulu11.68.17-ca-jdk11.0.21-win_x64.zip

3. a. Open the script, using Windows PowerShell ISE.

   b. Confirm the version numbers match what you have downloaded. If not, update the script.

   c. Confirm the install location matches your requirement. If not, update it accordingly.

   d. Save and close the file.

4. Open a Windows PowerShell Terminal as Administrator (if you are not already),
   navigate to the %base%\windows directory, and then run the script.

   For Examples:
   ```
   .\install.ps1 -all -secret password
   .\install.ps1 -idgov
   .\install.ps1 -base
   ```
   In the Terminal you will see what is happening. The script will also create a log file with the output as well.

5. After the above has completed, you can then install OSP, Identity Governance, Identity Reporting, or Workflow Engine.
