. ${PSScriptRoot}\def_upgrade.ps1

${active_mq_loc_final} = "${ACTIVE_MQ_DEFAULT}"
${java_loc_final} = "${JAVA_DEFAULT}"
${postgresql_loc_final} = "${POSTGRESQL_PATH_DEFAULT}"
${tomcat_loc_final} = "${TOMCAT_DEFAULT}"

${postgresql_admin} = "${POSTGRESQL_ADMIN_DEFAULT}"
${postgresql_port} = "${POSTGRESQL_PORT_DEFAULT}"
${postgresql_server} = "${POSTGRESQL_SERVER_DEFAULT}"

${active_mq_summary_code} = ${SUMMARY_CODE_FAILED}
${java_summary_code} = ${SUMMARY_CODE_FAILED}
${postgresql_summary_code} = ${SUMMARY_CODE_FAILED}
${tomcat_summary_code} = ${SUMMARY_CODE_FAILED}


If (Test-Path ${FILE_TOMCAT}) {
  ${tomcat_summary_code} = ${SUMMARY_CODE_SKIPPED}
  ${do_please} = Read-Host "It appears you are ready to upgrade Tomcat. Shall we proceed? [y/N]"
  If ("${do_please}" -eq "y" -Or "${do_please}" -eq "Y") {
    ${tomcat_summary_code} = ${SUMMARY_CODE_FAILED}
    ${input_invalid} = ${TRUE}
    while (${input_invalid}) {
      ${tomcat_loc} = Read-Host "  Where is your Tomcat located? [${tomcat_loc_final}]"
      If ("${tomcat_loc}" -ne "") { ${tomcat_loc_final} = ${tomcat_loc} }
      ${result} = (Get-PathValidity ${tomcat_loc_final} ${TOMCAT_VALIDITY})
      If ($result -eq ${TRUE} ) {
        ${input_invalid} = ${FALSE}
        Wait-StopProcesses "Tomcat" "tomcat"

        # Rename older tomcat parent folder
        ${tomcat_loc_rename} = "${tomcat_loc_final}-${TIMESTAMP}"
        Write-Host "    Renaming existing Tomcat location as `"${tomcat_loc_rename}`""
        Move-Item -Path ${tomcat_loc_final} -Destination ${tomcat_loc_rename} -Force

        # Unpack the new Tomcat tar where the old Tomcat was
        Unzip ${FILE_TOMCAT} ${tomcat_loc_final}

        Discard-SpecificFiles "Tomcat" ${tomcat_loc_final} ${TOMCAT_DISCARD}
        Copy-OldFiles "Tomcat" ${tomcat_loc_rename} ${tomcat_loc_final} ${TOMCAT_RETAIN}
        Disable-AJPConnector ${tomcat_loc_final}

        ${tomcat_summary_code} = ${SUMMARY_CODE_COMPLETED}
        Show-Differences ${tomcat_loc_final} ${tomcat_loc_rename}
      }
    }
  }
} Else {
  Write-Host "  You need to supply '${FILE_TOMCAT}' before Tomcat can be upgraded"
  ${tomcat_summary_code} = ${SUMMARY_CODE_MISSED}
}


If (Test-Path ${FILE_ACTIVE_MQ}) {
  ${active_mq_summary_code} = ${SUMMARY_CODE_SKIPPED}
  ${do_please} = Read-Host "It appears you are ready to upgrade ActiveMQ. Shall we proceed? [y/N]"
  If ("${do_please}" -eq "y" -Or "${do_please}" -eq "Y") {
    ${active_mq_summary_code} = ${SUMMARY_CODE_FAILED}
    ${input_invalid} = ${TRUE}
    while (${input_invalid}) {
      ${active_mq_loc} = Read-Host "  Where is your ActiveMQ located? [${active_mq_loc_final}]"
      If ("${active_mq_loc}" -ne "") { ${active_mq_loc_final} = ${active_mq_loc} }
      ${result} = (Get-PathValidity ${active_mq_loc_final} ${ACTIVE_MQ_VALIDITY})
      If ($result -eq ${TRUE} ) {
        ${input_invalid} = ${FALSE}
        Get-ValidJavaPath
        Wait-StopProcesses "ActiveMQ" "activemq"

        # Rename older ActiveMQ parent folder
        ${active_mq_loc_rename} = "${active_mq_loc_final}-${TIMESTAMP}"
        Write-Host "    Renaming existing ActiveMQ location as `"${active_mq_loc_rename}`""
        Move-Item -Path ${active_mq_loc_final} -Destination ${active_mq_loc_rename} -Force

        # Unpack the new ActiveMQ tar where the old ActiveMQ was
        Unzip ${FILE_ACTIVE_MQ} ${active_mq_loc_final}

        # Store Java location within activemq.bat
        ((Get-Content -path "${active_mq_loc_final}\bin\activemq.bat" -Raw) -replace
          "if `"%JAVA_HOME%`" == `"`" goto noJavaHome",
          "if `"%JAVA_HOME%`" == `"`" set JAVA_HOME=${java_loc_final}") |
          Set-Content -Path "${active_mq_loc_final}\bin\activemq.bat"

        Copy-OldFiles "ActiveMQ" ${active_mq_loc_rename} ${active_mq_loc_final} ${ACTIVE_MQ_RETAIN}
        
         addRequiredMQJar

        ${active_mq_summary_code} = ${SUMMARY_CODE_COMPLETED}
        Show-Differences ${active_mq_loc_final} ${active_mq_loc_rename}
      }
    }
  }
} Else {
  Write-Host "  You need to supply '${FILE_ACTIVE_MQ}' before ActiveMQ can be upgraded"
  ${active_mq_summary_code} = ${SUMMARY_CODE_MISSED}
}


If (Test-Path ${FILE_JAVA}) {
  ${java_summary_code} = ${SUMMARY_CODE_SKIPPED}
  ${do_please} = Read-Host "It appears you are ready to upgrade Java. Shall we proceed? [y/N]"
  If ("${do_please}" -eq "y" -Or "${do_please}" -eq "Y") {
    ${java_summary_code} = ${SUMMARY_CODE_FAILED}
    Get-ValidJavaPath

    Wait-StopProcesses "Tomcat" "tomcat"
    Wait-StopProcesses "ActiveMQ" "activemq"

    # Make a link for copying files
    ${parent} = "$(Split-Path -Path ${java_loc_final} -Parent)"
    ${copy_link} = "${parent}\copier-${TIMESTAMP}"

    # Create a symbolic link for copying files
    ${item} = (Get-Item -Path ${java_loc_final})
    If (${item}.Attributes -match "ReparsePoint") {
      # A link will ultimately point to the new location
      ${copy_item} = (New-Item -ItemType SymbolicLink -Path "${copy_link}" -Target "$(Get-ResolvedPath ${item}.FullName)")
      ${item}.Delete()
    } Else {
      # A directory will need to be renamed since a link will replace it
      ${java_loc_rename} = "${java_loc_final}-${TIMESTAMP}"
      Rename-Item -Path ${java_loc_final} -NewName ${java_loc_rename} -Force
      ${copy_item} = (New-Item -ItemType SymbolicLink -Path "${copy_link}" -Target "${java_loc_rename}")
    }

    # Unpack Java into unique destination name (same path; jdk-timestamp)
    # Note: this is the reverse of other moves because Java is likely in use
    ${java_loc_jdk} = "${parent}\jdk"
    If (Test-Path ${java_loc_jdk}) {
      ${java_loc_jdk} = "${java_loc_jdk}-${TIMESTAMP}"
    }

    # Unpack the new Java tar where the old Java was
    Unzip ${FILE_JAVA} ${java_loc_jdk}

    # Create a symbolic link with the old name but new destination
    #Java 1.8 $null = (New-Item -ItemType SymbolicLink -Path "${java_loc_final}" -Target "${java_loc_jdk}\jre")
    $null = (New-Item -ItemType SymbolicLink -Path "${java_loc_final}" -Target "${java_loc_jdk}")
    Copy-OldFiles "Java" ${copy_link} ${java_loc_final} ${JAVA_RETAIN}

    ${java_summary_code} = ${SUMMARY_CODE_COMPLETED}
    Show-Differences "${java_loc_final}" "$(${copy_item}.Target)"

    # Remove copy-link
    ${copy_item}.Delete()
  }
} Else {
  Write-Host "  You need to supply '${FILE_JAVA}' before Java can be upgraded"
  ${java_summary_code} = ${SUMMARY_CODE_MISSED}
}


If (Test-Path ${FILE_POSTGRESQL}) {
  ${postgresql_summary_code} = ${SUMMARY_CODE_SKIPPED}
  ${do_please} = Read-Host "It appears you are ready to upgrade PostgreSQL. Shall we proceed? [y/N]"
  If ("${do_please}" -eq "y" -Or "${do_please}" -eq "Y") {
    ${postgresql_summary_code} = ${SUMMARY_CODE_FAILED}
    ${input_invalid} = ${TRUE}
    while (${input_invalid}) {
      ${postgresql_loc} = Read-Host "  Where is your PostgreSQL located? [${postgresql_loc_final}]"
      If ("${postgresql_loc}" -ne "") { ${postgresql_loc_final} = ${postgresql_loc} }
      ${result} = (Get-PathValidity ${postgresql_loc_final} ${POSTGRESQL_VALIDITY})
      If ($result -eq ${TRUE} ) {
        ${input_invalid} = ${FALSE}

        # Back up existing PostgreSQL data
        ${admin_temp} = Read-Host -Prompt "  Specify PostgreSQL admin username [${postgresql_admin}]"
        If ((${admin_temp} -ne ${null}) -and (${admin_temp}) -ne "") { ${postgresql_admin} = ${admin_temp} }

        ${private:PG_PWD_NEEDS_REMOVAL} = ${false}
        If (${env:PGPASSWORD} -eq ${null}) {
          ${private:PG_PWD_NEEDS_REMOVAL} = ${true}
          ${env:PGPASSWORD} = [System.Runtime.InteropServices.Marshal]::PtrToStringAuto(
            [System.Runtime.InteropServices.Marshal]::SecureStringToBSTR(
              $(Read-Host -Prompt "  Specify PostgreSQL admin password" -AsSecureString)
            )
          )
        } Else {
          Write-Host "  Reading PostgreSQL admin password from `"PGPASSWORD`" environment variable"
        }

        ${server_temp} = Read-Host -Prompt "  Specify PostgreSQL server [${postgresql_server}]"
        If ((${server_temp} -ne ${null}) -and (${server_temp}) -ne "") { ${postgresql_server} = ${server_temp} }

        ${port_temp} = Read-Host -Prompt "  Specify PostgreSQL port [${postgresql_port}]"
        If ((${port_temp} -ne ${null}) -and (${port_temp}) -ne "") { ${postgresql_port} = ${port_temp} }

        ${destination_files} = "${PSScriptRoot}\sql-${TIMESTAMP}"

        Backup-Databases `
          ${postgresql_admin} `
          ${postgresql_server} `
          ${postgresql_port} `
          ${postgresql_loc_final} `
          ${destination_files} `
          ${POSTGRESQL_DATABASES}

        # Stop and disable old PostgreSQL service
        Wait-StopServices "PostgreSQL" "postgres"
        Wait-DisableServices "PostgreSQL" "postgres"

        # Rename old PostgreSQL folder
        ${postgresql_loc_rename} = "${postgresql_loc_final}-${TIMESTAMP}"
        Write-Host "    Renaming existing PostgreSQL location as `"${postgresql_loc_rename}`""
        Move-Item -Path ${postgresql_loc_final} -Destination ${postgresql_loc_rename} -Force

        # Install PostgreSQL
        Write-Host "    Installing PostgreSQL using `"${FILE_POSTGRESQL}`""
        Write-Host (
          "    ",
          "Start-Process",
            "-FilePath ${FILE_POSTGRESQL}",
            "-Wait",
            "-NoNewWindow",
            "-ArgumentList",
              "`"--unattendedmodeui none`",",
              "`"--mode unattended`",",
              "`"--superaccount ${postgresql_admin}`",",
              "`"--superpassword *******`",",
              "`"--serverport ${postgresql_port}`",",
              "`"--prefix ${postgresql_loc_final}`",",
              "`"--datadir ${postgresql_loc_final}\data`""
        )
        Start-Process `
          -FilePath ${FILE_POSTGRESQL} `
          -Wait `
          -NoNewWindow `
          -ArgumentList `
            "--unattendedmodeui none", `
            "--mode unattended", `
            "--superaccount ${postgresql_admin}", `
            "--superpassword ${env:PGPASSWORD}", `
            "--serverport ${postgresql_port}", `
            "--prefix ${postgresql_loc_final}", `
            "--datadir ${postgresql_loc_final}\data"

        # Restore PostgreSQL data and files
        Copy-OldFiles "PostgreSQL" ${postgresql_loc_rename} ${postgresql_loc_final} ${POSTGRESQL_RETAIN_BIN}

        # Restart PostgreSQL service
        Get-Service -DisplayName "*postgres*" | Where-Object {($_.StartType -ne "Disable")} | Restart-Service -Force

        # Restore databases
        Restore-Databases `
          ${postgresql_admin} `
          ${postgresql_server} `
          ${postgresql_port} `
          ${postgresql_loc_final} `
          ${destination_files} `
          ${POSTGRESQL_DATABASES}

        # Remove PostgreSQL admin password if we set it
        If (${PG_PWD_NEEDS_REMOVAL}) {
          [System.Environment]::SetEnvironmentVariable("PGPASSWORD", $null)
        }

        ${postgresql_summary_code} = ${SUMMARY_CODE_COMPLETED}
        #Show-Differences ${postgresql_loc_final} ${postgresql_loc_rename}
      }
    }
  }
} Else {
  Write-Host "  You need to supply '${FILE_POSTGRESQL}' before PostgreSQL can be upgraded"
  ${postgresql_summary_code} = ${SUMMARY_CODE_MISSED}
}


Summary-Register @("activemq", "java", "tomcat", "postgresql")
Summary-Print


# SIG # Begin signature block
# MIIsvAYJKoZIhvcNAQcCoIIsrTCCLKkCAQExDzANBglghkgBZQMEAgEFADB5Bgor
# BgEEAYI3AgEEoGswaTA0BgorBgEEAYI3AgEeMCYCAwEAAAQQH8w7YFlLCE63JNLG
# KX7zUQIBAAIBAAIBAAIBAAIBADAxMA0GCWCGSAFlAwQCAQUABCABUf7by/kvEj4j
# 45kY/tMO/KzVh3CzOdV7cHsytx729qCCJj8wggWNMIIEdaADAgECAhAOmxiO+dAt
# 5+/bUOIIQBhaMA0GCSqGSIb3DQEBDAUAMGUxCzAJBgNVBAYTAlVTMRUwEwYDVQQK
# EwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xJDAiBgNV
# BAMTG0RpZ2lDZXJ0IEFzc3VyZWQgSUQgUm9vdCBDQTAeFw0yMjA4MDEwMDAwMDBa
# Fw0zMTExMDkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2Vy
# dCBJbmMxGTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lD
# ZXJ0IFRydXN0ZWQgUm9vdCBHNDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoC
# ggIBAL/mkHNo3rvkXUo8MCIwaTPswqclLskhPfKK2FnC4SmnPVirdprNrnsbhA3E
# MB/zG6Q4FutWxpdtHauyefLKEdLkX9YFPFIPUh/GnhWlfr6fqVcWWVVyr2iTcMKy
# unWZanMylNEQRBAu34LzB4TmdDttceItDBvuINXJIB1jKS3O7F5OyJP4IWGbNOsF
# xl7sWxq868nPzaw0QF+xembud8hIqGZXV59UWI4MK7dPpzDZVu7Ke13jrclPXuU1
# 5zHL2pNe3I6PgNq2kZhAkHnDeMe2scS1ahg4AxCN2NQ3pC4FfYj1gj4QkXCrVYJB
# MtfbBHMqbpEBfCFM1LyuGwN1XXhm2ToxRJozQL8I11pJpMLmqaBn3aQnvKFPObUR
# WBf3JFxGj2T3wWmIdph2PVldQnaHiZdpekjw4KISG2aadMreSx7nDmOu5tTvkpI6
# nj3cAORFJYm2mkQZK37AlLTSYW3rM9nF30sEAMx9HJXDj/chsrIRt7t/8tWMcCxB
# YKqxYxhElRp2Yn72gLD76GSmM9GJB+G9t+ZDpBi4pncB4Q+UDCEdslQpJYls5Q5S
# UUd0viastkF13nqsX40/ybzTQRESW+UQUOsxxcpyFiIJ33xMdT9j7CFfxCBRa2+x
# q4aLT8LWRV+dIPyhHsXAj6KxfgommfXkaS+YHS312amyHeUbAgMBAAGjggE6MIIB
# NjAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTs1+OC0nFdZEzfLmc/57qYrhwP
# TzAfBgNVHSMEGDAWgBRF66Kv9JLLgjEtUYunpyGd823IDzAOBgNVHQ8BAf8EBAMC
# AYYweQYIKwYBBQUHAQEEbTBrMCQGCCsGAQUFBzABhhhodHRwOi8vb2NzcC5kaWdp
# Y2VydC5jb20wQwYIKwYBBQUHMAKGN2h0dHA6Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNv
# bS9EaWdpQ2VydEFzc3VyZWRJRFJvb3RDQS5jcnQwRQYDVR0fBD4wPDA6oDigNoY0
# aHR0cDovL2NybDMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0QXNzdXJlZElEUm9vdENB
# LmNybDARBgNVHSAECjAIMAYGBFUdIAAwDQYJKoZIhvcNAQEMBQADggEBAHCgv0Nc
# Vec4X6CjdBs9thbX979XB72arKGHLOyFXqkauyL4hxppVCLtpIh3bb0aFPQTSnov
# Lbc47/T/gLn4offyct4kvFIDyE7QKt76LVbP+fT3rDB6mouyXtTP0UNEm0Mh65Zy
# oUi0mcudT6cGAxN3J0TU53/oWajwvy8LpunyNDzs9wPHh6jSTEAZNUZqaVSwuKFW
# juyk1T3osdz9HNj0d1pcVIxv76FQPfx2CWiEn2/K2yCNNWAcAgPLILCsWKAOQGPF
# mCLBsln1VWvPJ6tsds5vIy30fnFqI2si/xK4VC0nftg62fC2h5b9W9FcrBjDTZ9z
# twGpn1eqXijiuZQwggWQMIIDeKADAgECAhAFmxtXno4hMuI5B72nd3VcMA0GCSqG
# SIb3DQEBDAUAMGIxCzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMx
# GTAXBgNVBAsTEHd3dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRy
# dXN0ZWQgUm9vdCBHNDAeFw0xMzA4MDExMjAwMDBaFw0zODAxMTUxMjAwMDBaMGIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBH
# NDCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIBAL/mkHNo3rvkXUo8MCIw
# aTPswqclLskhPfKK2FnC4SmnPVirdprNrnsbhA3EMB/zG6Q4FutWxpdtHauyefLK
# EdLkX9YFPFIPUh/GnhWlfr6fqVcWWVVyr2iTcMKyunWZanMylNEQRBAu34LzB4Tm
# dDttceItDBvuINXJIB1jKS3O7F5OyJP4IWGbNOsFxl7sWxq868nPzaw0QF+xembu
# d8hIqGZXV59UWI4MK7dPpzDZVu7Ke13jrclPXuU15zHL2pNe3I6PgNq2kZhAkHnD
# eMe2scS1ahg4AxCN2NQ3pC4FfYj1gj4QkXCrVYJBMtfbBHMqbpEBfCFM1LyuGwN1
# XXhm2ToxRJozQL8I11pJpMLmqaBn3aQnvKFPObURWBf3JFxGj2T3wWmIdph2PVld
# QnaHiZdpekjw4KISG2aadMreSx7nDmOu5tTvkpI6nj3cAORFJYm2mkQZK37AlLTS
# YW3rM9nF30sEAMx9HJXDj/chsrIRt7t/8tWMcCxBYKqxYxhElRp2Yn72gLD76GSm
# M9GJB+G9t+ZDpBi4pncB4Q+UDCEdslQpJYls5Q5SUUd0viastkF13nqsX40/ybzT
# QRESW+UQUOsxxcpyFiIJ33xMdT9j7CFfxCBRa2+xq4aLT8LWRV+dIPyhHsXAj6Kx
# fgommfXkaS+YHS312amyHeUbAgMBAAGjQjBAMA8GA1UdEwEB/wQFMAMBAf8wDgYD
# VR0PAQH/BAQDAgGGMB0GA1UdDgQWBBTs1+OC0nFdZEzfLmc/57qYrhwPTzANBgkq
# hkiG9w0BAQwFAAOCAgEAu2HZfalsvhfEkRvDoaIAjeNkaA9Wz3eucPn9mkqZucl4
# XAwMX+TmFClWCzZJXURj4K2clhhmGyMNPXnpbWvWVPjSPMFDQK4dUPVS/JA7u5iZ
# aWvHwaeoaKQn3J35J64whbn2Z006Po9ZOSJTROvIXQPK7VB6fWIhCoDIc2bRoAVg
# X+iltKevqPdtNZx8WorWojiZ83iL9E3SIAveBO6Mm0eBcg3AFDLvMFkuruBx8lbk
# apdvklBtlo1oepqyNhR6BvIkuQkRUNcIsbiJeoQjYUIp5aPNoiBB19GcZNnqJqGL
# FNdMGbJQQXE9P01wI4YMStyB0swylIQNCAmXHE/A7msgdDDS4Dk0EIUhFQEI6FUy
# 3nFJ2SgXUE3mvk3RdazQyvtBuEOlqtPDBURPLDab4vriRbgjU2wGb2dVf0a1TD9u
# KFp5JtKkqGKX0h7i7UqLvBv9R0oN32dmfrJbQdA75PQ79ARj6e/CVABRoIoqyc54
# zNXqhwQYs86vSYiv85KZtrPmYQ/ShQDnUBrkG5WdGaG5nLGbsQAe79APT0JsyQq8
# 7kP6OnGlyE0mpTX9iV28hWIdMtKgK1TtmlfB2/oQzxm3i0objwG2J5VT6LaJbVu8
# aNQj6ItRolb58KaAoNYes7wPD1N1KarqE3fk3oyBIa0HEEcRrYc9B9F1vM/zZn4w
# ggauMIIElqADAgECAhAHNje3JFR82Ees/ShmKl5bMA0GCSqGSIb3DQEBCwUAMGIx
# CzAJBgNVBAYTAlVTMRUwEwYDVQQKEwxEaWdpQ2VydCBJbmMxGTAXBgNVBAsTEHd3
# dy5kaWdpY2VydC5jb20xITAfBgNVBAMTGERpZ2lDZXJ0IFRydXN0ZWQgUm9vdCBH
# NDAeFw0yMjAzMjMwMDAwMDBaFw0zNzAzMjIyMzU5NTlaMGMxCzAJBgNVBAYTAlVT
# MRcwFQYDVQQKEw5EaWdpQ2VydCwgSW5jLjE7MDkGA1UEAxMyRGlnaUNlcnQgVHJ1
# c3RlZCBHNCBSU0E0MDk2IFNIQTI1NiBUaW1lU3RhbXBpbmcgQ0EwggIiMA0GCSqG
# SIb3DQEBAQUAA4ICDwAwggIKAoICAQDGhjUGSbPBPXJJUVXHJQPE8pE3qZdRodbS
# g9GeTKJtoLDMg/la9hGhRBVCX6SI82j6ffOciQt/nR+eDzMfUBMLJnOWbfhXqAJ9
# /UO0hNoR8XOxs+4rgISKIhjf69o9xBd/qxkrPkLcZ47qUT3w1lbU5ygt69OxtXXn
# HwZljZQp09nsad/ZkIdGAHvbREGJ3HxqV3rwN3mfXazL6IRktFLydkf3YYMZ3V+0
# VAshaG43IbtArF+y3kp9zvU5EmfvDqVjbOSmxR3NNg1c1eYbqMFkdECnwHLFuk4f
# sbVYTXn+149zk6wsOeKlSNbwsDETqVcplicu9Yemj052FVUmcJgmf6AaRyBD40Nj
# gHt1biclkJg6OBGz9vae5jtb7IHeIhTZgirHkr+g3uM+onP65x9abJTyUpURK1h0
# QCirc0PO30qhHGs4xSnzyqqWc0Jon7ZGs506o9UD4L/wojzKQtwYSH8UNM/STKvv
# mz3+DrhkKvp1KCRB7UK/BZxmSVJQ9FHzNklNiyDSLFc1eSuo80VgvCONWPfcYd6T
# /jnA+bIwpUzX6ZhKWD7TA4j+s4/TXkt2ElGTyYwMO1uKIqjBJgj5FBASA31fI7tk
# 42PgpuE+9sJ0sj8eCXbsq11GdeJgo1gJASgADoRU7s7pXcheMBK9Rp6103a50g5r
# mQzSM7TNsQIDAQABo4IBXTCCAVkwEgYDVR0TAQH/BAgwBgEB/wIBADAdBgNVHQ4E
# FgQUuhbZbU2FL3MpdpovdYxqII+eyG8wHwYDVR0jBBgwFoAU7NfjgtJxXWRM3y5n
# P+e6mK4cD08wDgYDVR0PAQH/BAQDAgGGMBMGA1UdJQQMMAoGCCsGAQUFBwMIMHcG
# CCsGAQUFBwEBBGswaTAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGlnaWNlcnQu
# Y29tMEEGCCsGAQUFBzAChjVodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5jb20vRGln
# aUNlcnRUcnVzdGVkUm9vdEc0LmNydDBDBgNVHR8EPDA6MDigNqA0hjJodHRwOi8v
# Y3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRUcnVzdGVkUm9vdEc0LmNybDAgBgNV
# HSAEGTAXMAgGBmeBDAEEAjALBglghkgBhv1sBwEwDQYJKoZIhvcNAQELBQADggIB
# AH1ZjsCTtm+YqUQiAX5m1tghQuGwGC4QTRPPMFPOvxj7x1Bd4ksp+3CKDaopafxp
# wc8dB+k+YMjYC+VcW9dth/qEICU0MWfNthKWb8RQTGIdDAiCqBa9qVbPFXONASIl
# zpVpP0d3+3J0FNf/q0+KLHqrhc1DX+1gtqpPkWaeLJ7giqzl/Yy8ZCaHbJK9nXzQ
# cAp876i8dU+6WvepELJd6f8oVInw1YpxdmXazPByoyP6wCeCRK6ZJxurJB4mwbfe
# Kuv2nrF5mYGjVoarCkXJ38SNoOeY+/umnXKvxMfBwWpx2cYTgAnEtp/Nh4cku0+j
# Sbl3ZpHxcpzpSwJSpzd+k1OsOx0ISQ+UzTl63f8lY5knLD0/a6fxZsNBzU+2QJsh
# IUDQtxMkzdwdeDrknq3lNHGS1yZr5Dhzq6YBT70/O3itTK37xJV77QpfMzmHQXh6
# OOmc4d0j/R0o08f56PGYX/sr2H7yRp11LB4nLCbbbxV7HhmLNriT1ObyF5lZynDw
# N7+YAN8gFk8n+2BnFqFmut1VwDophrCYoCvtlUG3OtUVmDG0YgkPCr2B2RP+v6TR
# 81fZvAT6gt4y3wSJ8ADNXcL50CN/AAvkdgIm2fBldkKmKYcJRyvmfxqkhQ/8mJb2
# VVQrH4D6wPIOK+XW+6kvRBVK5xMOHds3OBqhK/bt1nz8MIIGsDCCBJigAwIBAgIQ
# CK1AsmDSnEyfXs2pvZOu2TANBgkqhkiG9w0BAQwFADBiMQswCQYDVQQGEwJVUzEV
# MBMGA1UEChMMRGlnaUNlcnQgSW5jMRkwFwYDVQQLExB3d3cuZGlnaWNlcnQuY29t
# MSEwHwYDVQQDExhEaWdpQ2VydCBUcnVzdGVkIFJvb3QgRzQwHhcNMjEwNDI5MDAw
# MDAwWhcNMzYwNDI4MjM1OTU5WjBpMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGln
# aUNlcnQsIEluYy4xQTA/BgNVBAMTOERpZ2lDZXJ0IFRydXN0ZWQgRzQgQ29kZSBT
# aWduaW5nIFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMIICIjANBgkqhkiG9w0BAQEF
# AAOCAg8AMIICCgKCAgEA1bQvQtAorXi3XdU5WRuxiEL1M4zrPYGXcMW7xIUmMJ+k
# jmjYXPXrNCQH4UtP03hD9BfXHtr50tVnGlJPDqFX/IiZwZHMgQM+TXAkZLON4gh9
# NH1MgFcSa0OamfLFOx/y78tHWhOmTLMBICXzENOLsvsI8IrgnQnAZaf6mIBJNYc9
# URnokCF4RS6hnyzhGMIazMXuk0lwQjKP+8bqHPNlaJGiTUyCEUhSaN4QvRRXXegY
# E2XFf7JPhSxIpFaENdb5LpyqABXRN/4aBpTCfMjqGzLmysL0p6MDDnSlrzm2q2AS
# 4+jWufcx4dyt5Big2MEjR0ezoQ9uo6ttmAaDG7dqZy3SvUQakhCBj7A7CdfHmzJa
# wv9qYFSLScGT7eG0XOBv6yb5jNWy+TgQ5urOkfW+0/tvk2E0XLyTRSiDNipmKF+w
# c86LJiUGsoPUXPYVGUztYuBeM/Lo6OwKp7ADK5GyNnm+960IHnWmZcy740hQ83eR
# Gv7bUKJGyGFYmPV8AhY8gyitOYbs1LcNU9D4R+Z1MI3sMJN2FKZbS110YU0/EpF2
# 3r9Yy3IQKUHw1cVtJnZoEUETWJrcJisB9IlNWdt4z4FKPkBHX8mBUHOFECMhWWCK
# ZFTBzCEa6DgZfGYczXg4RTCZT/9jT0y7qg0IU0F8WD1Hs/q27IwyCQLMbDwMVhEC
# AwEAAaOCAVkwggFVMBIGA1UdEwEB/wQIMAYBAf8CAQAwHQYDVR0OBBYEFGg34Ou2
# O/hfEYb7/mF7CIhl9E5CMB8GA1UdIwQYMBaAFOzX44LScV1kTN8uZz/nupiuHA9P
# MA4GA1UdDwEB/wQEAwIBhjATBgNVHSUEDDAKBggrBgEFBQcDAzB3BggrBgEFBQcB
# AQRrMGkwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBBBggr
# BgEFBQcwAoY1aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1
# c3RlZFJvb3RHNC5jcnQwQwYDVR0fBDwwOjA4oDagNIYyaHR0cDovL2NybDMuZGln
# aWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZFJvb3RHNC5jcmwwHAYDVR0gBBUwEzAH
# BgVngQwBAzAIBgZngQwBBAEwDQYJKoZIhvcNAQEMBQADggIBADojRD2NCHbuj7w6
# mdNW4AIapfhINPMstuZ0ZveUcrEAyq9sMCcTEp6QRJ9L/Z6jfCbVN7w6XUhtldU/
# SfQnuxaBRVD9nL22heB2fjdxyyL3WqqQz/WTauPrINHVUHmImoqKwba9oUgYftzY
# gBoRGRjNYZmBVvbJ43bnxOQbX0P4PpT/djk9ntSZz0rdKOtfJqGVWEjVGv7XJz/9
# kNF2ht0csGBc8w2o7uCJob054ThO2m67Np375SFTWsPK6Wrxoj7bQ7gzyE84FJKZ
# 9d3OVG3ZXQIUH0AzfAPilbLCIXVzUstG2MQ0HKKlS43Nb3Y3LIU/Gs4m6Ri+kAew
# Q3+ViCCCcPDMyu/9KTVcH4k4Vfc3iosJocsL6TEa/y4ZXDlx4b6cpwoG1iZnt5Lm
# Tl/eeqxJzy6kdJKt2zyknIYf48FWGysj/4+16oh7cGvmoLr9Oj9FpsToFpFSi0HA
# SIRLlk2rREDjjfAVKM7t8RhWByovEMQMCGQ8M4+uKIw8y4+ICw2/O/TOHnuO77Xr
# y7fwdxPm5yg/rBKupS8ibEH5glwVZsxsDsrFhsP2JjMMB0ug0wcCampAMEhLNKhR
# ILutG4UI4lkNbcoFUCvqShyepf2gpx8GdOfy1lKQ/a+FSCH5Vzu0nAPthkX0tGFu
# v2jiJmCG6sivqf6UHedjGzqGVnhOMIIGwjCCBKqgAwIBAgIQBUSv85SdCDmmv9s/
# X+VhFjANBgkqhkiG9w0BAQsFADBjMQswCQYDVQQGEwJVUzEXMBUGA1UEChMORGln
# aUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQgRzQgUlNBNDA5
# NiBTSEEyNTYgVGltZVN0YW1waW5nIENBMB4XDTIzMDcxNDAwMDAwMFoXDTM0MTAx
# MzIzNTk1OVowSDELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMu
# MSAwHgYDVQQDExdEaWdpQ2VydCBUaW1lc3RhbXAgMjAyMzCCAiIwDQYJKoZIhvcN
# AQEBBQADggIPADCCAgoCggIBAKNTRYcdg45brD5UsyPgz5/X5dLnXaEOCdwvSKOX
# ejsqnGfcYhVYwamTEafNqrJq3RApih5iY2nTWJw1cb86l+uUUI8cIOrHmjsvlmbj
# aedp/lvD1isgHMGXlLSlUIHyz8sHpjBoyoNC2vx/CSSUpIIa2mq62DvKXd4ZGIX7
# ReoNYWyd/nFexAaaPPDFLnkPG2ZS48jWPl/aQ9OE9dDH9kgtXkV1lnX+3RChG4PB
# uOZSlbVH13gpOWvgeFmX40QrStWVzu8IF+qCZE3/I+PKhu60pCFkcOvV5aDaY7Mu
# 6QXuqvYk9R28mxyyt1/f8O52fTGZZUdVnUokL6wrl76f5P17cz4y7lI0+9S769Sg
# LDSb495uZBkHNwGRDxy1Uc2qTGaDiGhiu7xBG3gZbeTZD+BYQfvYsSzhUa+0rRUG
# FOpiCBPTaR58ZE2dD9/O0V6MqqtQFcmzyrzXxDtoRKOlO0L9c33u3Qr/eTQQfqZc
# ClhMAD6FaXXHg2TWdc2PEnZWpST618RrIbroHzSYLzrqawGw9/sqhux7UjipmAmh
# cbJsca8+uG+W1eEQE/5hRwqM/vC2x9XH3mwk8L9CgsqgcT2ckpMEtGlwJw1Pt7U2
# 0clfCKRwo+wK8REuZODLIivK8SgTIUlRfgZm0zu++uuRONhRB8qUt+JQofM604qD
# y0B7AgMBAAGjggGLMIIBhzAOBgNVHQ8BAf8EBAMCB4AwDAYDVR0TAQH/BAIwADAW
# BgNVHSUBAf8EDDAKBggrBgEFBQcDCDAgBgNVHSAEGTAXMAgGBmeBDAEEAjALBglg
# hkgBhv1sBwEwHwYDVR0jBBgwFoAUuhbZbU2FL3MpdpovdYxqII+eyG8wHQYDVR0O
# BBYEFKW27xPn783QZKHVVqllMaPe1eNJMFoGA1UdHwRTMFEwT6BNoEuGSWh0dHA6
# Ly9jcmwzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZTSEEy
# NTZUaW1lU3RhbXBpbmdDQS5jcmwwgZAGCCsGAQUFBwEBBIGDMIGAMCQGCCsGAQUF
# BzABhhhodHRwOi8vb2NzcC5kaWdpY2VydC5jb20wWAYIKwYBBQUHMAKGTGh0dHA6
# Ly9jYWNlcnRzLmRpZ2ljZXJ0LmNvbS9EaWdpQ2VydFRydXN0ZWRHNFJTQTQwOTZT
# SEEyNTZUaW1lU3RhbXBpbmdDQS5jcnQwDQYJKoZIhvcNAQELBQADggIBAIEa1t6g
# qbWYF7xwjU+KPGic2CX/yyzkzepdIpLsjCICqbjPgKjZ5+PF7SaCinEvGN1Ott5s
# 1+FgnCvt7T1IjrhrunxdvcJhN2hJd6PrkKoS1yeF844ektrCQDifXcigLiV4JZ0q
# BXqEKZi2V3mP2yZWK7Dzp703DNiYdk9WuVLCtp04qYHnbUFcjGnRuSvExnvPnPp4
# 4pMadqJpddNQ5EQSviANnqlE0PjlSXcIWiHFtM+YlRpUurm8wWkZus8W8oM3NG6w
# QSbd3lqXTzON1I13fXVFoaVYJmoDRd7ZULVQjK9WvUzF4UbFKNOt50MAcN7MmJ4Z
# iQPq1JE3701S88lgIcRWR+3aEUuMMsOI5ljitts++V+wQtaP4xeR0arAVeOGv6wn
# LEHQmjNKqDbUuXKWfpd5OEhfysLcPTLfddY2Z1qJ+Panx+VPNTwAvb6cKmx5Adza
# ROY63jg7B145WPR8czFVoIARyxQMfq68/qTreWWqaNYiyjvrmoI1VygWy2nyMpqy
# 0tg6uLFGhmu6F/3Ed2wVbK6rr3M66ElGt9V/zLY4wNjsHPW2obhDLN9OTH0eaHDA
# dwrUAuBcYLso/zjlUlrWrBciI0707NMX+1Br/wd3H3GXREHJuEbTbDJ8WC9nR2Xl
# G3O2mflrLAZG70Ee8PBf4NvZrZCARK+AEEGKMIIG6jCCBNKgAwIBAgIQBKbQDKbn
# vxPWBgHfq1yGCTANBgkqhkiG9w0BAQsFADBpMQswCQYDVQQGEwJVUzEXMBUGA1UE
# ChMORGlnaUNlcnQsIEluYy4xQTA/BgNVBAMTOERpZ2lDZXJ0IFRydXN0ZWQgRzQg
# Q29kZSBTaWduaW5nIFJTQTQwOTYgU0hBMzg0IDIwMjEgQ0ExMB4XDTIxMDYwODAw
# MDAwMFoXDTI0MDgzMDIzNTk1OVowbzELMAkGA1UEBhMCR0IxEDAOBgNVBAcTB05F
# V0JVUlkxJjAkBgNVBAoTHU1pY3JvIEZvY3VzIEludGVybmF0aW9uYWwgcGxjMSYw
# JAYDVQQDEx1NaWNybyBGb2N1cyBJbnRlcm5hdGlvbmFsIHBsYzCCAaIwDQYJKoZI
# hvcNAQEBBQADggGPADCCAYoCggGBAOoiQYhGCwyc+fGmIadVulPc2GZ9lCYQxC9K
# 1vSQ3pqs+3huyMrjKp2tXRU4HmwpY2w3tdvYr7Zpbj3wbKPR67IBp0IFvz0KNAYt
# 7AebJHbdPOqZvS01XV5ofNq59ABKvQOAcuAdmUadYLdVRYcfdMDX4D2i0WSuheIS
# NkZW3WrpBDYeRryJ2HwhoSQXbhHGtfihGEQHtz+KLpjSxJ/ntj60epd1i6a4Q2Ro
# Djgtrv0Ee4xq/ATZ9a6ukTuWB+V/WedvInFpD5etSBKqLhC93pnCPoO+jmlQkC6q
# qHApjAfSfsECnEUqVmr/DpR1LU1MyiGbHKog3LED7h0pCKUpQdeJc/R34ZRKtEW1
# e01TdMqCk7YsUZlKWz+Xbl6ZzYidPaYdPtKQaSXAPzuIzbys9LoKd5U2VBxCylLL
# vZgJEQlYhXUlu/vEBek6XzBuBUH4DZObmVIbkVS7v2sT6fXik6ibhU4PPEDdq0yG
# bjSHfze1LpXc8fIriotRukuSRIMv8QIDAQABo4ICBjCCAgIwHwYDVR0jBBgwFoAU
# aDfg67Y7+F8Rhvv+YXsIiGX0TkIwHQYDVR0OBBYEFIboW+tVaDsOcwhEgehx7b3u
# JpoxMA4GA1UdDwEB/wQEAwIHgDATBgNVHSUEDDAKBggrBgEFBQcDAzCBtQYDVR0f
# BIGtMIGqMFOgUaBPhk1odHRwOi8vY3JsMy5kaWdpY2VydC5jb20vRGlnaUNlcnRU
# cnVzdGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIxQ0ExLmNybDBToFGg
# T4ZNaHR0cDovL2NybDQuZGlnaWNlcnQuY29tL0RpZ2lDZXJ0VHJ1c3RlZEc0Q29k
# ZVNpZ25pbmdSU0E0MDk2U0hBMzg0MjAyMUNBMS5jcmwwPgYDVR0gBDcwNTAzBgZn
# gQwBBAEwKTAnBggrBgEFBQcCARYbaHR0cDovL3d3dy5kaWdpY2VydC5jb20vQ1BT
# MIGUBggrBgEFBQcBAQSBhzCBhDAkBggrBgEFBQcwAYYYaHR0cDovL29jc3AuZGln
# aWNlcnQuY29tMFwGCCsGAQUFBzAChlBodHRwOi8vY2FjZXJ0cy5kaWdpY2VydC5j
# b20vRGlnaUNlcnRUcnVzdGVkRzRDb2RlU2lnbmluZ1JTQTQwOTZTSEEzODQyMDIx
# Q0ExLmNydDAMBgNVHRMBAf8EAjAAMA0GCSqGSIb3DQEBCwUAA4ICAQBdyv7VGFvF
# 12qOAQ3bV8ae6galTCD2mxwlzEfc+6cmh/5h/h9N8f6THKy97LsrDN+wWA4AaVfL
# 4o0Pk/lZI4FXYFC5ljqwoFIA2CqcqVi2fpnWSlDcNSu+WLIrcD9StY75xkEPvgnV
# sMbLyIhQvlMwMpQh/MnMREQ40I/3nXZDVksjoRa3frEQYQLr8wEmHoS86l/tJ4R0
# P/cmK63nGMb8uc1LgREopxlCjf/NaNK8z2BjD8iJ7E0B1pGyr5viRM0/+I+OjAru
# bsmWUcYPkibX7pQ1c1shDfpu4fo3eqSz2nIMPEnKOeJrxSvi5tXfY8mIfO4uo43K
# Dg+9SZgWTLe4T2P1/jERijc3SpiF9QOYpDjktQPBla4CcF6b5HAi/ffs35T7wCNq
# mlA9hDrb+6djoCHkKaCQbbWklPujN/SxR2jpfkrEX0QuwZ76dZ9RYh9aNFeSLw4r
# qH6Lf2Bd2JjYTpw1zKN+FB6x44dZqWmVzFSrxxnzxxS1ptuwwyzL6dRpDO003y0O
# bQV2sCoUb3jeE37ifqOOfqeSrsIqueFCwlHtCnLjKM6KTR8iykYvoXop8UeADEJY
# Yyi8tqt3SbCKBF4fTEjLq82CUbpjjlEqVoN8pXyoFZyt9QoXE5bsygERRyPn07Mg
# fMhL3Zj6/nYG8FzyJe9YyjHD7smoGhwl9DGCBdMwggXPAgEBMH0waTELMAkGA1UE
# BhMCVVMxFzAVBgNVBAoTDkRpZ2lDZXJ0LCBJbmMuMUEwPwYDVQQDEzhEaWdpQ2Vy
# dCBUcnVzdGVkIEc0IENvZGUgU2lnbmluZyBSU0E0MDk2IFNIQTM4NCAyMDIxIENB
# MQIQBKbQDKbnvxPWBgHfq1yGCTANBglghkgBZQMEAgEFAKCBhDAYBgorBgEEAYI3
# AgEMMQowCKACgAChAoAAMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3AgEEMBwGCisG
# AQQBgjcCAQsxDjAMBgorBgEEAYI3AgEVMC8GCSqGSIb3DQEJBDEiBCD/Y2zbwPtQ
# 2kTRCk/dXIs0hh9hdFQeTRx55R/VF/bN/zANBgkqhkiG9w0BAQEFAASCAYA7qdGZ
# G7+s7dXRsTap0vUPXHu8Wnyw62QYpIM2IQF2wpmfYQko64hlYD2uheLhliwgdncj
# v0SsLzza0PyP3Mdl5h1mACNUMZxJBQa11uoN5L7TIevuBB6ujFzJZRGWBvP6a2rS
# ts7pWaZ7e6MnRaJbJKSKYCp6HMqL5pxpZi7f61lEG/Lu4bAIDSaLvK4t7a0B4a9l
# Fefqq4SGiwWql/W1oyBjpT8l1mcNj0PEEWuVMAtj0OwXJ+dFI4vYYE0BNvO9UEEE
# 78DPTkN/MRpdfba0Vj7gZBDedVvwnIhvbkXJvU1kX2zXWehROFqGezbszvXD+0+c
# fx5ppqqZvgZ3yZpwOJ3Szy1jSmQVi8SRiAB2pF5li9K6G1kj6m66M2mdtviEn0vG
# UXulHb5JsgJDDnpLbo9sFDq/rhuLLBEWrGS8apN1znsgv3pAiQzWckJQfbj2ZPjL
# +zE/F8vFO05M38zZpovWbx0rRV6e0koBFX5iJjvVO2fz3qL788FafeBcRBGhggMg
# MIIDHAYJKoZIhvcNAQkGMYIDDTCCAwkCAQEwdzBjMQswCQYDVQQGEwJVUzEXMBUG
# A1UEChMORGlnaUNlcnQsIEluYy4xOzA5BgNVBAMTMkRpZ2lDZXJ0IFRydXN0ZWQg
# RzQgUlNBNDA5NiBTSEEyNTYgVGltZVN0YW1waW5nIENBAhAFRK/zlJ0IOaa/2z9f
# 5WEWMA0GCWCGSAFlAwQCAQUAoGkwGAYJKoZIhvcNAQkDMQsGCSqGSIb3DQEHATAc
# BgkqhkiG9w0BCQUxDxcNMjQwMTA1MTM0OTQ1WjAvBgkqhkiG9w0BCQQxIgQgkSAa
# dhfH3Uk90dBYTa9PHiMcRrhZnnyF5xqggMFuQcAwDQYJKoZIhvcNAQEBBQAEggIA
# lFDQH8eWRkGDQxOhPgYpbc/0tbQpBRDBprFpBrAPBulz0TWMRk3zSsWfwew98XkU
# tpyvhIdTt8Au/2Vz61PEICHOhklXuItxB3wsn9dNXRLZO9S4v4p6SJJ/Izjsk8b2
# miuJZpwYvQeqoiOmX1GaLBpB7bnKF+uNRrYnDTlicLejCAh/GIXrthO4dqJ7NMEz
# cxJtA7vYLv3k+tOirrOwbJkz/opDeIA826/CBv9CnrdC6aEyvpSSTGVxxYLmNKj+
# 06Gfvfkh7b76oWL6tbZ0MSg8aOZ9OFiTSFrlsIt525JpOmDK7MfYqybT+sX2d92Y
# etvhaJmtOf5HNc1r1kMTf1LZ1/rpWQzAFypP0O0XcI57X357geBN9PdbU6l5KNWc
# g9kfPBN+VhD3eu1yAaAwV+8eT8P4gIQrY9pU98fXWdsIn1UQsEzdDU4CEv12b9Qk
# /iGe+5qud32afIJQJE8KtFujfmZr/EtVkHHALctUaETOFBOq+j02GIZz6MraTMxR
# QTJQ/sqZY6ogugB1NgsxBn80HlPKlFYAE+0HKiwLYP6Ph5iDQE3F2Q0qUWgf9Zg6
# 5YWYGUU/Of+CdvDQMdwWco0M0u182LNeSw1MNGYwIHywnAxqmC2dZUhKDo3cSPQq
# P92mGcu4eQHRBrRmaWGCGST6I/ihU0SJv0gFd+IK7rY=
# SIG # End signature block
