# Component Upgrade Helper Scripts

## Introduction

We are providing an example component upgrade helper scripts that can
be used to help update some of the system requirements on your Linux server.

## Component Versions

These scripts have been created to utilize variables, which allow for easy modification when necessary.
For Linux, the archive files for ActiveMQ, OpenJDK, and Tomcat must be tar.gz.

Refer to the System Requirements for Identity Governance 4.2 for the required versions of
Apache ActiveMQ, Apache Tomcat, Zulu OpenJDK from Azul, and the database server
(Microsoft SQL Server, Oracle, or PostgreSQL)

# Setup

Steps to utilize the Linux Component Upgrade helper script.

1. Extract the zip to the Linux Server that you are going to install on.

2. a. You should have the following for Linux:
   - %base%/linux
   - %base%/linux/compressed
   - %base%/linux/def_copies_3_0.sh
   - %base%/linux/def_copies_3_6.sh
   - %base%/linux/def_copies_3_7.sh
   - %base%/linux/def_copies_4_2.sh
   - %base%/linux/def_copies_4_3.sh
   - %base%/linux/def_copies.sh
   - %base%/linux/def_upgrade.sh
   - %base%/linux/README.md
   - %base%/linux/Sample_code_EULA.txt
   - %base%/linux/upgrade.sh
   - %base%/linux/versions.sh


   b. Put the necessary `tar.gz` files in the compressed folder.
   For Example:
   - apache-activemq-5.17.6-bin.tar.gz
   - apache-tomcat-9.0.91.tar.gz
   - zulu11.74.15-ca-jdk11.0.24-linux_x64.tar.gz

3. a. Open the `def_copies_4_2.sh` script.

   b. Confirm the version numbers match what you have downloaded. If they do not then you will need to update the script.

   c. Save and close the file.

# Checking Installed Versions Against Expected Versions

1. Open a Terminal and switch to `root` (if you are not already), navigate to the %base%/linux directory, and then run the script: `./versions.sh`

2. Provide the requested input when prompted.

# Upgrading Components

1. Open a Terminal and switch to `root` (if you are not already), navigate to the %base%/linux directory, and then run the script: `./upgrade.sh`

2. Provide the requested input when prompted.

