#/bin/bash

source ${0%/*}/def_upgrade.sh

# Assume default value first; modify as user provides input
active_mq_loc_final="${ACTIVE_MQ_DEFAULT}"
java_loc_final="${JAVA_DEFAULT}"
postgresql_bin_loc_final="${POSTGRESQL_PATH_DEFAULT_BIN}"
tomcat_loc_final="${TOMCAT_DEFAULT}"

echo -n "Do you want to compare Tomcat versions? [Y/n]: "
read do_please
if [ -z "${do_please}" ] || [ "${do_please}" == "y" ] || [ "${do_please}" == "Y" ]; then
  # We need a valid location to proceed
  input_invalid="true"
  while [ "${input_invalid}" == "true" ]; do
    # Ask user for the location, using default if nothing entered
    echo -n "Where is your Tomcat located? [${tomcat_loc_final}]: "
    read tomcat_loc
    if [ -n "${tomcat_loc}" ]; then tomcat_loc_final="${tomcat_loc}"; fi

    getPathValidity "${tomcat_loc_final}" "${TOMCAT_VALIDITY[@]}"
    if [ "$?" == "${VALIDITY_CODE_GOOD}" ]; then
      # Path is valid; we can proceed
      input_invalid="false"
      tomcat_version_output="$( ${tomcat_loc_final}/bin/version.sh )"
      tomcat_version_exist="$( echo "${tomcat_version_output}" | grep "Server number:" | trimInput | sed "s|Server number:\s*||g" )"
      compareVersionsAndPrompt "Tomcat" ${tomcat_version_exist} ${TOMCAT_VERSION_TARGET}

      java_loc_final="$( echo "${tomcat_version_output}" | grep "Using JRE_HOME:" | trimInput | sed "s|Using JRE_HOME:\s*||g" )"
      if [ -n "${java_loc_final}" ]; then
        ALREADY_OBTAINED_JAVA_LOC="true"
        echo "  Tomcat is using Java located at \"${java_loc_final}\""
      fi
    fi
  done
fi


echo -n "Do you want to compare ActiveMQ versions? [y/N]: "
read do_please
if [ "${do_please}" == "y" ] || [ "${do_please}" == "Y" ]; then
  # We need a valid location to proceed
  input_invalid="true"
  while [ "${input_invalid}" == "true" ]; do
    # Ask user for the location, using default if nothing entered
    echo -n "Where is your ActiveMQ located? [${active_mq_loc_final}]: "
    read active_mq_loc
    if [ -n "${active_mq_loc}" ]; then active_mq_loc_final="${active_mq_loc}"; fi

    getPathValidity "${active_mq_loc_final}" "${ACTIVE_MQ_VALIDITY[@]}"
    if [ "$?" == "${VALIDITY_CODE_GOOD}" ]; then
      # Path is valid; we can proceed
      input_invalid="false"
      # Ensure ActiveMQ knows where to find JAVA_HOME
      java_home_loc_activemq="$( cat ${active_mq_loc_final}/bin/env | grep "^JAVA_HOME=\"" | sed "s|JAVA_HOME=\"||g" | sed "s|\"||g" )"
      if [ -n "${java_home_loc_activemq}" ]; then
        echo "  ActiveMQ is using Java located at \"${java_home_loc_activemq}\""
        if [ "${ALREADY_OBTAINED_JAVA_LOC}" == "false" ]; then
          ALREADY_OBTAINED_JAVA_LOC="true"
          java_loc_final="${java_home_loc_activemq}"
        fi
      else
        get_valid_java_path
        export JAVA_HOME="${java_loc_final}"
      fi
      active_mq_version_output="$( ${active_mq_loc_final}/bin/activemq --version )"
      active_mq_version_exist="$( echo "${active_mq_version_output}" | grep "ActiveMQ " | trimInput | sed "s|ActiveMQ\s*||g" )"
      compareVersionsAndPrompt "ActiveMQ" ${active_mq_version_exist} ${ACTIVE_MQ_VERSION_TARGET}
    fi
  done
fi


echo -n "Do you want to compare Java versions? [Y/n]: "
read do_please
if [ -z "${do_please}" ] || [ "${do_please}" == "y" ] || [ "${do_please}" == "Y" ]; then
  if [ "${ALREADY_OBTAINED_JAVA_LOC}" == "false" ]; then
    get_valid_java_path
  fi
  java_version_exist="$( ${java_loc_final}/bin/java -version 2>&1 | grep "^.*\sversion" | trimInput | sed "s|^.*\sversion \"||g" | sed 's/"//g' | sed "s/ .*//g")"
  compareVersionsAndPrompt "Java" ${java_version_exist} ${JAVA_VERSION_TARGET}
fi


echo -n "Do you want to compare PostgreSQL versions? [y/N]: "
read do_please
if [ "${do_please}" == "y" ] || [ "${do_please}" == "Y" ]; then
  # We need a valid location to proceed
  input_invalid="true"
  while [ "${input_invalid}" == "true" ]; do
    # Ask user for the location, using default if nothing entered
    echo -n "Where is your PostgreSQL bin located? [${postgresql_bin_loc_final}]: "
    read postgresql_loc
    if [ -n "${postgresql_loc}" ]; then postgresql_bin_loc_final="${postgresql_loc}"; fi

    getPathValidity "${postgresql_bin_loc_final}" "${POSTGRESQL_VALIDITY_BIN[@]}"
    if [ "$?" == "${VALIDITY_CODE_GOOD}" ]; then
      # Path is valid; we can proceed
      input_invalid="false"
      postgresql_version_output="$( ${postgresql_bin_loc_final}/psql --version )"
      postgresql_version_exist="$( echo "${postgresql_version_output}" | grep "psql (PostgreSQL)" | trimInput | sed "s|psql (PostgreSQL)\s*||g" )"
      compareVersionsAndPrompt "PostgreSQL" ${postgresql_version_exist} ${POSTGRESQL_VERSION_TARGET}
    fi
  done
fi

