define({"0":{i:0.00351704730430442,u:"../Content/Tutorial/Introduction.htm",a:"Connectors provide the connection between IDOL and the repositories that your organization uses for storing and organizing information. You can use connectors to keep your IDOL index up-to-date with the information in a repository (using the synchronize fetch action) and to retrieve files, or lists ...",t:"Introduction"},"1":{i:0.000527569802810135,u:"../Content/ConnectorLib_Tutorial.htm",a:"ConnectorLib .NET Tutorial This section shows how to use the ConnectorLib .NET SDK to build a connector.",t:"ConnectorLib .NET Tutorial"},"2":{i:0.00125253966963246,u:"../Content/Tutorial/Implement.htm",a:"Implement a New Connector This section describes how to implement a new connector.",t:"Implement a New Connector"},"3":{i:0.000527569802810135,u:"../Content/Tutorial/Create_the_Visual_Studio.htm",a:"To create a new connector using Visual Studio, create a new solution containing a class library project. The class library will contain the code for your connector. Next, select the project and add a reference to DotNetConnector.dll. You are now ready to start writing the connector.",t:"Create the Visual Studio Solution"},"4":{i:0.000527569802810135,u:"../Content/Tutorial/Extend_ConnectorBase.htm",a:"To create a new connector you must create a class that extends the Autonomy.Connector.ConnectorBase class. For example: \nusing System;\nusing Autonomy.Connector;\n\nnamespace MyConnectorNamespace\n{\n\tpublic class MyConnector : ConnectorBase\n\t{\n\t\tpublic MyConnector(IConfig config, ILog log) :\n\t\t    ...",t:"Extend ConnectorBase"},"5":{i:0.00142443950940653,u:"../Content/Tutorial/RunConnector/Run_Introduction.htm",a:"Run the Connector This section describes how to run a new connector.",t:"Run the Connector"},"6":{i:0.000677048087242869,u:"../Content/Tutorial/RunConnector/Required_Files.htm",a:"To run the connector, you must place the following files in a directory (from now on called the connector directory). All of the files, except your connector  DLL , are provided with the SDK. Your connector  DLL , and any dependencies connectorLibDotNet.cfg connectorLibDotNet.exe DotNetConnector.dll ...",t:"Required Files"},"7":{i:0.000677048087242869,u:"../Content/Tutorial/RunConnector/Configure.htm",a:"Before running the connector you must modify  connectorLibDotNet.cfg . In the [Connector] section of the configuration file, set the following parameters. These parameters tell ConnectorLib .NET how to locate your connector implementation: DotNetConnectorLibrary The path to your connector DLL. ...",t:"Configure the Connector"},"8":{i:0.000527569802810135,u:"../Content/Tutorial/RunConnector/RunConnector.htm",a:"After you have collected the  required files  and  configured the connector , you can run the connector by starting  connectorLibDotNet.exe . View Log Messages Any log messages produced by your connector implementation appear in the appropriate log file.  For example, in the HelloWorld connector ...",t:"Run the Connector"},"9":{i:0.000527569802810135,u:"../Content/Tutorial/RunConnector/Troubleshooting.htm",a:"If you run the connector and find that it stops immediately, check the logs to see if any errors occurred at the time you tried to start it. You can also try running the connector from the command prompt to see if any messages are output to the console.  The following table provides the solutions ...",t:"Troubleshoot Errors"},"10":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Documents_Introduction.htm",a:"Create and Ingest Documents This section describes how to create and ingest Documents using ConnectorLib .NET.",t:"Create and Ingest Documents"},"11":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Documents_Intro.htm",a:"Much of what a connector does involves dealing with documents in some way. A document represents a single document in IDOL and has: A unique reference to identify it. A unique identifier for finding it in the repository. A set of key-value pairs for storing metadata. Optionally, a file storing the ...",t:"Introduction"},"12":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Create_a_Document.htm",a:"With ConnectorLib .NET, you can create a new document using the DocInfo.Create() methods, for example: \n       IDocInfo doc = DocInfo.Create(task.TaskConfig,\n\t\t\"http://www.example.com/testDocument.doc\",\n\t\t\"testDocument.doc\", true); The arguments for this method are:        Create(ITaskConfig ...",t:"Create a Document"},"13":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Add_Metadata.htm",a:"Often repositories store metadata about the files they contain, such as who created a file and when it was last modified. Metadata might also include repository-specific information. For example, a repository storing information about products for sale might include a price and a description for ...",t:"Add Metadata"},"14":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Metadata_only_Documents.htm",a:"To create a document that has metadata but no file, use a different overload of DocInfo.Create:        IDocInfo doc = DocInfo.Create(task.TaskConfig,\n\t\t\"http://www.example.com/metadataOnly\"); You might create a metadata-only document when items in a repository do not include file data (for example, ...",t:"Create Metadata-only Documents"},"15":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Identifiers.htm",a:"Although a document\u0027s reference should identify a unique file or item  in the repository, it might not be sufficient for the connector to retrieve it again efficiently (this might be necessary, for example, in response to a collect request). You can therefore add additional information to a ...",t:"Create Identifiers"},"16":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Ingest_a_Document.htm",a:"A connector\u0027s synchronize action typically involves retrieving files and associated metadata from a repository, creating documents from those files, and sending the documents  to the ingestion target, configured in the [Ingestion] section of the configuration file. Usually the target is a CFS, which ...",t:"Ingest a Document"},"17":{i:0.00141322873173586,u:"../Content/Tutorial/Documents/Ingest_Add.htm",a:"The Ingest Add method adds a new document to the ingestion target. You can create and ingest a document  like this:        using(IDocInfo doc = DocInfo.Create(task.TaskConfig,\n               \"http://www.example.com/testDocument.doc\",\n               \"testDocument.doc\", true))\n       {\n           ...",t:"Ingest Add"},"18":{i:0.00135885646845729,u:"../Content/Tutorial/Documents/Ingest_Remove.htm",a:"The Remove method deletes a document that has previously been ingested. Only the reference is required to do this:        task.Ingester.Remove(\"http://www.example.com/testDocument.doc\"); The synchronize action typically removes documents when the connector detects that a document has been removed ...",t:"Ingest Remove"},"19":{i:0.000677048087242869,u:"../Content/Tutorial/Documents/Ingest_Replace.htm",a:"The Replace method is short-hand for performing a  Remove  followed by an  Add. You can use this method when a document in a repository has been changed.        using(IDocInfo doc = DocInfo.Create(task.TaskConfig,\n               \"http://www.example.com/testDocument.doc\",\n               ...",t:"Ingest Replace"},"20":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Ingest_Update.htm",a:"If a document has been ingested previously, and the metadata for the document has changed but the file content has not, you can use the Ingest Update method. This instructs the target to update the metadata for an existing document, but to leave the content intact. The following example updates just ...",t:"Ingest Update"},"21":{i:0.000527569802810135,u:"../Content/Tutorial/Documents/Ingest_Result_Handlers.htm",a:"When you ingest a document using the Add, Replace, Remove or Update methods, the ingest command is placed in a queue and the method returns immediately. ConnectorLib .NET takes care of batching, sending the commands, and dealing with any transitory problems communicating with the target. As a ...",t:"Ingest Result Handlers"},"22":{i:0.00212493314448396,u:"../Content/Tutorial/CompleteSynchronize/Introduction.htm",a:"This section demonstrates code for a connector\u0027s synchronize action. During a complete synchronize, a connector ingests every document in a repository, regardless of whether the documents have changed since the last synchronize. \n            The sample uses a directory on the file system to ...",t:"A Complete Synchronize Action"},"23":{i:0.00134474926522784,u:"../Content/Tutorial/CompleteSynchronize/SampleCode.htm",a:"The following code sample demonstrates a complete synchronize action. The sample uses a directory on the file system to represent a repository.        using System;\n       using System.IO;\n       using Autonomy.Connector;\n \n       namespace MyConnectorNamespace\n       {\n           public class ...",t:"Sample Code for the Synchronize Action"},"24":{i:0.000527569802810135,u:"../Content/Tutorial/CompleteSynchronize/RunConnector.htm",a:"You can set up the connector using the instructions in  Run the Connector . SimpleSynchronize.dll must be in the connector directory, and you must set the following parameters in connectorLibDotNet.cfg:        DotNetConnectorLibrary=SimpleSynchronize.dll\n       ...",t:"Set up and Run the Connector"},"25":{i:0.000527569802810135,u:"../Content/Tutorial/CompleteSynchronize/Stopping.htm",a:"A connector can be requested to stop at any time.  For example,  the connector might be running as a service that is stopped, it might receive an action=stop command to its service port, or a user might press CTRL+C in the connector’s console window.  The  sample code  calls the Stopping() method on ...",t:"Handle Stop Requests"},"26":{i:0.000867633180879955,u:"../Content/Tutorial/CompleteSynchronize/Full_Incremental_Sync.htm",a:"The synchronize action demonstrated in the  sample code  acts the same way every time it is called: the connector ingests every  file in the repository . This is called a full synchronize, and a connector would typically do this the first time the synchronize action is used. When the synchronize ...",t:"Full and Incremental Synchronize"},"27":{i:0.00129037700194926,u:"../Content/Tutorial/Datastore/Datastore_Introduction.htm",a:"The Datastore This section describes how to use the Datastore.",t:"The Datastore"},"28":{i:0.000527569802810135,u:"../Content/Tutorial/Datastore/Datastore_Overview.htm",a:"The datastore is a feature of ConnectorLib .NET that allows a connector to store structured information in a file.  Each datastore file contains SQL-like tables with defined columns. You can use the features provided by ConnectorLib .NET to create new tables in the datastore, store and retrieve ...",t:"Introduction"},"29":{i:0.000527569802810135,u:"../Content/Tutorial/Datastore/Create_a_DataStoreFile.htm",a:"Create a Datastore File The datastore features are all contained within the  Autonomy.Connector.Datastore  namespace. The samples in this section assume there is  a using  directive for this namespace at the beginning of the file:        using Autonomy.Connector.Datastore; You can access a datastore ...",t:"Create a DatastoreFile"},"30":{i:0.00120022208275744,u:"../Content/Tutorial/Datastore/Create_tables.htm",a:"The connector described in   A Complete Synchronize Action  always ingests every file, even those that have not changed since the last synchronize. You could improve this connector by implementing  incremental synchronize . To do this, you can create a Datastore table to store the modified date of ...",t:"Create Tables"},"31":{i:0.000527569802810135,u:"../Content/Tutorial/Datastore/Insert_Records.htm",a:"After you have created a datastore table, you can add records to it:        Record record = new Record();\n\n       record[\"Reference\"] = @\"C:\\data\\file1.txt\";\n\n       record.Add(\"LastModified\", new DateTime(\n\t\t2013, 8, 05, 18, 05, 0, DateTimeKind.Utc));\n\n       docs.Insert(record); This example ...",t:"Insert Records"},"32":{i:0.000527569802810135,u:"../Content/Tutorial/Datastore/Processing_the_Queue.htm",a:"When you insert or update records in a datastore table, the changes are not made immediately. For efficiency reasons they are queued and then committed in batches. To make sure all changes have been committed before you perform a query, you can instruct the datastore to process the queue:        ...",t:"Process the Queue"},"33":{i:0.00783835679203831,u:"../Content/Tutorial/Datastore/Retrieve_a_Record.htm",a:"The following example shows how to retrieve (or \"select\") a record by reference:        Record selected = docs.SelectOne(\n\t\tdocs.Column(\"Reference\") == @\"C:\\data\\file1.txt\",\n\t\tnew string[] { \"Reference\", \"LastModified\"}); The first argument specifies the query to perform and selects records where ...",t:"Retrieve a Record"},"34":{i:0.00859638201683258,u:"../Content/Tutorial/Datastore/Filters.htm",a:"To select records in a table, you must use Filters. For information about selecting records, and for examples of Filters being used, see  Retrieve a Record .  This section describes how to create Filters. Basic Comparisons Normally, you can use operators like \u0027==\u0027, \u0027!=\u0027 and \u0027\u003c\u0027 to perform a single ...",t:"Filters"},"35":{i:0.000527569802810135,u:"../Content/Tutorial/Datastore/Update_Records.htm",a:"To update records in a table, use the  Update method of the Table class. This method updates all records that match a  filter .  You can update all of the columns for the record, or just some of them. In  Create Tables , a table was introduced that stored a reference and a last modified date.  This ...",t:"Update Records"},"36":{i:0.000527569802810135,u:"../Content/Tutorial/Datastore/Remove_Records.htm",a:"Remove Records You can remove records with  the Remove method of the Table class.  This method removes all records that match a  filter . For example, to remove all records where the reference is equal to C:\\data\\file1.txt:        docs.Remove(docs.Column(\"Reference\") == @\"C:\\data\\file1.txt\");",t:"Remove Records"},"37":{i:0.000867633180879955,u:"../Content/Tutorial/Datastore/Indexes.htm",a:"If your connector frequently uses  filters  based on the value of one column, you can significantly increase the speed of queries by creating an index. To create an index for the Reference column of a table, use the following code:        docs.CreateIndex(new string[] { \"Reference\" }); After the ...",t:"Indexes"},"38":{i:0.000527569802810135,u:"../Content/Tutorial/Datastore/Upgrade_Tables.htm",a:"You might add a new feature  to your connector that requires a change in the structure of its datastore tables.  If the connector has already been used in a production environment there might be datastore files with the old structure that have been populated with information.  It might be desirable ...",t:"Upgrade Tables"},"39":{i:0.00139080717639452,u:"../Content/Tutorial/IncrementalSynchronize/Make_Synchronize_Incremental.htm",a:"This section shows how the connector introduced in  A Complete Synchronize Action  can be updated to make the synchronize action incremental, by using the datastore functionality described in  The Datastore . An incremental synchronize is more efficient than running a full synchronize every time you ...",t:"Make an Incremental Synchronize Action"},"40":{i:0.000527569802810135,u:"../Content/Tutorial/IncrementalSynchronize/Incremental_Synchronize.htm",a:"The incremental synchronize implemented by the sample code in  IncrementalSynchronize.sln works by maintaining the following datastore table: Reference LastModified PendingAction Seen ... ... ... ... The connector adds one row to the table for every file that it finds in the repository.  The full ...",t:"Incremental Synchronize"},"41":{i:0.000527569802810135,u:"../Content/Tutorial/IncrementalSynchronize/Incremental_Synchronize_Example.htm",a:"This section describes the connector in operation. Cycle 1 To begin with, the datastore table is empty. The “data” directory (the repository from which the sample connector retrieves data) contains three files:        File1.txt\n       File2.txt\n       File3.txt When the synchronize action runs, the ...",t:"Incremental Synchronize Example"},"42":{i:0.000527569802810135,u:"../Content/Tutorial/IncrementalSynchronize/Code_Structure.htm",a:"The sample code in IncrementalSynchronize.sln is split into the following classes: MyState Handles access to the datastore and provides methods for updating and querying the table. MySynchronize Handles the synchronize action and depends upon MyState. MyConnector This is the main connector class.  ...",t:"Sample Code Structure"},"43":{i:0.000527569802810135,u:"../Content/Tutorial/Actions_Intro.htm",a:"So far this document has focused on implementing the synchronize fetch action, but a connector can implement other fetch actions in addition to, or instead of, synchronize.  We have already seen how to implement synchronize by overriding the Synchronize method in ConnectorBase. ConnectorBase also ...",t:"Implement Other Actions"},"44":{i:0.000976004656108335,u:"../Content/Tutorial/Actions_RetrieveDocuments.htm",a:"The following table lists the fetch actions that retrieve information from a repository. Action Description Method to override action=fetch\u0026fetchaction=synchronize Sends ingest commands to the ingest target to bring it up to date with what is contained the repository. Synchronize ...",t:"Retrieve Documents from a Repository"},"45":{i:0.000527569802810135,u:"../Content/Tutorial/Actions_UpdateRepository.htm",a:"The following table lists fetch actions that update documents in a repository. Action Description Method to override /action=fetch\u0026fetchaction=Delete Delete specified documents from the repository. Remove /action=fetch\u0026fetchaction=Insert Insert a document or documents into a repository. Insert ...",t:"Update Documents in a Repository"},"46":{i:0.000527569802810135,u:"../Content/Tutorial/Actions_Identifiers.htm",a:"\n            The identifiers fetch action provides information that can be used to browse a repository. It retrieves a list of documents that are present in the repository and generates an identifier for each document. Action Description Method to override /action=fetch\u0026fetchaction=Identifiers ...",t:"Browse a Repository"},"47":{i:0.000527569802810135,u:"../Content/Tutorial/Actions_RetrieveGroups.htm",a:"The SynchronizeGroups fetch action retrieves group information from a repository. This is discussed in more detail in  Mapped Security . Action Description Method to override action=fetch\u0026fetchaction=SynchronizeGroups Updates a group server with user, group and group membership information from the ...",t:"Retrieve Group Information from a Repository"},"48":{i:0.000527569802810135,u:"../Content/Tutorial/Actions_GetUri.htm",a:"A connector\u0027s GetUri action takes a document identifier and returns a URI for the document in the repository. The ConnectorBase class defines the entry point for this action:        public void GetUri(IGetUriTask task) To implement the GetUri action, override the GetUri function in your derived ...",t:"Retrieve the URI of a Document"},"49":{i:0.000527569802810135,u:"../Content/Tutorial/Actions_CustomFetch.htm",a:"You can implement custom fetch actions in a ConnectorLib .NET connector. Action Description Method to override action=Fetch\u0026FetchAction=MyAction Perform custom fetch actions on a repository. CustomFetch To implement a custom fetch action, override the CustomFetch method on the ConnectorBase ...",t:"Implement Custom Fetch Actions"},"50":{i:0.000527569802810135,u:"../Content/Tutorial/Actions_Custom.htm",a:"You can implement custom actions in a ConnectorLib .NET connector. Action Description Method to override action=MyAction Perform custom actions on a repository. Custom To implement a custom action, override the Custom method on the ConnectorBase interface. The  Custom method is passed the name of ...",t:"Implement Custom Actions"},"51":{i:0.000976004656108335,u:"../Content/Tutorial/Security/Security_Introduction.htm",a:"Documents in a repository can often be viewed only by authenticated users, and different users are allowed to view different documents.  In this case you might want any output from IDOL (for example, search results) to  show only documents that a user has permission to see.  This can be achieved by ...",t:"Mapped Security"},"52":{i:0.000804104816334259,u:"../Content/Tutorial/Security/AccessControlLists.htm",a:"An Access Control List (ACL) is a string of text that specifies who is allowed to view a document.  Connectors can add an ACL to a document field, usually AUTONOMYMETADATA, for every document that is ingested. This section describes an “NT Style” ACL, which is used in conjunction with the  IDOL ...",t:"Access Control Lists"},"53":{i:0.00148759482262346,u:"../Content/Tutorial/Security/Security_Groups.htm",a:"ACLs are often expressed in terms of users and groups. To determine whether a user can access a document, IDOL must know which security groups a user belongs to.  IDOL requests this information from a group server such as OmniGroupServer. The group server can retrieve the group membership ...",t:"Groups"},"54":{i:0.000804104816334259,u:"../Content/Tutorial/Security/SynchronizeGroups.htm",a:"As described in  Groups , it is sometimes necessary for a connector to provide group membership information to a group server. OmniGroupServer might be configured to store group information from a repository with the following settings: ...",t:"SynchronizeGroups"},"55":{i:0.000527569802810135,u:"../Content/Tutorial/ConnectorLib_Features.htm",a:"Logging, Configuration, and Temporary Files This section describes further useful features of ConnectorLib .NET.",t:"Logging, Configuration, and Temporary Files"},"56":{i:0.000527569802810135,u:"../Content/Tutorial/Logging.htm",a:" All of the fetch action methods you can override in ConnectorBase are passed a task object with a Log property of type ILog.  This allows you to log messages at a variety of levels:        task.Log.WriteLine(LogLevel.Always,\n\t\t\"This message will always be logged\");\t\n       ...",t:"Write Messages to the Log"},"57":{i:0.000527569802810135,u:"../Content/Tutorial/ReadConfiguration.htm",a:" All of the fetch action methods you can override in ConnectorBase are passed a task object with a TaskConfig property of type ITaskConfig. You can use this property to read configuration settings from the task\u0027s  configuration.  The task configuration returned by the methods of the TaskConfig ...",t:"Read Configuration Parameters"},"58":{i:0.000527569802810135,u:"../Content/Tutorial/CreateTempFiles.htm",a:"Your connector might need to create temporary files.  The task objects have a  TempDirectory property   that provides the path of the directory to use for storing temporary files. The Temporary class in the Autonomy.Connector.Utilities namespace provides a convenient method that you can use when ...",t:"Create Temporary Files"},"59":{i:0.000527569802810135,u:"../Content/Tutorial/ProgressReporting.htm",a:"The synchronize action is typically used to retrieve all data from a repository. This could take seconds, hours, or even days to complete. You might therefore decide to give the user an indication of how much progress the connector has made and how much work there is left to do. This section ...",t:"Progress Reporting"},"60":{i:0.000751787229459235,u:"../Content/Tutorial/ProgressReporting_Intro.htm",a:"Progress information for a synchronize action can be retrieved using the following HTTP command, sent to the connector\u0027s ACI port: http://host:port/action=QueueInfo\u0026QueueName=Fetch\u0026QueueAction=Progress\u0026Token=token The  QueueInfo  action returns a report of the progress: \u003cautnresponse\u003e\n  ...",t:"Introduction"},"61":{i:0.000751787229459235,u:"../Content/Tutorial/ProgressReporting_Basic.htm",a:"ISynchronizeTask has a member called TaskStage that allows you to report progress for the synchronize action.  The following example demonstrates basic progress reporting:    task.TaskStage.Maximum = 20;\n   for (int ii = 0; ii \u003c 20; ++ii)\n   {\n      // Do work\n      ...",t:"Basic Progress"},"62":{i:0.000527569802810135,u:"../Content/Tutorial/ProgressReporting_Stages.htm",a:"Instead of updating the progress of the task stage directly, you can split it into multiple child stages. This provides more detail in the  progress report . Add Stages Each stage is given a weight and a maximum value:    IStage stage1 = task.TaskStage.AddChild(\"Searching for new Documents\", 1, ...",t:"Progress with Stages"},"63":{i:0.000527569802810135,u:"../Content/Connector_Reference.htm",a:"Connector Reference This section describes the actions, configuration parameters, and Lua methods that you can use with any connector developed using the ConnectorLib .NET SDK.",t:"Connector Reference"},"64":{i:0.000527569802810135,u:"../Content/Actions/Actions.htm",a:" Actions This section describes the actions that you can use with your connector. Introduction to Actions Connector Actions Fetch Actions",t:" Actions"},"65":{i:0.000677048087242869,u:"../Content/Actions/_ACI_Actions_Intro.htm",a:"Actions allow you to query an ACI server  and instruct it to perform a variety of operations. All actions must be sent to the server  Port . The configured authorization roles determine which users can send which actions to the port. See  Authorization Roles Configuration Parameters . The general ...",t:"Introduction to Actions"},"66":{i:0.000527569802810135,u:"../Content/Actions/Synchronous_and_Asynchro.htm",a:"Some actions are synchronous and others are asynchronous. A connector does not respond to a synchronous action until it has completed the request. The result of the action is in the response to the request. A connector responds to an asynchronous action immediately. The request is added to a queue ...",t:"Synchronous and Asynchronous Actions"},"67":{i:0.000677048087242869,u:"../Content/Actions/Connector/_CN_Actions_Connector.htm",a:"This section describes the actions that are supported by the connector. The connector also supports the Fetch action. For information about using the Fetch action, see  Fetch Actions . The sample HTTP requests in this section are split across multiple lines for readability. When you use these ...",t:"Connector Actions"},"68":{i:0.000527569802810135,u:"../Content/Actions/General/_ACI_Admin.htm",a:"Opens the IDOL Admin interface for the component that you use to call the action. This interface allows you to view data for the component and provides some administrative actions. To use this action, you must have an admin.dat file available for the component. You can configure the location of this ...",t:"Admin"},"69":{i:0.00128562785281159,u:"../Content/Actions/General/_ACI_BackupServer.htm",a:"The BackupServer action creates a backup that can be used to restore the server\u0027s state. The backup includes: details of actions that have been queued, are running, and have finished. a copy of the configuration file. information about the files that the connector has retrieved. ConnectorLib .NET ...",t:"BackupServer"},"70":{i:0.000527569802810135,u:"../Content/Actions/Connector/_CN_GetUri.htm",a:"\n            This action accepts a document identifier and returns a URI to the document in the repository. /action=GetUri\u0026Identifier=...\n             [\u0026Redirect=true] Type: Synchronous Parameter Name Description Required Identifier The identifier of a document. The connector returns a URI that can ...",t:"GetUri"},"71":{i:0.00351704730430442,u:"../Content/Actions/Connector/_CN_PauseSchedules.htm",a:"Temporarily stops the connector starting scheduled tasks. Any tasks that are currently running are allowed to finish but the connector will not start tasks that are scheduled to start.  Type: Synchronous Parameter Name Description Required Sections A comma-separated list of task schedules to pause. ...",t:"PauseSchedules"},"72":{i:0.000527569802810135,u:"../Content/Actions/Connector/_CN_PurgeDatastore.htm",a:"This action instructs the connector to delete the datastore for a fetch task. If any synchronize actions are running, the connector waits for them to finish before deleting the datastore. You might want to delete the datastore for a fetch task if you have modified the task configuration and you need ...",t:"PurgeDatastore"},"73":{i:0.0230272774546597,u:"../Content/Actions/General/_ACI_QueueInfo.htm",a:"The QueueInfo action provides information about the asynchronous actions that the ACI server has queued, is processing, or has finished. You can use the QueueInfo action to: pause and resume processing the queued actions cancel a queued action change the priority of a queued action retrieve the ...",t:"QueueInfo"},"74":{i:0.00209827113718081,u:"../Content/Actions/General/_ACI_RestoreServer.htm",a:"The RestoreServer action restores a server’s state from a backup created by the BackupServer action. After using the RestoreServer action, you must restart the server. Type: Synchronous Parameter Name Description ActionID A string to use to identify an ACI action. Filename The path of the backup ...",t:"RestoreServer"},"75":{i:0.00351704730430442,u:"../Content/Actions/Connector/_CN_ResumeSchedules.htm",a:"Instructs the connector to resume starting scheduled tasks, for task schedules that have been paused by the action   PauseSchedules . Type: Synchronous Parameter Name Description Required Sections A comma-separated list of task schedules that you want to resume.  Specify the names of the tasks as ...",t:"ResumeSchedules"},});