define({"529":{i:0.000823284480307633,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_Methods.htm",a:"This section describes the methods provided by the LuaDocument object. A LuaDocument allows you to access and modify the reference, metadata and content of a document. If you have a LuaDocument object called document you can call its methods using the \u0027:\u0027 operator. For example: ...",t:"LuaDocument Methods"},"530":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_addField.htm",a:"addField The addField method adds a new field to the document. Syntax addField ( fieldname, fieldvalue ) Arguments Argument Description fieldname (string) The name of the field to add. fieldvalue (string) The value to set for the field.",t:"addField"},"531":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_addSection.htm",a:"The addSection method adds an empty section to the end of the document. Syntax addSection() Returns (LuaDocument). Returns a LuaDocument object representing the document, with the new section as the active section. Example local newSection = document:addSection()   -- Add a new section to the ...",t:"addSection"},"532":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_appendContent.htm",a:"The appendContent method appends content to the existing content (the DRECONTENT field) of a document  or document section. Syntax appendContent ( content [, number]) Arguments Argument Description content (string) The content to append. number (number) The document section to modify. If you do not ...",t:"appendContent"},"533":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_copyField.htm",a:"The copyField method copies a field value to a new field. If the target field already exists it is overwritten. Syntax copyField ( sourcename, targetname [, case] ) Arguments Argument Description sourcename (string) The name of the field to copy. targetname (string) The destination field name. case ...",t:"copyField"},"534":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_copyFieldNoOverwrite.htm",a:"The copyFieldNoOverwrite method copies a field value to a new field but does not overwrite the existing value. After calling this function the target field will contain all values of the source field in addition to any values it already had. Syntax copyFieldNoOverwrite( sourcename, targetname [, ...",t:"copyFieldNoOverwrite"},"535":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_countField.htm",a:"The countField method returns the number of fields with the specified name. Syntax countField( fieldname [, case] ) Arguments Argument Description fieldname (string) The name of the field to count. case (boolean) A boolean that specifies whether fieldname is case sensitive. The field name is case ...",t:"countField"},"536":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_deleteField.htm",a:"The deleteField method deletes a field from a document. If you specify the optional value argument, the field is deleted only if has the specified value. Syntax deleteField( fieldName [, case] ) deleteField( fieldName, value [, case] ) Arguments Argument Description fieldname (string) The name of ...",t:"deleteField"},"537":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_deleteFieldByPath.htm",a:"deleteFieldByPath The deleteFieldByPath method removes all document fields with the specified path. Syntax deleteFieldByPath( path ) Arguments Argument Description path (string) The path of the field(s) to delete. Example document:deleteFieldByPath(\"my/metadata/subfield\")",t:"deleteFieldByPath"},"538":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getContent.htm",a:"The getContent method gets the content (the value of the DRECONTENT field) for a document or document section. Syntax getContent([number]) Arguments Argument Description number (number) The document section for which you want to return the content.  If you do not specify this argument, the method ...",t:"getContent"},"539":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getField.htm",a:"The getField method returns a LuaField object representing the field with the specified name. Syntax getField( name [, case]) Arguments Argument Description name (string) The name of the field. case (boolean) A boolean that specifies whether the name argument is case-sensitive. The name is case ...",t:"getField"},"540":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getFieldNames.htm",a:"getFieldNames The getFieldNames method returns all of the field names for the document. Syntax getFieldNames() Returns (Strings) The names of the fields. To map the return values to a table, surround the function call with braces. For example: names = { document:getFieldNames() }",t:"getFieldNames"},"541":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getFields.htm",a:"The getFields method returns LuaField objects where each object represents a field that matches the specified name. Syntax getFields( name [, case]) Arguments Argument Description name (string) The name of the field. case (boolean) A boolean that specifies whether the name argument is ...",t:"getFields"},"542":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getFieldsByRegex.htm",a:"The getFieldsByRegex method returns all document fields where the field name or path matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Argument Description regex (string) The regular expression to match field names or paths ...",t:"getFieldsByRegex"},"543":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getFieldValue.htm",a:"The getFieldValue method gets the value of a field in a document. To return the values of a multi-value field, see  getFieldValues . Syntax getFieldValue( fieldname [, case]) Arguments Argument Description fieldname (string) The name of the field to be retrieved. case (boolean) A boolean that ...",t:"getFieldValue"},"544":{i:0.000853334639391724,u:"../Content/Lua/LuaDocument/_LUA_getFieldValues.htm",a:"The getFieldValues method gets all values from all fields that have the same name. Syntax getFieldValues( fieldname [, case]) Arguments Argument Description fieldname (string) The name of the field. case (boolean) A boolean that specifies whether fieldname is case-sensitive. The argument is case ...",t:"getFieldValues"},"545":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getNextSection.htm",a:"The getNextSection method returns the next section of a document (if the document has been divided into sections). The document object passed to the script\u0027s handler function represents the first section of the document. This means that the methods described in this section read and modify only the ...",t:"getNextSection"},"546":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getReference.htm",a:"getReference The getReference method returns a string containing the reference (the value of the DREREFERENCE document field). Syntax getReference() Returns (String). A string containing the reference.",t:"getReference"},"547":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getSection.htm",a:"The getSection method returns a LuaDocument object with the specified section as the active section. Syntax getSection(number) Arguments Argument Description number (number) The document section for which you want to return a LuaDocument object. Returns (LuaDocument). A LuaDocument object with the ...",t:"getSection"},"548":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getSectionCount.htm",a:"getSectionCount The getSectionCount method returns the number of sections in a document. Syntax getSectionCount() Returns (Number). The number of sections. Example local sectionCount = document:getSectionCount()",t:"getSectionCount"},"549":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_getValueByPath.htm",a:"The getValueByPath method gets the value of a document field.  The field is specified by its path, which means that you can get the value of a sub field. If you pass this method the path of a multi-value field, only the first value is returned. To return all of the values from a multi-value field, ...",t:"getValueByPath"},"550":{i:0.000853334639391724,u:"../Content/Lua/LuaDocument/_LUA_getValuesByPath.htm",a:"The getValuesByPath method gets all values of a document field. The field is specified by its path, which means that you can get values from a sub field. Syntax getValuesByPath( path ) Arguments Argument Description path (string) The path of the field. Returns (Strings). Strings that contain the ...",t:"getValuesByPath"},"551":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_hasField.htm",a:"The hasField method checks to see if a field exists in the current document. Syntax hasField ( fieldname [, case]) Arguments Argument Description fieldname (string) The name of the field. case (boolean) A boolean that specifies whether the fieldname is case-sensitive. The field name is ...",t:"hasField"},"552":{i:0.000590701279765756,u:"../Content/Lua/LuaDocument/_LUA_insertJson.htm",a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into a document. Syntax insertJson ( json [, fieldName] ) Arguments Argument Description json (string or  LuaJsonArray  or  LuaJsonObject ) The JSON to insert into the document. fieldName (string) The name of ...",t:"insertJson"},"553":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_insertXml.htm",a:"insertXml The insertXml method inserts XML metadata into the document. Syntax insertXml ( node ) Arguments Argument Description node (LuaXmlNode) The node to insert. Returns (LuaField). A LuaField object of the inserted data.",t:"insertXml"},"554":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_insertXmlWithoutRoot.htm",a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ...",t:"insertXmlWithoutRoot"},"555":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_new.htm",a:"The constructor for a LuaDocument object (creates a new LuaDocument object that only contains a reference). Syntax LuaDocument:new( reference ) Arguments Argument Description reference (string) The reference to assign to the new document. Returns (LuaDocument). The new LuaDocument object. Example ...",t:"LuaDocument:new"},"556":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_removeSection.htm",a:"The removeSection method removes a section from a document. Syntax removeSection( sectionNumber ) Arguments Argument Description sectionNumber (number) A zero-based index that specifies the section to remove. For example, to remove the second section, set this argument to  1. Returns Nothing. ...",t:"removeSection"},"557":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_renameField.htm",a:"The renameField method changes the name of a field. Syntax renameField( currentname, newname [, case]) Arguments Argument Description currentname (string) The name of the field to rename. newname (string) The new name of the field. case (boolean) A boolean that specifies whether the currentname ...",t:"renameField"},"558":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_setContent.htm",a:"The setContent method sets the content (the value of the DRECONTENT field) for a document or document section. Syntax setContent( content [, number] ) Arguments Argument Description content (string) The content to set for the document or document section. number (number) The document section to ...",t:"setContent"},"559":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_setFieldValue.htm",a:"The setFieldValue method sets the value of a field in a document. If the field does not exist, it is created. If the field already exists, the existing value is overwritten. Syntax setFieldValue( fieldname, newvalue ) Arguments Argument Description fieldname (string) The name of the field to set. ...",t:"setFieldValue"},"560":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_setReference.htm",a:"setReference The setReference method sets the reference (the value of the DREREFERENCE document field) to the string passed in. Syntax setReference( reference ) Arguments Argument Description reference (string) The reference to set.",t:"setReference"},"561":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_to_IDX.htm",a:"to_idx The to_idx method returns a string containing the document in IDX format. Syntax to_idx() Returns (String). Returns the document as a string.",t:"to_idx"},"562":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_to_JSON.htm",a:"to_json The to_json method returns a string containing the document in JSON format. Syntax to_json() Returns (String). Returns the document as a string.",t:"to_json"},"563":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_to_XML.htm",a:"to_xml The to_xml method returns a string containing the document in XML format. Syntax to_xml() Returns (String). Returns the document as a string.",t:"to_xml"},"564":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_writeStubIdx.htm",a:"The writeStubIdx method writes out a stub IDX document (a metadata file used by IDOL applications). The file is created in the current folder, but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubIdx( filename ) Arguments Argument ...",t:"writeStubIdx"},"565":{i:0.000461261696976616,u:"../Content/Lua/LuaDocument/_LUA_writeStubXml.htm",a:"The writeStubXml method writes out an XML file containing the metadata for the document. The file is created in the current folder but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubXml( filename ) Arguments Argument Description filename ...",t:"writeStubXml"},"566":{i:0.000441823008170112,u:"../Content/Lua/LuaField/_LUA_LuaField_Methods.htm",a:"This section describes the methods provided by LuaField objects. A LuaField represents a single field in a document. You can retrieve LuaField objects for a document using the LuaDocument getField and getFields methods. In its simplest form a field has just a name and a value, but it can also ...",t:"LuaField Methods"},"567":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_addField.htm",a:"addField The addField method adds a sub field with the specified name and value. Syntax addField( fieldname, fieldvalue ) Arguments Argument Description fieldname (string) The name of the field. fieldvalue (string) The value of the field.",t:"addField"},"568":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_copyField.htm",a:"The copyField method copies a sub field to another sub field. If the target sub field exists it is overwritten. Syntax copyField ( from, to [, case]) Arguments Argument Description from (string) The name of the field to copy. to (string) The name of the field to copy to. case (boolean) A boolean ...",t:"copyField"},"569":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_copyFieldNoOverwrite.htm",a:"The copyFieldNoOverwrite method copies the sub field to another sub field but does not overwrite the destination. After this operation the destination field contains all the values of the source field as well as any values it already had. Syntax copyFieldNoOverwrite( from, to [, case]) Arguments ...",t:"copyFieldNoOverwrite"},"570":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_countField.htm",a:"The countField method returns the number of sub fields that exist with the specified name. Syntax countField ( fieldname [, case]) Arguments Argument Description fieldname (string) The name of the field. case (boolean) A boolean that specifies whether the fieldname argument is case sensitive. The ...",t:"countField"},"571":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_deleteAttribute.htm",a:"deleteAttribute The deleteAttribute method deletes the specified field attribute. Syntax deleteAttribute( name ) Arguments Argument Description name (string) The name of the attribute to delete.",t:"deleteAttribute"},"572":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_deleteField.htm",a:"The deleteField method deletes the sub field with the specified name. Syntax deleteField( name [, case] )  deleteField( name , value [, case] )  Arguments Argument Description name (string) The name of the sub field to delete. value (string) The value of the sub field. If this is specified a field ...",t:"deleteField"},"573":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_deleteFieldByPath.htm",a:"deleteFieldByPath The deleteFieldByPath method removes the sub field(s) with the specified path. Syntax deleteFieldByPath( path ) Arguments Argument Description path (string) The path of the sub-field(s) to delete. Example myField:deleteFieldByPath(\"path/to/subfield\")",t:"deleteFieldByPath"},"574":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_getAttributeValue.htm",a:"getAttributeValue The getAttributeValue method gets the value of the specified attribute. Syntax getAttributeValue( name ) Arguments Argument Description name (string) The name of the attribute. Returns (String). The attribute value.",t:"getAttributeValue"},"575":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_getField.htm",a:"The getField method returns the specified sub field. Syntax getField ( name [, case]) Arguments Argument Description name (string) The name of the field to return. case (boolean) A boolean that specifies whether the name argument is case sensitive. The argument is case sensitive by default (true). ...",t:"getField"},"576":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_getFieldNames.htm",a:"The getFieldNames method returns the names of the sub fields in the LuaField object. Syntax getFieldNames() Returns (Strings). The names of the sub fields. The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: fieldnames = { ...",t:"getFieldNames"},"577":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_getFields.htm",a:"The getFields method returns all of the sub fields specified by the name argument. Syntax getFields( name [, case] ) Arguments Argument Description name (string) The name of the fields. case (boolean) A boolean that specifies whether the name argument is case sensitive. The argument is case ...",t:"getFields"},"578":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_getFieldsByRegex.htm",a:"The getFieldsByRegex method returns all sub fields where the sub field name or path (relative to this field) matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Argument Description regex (string) The regular expression to match ...",t:"getFieldsByRegex"},"579":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_getFieldValues.htm",a:"The getFieldValues method returns the values of all of the sub fields with the specified name. Syntax getFieldValues( fieldname [, case] ) Arguments Argument Description fieldname (string) The name of the field. case (boolean) A boolean that specifies whether the fieldname argument is case ...",t:"getFieldValues"},"580":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_getValueByPath.htm",a:"The getValueByPath method gets the value of a sub-field, specified by path.   If you pass this method the path of a sub-field that has multiple values, only the first value is returned. To return all of the values from a multi-value sub-field, see  getValuesByPath . Syntax getValueByPath( path ) ...",t:"getValueByPath"},"581":{i:0.000845163757621999,u:"../Content/Lua/LuaField/_LUA_getValuesByPath.htm",a:"The getValuesByPath method gets the values of a sub-field, specified by path.   Syntax getValuesByPath( path ) Arguments Argument Description path (string) The path of the sub-field. Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call ...",t:"getValuesByPath"},"582":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_hasAttribute.htm",a:"hasAttribute The hasAttribute method returns a Boolean indicating whether the field has the specified attribute. Syntax hasAttribute( name ) Arguments Argument Description name (string) The name of the attribute. Returns (Boolean). A Boolean specifying if the field has the specified attribute.",t:"hasAttribute"},"583":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_hasField.htm",a:"The hasField method returns a Boolean specifying if the sub field exists. Syntax hasField( fieldname [, case]) Arguments Argument Description fieldname (string) The name of the field. case (boolean) A boolean that specifies whether the fieldname argument is case sensitive. The argument is case ...",t:"hasField"},"584":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_insertJson.htm",a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into the field. Syntax insertJson ( json [, fieldName] ) Arguments Argument Description json (string or  LuaJsonArray  or  LuaJsonObject ) The JSON to insert into the field. fieldName (string) The name of a ...",t:"insertJson"},"585":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_insertXml.htm",a:"The insertXml method inserts XML metadata into the document. When called on a LuaField, the insertXml method inserts the fields as children of the LuaField. Syntax insertXml ( node ) Arguments Argument Description node (LuaXmlNode) The node to insert. Returns (LuaField). A LuaField object of the ...",t:"insertXml"},"586":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_insertXmlWithoutRoot.htm",a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ...",t:"insertXmlWithoutRoot"},"587":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_name.htm",a:"name The name method returns the name of the field object. Syntax name() Returns (String). The name of the field object.",t:"name"},"588":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_renameField.htm",a:"The renameField method renames a sub field. Syntax renameField( oldname, newname [, case] ) Arguments Argument Description oldname (string) The previous name of the field. newname (string) The new name of the field. case (boolean) A boolean that specifies whether the oldname argument is case ...",t:"renameField"},"589":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_setAttributeValue.htm",a:"setAttributeValue The setAttributeValue method sets the value for the specified attribute of the field. Syntax setAttributeValue( attribute, value ) Arguments Argument Description attribute (string) The name of the attribute to set. value (string) The value to set.",t:"setAttributeValue"},"590":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_setValue.htm",a:"setValue The setValue method sets the value of the field. Syntax setValue( value ) Arguments Argument Description value (string) The value to set.",t:"setValue"},"591":{i:0.000456845009254582,u:"../Content/Lua/LuaField/_LUA_value.htm",a:"value The value method returns the value of the field object. Syntax value() Returns (String). The value of the field object.",t:"value"},"592":{i:0.000581935067703282,u:"../Content/Lua/LuaHttpRequest/_LUA__LuaHttpRequest.htm",a:"This section describes the methods provided by LuaHttpRequest objects. If you have a LuaHttpRequest object called request you can call its methods using the \u0027:\u0027 operator. For example: request:send() Constructor Description LuaHttpRequest:new The constructor for a LuaHttpRequest object (creates a new ...",t:"LuaHttpRequest Methods"},"593":{i:0.000503653698455579,u:"../Content/Lua/LuaHttpRequest/_LUA_LuaHttpRequest_new.htm",a:"The constructor for a LuaHttpRequest object (creates a new LuaHttpRequest). Syntax LuaHttpRequest:new( config, section ) Arguments Argument Description config (LuaConfig) The LuaConfig object that contains the settings for sending the HTTP request. To obtain a LuaConfig object, see the function  ...",t:"LuaHttpRequest:new"},"594":{i:0.000643765757988749,u:"../Content/Lua/LuaHttpRequest/_LUA_send.htm",a:"The send method sends the HTTP request. Syntax send() Returns (LuaHttpResponse). A  LuaHttpResponse  object. The send method can throw an exception if the request fails. You can catch an exception by calling the method  using the Lua function pcall. Example The following example shows how to send a ...",t:"send"},"595":{i:0.000503653698455579,u:"../Content/Lua/LuaHttpRequest/_LUA_set_body.htm",a:"set_body The set_body method sets the body of the HTTP request. Syntax set_body( body ) Arguments Argument Description body (string or nil) The body of the HTTP request.",t:"set_body"},"596":{i:0.000503653698455579,u:"../Content/Lua/LuaHttpRequest/_LUA_set_config.htm",a:"The set_config method specifies settings to use for sending the HTTP request (in the form of a section from a configuration file). For example, you can specify the proxy server to use by setting the parameters ProxyHost and ProxyPort, or specify the SSL version to use by setting SSLMethod. Syntax ...",t:"set_config"},"597":{i:0.000931759909131692,u:"../Content/Lua/LuaHttpRequest/_LUA_set_header.htm",a:"The set_header method adds a header to the HTTP request. Syntax set_header( name, value ) Arguments Argument Description name (string) The name of the HTTP header to add to the request. value (string or nil) The value of the HTTP header to add to the request. Example request:set_header(\"X-EXAMPLE\", ...",t:"set_header"},"598":{i:0.000503653698455579,u:"../Content/Lua/LuaHttpRequest/_LUA_set_headers.htm",a:"The set_headers method replaces all headers in the HTTP request with new headers. To add a header without changing existing headers, use the method  set_header . Syntax set_headers( headers ) Arguments Argument Description headers (table) The new HTTP headers to add to the request. The table must ...",t:"set_headers"},"599":{i:0.000503653698455579,u:"../Content/Lua/LuaHttpRequest/_LUA_set_method.htm",a:"set_method Specifies the HTTP request method to use when sending the request, for example GET or POST.  Syntax set_method( method ) Arguments Argument Description method (string) The HTTP request method to use. Example request:set_method(\"POST\")",t:"set_method"},"600":{i:0.000503653698455579,u:"../Content/Lua/LuaHttpRequest/_LUA_set_url.htm",a:"set_url The set_url method sets the URL that you want to send the HTTP request to. Syntax set_url( url ) Arguments Argument Description url (string) The URL to send the request to. Example request:set_url(\"https://www.example.com/\")",t:"set_url"},"601":{i:0.000989024714018215,u:"../Content/Lua/LuaHttpResponse/_LUA__LuaHttpResponse.htm",a:"This section describes the methods provided by LuaHttpResponse objects. A LuaHttpResponse object is provided when you send an HTTP request using the  send  method on a  LuaHttpRequest  object. If you have a LuaHttpResponse object called response you can call its methods using the \u0027:\u0027 operator. For ...",t:"LuaHttpResponse Methods"},"602":{i:0.000581935067703282,u:"../Content/Lua/LuaHttpResponse/_LUA_get_body.htm",a:"get_body The get_body method returns the body of the HTTP response. Syntax get_body() Returns (String). The body of the HTTP response.",t:"get_body"},"603":{i:0.000581935067703282,u:"../Content/Lua/LuaHttpResponse/_LUA_get_header.htm",a:"get_header The get_header method returns the value of a specified HTTP header. Syntax get_header( name ) Arguments Argument Description name (string) The name of the HTTP header for which you want to get the value. Returns (String). The value of the header.",t:"get_header"},"604":{i:0.000581935067703282,u:"../Content/Lua/LuaHttpResponse/_LUA_get_headers.htm",a:"The get_headers method returns the names and values of all of the headers in the HTTP response. Syntax get_headers() Returns (table) A table that maps header names to values. Example The following example sends an HTTP request and then prints the headers that are returned to the console: local ...",t:"get_headers"},"605":{i:0.000581935067703282,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found.",t:"get_http_code"},"606":{i:0.0024755505937316,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Constructor Description LuaJsonArray:new The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Method ...",t:"LuaJsonArray Methods"},"607":{i:0.000617174814639869,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Argument Description values (lua_json_type) The values to add to the array. Each value can be a Boolean, float, integer, string,  LuaJsonArray ,  LuaJsonObject ,  LuaJsonValue , or ...",t:"LuaJsonArray:new"},});