define({"0":{i:0.00730059170319463,u:"../Content/Intro/intro_part.htm",a:"Introduction This section introduces the Micro Focus ACI API and includes the following topics: Introduction to the ACI API",t:"Introduction"},"1":{i:0.0135061802417265,u:"../Content/Intro/intro.htm",a:"Introduction to the ACI API The ACI (Autonomy Content Infrastructure) Client API enables easy communication between custom-built applications and Micro Focus ACI servers, as well as simple manipulation of the returned result sets. ",t:"Introduction to the ACI API"},"2":{i:0.00730059170319463,u:"../Content/Intro/API_Versions.htm",a:"API Versions This version of the ACI API Programming Guide is relevant for the following versions of the IDOL SDKs: Java Client NG IDOL SDK version 12.0 C IDOL SDK version 12.0 .NET IDOL SDK version 10.8",t:"API Versions"},"3":{i:0.00730059170319463,u:"../Content/Intro/System_Architecture.htm",a:"The ACI API uses HTTP to allow custom-built applications (for example C,  Java, or .NET applications) to communicate with Micro Focus ACI servers. Communication with the servers is implemented over HTTP using XML and can adhere to SOAP. The following diagram shows the architecture. Application ...",t:"System Architecture"},"4":{i:0.00730059170319463,u:"../Content/Intro/Use_the_ACI_API.htm",a:"You can use the ACI API to send actions to ACI servers and retrieve information from their responses. Each IDOL SDK provides APIs that allow you to: Configure connections to ACI servers. Send requests to ACI servers For details on the available actions and the parameters they require, refer to the ...",t:"Use the ACI API"},"5":{i:0.00730059170319463,u:"../Content/Intro/Autonomy_ACI_Server_.htm",a:"Micro Focus ACI Server Action Syntax You can use either HTTP GET or HTTP POST methods to access Micro Focus ACI servers. The following sections describe syntax differences between the two methods and show examples of each. The ACI API clients construct these requests for you.",t:"Micro Focus ACI Server Action Syntax"},"6":{i:0.00730059170319463,u:"../Content/Intro/HTTP_GET.htm",a:"The ACI API allows custom-built applications to access Micro Focus ACI servers using the following HTTP action syntax: http://host:port/action=action\u0026parameters where, host is the IP address (or name) of the machine on which the Micro Focus ACI server is running. port is the port number that is used ...",t:"HTTP GET"},"7":{i:0.00730059170319463,u:"../Content/Intro/HTTP_POST.htm",a:"The ACI API allows custom-built applications to access Micro Focus ACI servers using the following HTTP action syntax to post the body to  host:port.  action=action parameter1=parameter_value parameter2=parameter_value  is a CRLF combination or a CR. where, host is the IP address (or name) of the ...",t:"HTTP POST"},"8":{i:0.00730059170319463,u:"../Content/Intro/Display_Online_Help_.htm",a:"The ACI server online references contain details of the available actions and configuration parameters for an ACI server. You can use the references to find the details of the actions and parameters that you want to call with the ACI API. You can view the reference for a particular ACI server by ...",t:"Display Online Reference for ACI Server Actions"},"9":{i:0.00730059170319463,u:"../Content/Intro/The_ACI_Representati.htm",a:"The  ACI Representation of XML The following section is not relevant to the .NET IDOL SDK. Each XML entity in an XML document is represented by a Data ACI object (for the Java SDK, this is an AciResponse object), which holds the name of the XML entity and its value (if the XML entity contains plain ...",t:"The ACI Representation of XML"},"10":{i:0.00730059170319463,u:"../Content/Java/java_part.htm",a:"Java Language Interface This section provides information on using the Java language IDOL SDK and includes the following chapters: Use the Java Client NG IDOL SDK",t:"Java Language Interface"},"11":{i:0.0135061802417265,u:"../Content/Java/Java NG/usingJavaNG.htm",a:"Use the Java Client NG IDOL SDK This section describes common ways to use the Java Client NG IDOL SDK. ",t:"Use the Java Client NG IDOL SDK"},"12":{i:0.00730059170319463,u:"../Content/Java/Java NG/Java_ACI_NG_Objects.htm",a:"In the Java Client NG IDOL SDK, the main ACI API functionality is provided by the following objects: AciServerDetails allows you to set the connection details of an ACI server including encryption settings. AciService and AciParameter objects allow you to construct sets of action parameters and send ...",t:"Java ACI Objects"},"13":{i:0.00730059170319463,u:"../Content/Java/Java NG/Create_AciService.htm",a:"All communication with ACI Servers goes through an implementation of the AciService interface. To allow for the usage of different HTTP clients, the default implementation of the AciService interface requires an implementation of the AciHttpClient interface. The default implementation of the  ...",t:"Create an AciService"},"14":{i:0.00730059170319463,u:"../Content/Java/Java NG/Perform_an_Action.htm",a:"After you create your AciService, the next thing you need to do to send an action to an ACI Server, is to produce a set of parameters. You can use any kind of Set implementation, and there is a helper class, ActionParameters, with various methods to make it easier to populate. If you were sending a ...",t:"Perform an Action"},"15":{i:0.00730059170319463,u:"../Content/Java/Java NG/Process_an_ACI_Response.htm",a:"The API uses a processor based system to consume the responses from an ACI Server. It is based around two interfaces: Processor\u003cT\u003e and StAXProcessor\u003cT\u003e. StAXProcessor\u003cT\u003e has an abstract implementation that sets up the StAX parser. You can either write your own processor implementations, or use those ...",t:"Process an ACI Response"},"16":{i:0.00730059170319463,u:"../Content/Java/Java NG/Multipart_Action.htm",a:"The following program provides a more detailed example that includes sending multipart data to a Media Server for processing.  import com.autonomy.aci.client.services.AciService;\nimport com.autonomy.aci.client.services.impl.AciServiceImpl;\nimport ...",t:"Send Multipart Data"},"17":{i:0.00730059170319463,u:"../Content/Java/Java NG/JSP_Tag_Library.htm",a:"The Java Client NG IDOL SDK has a JSP tag library to provide an alternative method for sending actions.  The SDK includes documentation for these tags, as well as JavaDocs. For more information about the tag library, refer to these documents in your Java Client NG IDOL SDK installation package.  The ...",t:"JSP Tag Library"},"18":{i:0.00730059170319463,u:"../Content/NET/NET_part.htm",a:".NET Language Interface This section provides information on using the .NET language IDOL SDK. Use the .NET Interface",t:".NET Language Interface"},"19":{i:0.0135061802417265,u:"../Content/NET/usingNET.htm",a:"Use the .NET Interface This section describes common ways to use the IDOL SDK  for .NET.  The classes defined in the .NET IDOL SDK are in the Autonomy.Aci namespace. To use the examples in this document you must include the directive: using Autonomy.Aci;",t:"Use the .NET Interface"},"20":{i:0.00730059170319463,u:"../Content/NET/NET_ACI_API_Objects.htm",a:"In the .NET IDOL SDK, the main functionality is provided by the following objects: The AciClient class provides methods for creating new connections. Command objects represent requests to an ACI server. They can be run by any connection returned by AciClient. Response objects represent responses ...",t:".NET IDOL SDK Objects"},"21":{i:0.0486585799293063,u:"../Content/NET/Create_a_Connection.htm",a:"To send actions to an ACI server, you must first create a connection. When you create the connection, you specify the host and port of the server you want to send the actions to. You can specify other connection settings, such as the number of times to retry a request that fails before abandoning ...",t:"Create a Connection"},"22":{i:0.0846203223710249,u:"../Content/NET/Perform_an_Action.htm",a:"To send an action to the ACI server, you must create a Command object. This object stores information about the action that you want to run, including all the parameters that the action requires. For an example of how to create a Command object, see  Create an Action . Create an Action The following ...",t:"Perform an Action"},"23":{i:0.0126968374875876,u:"../Content/NET/Manipulate_a_Respons.htm",a:"The Execute method of an IConnection sends an action to an ACI server and returns a structure containing the response.  For an example of how to obtain this structure, see  Obtain a Response to a Query . Obtain a Response to a Query The following example shows how to run a command and retrieve the ...",t:"Manipulate a Response"},"24":{i:0.00730059170319463,u:"../Content/C/c_part.htm",a:"C Language Interface This section provides information on using the C language IDOL SDK and includes the following chapters: Use the C Interface C-Language Reference",t:"C Language Interface"},"25":{i:0.0104033859724606,u:"../Content/C/usingC.htm",a:"Use the C Interface This chapter describes common ways to use the C-language IDOL SDK. ",t:"Use the C Interface"},"26":{i:0.00730059170319463,u:"../Content/C/C_ACI_Objects.htm",a:"The fundamental construct in the C IDOL SDK is the ACI object. ACI objects have the following types: Connection objects allow you to represent details of the ACI server. Command objects allow you to set details of the requests made to the server; for example, the server action and the parameters ...",t:"C ACI Objects"},"27":{i:0.0486585799293063,u:"../Content/C/Create_a_Connection.htm",a:"You must create a connection object (type ACI_CONNECTION) to establish a connection with the server. You must set the server host details in this object before making a request. You can specify other connection settings, such as the number of times a connection to the server is attempted and fails ...",t:"Create a Connection"},"28":{i:0.00730059170319463,u:"../Content/C/Perform_an_Action.htm",a:"A command object (type ACI_COMMAND) stores information about the action that you want to run, as well as all the parameters that this action requires, such as:  the type of HTTP request (GET/POST) that is made when the action runs. security details for a data repository. There is no limit to the ...",t:"Perform an Action"},"29":{i:0.0486585799293063,u:"../Content/C/Manipulate_a_Respons.htm",a:"There are two ways to execute the request, depending on how you want to process the response. Obtain and Process an Unparsed Response The aciObjectExecuteToString function returns the server response as an unparsed data buffer: char *szResponse = NULL;\nint nResponseLen = 0;\nchar *szContentType = ...",t:"Process a Response"},"30":{i:0.00730059170319463,u:"../Content/C/Multipart_Action.htm",a:"The following program provides a more detailed example that includes sending multipart data to a Media Server for processing. This example uses the  aciObjectParamSetFile  function to upload the source data and task configuration files. To run this example program, you set four arguments at the ...",t:"Send Multipart Data"},"31":{i:0.0104033859724606,u:"../Content/C/C_functions.htm",a:"C-Language Reference This section describes the C-language functions that are part of the C IDOL SDK. ",t:"C-Language Reference"},"32":{i:0.00730059170319463,u:"../Content/C/Function_Summary.htm",a:"The C-language functions can be divided into several categories as identified in the table below. C-language functions Function Description Initialization and housekeeping  aciInit  Initializes the ACI API. aciInitEncryption Initializes the encryption keys to use for subsequent ACI connections. ...",t:"Function Summary"},"33":{i:0.00730059170319463,u:"../Content/C/Constants.htm",a:"The constants that are used in the C language SDK are outlined in the following table. Constants used in C-language functions Constant Description ACI_COMMAND Indicates that you want to create an ACI_COMMAND type ACI object. This constant is used by only the aciObjectCreate function. ACI_COM_COMMAND ...",t:"Constants"},"34":{i:0.00730059170319463,u:"../Content/C/aciClientFreeMemory.htm",a:"Call the aciClientFreeMemory function to free memory allocated with the ACI client. Syntax aciError aciClientFreeMemory(\n   void** ppMem)  Arguments Arguments Type/Description ppMem void**  A pointer to the memory to free. Discussion This function provides a mechanism to free arbitrary memory ...",t:"aciClientFreeMemory"},"35":{i:0.00730059170319463,u:"../Content/C/aciErrorStatusCreate.htm",a:"Call the aciErrorStatusCreate function to create an error status structure for aciResponseGetErrorStatus to use. Syntax aciError aciErrorStatusCreate(\n   t_aciErrorStatus** ppErrorStatus) Arguments Arguments Type/Description ppErrorStatus t_AciErrorStatus**  The ACI error status structure to create. ...",t:"aciErrorStatusCreate"},"36":{i:0.00730059170319463,u:"../Content/C/aciErrorStatusDestro.htm",a:"Call the aciErrorStatusDestroy function to destroy an error status structure created by aciErrorStatusCreate. Syntax aciError aciErrorStatusDestroy(\n   t_aciErrorStatus **ppErrorStatus) Arguments Arguments Type/Description ppErrorStatus t_AciErrorStatus**  The ACI error status structure to destroy. ...",t:"aciErrorStatusDestroy"},"37":{i:0.00730059170319463,u:"../Content/C/aciErrorStatusReset.htm",a:"Call the aciErrorStatusCreate function to reset an error status structure that the aciResponseGetErrorStatus uses. Syntax aciError aciErrorStatusReset(\n   t_aciErrorStatus *pErrorStatus) Arguments Arguments Type/Description pErrorStatus t_AciErrorStatus*  The ACI error status structure to reset. ...",t:"aciErrorStatusReset"},"38":{i:0.00730059170319463,u:"../Content/C/aciInit.htm",a:"aciInit Call the aciInit function to initialize the ACI API.  Syntax void aciInit ( ) Discussion You must call this function at the beginning of an application. ",t:"aciInit"},"39":{i:0.00730059170319463,u:"../Content/C/aciInitEncryption.htm",a:"Call the aciInitEncryption function to initialize the encryption keys to use for subsequent ACI connections.  Syntax aciError aciInitEncryption (\n    BOOL bOEMLicensed,\n    char* szEncType,\n    char* szTEAKeys) Arguments Arguments Type/Description bOEMLicensed BOOL  One of the following values: TRUE ...",t:"aciInitEncryption"},"40":{i:0.00730059170319463,u:"../Content/C/acioAttributeGetValu.htm",a:"Call the acioAttributeGetValue function to get the value of an attribute. Syntax aciError acioAttributeGetValue(\n   t_aciObject* pObject,\n   const char* szAttribName,\n   char** pszAttribValue) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to the ACI object whose attribute ...",t:"acioAttributeGetValue"},"41":{i:0.00730059170319463,u:"../Content/C/aciObjectAddAttribut.htm",a:"Call the aciObjectAddAttribute function to add a new attribute to an ACI object. Syntax aciError aciObjectAddAttribute(\n   t_aciObject* pObject,\n   const char* szAttributeName,\n   const char* szAttributeValue) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to the ACI object to ...",t:"aciObjectAddAttribute"},"42":{i:0.00730059170319463,u:"../Content/C/aciObjectAttributeGetNames.htm",a:"Call the aciObjectAttributeGetNames function to get an array of the attributes of the current object. Syntax aciError aciObjectAttributeGetNames(\n   t_aciObject* pObject,\n   char*** paszAttribNames,\n   int* pnNumAttributes) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to the ...",t:"aciObjectAttributeGetNames"},"43":{i:0.00730059170319463,u:"../Content/C/aciObjectAttributeGe.htm",a:"Call the aciObjectAttributeGetNamesAndValuesNoCopy function to retrieve arrays of attribute names and values of an ACI object. Syntax aciError aciObjectAttributeGetNamesAndValuesNoCopy(\n   t_aciObject* pObject,\n   const char*** paszAttrNames,\n   const char*** paszAttrValues,\n   int* pnNumAttrs); ...",t:"aciObjectAttributeGetNamesAndValuesNoCopy"},"44":{i:0.00730059170319463,u:"../Content/C/aciObjectCheckForSuc.htm",a:"Call the aciObjectCheckForSuccess function to check whether an ACI server reply object contains a successful response entry.  Syntax BOOL aciObjectCheckForSuccess (\n   t_aciObject* pACIOResult) Arguments Arguments Type/Description pACIOResult t_aciObject*  A pointer to an ACI server reply object you ...",t:"aciObjectCheckForSuccess"},"45":{i:0.00730059170319463,u:"../Content/C/aciObjectCreate.htm",a:"Call the aciObjectCreate function to create an ACI object. Syntax aciError aciObjectCreate (\n   t_aciObject** ppObject,\n   aciObjectType nType); Arguments Arguments Type/Description ppObject t_aciObject**  On return, the ACI object you created. nType aciObjectType  One of the following data type ...",t:"aciObjectCreate "},"46":{i:0.00730059170319463,u:"../Content/C/aciObjectDeleteObjec.htm",a:"Call the aciObjectDeleteObject function to delete a single ACI object. Syntax aciError aciObjectDeleteObject(\n   t_aciObject* pObject, \n   t_aciObject* pPrevious) Arguments Arguments Type/Description pObject t_aciObject*  The ACI object to delete. pPrevious t_aciObject*  ACI object (can be null if ...",t:"aciObjectDeleteObject"},"47":{i:0.00730059170319463,u:"../Content/C/aciObjectDestroy.htm",a:"Call the aciObjectDestroy function to destroy an ACI object. Syntax aciError aciObjectDestroy (\n   t_aciObject** ppObject); Arguments Arguments Type/Description ppObject t_aciObject**  The ACI object to destroy. Discussion This function frees memory from the ACI object and all objects in its linked ...",t:"aciObjectDestroy"},"48":{i:0.0135061802417265,u:"../Content/C/aciObjectExecute.htm",a:"Call the aciObjectExecute function to run an ACI action. Syntax aciError aciObjectExecute (\n   t_aciObject* pConnection,\n   t_aciObject* pToExecute,\n   t_aciObject** ppResult); Arguments Arguments Type/Description pConnection t_aciObject*  A pointer to an ACI_CONNECTION object. pToExecute ...",t:"aciObjectExecute"},"49":{i:0.00730059170319463,u:"../Content/C/aciObjectExecuteToSt.htm",a:"Call the aciObjectExecuteToString function to run an ACI action to a string buffer, rather than to an ACI response object. Syntax aciError aciObjectExecuteToString(\n   t_aciObject* pConnection,\n   t_aciObject* pToExecute,\n   char** pszResult,\n   int* pnBufferLength,\n   char** pszContentType); ...",t:"aciObjectExecuteToString"},"50":{i:0.00730059170319463,u:"../Content/C/aciObjectFirstEntry.htm",a:"Call the aciObjectFirstEntry function to locate the first child entry in a result. Syntax t_aciObject* aciObjectFirstEntry (\n   t_aciObject* pObject) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA object that contains an XML result. Discussion You can only call ...",t:"aciObjectFirstEntry"},"51":{i:0.00730059170319463,u:"../Content/C/aciObjectGetTagValue.htm",a:"Call the aciObjectGetTagValue function to obtain the value associated with the first occurrence of a tag. Syntax aciError aciObjectGetTagValueWithDefault (\n   t_aciObject* pObject, \n   char* szTagName, \n   char** pszTagValue,\n   char* szDefault) Arguments Arguments Type/Description pObject ...",t:"aciObjectGetTagValueWithDefault"},"52":{i:0.00730059170319463,u:"../Content/C/aciObjectGetVersion.htm",a:"Call the aciObjectGetVersion function to return the version string of the ACI client. Syntax char* aciObjectGetVersion() Discussion This function gets a human-readable string describing the version of the ACI Client API. Memory is allocated to the returned pointer and must be freed by the caller. ...",t:"aciObjectGetVersion"},"53":{i:0.00730059170319463,u:"../Content/C/aciObjectIsAlive.htm",a:"Call the aciObjectIsAlive function to determine whether the ACI server is accessible. Syntax BOOL aciObjectIsAlive (\n   t_aciObject* pACIOConnection) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_CONNECTION type object. Discussion This function checks whether the ACI ...",t:"aciObjectIsAlive"},"54":{i:0.00730059170319463,u:"../Content/C/aciObjectNextEntry.htm",a:"Call the aciObjectNextEntry function to locate the next child entry in a result. Syntax t_aciObject* aciObjectNextEntry (    t_aciObject* pObject) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA object that contains an XML result. Discussion You can only call this ...",t:"aciObjectNextEntry"},"55":{i:0.00730059170319463,u:"../Content/C/aciObjectParamSetBoo.htm",a:"Call the aciObjectParamSetBool function to set the contents of a Boolean parameter.  Syntax aciError aciObjectParamSetBool (\n   t_aciObject* pObject, \n   char* szName, \n   BOOL bValue) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA object that contains an XML ...",t:"aciObjectParamSetBool"},"56":{i:0.00730059170319463,u:"../Content/C/aciObjectParamSetDou.htm",a:"Call the aciObjectParamSetDouble function to set the contents of a double-precision floating point parameter.  Syntax aciError aciObjectParamSetDouble (\n   t_aciObject* pObject, \n   char* szName, \n   double dValue,\n   int nDecimalPlaces) Arguments Arguments Type/Description pObject t_aciObject*  A ...",t:"aciObjectParamSetDouble"},"57":{i:0.0135061802417265,u:"../Content/C/aciObjectParamSetFile.htm",a:"Call the aciObjectParamSetFile function to set a file parameter to the path to a file to upload. You can use this function for  Syntax aciError aciObjectParamSetFile(\n   t_aciObject* pObject,\n   const char * szName, \n   const char * szFileName );  Arguments Arguments Type/Description pObject ...",t:"aciObjectParamSetFile"},"58":{i:0.00730059170319463,u:"../Content/C/aciObjectParamSetInt.htm",a:"Call the aciObjectParamSetInt function to set the contents of an integer parameter.  Syntax aciError aciObjectParamSetInt(\n   t_aciObject* pObject, \n   char* szName, \n   int nValue) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA object that contains an XML ...",t:"aciObjectParamSetInt"},"59":{i:0.00730059170319463,u:"../Content/C/aciObjectParamSetLon.htm",a:"Call the aciObjectParamSetLong function to set the contents of a long integer parameter.  Syntax aciError aciObjectParamSetLong (\n   t_aciObject* pObject, \n   char* szName, \n   long lnValue); Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA object that contains an ...",t:"aciObjectParamSetLong"},"60":{i:0.00730059170319463,u:"../Content/C/aciObjectParamSetStr.htm",a:"Call the aciObjectParamSetString function to set the contents of a string parameter.  Syntax aciError aciObjectParamSetString (    t_aciObject* pObject,    char* szName,    char* szValue); Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA object that contains an XML ...",t:"aciObjectParamSetString"},"61":{i:0.00730059170319463,u:"../Content/C/aciObjectParamSetStringB.htm",a:"Call the aciObjectParamSetStringB function to set the contents of a binary data parameter with a length. Syntax aciError aciObjectParamSetStringB (\n   t_aciObject* pObject,\n   size_t nLength,\n   const char *szName,\n   const char *szValue); Arguments Arguments Type/Description pObject t_aciObject*  A ...",t:"aciObjectParamSetStringB"},"62":{i:0.00730059170319463,u:"../Content/C/aciObjectParamSetStringN.htm",a:"Call the aciObjectParamSetStringN function to set the contents of a string parameter with a length. Syntax aciError aciObjectParamSetStringN (\n   t_aciObject* pObject,\n   int nLength\n   const char *szName,\n   const char *szValue); Arguments Arguments Type/Description pObject t_aciObject*  A pointer ...",t:"aciObjectParamSetStringN"},"63":{i:0.00730059170319463,u:"../Content/C/aciObjectParamSetUns.htm",a:"Call the aciObjectParamSetUnsignedInt function to set the contents of an unsigned integer parameter.  Syntax aciError aciObjectParamSetUnsignedInt(\n   t_aciObject* pObject,\n   const char* szName,\n   unsigned int nValue) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ...",t:"aciObjectParamSetUnsignedInt"},"64":{i:0.00730059170319463,u:"../Content/C/aciObjectParentEntry.htm",a:"Call the aciObjectParentEntry function to return a pointer to the parent entry of the object. Syntax t_aciObject* aciObjectParentEntry(\n   t_aciObject* pObject) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA object that contains an XML result. Discussion This ...",t:"aciObjectParentEntry"},"65":{i:0.00730059170319463,u:"../Content/C/aciObjectResponseToS.htm",a:"Call the aciObjectResponseToStringArray function to return all the values of a tag in an ACI response object. Syntax aciError aciObjectResponseToStringArray(\n   t_aciObject *pResponse,\n   char *szTagName,\n   char *szNumberName,\n   char ***paszValues,\n   long *plnValues ); Arguments Arguments ...",t:"aciObjectResponseToStringArray"},"66":{i:0.00730059170319463,u:"../Content/C/aciObjectSetSecurity.htm",a:"Call the aciObjectSetSecurityKeys function to specify the security keys for communication with an ACI server. Syntax aciObjectSetSecurityKeys (    t_aciObject* pObject,    int nKey1,    int nKey2,    int nKey3,    int nKey4) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ...",t:"aciObjectSetSecurityKeys"},"67":{i:0.00730059170319463,u:"../Content/C/aciObjectSetUserSecu.htm",a:"Call the aciObjectSetUserSecurityInfo function to set the user-level security for documents in a repository. Syntax aciObjectSetUserSecurityInfo (\n   t_aciObject* pObject,\n   char* szRepository,\n   char* szName,\n   char* szValue) Arguments Arguments Type/Description pObject t_aciObject*  A pointer ...",t:"aciObjectSetUserSecurityInfo"},"68":{i:0.00730059170319463,u:"../Content/C/aciObjectToString.htm",a:"Call the aciObjectToString function to print an ACI object. Syntax void aciObjectToString (\n   t_aciObject* pObject) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI object. Discussion This function prints a string representation of the ACI object to the standard ...",t:"aciObjectToString"},"69":{i:0.00730059170319463,u:"../Content/C/aciObjectToXMLString.htm",a:"Call the aciObjectToXMLString function to convert an object into an XML-formatted string. Syntax char* aciObjectToXMLString (\n   t_aciObject* pObject) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI object. Returns The ACI object as a string containing XML formatting.",t:"aciObjectToXMLString"},"70":{i:0.00730059170319463,u:"../Content/C/aciObjectToXMLStringNoF.htm",a:"Call the aciObjectToXMLStringNoFormat function to convert an object into an XML string without newlines or tabs formatting. Syntax char* aciObjectToXMLStringNoFormat(\n   t_aciObject* pObject) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI object. Discussion This ...",t:"aciObjectToXMLStringNoFormat"},"71":{i:0.00730059170319463,u:"../Content/C/acioFindFirstEnclose.htm",a:"Call the acioFindFirstEnclosedOccurrenceFromRoot function to locate the first occurrence of the specified tag in an XML result from the immediate children. Syntax t_aciObject* acioFindFirstEnclosedOccurrenceFromRoot(\n   t_aciObject* pObject, \n   const char* szTag) Arguments Arguments ...",t:"acioFindFirstEnclosedOccurrenceFromRoot"},"72":{i:0.00730059170319463,u:"../Content/C/acioFindFirstOccurre.htm",a:"Call the acioFindFirstOccurrence function to locate the first occurrence of the specified tag in an XML result. Syntax t_aciObject* acioFindFirstOccurrence (\n   t_aciObject* pObject, \n   char* szTag) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA object that is ...",t:"acioFindFirstOccurrence"},"73":{i:0.00730059170319463,u:"../Content/C/acioFindFirstOccurreFromRoot.htm",a:"Call the acioFindFirstOccurrenceFromRoot function to locate the first occurrence of the specified tag in an XML result. Syntax t_aciObject* acioFindFirstOccurrenceFromRoot (\n   t_aciObject* pObject, \n   char* szTag) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to an ACI_DATA ...",t:"acioFindFirstOccurrenceFromRoot"},"74":{i:0.00730059170319463,u:"../Content/C/acioGetErrorDescript.htm",a:"Call the acioGetErrorDescription function to return an error description. Syntax onst char* acioGetErrorDescription(\n   aciError nError); Arguments Arguments Type/Description nError aciError  An ACI error code. Discussion This function returns an error description of the error code nError. Returns ...",t:"acioGetErrorDescription"},"75":{i:0.00730059170319463,u:"../Content/C/acioGetFirstVariable.htm",a:"Call the acioGetFirstVariable function to access the parameter list of an ACI object. Syntax t_aciObjectVariable* acioGetFirstVariable(\n   t_aciObject* pObject) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to the ACI object. Discussion This function accesses the parameter ...",t:"acioGetFirstVariable"},"76":{i:0.00730059170319463,u:"../Content/C/acioGetName.htm",a:"acioGetName Call the acioGetName function to obtain the name of an ACI object. Syntax char* acioGetName (\n   t_aciObject* pObject) Arguments Arguments Type/Description pObject t_aciObject*  A pointer to the ACI object whose name you want to obtain. Returns A pointer to the name of the ACI object.",t:"acioGetName"},"77":{i:0.00730059170319463,u:"../Content/C/acioGetNextVariable.htm",a:"Call the acioGetNextVariable function to access the next variable (parameter) in the list after the one passed in. Syntax t_aciObjectVariable* acioGetNextVariable(\n   t_aciObjectVariable* pVariable) Arguments Arguments Type/Description pVariable t_aciObjectVariable*  A pointer to an ACI object ...",t:"acioGetNextVariable"},});