define({"416":{i:0.00135750995882586,u:"../Content/Lua/General/_LUA_get_log2.htm",a:"get_log The get_log method returns a  LuaLog  object that provides the capability to write messages to a specified log type. Syntax get_log( log_type ) Arguments Returns (LuaLog). A  LuaLog  object. Example local log = get_log(\"application\")\nlog:write_line(log_level_normal(), \"doing something...\")",t:"get_log"},"417":{i:0.000382488282963672,u:"../Content/Lua/General/_LUA_get_log_service.htm",a:"The get_log_service function obtains a  LuaLogService  object, from which you can obtain a  LuaLog  object that you can use to write messages to a log file. To obtain a LuaLog object for writing to a standard log stream, call the function without any arguments or use the function  get_log  instead. ...",t:"get_log_service"},"418":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_getcwd.htm",a:"getcwd The getcwd method returns the current working directory of the application. Syntax getcwd() Returns (String). Returns a string containing the absolute path of the current working directory.",t:"getcwd"},"419":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_gobble_whitespace.htm",a:"gobble_whitespace The gobble_whitespace method reduces multiple adjacent white spaces (tabs, carriage returns, spaces, and so on) in the specified string to a single space. Syntax gobble_whitespace( input ) Arguments Returns (String). A string without adjacent white spaces.",t:"gobble_whitespace"},"420":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_hash_file.htm",a:"hash_file The hash_file method hashes the contents of the specified file using the SHA1 or MD5 algorithm. Syntax hash_file( FileName, Algorithm ) Arguments Returns (String). A hash of the file contents.",t:"hash_file"},"421":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_hash_string.htm",a:"hash_string The hash_string method hashes the specified string using the SHA1 or MD5 algorithm. Syntax hash_string( StringToHash, Algorithm ) Arguments Returns (String). The hashed input string.",t:"hash_string"},"422":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_is_dir.htm",a:"is_dir The is_dir method checks if the supplied path is a directory. Syntax is_dir( path ) Arguments Returns (Boolean). Returns true if the supplied path is a directory, false otherwise.",t:"is_dir"},"423":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_log.htm",a:"log The log method appends log messages to the specified file. Syntax log( file, message ) Arguments",t:"log"},"424":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_move_file.htm",a:"move_file The move_file method moves a file. Syntax move_file( src, dest [, overwrite] ) Arguments Returns (Boolean). Returns true to indicate success, false otherwise.",t:"move_file"},"425":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_parse_csv.htm",a:"The parse_csv method parses a string of comma-separated values into individual strings. The method understands quoted values (such that parsing \u0027foot, \"leg, torso\", elbow\u0027 produces three values) and ignores white space around delimiters. Syntax parse_csv( input [, delimiter ] ) Arguments Returns ...",t:"parse_csv"},"426":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_parse_document_csv.htm",a:"The parse_document_csv function parses a CSV file into documents and calls a function on each document. This function can handle CSV files with or without a header row, but if a header row is not present you must: set the named parameter use_header_row to false. specify the document field names to ...",t:"parse_document_csv"},"427":{i:0.000379598938198304,u:"../Content/Lua/General/_LUA_parse_document_idx.htm",a:"The parse_document_idx function parses an IDX file into documents and calls a function on each document. Syntax parse_document_idx( filename, handler ) Arguments Example The following example uses the parse_document_idx function to parse an IDX file, and calls the function appendDocumentReference on ...",t:"parse_document_idx"},"428":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_parse_document_idx2.htm",a:"The parse_document_idx function parses an IDX string or file, and returns a  LuaDocument . You can use this function if the string or file contains a single document. If you have an IDX file that contains multiple documents you can use the function  parse_document_idx(filename, handler) instead. ...",t:"parse_document_idx"},"429":{i:0.000379598938198304,u:"../Content/Lua/General/_LUA_parse_document_xml.htm",a:"The parse_document_xml function parses an XML file into documents and calls a function on each document. Syntax parse_document_xml( filename, handler [, params ] ) Arguments Named Parameters Example The following example parses an XML file named data.xml, and calls the function printReference on ...",t:"parse_document_xml"},"430":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_parse_document_xml2.htm",a:"The parse_document_xml function parses an XML string or file into a document and returns a LuaDocument. You can use this function if the string or file contains a single document. If you have an XML file that contains multiple documents you can use the function  parse_document_xml(filename, handler ...",t:"parse_document_xml"},"431":{i:0.000497158469852943,u:"../Content/Lua/General/_LUA_parse_json.htm",a:"The parse_json function parses a string of JSON and returns a JSON value. Syntax parse_json( json ) Arguments Returns ( LuaJsonValue ). A LuaJsonValue containing the JSON data. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n\nlocal myJsonValue = ...",t:"parse_json"},"432":{i:0.000407246812599071,u:"../Content/Lua/General/_LUA_parse_json_array.htm",a:"The parse_json_array function parses a string and returns a JSON array. Syntax parse_json_array( json ) Arguments Returns ( LuaJsonArray ). A LuaJsonArray containing the JSON data. See Also If you can\u0027t be sure whether the input data is a JSON array, you can use the function  parse_json  to parse ...",t:"parse_json_array"},"433":{i:0.000407246812599071,u:"../Content/Lua/General/_LUA_parse_json_object.htm",a:"The parse_json_object function parses a string and returns a JSON object. Syntax parse_json_object( json ) Arguments Returns ( LuaJsonObject ). A LuaJsonObject containing the JSON data. See Also If you can\u0027t be sure whether the input data is a JSON object, you can use the function  parse_json  to ...",t:"parse_json_object"},"434":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_parse_xml.htm",a:"The parse_xml method parses an XML string to a LuaXmlDocument. The following character encodings are supported. If the XML uses a different character encoding, you can use the function  convert_encoding  to convert the encoding before parsing the XML. UTF-8 UTF-16 ISO-Latin-1 (ISO-8859-1) ASCII ...",t:"parse_xml"},"435":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_regex_match.htm",a:"The regex_match method performs a regular expression match on a string. Syntax regex_match( input, regex [, case] ) Arguments Returns One or more strings, or nil. If the string matches the regular expression, and the regular expression has no sub-matches, the full string is returned. If the string ...",t:"regex_match"},"436":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_regex_replace_all.htm",a:"The regex_replace_all method searches a string for matches to a regular expression, and replaces the matches according to the value specified by the replacement argument. Syntax regex_replace_all( input, regex, replacement ) Arguments Returns (String). The modified string. Examples ...",t:"regex_replace_all"},"437":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_regex_search.htm",a:"regex_search The regex_search method performs a regular expression search on a string. This method returns a LuaRegexMatch object, rather than strings. Syntax regex_search ( input, regex [, case]) Arguments Returns (LuaRegexMatch).",t:"regex_search"},"438":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_script_path.htm",a:"The script_path function returns the path and file name of the script that is running. Syntax script_path() Returns (String, String) Returns the path of the folder that contains the script and the file name of the script, as separate strings. Example local script_directory, script_filename = ...",t:"script_path"},"439":{i:0.00259118037672688,u:"../Content/Lua/General/_LUA_send_aci_action.htm",a:"The send_aci_action method sends a query to an ACI server. This method takes the action parameters as a table instead of the full action as a string, as with send_aci_command. This avoids issues with parameter values containing an ampersand (\u0026). Syntax send_aci_action( host, port, action [, ...",t:"send_aci_action"},"440":{i:0.00247006516362927,u:"../Content/Lua/General/_LUA_send_aci_command.htm",a:"The send_aci_command method sends a query to an ACI server. Syntax send_aci_command( host, port, query [, timeout] [, retries] [, sslParameters] ) Arguments Returns (String). Returns the XML response as a string. If required, you can call parse_xml on the string to return a LuaXmlDocument. If the ...",t:"send_aci_command"},"441":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_send_and_wait_for_async_aci_action.htm",a:"The send_and_wait_for_async_aci_action method sends a query to an ACI server. The method does not return until the action has completed. You might use this method when you want to use an asynchronous action. The send_aci_action method returns as soon as it receives a response, which for an ...",t:"send_and_wait_for_async_aci_action"},"442":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_sleep.htm",a:"sleep The sleep method pauses the thread. Syntax sleep( milliseconds ) Arguments",t:"sleep"},"443":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_unzip_file.htm",a:"unzip_file The unzip_file method extracts the contents of a zip file. Syntax unzip_file( path, dest ) Arguments Returns (Boolean). Returns a Boolean indicating success or failure.",t:"unzip_file"},"444":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_url_escape.htm",a:"url_escape The url_escape method percent-encodes a string. Syntax url_escape( input ) Arguments Returns (String). The percent-encoded string.",t:"url_escape"},"445":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_url_unescape.htm",a:"url_unescape The url_unescape method replaces URL escaped characters and returns a standard string. Syntax url_unescape( input ) Arguments Returns (String). The modified string.",t:"url_unescape"},"446":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_xml_encode.htm",a:"xml_encode The xml_encode method takes a string and encodes it using XML escaping. Syntax xml_encode ( content ) Arguments Returns (String).",t:"xml_encode"},"447":{i:0.000266385195996215,u:"../Content/Lua/General/_LUA_zip_file.htm",a:"The zip_file method zips the supplied path (file or directory). It overwrites the output file only if you set the optional overwrite argument to true. Syntax zip_file( path [, overwrite] ) Arguments Returns (Boolean). Returns a Boolean indicating success or failure. On success writes a file called ...",t:"zip_file"},"448":{i:0.000262018224287826,u:"../Content/Lua/LuaConfig/_LUA_LuaConfig_Methods.htm",a:"A LuaConfig object provides access to configuration information. You can retrieve a LuaConfig for a given configuration file using the get_config function. If you have a LuaConfig object called config you can call its methods using the \u0027:\u0027 operator. For example: config:getValue(sectionName, ...",t:"LuaConfig Methods"},"449":{i:0.000317697113569785,u:"../Content/Lua/LuaConfig/_LUA_getEncryptedValue.htm",a:"getEncryptedValue The getEncryptedValue method returns the unencrypted value from the configuration file of an encrypted value. Syntax getEncryptedValue( section, parameter ) Arguments Returns (String). The unencrypted value.",t:"getEncryptedValue"},"450":{i:0.000317697113569785,u:"../Content/Lua/LuaConfig/_LUA_getValue.htm",a:"The getValue method returns the value of the configuration parameter key in a given section. If the key does not exist in the section, then it returns the default value. Syntax getValue( section, key [, default] ) Arguments Returns A string, boolean, or integer containing the value read from the ...",t:"getValue"},"451":{i:0.000317697113569785,u:"../Content/Lua/LuaConfig/_LUA_getValues.htm",a:"The getValues method returns multiple values for a parameter (for example, a comma-separated list or numbered list like keyN). Syntax getValues( section, parameter ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call ...",t:"getValues"},"452":{i:0.000571580434973101,u:"../Content/Lua/LuaConfig/_LUA_LuaConfig_new.htm",a:"LuaConfig:new The constructor for a LuaConfig object (creates a new LuaConfig object). Syntax LuaConfig:new( config_buffer ) Arguments Returns (LuaConfig). The new LuaConfig object. Example local config_buffer = \"[default]\\nparameter=value\"\nlocal config = LuaConfig:new(config_buffer)",t:"LuaConfig:new"},"453":{i:0.000488445708692004,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_Methods.htm",a:"This section describes the methods provided by the LuaDocument object. A LuaDocument allows you to access and modify the reference, metadata and content of a document. If you have a LuaDocument object called document you can call its methods using the \u0027:\u0027 operator. For example: ...",t:"LuaDocument Methods"},"454":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_addField.htm",a:"addField The addField method adds a new field to the document. Syntax addField ( fieldname, fieldvalue ) Arguments",t:"addField"},"455":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_addSection.htm",a:"The addSection method adds an empty section to the end of the document. Syntax addSection() Returns (LuaDocument). Returns a LuaDocument object representing the document, with the new section as the active section. Example local newSection = document:addSection()   -- Add a new section to the ...",t:"addSection"},"456":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_appendContent.htm",a:"The appendContent method appends content to the existing content (the DRECONTENT field) of a document  or document section. Syntax appendContent ( content [, number]) Arguments Examples \n-- Append content to the last section\ndocument:appendContent(\"content\")\n\n-- Append content to section 7, empty ...",t:"appendContent"},"457":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_copyField.htm",a:"copyField The copyField method copies a field value to a new field. If the target field already exists it is overwritten. Syntax copyField ( sourcename, targetname [, case] ) Arguments",t:"copyField"},"458":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_copyFieldNoOverwrite.htm",a:"The copyFieldNoOverwrite method copies a field value to a new field but does not overwrite the existing value. After calling this function the target field will contain all values of the source field in addition to any values it already had. Syntax copyFieldNoOverwrite( sourcename, targetname [, ...",t:"copyFieldNoOverwrite"},"459":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_countField.htm",a:"countField The countField method returns the number of fields with the specified name. Syntax countField( fieldname [, case] ) Arguments Returns (Number) The number of fields with the specified name.",t:"countField"},"460":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_deleteField.htm",a:"deleteField The deleteField method deletes a field from a document. If you specify the optional value argument, the field is deleted only if has the specified value. Syntax deleteField( fieldName [, case] ) deleteField( fieldName, value [, case] ) Arguments",t:"deleteField"},"461":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_deleteFieldByPath.htm",a:"deleteFieldByPath The deleteFieldByPath method removes all document fields with the specified path. Syntax deleteFieldByPath( path ) Arguments Example document:deleteFieldByPath(\"my/metadata/subfield\")",t:"deleteFieldByPath"},"462":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getContent.htm",a:"The getContent method gets the content (the value of the DRECONTENT field) for a document or document section. Syntax getContent([number]) Arguments Returns (String). The document content as a string. Examples \nlocal content7 = document:getContent(7)     -- Get content for section 7\nlocal section = ...",t:"getContent"},"463":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getField.htm",a:"getField The getField method returns a LuaField object representing the field with the specified name. Syntax getField( name [, case]) Arguments Returns (LuaField). A LuaField object.",t:"getField"},"464":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getFieldNames.htm",a:"getFieldNames The getFieldNames method returns all of the field names for the document. Syntax getFieldNames() Returns (Strings) The names of the fields. To map the return values to a table, surround the function call with braces. For example: names = { document:getFieldNames() }",t:"getFieldNames"},"465":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getFields.htm",a:"The getFields method returns LuaField objects where each object represents a field that matches the specified name. Syntax getFields( name [, case]) Arguments Returns (LuaFields) One LuaField for each matching field. To map the return values to a table, surround the function call with braces. For ...",t:"getFields"},"466":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getFieldsByRegex.htm",a:"The getFieldsByRegex method returns all document fields where the field name or path matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField represents a matching ...",t:"getFieldsByRegex"},"467":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getFieldValue.htm",a:"getFieldValue The getFieldValue method gets the value of a field in a document. To return the values of a multi-value field, see  getFieldValues . Syntax getFieldValue( fieldname [, case]) Arguments Returns (String). A string containing the value.",t:"getFieldValue"},"468":{i:0.000506069372232031,u:"../Content/Lua/LuaDocument/_LUA_getFieldValues.htm",a:"The getFieldValues method gets all values from all fields that have the same name. Syntax getFieldValues( fieldname [, case]) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ...",t:"getFieldValues"},"469":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getNextSection.htm",a:"The getNextSection method returns the next section of a document (if the document has been divided into sections). The document object passed to the script\u0027s handler function represents the first section of the document. This means that the methods described in this section read and modify only the ...",t:"getNextSection"},"470":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getReference.htm",a:"getReference The getReference method returns a string containing the reference (the value of the DREREFERENCE document field). Syntax getReference() Returns (String). A string containing the reference.",t:"getReference"},"471":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getSection.htm",a:"The getSection method returns a LuaDocument object with the specified section as the active section. Syntax getSection(number) Arguments Returns (LuaDocument). A LuaDocument object with the specified section as the active section. Example -- Get object for section 7 of document\nlocal section = ...",t:"getSection"},"472":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getSectionCount.htm",a:"getSectionCount The getSectionCount method returns the number of sections in a document. Syntax getSectionCount() Returns (Number). The number of sections. Example local sectionCount = document:getSectionCount()",t:"getSectionCount"},"473":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_getValueByPath.htm",a:"The getValueByPath method gets the value of a document field.  The field is specified by its path, which means that you can get the value of a sub field. If you pass this method the path of a multi-value field, only the first value is returned. To return all of the values from a multi-value field, ...",t:"getValueByPath"},"474":{i:0.000506069372232031,u:"../Content/Lua/LuaDocument/_LUA_getValuesByPath.htm",a:"The getValuesByPath method gets all values of a document field. The field is specified by its path, which means that you can get values from a sub field. Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the ...",t:"getValuesByPath"},"475":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_hasField.htm",a:"hasField The hasField method checks to see if a field exists in the current document. Syntax hasField ( fieldname [, case]) Arguments Returns (Boolean). True if the field exists, false otherwise.",t:"hasField"},"476":{i:0.00035031360354046,u:"../Content/Lua/LuaDocument/_LUA_insertJson.htm",a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into a document. Syntax insertJson ( json [, fieldName] ) Arguments Example The following example Lua script uses the insertJson method to add metadata to a document: function handler(document)\n  local ...",t:"insertJson"},"477":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_insertXml.htm",a:"insertXml The insertXml method inserts XML metadata into the document. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data.",t:"insertXml"},"478":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_insertXmlWithoutRoot.htm",a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ...",t:"insertXmlWithoutRoot"},"479":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_new.htm",a:"The constructor for a LuaDocument object (creates a new LuaDocument object that only contains a reference). Syntax LuaDocument:new( reference ) Arguments Returns (LuaDocument). The new LuaDocument object. Example local reference = \"my_reference\"\nlocal document = LuaDocument:new(reference)",t:"LuaDocument:new"},"480":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_removeSection.htm",a:"The removeSection method removes a section from a document. Syntax removeSection( sectionNumber ) Arguments Returns Nothing. Example \n-- Example that removes the last section of a document\nif document:getSectionCount() \u003e 0 then\n   local lastSection = document:getSectionCount() - 1\n   ...",t:"removeSection"},"481":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_renameField.htm",a:"renameField The renameField method changes the name of a field. Syntax renameField( currentname, newname [, case]) Arguments",t:"renameField"},"482":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_setContent.htm",a:"The setContent method sets the content (the value of the DRECONTENT field) for a document or document section. Syntax setContent( content [, number] ) Arguments Examples \n-- Set content for section 0\ndocument:setContent(\"content0\")\n\n-- Get document for section 1\nlocal section = ...",t:"setContent"},"483":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_setFieldValue.htm",a:"setFieldValue The setFieldValue method sets the value of a field in a document. If the field does not exist, it is created. If the field already exists, the existing value is overwritten. Syntax setFieldValue( fieldname, newvalue ) Arguments",t:"setFieldValue"},"484":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_setReference.htm",a:"setReference The setReference method sets the reference (the value of the DREREFERENCE document field) to the string passed in. Syntax setReference( reference ) Arguments",t:"setReference"},"485":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_to_IDX.htm",a:"to_idx The to_idx method returns a string containing the document in IDX format. Syntax to_idx() Returns (String). Returns the document as a string.",t:"to_idx"},"486":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_to_JSON.htm",a:"to_json The to_json method returns a string containing the document in JSON format. Syntax to_json() Returns (String). Returns the document as a string.",t:"to_json"},"487":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_to_XML.htm",a:"to_xml The to_xml method returns a string containing the document in XML format. Syntax to_xml() Returns (String). Returns the document as a string.",t:"to_xml"},"488":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_writeStubIdx.htm",a:"The writeStubIdx method writes out a stub IDX document (a metadata file used by IDOL applications). The file is created in the current folder, but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubIdx( filename ) Arguments Returns (Boolean). ...",t:"writeStubIdx"},"489":{i:0.000273550973949935,u:"../Content/Lua/LuaDocument/_LUA_writeStubXml.htm",a:"The writeStubXml method writes out an XML file containing the metadata for the document. The file is created in the current folder but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubXml( filename ) Arguments Returns (Boolean) True if ...",t:"writeStubXml"},"490":{i:0.000262018224287826,u:"../Content/Lua/LuaField/_LUA_LuaField_Methods.htm",a:"This section describes the methods provided by LuaField objects. A LuaField represents a single field in a document. You can retrieve LuaField objects for a document using the LuaDocument getField and getFields methods. In its simplest form a field has just a name and a value, but it can also ...",t:"LuaField Methods"},"491":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_addField.htm",a:"addField The addField method adds a sub field with the specified name and value. Syntax addField( fieldname, fieldvalue ) Arguments",t:"addField"},"492":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_copyField.htm",a:"copyField The copyField method copies a sub field to another sub field. If the target sub field exists it is overwritten. Syntax copyField ( from, to [, case]) Arguments",t:"copyField"},"493":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_copyFieldNoOverwrite.htm",a:"The copyFieldNoOverwrite method copies the sub field to another sub field but does not overwrite the destination. After this operation the destination field contains all the values of the source field as well as any values it already had. Syntax copyFieldNoOverwrite( from, to [, case]) Arguments",t:"copyFieldNoOverwrite"},"494":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_countField.htm",a:"countField The countField method returns the number of sub fields that exist with the specified name. Syntax countField ( fieldname [, case]) Arguments Returns (Number). The number of sub fields that exist with the specified name.",t:"countField"},"495":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_deleteAttribute.htm",a:"deleteAttribute The deleteAttribute method deletes the specified field attribute. Syntax deleteAttribute( name ) Arguments",t:"deleteAttribute"},"496":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_deleteField.htm",a:"deleteField The deleteField method deletes the sub field with the specified name. Syntax deleteField( name [, case] )  deleteField( name , value [, case] )  Arguments",t:"deleteField"},"497":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_deleteFieldByPath.htm",a:"deleteFieldByPath The deleteFieldByPath method removes the sub field(s) with the specified path. Syntax deleteFieldByPath( path ) Arguments Example myField:deleteFieldByPath(\"path/to/subfield\")",t:"deleteFieldByPath"},"498":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_getAttributeValue.htm",a:"getAttributeValue The getAttributeValue method gets the value of the specified attribute. Syntax getAttributeValue( name ) Arguments Returns (String). The attribute value.",t:"getAttributeValue"},"499":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_getField.htm",a:"getField The getField method returns the specified sub field. Syntax getField ( name [, case]) Arguments Returns (LuaField) A LuaField object.",t:"getField"},"500":{i:0.000270926846572939,u:"../Content/Lua/LuaField/_LUA_getFieldNames.htm",a:"The getFieldNames method returns the names of the sub fields in the LuaField object. Syntax getFieldNames() Returns (Strings). The names of the sub fields. The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: fieldnames = { ...",t:"getFieldNames"},});