define({"628":{y:0,u:"../Content/Lua/LuaConfig/_LUA_getValues.htm",l:-1,t:"getValues",i:0.000512186593433313,a:"The getValues method returns multiple values for a parameter (for example, a comma-separated list or numbered list like keyN). Syntax getValues( section, parameter ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call ..."},"629":{y:0,u:"../Content/Lua/LuaConfig/_LUA_LuaConfig_new.htm",l:-1,t:"LuaConfig:new",i:0.000867760944162035,a:"LuaConfig:new The constructor for a LuaConfig object (creates a new LuaConfig object). Syntax LuaConfig:new( config_buffer ) Arguments Returns (LuaConfig). The new LuaConfig object. Example local config_buffer = \"[default]\\nparameter=value\"\nlocal config = LuaConfig:new(config_buffer)"},"630":{y:0,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_Methods.htm",l:-1,t:"LuaDocument Methods",i:0.000577911651184325,a:"This section describes the methods provided by the LuaDocument object. A LuaDocument allows you to access and modify the reference, metadata and content of a document. If you have a LuaDocument object called document you can call its methods using the \u0027:\u0027 operator. For example: ..."},"631":{y:0,u:"../Content/Lua/LuaDocument/_LUA_addField.htm",l:-1,t:"addField",i:0.000380612570919474,a:"addField The addField method adds a new field to the document. Syntax addField ( fieldname, fieldvalue ) Arguments Returns (LuaField) A LuaField object representing the new field."},"632":{y:0,u:"../Content/Lua/LuaDocument/_LUA_addSection.htm",l:-1,t:"addSection",i:0.000380612570919474,a:"The addSection method adds an empty section to the end of the document. Syntax addSection() Returns (LuaDocument). Returns a LuaDocument object representing the document, with the new section as the active section. Example local newSection = document:addSection()   -- Add a new section to the ..."},"633":{y:0,u:"../Content/Lua/LuaDocument/_LUA_appendContent.htm",l:-1,t:"appendContent",i:0.000380612570919474,a:"The appendContent method appends content to the existing content (the DRECONTENT field) of a document  or document section. Syntax appendContent ( content [, number]) Arguments Examples \n-- Append content to the last section\ndocument:appendContent(\"content\")\n\n-- Append content to section 7, empty ..."},"634":{y:0,u:"../Content/Lua/LuaDocument/_LUA_copyField.htm",l:-1,t:"copyField",i:0.000380612570919474,a:"copyField The copyField method copies a field value to a new field. If the target field already exists it is overwritten. Syntax copyField ( sourcename, targetname [, case] ) Arguments"},"635":{y:0,u:"../Content/Lua/LuaDocument/_LUA_copyFieldNoOverwrite.htm",l:-1,t:"copyFieldNoOverwrite",i:0.000380612570919474,a:"The copyFieldNoOverwrite method copies a field value to a new field but does not overwrite the existing value. After calling this function the target field will contain all values of the source field in addition to any values it already had. Syntax copyFieldNoOverwrite( sourcename, targetname [, ..."},"636":{y:0,u:"../Content/Lua/LuaDocument/_LUA_countField.htm",l:-1,t:"countField",i:0.000380612570919474,a:"countField The countField method returns the number of fields with the specified name. Syntax countField( fieldname [, case] ) Arguments Returns (Number) The number of fields with the specified name."},"637":{y:0,u:"../Content/Lua/LuaDocument/_LUA_deleteField.htm",l:-1,t:"deleteField",i:0.000380612570919474,a:"deleteField The deleteField method deletes a field from a document. If you specify the optional value argument, the field is deleted only if has the specified value. Syntax deleteField( fieldName [, case] ) deleteField( fieldName, value [, case] ) Arguments"},"638":{y:0,u:"../Content/Lua/LuaDocument/_LUA_deleteFieldByPath.htm",l:-1,t:"deleteFieldByPath",i:0.000380612570919474,a:"deleteFieldByPath The deleteFieldByPath method removes all document fields with the specified path. Syntax deleteFieldByPath( path ) Arguments Example document:deleteFieldByPath(\"my/metadata/subfield\")"},"639":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getContent.htm",l:-1,t:"getContent",i:0.000380612570919474,a:"The getContent method gets the content (the value of the DRECONTENT field) for a document or document section. Syntax getContent([number]) Arguments Returns (String). The document content as a string. Examples \nlocal content7 = document:getContent(7)     -- Get content for section 7\nlocal section = ..."},"640":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getField.htm",l:-1,t:"getField",i:0.000380612570919474,a:"getField The getField method returns a LuaField object representing the field with the specified name. Syntax getField( name [, case]) Arguments Returns (LuaField). A LuaField object."},"641":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldNames.htm",l:-1,t:"getFieldNames",i:0.000380612570919474,a:"getFieldNames The getFieldNames method returns all of the field names for the document. Syntax getFieldNames() Returns (Strings) The names of the fields. To map the return values to a table, surround the function call with braces. For example: names = { document:getFieldNames() }"},"642":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFields.htm",l:-1,t:"getFields",i:0.000380612570919474,a:"The getFields method returns LuaField objects where each object represents a field that matches the specified name. Syntax getFields( name [, case]) Arguments Returns (LuaFields) One LuaField for each matching field. To map the return values to a table, surround the function call with braces. For ..."},"643":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldsByRegex.htm",l:-1,t:"getFieldsByRegex",i:0.000380612570919474,a:"The getFieldsByRegex method returns all document fields where the field name or path matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField represents a matching ..."},"644":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldValue.htm",l:-1,t:"getFieldValue",i:0.000380612570919474,a:"getFieldValue The getFieldValue method gets the value of a field in a document. To return the values of a multi-value field, see  getFieldValues . Syntax getFieldValue( fieldname [, case]) Arguments Returns (String). A string containing the value."},"645":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldValues.htm",l:-1,t:"getFieldValues",i:0.000704133495654958,a:"The getFieldValues method gets all values from all fields that have the same name. Syntax getFieldValues( fieldname [, case]) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ..."},"646":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getNextSection.htm",l:-1,t:"getNextSection",i:0.000380612570919474,a:"The getNextSection method returns the next section of a document (if the document has been divided into sections). The document object passed to the script\u0027s handler function represents the first section of the document. This means that the methods described in this section read and modify only the ..."},"647":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getReference.htm",l:-1,t:"getReference",i:0.000380612570919474,a:"getReference The getReference method returns a string containing the reference (the value of the DREREFERENCE document field). Syntax getReference() Returns (String). A string containing the reference."},"648":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getSection.htm",l:-1,t:"getSection",i:0.000380612570919474,a:"The getSection method returns a LuaDocument object with the specified section as the active section. Syntax getSection(number) Arguments Returns (LuaDocument). A LuaDocument object with the specified section as the active section. Example -- Get object for section 7 of document\nlocal section = ..."},"649":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getSectionCount.htm",l:-1,t:"getSectionCount",i:0.000380612570919474,a:"getSectionCount The getSectionCount method returns the number of sections in a document. Syntax getSectionCount() Returns (Number). The number of sections. Example local sectionCount = document:getSectionCount()"},"650":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getValueByPath.htm",l:-1,t:"getValueByPath",i:0.000380612570919474,a:"The getValueByPath method gets the value of a document field.  The field is specified by its path, which means that you can get the value of a sub field. If you pass this method the path of a multi-value field, only the first value is returned. To return all of the values from a multi-value field, ..."},"651":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getValuesByPath.htm",l:-1,t:"getValuesByPath",i:0.000704133495654958,a:"The getValuesByPath method gets all values of a document field. The field is specified by its path, which means that you can get values from a sub field. Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the ..."},"652":{y:0,u:"../Content/Lua/LuaDocument/_LUA_hasField.htm",l:-1,t:"hasField",i:0.000380612570919474,a:"hasField The hasField method checks to see if a field exists in the current document. Syntax hasField ( fieldname [, case]) Arguments Returns (Boolean). True if the field exists, false otherwise."},"653":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertJson.htm",l:-1,t:"insertJson",i:0.000488121875538457,a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into a document. Syntax insertJson ( json [, fieldName] ) Arguments Example The following example Lua script uses the insertJson method to add metadata to a document: function handler(document)\n  local ..."},"654":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertXml.htm",l:-1,t:"insertXml",i:0.000380612570919474,a:"insertXml The insertXml method inserts XML metadata into the document. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data."},"655":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertXmlWithoutRoot.htm",l:-1,t:"insertXmlWithoutRoot",i:0.000380612570919474,a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ..."},"656":{y:0,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_new.htm",l:-1,t:"LuaDocument:new",i:0.000380612570919474,a:"The constructor for a LuaDocument object (creates a new LuaDocument object that only contains a reference). Syntax LuaDocument:new( reference ) Arguments Returns (LuaDocument). The new LuaDocument object. Example local reference = \"my_reference\"\nlocal document = LuaDocument:new(reference)"},"657":{y:0,u:"../Content/Lua/LuaDocument/_LUA_removeSection.htm",l:-1,t:"removeSection",i:0.000380612570919474,a:"The removeSection method removes a section from a document. Syntax removeSection( sectionNumber ) Arguments Returns Nothing. Example \n-- Example that removes the last section of a document\nif document:getSectionCount() \u003e 0 then\n   local lastSection = document:getSectionCount() - 1\n   ..."},"658":{y:0,u:"../Content/Lua/LuaDocument/_LUA_renameField.htm",l:-1,t:"renameField",i:0.000380612570919474,a:"renameField The renameField method changes the name of a field. Syntax renameField( currentname, newname [, case]) Arguments"},"659":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setContent.htm",l:-1,t:"setContent",i:0.000380612570919474,a:"The setContent method sets the content (the value of the DRECONTENT field) for a document or document section. Syntax setContent( content [, number] ) Arguments Examples \n-- Set content for section 0\ndocument:setContent(\"content0\")\n\n-- Get document for section 1\nlocal section = ..."},"660":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setFieldValue.htm",l:-1,t:"setFieldValue",i:0.000380612570919474,a:"setFieldValue The setFieldValue method sets the value of a field in a document. If the field does not exist, it is created. If the field already exists, the existing value is overwritten. Syntax setFieldValue( fieldname, newvalue ) Arguments"},"661":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setReference.htm",l:-1,t:"setReference",i:0.000380612570919474,a:"setReference The setReference method sets the reference (the value of the DREREFERENCE document field) to the string passed in. Syntax setReference( reference ) Arguments"},"662":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_IDX.htm",l:-1,t:"to_idx",i:0.000380612570919474,a:"to_idx The to_idx method returns a string containing the document in IDX format. Syntax to_idx() Returns (String). Returns the document as a string."},"663":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_JSON.htm",l:-1,t:"to_json",i:0.000380612570919474,a:"to_json The to_json method returns a string containing the document in JSON format. Syntax to_json() Returns (String). Returns the document as a string."},"664":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_XML.htm",l:-1,t:"to_xml",i:0.000380612570919474,a:"to_xml The to_xml method returns a string containing the document in XML format. Syntax to_xml() Returns (String). Returns the document as a string."},"665":{y:0,u:"../Content/Lua/LuaDocument/_LUA_writeStubIdx.htm",l:-1,t:"writeStubIdx",i:0.000380612570919474,a:"The writeStubIdx method writes out a stub IDX document (a metadata file used by IDOL applications). The file is created in the current folder, but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubIdx( filename ) Arguments Returns (Boolean). ..."},"666":{y:0,u:"../Content/Lua/LuaDocument/_LUA_writeStubXml.htm",l:-1,t:"writeStubXml",i:0.000380612570919474,a:"The writeStubXml method writes out an XML file containing the metadata for the document. The file is created in the current folder but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubXml( filename ) Arguments Returns (Boolean) True if ..."},"667":{y:0,u:"../Content/Lua/LuaField/_LUA_LuaField_Methods.htm",l:-1,t:"LuaField Methods",i:0.000366967423741223,a:"This section describes the methods provided by LuaField objects. A LuaField represents a single field in a document. You can retrieve LuaField objects for a document using the LuaDocument getField and getFields methods. In its simplest form a field has just a name and a value, but it can also ..."},"668":{y:0,u:"../Content/Lua/LuaField/_LUA_addField.htm",l:-1,t:"addField",i:0.0003794443252498,a:"addField The addField method adds a sub field with the specified name and value. Syntax addField( fieldname, fieldvalue ) Arguments Returns (LuaField) A LuaField object representing the new field."},"669":{y:0,u:"../Content/Lua/LuaField/_LUA_copyField.htm",l:-1,t:"copyField",i:0.0003794443252498,a:"copyField The copyField method copies a sub field to another sub field. If the target sub field exists it is overwritten. Syntax copyField ( from, to [, case]) Arguments"},"670":{y:0,u:"../Content/Lua/LuaField/_LUA_copyFieldNoOverwrite.htm",l:-1,t:"copyFieldNoOverwrite",i:0.0003794443252498,a:"The copyFieldNoOverwrite method copies the sub field to another sub field but does not overwrite the destination. After this operation the destination field contains all the values of the source field as well as any values it already had. Syntax copyFieldNoOverwrite( from, to [, case]) Arguments"},"671":{y:0,u:"../Content/Lua/LuaField/_LUA_countField.htm",l:-1,t:"countField",i:0.0003794443252498,a:"countField The countField method returns the number of sub fields that exist with the specified name. Syntax countField ( fieldname [, case]) Arguments Returns (Number). The number of sub fields that exist with the specified name."},"672":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteAttribute.htm",l:-1,t:"deleteAttribute",i:0.0003794443252498,a:"deleteAttribute The deleteAttribute method deletes the specified field attribute. Syntax deleteAttribute( name ) Arguments"},"673":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteField.htm",l:-1,t:"deleteField",i:0.0003794443252498,a:"deleteField The deleteField method deletes the sub field with the specified name. Syntax deleteField( name [, case] )  deleteField( name , value [, case] )  Arguments"},"674":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteFieldByPath.htm",l:-1,t:"deleteFieldByPath",i:0.0003794443252498,a:"deleteFieldByPath The deleteFieldByPath method removes the sub field(s) with the specified path. Syntax deleteFieldByPath( path ) Arguments Example myField:deleteFieldByPath(\"path/to/subfield\")"},"675":{y:0,u:"../Content/Lua/LuaField/_LUA_getAttributeValue.htm",l:-1,t:"getAttributeValue",i:0.0003794443252498,a:"getAttributeValue The getAttributeValue method gets the value of the specified attribute. Syntax getAttributeValue( name ) Arguments Returns (String). The attribute value."},"676":{y:0,u:"../Content/Lua/LuaField/_LUA_getField.htm",l:-1,t:"getField",i:0.0003794443252498,a:"getField The getField method returns the specified sub field. Syntax getField ( name [, case]) Arguments Returns (LuaField) A LuaField object."},"677":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldNames.htm",l:-1,t:"getFieldNames",i:0.0003794443252498,a:"The getFieldNames method returns the names of the sub fields in the LuaField object. Syntax getFieldNames() Returns (Strings). The names of the sub fields. The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: fieldnames = { ..."},"678":{y:0,u:"../Content/Lua/LuaField/_LUA_getFields.htm",l:-1,t:"getFields",i:0.0003794443252498,a:"The getFields method returns all of the sub fields specified by the name argument. Syntax getFields( name [, case] ) Arguments Returns (LuaFields) One LuaField per matching field. The objects can be assigned to a table. To map the return values to a table, surround the function call with braces. For ..."},"679":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldsByRegex.htm",l:-1,t:"getFieldsByRegex",i:0.0003794443252498,a:"The getFieldsByRegex method returns all sub fields where the sub field name or path (relative to this field) matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField ..."},"680":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldValues.htm",l:-1,t:"getFieldValues",i:0.0003794443252498,a:"The getFieldValues method returns the values of all of the sub fields with the specified name. Syntax getFieldValues( fieldname [, case] ) Arguments Returns (Strings) One string for each value. The strings can be assigned to a table. To map the return values to a table, surround the function call ..."},"681":{y:0,u:"../Content/Lua/LuaField/_LUA_getValueByPath.htm",l:-1,t:"getValueByPath",i:0.0003794443252498,a:"The getValueByPath method gets the value of a sub-field, specified by path.   If you pass this method the path of a sub-field that has multiple values, only the first value is returned. To return all of the values from a multi-value sub-field, see  getValuesByPath . Syntax getValueByPath( path ) ..."},"682":{y:0,u:"../Content/Lua/LuaField/_LUA_getValuesByPath.htm",l:-1,t:"getValuesByPath",i:0.00070197223910675,a:"The getValuesByPath method gets the values of a sub-field, specified by path.   Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ..."},"683":{y:0,u:"../Content/Lua/LuaField/_LUA_hasAttribute.htm",l:-1,t:"hasAttribute",i:0.0003794443252498,a:"hasAttribute The hasAttribute method returns a Boolean indicating whether the field has the specified attribute. Syntax hasAttribute( name ) Arguments Returns (Boolean). A Boolean specifying if the field has the specified attribute."},"684":{y:0,u:"../Content/Lua/LuaField/_LUA_hasField.htm",l:-1,t:"hasField",i:0.0003794443252498,a:"hasField The hasField method returns a Boolean specifying if the sub field exists. Syntax hasField( fieldname [, case]) Arguments Returns (Boolean). A Boolean specifying if the sub field exists or not."},"685":{y:0,u:"../Content/Lua/LuaField/_LUA_insertJson.htm",l:-1,t:"insertJson",i:0.0003794443252498,a:"insertJson The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into the field. Syntax insertJson ( json [, fieldName] ) Arguments See Also LuaDocument:insertJson"},"686":{y:0,u:"../Content/Lua/LuaField/_LUA_insertXml.htm",l:-1,t:"insertXml",i:0.0003794443252498,a:"insertXml The insertXml method inserts XML metadata into the document. When called on a LuaField, the insertXml method inserts the fields as children of the LuaField. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data."},"687":{y:0,u:"../Content/Lua/LuaField/_LUA_insertXmlWithoutRoot.htm",l:-1,t:"insertXmlWithoutRoot",i:0.0003794443252498,a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ..."},"688":{y:0,u:"../Content/Lua/LuaField/_LUA_name.htm",l:-1,t:"name",i:0.0003794443252498,a:"name The name method returns the name of the field object. Syntax name() Returns (String). The name of the field object."},"689":{y:0,u:"../Content/Lua/LuaField/_LUA_renameField.htm",l:-1,t:"renameField",i:0.0003794443252498,a:"renameField The renameField method renames a sub field. Syntax renameField( oldname, newname [, case] ) Arguments"},"690":{y:0,u:"../Content/Lua/LuaField/_LUA_setAttributeValue.htm",l:-1,t:"setAttributeValue",i:0.0003794443252498,a:"setAttributeValue The setAttributeValue method sets the value for the specified attribute of the field. Syntax setAttributeValue( attribute, value ) Arguments"},"691":{y:0,u:"../Content/Lua/LuaField/_LUA_setValue.htm",l:-1,t:"setValue",i:0.0003794443252498,a:"setValue The setValue method sets the value of the field. Syntax setValue( value ) Arguments"},"692":{y:0,u:"../Content/Lua/LuaField/_LUA_value.htm",l:-1,t:"value",i:0.0003794443252498,a:"value The value method returns the value of the field object. Syntax value() Returns (String). The value of the field object."},"693":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA__LuaHttpRequest.htm",l:-1,t:"LuaHttpRequest Methods",i:0.000483340946111041,a:"This section describes the methods provided by LuaHttpRequest objects. If you have a LuaHttpRequest object called request you can call its methods using the \u0027:\u0027 operator. For example: request:send() Method Description send Sends the HTTP request. set_body Sets the body of the HTTP request. ..."},"694":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_LuaHttpRequest_new.htm",l:-1,t:"LuaHttpRequest:new",i:0.00041832244256276,a:"The constructor for a LuaHttpRequest object (creates a new LuaHttpRequest). Syntax LuaHttpRequest:new( config, section ) Arguments Returns (LuaHttpRequest). The new LuaHttpRequest object. Example The following example creates a new LuaHttpRequest object by reading configuration settings from a ..."},"695":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_send.htm",l:-1,t:"send",i:0.000534695964932579,a:"The send method sends the HTTP request. Syntax send() Returns (LuaHttpResponse). A  LuaHttpResponse  object. The send method can throw an exception if the request fails. You can catch an exception by calling the method  using the Lua function pcall. Example The following example shows how to send a ..."},"696":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_body.htm",l:-1,t:"set_body",i:0.00041832244256276,a:"set_body The set_body method sets the body of the HTTP request. Syntax set_body( body ) Arguments"},"697":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_config.htm",l:-1,t:"set_config",i:0.00041832244256276,a:"The set_config method specifies settings to use for sending the HTTP request (in the form of a section from a configuration file). For example, you can specify the proxy server to use by setting the parameters ProxyHost and ProxyPort, or specify the SSL version to use by setting SSLMethod. Syntax ..."},"698":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_header.htm",l:-1,t:"set_header",i:0.000773896793291483,a:"set_header The set_header method adds a header to the HTTP request. Syntax set_header( name, value ) Arguments Example request:set_header(\"X-EXAMPLE\", \"Example\")"},"699":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_headers.htm",l:-1,t:"set_headers",i:0.00041832244256276,a:"set_headers The set_headers method replaces all headers in the HTTP request with new headers. To add a header without changing existing headers, use the method  set_header . Syntax set_headers( headers ) Arguments Example request:set_headers( {X-EXAMPLE=\"Example\", X-ANOTHER=\"ANOTHER\"} )"},"700":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_method.htm",l:-1,t:"set_method",i:0.00041832244256276,a:"set_method Specifies the HTTP request method to use when sending the request, for example GET or POST.  Syntax set_method( method ) Arguments Example request:set_method(\"POST\")"},"701":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_url.htm",l:-1,t:"set_url",i:0.00041832244256276,a:"set_url The set_url method sets the URL that you want to send the HTTP request to. Syntax set_url( url ) Arguments Example request:set_url(\"https://www.example.com/\")"},"702":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA__LuaHttpResponse.htm",l:-1,t:"LuaHttpResponse Methods",i:0.000821459387327812,a:"This section describes the methods provided by LuaHttpResponse objects. A LuaHttpResponse object is provided when you send an HTTP request using the  send  method on a  LuaHttpRequest  object. If you have a LuaHttpResponse object called response you can call its methods using the \u0027:\u0027 operator. For ..."},"703":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_body.htm",l:-1,t:"get_body",i:0.000483340946111041,a:"get_body The get_body method returns the body of the HTTP response. Syntax get_body() Returns (String). The body of the HTTP response."},"704":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_header.htm",l:-1,t:"get_header",i:0.000483340946111041,a:"get_header The get_header method returns the value of a specified HTTP header. Syntax get_header( name ) Arguments Returns (String). The value of the header."},"705":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_headers.htm",l:-1,t:"get_headers",i:0.000483340946111041,a:"The get_headers method returns the names and values of all of the headers in the HTTP response. Syntax get_headers() Returns (table) A table that maps header names to values. Example The following example sends an HTTP request and then prints the headers that are returned to the console: local ..."},"706":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",l:-1,t:"get_http_code",i:0.000483340946111041,a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found."},"707":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",l:-1,t:"LuaJsonArray Methods",i:0.00205468097863847,a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Method Description append Appends a value to the array. clear Clears the array, so that it contains no values. copy ..."},"708":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",l:-1,t:"LuaJsonArray:new",i:0.000512507474805716,a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Returns (LuaJsonArray). The new LuaJsonArray object. Example The following is a simple JSON array: [4, \"a string\", true] To create a LuaJsonArray object to represent this array: local ..."},"709":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_append.htm",l:-1,t:"append",i:0.000512507474805716,a:"append The append method appends a value to the JSON array. Syntax append( value ) Arguments Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:append(6)\n-- the array is now [4, \"a string\", true, 6]"},"710":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_clear.htm",l:-1,t:"clear",i:0.000512507474805716,a:"clear The clear method clears the array, so that it contains no values. Syntax clear() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:clear()\nprint (myJsonArray:string())\n-- []"},"711":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_copy.htm",l:-1,t:"copy",i:0.000512507474805716,a:"The copy method returns a copy of the array. Modifying the copy does not modify the original array. Syntax copy() Returns (LuaJsonArray). A copy of the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nlocal anotherJsonArray = myJsonArray:copy()\nprint ..."},"712":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_empty.htm",l:-1,t:"empty",i:0.000512507474805716,a:"The empty method checks whether the JSON array is empty. Syntax empty() Returns (Boolean). Returns true if the array is empty. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nprint (\"Is the array empty?  \" , myJsonArray:empty() )\n-- Is the array empty?   ..."},});