define({"341":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_LuaJsonObject_new.htm",a:"The constructor for a LuaJsonObject object (creates a new LuaJsonObject). If you do not specify any attributes to assign to the object (by omitting the attributes argument), an empty object is created. Syntax LuaJsonObject:new( [attributes] ) Arguments Returns (LuaJsonObject). The new LuaJsonObject ...",t:"LuaJsonObject:new"},"342":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_assign.htm",a:"The assign method adds an attribute (a name/value pair) to the object. Syntax assign (name, value) Arguments Example local myJsonObject = LuaJsonObject:new( { name1=\"value1\" , name2=\"value2\" } )\nmyJsonObject:assign(\"name3\", \"value3\")\nmyJsonObject:assign(\"name4\", LuaJsonArray:new(\"value4a\",\"value4b\") ...",t:"assign"},"343":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_assign2.htm",a:"The assign method adds a table of attributes (name/value pairs) to the object. Syntax assign (attributes) Arguments Example local myJsonObject = LuaJsonObject:new()\nmyJsonObject:assign( {\n        attr1=LuaJsonObject:new( { n=42 } ),\n        attr2=LuaJsonArray:new( 1, 2, \"three\" ),\n        ...",t:"assign"},"344":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_clear.htm",a:"clear The clear method clears the object, so that it contains no attributes (name/value pairs). Syntax clear() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:clear()\nprint (myJsonObject:string())\n-- {}",t:"clear"},"345":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_copy.htm",a:"The copy method returns a copy of the JSON object. Modifying the copy does not modify the original object. Syntax copy() Returns (LuaJsonObject). A copy of the object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal anotherJsonObject = ...",t:"copy"},"346":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_empty.htm",a:"empty The empty method determines whether the JSON object is empty. Syntax empty() Returns (Boolean). Returns true if the object has no attributes (name/value pairs). Example local myJsonObject = LuaJsonObject:new()\nprint(myJsonObject:empty())\n-- true\n",t:"empty"},"347":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_erase.htm",a:"erase The erase method removes a specified attribute (name/value pair) from the JSON object. Syntax erase( name ) Arguments Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:erase(\"version\")\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\"}",t:"erase"},"348":{i:0.00538719590056619,u:"../Content/Lua/LuaJsonObject/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON object. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"exists"},"349":{i:0.00538719590056619,u:"../Content/Lua/LuaJsonObject/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON object. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"existsByPath"},"350":{i:0.00538719590056619,u:"../Content/Lua/LuaJsonObject/_LUA_lookup.htm",a:"The lookup method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ...",t:"lookup"},"351":{i:0.00538719590056619,u:"../Content/Lua/LuaJsonObject/_LUA_lookupByPath.htm",a:"The lookupByPath method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ...",t:"lookupByPath"},"352":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_pairs.htm",a:"The pairs method returns an iterator function that you can use with a for loop to iterate over all of the attributes contained in the JSON object. Syntax pairs() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\n\nfor i, v in myJsonObject:pairs() do\n  print (i .. \u0027=\u0027 ...",t:"pairs"},"353":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_size.htm",a:"size The size method returns the number of attributes (name/value pairs) in the JSON object. Syntax size() Returns (Number). The number of attributes in the JSON object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:size())\n-- 2",t:"size"},"354":{i:0.000808099530197142,u:"../Content/Lua/LuaJsonObject/_LUA_string.htm",a:"string The string method returns the JSON object as a string. Syntax string() Returns (String). The JSON object as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\",\"version\":11}",t:"string"},"355":{i:0.00282905868537242,u:"../Content/Lua/LuaJsonValue/_LUA__LuaJsonValue.htm",a:"A LuaJsonValue object represents a JSON value.  If you have a LuaJsonValue object called myJsonValue you can call its methods using the \u0027:\u0027 operator. For example: myJsonValue:is_object() Method Description array Gets a LuaJsonArray that represents the JSON array, if the value is an array. copy ...",t:"LuaJsonValue Methods"},"356":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_LuaJsonValue_new.htm",a:"LuaJsonValue:new The constructor for a LuaJsonValue object (creates a new LuaJsonValue). Syntax LuaJsonValue:new( value ) Arguments Returns (LuaJsonValue). The new LuaJsonValue object.",t:"LuaJsonValue:new"},"357":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_array.htm",a:"The array method gets the array, if the value is a JSON array. Syntax array() Returns (LuaJsonArray). A  LuaJsonArray  object that represents the array. Example local fh = io.open(\"example_array.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = ...",t:"array"},"358":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_copy.htm",a:"copy The copy method returns a copy of the value. Modifying the copy does not affect the original value. Syntax copy() Returns (LuaJsonValue). A copy of the value.",t:"copy"},"359":{i:0.00486338477466469,u:"../Content/Lua/LuaJsonValue/_LUA_exists.htm",a:"The exists method checks whether a specified path exists in the JSON value. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"exists"},"360":{i:0.00486338477466469,u:"../Content/Lua/LuaJsonValue/_LUA_existsByPath.htm",a:"The existsByPath method checks whether a specified path exists in the JSON value.  Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ...",t:"existsByPath"},"361":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_array.htm",a:"is_array The is_array method whether the value is a JSON array. Syntax is_array() Returns (Boolean). Returns true if the value is an array value, false otherwise.",t:"is_array"},"362":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_boolean.htm",a:"is_boolean The is_boolean method returns whether the value is a Boolean value. Syntax is_boolean() Returns (Boolean). Returns true if the value is a Boolean value, false otherwise.",t:"is_boolean"},"363":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_float.htm",a:"is_float The is_float method returns whether the value is a floating point value. Syntax is_float() Returns (Boolean). Returns true if the value is a floating point value, false otherwise.",t:"is_float"},"364":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_integer.htm",a:"is_integer The is_integer method returns whether the value is an integral value. Syntax is_integer() Returns (Boolean). Returns true if the value is an integer value, false otherwise.",t:"is_integer"},"365":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_null.htm",a:"is_null The is_null method returns whether the value is a null value. Syntax is_null() Returns (Boolean). Returns true if the value is a null value, false otherwise.",t:"is_null"},"366":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_number.htm",a:"is_number The is_number method returns whether the value is a number. Syntax is_number() Returns (Boolean). Returns true if the value is a number, false otherwise.",t:"is_number"},"367":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_object.htm",a:"is_object The is_object method returns whether the value is a JSON object. Syntax is_object() Returns (Boolean). Returns true if the value is a JSON object, false otherwise.",t:"is_object"},"368":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_simple_value.htm",a:"is_simple_value The is_simple_value method returns whether the value is a simple value (Boolean, float, integer, or string). Syntax is_simple_value() Returns (Boolean). Returns true if the value is a simple value, false otherwise.",t:"is_simple_value"},"369":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_is_string.htm",a:"is_string The is_string method returns whether the value is a string value. Syntax is_string() Returns (Boolean). Returns true if the value is a string value, false otherwise.",t:"is_string"},"370":{i:0.00486338477466469,u:"../Content/Lua/LuaJsonValue/_LUA_lookup.htm",a:"The lookup method returns the value at the specified path in the JSON value. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ...",t:"lookup"},"371":{i:0.00486338477466469,u:"../Content/Lua/LuaJsonValue/_LUA_lookupByPath.htm",a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ...",t:"lookupByPath"},"372":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_object.htm",a:"The object method gets the object, if the value is a JSON object. Syntax object() Returns (LuaJsonObject) A  LuaJsonObject  object that represents the JSON object. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n\nlocal myJsonValue = ...",t:"object"},"373":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_string.htm",a:"The string method returns the JSON value as a string. Syntax string() Returns (String). The JSON value as a string. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = parse_json(file_content)\n\nprint(myJsonValue:string())\n",t:"string"},"374":{i:0.000729525263821521,u:"../Content/Lua/LuaJsonValue/_LUA_value.htm",a:"The value method gets the value, if the JSON value is a simple type (a Boolean, float, integer, or string). This method returns a default value if one is specified and the value cannot be converted to the same type as the default. Syntax value( [default] ) Arguments Returns (lua_json_simple_type). A ...",t:"value"},"375":{i:0.00443062732985908,u:"../Content/Lua/LuaLog/_LUA_LuaLog.htm",a:"LuaLog Methods A LuaLog object provides the capability to use a log stream. You can obtain a LuaLog object for a log stream by using the function  get_log . If you have a LuaLog object called log you can call its methods using the \u0027:\u0027 operator. For example: log:write_line(level, message)",t:"LuaLog Methods"},"376":{i:0.0024859817637553,u:"../Content/Lua/LuaLog/_LUA_write_line.htm",a:"The write_line method writes a message to the log stream. Syntax write_line( level, message ) Arguments Example local config = get_config(\"connector.cfg\")\nlocal log = get_log(config, \"SynchronizeLogStream\")\nlog:write_line( log_level_error() , \"This message is written to the synchronize log\")",t:"write_line"},"377":{i:0.000800051980721634,u:"../Content/Lua/LuaLogService/_LUA__LuaLogService.htm",a:"A LuaLogService object provides the capability to write messages to a standard or custom log file. If you have a LuaLogService object called myLogService you can call its methods using the \u0027:\u0027 operator. For example: myLogService:get_log(\"application\") Method Description get_log Returns a LuaLog ...",t:"LuaLogService Methods"},"378":{i:0.000942984338001528,u:"../Content/Lua/LuaLogService/_LUA_LuaLogService_new.htm",a:"The constructor for a LuaLogService object (creates a new LuaLogService). Do not create a new log service to write messages to log types that are defined in the Controller configuration file. Instead use the same log service as Controller, by calling  get_log_service , or obtain a LuaLog object ...",t:"LuaLogService:new"},"379":{i:0.000942984338001528,u:"../Content/Lua/LuaLogService/_LUA_get_log.htm",a:"get_log The get_log method returns a LuaLog object that you can use to write log messages to a specified log type. Syntax get_log( type ) Arguments Returns (LuaLog). A  LuaLog  object. Example local log = myLuaLogService:get_log(\"import\")\n-- import is a standard log type for CFS",t:"get_log"},"380":{i:0.000602961984353749,u:"../Content/Lua/LuaRegexMatch/_LUA_LuaRegexMatch_Methods.htm",a:"A LuaRegexMatch object provides information about the matches for a regular expression found in a string. For example, the regex_search function returns a LuaRegexMatch object. If a match is found for a regular expression at multiple points in the string, you can use the next() method to get a ...",t:"LuaRegexMatch Methods"},"381":{i:0.000705465592174565,u:"../Content/Lua/LuaRegexMatch/_LUA_length.htm",a:"length The length method returns the length of the match. You can also retrieve the length of sub matches by specifying the submatch parameter. Syntax length( [ submatch ] ) Arguments Returns (Number). The length of the sub match.",t:"length"},"382":{i:0.000705465592174565,u:"../Content/Lua/LuaRegexMatch/_LUA_next.htm",a:"next The next method returns a LuaRegexMatch object for the next match. Syntax next() Returns (LuaRegexMatch). A LuaRegexMatch object for the next match, or nil if there are no matches following this one.",t:"next"},"383":{i:0.000705465592174565,u:"../Content/Lua/LuaRegexMatch/_LUA_position.htm",a:"The position method returns the position of the match in the string searched, where 1 refers to the first character in the string. You can also retrieve the position of sub matches by specifying the submatch parameter. Syntax position( [ submatch ] ) Arguments Returns (Number). The position of the ...",t:"position"},"384":{i:0.000705465592174565,u:"../Content/Lua/LuaRegexMatch/_LUA_size.htm",a:"size The size method returns the total number of sub matches made for the current match, including the whole match (sub match 0). Syntax size() Returns (Number). The number of sub matches for the current match.",t:"size"},"385":{i:0.000705465592174565,u:"../Content/Lua/LuaRegexMatch/_LUA_str.htm",a:"str The str method returns the value of the substring that matched the regular expression. You can also retrieve the values of sub matches by specifying the submatch parameter. Syntax str( [ submatch ] ) Arguments Returns (String). The value of the sub match.",t:"str"},"386":{i:0.000602961984353749,u:"../Content/Lua/LuaXmlDocument/_LUA_LuaXmlDocument_Methods.htm",a:"This section describes the methods provided by LuaXmlDocument objects. A LuaXmlDocument object provides methods for accessing information stored in XML format. You can create a LuaXmlDocument from a string containing XML using the parse_xml function. If you have a LuaXmlDocument object called xml ...",t:"LuaXmlDocument Methods"},"387":{i:0.000705465592174565,u:"../Content/Lua/LuaXmlDocument/_LUA_root.htm",a:"root The root method returns an LuaXmlNode, which is the root node of the XML document. Syntax root() Returns (LuaXmlNode). A LuaXmlNode object.",t:"root"},"388":{i:0.000705465592174565,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathExecute.htm",a:"XPathExecute The XPathExecute method returns a LuaXmlNodeSet, which is the result of the supplied XPath query. Syntax XPathExecute( xpathQuery ) Arguments Returns (LuaXmlNodeSet). A LuaXmlNodeSet object.",t:"XPathExecute"},"389":{i:0.000705465592174565,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathRegisterNs.htm",a:"XPathRegisterNs The XPathRegisterNs method registers a namespace with the XML parser. Syntax XPathRegisterNs( prefix, location ) Arguments Returns (Boolean). True if successful, False in case of error.",t:"XPathRegisterNs"},"390":{i:0.000705465592174565,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValue.htm",a:"XPathValue The XPathValue method returns the first occurrence of the value matching the XPath query. Syntax XPathValue( query ) Arguments Returns (String). A string of the value.",t:"XPathValue"},"391":{i:0.000705465592174565,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValues.htm",a:"The XPathValues method returns the values according to the XPath query. Syntax XPathValues( query ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: values = { xml:XPathValues(query) }",t:"XPathValues"},"392":{i:0.000602961984353749,u:"../Content/Lua/LuaXmlNodeSet/_LUA_LuaXmlNodeSet_Methods.htm",a:"LuaXmlNodeSet Methods A LuaXmlNodeSet object represents a set of XML nodes. If you have a LuaXmlNodeSet object called nodes you can call its methods using the \u0027:\u0027 operator. For example: nodes:size()",t:"LuaXmlNodeSet Methods"},"393":{i:0.000859221003905789,u:"../Content/Lua/LuaXmlNodeSet/_LUA_at.htm",a:"at The at method returns the LuaXmlNode at position position in the set. Syntax at( position ) Arguments Returns (LuaXmlNode).",t:"at"},"394":{i:0.000859221003905789,u:"../Content/Lua/LuaXmlNodeSet/_LUA_size.htm",a:"size The size method returns the size of the node set. Syntax size() Returns (Number) An integer, the size of the node set.",t:"size"},"395":{i:0.000602961984353749,u:"../Content/Lua/LuaXmlNode/_LUA_LuaXmlNode_Methods.htm",a:"LuaXmlNode Methods A LuaXmlNode object represents a single node in an XML document.  If you have a LuaXmlNode object called node you can call its methods using the \u0027:\u0027 operator. For example: node:name()",t:"LuaXmlNode Methods"},"396":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_attr.htm",a:"attr The attr method returns the first LuaXmlAttribute attribute object for the LuaXmlNode. If the name argument is specified, the method returns the first LuaXmlAttribute object with the specified name. Syntax attr( [name] ) Arguments Returns (LuaXmlAttribute). ",t:"attr"},"397":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_content.htm",a:"content The content method returns the content (text element) of the XML node. Syntax content() Returns (String). A string containing the content.",t:"content"},"398":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_firstChild.htm",a:"firstChild The firstChild method returns the LuaXmlNode that is the first child of this node. Syntax firstChild() Returns (LuaXmlNode).",t:"firstChild"},"399":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_lastChild.htm",a:"lastChild The lastChild method returns the LuaXmlNode that is the last child of this node. Syntax lastChild() Returns (LuaXmlNode).",t:"lastChild"},"400":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_name.htm",a:"name The name method returns the name of the XML node. Syntax name() Returns (String). A string containing the name.",t:"name"},"401":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_next.htm",a:"next The next method returns the LuaXmlNode that is the next sibling of this node. Syntax next() Returns (LuaXmlNode).",t:"next"},"402":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_nodePath.htm",a:"nodePath The nodePath method returns the XML path to the node, which can be used in another XPath query. Syntax nodePath() Returns (String). A string containing the path.",t:"nodePath"},"403":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_parent.htm",a:"parent The parent method returns the parent LuaXmlNode of the node. Syntax parent() Returns (LuaXmlNode).",t:"parent"},"404":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_prev.htm",a:"prev The prev method returns a LuaXmlNode that is the previous sibling of this node. Syntax prev() Returns (LuaXmlNode).",t:"prev"},"405":{i:0.000654213788264157,u:"../Content/Lua/LuaXmlNode/_LUA_type.htm",a:"The type method returns the type of the node as a string. Syntax type() Returns (String) A string containing the type. Possible values are: element_node comment_node element_decl attribute_node document_node attribute_decl text_node document_type_node entity_decl cdata_section_node ...",t:"type"},"406":{i:0.000602961984353749,u:"../Content/Lua/LuaXmlAttribute/_LUA_LuaXmlAttribute_Methods.htm",a:"LuaXmlAttribute Methods A LuaXmlAttribute object represents an attribute on an XML element. If you have a LuaXmlAttribute object called attribute you can call its methods using the \u0027:\u0027 operator. For example: attribute:name()",t:"LuaXmlAttribute Methods"},"407":{i:0.000731091494129769,u:"../Content/Lua/LuaXmlAttribute/_LUA_name.htm",a:"name The name method returns the name of this attribute. Syntax name() Returns (String). A string containing the name of the attribute.",t:"name"},"408":{i:0.000731091494129769,u:"../Content/Lua/LuaXmlAttribute/_LUA_next.htm",a:"next The next method returns a LuaXmlAttribute object for the next attribute in the parent element. Syntax next() Returns (LuaXmlAttribute).",t:"next"},"409":{i:0.000731091494129769,u:"../Content/Lua/LuaXmlAttribute/_LUA_prev.htm",a:"prev The prev method returns a LuaXmlAttribute object for the previous attribute in the parent element. Syntax prev() Returns (LuaXmlAttribute).",t:"prev"},"410":{i:0.000731091494129769,u:"../Content/Lua/LuaXmlAttribute/_LUA_value.htm",a:"value The value method returns the value of this attribute. Syntax value() Returns (String). A string containing the value of the attribute.",t:"value"},"411":{i:0.000602961984353749,u:"../Content/Lua/Controller/_LuaFunctions.htm",a:"Controller Lua scripts take the basic form: function TaskMain(service)\n   local status = 0\n   -- perform task\n   return status\nend  Scripts return a status value that indicates the status event. The status event is recorded by the Controller server: This section describes the Controller-specific ...",t:"Controller Lua Functions and Methods"},"412":{i:0.000602961984353749,u:"../Content/Lua/Controller/add_service_status.htm",a:"addServiceStatus This function generates a status event of the specified type, with the specified message body. Syntax service:addServiceStatus( type, body ) For example: service:addServiceStatus(\"Error\", \"Test action did not return success\") Arguments",t:"addServiceStatus"},"413":{i:0.000602961984353749,u:"../Content/Lua/Controller/get_port_number.htm",a:"getPortNumber The getPortNumber function returns the ACI port number of the current service. Syntax service:getPortNumber( )  Arguments None Returns The ACI port number of the current service.",t:"getPortNumber"},"414":{i:0.000602961984353749,u:"../Content/Appendixes.htm",a:"Appendixes This section contains the following appendixes: Open Source and Third-Party Software License Agreements Open Source and Third-Party Software License Agreements (Online Help)",t:"Appendixes"},"415":{i:0.000859221003905789,u:"../Content/ThirdPartyLicenses/_LIC_App_OpenSource.htm",a:"Open Source and Third-Party Software License Agreements Micro Focus acknowledges the redistribution of the following open source and third-party components under the licenses shown below.",t:"Open Source and Third-Party Software License Agreements"},"416":{i:0.000602961984353749,u:"../Content/ThirdPartyLicenses/_LIC_Lua.htm",a:"Copyright © 1994–2017 Lua.org, PUC-Rio. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the \"Software\"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, ...",t:"Lua"},"417":{i:0.000859221003905789,u:"../Content/ThirdPartyLicenses/OnlineHelp/_LIC_OS3PLicenses.htm",a:"Micro Focus acknowledges the redistribution  of open source and third-party components as part of the Help content that use the following licenses. Apache License 2.0 PIE.htc, PIE_uncompressed.htc, PIE-no-motw.htc For the text of the Apache License 2.0, see  Appendix: Apache License 2.0 (Full Text) ...",t:"Open Source and Third-Party Software License Agreements (Online Help)"},"418":{i:0.00084640811660173,u:"../Content/ThirdPartyLicenses/OnlineHelp/_LIC_Apache_v2.0_fullText.htm",a:"Apache License Version 2.0, January 2004\n             http://www.apache.org/licenses/ TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION 1. Definitions. \"License\" shall mean the terms and conditions for use, reproduction, and\n\t\tdistribution as defined by Sections 1 through 9 of this ...",t:"Appendix: Apache License 2.0 (Full Text)"},"419":{i:0.00084640811660173,u:"../Content/ThirdPartyLicenses/OnlineHelp/_LIC_BSD_3-Clause_fullText.htm",a:"Copyright (c) \u003cYEAR\u003e, \u003cOWNER\u003e All rights reserved. Redistribution and use in source and binary forms, with or without modification, are permitted provided that the following conditions are met: 1. Redistributions of source code must retain the above copyright notice, this list of conditions and the ...",t:"Appendix: BSD 3-Clause License (Full Text)"},"420":{i:0.00084640811660173,u:"../Content/ThirdPartyLicenses/OnlineHelp/_LIC_MITLicense_fullText.htm",a:"\nThe MIT License (MIT) \nCopyright (c) \u003cyear\u003e \u003ccopyright holders\u003e Permission is hereby granted, free of charge, to any person obtaining a copy\nof this software and associated documentation files (the \"Software\"), to deal\nin the Software without restriction, including without limitation the rights\nto ...",t:"Appendix: The MIT License (Full Text)"},"421":{i:0.00181010507689327,u:"../Content/Actions/Controller/Parameters/MaxResultsGetStats.htm",a:"MaxResults The maximum number of results that the GetStatistics action can return, from the total number of results returned. Set MaxResults to  0 to return unlimited results. You can also specify an optional  GetStatusOverview . By default, the most recent results display first. ",t:"MaxResults"},"422":{i:0.00143124095522932,u:"../Content/Actions/Scheduling/Parameters/Name_AddSchedule.htm",a:"Name An optional name for the new schedule. If you do not specify a name, Controller generates a unique name and includes the details of the name in the response.",t:"Name"},"423":{i:0.00224990411478796,u:"../Content/Actions/Scheduling/Parameters/_SHARED_ScheduleType.htm",a:"ScheduleType Set ScheduleType to indexAction if you want to schedule an index action, or to aciAction if you want to schedule an ACI action.",t:"ScheduleType"},"424":{i:0.00216914009496566,u:"../Content/Actions/Controller/Parameters/TypeListMeters.htm",a:"Type The type of meter to return. Set to one of the following: Service Process System",t:"Type"},"425":{i:0.0019888421591939,u:"../Content/Actions/Controller/Parameters/Operation.htm",a:"The type of operation to perform. Set this parameter to one of the following options: create. Create a new file.\n             update. Update an existing file.\n             delete. Delete an existing file.\n             You must specify a relative file path relative to the shared file directory.",t:"Operation"},"426":{i:0.00202315747991961,u:"../Content/Actions/Controller/Parameters/Command.htm",a:"Command The action that you want to send to the specified service port. For ACI and service actions, you do not need to include action= or a=.",t:"Command"},"427":{i:0.00136260933888863,u:"../Content/Service/ServiceActions/_ACI_Name.htm",a:"Name Type the name of the log stream you want to return. To retrieve a list of log stream names, use the  GetLogStreamNames  service action.",t:"Name"},"428":{i:0.00151185742986657,u:"../Content/Actions/Controller/Parameters/PortRunScript.htm",a:"Port Specify the optional Port parameter to run your script on only the service with the specified port number. If you do not specify a port, the script runs on services on all ports.",t:"Port"},"429":{i:0.00181010507689327,u:"../Content/Actions/Controller/Parameters/IncludeAllMeters.htm",a:"IncludeAllMeters Whether to include meters with no values for the relevant period in the response.",t:"IncludeAllMeters"},});