define({"0":{y:0,u:"../Content/Part_Overview.htm",l:-1,t:"Overview of Filter SDK",i:0.00322392247013707,a:"Overview of Filter SDK This section provides an overview of the Micro Focus KeyView Filter SDK and describes how to use the  C++  implementation of the API. Introducing Filter SDK Getting Started"},"1":{y:0,u:"../Content/filter_shared/filtersdk_intro/intro_filtersdk.htm",l:-1,t:"Introducing Filter SDK",i:0.00459411032157739,a:"Introducing Filter SDK This section describes the Filter SDK package. "},"2":{y:0,u:"../Content/filter_shared/filtersdk_intro/Overview.htm",l:-1,t:"Overview",i:0.00322392247013707,a:"Micro Focus KeyView Filter SDK enables you to incorporate text extraction functionality into your own applications. It extracts text and metadata from a wide variety of file formats on numerous platforms, and can automatically recognize over 1000 document types. It supports both file-based and ..."},"3":{y:0,u:"../Content/filter_shared/filtersdk_intro/Features.htm",l:-1,t:"Features",i:0.00322392247013707,a:"Document readers are threadsafe. The benefit of a threadsafe technology is that you can successfully extract text from hundreds of documents simultaneously. Documents are not queued for sequential filtering, but are actually filtered at the same time. Filter supports popular word processing, ..."},"4":{y:0,u:"../Content/Shared/_KV_Platform.htm",l:-1,t:"Platforms, Compilers, and Dependencies",i:0.00322392247013707,a:"Platforms, Compilers, and Dependencies This section lists the supported platforms, supported compilers, and software dependencies for the KeyView software."},"5":{y:0,u:"../Content/Shared/_KV_Platform_Supported_Platforms.htm",l:-1,t:"Supported Platforms",i:0.00322392247013707,a:"CentOS 7 x86, x64, and AArch64 IBM AIX L6.1 PowerPC 32-bit and 64-bit IBM AIX L7.1 PowerPC 32-bit and 64-bit macOS 10.13 or later on 64-bit Apple-Intel architecture macOS 11 or later on Apple M1. Microsoft Windows Server 2012 x64 Microsoft Windows Server 2016 x64 Microsoft Windows Server 2019 x64 ..."},"6":{y:0,u:"../Content/Shared/_KV_Platform_Compilers.htm",l:-1,t:"Supported Compilers",i:0.00322392247013707,a:"Supported Compilers Supported Compilers for Java Components Component Compiler Java components Java 7 C++ Filter SDK The C++ Filter SDK is supported on: Linux using GCC 5 or later Windows using Visual Studio 2015 or later"},"7":{y:0,u:"../Content/Shared/_KV_Platform_Dependencies.htm",l:-1,t:"Software Dependencies",i:0.00322392247013707,a:"Some KeyView components require  specific third-party software: Java Runtime Environment (JRE) or Java Software Developer Kit (JDK) version 7 or 8 is required for  Java API and  graphics conversion in Export SDK. Outlook 2002 or later is required to process Microsoft Outlook Personal Folders (PST) ..."},"8":{y:0,u:"../Content/Shared/_KV_install_Windows.htm",l:-1,t:"Windows Installation",i:0.00322392247013707,a:"To install the SDK on Windows, use the following procedure. To install the SDK  Run the installation program, KeyViewProductNameSDK_VersionNumber_OS.exe, where ProductName is the name of the product, VersionNumber is the product version number, and OS is the operating system. For example: ..."},"9":{y:0,u:"../Content/Shared/_KV_install_UNIX.htm",l:-1,t:"UNIX Installation",i:0.00322392247013707,a:"To install the SDK, use one of the following procedures. To install the SDK from the graphical interface Run the installation program and follow the on-screen instructions. To install the SDK from the console Run the installation program from the console as follows: ..."},"10":{y:0,u:"../Content/filter_shared/filtersdk_intro/Package_Contents.htm",l:-1,t:"Package Contents",i:0.00322392247013707,a:"The Filter SDK installation contains: All the libraries and executables necessary for extracting text from a wide variety of formats. The  include files  that define the functions and structures used by the application to establish an interface with Filter: The Java API implemented in the package ..."},"11":{y:0,u:"../Content/Shared/_KV_License_Update.htm",l:-1,t:"License Information",i:0.0556147270940397,a:"Your license key controls whether you have the full version of the KeyView SDK, or a trial version. It also determines whether the following advanced features are enabled: Advanced character set detection with the character set detection library (kvlangdetect). Advanced document readers: Microsoft ..."},"12":{y:0,u:"../Content/filter_shared/filtersdk_intro/Directory_Structure.htm",l:-1,t:"Directory Structure",i:0.00322392247013707,a:"Directory Structure The following table describes the contents of the Filter SDK. The variable  OS is the operating system for which the SDK is installed. For example, the bin directory on a standard 32-bit Windows installation would be located at KeyviewFilterSDK\\WINDOWS\\bin."},"13":{y:0,u:"../Content/Chapter_GettingStarted.htm",l:-1,t:"Getting Started",i:0.00844094026476653,a:"Getting Started This section provides an overview of Filter SDK, and describes how to use the  C++  implementation of the API."},"14":{y:0,u:"../Content/C++/gettingstarted/Using_the_C++_Imp.htm",l:-1,t:"Use the C++ Language Implementation of the API",i:0.00322392247013707,a:"The C++ API is designed to make extraction of content from documents as straightforward as possible. The primary advantage over the C API is the use of C++ features to provide a simpler interface that is easy to use.\n         The API consists of: Header files that define all of the classes and ..."},"15":{y:0,u:"../Content/C++/gettingstarted/Building.htm",l:-1,t:"Build the C++ API",i:0.00459411032157739,a:"This section describes the build process for Windows and Linux. To build the C++ API on Windows To build on Windows, you need at least Microsoft Visual Studio 2015.  Switch to the cppapi/bin directory.  At the Visual Studio command prompt, run nmake -f Makefile.  This command creates a file called ..."},"16":{y:0,u:"../Content/C++/gettingstarted/Create_Session.htm",l:-1,t:"Create a KeyView Session\n        ",i:0.00322392247013707,a:"Create a KeyView Session\n         To use the C++ Filter SDK, link the library built in  Build the C++ API , and include the following headers in your code: #include \"Keyview_FilterSDK.hpp\"\n#include \"Keyview_IO.hpp\" To use the SDK, you must create a KeyView session: auto KV = ..."},"17":{y:0,u:"../Content/C++/gettingstarted/DetectFormat.htm",l:-1,t:"Detect the Format of a File",i:0.00322392247013707,a:"You can detect the format of a file by using the detect method. For example: auto myinput = keyview::io::InputFile{ std::string(\"InputFile.docx\") };\nauto detection_info = KV.detect(myinput);\n\n// Print out what we found\nstd::cout \u003c\u003c \"Format:\\t\" \u003c\u003c static_cast\u003cint\u003e(detection_info.format()) \u003c\u003c ..."},"18":{y:0,u:"../Content/C++/gettingstarted/FilterFile.htm",l:-1,t:"Filter a File",i:0.00322392247013707,a:"Filter a File You can get a plain text version of the file content by using the filter method: auto myinput = keyview::io::InputFile{ std::string(\"InputFile.docx\") };\nauto myoutput = keyview::io::OutputFile{ std::string(\"out.txt\") };\nKV.filter(myinput, myoutput);"},"19":{y:0,u:"../Content/C++/gettingstarted/ExtractSubfiles.htm",l:-1,t:"Extract Subfiles",i:0.00322392247013707,a:"You can iterate over subfile information using the subfiles method. Each element returned by the iterator contains information about the subfile, and a method to let you extract it if you want to: auto myinput = keyview::io::InputFile{ std::string(\"InputFile.zip\") };\nfor (const auto\u0026 subfile : ..."},"20":{y:0,u:"../Content/C++/gettingstarted/ExtractMetadata.htm",l:-1,t:"Extract Metadata",i:0.00322392247013707,a:"You can obtain the metadata for a file by calling the  metadata_map  method: auto myinput = keyview::io::InputFile{ std::string(\"InputFile.docx\") };\nauto metadata = KV.metadata_map(myinput);\nfor (const auto\u0026 it : metadata)\n{\n     std::cout \u003c\u003c it.first \u003c\u003c \": \" \u003c\u003c it.second \u003c\u003c \u0027\\n\u0027;\n} The metadata map ..."},"21":{y:0,u:"../Content/C++/gettingstarted/Exceptions.htm",l:-1,t:"Exceptions",i:0.00322392247013707,a:"All of the C++ API methods can throw exceptions. KeyView errors take the form of an instance of keyview_error, which is itself derived from std::exception. The exceptions that can be thrown are defined in Keyview_Errors.hpp. In application code, it is possible to catch and correctly handle many of ..."},"22":{y:0,u:"../Content/C++/gettingstarted/GenericIO.htm",l:-1,t:"Generic IO Types",i:0.00322392247013707,a:"The C++ API makes use of generic types for input and output. For example, the signature of the filter method is: template \u003ctypename Input_Type, typename Output_Type\u003e\nvoid filter(Input_Type\u0026 input, Output_Type\u0026 output); Some input and output types are defined in Keyview_IO.hpp. These are  InputFile , ..."},"23":{y:0,u:"../Content/Part_UseSDK.htm",l:-1,t:"Use Filter SDK",i:0.00322392247013707,a:"Use Filter SDK This section explains how to perform some basic tasks by using the File Extraction and Filter APIs, and describes the sample programs. Use the File Extraction API Use the Filter API Sample Programs"},"24":{y:0,u:"../Content/kv_xtract_api_c/_KV_xtract_c.htm",l:-1,t:"Use the File Extraction API",i:0.00413738103776395,a:"Use the File Extraction API This section describes how to extract subfiles from a container file by using the File Extraction API. "},"25":{y:0,u:"../Content/kv_xtract_api_c/_KV_xtract_c_Introduction.htm",l:-1,t:"Introduction",i:0.00322392247013707,a:"To  filter  a file, you must first determine whether the file contains any subfiles (attachments, embedded OLE objects, and so on). A file that contains subfiles is called a  container file. A container file has a main file (parent) and subfiles (children) embedded in the main file.  The following ..."},"26":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_Sub_Files.htm",l:-1,t:"Extract Subfiles",i:0.00459411032157739,a:"To filter all files in a container file, you must open the container and extract its subfiles to either a file or a stream by using the File Extraction API. The extraction process is done repeatedly until all subfiles are extracted and exposed for filtering. After a subfile is extracted, you can ..."},"27":{y:0,u:"../Content/Shared/_KV_xtract_Extract_Images.htm",l:-1,t:"Extract Images",i:0.00322392247013707,a:"You can use the File Extraction API  to extract images within the file by specifying the following in the formats.ini file: [Options]\nExtractImages=TRUE If you set this option, images within the file  behave in the same way as any other subfile. Extracted images  have the name image[X].[Y], where ..."},"28":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_Mail_Metadata.htm",l:-1,t:"Extract Mail Metadata",i:0.00413738103776395,a:"You can extract metadata, such as subject, sender, and recipient, from subfiles of mail formats, by calling the metadata_map() function on a Session object (see  The Session Class  for more information). Default Metadata Set KeyView internally defines a set of common mail metadata fields that you ..."},"29":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_SubFiles_OutlookExpress.htm",l:-1,t:"Extract Subfiles from Outlook Express Files",i:0.00322392247013707,a:"Extract Subfiles from Outlook  Express Files If the Outlook file contains a non-mail attachment, the attachment is extracted in its native format to the same directory as the message text file. If the Outlook file contains a mail attachment, the complete attachment (including message text and ..."},"30":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_SubFiles_MailboxFiles.htm",l:-1,t:"Extract Subfiles from Mailbox Files",i:0.00322392247013707,a:"Extract  Subfiles from Mailbox Files A Mailbox (MBX) file is a collection of individual emails compiled with RFC 822 and RFC 2045 - 2049 (MIME), and divided by message separators. There are many mail applications that export to an MBX format, such as Eudora Email and Mozilla Thunderbird.  In Eudora ..."},"31":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_SubFiles_OutlookPersonalFolder.htm",l:-1,t:"Extract Subfiles from Outlook Personal Folders Files",i:0.00322392247013707,a:"Extract  Subfiles from Outlook Personal Folders Files KeyView can extract Outlook items such as messages, appointments, contacts, tasks, notes, and journal entries from a PST file.  If an Outlook item contains a non-mail attachment, the attachment is extracted in its native format to a subdirectory. ..."},"32":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_SubFiles_LotusDominoXML.htm",l:-1,t:"Extract Subfiles from Lotus Domino XML Language Files",i:0.00322392247013707,a:"Extract  Subfiles from Lotus Domino XML Language Files When you extract a Lotus Domino XML Language (.DXL) file, the message text and header information (To, From, Sent, and so on) is extracted to a text file. You can make sure that dates and times extracted from Lotus Domino .DXL files are ..."},"33":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_SubFiles_LotusNotes_DB.htm",l:-1,t:"Extract Subfiles from Lotus Notes Database Files",i:0.00322392247013707,a:"Extract  Subfiles from Lotus Notes Database Files A Lotus Notes database is a single file that contains multiple documents called notes. Notes include design notes (such as forms, views, folders, navigators, outlines, pages, framesets, agents, and resources), data document notes, profile document ..."},"34":{y:0,u:"../Content/kv_xtract_api_c/_KV_xtract_c_Extract_SubFiles_PDF_Files.htm",l:-1,t:"Extract Subfiles from PDF Files",i:0.00596429817301772,a:"Extract  Subfiles from PDF Files KeyView can extract document-level and page-level attachments from a PDF document. Document-level attachments are added by using the Attach A File tool, and can include links to or from the parent document or to other file attachments. Page-level attachments are ..."},"35":{y:0,u:"../Content/Shared/_KV_PDF_ImprovePerformanceWithSmallImages.htm",l:-1,t:"Improve Performance for PDFs with Many Small Images",i:0.00322392247013707,a:"To improve performance when processing  PDF files that contain many small images, you can choose to ignore images unless they exceed a minimum width and/or height. If an image is smaller than the minimum width or height, KeyView does not extract the image.  For example, to ignore images that are ..."},"36":{y:0,u:"../Content/kv_xtract_api_c/_KV_xtract_c_Extract_Embedded_OLE_Objects.htm",l:-1,t:"Extract Embedded OLE Objects",i:0.00322392247013707,a:"The File Extraction API can extract embedded  OLE objects from the following types of documents: Lotus Notes (DXL) Microsoft Excel Microsoft Word Microsoft PowerPoint Microsoft Outlook Microsoft Visio Microsoft Project OASIS Open Document Rich Text Format (RTF) When an embedded OLE object is ..."},"37":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_SubFiles_ZIPFiles.htm",l:-1,t:"Extract Subfiles from ZIP Files",i:0.00322392247013707,a:"You can extract ZIP files that are not password-protected by using the general method (see  Extract Subfiles ). However, some ZIP files use password protection, in which case you must use a different method to enter the required credentials.  See  Password Protected Files  for more information."},"38":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Extract_Metadata.htm",l:-1,t:"Extract  Metadata",i:0.00322392247013707,a:"You can obtain the metadata for a file by calling the  metadata_map  method: auto myinput = keyview::io::InputFile{ std::string(\"InputFile.docx\") };\nauto metadata = KV.metadata_map(myinput);\nfor (const auto\u0026 it : metadata)\n{ \n    std::cout \u003c\u003c it.first \u003c\u003c \": \" \u003c\u003c it.second \u003c\u003c \u0027\\n\u0027;\n} The metadata map ..."},"39":{y:0,u:"../Content/Chapter_UseFilterAPI.htm",l:-1,t:"Use the Filter API",i:0.00413738103776395,a:"Use the Filter API This section describes how to perform some basic filtering tasks by using the Filter API."},"40":{y:0,u:"../Content/C++/filter_api/Generate_an_Error_Log.htm",l:-1,t:"Generate an Error Log",i:0.00322392247013707,a:"You can monitor and debug filtering operations by enabling a detailed error log. This enables you to see errors that are generated at run time, and to track problem files in stream or file mode. Error logs are not generated when in-process filtering is enabled. The error log might include the ..."},"41":{y:0,u:"../Content/C++/filter_api/Enable_Disable_Error_Logging.htm",l:-1,t:"Enable or Disable Error Logging",i:0.0037719976107132,a:"Enable or Disable Error  Logging You can enable or disable error logging by using either the API or environment variables. By default, a file called kvoop.log is created in the system temporary directory; however, you can change the path and file name of this file (see  Change the Path and File Name ..."},"42":{y:0,u:"../Content/C++/filter_api/Change_Path_Log.htm",l:-1,t:"Change the Path and File Name of the Log File",i:0.00537512166242998,a:"You can change the default path and file name of the log file. The default is C:\\temp\\kvoop.log on Windows and /tmp/kvoop.log on UNIX.  To change the path and file name of the log file, add the following to the formats.ini file: [kvooplog]\nKvoopLogName=filepath"},"43":{y:0,u:"../Content/C++/filter_api/Report_Memory_Errors.htm",l:-1,t:"Report Memory Errors",i:0.0037719976107132,a:"You can report memory leaks and  memory overwrites in the log file by enabling the  memory trace system, either by using the API or environment variables. If the memory trace system is enabled, the extended error codes for memory leaks and memory overwrites (26 and 27, respectively) are reported in ..."},"44":{y:0,u:"../Content/C++/filter_api/Specify_a_Memory_Guard.htm",l:-1,t:"Specify a Memory Guard",i:0.00537512166242998,a:"To report memory overwrites in the log file, you must set a  memory guard that protects against memory overwrites. Normally, this is set in the range of 100-200 bytes. For example, if a memory guard of 100 is set and 20 bytes of memory are specified, a total of 120 bytes of memory are allocated. The ..."},"45":{y:0,u:"../Content/C++/filter_api/Specify_the_Maximum_Size.htm",l:-1,t:"Specify the Maximum Size of the Log File",i:0.0037719976107132,a:"You can specify the maximum size of the log file. When this size is reached and new entries are logged, either the first entry in the file is overwritten or the new entries are not reported.  To configure the maximum log size and whether old entries are overwritten, add the following section to the ..."},"46":{y:0,u:"../Content/C++/filter_api/Extract_Metadata.htm",l:-1,t:"Extract Metadata",i:0.00322392247013707,a:"Extract  Metadata When a file format supports metadata, KeyView can extract and process that information. Metadata includes document information fields such as title, author, creation date, and file size. Depending on the file\u0027s format, metadata is referred to in a number of ways: for example, ..."},"47":{y:0,u:"../Content/C++/filter_api/Convert_Character_Sets.htm",l:-1,t:"Convert Character Sets",i:0.00322392247013707,a:"Filter can convert the character set of a document to an arbitrary character set specified in the API, or to the character set of the operating system on which the output text is viewed. For this conversion to occur, a source character set must be identified. The source character set can either be ..."},"48":{y:0,u:"../Content/C++/filter_api/Determine_the_CharacterSet.htm",l:-1,t:"Determine the Character Set of the Output Text",i:0.00322392247013707,a:"Determine the  Character Set of the Output Text To determine the output character set of a filtered document, Filter considers the following: Whether the document reader can determine the character set of the file format. If the document reader cannot determine the character set information for the ..."},"49":{y:0,u:"../Content/C++/filter_api/Set_CharSet_Filtering.htm",l:-1,t:"Set the Character Set During Filtering",i:0.00322392247013707,a:"Set the Character  Set During Filtering You can convert the character set of a file at the time the file is filtered. To specify the source character set of a file, invoke source_encoding() on a Configuration object, before creating a session, using any value in the enumerated list Encoding in ..."},"50":{y:0,u:"../Content/C++/filter_api/Set_CharSet_Extraction.htm",l:-1,t:"Set the Character Set During Subfile Extraction",i:0.00322392247013707,a:"Set the Character Set During  Subfile Extraction You can convert the character set of a subfile at the time the subfile is extracted from the container and before it is filtered. This is most often used to set the character set of a mail message\u0027s body text. See  Filter PDF Files  for more ..."},"51":{y:0,u:"../Content/C++/filter_api/Prevent_the_Default_Conv.htm",l:-1,t:"Customize Character Set Detection and Conversion",i:0.00322392247013707,a:"KeyView attempts to detect the character set of an input file by default. Some character sets (including ANSI, UTF-8, and UTF-16) can be detected by core KeyView functionality but others can only be detected if your license includes advanced character set detection. If your license includes advanced ..."},"52":{y:0,u:"../Content/C++/filter_api/Extract_Deleted_Text_Mar.htm",l:-1,t:"Extract Deleted Text Marked by Tracked Changes",i:0.00322392247013707,a:"The revision tracking feature in applications—such as Microsoft Word\u0027s  Track Changes—marks changes to a document (typically, strikethrough for deleted text and underline for inserted text) and tracks each change by reviewer name and date.  If revision tracking was enabled when text was deleted from ..."},"53":{y:0,u:"../Content/kv_xtract_api_cpp/_KV_xtract_cpp_Filter_File.htm",l:-1,t:"Filter a File",i:0.00322392247013707,a:"Filter a File You can get a plaintext version of the file content by using the  filter  method: auto myinput = keyview::io::InputFile{ std::string(\"InputFile.docx\") };\nauto myoutput = keyview::io::OutputFile{ std::string(\"out.txt\") };\nKV.filter(myinput, myoutput);"},"54":{y:0,u:"../Content/C++/filter_api/Filter_PDF_Files.htm",l:-1,t:"Filter PDF Files",i:0.00596429817301772,a:"Filter PDF Files Filter has special configuration options that allow greater control over the conversion of Adobe Acrobat PDF files."},"55":{y:0,u:"../Content/C++/filter_api/Filter_PDF_LogicalOrder.htm",l:-1,t:"Filter PDF Files to a Logical Reading Order",i:0.00322392247013707,a:"The PDF format is primarily designed for presentation and printing of brochures, magazines, forms, reports, and other materials with complex visual designs. Most PDF files do not contain the logical structure of the original document—the correct reading order, for example, and the presence and ..."},"56":{y:0,u:"../Content/C++/filter_api/Rotated_Text.htm",l:-1,t:"Rotated Text",i:0.00322392247013707,a:"When a PDF that contains rotated text is filtered, the rotated text is extracted after the text at the end of the PDF page on which the rotated text appears. If the PDF is filtered with logical order enabled, and the amount of rotated text on a page surpasses a predefined threshold,  the page is ..."},"57":{y:0,u:"../Content/C++/filter_api/Extract_Custom_Metadata_PDF.htm",l:-1,t:"Extract Custom Metadata from PDF Files",i:0.00322392247013707,a:"Extract Custom Metadata  from PDF Files You can extract custom metadata from PDF files either by specifying individual metadata tag names, or by extracting all custom metadata at once. Extract All Custom Metadata You can extract all metadata through the API. To extract all metadata by using the API ..."},"58":{y:0,u:"../Content/C++/filter_api/Filter_Tagged_PDF_Content.htm",l:-1,t:"Filter Tagged PDF Content",i:0.00322392247013707,a:"A tagged PDF contains an additional layer of text for visually impaired readers. This text is used in text-to-speech features in various PDF viewing programs. You can enable filtering of tagged PDF text in the API. Filtering the extra layer of tagged content might result in duplicate text in the ..."},"59":{y:0,u:"../Content/C++/filter_api/Skip_Embedded_Fonts.htm",l:-1,t:"Skip Embedded Fonts",i:0.00322392247013707,a:"Text in PDF files sometimes contains embedded fonts. If you experience difficulties filtering embedded fonts, there are options in the API, the formats.ini file, and the filter sample program that enable you to skip this type of text. If you skip embedded fonts, none of the content that contains ..."},"60":{y:0,u:"../Content/C++/filter_api/Control_Hyphenation.htm",l:-1,t:"Control Hyphenation",i:0.00322392247013707,a:"There are two types of hyphens in a PDF document:  A soft hyphen is added to a word by a word processor to divide the word across two lines. This is a discretionary hyphen and is used to ensure proper text flow in justified text. A hard hyphen is intentionally added to a word regardless of the ..."},"61":{y:0,u:"../Content/C++/filter_api/Filter_Portfolio_PDF.htm",l:-1,t:"Filter Portfolio PDF Files",i:0.00322392247013707,a:"Filter Portfolio PDF Files Portfolio PDF files contain subfiles and an ActionScript interface for navigating between them. You can use the extraction API to extract the subfiles. See  Extract Subfiles from PDF Files ."},"62":{y:0,u:"../Content/C++/filter_api/Filter_Spreadsheet_Files.htm",l:-1,t:"Filter Spreadsheet Files",i:0.00322392247013707,a:"Filter Spreadsheet Files Filter has special configuration options that enable greater control over the conversion of spreadsheet files."},"63":{y:0,u:"../Content/C++/filter_api/Filter_Worksheet_Names.htm",l:-1,t:"Filter Worksheet Names",i:0.00322392247013707,a:"Filter  Worksheet Names Normally, Filter does not extract worksheet names from a spreadsheet because it is assumed that the text should not be exposed. To extract worksheet names, add the following lines to the  formats.ini file: [Options]\ngetsheetnames=1"},"64":{y:0,u:"../Content/C++/filter_api/Filter_Hidden_Text_in_Mi.htm",l:-1,t:"Filter Hidden Text in Microsoft Excel Files",i:0.00322392247013707,a:"Filter  Hidden Text in Microsoft Excel Files Normally, Filter does not filter hidden text from a Microsoft Excel spreadsheet because it is assumed that the text should not be exposed. To extract text from hidden rows, columns, and sheets from Excel spreadsheets, add the following lines to the ..."},"65":{y:0,u:"../Content/C++/filter_api/Specify_Date_and_Time_Fo.htm",l:-1,t:"Specify Date and Time Format on UNIX Systems",i:0.00322392247013707,a:"In Microsoft Excel you can choose to format dates and times according to the system locale.  On Windows, KeyView uses the system locale settings to determine how these dates and times should be formatted.  In other operating systems, KeyView uses the U.S. short date format (mm/dd/yyyy).  You can ..."},"66":{y:0,u:"../Content/C++/filter_api/large_numbers_excel.htm",l:-1,t:"Filter Very Large Numbers in Spreadsheet Cells to Precision Numbers",i:0.00322392247013707,a:"By default, numbers are extracted in the format specified by the Excel file (for example, General, Currency and Date). Spreadsheets might contain cells that have very large numbers in them. Excel displays the numbers in a scientific notation that rounds or truncates the numbers.  To extract numbers ..."},"67":{y:0,u:"../Content/C++/filter_api/Extract_Microsoft_Excel_.htm",l:-1,t:"Extract Microsoft Excel Formulas",i:0.0214818484939994,a:"Normally, the actual value of a  formula is extracted from an Excel spreadsheet; the formula from which the value is derived is not included in the output. However, KeyView enables you to include the value as well as the formula in the output. For example, if Filter is configured to extract the ..."},"68":{y:0,u:"../Content/filter_shared/custom_headerfooter.htm",l:-1,t:"Configure Headers and Footers",i:0.00322392247013707,a:"You can configure custom header and footer tags for word processing and spreadsheet documents  by editing the formats.ini file. To configure headers and footers Open the formats.ini file. In the [Options] section, add the following items: ..."},"69":{y:0,u:"../Content/C++/filter_api/Filter_Hidden_Data.htm",l:-1,t:"Filter Hidden Data",i:0.00322392247013707,a:"Filter Hidden Data Some documents contain hidden information, which is not filtered by default. Depending on the type of hidden data that you want to filter and the type of document that you are filtering, you can either use the API or set parameters in the formats.ini file."},"70":{y:0,u:"../Content/C++/filter_api/Hidden_Data_HTML.htm",l:-1,t:"Hidden Data in HTML Documents",i:0.00322392247013707,a:"KeyView can filter comments from HTML documents. To enable comment filtering, you must set a flag in the formats.ini file. To enable filtering of comments from HTML files Open the formats.ini file in a text editor. Under [Options], set the following flag. GetHTMLHiddenInfo= 1"},"71":{y:0,u:"../Content/Shared/_KV_Tab_Delimited_Output.htm",l:-1,t:"Tab Delimited Output for Embedded Tables",i:0.00322392247013707,a:"You can use KeyView to convert embedded tables in Word Processing documents (for example, Microsoft Word) to tab-delimited form, by specifying the following option in the formats.ini file: [Options]\nTabDelimited=TRUE This option inserts a tab character between each cell, and a line break between ..."},"72":{y:0,u:"../Content/Shared/_KV_Table_Detection_PDF.htm",l:-1,t:"Table Detection for PDF Files",i:0.00322392247013707,a:"PDF files often contain data presented in a tabular form. However, there is no information about the table stored within the PDF itself – the text is simply placed in  an arrangement that looks like a table to the human eye. When this data is filtered, it can be very difficult to reconstruct the ..."},});