define({"537":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldNames.htm",l:-1,t:"getFieldNames",i:0.000476361822834668,a:"The getFieldNames method returns the names of the sub fields in the LuaField object. Syntax getFieldNames() Returns (Strings). The names of the sub fields. The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: fieldnames = { ..."},"538":{y:0,u:"../Content/Lua/LuaField/_LUA_getFields.htm",l:-1,t:"getFields",i:0.000476361822834668,a:"The getFields method returns all of the sub fields specified by the name argument. Syntax getFields( name [, case] ) Arguments Returns (LuaFields) One LuaField per matching field. The objects can be assigned to a table. To map the return values to a table, surround the function call with braces. For ..."},"539":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldsByRegex.htm",l:-1,t:"getFieldsByRegex",i:0.000476361822834668,a:"The getFieldsByRegex method returns all sub fields where the sub field name or path (relative to this field) matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField ..."},"540":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldValues.htm",l:-1,t:"getFieldValues",i:0.000476361822834668,a:"The getFieldValues method returns the values of all of the sub fields with the specified name. Syntax getFieldValues( fieldname [, case] ) Arguments Returns (Strings) One string for each value. The strings can be assigned to a table. To map the return values to a table, surround the function call ..."},"541":{y:0,u:"../Content/Lua/LuaField/_LUA_getValueByPath.htm",l:-1,t:"getValueByPath",i:0.000476361822834668,a:"The getValueByPath method gets the value of a sub-field, specified by path.   If you pass this method the path of a sub-field that has multiple values, only the first value is returned. To return all of the values from a multi-value sub-field, see  getValuesByPath . Syntax getValueByPath( path ) ..."},"542":{y:0,u:"../Content/Lua/LuaField/_LUA_getValuesByPath.htm",l:-1,t:"getValuesByPath",i:0.000881269675777249,a:"The getValuesByPath method gets the values of a sub-field, specified by path.   Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ..."},"543":{y:0,u:"../Content/Lua/LuaField/_LUA_hasAttribute.htm",l:-1,t:"hasAttribute",i:0.000476361822834668,a:"hasAttribute The hasAttribute method returns a Boolean indicating whether the field has the specified attribute. Syntax hasAttribute( name ) Arguments Returns (Boolean). A Boolean specifying if the field has the specified attribute."},"544":{y:0,u:"../Content/Lua/LuaField/_LUA_hasField.htm",l:-1,t:"hasField",i:0.000476361822834668,a:"hasField The hasField method returns a Boolean specifying if the sub field exists. Syntax hasField( fieldname [, case]) Arguments Returns (Boolean). A Boolean specifying if the sub field exists or not."},"545":{y:0,u:"../Content/Lua/LuaField/_LUA_insertJson.htm",l:-1,t:"insertJson",i:0.000476361822834668,a:"insertJson The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into the field. Syntax insertJson ( json [, fieldName] ) Arguments See Also LuaDocument:insertJson"},"546":{y:0,u:"../Content/Lua/LuaField/_LUA_insertXml.htm",l:-1,t:"insertXml",i:0.000476361822834668,a:"insertXml The insertXml method inserts XML metadata into the document. When called on a LuaField, the insertXml method inserts the fields as children of the LuaField. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data."},"547":{y:0,u:"../Content/Lua/LuaField/_LUA_insertXmlWithoutRoot.htm",l:-1,t:"insertXmlWithoutRoot",i:0.000476361822834668,a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ..."},"548":{y:0,u:"../Content/Lua/LuaField/_LUA_name.htm",l:-1,t:"name",i:0.000476361822834668,a:"name The name method returns the name of the field object. Syntax name() Returns (String). The name of the field object."},"549":{y:0,u:"../Content/Lua/LuaField/_LUA_renameField.htm",l:-1,t:"renameField",i:0.000476361822834668,a:"renameField The renameField method renames a sub field. Syntax renameField( oldname, newname [, case] ) Arguments"},"550":{y:0,u:"../Content/Lua/LuaField/_LUA_setAttributeValue.htm",l:-1,t:"setAttributeValue",i:0.000476361822834668,a:"setAttributeValue The setAttributeValue method sets the value for the specified attribute of the field. Syntax setAttributeValue( attribute, value ) Arguments"},"551":{y:0,u:"../Content/Lua/LuaField/_LUA_setValue.htm",l:-1,t:"setValue",i:0.000476361822834668,a:"setValue The setValue method sets the value of the field. Syntax setValue( value ) Arguments"},"552":{y:0,u:"../Content/Lua/LuaField/_LUA_value.htm",l:-1,t:"value",i:0.000476361822834668,a:"value The value method returns the value of the field object. Syntax value() Returns (String). The value of the field object."},"553":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA__LuaHttpRequest.htm",l:-1,t:"LuaHttpRequest Methods",i:0.000606795676288571,a:"This section describes the methods provided by LuaHttpRequest objects. If you have a LuaHttpRequest object called request you can call its methods using the \u0027:\u0027 operator. For example: request:send() Method Description send Sends the HTTP request. set_body Sets the body of the HTTP request. ..."},"554":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_LuaHttpRequest_new.htm",l:-1,t:"LuaHttpRequest:new",i:0.000525170172641246,a:"The constructor for a LuaHttpRequest object (creates a new LuaHttpRequest). Syntax LuaHttpRequest:new( config, section ) Arguments Returns (LuaHttpRequest). The new LuaHttpRequest object. Example The following example creates a new LuaHttpRequest object by reading configuration settings from a ..."},"555":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_send.htm",l:-1,t:"send",i:0.000671267772336068,a:"The send method sends the HTTP request. Syntax send() Returns (LuaHttpResponse). A  LuaHttpResponse  object. The send method can throw an exception if the request fails. You can catch an exception by calling the method  using the Lua function pcall. Example The following example shows how to send a ..."},"556":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_body.htm",l:-1,t:"set_body",i:0.000525170172641246,a:"set_body The set_body method sets the body of the HTTP request. Syntax set_body( body ) Arguments"},"557":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_config.htm",l:-1,t:"set_config",i:0.000525170172641246,a:"The set_config method specifies settings to use for sending the HTTP request (in the form of a section from a configuration file). For example, you can specify the proxy server to use by setting the parameters ProxyHost and ProxyPort, or specify the SSL version to use by setting SSLMethod. Syntax ..."},"558":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_header.htm",l:-1,t:"set_header",i:0.000971565170599688,a:"set_header The set_header method adds a header to the HTTP request. Syntax set_header( name, value ) Arguments Example request:set_header(\"X-EXAMPLE\", \"Example\")"},"559":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_headers.htm",l:-1,t:"set_headers",i:0.000525170172641246,a:"set_headers The set_headers method replaces all headers in the HTTP request with new headers. To add a header without changing existing headers, use the method  set_header . Syntax set_headers( headers ) Arguments Example request:set_headers( {X-EXAMPLE=\"Example\", X-ANOTHER=\"ANOTHER\"} )"},"560":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_method.htm",l:-1,t:"set_method",i:0.000525170172641246,a:"set_method Specifies the HTTP request method to use when sending the request, for example GET or POST.  Syntax set_method( method ) Arguments Example request:set_method(\"POST\")"},"561":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_url.htm",l:-1,t:"set_url",i:0.000525170172641246,a:"set_url The set_url method sets the URL that you want to send the HTTP request to. Syntax set_url( url ) Arguments Example request:set_url(\"https://www.example.com/\")"},"562":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA__LuaHttpResponse.htm",l:-1,t:"LuaHttpResponse Methods",i:0.0010312761869092,a:"This section describes the methods provided by LuaHttpResponse objects. A LuaHttpResponse object is provided when you send an HTTP request using the  send  method on a  LuaHttpRequest  object. If you have a LuaHttpResponse object called response you can call its methods using the \u0027:\u0027 operator. For ..."},"563":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_body.htm",l:-1,t:"get_body",i:0.000606795676288571,a:"get_body The get_body method returns the body of the HTTP response. Syntax get_body() Returns (String). The body of the HTTP response."},"564":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_header.htm",l:-1,t:"get_header",i:0.000606795676288571,a:"get_header The get_header method returns the value of a specified HTTP header. Syntax get_header( name ) Arguments Returns (String). The value of the header."},"565":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_headers.htm",l:-1,t:"get_headers",i:0.000606795676288571,a:"The get_headers method returns the names and values of all of the headers in the HTTP response. Syntax get_headers() Returns (table) A table that maps header names to values. Example The following example sends an HTTP request and then prints the headers that are returned to the console: local ..."},"566":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",l:-1,t:"get_http_code",i:0.000606795676288571,a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found."},"567":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",l:-1,t:"LuaJsonArray Methods",i:0.00257936376903529,a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Method Description append Appends a value to the array. clear Clears the array, so that it contains no values. copy ..."},"568":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",l:-1,t:"LuaJsonArray:new",i:0.000643403200501433,a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Returns (LuaJsonArray). The new LuaJsonArray object. Example The following is a simple JSON array: [4, \"a string\", true] To create a LuaJsonArray object to represent this array: local ..."},"569":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_append.htm",l:-1,t:"append",i:0.000643403200501433,a:"append The append method appends a value to the JSON array. Syntax append( value ) Arguments Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:append(6)\n-- the array is now [4, \"a string\", true, 6]"},"570":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_clear.htm",l:-1,t:"clear",i:0.000643403200501433,a:"clear The clear method clears the array, so that it contains no values. Syntax clear() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:clear()\nprint (myJsonArray:string())\n-- []"},"571":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_copy.htm",l:-1,t:"copy",i:0.000643403200501433,a:"The copy method returns a copy of the array. Modifying the copy does not modify the original array. Syntax copy() Returns (LuaJsonArray). A copy of the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nlocal anotherJsonArray = myJsonArray:copy()\nprint ..."},"572":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_empty.htm",l:-1,t:"empty",i:0.000643403200501433,a:"The empty method checks whether the JSON array is empty. Syntax empty() Returns (Boolean). Returns true if the array is empty. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nprint (\"Is the array empty?  \" , myJsonArray:empty() )\n-- Is the array empty?   ..."},"573":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_exists.htm",l:-1,t:"exists",i:0.00428927307197919,a:"The exists method checks whether a specified path exists in the JSON array. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ..."},"574":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00428927307197919,a:"The existsByPath method checks whether a specified path exists in the JSON array. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ..."},"575":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_ipairs.htm",l:-1,t:"ipairs",i:0.000643403200501433,a:"The ipairs method returns a function that you can use with a for loop to iterate over all of the values in the array. Syntax ipairs() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nfor i, v in myJsonArray:ipairs() do\n  print (v:string())\nend\n\n-- prints the following...\n-- 4\n-- a ..."},"576":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00428927307197919,a:"The lookup method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ..."},"577":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00428927307197919,a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"578":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_size.htm",l:-1,t:"size",i:0.000643403200501433,a:"size The size method returns the size of the JSON array. Syntax size() Returns (integer). The number of values in the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nprint (\"Array size is \" , myJsonArray:size() )\n-- Array size is 3"},"579":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_string.htm",l:-1,t:"string",i:0.000643403200501433,a:"The string method returns the JSON array as a string. Syntax string() Returns (String). The array as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = LuaJsonArray:new(\"zero\",1,2,myJsonObject)\n\nprint (myJsonArray:string())\n-- ..."},"580":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA__LuaJsonObject.htm",l:-1,t:"LuaJsonObject Methods",i:0.00257936376903529,a:"A LuaJsonObject object represents a JSON object. If you have a LuaJsonObject object called object you can call its methods using the \u0027:\u0027 operator. For example: object:size() Method Description assign Adds an attribute (a name/value pair) to the object. assign Adds a table of attributes (name/value ..."},"581":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_LuaJsonObject_new.htm",l:-1,t:"LuaJsonObject:new",i:0.000617302468514621,a:"The constructor for a LuaJsonObject object (creates a new LuaJsonObject). If you do not specify any attributes to assign to the object (by omitting the attributes argument), an empty object is created. Syntax LuaJsonObject:new( [attributes] ) Arguments Returns (LuaJsonObject). The new LuaJsonObject ..."},"582":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_assign.htm",l:-1,t:"assign",i:0.000617302468514621,a:"The assign method adds an attribute (a name/value pair) to the object. Syntax assign (name, value) Arguments Example local myJsonObject = LuaJsonObject:new( { name1=\"value1\" , name2=\"value2\" } )\nmyJsonObject:assign(\"name3\", \"value3\")\nmyJsonObject:assign(\"name4\", LuaJsonArray:new(\"value4a\",\"value4b\") ..."},"583":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_assign2.htm",l:-1,t:"assign",i:0.000617302468514621,a:"The assign method adds a table of attributes (name/value pairs) to the object. Syntax assign (attributes) Arguments Example local myJsonObject = LuaJsonObject:new()\nmyJsonObject:assign( {\n        attr1=LuaJsonObject:new( { n=42 } ),\n        attr2=LuaJsonArray:new( 1, 2, \"three\" ),\n        ..."},"584":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_clear.htm",l:-1,t:"clear",i:0.000617302468514621,a:"clear The clear method clears the object, so that it contains no attributes (name/value pairs). Syntax clear() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:clear()\nprint (myJsonObject:string())\n-- {}"},"585":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_copy.htm",l:-1,t:"copy",i:0.000617302468514621,a:"The copy method returns a copy of the JSON object. Modifying the copy does not modify the original object. Syntax copy() Returns (LuaJsonObject). A copy of the object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal anotherJsonObject = ..."},"586":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_empty.htm",l:-1,t:"empty",i:0.000617302468514621,a:"empty The empty method determines whether the JSON object is empty. Syntax empty() Returns (Boolean). Returns true if the object has no attributes (name/value pairs). Example local myJsonObject = LuaJsonObject:new()\nprint(myJsonObject:empty())\n-- true\n"},"587":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_erase.htm",l:-1,t:"erase",i:0.000617302468514621,a:"erase The erase method removes a specified attribute (name/value pair) from the JSON object. Syntax erase( name ) Arguments Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:erase(\"version\")\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\"}"},"588":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_exists.htm",l:-1,t:"exists",i:0.00411527272265466,a:"The exists method checks whether a specified path exists in the JSON object. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"589":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00411527272265466,a:"The existsByPath method checks whether a specified path exists in the JSON object. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"590":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00411527272265466,a:"The lookup method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"591":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00411527272265466,a:"The lookupByPath method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"592":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_pairs.htm",l:-1,t:"pairs",i:0.000617302468514621,a:"The pairs method returns an iterator function that you can use with a for loop to iterate over all of the attributes contained in the JSON object. Syntax pairs() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\n\nfor i, v in myJsonObject:pairs() do\n  print (i .. \u0027=\u0027 ..."},"593":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_size.htm",l:-1,t:"size",i:0.000617302468514621,a:"size The size method returns the number of attributes (name/value pairs) in the JSON object. Syntax size() Returns (Number). The number of attributes in the JSON object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:size())\n-- 2"},"594":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_string.htm",l:-1,t:"string",i:0.000617302468514621,a:"string The string method returns the JSON object as a string. Syntax string() Returns (String). The JSON object as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\",\"version\":11}"},"595":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA__LuaJsonValue.htm",l:-1,t:"LuaJsonValue Methods",i:0.00215958410771938,a:"A LuaJsonValue object represents a JSON value.  If you have a LuaJsonValue object called myJsonValue you can call its methods using the \u0027:\u0027 operator. For example: myJsonValue:is_object() Method Description array Gets a LuaJsonArray that represents the JSON array, if the value is an array. copy ..."},"596":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_LuaJsonValue_new.htm",l:-1,t:"LuaJsonValue:new",i:0.000557311152991762,a:"LuaJsonValue:new The constructor for a LuaJsonValue object (creates a new LuaJsonValue). Syntax LuaJsonValue:new( value ) Arguments Returns (LuaJsonValue). The new LuaJsonValue object."},"597":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_array.htm",l:-1,t:"array",i:0.000557311152991762,a:"The array method gets the array, if the value is a JSON array. Syntax array() Returns (LuaJsonArray). A  LuaJsonArray  object that represents the array. Example local fh = io.open(\"example_array.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = ..."},"598":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_copy.htm",l:-1,t:"copy",i:0.000557311152991762,a:"copy The copy method returns a copy of the value. Modifying the copy does not affect the original value. Syntax copy() Returns (LuaJsonValue). A copy of the value."},"599":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_exists.htm",l:-1,t:"exists",i:0.00371534071382026,a:"The exists method checks whether a specified path exists in the JSON value. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"600":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00371534071382026,a:"The existsByPath method checks whether a specified path exists in the JSON value.  Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"601":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_array.htm",l:-1,t:"is_array",i:0.000557311152991762,a:"is_array The is_array method whether the value is a JSON array. Syntax is_array() Returns (Boolean). Returns true if the value is an array value, false otherwise."},"602":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_boolean.htm",l:-1,t:"is_boolean",i:0.000557311152991762,a:"is_boolean The is_boolean method returns whether the value is a Boolean value. Syntax is_boolean() Returns (Boolean). Returns true if the value is a Boolean value, false otherwise."},"603":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_float.htm",l:-1,t:"is_float",i:0.000557311152991762,a:"is_float The is_float method returns whether the value is a floating point value. Syntax is_float() Returns (Boolean). Returns true if the value is a floating point value, false otherwise."},"604":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_integer.htm",l:-1,t:"is_integer",i:0.000557311152991762,a:"is_integer The is_integer method returns whether the value is an integral value. Syntax is_integer() Returns (Boolean). Returns true if the value is an integer value, false otherwise."},"605":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_null.htm",l:-1,t:"is_null",i:0.000557311152991762,a:"is_null The is_null method returns whether the value is a null value. Syntax is_null() Returns (Boolean). Returns true if the value is a null value, false otherwise."},"606":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_number.htm",l:-1,t:"is_number",i:0.000557311152991762,a:"is_number The is_number method returns whether the value is a number. Syntax is_number() Returns (Boolean). Returns true if the value is a number, false otherwise."},"607":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_object.htm",l:-1,t:"is_object",i:0.000557311152991762,a:"is_object The is_object method returns whether the value is a JSON object. Syntax is_object() Returns (Boolean). Returns true if the value is a JSON object, false otherwise."},"608":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_simple_value.htm",l:-1,t:"is_simple_value",i:0.000557311152991762,a:"is_simple_value The is_simple_value method returns whether the value is a simple value (Boolean, float, integer, or string). Syntax is_simple_value() Returns (Boolean). Returns true if the value is a simple value, false otherwise."},"609":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_string.htm",l:-1,t:"is_string",i:0.000557311152991762,a:"is_string The is_string method returns whether the value is a string value. Syntax is_string() Returns (Boolean). Returns true if the value is a string value, false otherwise."},"610":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00371534071382026,a:"The lookup method returns the value at the specified path in the JSON value. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ..."},"611":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00371534071382026,a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"612":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_object.htm",l:-1,t:"object",i:0.000557311152991762,a:"The object method gets the object, if the value is a JSON object. Syntax object() Returns (LuaJsonObject) A  LuaJsonObject  object that represents the JSON object. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n\nlocal myJsonValue = ..."},"613":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_string.htm",l:-1,t:"string",i:0.000557311152991762,a:"The string method returns the JSON value as a string. Syntax string() Returns (String). The JSON value as a string. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = parse_json(file_content)\n\nprint(myJsonValue:string())\n"},"614":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_value.htm",l:-1,t:"value",i:0.000557311152991762,a:"The value method gets the value, if the JSON value is a simple type (a Boolean, float, integer, or string). This method returns a default value if one is specified and the value cannot be converted to the same type as the default. Syntax value( [default] ) Arguments Returns (lua_json_simple_type). A ..."},"615":{y:0,u:"../Content/Lua/LuaLog/_LUA_LuaLog.htm",l:-1,t:"LuaLog Methods",i:0.00400015781305121,a:"LuaLog Methods A LuaLog object provides the capability to use a log stream. You can obtain a LuaLog object for a log stream by using the function  get_log . If you have a LuaLog object called log you can call its methods using the \u0027:\u0027 operator. For example: log:write_line(level, message)"},"616":{y:0,u:"../Content/Lua/LuaLog/_LUA_write_line.htm",l:-1,t:"write_line",i:0.00216076800570546,a:"The write_line method writes a message to the log stream. Syntax write_line( level, message ) Arguments Example local config = get_config(\"connector.cfg\")\nlocal log = get_log(config, \"SynchronizeLogStream\")\nlog:write_line( log_level_error() , \"This message is written to the synchronize log\")"},"617":{y:0,u:"../Content/Lua/LuaLogService/_LUA__LuaLogService.htm",l:-1,t:"LuaLogService Methods",i:0.000609720025372525,a:"A LuaLogService object provides the capability to write messages to a standard or custom log file. If you have a LuaLogService object called myLogService you can call its methods using the \u0027:\u0027 operator. For example: myLogService:get_log(\"application\") Method Description get_log Returns a LuaLog ..."},"618":{y:0,u:"../Content/Lua/LuaLogService/_LUA_LuaLogService_new.htm",l:-1,t:"LuaLogService:new",i:0.000719829301513225,a:"The constructor for a LuaLogService object (creates a new LuaLogService). Do not create a new log service to write messages to log types that are defined in the Amazon S3 Connector configuration file. Instead use the same log service as Amazon S3 Connector, by calling  get_log_service , or obtain a ..."},"619":{y:0,u:"../Content/Lua/LuaLogService/_LUA_get_log.htm",l:-1,t:"get_log",i:0.000719829301513225,a:"get_log The get_log method returns a LuaLog object that you can use to write log messages to a specified log type. Syntax get_log( type ) Arguments Returns (LuaLog). A  LuaLog  object. Example local log = myLuaLogService:get_log(\"import\")\n-- import is a standard log type for CFS"},"620":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_LuaRegexMatch_Methods.htm",l:-1,t:"LuaRegexMatch Methods",i:0.000460698076593749,a:"A LuaRegexMatch object provides information about the matches for a regular expression found in a string. For example, the regex_search function returns a LuaRegexMatch object. If a match is found for a regular expression at multiple points in the string, you can use the next() method to get a ..."},"621":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_length.htm",l:-1,t:"length",i:0.000539016807798342,a:"length The length method returns the length of the match. You can also retrieve the length of sub matches by specifying the submatch parameter. Syntax length( [ submatch ] ) Arguments Returns (Number). The length of the sub match."},"622":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_next.htm",l:-1,t:"next",i:0.000539016807798342,a:"next The next method returns a LuaRegexMatch object for the next match. Syntax next() Returns (LuaRegexMatch). A LuaRegexMatch object for the next match, or nil if there are no matches following this one."},"623":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_position.htm",l:-1,t:"position",i:0.000539016807798342,a:"The position method returns the position of the match in the string searched, where 1 refers to the first character in the string. You can also retrieve the position of sub matches by specifying the submatch parameter. Syntax position( [ submatch ] ) Arguments Returns (Number). The position of the ..."},"624":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_size.htm",l:-1,t:"size",i:0.000539016807798342,a:"size The size method returns the total number of sub matches made for the current match, including the whole match (sub match 0). Syntax size() Returns (Number). The number of sub matches for the current match."},"625":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_str.htm",l:-1,t:"str",i:0.000539016807798342,a:"str The str method returns the value of the substring that matched the regular expression. You can also retrieve the values of sub matches by specifying the submatch parameter. Syntax str( [ submatch ] ) Arguments Returns (String). The value of the sub match."},"626":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_LuaXmlDocument_Methods.htm",l:-1,t:"LuaXmlDocument Methods",i:0.000460698076593749,a:"This section describes the methods provided by LuaXmlDocument objects. A LuaXmlDocument object provides methods for accessing information stored in XML format. You can create a LuaXmlDocument from a string containing XML using the parse_xml function. If you have a LuaXmlDocument object called xml ..."},"627":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_root.htm",l:-1,t:"root",i:0.000539016807798342,a:"root The root method returns an LuaXmlNode, which is the root node of the XML document. Syntax root() Returns (LuaXmlNode). A LuaXmlNode object."},"628":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathExecute.htm",l:-1,t:"XPathExecute",i:0.000539016807798342,a:"XPathExecute The XPathExecute method returns a LuaXmlNodeSet, which is the result of the supplied XPath query. Syntax XPathExecute( xpathQuery ) Arguments Returns (LuaXmlNodeSet). A LuaXmlNodeSet object."},"629":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathRegisterNs.htm",l:-1,t:"XPathRegisterNs",i:0.000539016807798342,a:"XPathRegisterNs The XPathRegisterNs method registers a namespace with the XML parser. Syntax XPathRegisterNs( prefix, location ) Arguments Returns (Boolean). True if successful, False in case of error."},"630":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValue.htm",l:-1,t:"XPathValue",i:0.000539016807798342,a:"XPathValue The XPathValue method returns the first occurrence of the value matching the XPath query. Syntax XPathValue( query ) Arguments Returns (String). A string of the value."},"631":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValues.htm",l:-1,t:"XPathValues",i:0.000539016807798342,a:"The XPathValues method returns the values according to the XPath query. Syntax XPathValues( query ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: values = { xml:XPathValues(query) }"},"632":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_LuaXmlNodeSet_Methods.htm",l:-1,t:"LuaXmlNodeSet Methods",i:0.000460698076593749,a:"LuaXmlNodeSet Methods A LuaXmlNodeSet object represents a set of XML nodes. If you have a LuaXmlNodeSet object called nodes you can call its methods using the \u0027:\u0027 operator. For example: nodes:size()"},"633":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_at.htm",l:-1,t:"at",i:0.000656494904605231,a:"at The at method returns the LuaXmlNode at position position in the set. Syntax at( position ) Arguments Returns (LuaXmlNode)."},"634":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_size.htm",l:-1,t:"size",i:0.000656494904605231,a:"size The size method returns the size of the node set. Syntax size() Returns (Number) An integer, the size of the node set."},"635":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_LuaXmlNode_Methods.htm",l:-1,t:"LuaXmlNode Methods",i:0.000460698076593749,a:"LuaXmlNode Methods A LuaXmlNode object represents a single node in an XML document.  If you have a LuaXmlNode object called node you can call its methods using the \u0027:\u0027 operator. For example: node:name()"},"636":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_attr.htm",l:-1,t:"attr",i:0.000499857442196046,a:"attr The attr method returns the first LuaXmlAttribute attribute object for the LuaXmlNode. If the name argument is specified, the method returns the first LuaXmlAttribute object with the specified name. Syntax attr( [name] ) Arguments Returns (LuaXmlAttribute). "},"637":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_content.htm",l:-1,t:"content",i:0.000499857442196046,a:"content The content method returns the content (text element) of the XML node. Syntax content() Returns (String). A string containing the content."},"638":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_firstChild.htm",l:-1,t:"firstChild",i:0.000499857442196046,a:"firstChild The firstChild method returns the LuaXmlNode that is the first child of this node. Syntax firstChild() Returns (LuaXmlNode)."},"639":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_lastChild.htm",l:-1,t:"lastChild",i:0.000499857442196046,a:"lastChild The lastChild method returns the LuaXmlNode that is the last child of this node. Syntax lastChild() Returns (LuaXmlNode)."},"640":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_name.htm",l:-1,t:"name",i:0.000499857442196046,a:"name The name method returns the name of the XML node. Syntax name() Returns (String). A string containing the name."},"641":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_next.htm",l:-1,t:"next",i:0.000499857442196046,a:"next The next method returns the LuaXmlNode that is the next sibling of this node. Syntax next() Returns (LuaXmlNode)."},"642":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_nodePath.htm",l:-1,t:"nodePath",i:0.000499857442196046,a:"nodePath The nodePath method returns the XML path to the node, which can be used in another XPath query. Syntax nodePath() Returns (String). A string containing the path."},"643":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_parent.htm",l:-1,t:"parent",i:0.000499857442196046,a:"parent The parent method returns the parent LuaXmlNode of the node. Syntax parent() Returns (LuaXmlNode)."},"644":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_prev.htm",l:-1,t:"prev",i:0.000499857442196046,a:"prev The prev method returns a LuaXmlNode that is the previous sibling of this node. Syntax prev() Returns (LuaXmlNode)."},"645":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_type.htm",l:-1,t:"type",i:0.000499857442196046,a:"The type method returns the type of the node as a string. Syntax type() Returns (String) A string containing the type. Possible values are: element_node comment_node element_decl attribute_node document_node attribute_decl text_node document_type_node entity_decl cdata_section_node ..."},"646":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_LuaXmlAttribute_Methods.htm",l:-1,t:"LuaXmlAttribute Methods",i:0.000460698076593749,a:"LuaXmlAttribute Methods A LuaXmlAttribute object represents an attribute on an XML element. If you have a LuaXmlAttribute object called attribute you can call its methods using the \u0027:\u0027 operator. For example: attribute:name()"},"647":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_name.htm",l:-1,t:"name",i:0.00055859649059949,a:"name The name method returns the name of this attribute. Syntax name() Returns (String). A string containing the name of the attribute."},"648":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_next.htm",l:-1,t:"next",i:0.00055859649059949,a:"next The next method returns a LuaXmlAttribute object for the next attribute in the parent element. Syntax next() Returns (LuaXmlAttribute)."},"649":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_prev.htm",l:-1,t:"prev",i:0.00055859649059949,a:"prev The prev method returns a LuaXmlAttribute object for the previous attribute in the parent element. Syntax prev() Returns (LuaXmlAttribute)."},"650":{y:0,u:"../Content/Lua/LuaXmlAttribute/_LUA_value.htm",l:-1,t:"value",i:0.00055859649059949,a:"value The value method returns the value of this attribute. Syntax value() Returns (String). A string containing the value of the attribute."},"651":{y:0,u:"../Content/Resources/MasterPages/_FT_Glossary.htm",l:-1,t:"Glossary",i:0.000460698076593749,a:"Glossary"},"652":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_MaxPriority.htm",l:-1,t:"Max-Priority",i:0.00218463555933889,a:"Max-Priority Use this parameter when QueueAction=GetStatus, to filter the actions that are returned. When this parameter is set, the connector only returns actions that have a priority the same as or below the specified value. "},"653":{y:0,u:"../Content/Service/ServiceActions/_ACI_Name.htm",l:-1,t:"Name",i:0.00104444784100699,a:"Name Type the name of the log stream you want to return. To retrieve a list of log stream names, use the  GetLogStreamNames  service action."},"654":{y:0,u:"../Content/Actions/General/_ACI_IP.htm",l:-1,t:"IP",i:0.00104406694679827,a:"IP The IP address for which to check permissions. By default, the  ShowPermissions  action checks the permissions for the client that sends the request."},"655":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_QueuedBefore.htm",l:-1,t:"Queued-Before",i:0.00218463555933889,a:"Use this parameter when QueueAction=GetStatus, to filter the actions that are returned. When this parameter is set, the server only returns actions that were added to the queue before the specified date and time. Specify the date and time in one of the following formats: YYYY-MM-DD HH:NN:SS ZZZ ..."},"656":{y:0,u:"../Content/Lua/_LUA_HTTP_Client_Config.htm",l:-1,t:"HTTP Client Parameters",i:0.00309094532997115,a:"This page describes the HTTP Client options that you can use with the Lua function  send_http_request . When configuring authentication, do not set more than one of the following combinations. BasicUsername and BasicPassword DigestUsername and DigestPassword NTLMUsername and NTLMPassword You can ..."},"657":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_StartedAfter.htm",l:-1,t:"Started-After",i:0.00218463555933889,a:"Use this parameter when QueueAction=GetStatus, to filter the actions that are returned. When this parameter is set, the server only returns actions that started processing after the specified date and time. Specify the date and time in one of the following formats: YYYY-MM-DD HH:NN:SS ZZZ YYYY/MM/DD ..."},"658":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_QueuedAfter.htm",l:-1,t:"Queued-After",i:0.00218463555933889,a:"Use this parameter when QueueAction=GetStatus, to filter the actions that are returned. When this parameter is set, the server only returns actions that were added to the queue after the specified date and time. Specify the date and time in one of the following formats: YYYY-MM-DD HH:NN:SS ZZZ ..."},"659":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_SortBy.htm",l:-1,t:"Sort-By",i:0.00218463555933889,a:"Sort-By The property to use to sort the actions that are returned: queue-time - The time the request was received. start-time - The time the server began processing the request. finish-time - The time the server finished processing the request."},"660":{y:0,u:"../Content/Actions/General/_ACI_Filename.htm",l:-1,t:"Filename",i:0.00126179055178763,a:"Filename The path of the backup file. "},"661":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_MaxDepth.htm",l:-1,t:"MaxDepth",i:0.00218463555933889,a:"The maximum number of levels to include in the output. For example, if you set  MaxDepth=0, the progress of an action is reported, but the progress of its stages is not. If you set  MaxDepth=2, the progress of an action and its stages is reported, and each stage can be divided into sub-stages."},"662":{y:0,u:"../Content/Actions/General/_ACI_Path.htm",l:-1,t:"Path",i:0.00078792211674809,a:"Path The folder in which to save the backup file. "},"663":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_SortOrder.htm",l:-1,t:"Sort-Order",i:0.00218463555933889,a:"Sort-Order The order to use to sort the actions that are returned: ascending  - The oldest action is listed first. descending - The most recent action is listed first."},"664":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_AllStages.htm",l:-1,t:"AllStages",i:0.00218463555933889,a:"AllStages A Boolean that specifies what information to show in the response. The default (False)   merges the finished stages of a task and does not expand pending stages into sub-stages. To show this information, set this parameter to  True."},"665":{y:0,u:"../Content/Actions/SharedParameters/_ACI_FileName.htm",l:-1,t:"FileName",i:0.0021552793609538,a:"The location of the file to write the action output to, if you have set  Output  to  File. Type the full path to the file. The path that you specify must be listed in the  AllowedOutputDirectoryCSVs  configuration parameter. Amazon S3 Connector cannot write the output file to directories that are ..."},"666":{y:0,u:"../Content/Actions/SharedParameters/_ACI_Output.htm",l:-1,t:"Output",i:0.00398726189246113,a:"Type  File to write action output to a file. If you set Output to  File, you must use the  FileName  parameter to specify the name and the location of the file that you want to write the output to. The path that you specify in  FileName  must be listed in the  AllowedOutputDirectoryCSVs  ..."},"667":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_MaxResults.htm",l:-1,t:"MaxResults",i:0.00218463555933889,a:"MaxResults The maximum number of results to return in the response when you run action=QueueInfo\u0026QueueAction=getStatus. The default value of this parameter does not limit the number of results. "},"668":{y:0,u:"../Content/Service/ServiceActions/_ACI_File.htm",l:-1,t:"File",i:0.00246852156260573,a:"File The path and file name of the diagnostics ZIP file to create. You can use an absolute or relative path. Relative paths are relative to the current component working directory."},"669":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_Start.htm",l:-1,t:"Start",i:0.00218463555933889,a:"Start The index of the first result to return in the response when you run action=QueueInfo\u0026QueueAction=getStatus. The index of the first result is  1. Use this parameter when you set the MaxResults action parameter, to page through the results."},"670":{y:0,u:"../Content/Actions/General/_ACI_Format.htm",l:-1,t:"Format",i:0.00203221133998382,a:"Format Type  XML to display the request log in XML format. "},"671":{y:0,u:"../Content/Service/ServiceActions/_ACI_Tail.htm",l:-1,t:"Tail",i:0.00104444784100699,a:"Tail Type the number of lines from the log stream to return. The lines are read from the top (that is, the most recent lines are returned). Type  -1 to return all entries."},"672":{y:0,u:"../Content/Service/ServiceActions/_ACI_FromDisk.htm",l:-1,t:"FromDisk",i:0.00104444784100699,a:"FromDisk Specifies whether the log stream is read from disk or memory. Type  True if you want the log stream to be read from disk rather than from memory. "},"673":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_QueueName.htm",l:-1,t:"QueueName",i:0.00161206042158185,a:"QueueName The name of the queue to query. There is one queue for each asynchronous action.  \n            Most of a connector\u0027s functionality is accessed through action=fetch, so usually you will specify fetch.\n        "},"674":{y:0,u:"../Content/Actions/SharedParameters/_ACI_Template.htm",l:-1,t:"Template",i:0.00448168627773659,a:"Template The name of the XSL template to apply to the action output. Exclude the file path and file extension."},"675":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_FinishedAfter.htm",l:-1,t:"Finished-After",i:0.00218463555933889,a:"Use this parameter when QueueAction=GetStatus, to filter the actions that are returned. When this parameter is set, the server only returns actions that finished processing after the specified date and time. Specify the date and time in one of the following formats: YYYY-MM-DD HH:NN:SS ZZZ ..."},"676":{y:0,u:"../Content/Actions/General/_ACI_Refresh.htm",l:-1,t:"Refresh",i:0.00203221133998382,a:"Refresh The number of seconds to elapse before the request log refreshes. "},"677":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_Priority.htm",l:-1,t:"Priority",i:0.00125614598818492,a:"Priority The new priority to assign to the queued action. Specify the new priority as an integer. The higher the value you assign, the higher the priority of the action. "},"678":{y:0,u:"../Content/Actions/General/_ACI_OpenLinks.htm",l:-1,t:"OpenLinks",i:0.00203221133998382,a:"OpenLinks Type  on to open logged requests in a new window when they are clicked. "},"679":{y:0,u:"../Content/Actions/SharedParameters/_ACI_ActionID.htm",l:-1,t:"ActionID",i:0.00238446250353313,a:"A string to use to identify an ACI action. You can use this parameter to track actions where the action is passed between multiple IDOL components. Each IDOL component passes the ActionID string along with the action, so that you can easily find related actions in logs for each component. If you do ..."},"680":{y:0,u:"../Content/Actions/SharedParameters/_ACI_ForceTemplateRefresh.htm",l:-1,t:"ForceTemplateRefresh",i:0.00427142752579206,a:"ForceTemplateRefresh If you specify a Template to use for your action results, you can set ForceTemplateRefresh to  True to force the ACI server  to reload this template from disk rather than from the cache."},"681":{y:0,u:"../Content/Actions/General/_ACI_MemoryReport_MaxDepth.htm",l:-1,t:"MaxDepth",i:0.00314628043290026,a:"MaxDepth The maximum depth to return memory information for. The  MemoryReport  response XML displays a tree structure, with information for components and their sub-components on multiple levels. You can set MaxDepth to restrict the report to this number of levels. "},"682":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_StartedBefore.htm",l:-1,t:"Started-Before",i:0.00218463555933889,a:"Use this parameter when QueueAction=GetStatus, to filter the actions that are returned. When this parameter is set, the server only returns actions that started processing before the specified date and time. Specify the date and time in one of the following formats: YYYY-MM-DD HH:NN:SS ZZZ ..."},"683":{y:0,u:"../Content/Actions/General/_ACI_Tail.htm",l:-1,t:"Tail",i:0.00203221133998382,a:"Tail The number of most recent requests that the log must display. "},"684":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo_QueueAction.htm",l:-1,t:"QueueAction",i:0.00125614598818492,a:"The action to perform on the queue. Specify one of the following actions:  cancel - cancel the queued action specified by the Token parameter. Use this option to cancel an action that has not started processing. changePriority - change the priority of the queued action specified by the Token ..."},"685":{y:0,u:"../Content/Actions/General/_ACI_DiskReport_MaxDepth.htm",l:-1,t:"MaxDepth",i:0.00314628043290026,a:"The maximum number of levels to print in the output for a disk report. Amazon S3 Connector always counts all objects, but for this number of levels, Amazon S3 Connector also prints details of the components, items, directories, and files.  To print the whole directory tree, set this parameter to  ..."},"686":{y:0,u:"../Content/Configuration/Server/_ACI_AllowedOutputDirectoryCSVs.htm",l:-1,t:"AllowedOutputDirectoryCSVs",i:0.00307127062670747,a:"A comma-separated list of the directories that the server  can write output files to. Output files are created when an action is sent with the  Output  parameter set to  file. The path must be absolute (for example, C:\\IDOLServer\\outputs or /store/idol/results). The service cannot write to ..."},});