define({"535":{y:0,u:"../Content/Lua/General/_LUA_parse_xml.htm",l:-1,t:"parse_xml",i:0.000422518044911535,a:"Parses an XML string to a LuaXmlDocument. The following character encodings are supported. If the XML uses a different character encoding, you can use the function  convert_encoding  to convert the encoding before parsing the XML. UTF-8 UTF-16 ISO-Latin-1 (ISO-8859-1) ASCII Syntax parse_xml( xml ) ..."},"536":{y:0,u:"../Content/Lua/General/_LUA_password_strength.htm",l:-1,t:"password_strength",i:0.000422518044911535,a:"password_strength Evaluates the strength of a password. Syntax password_strength( password ) Arguments Returns (Integer). A number (1-10) that represents the strength of the password (less than 2 is weak, 2-4 is acceptable, 5 or more is strong)."},"537":{y:0,u:"../Content/Lua/General/_LUA_regex_match.htm",l:-1,t:"regex_match",i:0.000422518044911535,a:"Tests whether an input string matches a regular expression. The full string must match the regular expression, otherwise the function returns nil. To find matches within a string, OpenText recommends using the function  regex_search . Syntax regex_match( input, regex [, case] ) Arguments Returns One ..."},"538":{y:0,u:"../Content/Lua/General/_LUA_regex_replace_all.htm",l:-1,t:"regex_replace_all",i:0.000422518044911535,a:"Searches a string for matches to a regular expression, and replaces the matches according to the value specified by the replacement argument. Syntax regex_replace_all( input, regex, replacement ) Arguments Returns (String). The modified string. Examples regex_replace_all(\"ABC ABC ABC\", \"AB\", \"A\")\n-- ..."},"539":{y:0,u:"../Content/Lua/General/_LUA_regex_search.htm",l:-1,t:"regex_search",i:0.000781658621026016,a:"regex_search Performs a regular expression search on a string. This function returns a  LuaRegexMatch  object, rather than strings. Syntax regex_search ( input, regex [, case]) Arguments Returns (LuaRegexMatch)."},"540":{y:0,u:"../Content/Lua/General/_LUA_script_path.htm",l:-1,t:"script_path",i:0.000422518044911535,a:"The script_path function returns the path and file name of the script that is running. Syntax script_path() Returns (String, String) Returns the path of the folder that contains the script and the file name of the script, as separate strings. Example local script_directory, script_filename = ..."},"541":{y:0,u:"../Content/Lua/General/_LUA_send_aci_action.htm",l:-1,t:"send_aci_action",i:0.0041102864773928,a:"Sends a query to an ACI server. This method takes the action parameters as a table instead of the full action as a string, as with send_aci_command. This avoids issues with parameter values containing an ampersand (\u0026). Syntax send_aci_action( host, port, action [, parameters] [, timeout] [, retries] ..."},"542":{y:0,u:"../Content/Lua/General/_LUA_send_aci_command.htm",l:-1,t:"send_aci_command",i:0.00391741976370794,a:"Sends a query to an ACI server. Syntax send_aci_command( host, port, query [, timeout] [, retries] [, sslParameters] ) Arguments Returns (String). Returns the XML response as a string. If required, you can call parse_xml on the string to return a LuaXmlDocument. If the request fails, it returns nil. ..."},"543":{y:0,u:"../Content/Lua/General/_LUA_send_and_wait_for_async_aci_action.htm",l:-1,t:"send_and_wait_for_async_aci_action",i:0.000422518044911535,a:"Sends a query to an ACI server and does not return until the action has completed. You might use this method when you want to use an asynchronous action. The send_aci_action method returns as soon as it receives a response, which for an asynchronous action means that it returns a token. The method ..."},"544":{y:0,u:"../Content/Lua/General/_LUA_send_http_request.htm",l:-1,t:"send_http_request",i:0.00279976846123506,a:"The send_http_request function sends an HTTP request. Syntax send_http_request( params ) Arguments Named Parameters Returns String. The HTTP response. The send_http_request function can throw an exception if the request fails. You can catch an exception by calling send_http_request using the Lua ..."},"545":{y:0,u:"../Content/Lua/General/_LUA_sleep.htm",l:-1,t:"sleep",i:0.000422518044911535,a:"sleep The sleep function pauses the thread. Syntax sleep( milliseconds ) Arguments"},"546":{y:0,u:"../Content/Lua/General/_LUA_unzip_file.htm",l:-1,t:"unzip_file",i:0.000422518044911535,a:"unzip_file Extracts the contents of a zip file. Syntax unzip_file( path, dest ) Arguments Returns (Boolean). Returns a Boolean indicating success or failure."},"547":{y:0,u:"../Content/Lua/General/_LUA_upper_case_utf8.htm",l:-1,t:"upper_case_utf8",i:0.000422518044911535,a:"upper_case_utf8 Converts a UTF-8 string to upper case. Syntax upper_case_utf8( input ) Arguments Returns (String). The original string in upper case."},"548":{y:0,u:"../Content/Lua/General/_LUA_url_escape.htm",l:-1,t:"url_escape",i:0.000422518044911535,a:"url_escape Percent-encodes a string. Syntax url_escape( input ) Arguments Returns (String). The percent-encoded string."},"549":{y:0,u:"../Content/Lua/General/_LUA_url_unescape.htm",l:-1,t:"url_unescape",i:0.000422518044911535,a:"url_unescape The url_unescape function replaces URL escaped characters and returns a standard string. Syntax url_unescape( input ) Arguments Returns (String). The modified string."},"550":{y:0,u:"../Content/Lua/General/_LUA_xml_encode.htm",l:-1,t:"xml_encode",i:0.000422518044911535,a:"xml_encode Takes a string and encodes it using XML escaping. Syntax xml_encode ( content ) Arguments Returns (String)."},"551":{y:0,u:"../Content/Lua/General/_LUA_zip_file.htm",l:-1,t:"zip_file",i:0.000422518044911535,a:"The zip_file function zips the supplied path (file or directory). It overwrites the output file only if you set the optional overwrite argument to true. Syntax zip_file( path [, overwrite] ) Arguments Returns (Boolean). Returns a Boolean indicating success or failure. On success writes a file called ..."},"552":{y:0,u:"../Content/Lua/LuaConfig/_LUA_LuaConfig_Methods.htm",l:-1,t:"LuaConfig Methods",i:0.000776120601408289,a:"A LuaConfig object provides access to configuration information. You can retrieve a LuaConfig for a given configuration file using the get_config function. If you have a LuaConfig object called config you can call its methods using the \u0027:\u0027 operator. For example: config:getValue(sectionName, ..."},"553":{y:0,u:"../Content/Lua/LuaConfig/_LUA_getEncryptedValue.htm",l:-1,t:"getEncryptedValue",i:0.000581905775132017,a:"getEncryptedValue The getEncryptedValue method returns the unencrypted value from the configuration file of an encrypted value. Syntax getEncryptedValue( section, parameter ) Arguments Returns (String). The unencrypted value."},"554":{y:0,u:"../Content/Lua/LuaConfig/_LUA_getValue.htm",l:-1,t:"getValue",i:0.000581905775132017,a:"The getValue method returns the value of the configuration parameter key in a given section. If the key does not exist in the section, then it returns the default value. Syntax getValue( section, key [, default] ) Arguments Returns A string, boolean, or integer containing the value read from the ..."},"555":{y:0,u:"../Content/Lua/LuaConfig/_LUA_getValues.htm",l:-1,t:"getValues",i:0.000581905775132017,a:"The getValues method returns multiple values for a parameter (for example, a comma-separated list or numbered list like keyN). Syntax getValues( section, parameter ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call ..."},"556":{y:0,u:"../Content/Lua/LuaConfig/_LUA_LuaConfig_new.htm",l:-1,t:"LuaConfig:new",i:0.000985939971527063,a:"LuaConfig:new The constructor for a LuaConfig object (creates a new LuaConfig object). Syntax LuaConfig:new( config_buffer ) Arguments Returns (LuaConfig). The new LuaConfig object. Example local config_buffer = \"[default]\\nparameter=value\"\nlocal config = LuaConfig:new(config_buffer)"},"557":{y:0,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_Methods.htm",l:-1,t:"LuaDocument Methods",i:0.000656407076036795,a:"This section describes the methods provided by the LuaDocument object. A LuaDocument allows you to access and modify the reference, metadata and content of a document. If you have a LuaDocument object called document you can call its methods using the \u0027:\u0027 operator. For example: ..."},"558":{y:0,u:"../Content/Lua/LuaDocument/_LUA_addField.htm",l:-1,t:"addField",i:0.000432478536907143,a:"addField The addField method adds a new field to the document. Syntax addField ( fieldname, fieldvalue ) Arguments Returns (LuaField) A LuaField object representing the new field."},"559":{y:0,u:"../Content/Lua/LuaDocument/_LUA_addSection.htm",l:-1,t:"addSection",i:0.000432478536907143,a:"The addSection method adds an empty section to the end of the document. Syntax addSection() Returns (LuaDocument). Returns a LuaDocument object representing the document, with the new section as the active section. Example local newSection = document:addSection()   -- Add a new section to the ..."},"560":{y:0,u:"../Content/Lua/LuaDocument/_LUA_appendContent.htm",l:-1,t:"appendContent",i:0.000432478536907143,a:"The appendContent method appends content to the existing content (the DRECONTENT field) of a document  or document section. Syntax appendContent ( content [, number]) Arguments Examples \n-- Append content to the last section\ndocument:appendContent(\"content\")\n\n-- Append content to section 7, empty ..."},"561":{y:0,u:"../Content/Lua/LuaDocument/_LUA_copyField.htm",l:-1,t:"copyField",i:0.000432478536907143,a:"copyField The copyField method copies a field value to a new field. If the target field already exists it is overwritten. Syntax copyField ( sourcename, targetname [, case] ) Arguments"},"562":{y:0,u:"../Content/Lua/LuaDocument/_LUA_copyFieldNoOverwrite.htm",l:-1,t:"copyFieldNoOverwrite",i:0.000432478536907143,a:"The copyFieldNoOverwrite method copies a field value to a new field but does not overwrite the existing value. After calling this function the target field will contain all values of the source field in addition to any values it already had. Syntax copyFieldNoOverwrite( sourcename, targetname [, ..."},"563":{y:0,u:"../Content/Lua/LuaDocument/_LUA_countField.htm",l:-1,t:"countField",i:0.000432478536907143,a:"countField The countField method returns the number of fields with the specified name. Syntax countField( fieldname [, case] ) Arguments Returns (Number) The number of fields with the specified name."},"564":{y:0,u:"../Content/Lua/LuaDocument/_LUA_deleteField.htm",l:-1,t:"deleteField",i:0.000432478536907143,a:"deleteField The deleteField method deletes a field from a document. If you specify the optional value argument, the field is deleted only if has the specified value. Syntax deleteField( fieldName [, case] ) deleteField( fieldName, value [, case] ) Arguments"},"565":{y:0,u:"../Content/Lua/LuaDocument/_LUA_deleteFieldByPath.htm",l:-1,t:"deleteFieldByPath",i:0.000432478536907143,a:"deleteFieldByPath The deleteFieldByPath method removes all document fields with the specified path. Syntax deleteFieldByPath( path ) Arguments Example document:deleteFieldByPath(\"my/metadata/subfield\")"},"566":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getContent.htm",l:-1,t:"getContent",i:0.000432478536907143,a:"The getContent method gets the content (the value of the DRECONTENT field) for a document or document section. Syntax getContent([number]) Arguments Returns (String). The document content as a string. Examples \nlocal content7 = document:getContent(7)     -- Get content for section 7\nlocal section = ..."},"567":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getField.htm",l:-1,t:"getField",i:0.000432478536907143,a:"getField The getField method returns a LuaField object representing the field with the specified name. Syntax getField( name [, case]) Arguments Returns (LuaField). A LuaField object."},"568":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldNames.htm",l:-1,t:"getFieldNames",i:0.000432478536907143,a:"getFieldNames The getFieldNames method returns all of the field names for the document. Syntax getFieldNames() Returns (Strings) The names of the fields. To map the return values to a table, surround the function call with braces. For example: names = { document:getFieldNames() }"},"569":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFields.htm",l:-1,t:"getFields",i:0.000432478536907143,a:"The getFields method returns LuaField objects where each object represents a field that matches the specified name. Syntax getFields( name [, case]) Arguments Returns (LuaFields) One LuaField for each matching field. To map the return values to a table, surround the function call with braces. For ..."},"570":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldsByRegex.htm",l:-1,t:"getFieldsByRegex",i:0.000432478536907143,a:"The getFieldsByRegex method returns all document fields where the field name or path matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField represents a matching ..."},"571":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldValue.htm",l:-1,t:"getFieldValue",i:0.000432478536907143,a:"getFieldValue The getFieldValue method gets the value of a field in a document. To return the values of a multi-value field, see  getFieldValues . Syntax getFieldValue( fieldname [, case]) Arguments Returns (String). A string containing the value."},"572":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldValues.htm",l:-1,t:"getFieldValues",i:0.000800085539328393,a:"The getFieldValues method gets all values from all fields that have the same name. Syntax getFieldValues( fieldname [, case]) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ..."},"573":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getNextSection.htm",l:-1,t:"getNextSection",i:0.000432478536907143,a:"The getNextSection method returns the next section of a document (if the document has been divided into sections). The document object passed to the script\u0027s handler function represents the first section of the document. This means that the methods described in this section read and modify only the ..."},"574":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getReference.htm",l:-1,t:"getReference",i:0.000432478536907143,a:"getReference The getReference method returns a string containing the reference (the value of the DREREFERENCE document field). Syntax getReference() Returns (String). A string containing the reference."},"575":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getSection.htm",l:-1,t:"getSection",i:0.000432478536907143,a:"The getSection method returns a LuaDocument object with the specified section as the active section. Syntax getSection(number) Arguments Returns (LuaDocument). A LuaDocument object with the specified section as the active section. Example -- Get object for section 7 of document\nlocal section = ..."},"576":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getSectionCount.htm",l:-1,t:"getSectionCount",i:0.000432478536907143,a:"getSectionCount The getSectionCount method returns the number of sections in a document. Syntax getSectionCount() Returns (Number). The number of sections. Example local sectionCount = document:getSectionCount()"},"577":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getValueByPath.htm",l:-1,t:"getValueByPath",i:0.000432478536907143,a:"The getValueByPath method gets the value of a document field.  The field is specified by its path, which means that you can get the value of a sub field. If you pass this method the path of a multi-value field, only the first value is returned. To return all of the values from a multi-value field, ..."},"578":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getValuesByPath.htm",l:-1,t:"getValuesByPath",i:0.000800085539328393,a:"The getValuesByPath method gets all values of a document field. The field is specified by its path, which means that you can get values from a sub field. Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the ..."},"579":{y:0,u:"../Content/Lua/LuaDocument/_LUA_hasField.htm",l:-1,t:"hasField",i:0.000432478536907143,a:"hasField The hasField method checks to see if a field exists in the current document. Syntax hasField ( fieldname [, case]) Arguments Returns (Boolean). True if the field exists, false otherwise."},"580":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertJson.htm",l:-1,t:"insertJson",i:0.000554639868980199,a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into a document. Syntax insertJson ( json [, fieldName] ) Arguments Example The following example Lua script uses the insertJson method to add metadata to a document: function handler(document)\n  local ..."},"581":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertXml.htm",l:-1,t:"insertXml",i:0.000432478536907143,a:"insertXml The insertXml method inserts XML metadata into the document. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data."},"582":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertXmlWithoutRoot.htm",l:-1,t:"insertXmlWithoutRoot",i:0.000432478536907143,a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ..."},"583":{y:0,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_new.htm",l:-1,t:"LuaDocument:new",i:0.000432478536907143,a:"The constructor for a LuaDocument object (creates a new LuaDocument object that only contains a reference). Syntax LuaDocument:new( reference ) Arguments Returns (LuaDocument). The new LuaDocument object. Example local reference = \"my_reference\"\nlocal document = LuaDocument:new(reference)"},"584":{y:0,u:"../Content/Lua/LuaDocument/_LUA_removeSection.htm",l:-1,t:"removeSection",i:0.000432478536907143,a:"The removeSection method removes a section from a document. Syntax removeSection( sectionNumber ) Arguments Returns Nothing. Example \n-- Example that removes the last section of a document\nif document:getSectionCount() \u003e 0 then\n   local lastSection = document:getSectionCount() - 1\n   ..."},"585":{y:0,u:"../Content/Lua/LuaDocument/_LUA_renameField.htm",l:-1,t:"renameField",i:0.000432478536907143,a:"renameField The renameField method changes the name of a field. Syntax renameField( currentname, newname [, case]) Arguments"},"586":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setContent.htm",l:-1,t:"setContent",i:0.000432478536907143,a:"The setContent method sets the content (the value of the DRECONTENT field) for a document or document section. Syntax setContent( content [, number] ) Arguments Examples \n-- Set content for section 0\ndocument:setContent(\"content0\")\n\n-- Get document for section 1\nlocal section = ..."},"587":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setFieldValue.htm",l:-1,t:"setFieldValue",i:0.000432478536907143,a:"setFieldValue The setFieldValue method sets the value of a field in a document. If the field does not exist, it is created. If the field already exists, the existing value is overwritten. Syntax setFieldValue( fieldname, newvalue ) Arguments"},"588":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setReference.htm",l:-1,t:"setReference",i:0.000432478536907143,a:"setReference The setReference method sets the reference (the value of the DREREFERENCE document field) to the string passed in. Syntax setReference( reference ) Arguments"},"589":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_IDX.htm",l:-1,t:"to_idx",i:0.000432478536907143,a:"to_idx The to_idx method returns a string containing the document in IDX format. Syntax to_idx() Returns (String). Returns the document as a string."},"590":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_JSON.htm",l:-1,t:"to_json",i:0.000432478536907143,a:"to_json The to_json method returns a string containing the document in JSON format. Syntax to_json() Returns (String). Returns the document as a string."},"591":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_XML.htm",l:-1,t:"to_xml",i:0.000432478536907143,a:"to_xml The to_xml method returns a string containing the document in XML format. Syntax to_xml() Returns (String). Returns the document as a string."},"592":{y:0,u:"../Content/Lua/LuaDocument/_LUA_writeStubIdx.htm",l:-1,t:"writeStubIdx",i:0.000432478536907143,a:"The writeStubIdx method writes out a stub IDX document (a metadata file used by IDOL applications). The file is created in the current folder, but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubIdx( filename ) Arguments Returns (Boolean). ..."},"593":{y:0,u:"../Content/Lua/LuaDocument/_LUA_writeStubXml.htm",l:-1,t:"writeStubXml",i:0.000432478536907143,a:"The writeStubXml method writes out an XML file containing the metadata for the document. The file is created in the current folder but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubXml( filename ) Arguments Returns (Boolean) True if ..."},"594":{y:0,u:"../Content/Lua/LuaField/_LUA_LuaField_Methods.htm",l:-1,t:"LuaField Methods",i:0.000416980025293807,a:"This section describes the methods provided by LuaField objects. A LuaField represents a single field in a document. You can retrieve LuaField objects for a document using the LuaDocument getField and getFields methods. In its simplest form a field has just a name and a value, but it can also ..."},"595":{y:0,u:"../Content/Lua/LuaField/_LUA_addField.htm",l:-1,t:"addField",i:0.00043115735551519,a:"addField The addField method adds a sub field with the specified name and value. Syntax addField( fieldname, fieldvalue ) Arguments Returns (LuaField) A LuaField object representing the new field."},"596":{y:0,u:"../Content/Lua/LuaField/_LUA_copyField.htm",l:-1,t:"copyField",i:0.00043115735551519,a:"copyField The copyField method copies a sub field to another sub field. If the target sub field exists it is overwritten. Syntax copyField ( from, to [, case]) Arguments"},"597":{y:0,u:"../Content/Lua/LuaField/_LUA_copyFieldNoOverwrite.htm",l:-1,t:"copyFieldNoOverwrite",i:0.00043115735551519,a:"The copyFieldNoOverwrite method copies the sub field to another sub field but does not overwrite the destination. After this operation the destination field contains all the values of the source field as well as any values it already had. Syntax copyFieldNoOverwrite( from, to [, case]) Arguments"},"598":{y:0,u:"../Content/Lua/LuaField/_LUA_countField.htm",l:-1,t:"countField",i:0.00043115735551519,a:"countField The countField method returns the number of sub fields that exist with the specified name. Syntax countField ( fieldname [, case]) Arguments Returns (Number). The number of sub fields that exist with the specified name."},"599":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteAttribute.htm",l:-1,t:"deleteAttribute",i:0.00043115735551519,a:"deleteAttribute The deleteAttribute method deletes the specified field attribute. Syntax deleteAttribute( name ) Arguments"},"600":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteField.htm",l:-1,t:"deleteField",i:0.00043115735551519,a:"deleteField The deleteField method deletes the sub field with the specified name. Syntax deleteField( name [, case] )  deleteField( name , value [, case] )  Arguments"},"601":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteFieldByPath.htm",l:-1,t:"deleteFieldByPath",i:0.00043115735551519,a:"deleteFieldByPath The deleteFieldByPath method removes the sub field(s) with the specified path. Syntax deleteFieldByPath( path ) Arguments Example myField:deleteFieldByPath(\"path/to/subfield\")"},"602":{y:0,u:"../Content/Lua/LuaField/_LUA_getAttributeValue.htm",l:-1,t:"getAttributeValue",i:0.00043115735551519,a:"getAttributeValue The getAttributeValue method gets the value of the specified attribute. Syntax getAttributeValue( name ) Arguments Returns (String). The attribute value."},"603":{y:0,u:"../Content/Lua/LuaField/_LUA_getField.htm",l:-1,t:"getField",i:0.00043115735551519,a:"getField The getField method returns the specified sub field. Syntax getField ( name [, case]) Arguments Returns (LuaField) A LuaField object."},"604":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldNames.htm",l:-1,t:"getFieldNames",i:0.00043115735551519,a:"The getFieldNames method returns the names of the sub fields in the LuaField object. Syntax getFieldNames() Returns (Strings). The names of the sub fields. The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: fieldnames = { ..."},"605":{y:0,u:"../Content/Lua/LuaField/_LUA_getFields.htm",l:-1,t:"getFields",i:0.00043115735551519,a:"The getFields method returns all of the sub fields specified by the name argument. Syntax getFields( name [, case] ) Arguments Returns (LuaFields) One LuaField per matching field. The objects can be assigned to a table. To map the return values to a table, surround the function call with braces. For ..."},"606":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldsByRegex.htm",l:-1,t:"getFieldsByRegex",i:0.00043115735551519,a:"The getFieldsByRegex method returns all sub fields where the sub field name or path (relative to this field) matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField ..."},"607":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldValues.htm",l:-1,t:"getFieldValues",i:0.00043115735551519,a:"The getFieldValues method returns the values of all of the sub fields with the specified name. Syntax getFieldValues( fieldname [, case] ) Arguments Returns (Strings) One string for each value. The strings can be assigned to a table. To map the return values to a table, surround the function call ..."},"608":{y:0,u:"../Content/Lua/LuaField/_LUA_getValueByPath.htm",l:-1,t:"getValueByPath",i:0.00043115735551519,a:"The getValueByPath method gets the value of a sub-field, specified by path.   If you pass this method the path of a sub-field that has multiple values, only the first value is returned. To return all of the values from a multi-value sub-field, see  getValuesByPath . Syntax getValueByPath( path ) ..."},"609":{y:0,u:"../Content/Lua/LuaField/_LUA_getValuesByPath.htm",l:-1,t:"getValuesByPath",i:0.000797641351734358,a:"The getValuesByPath method gets the values of a sub-field, specified by path.   Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ..."},"610":{y:0,u:"../Content/Lua/LuaField/_LUA_hasAttribute.htm",l:-1,t:"hasAttribute",i:0.00043115735551519,a:"hasAttribute The hasAttribute method returns a Boolean indicating whether the field has the specified attribute. Syntax hasAttribute( name ) Arguments Returns (Boolean). A Boolean specifying if the field has the specified attribute."},"611":{y:0,u:"../Content/Lua/LuaField/_LUA_hasField.htm",l:-1,t:"hasField",i:0.00043115735551519,a:"hasField The hasField method returns a Boolean specifying if the sub field exists. Syntax hasField( fieldname [, case]) Arguments Returns (Boolean). A Boolean specifying if the sub field exists or not."},"612":{y:0,u:"../Content/Lua/LuaField/_LUA_insertJson.htm",l:-1,t:"insertJson",i:0.00043115735551519,a:"insertJson The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into the field. Syntax insertJson ( json [, fieldName] ) Arguments See Also LuaDocument:insertJson"},"613":{y:0,u:"../Content/Lua/LuaField/_LUA_insertXml.htm",l:-1,t:"insertXml",i:0.00043115735551519,a:"insertXml The insertXml method inserts XML metadata into the document. When called on a LuaField, the insertXml method inserts the fields as children of the LuaField. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data."},"614":{y:0,u:"../Content/Lua/LuaField/_LUA_insertXmlWithoutRoot.htm",l:-1,t:"insertXmlWithoutRoot",i:0.00043115735551519,a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ..."},"615":{y:0,u:"../Content/Lua/LuaField/_LUA_name.htm",l:-1,t:"name",i:0.00043115735551519,a:"name The name method returns the name of the field object. Syntax name() Returns (String). The name of the field object."},"616":{y:0,u:"../Content/Lua/LuaField/_LUA_renameField.htm",l:-1,t:"renameField",i:0.00043115735551519,a:"renameField The renameField method renames a sub field. Syntax renameField( oldname, newname [, case] ) Arguments"},"617":{y:0,u:"../Content/Lua/LuaField/_LUA_setAttributeValue.htm",l:-1,t:"setAttributeValue",i:0.00043115735551519,a:"setAttributeValue The setAttributeValue method sets the value for the specified attribute of the field. Syntax setAttributeValue( attribute, value ) Arguments"},"618":{y:0,u:"../Content/Lua/LuaField/_LUA_setValue.htm",l:-1,t:"setValue",i:0.00043115735551519,a:"setValue The setValue method sets the value of the field. Syntax setValue( value ) Arguments"},"619":{y:0,u:"../Content/Lua/LuaField/_LUA_value.htm",l:-1,t:"value",i:0.00043115735551519,a:"value The value method returns the value of the field object. Syntax value() Returns (String). The value of the field object."},"620":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA__LuaHttpRequest.htm",l:-1,t:"LuaHttpRequest Methods",i:0.00054921363083964,a:"This section describes the methods provided by LuaHttpRequest objects. If you have a LuaHttpRequest object called request you can call its methods using the \u0027:\u0027 operator. For example: request:send() Method Description send Sends the HTTP request. set_body Sets the body of the HTTP request. ..."},"621":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_LuaHttpRequest_new.htm",l:-1,t:"LuaHttpRequest:new",i:0.000475334017702869,a:"The constructor for a LuaHttpRequest object (creates a new LuaHttpRequest). Syntax LuaHttpRequest:new( config, section ) Arguments Returns (LuaHttpRequest). The new LuaHttpRequest object. Example The following example creates a new LuaHttpRequest object by reading configuration settings from a ..."},"622":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_send.htm",l:-1,t:"send",i:0.000607567623248701,a:"The send method sends the HTTP request. Syntax send() Returns (LuaHttpResponse). A  LuaHttpResponse  object. The send method can throw an exception if the request fails. You can catch an exception by calling the method  using the Lua function pcall. Example The following example shows how to send a ..."},"623":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_body.htm",l:-1,t:"set_body",i:0.000475334017702869,a:"set_body The set_body method sets the body of the HTTP request. Syntax set_body( body ) Arguments"},"624":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_config.htm",l:-1,t:"set_config",i:0.000475334017702869,a:"The set_config method specifies settings to use for sending the HTTP request (in the form of a section from a configuration file). For example, you can specify the proxy server to use by setting the parameters ProxyHost and ProxyPort, or specify the SSL version to use by setting SSLMethod. Syntax ..."},"625":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_header.htm",l:-1,t:"set_header",i:0.000879368214097915,a:"set_header The set_header method adds a header to the HTTP request. Syntax set_header( name, value ) Arguments Example request:set_header(\"X-EXAMPLE\", \"Example\")"},"626":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_headers.htm",l:-1,t:"set_headers",i:0.000475334017702869,a:"set_headers The set_headers method replaces all headers in the HTTP request with new headers. To add a header without changing existing headers, use the method  set_header . Syntax set_headers( headers ) Arguments Example request:set_headers( {X-EXAMPLE=\"Example\", X-ANOTHER=\"ANOTHER\"} )"},"627":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_method.htm",l:-1,t:"set_method",i:0.000475334017702869,a:"set_method Specifies the HTTP request method to use when sending the request, for example GET or POST.  Syntax set_method( method ) Arguments Example request:set_method(\"POST\")"},"628":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_url.htm",l:-1,t:"set_url",i:0.000475334017702869,a:"set_url The set_url method sets the URL that you want to send the HTTP request to. Syntax set_url( url ) Arguments Example request:set_url(\"https://www.example.com/\")"},"629":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA__LuaHttpResponse.htm",l:-1,t:"LuaHttpResponse Methods",i:0.00093341290542679,a:"This section describes the methods provided by LuaHttpResponse objects. A LuaHttpResponse object is provided when you send an HTTP request using the  send  method on a  LuaHttpRequest  object. If you have a LuaHttpResponse object called response you can call its methods using the \u0027:\u0027 operator. For ..."},"630":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_body.htm",l:-1,t:"get_body",i:0.00054921363083964,a:"get_body The get_body method returns the body of the HTTP response. Syntax get_body() Returns (String). The body of the HTTP response."},"631":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_header.htm",l:-1,t:"get_header",i:0.00054921363083964,a:"get_header The get_header method returns the value of a specified HTTP header. Syntax get_header( name ) Arguments Returns (String). The value of the header."},"632":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_headers.htm",l:-1,t:"get_headers",i:0.00054921363083964,a:"The get_headers method returns the names and values of all of the headers in the HTTP response. Syntax get_headers() Returns (table) A table that maps header names to values. Example The following example sends an HTTP request and then prints the headers that are returned to the console: local ..."},"633":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",l:-1,t:"get_http_code",i:0.00054921363083964,a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found."},"634":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",l:-1,t:"LuaJsonArray Methods",i:0.00233444025905079,a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Method Description append Appends a value to the array. clear Clears the array, so that it contains no values. copy ..."},"635":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",l:-1,t:"LuaJsonArray:new",i:0.000582336360020203,a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Returns (LuaJsonArray). The new LuaJsonArray object. Example The following is a simple JSON array: [4, \"a string\", true] To create a LuaJsonArray object to represent this array: local ..."},"636":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_append.htm",l:-1,t:"append",i:0.000582336360020203,a:"append The append method appends a value to the JSON array. Syntax append( value ) Arguments Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:append(6)\n-- the array is now [4, \"a string\", true, 6]"},"637":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_clear.htm",l:-1,t:"clear",i:0.000582336360020203,a:"clear The clear method clears the array, so that it contains no values. Syntax clear() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:clear()\nprint (myJsonArray:string())\n-- []"},"638":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_copy.htm",l:-1,t:"copy",i:0.000582336360020203,a:"The copy method returns a copy of the array. Modifying the copy does not modify the original array. Syntax copy() Returns (LuaJsonArray). A copy of the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nlocal anotherJsonArray = myJsonArray:copy()\nprint ..."},"639":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_empty.htm",l:-1,t:"empty",i:0.000582336360020203,a:"The empty method checks whether the JSON array is empty. Syntax empty() Returns (Boolean). Returns true if the array is empty. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nprint (\"Is the array empty?  \" , myJsonArray:empty() )\n-- Is the array empty?   ..."},"640":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_exists.htm",l:-1,t:"exists",i:0.00388216941922929,a:"The exists method checks whether a specified path exists in the JSON array. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ..."},"641":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00388216941922929,a:"The existsByPath method checks whether a specified path exists in the JSON array. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ..."},"642":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_ipairs.htm",l:-1,t:"ipairs",i:0.000582336360020203,a:"The ipairs method returns a function that you can use with a for loop to iterate over all of the values in the array. Syntax ipairs() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nfor i, v in myJsonArray:ipairs() do\n  print (v:string())\nend\n\n-- prints the following...\n-- 4\n-- a ..."},"643":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00388216941922929,a:"The lookup method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ..."},"644":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00388216941922929,a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"645":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_size.htm",l:-1,t:"size",i:0.000582336360020203,a:"size The size method returns the size of the JSON array. Syntax size() Returns (integer). The number of values in the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nprint (\"Array size is \" , myJsonArray:size() )\n-- Array size is 3"},"646":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_string.htm",l:-1,t:"string",i:0.000582336360020203,a:"The string method returns the JSON array as a string. Syntax string() Returns (String). The array as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = LuaJsonArray:new(\"zero\",1,2,myJsonObject)\n\nprint (myJsonArray:string())\n-- ..."},"647":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA__LuaJsonObject.htm",l:-1,t:"LuaJsonObject Methods",i:0.00233444025905079,a:"A LuaJsonObject object represents a JSON object. If you have a LuaJsonObject object called object you can call its methods using the \u0027:\u0027 operator. For example: object:size() Method Description assign Adds an attribute (a name/value pair) to the object. assign Adds a table of attributes (name/value ..."},"648":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_LuaJsonObject_new.htm",l:-1,t:"LuaJsonObject:new",i:0.00055871402648786,a:"The constructor for a LuaJsonObject object (creates a new LuaJsonObject). If you do not specify any attributes to assign to the object (by omitting the attributes argument), an empty object is created. Syntax LuaJsonObject:new( [attributes] ) Arguments Returns (LuaJsonObject). The new LuaJsonObject ..."},"649":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_assign.htm",l:-1,t:"assign",i:0.00055871402648786,a:"The assign method adds an attribute (a name/value pair) to the object. Syntax assign (name, value) Arguments Example local myJsonObject = LuaJsonObject:new( { name1=\"value1\" , name2=\"value2\" } )\nmyJsonObject:assign(\"name3\", \"value3\")\nmyJsonObject:assign(\"name4\", LuaJsonArray:new(\"value4a\",\"value4b\") ..."},"650":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_assign2.htm",l:-1,t:"assign",i:0.00055871402648786,a:"The assign method adds a table of attributes (name/value pairs) to the object. Syntax assign (attributes) Arguments Example local myJsonObject = LuaJsonObject:new()\nmyJsonObject:assign( {\n        attr1=LuaJsonObject:new( { n=42 } ),\n        attr2=LuaJsonArray:new( 1, 2, \"three\" ),\n        ..."},"651":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_clear.htm",l:-1,t:"clear",i:0.00055871402648786,a:"clear The clear method clears the object, so that it contains no attributes (name/value pairs). Syntax clear() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:clear()\nprint (myJsonObject:string())\n-- {}"},"652":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_copy.htm",l:-1,t:"copy",i:0.00055871402648786,a:"The copy method returns a copy of the JSON object. Modifying the copy does not modify the original object. Syntax copy() Returns (LuaJsonObject). A copy of the object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal anotherJsonObject = ..."},"653":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_empty.htm",l:-1,t:"empty",i:0.00055871402648786,a:"empty The empty method determines whether the JSON object is empty. Syntax empty() Returns (Boolean). Returns true if the object has no attributes (name/value pairs). Example local myJsonObject = LuaJsonObject:new()\nprint(myJsonObject:empty())\n-- true\n"},"654":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_erase.htm",l:-1,t:"erase",i:0.00055871402648786,a:"erase The erase method removes a specified attribute (name/value pair) from the JSON object. Syntax erase( name ) Arguments Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:erase(\"version\")\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\"}"},"655":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_exists.htm",l:-1,t:"exists",i:0.00372469121969153,a:"The exists method checks whether a specified path exists in the JSON object. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"656":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00372469121969153,a:"The existsByPath method checks whether a specified path exists in the JSON object. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"657":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00372469121969153,a:"The lookup method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"658":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00372469121969153,a:"The lookupByPath method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"659":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_pairs.htm",l:-1,t:"pairs",i:0.00055871402648786,a:"The pairs method returns an iterator function that you can use with a for loop to iterate over all of the attributes contained in the JSON object. Syntax pairs() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\n\nfor i, v in myJsonObject:pairs() do\n  print (i .. \u0027=\u0027 ..."},"660":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_size.htm",l:-1,t:"size",i:0.00055871402648786,a:"size The size method returns the number of attributes (name/value pairs) in the JSON object. Syntax size() Returns (Number). The number of attributes in the JSON object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:size())\n-- 2"},"661":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_string.htm",l:-1,t:"string",i:0.00055871402648786,a:"string The string method returns the JSON object as a string. Syntax string() Returns (String). The JSON object as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\",\"version\":11}"},"662":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA__LuaJsonValue.htm",l:-1,t:"LuaJsonValue Methods",i:0.001954250439977,a:"A LuaJsonValue object represents a JSON value.  If you have a LuaJsonValue object called myJsonValue you can call its methods using the \u0027:\u0027 operator. For example: myJsonValue:is_object() Method Description array Gets a LuaJsonArray that represents the JSON array, if the value is an array. copy ..."},"663":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_LuaJsonValue_new.htm",l:-1,t:"LuaJsonValue:new",i:0.00050440709967895,a:"LuaJsonValue:new The constructor for a LuaJsonValue object (creates a new LuaJsonValue). Syntax LuaJsonValue:new( value ) Arguments Returns (LuaJsonValue). The new LuaJsonValue object."},"664":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_array.htm",l:-1,t:"array",i:0.00050440709967895,a:"The array method gets the array, if the value is a JSON array. Syntax array() Returns (LuaJsonArray). A  LuaJsonArray  object that represents the array. Example local fh = io.open(\"example_array.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = ..."},"665":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_copy.htm",l:-1,t:"copy",i:0.00050440709967895,a:"copy The copy method returns a copy of the value. Modifying the copy does not affect the original value. Syntax copy() Returns (LuaJsonValue). A copy of the value."},"666":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_exists.htm",l:-1,t:"exists",i:0.00336265402018335,a:"The exists method checks whether a specified path exists in the JSON value. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"667":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00336265402018335,a:"The existsByPath method checks whether a specified path exists in the JSON value.  Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"668":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_array.htm",l:-1,t:"is_array",i:0.00050440709967895,a:"is_array The is_array method whether the value is a JSON array. Syntax is_array() Returns (Boolean). Returns true if the value is an array value, false otherwise."},"669":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_boolean.htm",l:-1,t:"is_boolean",i:0.00050440709967895,a:"is_boolean The is_boolean method returns whether the value is a Boolean value. Syntax is_boolean() Returns (Boolean). Returns true if the value is a Boolean value, false otherwise."},"670":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_float.htm",l:-1,t:"is_float",i:0.00050440709967895,a:"is_float The is_float method returns whether the value is a floating point value. Syntax is_float() Returns (Boolean). Returns true if the value is a floating point value, false otherwise."},"671":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_integer.htm",l:-1,t:"is_integer",i:0.00050440709967895,a:"is_integer The is_integer method returns whether the value is an integral value. Syntax is_integer() Returns (Boolean). Returns true if the value is an integer value, false otherwise."},"672":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_null.htm",l:-1,t:"is_null",i:0.00050440709967895,a:"is_null The is_null method returns whether the value is a null value. Syntax is_null() Returns (Boolean). Returns true if the value is a null value, false otherwise."},"673":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_number.htm",l:-1,t:"is_number",i:0.00050440709967895,a:"is_number The is_number method returns whether the value is a number. Syntax is_number() Returns (Boolean). Returns true if the value is a number, false otherwise."},"674":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_object.htm",l:-1,t:"is_object",i:0.00050440709967895,a:"is_object The is_object method returns whether the value is a JSON object. Syntax is_object() Returns (Boolean). Returns true if the value is a JSON object, false otherwise."},"675":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_simple_value.htm",l:-1,t:"is_simple_value",i:0.00050440709967895,a:"is_simple_value The is_simple_value method returns whether the value is a simple value (Boolean, float, integer, or string). Syntax is_simple_value() Returns (Boolean). Returns true if the value is a simple value, false otherwise."},"676":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_string.htm",l:-1,t:"is_string",i:0.00050440709967895,a:"is_string The is_string method returns whether the value is a string value. Syntax is_string() Returns (Boolean). Returns true if the value is a string value, false otherwise."},"677":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00336265402018335,a:"The lookup method returns the value at the specified path in the JSON value. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ..."},});