define({"408":{y:0,u:"../Content/Lua/LuaDocument/_LUA_appendContent.htm",l:-1,t:"appendContent",i:0.000549575616268063,a:"The appendContent method appends content to the existing content (the DRECONTENT field) of a document  or document section. Syntax appendContent ( content [, number]) Arguments Examples \n-- Append content to the last section\ndocument:appendContent(\"content\")\n\n-- Append content to section 7, empty ..."},"409":{y:0,u:"../Content/Lua/LuaDocument/_LUA_copyField.htm",l:-1,t:"copyField",i:0.000549575616268063,a:"copyField The copyField method copies a field value to a new field. If the target field already exists it is overwritten. Syntax copyField ( sourcename, targetname [, case] ) Arguments"},"410":{y:0,u:"../Content/Lua/LuaDocument/_LUA_copyFieldNoOverwrite.htm",l:-1,t:"copyFieldNoOverwrite",i:0.000549575616268063,a:"The copyFieldNoOverwrite method copies a field value to a new field but does not overwrite the existing value. After calling this function the target field will contain all values of the source field in addition to any values it already had. Syntax copyFieldNoOverwrite( sourcename, targetname [, ..."},"411":{y:0,u:"../Content/Lua/LuaDocument/_LUA_countField.htm",l:-1,t:"countField",i:0.000549575616268063,a:"countField The countField method returns the number of fields with the specified name. Syntax countField( fieldname [, case] ) Arguments Returns (Number) The number of fields with the specified name."},"412":{y:0,u:"../Content/Lua/LuaDocument/_LUA_deleteField.htm",l:-1,t:"deleteField",i:0.000549575616268063,a:"deleteField The deleteField method deletes a field from a document. If you specify the optional value argument, the field is deleted only if has the specified value. Syntax deleteField( fieldName [, case] ) deleteField( fieldName, value [, case] ) Arguments"},"413":{y:0,u:"../Content/Lua/LuaDocument/_LUA_deleteFieldByPath.htm",l:-1,t:"deleteFieldByPath",i:0.000549575616268063,a:"deleteFieldByPath The deleteFieldByPath method removes all document fields with the specified path. Syntax deleteFieldByPath( path ) Arguments Example document:deleteFieldByPath(\"my/metadata/subfield\")"},"414":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getContent.htm",l:-1,t:"getContent",i:0.000549575616268063,a:"The getContent method gets the content (the value of the DRECONTENT field) for a document or document section. Syntax getContent([number]) Arguments Returns (String). The document content as a string. Examples \nlocal content7 = document:getContent(7)     -- Get content for section 7\nlocal section = ..."},"415":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getField.htm",l:-1,t:"getField",i:0.000549575616268063,a:"getField The getField method returns a LuaField object representing the field with the specified name. Syntax getField( name [, case]) Arguments Returns (LuaField). A LuaField object."},"416":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldNames.htm",l:-1,t:"getFieldNames",i:0.000549575616268063,a:"getFieldNames The getFieldNames method returns all of the field names for the document. Syntax getFieldNames() Returns (Strings) The names of the fields. To map the return values to a table, surround the function call with braces. For example: names = { document:getFieldNames() }"},"417":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFields.htm",l:-1,t:"getFields",i:0.000549575616268063,a:"The getFields method returns LuaField objects where each object represents a field that matches the specified name. Syntax getFields( name [, case]) Arguments Returns (LuaFields) One LuaField for each matching field. To map the return values to a table, surround the function call with braces. For ..."},"418":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldsByRegex.htm",l:-1,t:"getFieldsByRegex",i:0.000549575616268063,a:"The getFieldsByRegex method returns all document fields where the field name or path matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField represents a matching ..."},"419":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldValue.htm",l:-1,t:"getFieldValue",i:0.000549575616268063,a:"getFieldValue The getFieldValue method gets the value of a field in a document. To return the values of a multi-value field, see  getFieldValues . Syntax getFieldValue( fieldname [, case]) Arguments Returns (String). A string containing the value."},"420":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getFieldValues.htm",l:-1,t:"getFieldValues",i:0.00101671529736523,a:"The getFieldValues method gets all values from all fields that have the same name. Syntax getFieldValues( fieldname [, case]) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ..."},"421":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getNextSection.htm",l:-1,t:"getNextSection",i:0.000549575616268063,a:"The getNextSection method returns the next section of a document (if the document has been divided into sections). The document object passed to the script\u0027s handler function represents the first section of the document. This means that the methods described in this section read and modify only the ..."},"422":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getReference.htm",l:-1,t:"getReference",i:0.000549575616268063,a:"getReference The getReference method returns a string containing the reference (the value of the DREREFERENCE document field). Syntax getReference() Returns (String). A string containing the reference."},"423":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getSection.htm",l:-1,t:"getSection",i:0.000549575616268063,a:"The getSection method returns a LuaDocument object with the specified section as the active section. Syntax getSection(number) Arguments Returns (LuaDocument). A LuaDocument object with the specified section as the active section. Example -- Get object for section 7 of document\nlocal section = ..."},"424":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getSectionCount.htm",l:-1,t:"getSectionCount",i:0.000549575616268063,a:"getSectionCount The getSectionCount method returns the number of sections in a document. Syntax getSectionCount() Returns (Number). The number of sections. Example local sectionCount = document:getSectionCount()"},"425":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getValueByPath.htm",l:-1,t:"getValueByPath",i:0.000549575616268063,a:"The getValueByPath method gets the value of a document field.  The field is specified by its path, which means that you can get the value of a sub field. If you pass this method the path of a multi-value field, only the first value is returned. To return all of the values from a multi-value field, ..."},"426":{y:0,u:"../Content/Lua/LuaDocument/_LUA_getValuesByPath.htm",l:-1,t:"getValuesByPath",i:0.00101671529736523,a:"The getValuesByPath method gets all values of a document field. The field is specified by its path, which means that you can get values from a sub field. Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the ..."},"427":{y:0,u:"../Content/Lua/LuaDocument/_LUA_hasField.htm",l:-1,t:"hasField",i:0.000549575616268063,a:"hasField The hasField method checks to see if a field exists in the current document. Syntax hasField ( fieldname [, case]) Arguments Returns (Boolean). True if the field exists, false otherwise."},"428":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertJson.htm",l:-1,t:"insertJson",i:0.000704813152621827,a:"The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into a document. Syntax insertJson ( json [, fieldName] ) Arguments Example The following example Lua script uses the insertJson method to add metadata to a document: function handler(document)\n  local ..."},"429":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertXml.htm",l:-1,t:"insertXml",i:0.000549575616268063,a:"insertXml The insertXml method inserts XML metadata into the document. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data."},"430":{y:0,u:"../Content/Lua/LuaDocument/_LUA_insertXmlWithoutRoot.htm",l:-1,t:"insertXmlWithoutRoot",i:0.000549575616268063,a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ..."},"431":{y:0,u:"../Content/Lua/LuaDocument/_LUA_LuaDocument_new.htm",l:-1,t:"LuaDocument:new",i:0.000549575616268063,a:"The constructor for a LuaDocument object (creates a new LuaDocument object that only contains a reference). Syntax LuaDocument:new( reference ) Arguments Returns (LuaDocument). The new LuaDocument object. Example local reference = \"my_reference\"\nlocal document = LuaDocument:new(reference)"},"432":{y:0,u:"../Content/Lua/LuaDocument/_LUA_removeSection.htm",l:-1,t:"removeSection",i:0.000549575616268063,a:"The removeSection method removes a section from a document. Syntax removeSection( sectionNumber ) Arguments Returns Nothing. Example \n-- Example that removes the last section of a document\nif document:getSectionCount() \u003e 0 then\n   local lastSection = document:getSectionCount() - 1\n   ..."},"433":{y:0,u:"../Content/Lua/LuaDocument/_LUA_renameField.htm",l:-1,t:"renameField",i:0.000549575616268063,a:"renameField The renameField method changes the name of a field. Syntax renameField( currentname, newname [, case]) Arguments"},"434":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setContent.htm",l:-1,t:"setContent",i:0.000549575616268063,a:"The setContent method sets the content (the value of the DRECONTENT field) for a document or document section. Syntax setContent( content [, number] ) Arguments Examples \n-- Set content for section 0\ndocument:setContent(\"content0\")\n\n-- Get document for section 1\nlocal section = ..."},"435":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setFieldValue.htm",l:-1,t:"setFieldValue",i:0.000549575616268063,a:"setFieldValue The setFieldValue method sets the value of a field in a document. If the field does not exist, it is created. If the field already exists, the existing value is overwritten. Syntax setFieldValue( fieldname, newvalue ) Arguments"},"436":{y:0,u:"../Content/Lua/LuaDocument/_LUA_setReference.htm",l:-1,t:"setReference",i:0.000549575616268063,a:"setReference The setReference method sets the reference (the value of the DREREFERENCE document field) to the string passed in. Syntax setReference( reference ) Arguments"},"437":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_IDX.htm",l:-1,t:"to_idx",i:0.000549575616268063,a:"to_idx The to_idx method returns a string containing the document in IDX format. Syntax to_idx() Returns (String). Returns the document as a string."},"438":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_JSON.htm",l:-1,t:"to_json",i:0.000549575616268063,a:"to_json The to_json method returns a string containing the document in JSON format. Syntax to_json() Returns (String). Returns the document as a string."},"439":{y:0,u:"../Content/Lua/LuaDocument/_LUA_to_XML.htm",l:-1,t:"to_xml",i:0.000549575616268063,a:"to_xml The to_xml method returns a string containing the document in XML format. Syntax to_xml() Returns (String). Returns the document as a string."},"440":{y:0,u:"../Content/Lua/LuaDocument/_LUA_writeStubIdx.htm",l:-1,t:"writeStubIdx",i:0.000549575616268063,a:"The writeStubIdx method writes out a stub IDX document (a metadata file used by IDOL applications). The file is created in the current folder, but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubIdx( filename ) Arguments Returns (Boolean). ..."},"441":{y:0,u:"../Content/Lua/LuaDocument/_LUA_writeStubXml.htm",l:-1,t:"writeStubXml",i:0.000549575616268063,a:"The writeStubXml method writes out an XML file containing the metadata for the document. The file is created in the current folder but you can specify a full path and file name if you want to create the file in another folder. Syntax writeStubXml( filename ) Arguments Returns (Boolean) True if ..."},"442":{y:0,u:"../Content/Lua/LuaField/_LUA_LuaField_Methods.htm",l:-1,t:"LuaField Methods",i:0.000529880751029353,a:"This section describes the methods provided by LuaField objects. A LuaField represents a single field in a document. You can retrieve LuaField objects for a document using the LuaDocument getField and getFields methods. In its simplest form a field has just a name and a value, but it can also ..."},"443":{y:0,u:"../Content/Lua/LuaField/_LUA_addField.htm",l:-1,t:"addField",i:0.000547896712048985,a:"addField The addField method adds a sub field with the specified name and value. Syntax addField( fieldname, fieldvalue ) Arguments Returns (LuaField) A LuaField object representing the new field."},"444":{y:0,u:"../Content/Lua/LuaField/_LUA_copyField.htm",l:-1,t:"copyField",i:0.000547896712048985,a:"copyField The copyField method copies a sub field to another sub field. If the target sub field exists it is overwritten. Syntax copyField ( from, to [, case]) Arguments"},"445":{y:0,u:"../Content/Lua/LuaField/_LUA_copyFieldNoOverwrite.htm",l:-1,t:"copyFieldNoOverwrite",i:0.000547896712048985,a:"The copyFieldNoOverwrite method copies the sub field to another sub field but does not overwrite the destination. After this operation the destination field contains all the values of the source field as well as any values it already had. Syntax copyFieldNoOverwrite( from, to [, case]) Arguments"},"446":{y:0,u:"../Content/Lua/LuaField/_LUA_countField.htm",l:-1,t:"countField",i:0.000547896712048985,a:"countField The countField method returns the number of sub fields that exist with the specified name. Syntax countField ( fieldname [, case]) Arguments Returns (Number). The number of sub fields that exist with the specified name."},"447":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteAttribute.htm",l:-1,t:"deleteAttribute",i:0.000547896712048985,a:"deleteAttribute The deleteAttribute method deletes the specified field attribute. Syntax deleteAttribute( name ) Arguments"},"448":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteField.htm",l:-1,t:"deleteField",i:0.000547896712048985,a:"deleteField The deleteField method deletes the sub field with the specified name. Syntax deleteField( name [, case] )  deleteField( name , value [, case] )  Arguments"},"449":{y:0,u:"../Content/Lua/LuaField/_LUA_deleteFieldByPath.htm",l:-1,t:"deleteFieldByPath",i:0.000547896712048985,a:"deleteFieldByPath The deleteFieldByPath method removes the sub field(s) with the specified path. Syntax deleteFieldByPath( path ) Arguments Example myField:deleteFieldByPath(\"path/to/subfield\")"},"450":{y:0,u:"../Content/Lua/LuaField/_LUA_getAttributeValue.htm",l:-1,t:"getAttributeValue",i:0.000547896712048985,a:"getAttributeValue The getAttributeValue method gets the value of the specified attribute. Syntax getAttributeValue( name ) Arguments Returns (String). The attribute value."},"451":{y:0,u:"../Content/Lua/LuaField/_LUA_getField.htm",l:-1,t:"getField",i:0.000547896712048985,a:"getField The getField method returns the specified sub field. Syntax getField ( name [, case]) Arguments Returns (LuaField) A LuaField object."},"452":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldNames.htm",l:-1,t:"getFieldNames",i:0.000547896712048985,a:"The getFieldNames method returns the names of the sub fields in the LuaField object. Syntax getFieldNames() Returns (Strings). The names of the sub fields. The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: fieldnames = { ..."},"453":{y:0,u:"../Content/Lua/LuaField/_LUA_getFields.htm",l:-1,t:"getFields",i:0.000547896712048985,a:"The getFields method returns all of the sub fields specified by the name argument. Syntax getFields( name [, case] ) Arguments Returns (LuaFields) One LuaField per matching field. The objects can be assigned to a table. To map the return values to a table, surround the function call with braces. For ..."},"454":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldsByRegex.htm",l:-1,t:"getFieldsByRegex",i:0.000547896712048985,a:"The getFieldsByRegex method returns all sub fields where the sub field name or path (relative to this field) matches a regular expression. Syntax getFieldsByRegex( regex [, recursive [, matchFullPath [, caseSensitive ]]]) Arguments Returns (LuaFields) A list of LuaField objects where each LuaField ..."},"455":{y:0,u:"../Content/Lua/LuaField/_LUA_getFieldValues.htm",l:-1,t:"getFieldValues",i:0.000547896712048985,a:"The getFieldValues method returns the values of all of the sub fields with the specified name. Syntax getFieldValues( fieldname [, case] ) Arguments Returns (Strings) One string for each value. The strings can be assigned to a table. To map the return values to a table, surround the function call ..."},"456":{y:0,u:"../Content/Lua/LuaField/_LUA_getValueByPath.htm",l:-1,t:"getValueByPath",i:0.000547896712048985,a:"The getValueByPath method gets the value of a sub-field, specified by path.   If you pass this method the path of a sub-field that has multiple values, only the first value is returned. To return all of the values from a multi-value sub-field, see  getValuesByPath . Syntax getValueByPath( path ) ..."},"457":{y:0,u:"../Content/Lua/LuaField/_LUA_getValuesByPath.htm",l:-1,t:"getValuesByPath",i:0.00101360932111028,a:"The getValuesByPath method gets the values of a sub-field, specified by path.   Syntax getValuesByPath( path ) Arguments Returns (Strings). Strings that contain the values. To map the return values to a table, surround the function call with braces. For example: fieldvalues = { ..."},"458":{y:0,u:"../Content/Lua/LuaField/_LUA_hasAttribute.htm",l:-1,t:"hasAttribute",i:0.000547896712048985,a:"hasAttribute The hasAttribute method returns a Boolean indicating whether the field has the specified attribute. Syntax hasAttribute( name ) Arguments Returns (Boolean). A Boolean specifying if the field has the specified attribute."},"459":{y:0,u:"../Content/Lua/LuaField/_LUA_hasField.htm",l:-1,t:"hasField",i:0.000547896712048985,a:"hasField The hasField method returns a Boolean specifying if the sub field exists. Syntax hasField( fieldname [, case]) Arguments Returns (Boolean). A Boolean specifying if the sub field exists or not."},"460":{y:0,u:"../Content/Lua/LuaField/_LUA_insertJson.htm",l:-1,t:"insertJson",i:0.000547896712048985,a:"insertJson The insertJson method inserts metadata from a JSON string, LuaJsonObject, or LuaJsonArray, into the field. Syntax insertJson ( json [, fieldName] ) Arguments See Also LuaDocument:insertJson"},"461":{y:0,u:"../Content/Lua/LuaField/_LUA_insertXml.htm",l:-1,t:"insertXml",i:0.000547896712048985,a:"insertXml The insertXml method inserts XML metadata into the document. When called on a LuaField, the insertXml method inserts the fields as children of the LuaField. Syntax insertXml ( node ) Arguments Returns (LuaField). A LuaField object of the inserted data."},"462":{y:0,u:"../Content/Lua/LuaField/_LUA_insertXmlWithoutRoot.htm",l:-1,t:"insertXmlWithoutRoot",i:0.000547896712048985,a:"The insertXmlWithoutRoot method inserts XML metadata into the document. This method does not insert the top level node. All of the child nodes are inserted into the document. insertXmlWithoutRoot(node) is therefore equivalent to calling insertXml() for each child node. Syntax insertXmlWithoutRoot ( ..."},"463":{y:0,u:"../Content/Lua/LuaField/_LUA_name.htm",l:-1,t:"name",i:0.000547896712048985,a:"name The name method returns the name of the field object. Syntax name() Returns (String). The name of the field object."},"464":{y:0,u:"../Content/Lua/LuaField/_LUA_renameField.htm",l:-1,t:"renameField",i:0.000547896712048985,a:"renameField The renameField method renames a sub field. Syntax renameField( oldname, newname [, case] ) Arguments"},"465":{y:0,u:"../Content/Lua/LuaField/_LUA_setAttributeValue.htm",l:-1,t:"setAttributeValue",i:0.000547896712048985,a:"setAttributeValue The setAttributeValue method sets the value for the specified attribute of the field. Syntax setAttributeValue( attribute, value ) Arguments"},"466":{y:0,u:"../Content/Lua/LuaField/_LUA_setValue.htm",l:-1,t:"setValue",i:0.000547896712048985,a:"setValue The setValue method sets the value of the field. Syntax setValue( value ) Arguments"},"467":{y:0,u:"../Content/Lua/LuaField/_LUA_value.htm",l:-1,t:"value",i:0.000547896712048985,a:"value The value method returns the value of the field object. Syntax value() Returns (String). The value of the field object."},"468":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA__LuaHttpRequest.htm",l:-1,t:"LuaHttpRequest Methods",i:0.000697917757933773,a:"This section describes the methods provided by LuaHttpRequest objects. If you have a LuaHttpRequest object called request you can call its methods using the \u0027:\u0027 operator. For example: request:send() Method Description send Sends the HTTP request. set_body Sets the body of the HTTP request. ..."},"469":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_LuaHttpRequest_new.htm",l:-1,t:"LuaHttpRequest:new",i:0.000604034586290315,a:"The constructor for a LuaHttpRequest object (creates a new LuaHttpRequest). Syntax LuaHttpRequest:new( config, section ) Arguments Returns (LuaHttpRequest). The new LuaHttpRequest object. Example The following example creates a new LuaHttpRequest object by reading configuration settings from a ..."},"470":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_send.htm",l:-1,t:"send",i:0.000772071593194735,a:"The send method sends the HTTP request. Syntax send() Returns (LuaHttpResponse). A  LuaHttpResponse  object. The send method can throw an exception if the request fails. You can catch an exception by calling the method  using the Lua function pcall. Example The following example shows how to send a ..."},"471":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_body.htm",l:-1,t:"set_body",i:0.000604034586290315,a:"set_body The set_body method sets the body of the HTTP request. Syntax set_body( body ) Arguments"},"472":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_config.htm",l:-1,t:"set_config",i:0.000604034586290315,a:"The set_config method specifies settings to use for sending the HTTP request (in the form of a section from a configuration file). For example, you can specify the proxy server to use by setting the parameters ProxyHost and ProxyPort, or specify the SSL version to use by setting SSLMethod. Syntax ..."},"473":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_header.htm",l:-1,t:"set_header",i:0.0011174644512566,a:"set_header The set_header method adds a header to the HTTP request. Syntax set_header( name, value ) Arguments Example request:set_header(\"X-EXAMPLE\", \"Example\")"},"474":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_headers.htm",l:-1,t:"set_headers",i:0.000604034586290315,a:"set_headers The set_headers method replaces all headers in the HTTP request with new headers. To add a header without changing existing headers, use the method  set_header . Syntax set_headers( headers ) Arguments Example request:set_headers( {X-EXAMPLE=\"Example\", X-ANOTHER=\"ANOTHER\"} )"},"475":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_method.htm",l:-1,t:"set_method",i:0.000604034586290315,a:"set_method Specifies the HTTP request method to use when sending the request, for example GET or POST.  Syntax set_method( method ) Arguments Example request:set_method(\"POST\")"},"476":{y:0,u:"../Content/Lua/LuaHttpRequest/_LUA_set_url.htm",l:-1,t:"set_url",i:0.000604034586290315,a:"set_url The set_url method sets the URL that you want to send the HTTP request to. Syntax set_url( url ) Arguments Example request:set_url(\"https://www.example.com/\")"},"477":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA__LuaHttpResponse.htm",l:-1,t:"LuaHttpResponse Methods",i:0.00118614227259254,a:"This section describes the methods provided by LuaHttpResponse objects. A LuaHttpResponse object is provided when you send an HTTP request using the  send  method on a  LuaHttpRequest  object. If you have a LuaHttpResponse object called response you can call its methods using the \u0027:\u0027 operator. For ..."},"478":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_body.htm",l:-1,t:"get_body",i:0.000697917757933773,a:"get_body The get_body method returns the body of the HTTP response. Syntax get_body() Returns (String). The body of the HTTP response."},"479":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_header.htm",l:-1,t:"get_header",i:0.000697917757933773,a:"get_header The get_header method returns the value of a specified HTTP header. Syntax get_header( name ) Arguments Returns (String). The value of the header."},"480":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_headers.htm",l:-1,t:"get_headers",i:0.000697917757933773,a:"The get_headers method returns the names and values of all of the headers in the HTTP response. Syntax get_headers() Returns (table) A table that maps header names to values. Example The following example sends an HTTP request and then prints the headers that are returned to the console: local ..."},"481":{y:0,u:"../Content/Lua/LuaHttpResponse/_LUA_get_http_code.htm",l:-1,t:"get_http_code",i:0.000697917757933773,a:"get_http_code The get_http_code method returns the HTTP response code for the request. Syntax get_http_code() Returns (number). The response code, for example 200 for success, or 404 for not found."},"482":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA__LuaJsonArray.htm",l:-1,t:"LuaJsonArray Methods",i:0.00296650976799116,a:"A LuaJsonArray object represents a JSON array. If you have a LuaJsonArray object called myJsonArray you can call its methods using the \u0027:\u0027 operator. For example: myJsonArray:size() Method Description append Appends a value to the array. clear Clears the array, so that it contains no values. copy ..."},"483":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_LuaJsonArray_new.htm",l:-1,t:"LuaJsonArray:new",i:0.000740008777360899,a:"The constructor for a LuaJsonArray object (creates a new LuaJsonArray). Syntax LuaJsonArray:new( values ) Arguments Returns (LuaJsonArray). The new LuaJsonArray object. Example The following is a simple JSON array: [4, \"a string\", true] To create a LuaJsonArray object to represent this array: local ..."},"484":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_append.htm",l:-1,t:"append",i:0.000740008777360899,a:"append The append method appends a value to the JSON array. Syntax append( value ) Arguments Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:append(6)\n-- the array is now [4, \"a string\", true, 6]"},"485":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_clear.htm",l:-1,t:"clear",i:0.000740008777360899,a:"clear The clear method clears the array, so that it contains no values. Syntax clear() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nmyJsonArray:clear()\nprint (myJsonArray:string())\n-- []"},"486":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_copy.htm",l:-1,t:"copy",i:0.000740008777360899,a:"The copy method returns a copy of the array. Modifying the copy does not modify the original array. Syntax copy() Returns (LuaJsonArray). A copy of the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nlocal anotherJsonArray = myJsonArray:copy()\nprint ..."},"487":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_empty.htm",l:-1,t:"empty",i:0.000740008777360899,a:"The empty method checks whether the JSON array is empty. Syntax empty() Returns (Boolean). Returns true if the array is empty. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nprint (\"Is the array empty?  \" , myJsonArray:empty() )\n-- Is the array empty?   ..."},"488":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_exists.htm",l:-1,t:"exists",i:0.00493327526214468,a:"The exists method checks whether a specified path exists in the JSON array. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ..."},"489":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00493327526214468,a:"The existsByPath method checks whether a specified path exists in the JSON array. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = ..."},"490":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_ipairs.htm",l:-1,t:"ipairs",i:0.000740008777360899,a:"The ipairs method returns a function that you can use with a for loop to iterate over all of the values in the array. Syntax ipairs() Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\n\nfor i, v in myJsonArray:ipairs() do\n  print (v:string())\nend\n\n-- prints the following...\n-- 4\n-- a ..."},"491":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00493327526214468,a:"The lookup method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ..."},"492":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00493327526214468,a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original array. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"493":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_size.htm",l:-1,t:"size",i:0.000740008777360899,a:"size The size method returns the size of the JSON array. Syntax size() Returns (integer). The number of values in the array. Example local myJsonArray = LuaJsonArray:new(4,\"a string\",true)\nprint (\"Array size is \" , myJsonArray:size() )\n-- Array size is 3"},"494":{y:0,u:"../Content/Lua/LuaJsonArray/_LUA_string.htm",l:-1,t:"string",i:0.000740008777360899,a:"The string method returns the JSON array as a string. Syntax string() Returns (String). The array as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal myJsonArray = LuaJsonArray:new(\"zero\",1,2,myJsonObject)\n\nprint (myJsonArray:string())\n-- ..."},"495":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA__LuaJsonObject.htm",l:-1,t:"LuaJsonObject Methods",i:0.00296650976799116,a:"A LuaJsonObject object represents a JSON object. If you have a LuaJsonObject object called object you can call its methods using the \u0027:\u0027 operator. For example: object:size() Method Description assign Adds an attribute (a name/value pair) to the object. assign Adds a table of attributes (name/value ..."},"496":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_LuaJsonObject_new.htm",l:-1,t:"LuaJsonObject:new",i:0.000709990487884964,a:"The constructor for a LuaJsonObject object (creates a new LuaJsonObject). If you do not specify any attributes to assign to the object (by omitting the attributes argument), an empty object is created. Syntax LuaJsonObject:new( [attributes] ) Arguments Returns (LuaJsonObject). The new LuaJsonObject ..."},"497":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_assign.htm",l:-1,t:"assign",i:0.000709990487884964,a:"The assign method adds an attribute (a name/value pair) to the object. Syntax assign (name, value) Arguments Example local myJsonObject = LuaJsonObject:new( { name1=\"value1\" , name2=\"value2\" } )\nmyJsonObject:assign(\"name3\", \"value3\")\nmyJsonObject:assign(\"name4\", LuaJsonArray:new(\"value4a\",\"value4b\") ..."},"498":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_assign2.htm",l:-1,t:"assign",i:0.000709990487884964,a:"The assign method adds a table of attributes (name/value pairs) to the object. Syntax assign (attributes) Arguments Example local myJsonObject = LuaJsonObject:new()\nmyJsonObject:assign( {\n        attr1=LuaJsonObject:new( { n=42 } ),\n        attr2=LuaJsonArray:new( 1, 2, \"three\" ),\n        ..."},"499":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_clear.htm",l:-1,t:"clear",i:0.000709990487884964,a:"clear The clear method clears the object, so that it contains no attributes (name/value pairs). Syntax clear() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:clear()\nprint (myJsonObject:string())\n-- {}"},"500":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_copy.htm",l:-1,t:"copy",i:0.000709990487884964,a:"The copy method returns a copy of the JSON object. Modifying the copy does not modify the original object. Syntax copy() Returns (LuaJsonObject). A copy of the object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nlocal anotherJsonObject = ..."},"501":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_empty.htm",l:-1,t:"empty",i:0.000709990487884964,a:"empty The empty method determines whether the JSON object is empty. Syntax empty() Returns (Boolean). Returns true if the object has no attributes (name/value pairs). Example local myJsonObject = LuaJsonObject:new()\nprint(myJsonObject:empty())\n-- true\n"},"502":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_erase.htm",l:-1,t:"erase",i:0.000709990487884964,a:"erase The erase method removes a specified attribute (name/value pair) from the JSON object. Syntax erase( name ) Arguments Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nmyJsonObject:erase(\"version\")\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\"}"},"503":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_exists.htm",l:-1,t:"exists",i:0.00473315977647315,a:"The exists method checks whether a specified path exists in the JSON object. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"504":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00473315977647315,a:"The existsByPath method checks whether a specified path exists in the JSON object. Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"505":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00473315977647315,a:"The lookup method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"506":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00473315977647315,a:"The lookupByPath method returns the value at the specified path in the JSON object. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"507":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_pairs.htm",l:-1,t:"pairs",i:0.000709990487884964,a:"The pairs method returns an iterator function that you can use with a for loop to iterate over all of the attributes contained in the JSON object. Syntax pairs() Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\n\nfor i, v in myJsonObject:pairs() do\n  print (i .. \u0027=\u0027 ..."},"508":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_size.htm",l:-1,t:"size",i:0.000709990487884964,a:"size The size method returns the number of attributes (name/value pairs) in the JSON object. Syntax size() Returns (Number). The number of attributes in the JSON object. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:size())\n-- 2"},"509":{y:0,u:"../Content/Lua/LuaJsonObject/_LUA_string.htm",l:-1,t:"string",i:0.000709990487884964,a:"string The string method returns the JSON object as a string. Syntax string() Returns (String). The JSON object as a string. Example local myJsonObject = LuaJsonObject:new( { product=\"IDOL\" , version=11 } )\nprint (myJsonObject:string())\n-- {\"product\":\"IDOL\",\"version\":11}"},"510":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA__LuaJsonValue.htm",l:-1,t:"LuaJsonValue Methods",i:0.00248338039313723,a:"A LuaJsonValue object represents a JSON value.  If you have a LuaJsonValue object called myJsonValue you can call its methods using the \u0027:\u0027 operator. For example: myJsonValue:is_object() Method Description array Gets a LuaJsonArray that represents the JSON array, if the value is an array. copy ..."},"511":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_LuaJsonValue_new.htm",l:-1,t:"LuaJsonValue:new",i:0.000640979483574984,a:"LuaJsonValue:new The constructor for a LuaJsonValue object (creates a new LuaJsonValue). Syntax LuaJsonValue:new( value ) Arguments Returns (LuaJsonValue). The new LuaJsonValue object."},"512":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_array.htm",l:-1,t:"array",i:0.000640979483574984,a:"The array method gets the array, if the value is a JSON array. Syntax array() Returns (LuaJsonArray). A  LuaJsonArray  object that represents the array. Example local fh = io.open(\"example_array.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = ..."},"513":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_copy.htm",l:-1,t:"copy",i:0.000640979483574984,a:"copy The copy method returns a copy of the value. Modifying the copy does not affect the original value. Syntax copy() Returns (LuaJsonValue). A copy of the value."},"514":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_exists.htm",l:-1,t:"exists",i:0.00427310078723402,a:"The exists method checks whether a specified path exists in the JSON value. Syntax exists( pathElements ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example \nConsider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"515":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_existsByPath.htm",l:-1,t:"existsByPath",i:0.00427310078723402,a:"The existsByPath method checks whether a specified path exists in the JSON value.  Syntax existsByPath( path ) Arguments Returns (Boolean) Returns true if the path exists, false otherwise. Example Consider the following JSON: \n{\n  \"product\": \"IDOL\",\n  \"component\": \"CFS\",\n  \"version\": { \"major\": 11, ..."},"516":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_array.htm",l:-1,t:"is_array",i:0.000640979483574984,a:"is_array The is_array method whether the value is a JSON array. Syntax is_array() Returns (Boolean). Returns true if the value is an array value, false otherwise."},"517":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_boolean.htm",l:-1,t:"is_boolean",i:0.000640979483574984,a:"is_boolean The is_boolean method returns whether the value is a Boolean value. Syntax is_boolean() Returns (Boolean). Returns true if the value is a Boolean value, false otherwise."},"518":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_float.htm",l:-1,t:"is_float",i:0.000640979483574984,a:"is_float The is_float method returns whether the value is a floating point value. Syntax is_float() Returns (Boolean). Returns true if the value is a floating point value, false otherwise."},"519":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_integer.htm",l:-1,t:"is_integer",i:0.000640979483574984,a:"is_integer The is_integer method returns whether the value is an integral value. Syntax is_integer() Returns (Boolean). Returns true if the value is an integer value, false otherwise."},"520":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_null.htm",l:-1,t:"is_null",i:0.000640979483574984,a:"is_null The is_null method returns whether the value is a null value. Syntax is_null() Returns (Boolean). Returns true if the value is a null value, false otherwise."},"521":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_number.htm",l:-1,t:"is_number",i:0.000640979483574984,a:"is_number The is_number method returns whether the value is a number. Syntax is_number() Returns (Boolean). Returns true if the value is a number, false otherwise."},"522":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_object.htm",l:-1,t:"is_object",i:0.000640979483574984,a:"is_object The is_object method returns whether the value is a JSON object. Syntax is_object() Returns (Boolean). Returns true if the value is a JSON object, false otherwise."},"523":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_simple_value.htm",l:-1,t:"is_simple_value",i:0.000640979483574984,a:"is_simple_value The is_simple_value method returns whether the value is a simple value (Boolean, float, integer, or string). Syntax is_simple_value() Returns (Boolean). Returns true if the value is a simple value, false otherwise."},"524":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_is_string.htm",l:-1,t:"is_string",i:0.000640979483574984,a:"is_string The is_string method returns whether the value is a string value. Syntax is_string() Returns (Boolean). Returns true if the value is a string value, false otherwise."},"525":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_lookup.htm",l:-1,t:"lookup",i:0.00427310078723402,a:"The lookup method returns the value at the specified path in the JSON value. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookup( pathElements ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified path, ..."},"526":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_lookupByPath.htm",l:-1,t:"lookupByPath",i:0.00427310078723402,a:"The lookupByPath method returns the value at the specified path in the JSON array. This method does not make a copy of the value, so modifying the returned value affects the original object. Syntax lookupByPath( path ) Arguments Returns (LuaJsonValue) Returns the value that exists at the specified ..."},"527":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_object.htm",l:-1,t:"object",i:0.000640979483574984,a:"The object method gets the object, if the value is a JSON object. Syntax object() Returns (LuaJsonObject) A  LuaJsonObject  object that represents the JSON object. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n\nlocal myJsonValue = ..."},"528":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_string.htm",l:-1,t:"string",i:0.000640979483574984,a:"The string method returns the JSON value as a string. Syntax string() Returns (String). The JSON value as a string. Example local fh = io.open(\"example_json.json\", \"r\")\nlocal file_content = fh:read(\"*all\")\nfh:close()\n    \nlocal myJsonValue = parse_json(file_content)\n\nprint(myJsonValue:string())\n"},"529":{y:0,u:"../Content/Lua/LuaJsonValue/_LUA_value.htm",l:-1,t:"value",i:0.000640979483574984,a:"The value method gets the value, if the JSON value is a simple type (a Boolean, float, integer, or string). This method returns a default value if one is specified and the value cannot be converted to the same type as the default. Syntax value( [default] ) Arguments Returns (lua_json_simple_type). A ..."},"530":{y:0,u:"../Content/Lua/LuaLog/_LUA_LuaLog.htm",l:-1,t:"LuaLog Methods",i:0.00423666345341603,a:"LuaLog Methods A LuaLog object provides the capability to use a log stream. You can obtain a LuaLog object for a log stream by using the function  get_log . If you have a LuaLog object called log you can call its methods using the \u0027:\u0027 operator. For example: log:write_line(level, message)"},"531":{y:0,u:"../Content/Lua/LuaLog/_LUA_write_line.htm",l:-1,t:"write_line",i:0.00233046595948679,a:"The write_line method writes a message to the log stream. Syntax write_line( level, message ) Arguments Example To write a log message from the ExecuteDocumentLua processor in IDOL NiFi Ingest: local log = get_log()\nlog:write_line(log_level_normal(), \"doing something...\")\n\n-- or use the following ..."},"532":{y:0,u:"../Content/Lua/LuaLogService/_LUA__LuaLogService.htm",l:-1,t:"LuaLogService Methods",i:0.000651013459320902,a:"A LuaLogService object provides the capability to write messages to a custom log file. To write messages to standard log files, OpenText recommends using the function  get_log  instead. If you have a LuaLogService object called myLogService you can call its methods using the \u0027:\u0027 operator. For ..."},"533":{y:0,u:"../Content/Lua/LuaLogService/_LUA_LuaLogService_new.htm",l:-1,t:"LuaLogService:new",i:0.000714334731108206,a:"The constructor for a LuaLogService object (creates a new LuaLogService). Do not construct a new log service to write messages to log types that are defined in the ConnectorLib C++ configuration file. Syntax LuaLogService:new( config ) Arguments Returns (LuaLogService). The new LuaLogService object. ..."},"534":{y:0,u:"../Content/Lua/LuaLogService/_LUA_get_log.htm",l:-1,t:"get_log",i:0.000714334731108206,a:"get_log The get_log method returns a LuaLog object that you can use to write log messages to a specified log type. Syntax get_log( type ) Arguments Returns (LuaLog). A  LuaLog  object."},"535":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_LuaRegexMatch_Methods.htm",l:-1,t:"LuaRegexMatch Methods",i:0.00137418582975652,a:"A LuaRegexMatch object provides information about the matches for a regular expression found in a string. For example, the regex_search function returns a LuaRegexMatch object. If a match is found for a regular expression at multiple points in the string, you can use the next() method to get a ..."},"536":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_length.htm",l:-1,t:"length",i:0.000763492596828372,a:"length The length method returns the length of the match. You can also retrieve the length of sub matches by specifying the submatch parameter. Syntax length( [ submatch ] ) Arguments Returns (Number). The length of the sub match."},"537":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_next.htm",l:-1,t:"next",i:0.000763492596828372,a:"next The next method returns a LuaRegexMatch object for the next match. Syntax next() Returns (LuaRegexMatch). A LuaRegexMatch object for the next match, or nil if there are no matches following this one."},"538":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_position.htm",l:-1,t:"position",i:0.000763492596828372,a:"The position method returns the position of the match in the string searched, where 1 refers to the first character in the string. You can also retrieve the position of sub matches by specifying the submatch parameter. Syntax position( [ submatch ] ) Arguments Returns (Number). The position of the ..."},"539":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_size.htm",l:-1,t:"size",i:0.000763492596828372,a:"size The size method returns the total number of sub matches made for the current match, including the whole match (sub match 0). Syntax size() Returns (Number). The number of sub matches for the current match."},"540":{y:0,u:"../Content/Lua/LuaRegexMatch/_LUA_str.htm",l:-1,t:"str",i:0.000763492596828372,a:"str The str method returns the matched text. You can also retrieve the values of sub matches by specifying the submatch parameter. Syntax str( [ submatch ] ) Arguments Returns (String). The value of the sub match."},"541":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_LuaXmlDocument_Methods.htm",l:-1,t:"LuaXmlDocument Methods",i:0.000529880751029353,a:"This section describes the methods provided by LuaXmlDocument objects. A LuaXmlDocument object provides methods for accessing information stored in XML format. You can create a LuaXmlDocument from a string containing XML using the parse_xml function. If you have a LuaXmlDocument object called xml ..."},"542":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_root.htm",l:-1,t:"root",i:0.000619960556127512,a:"root The root method returns an LuaXmlNode, which is the root node of the XML document. Syntax root() Returns (LuaXmlNode). A LuaXmlNode object."},"543":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathExecute.htm",l:-1,t:"XPathExecute",i:0.000619960556127512,a:"XPathExecute The XPathExecute method returns a LuaXmlNodeSet, which is the result of the supplied XPath query. Syntax XPathExecute( xpathQuery ) Arguments Returns (LuaXmlNodeSet). A LuaXmlNodeSet object."},"544":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathRegisterNs.htm",l:-1,t:"XPathRegisterNs",i:0.000619960556127512,a:"XPathRegisterNs The XPathRegisterNs method registers a namespace with the XML parser. Syntax XPathRegisterNs( prefix, location ) Arguments Returns (Boolean). True if successful, False in case of error."},"545":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValue.htm",l:-1,t:"XPathValue",i:0.000619960556127512,a:"XPathValue The XPathValue method returns the first occurrence of the value matching the XPath query. Syntax XPathValue( query ) Arguments Returns (String). A string of the value."},"546":{y:0,u:"../Content/Lua/LuaXmlDocument/_LUA_XPathValues.htm",l:-1,t:"XPathValues",i:0.000619960556127512,a:"The XPathValues method returns the values according to the XPath query. Syntax XPathValues( query ) Arguments Returns (Strings). The strings can be assigned to a table. To map the return values to a table, surround the function call with braces. For example: values = { xml:XPathValues(query) }"},"547":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_LuaXmlNodeSet_Methods.htm",l:-1,t:"LuaXmlNodeSet Methods",i:0.000529880751029353,a:"LuaXmlNodeSet Methods A LuaXmlNodeSet object represents a set of XML nodes. If you have a LuaXmlNodeSet object called nodes you can call its methods using the \u0027:\u0027 operator. For example: nodes:size()"},"548":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_at.htm",l:-1,t:"at",i:0.000755080263774752,a:"at The at method returns the LuaXmlNode at position position in the set. Syntax at( position ) Arguments Returns (LuaXmlNode)."},"549":{y:0,u:"../Content/Lua/LuaXmlNodeSet/_LUA_size.htm",l:-1,t:"size",i:0.000755080263774752,a:"size The size method returns the size of the node set. Syntax size() Returns (Number) An integer, the size of the node set."},"550":{y:0,u:"../Content/Lua/LuaXmlNode/_LUA_LuaXmlNode_Methods.htm",l:-1,t:"LuaXmlNode Methods",i:0.000529880751029353,a:"LuaXmlNode Methods A LuaXmlNode object represents a single node in an XML document.  If you have a LuaXmlNode object called node you can call its methods using the \u0027:\u0027 operator. For example: node:name()"},});