define({"0":{y:0,u:"../Content/Tutorial/Introduction.htm",l:-1,t:"Introduction",i:0.00356663975161205,a:"Connectors provide the connection between Knowledge Discovery and the repositories that your organization uses for storing and organizing information. You can use connectors to keep your Knowledge Discovery index up-to-date with the information in a repository (using the synchronize fetch action) ..."},"1":{y:0,u:"../Content/ConnectorLib_Tutorial.htm",l:-1,t:"ConnectorLib C++ Tutorial",i:0.000535006340003021,a:"ConnectorLib C++ Tutorial This section shows how to use the ConnectorLib C++ SDK to build a connector."},"2":{y:0,u:"../Content/Tutorial/Prerequisites.htm",l:-1,t:"Prerequisites",i:0.000535006340003021,a:"Prerequisites Before you can run some of the code samples in the ConnectorLib C++ SDK, you must obtain some third-party libraries and set some environment variables:"},"3":{y:0,u:"../Content/Tutorial/Implement.htm",l:-1,t:"Implement a New Connector",i:0.00127019493689961,a:"Implement a New Connector This section describes how to implement a new connector."},"4":{y:0,u:"../Content/Tutorial/Create_the_Visual_Studio.htm",l:-1,t:"Create the Visual Studio Solution",i:0.000535006340003021,a:"To create a new connector using Visual Studio, follow these steps: Create a new solution containing an empty Win32 DLL project. The project will contain the code for your connector. In the project properties, add the \"include\" path contained in the SDK to the list of Include Directories. Add a new ..."},"5":{y:0,u:"../Content/Tutorial/Extend_ConnectorBase.htm",l:-1,t:"Extend ConnectorBase",i:0.000535006340003021,a:"To create a new connector, you must include the SDK header files in the source file.  Add the following include statement at the top of the source file you created: #include \u003cautonomy/connector/connector.hpp\u003e So that the required classes are conveniently accessible, add the following using statement ..."},"6":{y:0,u:"../Content/Tutorial/RunConnector/Run_Introduction.htm",l:-1,t:"Run the Connector",i:0.00144451784493525,a:"Run the Connector This section describes how to run a new connector."},"7":{y:0,u:"../Content/Tutorial/RunConnector/Required_Files.htm",l:-1,t:"Required Files",i:0.00068659159082506,a:"To run the connector, you must place the following files in a directory (from now on called the connector directory). All of the files, except your connector  library , are provided with the SDK. Your connector  library (*.dll or lib*.so) , and any dependencies connectorLibCpp.cfg ..."},"8":{y:0,u:"../Content/Tutorial/RunConnector/Configure.htm",l:-1,t:"Configure the Connector",i:0.00068659159082506,a:"Before running the connector you must modify connectorLibCpp.cfg. In the [Connector] section of the configuration file, set the following parameter. This parameter tells ConnectorLib C++ how to locate your connector implementation: For example, this is the configuration for the HelloWorld connector ..."},"9":{y:0,u:"../Content/Tutorial/RunConnector/RunConnector.htm",l:-1,t:"Run the Connector",i:0.000535006340003021,a:"After you have collected the  required files  and  configured the connector , you can run the connector by starting connectorLibCpp.exe. Install the Connector as a Service You can install the connector as a service using the -install command line option. For example: connectorLibCpp.exe -install ..."},"10":{y:0,u:"../Content/Tutorial/RunConnector/Troubleshooting.htm",l:-1,t:"Troubleshoot Errors",i:0.000535006340003021,a:"If you run the connector and find that it stops immediately, check the logs to see if any errors occurred at the time you tried to start it. You can also try running the connector from the command prompt to see if any messages are output to the console.  The following table provides the solutions ..."},"11":{y:0,u:"../Content/Tutorial/Documents/Documents_Introduction.htm",l:-1,t:"Create and Ingest Documents",i:0.000535006340003021,a:"Create and Ingest Documents This section describes how to create and ingest Documents using ConnectorLib C++."},"12":{y:0,u:"../Content/Tutorial/Documents/Documents_Intro.htm",l:-1,t:"Introduction",i:0.000535006340003021,a:"Much of what a connector does involves dealing with documents in some way. A document represents a single document in the index and has: A unique reference to identify it. A unique identifier for finding it in the repository. A set of key-value pairs for storing metadata. Optionally, a file storing ..."},"13":{y:0,u:"../Content/Tutorial/Documents/Create_a_Document.htm",l:-1,t:"Create a Document",i:0.000535006340003021,a:"With ConnectorLib C++, you can create a new document using the createDocInfo(...) functions on an instance of the DocInfoBuilder class.  You can create the DocInfoBuilder from any ConnectorTask object.        DocInfoBuilder builder = task.docInfoBuilder();\n\n       DocInfo docInfo = ..."},"14":{y:0,u:"../Content/Tutorial/Documents/Add_Metadata.htm",l:-1,t:"Add Metadata",i:0.000535006340003021,a:"Often repositories store metadata about the files they contain, such as who created a file and when it was last modified. Metadata might also include repository-specific information. For example, a repository storing information about products for sale might include a price and a description for ..."},"15":{y:0,u:"../Content/Tutorial/Documents/Metadata_only_Documents.htm",l:-1,t:"Create Metadata-only Documents",i:0.000535006340003021,a:"To create a document that has metadata but no file, use a different overload of DocInfoBuilder::createDocInfo:        DocInfo docInfo = builder.createDocInfo(\n               \"http://www.example.com/metadataOnly\"); You might create a metadata-only document when items in a repository do not include ..."},"16":{y:0,u:"../Content/Tutorial/Documents/Identifiers.htm",l:-1,t:"Create Identifiers",i:0.000535006340003021,a:"Although a document\u0027s reference should identify a unique file or item  in the repository, it might not be sufficient for the connector to retrieve it again efficiently (this might be necessary, for example, in response to a collect request). You can therefore add additional information to a ..."},"17":{y:0,u:"../Content/Tutorial/Documents/Ingest_a_Document.htm",l:-1,t:"Ingest a Document",i:0.000535006340003021,a:"A connector\u0027s synchronize action typically involves retrieving files and associated metadata from a repository, creating documents from those files, and sending the documents  to the ingestion target, configured in the [Ingestion] section of the configuration file. Usually the target is a CFS, which ..."},"18":{y:0,u:"../Content/Tutorial/Documents/Ingest_Add.htm",l:-1,t:"Ingest Add",i:0.00143314901632845,a:"The Ingest Add method adds a new document to the ingestion target. You can create and ingest a document  like this:        DocInfo docInfo = task.docInfoBuilder().createDocInfo(\n          \"http://www.example.com/testDocument.doc\",\n          \"testDocument.doc\",\n          true);\n\n       Metadata ..."},"19":{y:0,u:"../Content/Tutorial/Documents/Ingest_Remove.htm",l:-1,t:"Ingest Remove",i:0.00164224246965218,a:"The Remove method deletes a document that has previously been ingested. Only the reference is required to do this:        task.ingester().remove(\"http://www.example.com/testDocument.doc\"); The synchronize action typically removes documents when the connector detects that a document has been removed ..."},"20":{y:0,u:"../Content/Tutorial/Documents/Ingest_Replace.htm",l:-1,t:"Ingest Replace",i:0.00068659159082506,a:"The Replace method is short-hand for performing a  Remove  followed by an  Add. You can use this method when a document in a repository has been changed.        DocInfo docInfo = task.docInfoBuilder().createDocInfo(\n          \"http://www.example.com/testDocument.doc\",\n          \"testDocument.doc\",\n  ..."},"21":{y:0,u:"../Content/Tutorial/Documents/Ingest_Update.htm",l:-1,t:"Ingest Update",i:0.000535006340003021,a:"If a document has been ingested previously, and the metadata for the document has changed but the file content has not, you can use the Ingest Update method. This instructs the target to update the metadata for an existing document, but to leave the content intact. The following example updates just ..."},"22":{y:0,u:"../Content/Tutorial/Documents/Ingest_Result_Handlers.htm",l:-1,t:"Ingest Result Handlers",i:0.000535006340003021,a:"When you ingest a document using the Add, Replace, Remove or Update methods, the ingest command is placed in a queue and the method returns immediately. ConnectorLib C++ takes care of batching, sending the commands, and dealing with any transitory problems communicating with the target. As a result, ..."},"23":{y:0,u:"../Content/Tutorial/CompleteSynchronize/Introduction.htm",l:-1,t:"A Complete Synchronize Action",i:0.00222584581572673,a:"This section demonstrates code for a connector\u0027s synchronize action. During a complete synchronize, a connector ingests every document in a repository, regardless of whether the documents have changed since the last synchronize. \n            To avoid requiring additional dependencies, the sample ..."},"24":{y:0,u:"../Content/Tutorial/CompleteSynchronize/SampleCode_Cpp.htm",l:-1,t:"Sample Code for the Synchronize Action",i:0.00144451784493525,a:"The following sample code demonstrates a complete synchronize action. The synchronize action in this example generates documents for integers from 2 up to a configured limit IntegerLimit.  Each document contains some properties of the integer as metadata. The connector.hpp header file defines the ..."},"25":{y:0,u:"../Content/Tutorial/CompleteSynchronize/RunConnector.htm",l:-1,t:"Set up and Run the Connector",i:0.000535006340003021,a:"You can set up the connector using the instructions in  Run the Connector . SimpleSynchronize.dll must be in the connector directory, and you must set the following parameters in connectorLibCpp.cfg:        ConnectorLibrary=SimpleSynchronize This example connector ingests a document for each integer ..."},"26":{y:0,u:"../Content/Tutorial/CompleteSynchronize/Stopping.htm",l:-1,t:"Handle Stop Requests",i:0.000535006340003021,a:"A connector can be requested to stop at any time.  For example,  the connector might be running as a service that is stopped, it might receive an action=stop command to its service port, or a user might press CTRL+C in the connector’s console window.  The  sample code  calls the shouldStop method on ..."},"27":{y:0,u:"../Content/Tutorial/CompleteSynchronize/Full_Incremental_Sync.htm",l:-1,t:"Full and Incremental Synchronize",i:0.000535006340003021,a:"The synchronize action demonstrated in the  sample code  acts the same way every time it is called: the connector ingests every  document in the repository . This is called a full synchronize, and a connector would typically do this the first time the synchronize action is used. When the synchronize ..."},"28":{y:0,u:"../Content/Tutorial/IncrementalSynchronize/Make_Synchronize_Incremental.htm",l:-1,t:"Make an Incremental Synchronize Action",i:0.00156199660993688,a:"This section shows how to make an incremental synchronize action. An incremental synchronize is more efficient than running a full synchronize every time you need to synchronize with the information in the repository. The first time you run the synchronize action, the connector ingests all of the ..."},"29":{y:0,u:"../Content/Tutorial/IncrementalSynchronize/Incremental_Synchronize.htm",l:-1,t:"Incremental Synchronize",i:0.000535006340003021,a:"The incremental synchronize implemented by the sample code in   the IncrementalSynchronize project  works by maintaining the following datastore table: The connector adds one row to the table for every file that it finds in the repository.  The full path of the file is used as the  reference.  ..."},"30":{y:0,u:"../Content/Tutorial/IncrementalSynchronize/Incremental_Synchronize_Example.htm",l:-1,t:"Incremental Synchronize Example",i:0.000535006340003021,a:"This section describes the connector in operation. Cycle 1 To begin with, the datastore table is empty. The “data” directory (the repository from which the sample connector retrieves data) contains three files:        File1.txt\n       File2.txt\n       File3.txt When the synchronize action runs, the ..."},"31":{y:0,u:"../Content/Tutorial/IncrementalSynchronize/Code_Structure.htm",l:-1,t:"Sample Code Structure",i:0.000535006340003021,a:"Sample Code Structure The sample code in  the IncrementalSynchronize project  is split into the following classes:"},"32":{y:0,u:"../Content/Tutorial/Actions_Intro.htm",l:-1,t:"Implement Other Actions",i:0.000535006340003021,a:"So far this document has focused on implementing the synchronize fetch action, but a connector can implement other fetch actions in addition to, or instead of, synchronize.  We have already seen how to implement synchronize by overriding the synchronize method in ConnectorBase. ConnectorBase also ..."},"33":{y:0,u:"../Content/Tutorial/Actions_RetrieveDocuments.htm",l:-1,t:"Retrieve Documents from a Repository",i:0.000989762092469136,a:"The following table lists the fetch actions that retrieve information from a repository. The synchronize action has already been demonstrated in  A Complete Synchronize Action  and  Make an Incremental Synchronize Action . synchronizeIds, collect, and view  are all passed one or more DocInfo ..."},"34":{y:0,u:"../Content/Tutorial/Actions_UpdateRepository.htm",l:-1,t:"Update Documents in a Repository",i:0.000535006340003021,a:"The following table lists fetch actions that update documents in a repository. Like the Collect fetch action (see  Retrieve Documents from a Repository ), these actions are passed a collection of DocInfo objects, each of which contains an identifier.  Like the Collect fetch action,  s uccess or  f ..."},"35":{y:0,u:"../Content/Tutorial/Actions_Identifiers.htm",l:-1,t:"Browse a Repository",i:0.000535006340003021,a:"\n            The identifiers fetch action provides information that can be used to browse a repository. It retrieves a list of documents that are present in the repository and generates an identifier for each document. Enable the Action To enable the identifiers fetch action, update the features() ..."},"36":{y:0,u:"../Content/Tutorial/Actions_Stub.htm",l:-1,t:"Insert a Stub into a Repository",i:0.000535006340003021,a:"\n            The stub fetch action inserts a stub into a repository. A stub is a link to a document in another repository. An application might use your connector to insert a stub when a document is moved to another repository or is deleted. The stub can point to the new location, or in the case ..."},"37":{y:0,u:"../Content/Tutorial/Actions_RetrieveGroups.htm",l:-1,t:"Retrieve Group Information from a Repository",i:0.000535006340003021,a:"Retrieve Group Information from a Repository The SynchronizeGroups fetch action retrieves group information from a repository. This is discussed in more detail in  Mapped Security ."},"38":{y:0,u:"../Content/Tutorial/Actions_GetUri.htm",l:-1,t:"Retrieve the URI of a Document",i:0.000535006340003021,a:"A connector\u0027s GetUri action takes a document identifier and returns a URI for the document in the repository. Before you implement the GetUri action, enable the action by updating the features() function on the connector so that it returns Features::get_uri:         Features::feature_type ..."},"39":{y:0,u:"../Content/Tutorial/Actions_CustomFetch.htm",l:-1,t:"Implement Custom Fetch Actions",i:0.000535006340003021,a:"You can implement custom fetch actions in a ConnectorLib C++ connector. First add the custom_fetch feature to the list of supported features returned by the features function on ConnectorBase:        Features::feature_type MyConnector::features() \n       { \n          return ..."},"40":{y:0,u:"../Content/Tutorial/Actions_Custom.htm",l:-1,t:"Implement Custom Actions",i:0.000535006340003021,a:"You can implement custom actions in a ConnectorLib C++ connector. First add the custom feature to the list of supported features returned by the features function on ConnectorBase:        Features::feature_type MyConnector::features() \n       { \n          return ..."},"41":{y:0,u:"../Content/Tutorial/Security/Security_Introduction.htm",l:-1,t:"Mapped Security",i:0.000989762092469136,a:"Documents in a repository can often be viewed only by authenticated users, and different users are allowed to view different documents.  In this case you might want any output from Knowledge Discovery (for example, search results) to  show only documents that a user has permission to see.  This can ..."},"42":{y:0,u:"../Content/Tutorial/Security/AccessControlLists.htm",l:-1,t:"Access Control Lists",i:0.000815439184433493,a:"An Access Control List (ACL) is a string of text that specifies who is allowed to view a document.  Connectors can add an ACL to a document field, usually AUTONOMYMETADATA, for every document that is ingested. This section describes an “NT Style” ACL, which is used in conjunction with the  security ..."},"43":{y:0,u:"../Content/Tutorial/Security/Security_Groups.htm",l:-1,t:"Groups",i:0.00150856312668618,a:"ACLs are often expressed in terms of users and groups. To determine whether a user can access a document, the Content component must know which security groups a user belongs to.  The Community component requests this information from a group server such as OmniGroupServer. The group server can ..."},"44":{y:0,u:"../Content/Tutorial/Security/SynchronizeGroups.htm",l:-1,t:"SynchronizeGroups",i:0.000815439184433493,a:"As described in  Groups , it is sometimes necessary for a connector to provide group membership information to a group server. OmniGroupServer might be configured to store group information from a repository with the following settings: ..."},"45":{y:0,u:"../Content/Tutorial/ConnectorLib_Features.htm",l:-1,t:"Logging, Configuration, and Temporary Files",i:0.000535006340003021,a:"Logging, Configuration, and Temporary Files This section describes further useful features of ConnectorLib C++."},"46":{y:0,u:"../Content/Tutorial/Logging.htm",l:-1,t:"Write Messages to the Log",i:0.000535006340003021,a:"All of the fetch action methods you can override in ConnectorBase are passed a task object with a Log object accessible with task.log()        task.log().always(\"This message is always logged\");\n       task.log().critical(\"This is logged at the critical level\");\n       task.log().error(\"Errors are ..."},"47":{y:0,u:"../Content/Tutorial/ReadConfiguration.htm",l:-1,t:"Read Configuration Parameters",i:0.000535006340003021,a:"All of the fetch action methods you can override in ConnectorBase are passed a task object that has a taskConfig() that returns the configuration for the task. The task configuration returned by the methods of the TaskConfig object  can be different to what is specified in the configuration file. ..."},"48":{y:0,u:"../Content/Tutorial/CreateTempFiles.htm",l:-1,t:"Create Temporary Files",i:0.000535006340003021,a:"Your connector might need to create temporary files.  The task objects have a  tempDirectory() function  that provides the path of the directory to use for storing temporary files. The task object also provides a getTempFilename function to create a unique temporary file name:        std::string ..."},"49":{y:0,u:"../Content/Tutorial/ProgressReporting.htm",l:-1,t:"Progress Reporting",i:0.00068659159082506,a:"The synchronize action is typically used to retrieve all data from a repository. This could take seconds, hours, or even days to complete. You might therefore decide to give the user an indication of how much progress the connector has made and how much work there is left to do. This section ..."},"50":{y:0,u:"../Content/Tutorial/ProgressReporting_Intro.htm",l:-1,t:"Introduction",i:0.000762384216236079,a:"Progress information for a synchronize action can be retrieved using the following HTTP command, sent to the connector\u0027s ACI port: http://host:port/action=QueueInfo\u0026QueueName=Fetch\u0026QueueAction=Progress\u0026Token=token The  QueueInfo  action returns a report of the progress: \u003cautnresponse\u003e\n  ..."},"51":{y:0,u:"../Content/Tutorial/ProgressReporting_Basic.htm",l:-1,t:"Basic Progress",i:0.000762384216236079,a:"FetchTask has a function called taskStage() that allows you to report progress for the synchronize action. The following example demonstrates basic progress reporting:    task.taskStage().setMaximum(20);\n   for (int ii = 0; ii \u003c 20; ++ii)\n   {\n      // Do work\n      ..."},"52":{y:0,u:"../Content/Tutorial/ProgressReporting_Stages.htm",l:-1,t:"Progress with Stages",i:0.000535006340003021,a:"Instead of updating the progress of the task stage directly, you can split it into multiple child stages. This provides more detail in the  progress report . Add Stages Each stage is given a weight and a maximum value:    Stage stage1 = task.taskStage().addChild(\"Searching for new Documents\", 1, ..."},"53":{y:0,u:"../Content/Connector_Reference.htm",l:-1,t:"Connector Reference",i:0.000535006340003021,a:"Connector Reference This section describes the actions, configuration parameters, and Lua methods that you can use with any connector developed using the ConnectorLib C++ SDK."},"54":{y:0,u:"../Content/Actions/Actions.htm",l:-1,t:" Actions",i:0.000535006340003021,a:" Actions This section describes the actions that you can use with your connector. Introduction to Actions Connector Actions Fetch Actions"},"55":{y:0,u:"../Content/Actions/_ACI_Actions_Intro.htm",l:-1,t:"Introduction to Actions",i:0.00068659159082506,a:"Actions allow you to query an ACI server  and instruct it to perform a variety of operations. All actions must be sent to the server  Port . The configured authorization roles determine which users can send which actions to the port. See  Authorization Roles Configuration Parameters . The general ..."},"56":{y:0,u:"../Content/Actions/Synchronous_and_Asynchro.htm",l:-1,t:"Synchronous and Asynchronous Actions",i:0.000535006340003021,a:"Some actions are synchronous and others are asynchronous. A connector does not respond to a synchronous action until it has completed the request. The result of the action is in the response to the request. A connector responds to an asynchronous action immediately. The request is added to a queue ..."},"57":{y:0,u:"../Content/Actions/Connector/_CN_Actions_Connector.htm",l:-1,t:"Connector Actions",i:0.00068659159082506,a:"This section describes the actions that are supported by the connector. The connector also supports the Fetch action. For information about using the Fetch action, see  Fetch Actions . The sample HTTP requests in this section are split across multiple lines for readability. When you use these ..."},"58":{y:0,u:"../Content/Actions/General/_ACI_Admin.htm",l:-1,t:"Admin",i:0.000535006340003021,a:"Opens the Knowledge Discovery Admin interface. This interface allows you to view data for the component and provides some administrative actions. To use this action, you must have an admin.dat file available for the component. You can configure the location of this file by using the  AdminFile  ..."},"59":{y:0,u:"../Content/Actions/General/_ACI_BackupServer.htm",l:-1,t:"BackupServer",i:0.00130374914871262,a:"The BackupServer action creates a backup that can be used to restore the server\u0027s state. The backup includes: details of actions that have been queued, are running, and have finished. a copy of the configuration file. information about the files that the connector has retrieved. ConnectorLib C++ ..."},"60":{y:0,u:"../Content/Actions/Connector/_CN_GetUri.htm",l:-1,t:"GetUri",i:0.000535006340003021,a:"\n            This action accepts a document identifier and returns a URI to the document in the repository. /action=GetUri\u0026Identifier=...\n             [\u0026Redirect=true] Type: Synchronous Example http://connector:1234/action=GetUri\u0026Identifier=... Response An example response for this action appears ..."},"61":{y:0,u:"../Content/Actions/Connector/_CN_PauseSchedules.htm",l:-1,t:"PauseSchedules",i:0.00356663975161205,a:"Temporarily stops the connector starting scheduled tasks. Any tasks that are currently running are allowed to finish but the connector will not start tasks that are scheduled to start.  Type: Synchronous Example http://localhost:7002/action=PauseSchedules\u0026Sections=MyTask,AnotherTask Response ..."},"62":{y:0,u:"../Content/Actions/Connector/_CN_PurgeDatastore.htm",l:-1,t:"PurgeDatastore",i:0.000535006340003021,a:"This action instructs the connector to delete the datastore for a fetch task. If any synchronize actions are running, the connector waits for them to finish before deleting the datastore. You might want to delete the datastore for a fetch task if you have modified the task configuration and you need ..."},"63":{y:0,u:"../Content/Actions/General/_ACI_QueueInfo.htm",l:-1,t:"QueueInfo",i:0.0233517951749865,a:"The QueueInfo action provides information about the asynchronous actions that the ACI server has queued, is processing, or has finished. You can use the QueueInfo action to: pause and resume processing the queued actions cancel a queued action change the priority of a queued action retrieve the ..."},"64":{y:0,u:"../Content/Actions/General/_ACI_RestoreServer.htm",l:-1,t:"RestoreServer",i:0.00212784509191055,a:"The RestoreServer action restores a server’s state from a backup created by the BackupServer action. After using the RestoreServer action, you must restart the server. Type: Synchronous Example http://host:port/action=RestoreServer\u0026filename=./backups/filename.zip Response \u003cautnresponse ..."},"65":{y:0,u:"../Content/Actions/Connector/_CN_ResumeSchedules.htm",l:-1,t:"ResumeSchedules",i:0.00356663975161205,a:"Instructs the connector to resume starting scheduled tasks, for task schedules that have been paused by the action   PauseSchedules . Type: Synchronous Example http://localhost:7002/action=ResumeSchedules\u0026Sections=MyTask,AnotherTask Response \u003cautnresponse\u003e\n  \u003caction\u003eRESUMESCHEDULES\u003c/action\u003e\n  ..."},"66":{y:0,u:"../Content/Actions/Connector/_CN_StopFetch.htm",l:-1,t:"StopFetch",i:0.000535006340003021,a:"This action requests all active asynchronous Fetch actions or a particular asynchronous Fetch action to stop. http://host:port/action=StopFetch\n\t\t          [\u0026Token=Fetch_Action_Token] Type: Synchronous Example http://localhost:1234/action=StopFetch Response ..."},"67":{y:0,u:"../Content/Actions/Connector/_CN_TaskList.htm",l:-1,t:"TaskList",i:0.000535006340003021,a:"This action returns a list of the fetch tasks that are configured in the connector\u0027s configuration file, and fetch tasks that the connector ran as a result of receiving a fetch action with a configuration included in the config action parameter. The connector returns (if applicable): The name of the ..."},"68":{y:0,u:"../Content/Actions/Connector/_CN_View.htm",l:-1,t:"View",i:0.000535006340003021,a:"The View action retrieves a single document and returns it. Type: Synchronous Example http://localhost:(Undefined variable: ACIServer.ACIPort)/action=View\u0026Identifier=PGlkIHQ9IkZpbGUiIHM9Ik1ZVEFTSyIgcj0iQzpcSURPTFxmaWxlLnR4dCIvPg== Response The response is the binary content of the file, unless you ..."},"69":{y:0,u:"../Content/Actions/Fetch/_CN_Action_Fetch.htm",l:-1,t:"Fetch Actions",i:0.00127019493689961,a:"This section describes the fetch actions that are supported by the connector. All of the actions in this section are available through action=Fetch. The sample HTTP requests in this section are split across multiple lines for readability. When using these requests, the whole request must be on one ..."},"70":{y:0,u:"../Content/Actions/Fetch/_CN_Collect.htm",l:-1,t:"Collect",i:0.000535006340003021,a:"\n            This action retrieves documents from a repository and sends the documents to a specified location. You can save the documents to disk or add them to the ingest queue. You must specify the documents that you want to collect by their identifiers.\n        Type: Asynchronous Example ..."},"71":{y:0,u:"../Content/Actions/Fetch/_CN_DeleteRemove.htm",l:-1,t:"Delete/Remove",i:0.000535006340003021,a:"This action deletes documents from a repository by their identifiers. Remove and delete are different names for the same action. Type: Asynchronous Example http://localhost:1234/action=Fetch\u0026FetchAction=Delete\n                                  \u0026Identifiers=...  Response \n             As this is an ..."},"72":{y:0,u:"../Content/Actions/Fetch/_CN_Hold.htm",l:-1,t:"Hold",i:0.000535006340003021,a:"The Hold action places a hold on a document or documents in the repository. When a document has been placed on hold, it cannot be deleted or modified by a regular user. Specify the documents to hold by their identifiers. Type: Asynchronous Example http://localhost:1234/action=Fetch\u0026FetchAction=Hold\n ..."},"73":{y:0,u:"../Content/Actions/Fetch/Insert.htm",l:-1,t:"Insert",i:0.000535006340003021,a:"Inserts a document or documents into the data repository. Type: Asynchronous Example \n            This example shows how to use a File System Connector to insert a file with the reference C:\\Autonomy\\FileSystemConnectorCFS\\dir1\\newfile.txt and the content This is my file into a file system. \n        ..."},"74":{y:0,u:"../Content/Actions/Fetch/_CN_ReleaseHold.htm",l:-1,t:"ReleaseHold",i:0.000535006340003021,a:"The ReleaseHold action releases a document that has been placed on hold.\n         Documents are specified by their identifier.\n        Type: Asynchronous Example\n         http://localhost:1234/action=Fetch\u0026FetchAction=ReleaseHold\n                                  ..."},"75":{y:0,u:"../Content/Actions/Fetch/_CN_Stub.htm",l:-1,t:"Stub",i:0.000535006340003021,a:"\n            This action inserts a stub, a link to a document in another repository. An application might use a connector to insert a stub when a document is moved to another repository or is deleted. The stub can point to the new location, or in the case where the document has been deleted, explain ..."},"76":{y:0,u:"../Content/Actions/Fetch/_CN_Synchronize.htm",l:-1,t:"Synchronize",i:0.000535006340003021,a:"This action searches a repository for new, updated, and deleted documents, and sends the updates to an ingestion server. Type: Asynchronous Example http://host:port/action=Fetch\u0026FetchAction=Synchronize Response A sample response appears below. In this example, two tasks were performed as part of the ..."},"77":{y:0,u:"../Content/Actions/Fetch/_CN_SynchronizeGroups.htm",l:-1,t:"SynchronizeGroups",i:0.000535006340003021,a:"This action searches a repository for group updates and sends these updates to OmniGroupServer. Type: Asynchronous Example http://host:port/action=Fetch\u0026FetchAction=SynchronizeGroups Response A sample response appears below. In this example, two tasks were performed as part of the synchronize groups ..."},"78":{y:0,u:"../Content/Actions/Fetch/_CN_Update.htm",l:-1,t:"Update",i:0.000535006340003021,a:"The Update action updates the metadata of documents in a repository.\nDocuments are specified by their identifier.           /action=fetch\u0026fetchaction=Update\n\t\t      [\u0026config=\u003cBase64_Config\u003e]\n\t\t       \u0026identifiersXML=\u003cIdentifiers_XML\u003e\n\t\t      [\u0026\u003cOverride_Config_Parameters\u003e]\n Type: Asynchronous ..."},"79":{y:0,u:"../Content/Configuration/ConfigParameters.htm",l:-1,t:"Configuration Parameters",i:0.000535006340003021,a:"Configuration Parameters This section describes the configuration parameters that you can use with your connector."},"80":{y:0,u:"../Content/Configuration/_ACI_Config_Intro.htm",l:-1,t:"Introduction to Configuration",i:0.000535006340003021,a:"Configuration parameters are set in the  configuration file. When setting configuration parameter values, you must use UTF-8. This section describes how to enter parameter values in the configuration file. Enter Boolean Values The following settings for Boolean parameters are interchangeable: TRUE = ..."},"81":{y:0,u:"../Content/Configuration/Actions/_ACI_params_actions.htm",l:-1,t:"Actions Configuration Parameters",i:0.000535006340003021,a:"The parameters in the [Actions] section control how the server handles incoming ACI requests, and are used to set up event handlers. AsyncStoreLibraryDirectory AsyncStoreLibraryName ConnectionString DatastoreSharingGroupName DeleteProcessingRequestsWhenServerStarts ..."},"82":{y:0,u:"../Content/Configuration/Actions/_ACI_AsyncStoreLibraryDirectory.htm",l:-1,t:"AsyncStoreLibraryDirectory",i:0.00514479627654691,a:" To store asynchronous action queues in a database, rather than in an internal datastore file, set the parameters AsyncStoreLibraryDirectory, AsyncStoreLibraryName, and ConnectionString. If you use the same database to store action queues for more than one type of component, you must also set ..."},"83":{y:0,u:"../Content/Configuration/Actions/_ACI_AsyncStoreLibraryName.htm",l:-1,t:"AsyncStoreLibraryName",i:0.00514479627654691,a:" To store asynchronous action queues in a database, rather than in an internal datastore file, set the parameters AsyncStoreLibraryDirectory, AsyncStoreLibraryName, and ConnectionString. If you use the same database to store action queues for more than one type of component, you must also set ..."},"84":{y:0,u:"../Content/Configuration/Actions/_ACI_ConnectionString.htm",l:-1,t:"ConnectionString",i:0.00514479627654691,a:" To store asynchronous action queues in a database, rather than in an internal datastore file, set the parameters AsyncStoreLibraryDirectory, AsyncStoreLibraryName, and ConnectionString. If you use the same database to store action queues for more than one type of component, you must also set ..."},"85":{y:0,u:"../Content/Configuration/Actions/_ACI_DatastoreSharingGroupName.htm",l:-1,t:"DatastoreSharingGroupName",i:0.00492972243521547,a:"To store asynchronous action queues in a database, rather than in an internal datastore file, set the parameters AsyncStoreLibraryDirectory, AsyncStoreLibraryName, and ConnectionString. To use the same database to store action queues for more than one type of Knowledge Discovery component, you must ..."},"86":{y:0,u:"../Content/Configuration/Actions/_ACI_DeleteProcessingRequestsWhenServerStarts.htm",l:-1,t:"DeleteProcessingRequestsWhenServerStarts",i:0.00371100324740296,a:"Specifies whether to remove requests that have a status of processing from the action queue when the server starts. In most cases OpenText recommends that you use the default value, so that when the server starts it continues to process unfinished requests. However, if a request causes the server to ..."},"87":{y:0,u:"../Content/Configuration/Actions/_ACI_DeleteQueuedRequestsWhenServerStarts.htm",l:-1,t:"DeleteQueuedRequestsWhenServerStarts",i:0.00371100324740296,a:"Specifies whether to remove requests that have a status of queued from the action queue when the server starts. The action queue can contain queued requests if the server was stopped before it could process all of the requests in the queue. In most cases OpenText recommends that you use the default ..."},"88":{y:0,u:"../Content/Configuration/Actions/_ACI_InMemoryDatastoreBackupIntervalMins.htm",l:-1,t:"InMemoryDatastoreBackupIntervalMins",i:0.00407352088085279,a:"The time interval (in minutes) after which action queues stored in memory are written to disk. This parameter applies only when  UseInMemoryDatastore  is TRUE. Writing the queues to disk can reduce the number of actions that would be lost if ConnectorLib C++ stops unexpectedly, but configuring ..."},"89":{y:0,u:"../Content/Configuration/Actions/_ACI_LibraryName.htm",l:-1,t:"LibraryName",i:0.00517962128212772,a:"The LibraryName parameter specifies the name of the library to use as the event handler. Specifying the .dll or .so extension is optional.  To use the internal text file handler, set this parameter to TextFileHandler, and set the FilePath parameter. To run a Lua script, set this parameter to ..."},"90":{y:0,u:"../Content/Configuration/Actions/_ACI_MaxDatastoreConnections.htm",l:-1,t:"MaxDatastoreConnections",i:0.000556661375834741,a:" The maximum number of connections to open to the database that stores asynchronous action queues. In most cases the default value of one connection is sufficient. Increasing the number of connections allows more threads to communicate with the database concurrently. This can improve performance but ..."},"91":{y:0,u:"../Content/Configuration/Actions/_ACI_MaxFinishedSize.htm",l:-1,t:"MaxFinishedSize",i:0.00371100324740296,a:"The MaxFinishedSize parameter specifies the maximum number of Finished + Error tasks to store. When the MaxFinishedSize is reached, the oldest Finished or Error action is disposed of and so is no longer accessible through the QueueInfo action. Queued, Processing, Finished, and Error are the action ..."},"92":{y:0,u:"../Content/Configuration/Actions/_ACI_MaximumThreads.htm",l:-1,t:"MaximumThreads",i:0.00101141712830086,a:"The MaximumThreads parameter specifies the maximum number of asynchronous ACI actions to process simultaneously. If you set this parameter only in the [Actions] section of the configuration file, the server simultaneously runs the specified number of actions from each asynchronous queue. You can ..."},"93":{y:0,u:"../Content/Configuration/Actions/_ACI_MaxQueueSize.htm",l:-1,t:"MaxQueueSize",i:0.00371100324740296,a:"The MaxQueueSize parameter specifies the maximum number of asynchronous actions that are queued by the server. When the maximum number is reached, no further actions are accepted until the queue has diminished. If you set this parameter only in the [Actions] section of the configuration file, the ..."},"94":{y:0,u:"../Content/Configuration/Actions/_ACI_OnError.htm",l:-1,t:"OnError",i:0.00342808131762684,a:"The OnError parameter specifies the name of a handler for the error event of an asynchronous action. The OnError event is called if an asynchronous action fails and cannot continue. The name that you specify must represent a section in the configuration file that contains the  LibraryName  parameter ..."},"95":{y:0,u:"../Content/Configuration/Actions/_ACI_OnFinish.htm",l:-1,t:"OnFinish",i:0.00308727551262079,a:"The OnFinish parameter specifies the name of a handler for the finish event of an asynchronous action. The name that you specify must represent a section in the configuration file that contains the settings for the event handler. For example: [ActionName]\nOnFinish=MyHandler\n\n[MyHandler]\n...\n"},"96":{y:0,u:"../Content/Configuration/Actions/_ACI_OnQueueEvent.htm",l:-1,t:"OnQueueEvent",i:0.00174499265848497,a:"ConnectorLib C++ generates an event when an asynchronous action queue becomes full, becomes empty, or the queue size passes certain thresholds. The OnQueueEvent parameter specifies the name of the handler to use to handle these events. A QueueFull event occurs when the action queue becomes full. A ..."},"97":{y:0,u:"../Content/Configuration/Actions/_ACI_OnStart.htm",l:-1,t:"OnStart",i:0.00308727551262079,a:"OnStart The OnStart parameter specifies the name of a handler for the start event of an asynchronous action. The name that you specify must represent a section in the configuration file that contains the settings for the event handler. For example: [ActionName]\nOnStart=MyHandler\n\n[MyHandler]\n...\n"},"98":{y:0,u:"../Content/Configuration/Actions/_ACI_Path.htm",l:-1,t:"Path",i:0.000556661375834741,a:"Path The directory in which to store information about asynchronous ACI actions. "},"99":{y:0,u:"../Content/Configuration/Actions/_ACI_QueueEmptyingThreshold.htm",l:-1,t:"QueueEmptyingThreshold",i:0.00139803470022888,a:"ConnectorLib C++ generates an event when an asynchronous action queue becomes full, becomes empty, or the queue size passes certain thresholds. This parameter specifies the threshold at which a QueueEmptying event is triggered. When the number of actions in a queue falls below this proportion of the ..."},"100":{y:0,u:"../Content/Configuration/Actions/_ACI_QueueFillingThreshold.htm",l:-1,t:"QueueFillingThreshold",i:0.00139803470022888,a:"ConnectorLib C++ generates an event when an asynchronous action queue becomes full, becomes empty, or the queue size passes certain thresholds. This parameter specifies the threshold at which a QueueFilling event is triggered. When the number of actions in a queue exceeds this proportion of the ..."},"101":{y:0,u:"../Content/Configuration/Actions/_ACI_UseInMemoryDatastore.htm",l:-1,t:"UseInMemoryDatastore",i:0.00413707108184517,a:"A Boolean value that specifies whether to keep the queues for asynchronous actions in memory. Storing action queues in memory can improve performance but means that the queues (including queued actions and the results of finished actions) are lost if ConnectorLib C++ stops unexpectedly, for example ..."},"102":{y:0,u:"../Content/Configuration/Actions/_ACI_UseStringentDatastore.htm",l:-1,t:"UseStringentDatastore",i:0.000556661375834741,a:"The datastore that holds the action queues for ConnectorLib C++ is resistant to corruption when a system failure (such as a loss of power) occurs. To increase the speed at which the datastore responds to queries from ConnectorLib C++, you can set UseStringentDatastore=False, however the datastore ..."},"103":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_HTTP_Event_Handler_Config.htm",l:-1,t:"HTTP Event Handler Configuration",i:0.000535006340003021,a:"HTTP Event Handler Configuration The parameters in this section specify settings for the HTTP event handler. These settings are used if LibraryName=HttpHandler."},"104":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_BasicPassword.htm",l:-1,t:"BasicPassword",i:0.00356663975161205,a:"BasicPassword The BasicPassword parameter specifies the password to use to access the URL where event data is sent (when using basic authentication). This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"105":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_BasicUser.htm",l:-1,t:"BasicUser",i:0.00356663975161205,a:"BasicUser The BasicUser parameter specifies the user name to use to access the URL where event data is sent (when using basic authentication). This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"106":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_NTLMPassword.htm",l:-1,t:"NTLMPassword",i:0.00356663975161205,a:"NTLMPassword The NTLMPassword parameter specifies the password to use to access the URL where event data is sent (when using NTLM or NTLMv2 authentication). This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"107":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_NTLMUser.htm",l:-1,t:"NTLMUser",i:0.00356663975161205,a:"NTLMUser The NTLMUser parameter specifies the user name to use to access the URL where event data is sent (when using NTLM or NTLMv2 authentication). This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"108":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_ProxyHost.htm",l:-1,t:"ProxyHost",i:0.0015495325540417,a:"ProxyHost The ProxyHost parameter specifies the host name or IP address of a proxy server to use to send event data. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"109":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_ProxyPassword.htm",l:-1,t:"ProxyPassword",i:0.0055837469491824,a:"ProxyPassword The ProxyPassword parameter specifies a password for the proxy server. You can set this parameter if you need to send event data through a proxy server. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"110":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_ProxyPort.htm",l:-1,t:"ProxyPort",i:0.00119355861591006,a:"ProxyPort The ProxyPort parameter specifies the port of a proxy server to use to send event data. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"111":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_ProxyUser.htm",l:-1,t:"ProxyUsername",i:0.00593972088731404,a:"ProxyUsername The ProxyUsername parameter specifies a user name for the proxy server. You can set this parameter if you need to send event data through a proxy server. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"112":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_Retries.htm",l:-1,t:"Retries",i:0.00356663975161205,a:"Retries The Retries parameter specifies the number of times that the connector should attempt to connect to the URL where event data is sent, if the initial connection fails. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"113":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_RetryInterval.htm",l:-1,t:"RetryInterval",i:0.00356663975161205,a:"RetryInterval The RetryInterval parameter specifies the amount of time (in seconds) between attempts to connect to the URL. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"114":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_SSLConfig.htm",l:-1,t:"SSLConfig",i:0.000535006340003021,a:"SSLConfig The SSLConfig parameter specifies the name of a section in the configuration file that contains SSL settings for communication with the URL. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"115":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_URL.htm",l:-1,t:"URL",i:0.0024573447099315,a:"The URL parameter specifies the URL to receive event data. You can send event data to the application that initiated the action, so that the application receives the result of the action, or is notified if the action fails to complete successfully. This parameter is used only when you are using the ..."},"116":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_UseNTLMAuthentication.htm",l:-1,t:"UseNTLMAuthentication",i:0.00356663975161205,a:"UseNTLMAuthentication The UseNTLMAuthentication parameter specifies whether the event handler uses NTLM authentication to connect to the URL. This parameter is used only when you are using the HTTP handler (LibraryName=HttpHandler)."},"117":{y:0,u:"../Content/Configuration/Actions/HTTPEventHandler/_ACI_UseNTLMv2.htm",l:-1,t:"UseNTLMv2",i:0.00356663975161205,a:"The UseNTLMv2 parameter specifies whether the event handler uses NTLMv2 authentication to connect to the URL. To use NTLMv2 authentication, you must also set the  UseNTLMAuthentication  parameter, for example: UseNTLMAuthentication=True\nUseNTLMv2=True This parameter is used only when you are using ..."},"118":{y:0,u:"../Content/Configuration/Actions/LuaEventHandler/_ACI_Lua_Event_Handler_Config.htm",l:-1,t:"Lua Event Handler Configuration",i:0.000535006340003021,a:"Lua Event Handler Configuration The parameters in this section specify settings for the Lua event handler. These settings are used if LibraryName=LuaHandler."},"119":{y:0,u:"../Content/Configuration/Actions/LuaEventHandler/_ACI_LuaScript.htm",l:-1,t:"LuaScript",i:0.00200258895746538,a:"The LuaScript parameter specifies a Lua script to run when an event occurs. This parameter is used only when you are using the Lua handler (LibraryName=LuaHandler) Lua script event handlers have the form: function handler(request, xml)\n\t...\nend request is a table holding the request parameters. xml ..."},"120":{y:0,u:"../Content/Configuration/Actions/TextEventHandler/_ACI_Text_File_Event_Handler.htm",l:-1,t:"Text File Event Handler Configuration",i:0.000535006340003021,a:"Text File Event Handler Configuration The parameters in this section specify settings for the Text File event handler. These settings are used if LibraryName=TextFileHandler."},"121":{y:0,u:"../Content/Configuration/Actions/TextEventHandler/_ACI_FilePath.htm",l:-1,t:"FilePath",i:0.00200258895746538,a:"FilePath The FilePath parameter specifies the location of the file to receive event data. This parameter is used only when you are using the text file handler (LibraryName=TextFileHandler)."},"122":{y:0,u:"../Content/Configuration/AuthorizationRoles/_ACI_Config_AuthorizationRoles.htm",l:-1,t:"Authorization Roles Configuration Parameters",i:0.00420820428929475,a:"The [AuthorizationRoles] section contains definitions for roles that enable particular sets of actions for particular clients, SSL identities, and GSS principals. You must create a  subsection for each authorization role that you define in the [AuthorizationRoles] configuration section.  You define ..."},"123":{y:0,u:"../Content/Configuration/AuthorizationRoles/_ACI_N.htm",l:-1,t:"N",i:0.000535006340003021,a:"The names of the authorization role configuration sections. For the name of this configuration parameter, replace  N with the zero-based rank number of the specified authorization role. For the parameter value, type the name of the authorization role configuration section. You must number the ..."},"124":{y:0,u:"../Content/Configuration/AuthorizationRoles/_ACI_Config_MyAuthorizationRole.htm",l:-1,t:"My Authorization Role Configuration Parameters",i:0.000535006340003021,a:"The individual authorization role sections contain settings that define the authorization role.  You must create a  subsection for each authorization role that you define in the [AuthorizationRoles] configuration section.  You define the permissions that a particular role has by using  StandardRoles ..."},"125":{y:0,u:"../Content/Configuration/AuthorizationRoles/_ACI_Actions.htm",l:-1,t:"Actions",i:0.000625957490496244,a:"A comma-separated list of ACI actions that you want to enable for this role configuration.  If a user connection matches one of the allowed clients, principals, or SSL identities, they have permission to perform the specified actions, regardless of whether they also have the appropriate standard ..."},"126":{y:0,u:"../Content/Configuration/AuthorizationRoles/_ACI_Clients.htm",l:-1,t:"Clients",i:0.00219170879343797,a:"A comma-separated list of IP addresses (or host names) of clients that have authorization for the functions included in this role. There must be no space before or after a comma. You can use wildcards in an IP address, but not in a host name. For example, 187.*.*.* includes any machine with an ..."},"127":{y:0,u:"../Content/Configuration/AuthorizationRoles/_ACI_GSSPrincipals.htm",l:-1,t:"GSSPrincipals",i:0.00312318660584873,a:"A comma-separated list of Kerberos GSS principals that have authorization for the functions included in this role. You can include Wildcard values in the GSS principal names.  The Kerberos principal name consists of: The Kerberos primary. This value might be the user name or service name (for ..."},});