/****************************************************************************
 |
 |	(C) Copyright 2001, 2009-2010, 2014  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: gpachner $
 | $Date: 2005-05-13 22:23:28 +0530 (Fri, 13 May 2005) $
 |
 | $RCSfile$
 | $Revision: 980 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		NSS Library source
 +-------------------------------------------------------------------------*/
#ifndef _AUDITEVENT_H_
#define _AUDITEVENT_H_

#ifndef _ZPARAMS_H_
#	include <zParams.h>
#endif

#include <zOmni.h>

#ifdef __cplusplus
extern "C" {
#endif

/**** Audit Event system defines and structures       */

#define AUDIT_Event_Delete              0 
#define AUDIT_Event_Create              1 
#define AUDIT_Event_Open                2
#define AUDIT_Event_Close               3 
#define AUDIT_Event_Rename              4 
#define AUDIT_Event_Link                5 
#define AUDIT_Event_ModifyInfo          6 
#define AUDIT_Event_AddTrustee          7 
#define AUDIT_Event_RemoveTrustee       8 
#define AUDIT_Event_SetInheritedRights  9 

#define AUDIT_MAX_NSS_EVENTS            10

#define AUDIT_API_VERSION_1             1
#define AUDIT_API_VERSION_2             2
#define AUDIT_CURRENT_API_VERSION       2

#define AUDITMSG_MAX_VARIABLE_DATA      (2 * zMAX_COMPONENT_NAME * sizeof(unicode_t))

typedef struct AuditTimeInfo_s
{
	Time_t accessedTime;            /* Last time file was accessed*/
    Time_t createdTime;             /* Time file was created */
    Time_t modifiedTime;            /* Last time data was changed */
    Time_t metaDataModifiedTime;    /* Last time metadata was changed. */	
} AuditTimeInfo_s;



typedef struct AuditDelete_s
{
	NINT		eventType;
	NINT 		taskID;
	Zid_t		zid;
	Zid_t		parentZid;
	unicode_t 	*name;
	NINT 		fileType;
	NINT 		fileNameType;
	QUAD 		fileAttributes;
	VolumeID_t	volID;
	zNW_user_s 	userID;
	BYTE		*blob;	
	NINT		blobLength;
	STATUS 		opRetCode;
	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditDelete_s;

typedef struct AuditCreate_s
{
	NINT		eventType;
	NINT 		taskID;
	Zid_t		parentZid;
	unicode_t 	*name;
	VolumeID_t	volID;
	zNW_user_s	userID;

	NINT 		fileType;
	QUAD 		fileAttributes;
	NINT 		createFlags;
	NINT 		requestedRights;
	NINT 		createAndOpen;

	STATUS 		opRetCode;
	NINT 		retOpenCreateAction;
	Key_t 		retKey;
	Zid_t		retZid;
	VolumeID_t	retVolID;
	AuditTimeInfo_s 	times;
	BYTE		*blob;	
	NINT		blobLength;

	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditCreate_s;


typedef struct AuditOpen_s
{
	NINT		eventType;
	NINT 		taskID;
	Zid_t		zid;
	Zid_t		parentZid;
	unicode_t 	*name;
	NINT 		fileType;
	QUAD 		fileAttributes;
	VolumeID_t	volID;
	zNW_user_s	userID;

	NINT 		requestedRights;

	STATUS 		opRetCode;
	Key_t 		retKey;
	Zid_t		retZid;
	VolumeID_t	retVolID;
	AuditTimeInfo_s 	times;
	BYTE		*blob;	
	NINT		blobLength;

	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditOpen_s;

typedef struct AuditClose_s
{
	NINT		eventType;
	NINT 		taskID;
	Zid_t		zid;
	Zid_t		parentZid;
	unicode_t 	*name;
	NINT 		fileType;
	QUAD 		fileAttributes;
	VolumeID_t	volID;
	zNW_user_s	userID;

	Key_t 		key;
	NINT 		fhState;
	AuditTimeInfo_s 	times;

	STATUS 		opRetCode;
	NINT 		fileDeleted;
	BYTE		*blob;	
	NINT		blobLength;

	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditClose_s;

typedef struct AuditRename_s
{
	NINT		eventType;
	zNW_user_s 	userID;
	NINT 		taskID;
	Zid_t		srcZid;
	Zid_t		srcParentZid;
	VolumeID_t	volID;
	unicode_t 	*srcName;
	NINT 		fileType;
	NINT 		fileNameType;
	QUAD 		fileAttributes;
	Zid_t		dstParentZid;
	unicode_t 	*dstName;
	NINT 		renameFlags;
	BYTE		*blob;	
	NINT		blobLength;

	STATUS 		opRetCode;
	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditRename_s;

typedef struct AuditModifyInfo_s
{
	NINT		eventType;
	NINT 		taskID;
	Zid_t		zid;
	Zid_t		parentZid;
	unicode_t 	*name;
	NINT 		fileType;
	QUAD 		fileAttributes;
	VolumeID_t	volID;
	zNW_user_s	userID;

	NINT 		modifyInfoMask;
	NINT 		modifyTypeInfoMask;
	zInfoE_s 	*modifyInfo;
	void 		*modifyTypeInfo;
	BYTE		*blob;	
	NINT		blobLength;

	STATUS 		opRetCode;
	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditModifyInfo_s;

typedef struct AuditLink_s
{
	NINT		eventType;
	zNW_user_s	userID;
	NINT 		taskID;
	Zid_t		srcZid;
	Zid_t		srcParentZid;
	VolumeID_t	volID;
	unicode_t 	*srcName;
	NINT 		fileType;
	QUAD 		fileAttributes;
	Zid_t		dstParentZid;
	unicode_t 	*dstName;
	NINT 		linkFlags;
	BYTE		*blob;	
	NINT		blobLength;

	STATUS 		opRetCode;
	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditLink_s;

typedef struct AuditAddTrustee_s
{
	NINT		eventType;
	zNW_user_s 	userID;
	NINT 		taskID;
	Zid_t		zid;
	Zid_t		parentZid;
	unicode_t 	*name;
	NINT 		fileType;
	QUAD 		fileAttributes;
	VolumeID_t	volID;

	//UserID_t 	trusteeID;
	zNW_user_s	trusteeID;
	NINT 		rights;
	NINT 		attributes;
	NINT 		previousRights;
	BYTE		*blob;	
	NINT		blobLength;

	STATUS 		opRetCode;
	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditAddTrustee_s;

typedef struct AuditRemoveTrustee_s
{
	NINT 		eventType;
	zNW_user_s 	userID;
	NINT 		taskID;
	Zid_t		zid;
	Zid_t		parentZid;
	unicode_t 	*name;
	NINT 		fileType;
	QUAD 		fileAttributes;
	VolumeID_t	volID;

	//UserID_t 	trusteeID;
	zNW_user_s	trusteeID;
	NINT 		rights;
	NINT 		purgedFileFlag;
	BYTE		*blob;	
	NINT		blobLength;

	STATUS 		opRetCode;
	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditRemoveTrustee_s;

typedef struct AuditSetInheritedRights_s
{
	NINT 		eventType;
	zNW_user_s 	userID;
	NINT 		taskID;
	Zid_t		zid;
	Zid_t		parentZid;
	unicode_t 	*name;
	NINT 		fileType;
	QUAD 		fileAttributes;
	VolumeID_t	volID;

	NINT 		inheritedRights;
	BOOL 		authorizeFlag;
	NINT 		previousInheritedRights;
	BYTE		*blob;	
	NINT		blobLength;

	STATUS 		opRetCode;
	BYTE		variableData[AUDITMSG_MAX_VARIABLE_DATA];
} AuditSetInheritedRights_s;

typedef struct AuditEventOps_s
{
	STATUS (*Delete)(AuditDelete_s *);
	STATUS (*Create)(AuditCreate_s *);
	STATUS (*Open)(AuditOpen_s *);
	STATUS (*Close)(AuditClose_s *);
	STATUS (*Rename)(AuditRename_s *);
	STATUS (*Link)(AuditLink_s *);
	STATUS (*Modifyinfo)(AuditModifyInfo_s *);
	STATUS (*AddTrustee)(AuditAddTrustee_s *);
	STATUS (*RemoveTrustee)(AuditRemoveTrustee_s *);
	STATUS (*SetInheritedRights)(AuditSetInheritedRights_s *);

} AuditEventOps_s;

typedef struct AuditRegistrationBlock
{
	NINT version;
	NINT numCallbacks;
	AuditEventOps_s callbacks;
} AuditRegistrationBlock;

typedef struct AuditRegisterEventBlock
{
	NINT version;
	NINT eventType;
	statusfunc_t callBack;
} AuditRegisterEventBlock;

typedef struct AuditUnregisterEventBlock
{
	NINT version;
	NINT eventType;
} AuditUnregisterEventBlock;


STATUS AUDIT_RegisterService( 
			AuditRegistrationBlock *auditBlock);

STATUS AUDIT_UnregisterService(void); 

STATUS AUDIT_RegisterEvent(
			AuditRegisterEventBlock *auditBlock);

STATUS AUDIT_UnregisterEvent(
			AuditUnregisterEventBlock *auditBlock);

#ifdef __cplusplus
}
#endif

#endif
