/***************************************************************************
 |
 |	(C) Copyright 2001 Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	Novell Distributed File Services (DFS) public GUID definitions
 |
 |--------------------------------------------------------------------------
 |
 | $Author: taysom $
 | $Date: 2004-12-31 01:10:58 +0530 (Fri, 31 Dec 2004) $
 |
 | $RCSfile$
 | $Revision: 465 $
 |
 |--------------------------------------------------------------------------
 |	This module is used to:
 |	Define well-known GUID values used in Novell Distributed File Services
 +------------------------------------------------------------------------*/

#ifndef _DFSGUIDS_H_
#define _DFSGUIDS_H_

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************************************
 * Note: Values defined in this file are intended to be used as
 * initializers for variables of type GUID_t defined in the file <zOmni.h>
 ***************************************************************************/

/* GUID for the Volume Location Database Service: */
#define DFS_GUID_VLDB			{0x80BE8C84, 0x50DC, 0x11D3, 0xAB, 0x6E, {0x00, 0x08, 0xC7, 0xD3, 0xAF, 0x2D}}

/* GUID for the Volume Location Service Remote Procedure Call module: */
#define DFS_GUID_VLRPC			{0x80BE8C85, 0x50DC, 0x11D3, 0xAB, 0x6E, {0x00, 0x08, 0xC7, 0xD3, 0xAF, 0x2D}}

/* GUID for the VLDB VDQAD back-end replication module: */
#define DFS_GUID_VDQAD_REPL		{0x80BE8C86, 0x50DC, 0x11D3, 0xAB, 0x6E, {0x00, 0x08, 0xC7, 0xD3, 0xAF, 0x2D}}

/* GUID for the VLDB Repair module: */
#define DFS_GUID_VLDB_REPAIR	{0x80BE8C87, 0x50DC, 0x11D3, 0xAB, 0x6E, {0x00, 0x08, 0xC7, 0xD3, 0xAF, 0x2D}}

/* GUID for the Volume Manager Service: */
#define DFS_GUID_VOLMAN			{0x80BE8C88, 0x50DC, 0x11D3, 0xAB, 0x6E, {0x00, 0x08, 0xC7, 0xD3, 0xAF, 0x2D}}

/* GUID for the Volume Manager Remote Procedure Call module: */
#define DFS_GUID_VMRPC			{0x8B4534B8, 0x7F5B, 0x01D4, 0x80, 0x01, {0x00, 0xC0, 0x4F, 0xA3, 0x35, 0XE0}}

#ifdef __cplusplus
}
#endif

#endif /* _DFSGUIDS_H_ */
