/****************************************************************************
 |
 |	(C) Copyright 2001, 2004-2012, 2014-2015  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Advance File Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: kpraveen $
 | $Date: 2015-02-05 05:24:24 +0530 (Thu, 05 Feb 2015) $
 |
 | $RCSfile$
 | $Revision: 5389 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		define the tags to be used for the XML management
 +-------------------------------------------------------------------------*/
#ifndef _XMLTAGS_H_
#define _XMLTAGS_H_


#define CDATA_START		"<![CDATA["
#define CDATA_END		"]]>"

#define	TAG_ABORT							"abort"
#define TAG_ACCESSCONTROL					"accessControl"
#define TAG_ACCESSEDTIME					"accessedTime"
#define TAG_ACCESSEDDOSTIME					"accessedDOSTime"
#define TAG_ACCESSRIGHTS					"accessRights"
#define TAG_ACTION							"action"
#define TAG_ACTIVATE						"activate"
#define TAG_ACTIVATEPOOLSNAPSHOT			"activatePoolSnapshot"
#define TAG_ACTIVATETIME					"activateTime"
#define TAG_ACTIVEEPOCHS					"activeEpochs"
#define TAG_ADAPTER							"adapter"
#define TAG_ADAPTERCARDTARGETID				"adapterCardTargetID"
#define TAG_ADAPTERDMACHANNEL				"adapterDMAChannel"
#define TAG_ADAPTERDMAINFO					"adapterDMAInfo"
#define TAG_ADAPTERDRIVERID					"adapterDriverID"
#define TAG_ADAPTERDRIVERNAME				"adapterDriverName"
#define TAG_ADAPTERFLAGS					"adapterFlags"
#define TAG_ADAPTERID						"adapterID"
#define TAG_ADAPTERINFO						"adapterInfo"
#define TAG_ADAPTERINTERRUPT				"adapterInterrupt"
#define TAG_ADAPTERINTERRUPTINFO			"adapterInterruptInfo"
#define TAG_ADAPTERMEMORYINFO				"adapterMemoryInfo"
#define TAG_ADAPTERMEMORYPHYADDRESS			"adapterMemoryPhysicalAddress"
#define TAG_ADAPTERMEMORYPHYLENGTH			"adapterMemoryPhysicalLength"
#define TAG_ADAPTERMEMORYVIRTADDRESS   		"adapterMemoryVirtualAddress"
#define TAG_ADAPTERNUMBER					"adapterNumber"
#define TAG_ADAPTERSLOT						"adapterSlot"
#define TAG_ADAPTERSUBSYSTEMID				"adapterSubSystemID"
#define TAG_ADAPTERSUPPORTEDTARGETIDS		"adapterSupportedTargetIDs"
#define TAG_ADAPTERSUPPORTEDUNITNUMBERS		"adapterSupportedUnitNumbers"
#define TAG_ADAPTERTYPE						"adapterType"
#define TAG_ADDCOMPLOG						"addCompLog"
#define TAG_ADDCONTEXT						"addContext"
#define TAG_ADDDOMAINACL					"addDomainACL"
#define TAG_ADDPARTITION					"addPartition"
#define TAG_ADDPARTITION2					"addPartition2"
#define TAG_ADDPARTITIONTOMIRROR			"addPartitionToMirror"
#define TAG_ADDPOOL							"addPool"
#define TAG_ADDPOOLDEVICEINFO				"addPoolDeviceInfo"
#define TAG_ADDPOOLSIMPLE					"addPool2"
#define TAG_ADDPOOLSNAPSHOT					"addPoolSnapshot"
#define TAG_ADDQUOTA						"addQuota"
#define TAG_ADDSHARE						"addShare"
#define TAG_ADENABLED						"ADEnabled"
#define TAG_ALLOW							"allow"
#define TAG_ALLOWALL						"allowAll"
#define TAG_ALLUSERS						"allUsers"
#define TAG_BITARRAY						"bitArray"
#define TAG_ADDRAID							"addRAID"
#define TAG_ADDRAIDSIMPLE					"addRAID2"
#define TAG_ADDS							"adds"
#define TAG_ADDTRADITIONALVOLUME			"addTraditionalVolume"
#define TAG_ADDTRUSTEE						"addTrustee"
#define TAG_ADDUSER							"addUser"
#define TAG_ADDVOLUME						"addVolume"
#define TAG_ADDVOLUMETOVLDB					"addVolumeToVLDB"
#define TAG_ADID						"adID"			// Any change in ADID tag needs change in AD TAG defined
											// in metamig.c, rights.c and quota.c
#define TAG_ADENABLEDMEDIA					"adEnabledMedia"
#define TAG_ADMINLINK						"adminLink"
#define TAG_ADUSER						"adUser"
#define TAG_ADVERTISINGPROTOCOLS			"advertisingProtocols"
#define TAG_AFP								"afp"
#define TAG_ALGOID							"algoID"
#define TAG_ALGOVERSION						"algoVersion"
#define TAG_ALIGNMENT						"alignment"
#define TAG_ALL								"all"
#define TAG_ALLACCESSRIGHTS					"allAccessRights"
#define TAG_ALLOCATEDPACKETS				"allocatedPackets"
#define TAG_ALLOCATEDSIZE					"allocatedSize"
#define TAG_ALLPATHS						"allPaths"
#define TAG_ARCHIVE							"archive"
#define TAG_ARCHIVEDTIME					"archivedTime"
#define TAG_ARCHIVEDDOSTIME					"archivedDOSTime"
#define TAG_ARCHIVER						"archiver"
#define TAG_ARCHIVERID						"archiverID"
#define TAG_ATTACHIPADDRESSES				"attachIPAddresses"
#define TAG_ATTRARCHIVE						"attrArchive"
#define TAG_ATTRIBUTEINFO					"attributeInfo"
#define TAG_ATTRIBUTENAME					"attributeName"
#define TAG_ATTRIBUTES						"attributes"
#define TAG_AUTHENTICATION					"authentication"
#define TAG_AUTHERRORS						"authErrors"
#define TAG_AUTHMODE						"authMode"
#define TAG_AUTHORIZATIONCACHE				"authorizationCache"
#define TAG_AUTHORIZATIONCACHESIZE			"authorizationCacheSize"
#define TAG_AUTHORIZATIONMODEL				"authorizationModel"
#define TAG_AUTHORIZENW						"authorizeNW"
#define TAG_AUTOLOADVLDB					"autoLoadVLDB"
#define TAG_AVAILABLESIZE					"availableSize"
#define TAG_AVECOMPRATIO					"aveCompRatio"
#define TAG_AVECOPYTIME						"aveCopyTime"
#define TAG_AVEDELETETIME					"aveDeleteTime"
#define TAG_AVEFLUSHTIME					"aveFlushTime"
#define TAG_AVEGETMCTIME					"aveGetMCTime"
#define TAG_AVEMOVETIME						"aveMoveTime"
#define TAG_AVEQUEUEDTIME					"aveQueuedTime"
#define TAG_AVERENAMETIME					"aveRenameTime"
#define TAG_AVESPLITTIME					"aveSplitTime"
#define TAG_BACKENDDB						"backEndDB"
#define TAG_BACKENDDATABASEPATH				"backEndDatabasePath"
#define TAG_BACKENDVERSION					"backEndVersion"
#define TAG_BACKGROUND						"background"
#define TAG_BACKUP							"backup"
#define TAG_BASICINFO						"basicInfo"
#define TAG_BEAST							"beast"
#define TAG_BEASTCLASS						"beastClass"
#define TAG_BEASTCOUNT						"beastCount"
#define TAG_BEASTINFO						"beastInfo"
#define TAG_BEASTSIZE						"beastSize"
#define TAG_BEASTSTATE						"beastState"
#define TAG_BEASTVERSION					"beastVersion"
#define TAG_BEASTZIDS						"beastZids"
#define TAG_BEGINRID						"beginRID"
#define TAG_BLOCKSIZE						"blockSize"
#define TAG_BLOCKSIZESHIFT					"blockSizeShift"
#define TAG_BOOTABLE						"bootable"
#define TAG_BROWSE							"browse"
#define TAG_BROWSEBEASTS					"browseBeasts"
#define TAG_BUCKETMAXIMUMENTRIES			"bucketMaximumEntries"
#define TAG_BUCKETSUSEDPERCENT				"bucketsUsedPercent"
#define TAG_BUFFERCACHE						"bufferCache"
#define TAG_BUILD							"build"
#define TAG_BUILDDATE						"buildDate"
#define TAG_BUILDNUMBER						"buildNumber"
#define TAG_BYTESREAD						"bytesRead"
#define TAG_BYTESWRITTEN					"bytesWritten"
#define TAG_CACHEACTIVATIONCOUNT			"cacheActivationCount"
#define TAG_CACHEBALANCEPERCENT				"cacheBalancePercent"
#define TAG_CACHEBALANCETIMER				"cacheBalanceTimer"

#ifdef XML_TAGS_REMOVED_IN_OES2
#define TAG_CACHEBUFFERFLUSHTIMER			"cacheBufferFlushTimer"
#endif
/*
	The tag TAG_CACHEBUFFERFLUSHTIMER is no longer generated since
	OES2 within Linux.  Instead, Linux OES2 has the following three
	tags.

		TAG_CACHEJOURNALFLUSHTIMER
		TAG_CACHEMETADATAFLUSHTIMER
		TAG_CACHEUSERDATAFLUSHTIMER

	If you need the old tag because your application runs
	against OES1 and OES2 then define XML_TAGS_REMOVED_IN_OES2
	before including xmlTags.h.  We have elected to not define
	by default so that you get compile time errors that will
	let you know that the tag is no longer returned in OES2.
	In which case, you may want to re-write your code to handle
	the three new tags above.
*/

#define TAG_CACHEJOURNALFLUSHTIMER			"cacheJournalFlushTimer"		/* Added for OES2 group write feature */
#define TAG_CACHEMETADATAFLUSHTIMER			"cacheMetadataFlushTimer"		/* Added for OES2 group write feature */
#define TAG_CACHEUSERDATAFLUSHTIMER			"cacheUserDataFlushTimer"		/* Added for OES2 group write feature */

#define TAG_CACHEMETADATAGROUPWRITELIMIT	"cacheMetadataGroupWriteLimit"	/* Added for OES2 group write feature */
#define TAG_CACHEMETADATAGROUPWRITECOUNT	"cacheMetadataGroupWriteCount"	/* Added for OES2 group write feature */

#define TAG_CACHEBSBCRLIMIT             	"cacheBSBCRLimit"           	/* Added post OES2 SP2 */
#define TAG_CACHEBSBRALIMIT             	"cacheBSBRALimit"           	/* Added post OES2 SP2 */

#define TAG_CACHEBUFFERSNUMBER				"cacheBuffersNumber"
#define TAG_CACHEHITPERCENT					"cacheHitPercent"
#define TAG_CACHEHITS						"cacheHits"
#define TAG_CACHEIOLINUXHITS		    	"cacheHitsLinux"
#define TAG_CACHEIOLINUXHITSPERCENT 		"cacheHitsLinuxPercent"
#define TAG_CACHEIOLINUXMISSES  			"cacheMissesLinux"
#define TAG_CACHEIOLINUXUSERHITS			"cacheHitsLinuxUser"
#define TAG_CACHEIOLINUXUSERHITSPERCENT		"cacheHitsLinuxPercentUser"
#define TAG_CACHEIOLINUXUSERMISSES			"cacheMissesLinuxUser"
#define TAG_CACHEIOLINUXSYSTEMHITS			"cacheHitsLinuxSystem"
#define TAG_CACHEIOLINUXSYSTEMHITSPERCENT	"cacheHitsLinuxPercentSystem"
#define TAG_CACHEIOLINUXSYSTEMMISSES		"cacheMissesLinuxSystem"
#define TAG_CACHEIOSYSTEMHITPERCENT			"cacheHitPercentSystem"
#define TAG_CACHEIOSYSTEMHITS				"cacheHitsSystem"
#define TAG_CACHEIOSYSTEMMISSES  			"cacheMissesSystem"
#define TAG_CACHEIOUSERHITPERCENT			"cacheHitPercentUser"
#define TAG_CACHEIOUSERHITS					"cacheHitsUser"
#define TAG_CACHEIOUSERMISSES				"cacheMissesUser"
#define TAG_CACHEMISSES						"cacheMisses"
#define TAG_CACHENEGATIVEHITS				"cacheNegativeHits"
#define TAG_CACHEPAGESALLOCATED				"cachePagesAllocated"
#define TAG_CACHEPOSITIVEHITS				"cachePositiveHits"
#define TAG_CACHERESETCOUNT					"cacheResetCount"
#define TAG_CACHESIGNATURE					"cacheSignature"
#define TAG_CACHESIZE						"cacheSize"
#define TAG_CAPACITY						"capacity"
#define TAG_CFSMASTER						"cfsMaster"
#define TAG_CFSSLAVE						"cfsSlave"
#define TAG_CHANGEEVENTEPOCH				"changeEventEpoch"
#define TAG_CHANGEJOBSTATE					"changeJobState"
#define TAG_CHANGEMODE						"changeMode"
#define TAG_CHANGEOWNERGROUP				"changeOwnerGroup"
#define TAG_CHECKEPOCHS						"checkEpochs"
#define TAG_CHUNKSIZE						"chunkSize"
#define TAG_CIFS							"cifs"
#define TAG_CIFSENABLED						"cifsEnabled"
#define TAG_CIFSSERVERNAME					"cifsServerName"
#define TAG_CIFSVIRTUALSERVERNAME			"cifsVirtualServerName"
#define TAG_CIFSPROXYUSERINFO				"cifsProxyUserInfo"
#define TAG_CLASSID							"classID"
#define TAG_CLEAN							"clean"
#define TAG_CLOSEDFILECACHESIZE				"closedFileCacheSize"
#define TAG_CLUSTER							"cluster"
#define	TAG_COMMENT							"comment"
#define TAG_COMPATTRIBUTES                  "compAttributes"
#define TAG_COMPBEASTINFO					"compBeastInfo"
#define TAG_COMPHEADER                      "compHeader"
#define TAG_COMPFLAGS                       "compFlags"
#define TAG_COMPFLAGSIMMEDIATECOMPRES       "compFlagsImmediateCompress"
#define TAG_COMPFLAGSUPGRADESTART           "compFlagsUpgradeStart"
#define TAG_COMPFLAGSUPGRADEFINISHED        "compFlagsUpgradeFinished"
#define TAG_COMPRESSCODE                    "compressCode"
#define TAG_COMPRESSED						"compressed"
#define TAG_COMPRESSEDBLOCKS				"compressedBlocks"
#define TAG_COMPRESSEDBYTES					"compressedBytes"
#define TAG_COMPRESSEDDELETEDFILES			"compressedDeletedFiles"
#define TAG_COMPRESSEDFILELENGTH            "compressedFileLength"
#define TAG_COMPRESSEDFILES					"compressedFiles"
#define TAG_COMPRESSIMMEDIATE				"compressImmediate"
#define TAG_COMPRESSION						"compression"
#define TAG_COMPRESSIONINFO					"compressionInfo"
#define TAG_COMPRESSIONSTATS				"compressionStats"
#define TAG_COMPRESSMAJORVERSION            "compressMajorVersion"
#define TAG_COMPRESSMINORVERSION            "compressMinorVersion"
#define TAG_COMPZID							"compZid"
#define TAG_CONFIG							"config"
#define TAG_CONTEXT							"context"
#define TAG_CONTINUESTATE					"continueState"
#define TAG_COOKIE							"cookie"
#define	TAG_COPY							"copy"
#define	TAG_COPYCOUNT						"copyCount"
#define	TAG_COPYINHIBIT						"copyInhibit"
#define TAG_COUNT							"count"
#define TAG_CPRECIOUS						"cPrecious"
#define TAG_CREATE							"create"
#define TAG_CREATEALLOWED					"createAllowed"
#define TAG_CREATECONTEXTLIST				"createContextList"
#define TAG_CREATEDOMAIN					"createDomain"
#define	TAG_CREATEJOB						"createJob"
#define TAG_CREATEDTIME						"createdTime"
#define TAG_CREATEDDOSTIME					"createdDOSTime"
#define TAG_CREATEJUNCTION					"createJunction"
#define TAG_CREATELINK						"createLink"
#define TAG_CREATEMEDIALAYOUT				"createMediaLayout"
#define TAG_CREATENEWSERVICE				"createNewService"
#define TAG_CREATETIME						"createTime"
#define TAG_CREATOR							"creator"
#define TAG_CREATORID							"creatorID"
#define TAG_CSABEASTZID						"csaBeastZid"
#define TAG_CURRENTACTIVITY					"currentActivity"
#define TAG_CURRENTBUFFERCACHESIZE			"currentBufferCacheSize"
#define TAG_CURRENTOPENCOUNT				"currentOpenCount"
#define TAG_CURRENTSTATE					"currentState"
#define TAG_DATABASEPATH					"databasePath"
#define TAG_DATASIZE						"dataSize"
#define TAG_DATASTREAM						"dataStream"
#define TAG_DATASTREAMS						"dataStreams"
#define TAG_DATASTREAMCOMPRESS				"dataStreamCompress"
#define TAG_DATASTREAMINFO					"dataStreamInfo"
#define TAG_DBINFO							"dbInfo"
#define TAG_DEACTIVATE						"deactivate"
#define TAG_DEACTIVATEPOOLSNAPSHOT			"deactivatePoolSnapshot"
#define TAG_DELETEBEAST                     "deleteBeast"
#define TAG_DELETECOUNT						"deleteCount"
#define TAG_DELETEDFILES					"deletedFiles"
#define TAG_DELETEDINFO						"deletedInfo"
#define TAG_DELETEDOMAIN					"deleteDomain"
#define TAG_DELETEDPARENTENTRY				"deletedParentEntry"
#define TAG_DELETEDTIME						"deletedTime"
#define TAG_DELETEDVOLUME					"deletedVolume"
#define TAG_DELETEDVOLUMES					"deletedVolumes"
#define TAG_DELETEDVOLUMEINFO				"deletedVolumeInfo"
#define TAG_DELETEDVOLUMENAME				"deletedVolumeName"
#define TAG_DELETEINHIBIT					"deleteInhibit"
#define TAG_DELETEJUNCTION					"deleteJunction"
#define TAG_DELETELINK						"deleteLink"
#define TAG_DELETESERVICE					"deleteService"
#define TAG_DELETESTATE						"deleteState"
#define TAG_DELETOR						"deletor"
#define TAG_DELETORID						"deletorID"
#define TAG_DENY							"deny"
#define TAG_DENYALL							"denyAll"
#define TAG_DENYREADERCOUNT					"denyReaderCount"
#define TAG_DENYWRITERCOUNT					"denyWriterCount"
#define TAG_DERIVEDFROMCLASSID				"derivedFromClassID"
#define TAG_DESCRIPTION						"description"
#define TAG_DETAILS							"details"
#define TAG_DEVICE							"device"
#define TAG_DEVICEID						"deviceID"
#define TAG_DEVICEINFO						"deviceInfo"
#define TAG_DEVICEMIRROR					"deviceMirror"
#define TAG_DEVICENAME						"deviceName"
#define TAG_DEVICERAID						"deviceRAID"
#define TAG_DEVICES							"devices"
#define TAG_DEVICESHARED					"deviceShared"
#define TAG_DEVICESIMPLEINFO				"deviceSimpleInfo"
#define TAG_DEVICETYPE						"deviceType"
#define TAG_DEVICEINITFLAG					"deviceInitFlag"
#define TAG_DEVICEFORMAT					"deviceFormat"
#define TAG_DFS								"dfs"
#define TAG_DFSGUID							"dfsGUID"
#define TAG_DIOMODECOUNT					"dioModeCount"
#define	TAG_DIRECTIO                        "directIO"
#define TAG_DIRECTORY						"directory"
#define TAG_DIRECTORYQUOTA					"directoryQuota"
#define TAG_DIRECTORYQUOTAINFO				"directoryQuotaInfo"
#define TAG_DIRECTORYQUOTAS					"directoryQuotas"
#define TAG_DIRINFO							"dirInfo"
#define TAG_DOMAIN							"domain"
#define TAG_DOMAINNAME						"domainName"
#define TAG_DONOTCOMPRESS					"doNotCompress"
#define	TAG_DONTBACKUP                      "dontBackup"
#define TAG_DONTDELETEWHILEOPENCOUNT		"dontDeleteWhileOpenCount"
#define TAG_DONTREMOVENDSOBJECT				"dontRemoveNDSObject"
#define TAG_DONTRENAMENDSOBJECT				"dontRenameNDSObject"
#define TAG_DOSMETADATA                     "dosMetaData"
#define TAG_DSTPARENTFULLPATH				"dstParentFullPath"
#define TAG_DSTPARENTID						"dstParentID"
#define TAG_DSTPARENTPATH					"dstParentPath"
#define TAG_DSTPATH						"dstPath"
#define TAG_DUPLICATEADDS					"duplicateAdds"
#define TAG_EDIRID						"edirID"
#define TAG_EFFECTIVERIGHTS					"effectiveRights"
#define TAG_ELEMENTCOUNT					"elementCount"
#define TAG_ELEMENTSIZE						"elementSize"
#define TAG_ENABLEDATTRIBUTEBITS			"enabledAttributeBits"
#define TAG_ENABLEDATTRIBUTES				"enabledAttributes"
#define TAG_ENABLEIOWRITE					"enableIOWrite"
#define	TAG_ENCRYPTED                       "encrypted"
#define TAG_ENDRID							"endRID"
#define TAG_EOF								"eof"
#define TAG_EPOCH							"epoch"
#define TAG_EQUIVALENTIDS					"equivalentIDs"
#define TAG_ERASE							"erase"
#define TAG_ERROR							"error"
#define TAG_ERRORCODE						"errorCode"
#define TAG_ERRORCOUNT						"errorCount"
#define TAG_EXECUTE							"execute"
#define TAG_EXPANDPOOL						"expandPool"
#define TAG_EXPANDPOOLSIMPLE				"expandPool2"
#define TAG_EXPANDRAID						"expandRAID"
#define TAG_EXPANDRAIDSIMPLE				"expandRAID2"
#define TAG_EXPANDTRADITIONALVOLUME			"expandTraditionalVolume"
#define TAG_EXTENDEDATTRIBUTE				"extendedAttribute"
#define TAG_EXTENDEDATTRIBUTES				"extendedAttributes"
#define TAG_EXTENDEDMACNAMESPACE            "extendedMacNameSpace"
#define TAG_FAILURE							"failure"
#define TAG_FILE							"file"
#define TAG_FILEBEASTINFO					"fileBeastInfo"
#define TAG_FILEEVENTLIST					"fileEventList"
#define TAG_FILEFLUSHTIMER					"fileFlushTimer"
#define TAG_FILEID							"fileID"
#define TAG_FILEINFO						"fileInfo"
#define TAG_FILENAME						"fileName"
#define TAG_FILEPHYSSIZE                    "filePhysSize"
#define TAG_FILEREADCOUNTS					"fileReadCounts"
#define TAG_FILEREPLY						"fileReply"
#define TAG_FILEREQUEST						"fileRequest"
#define TAG_FILES							"files"
#define TAG_FILESCAN						"fileScan"
#define TAG_FILESDELETED					"filesDeleted"
#define TAG_FILESIZE						"fileSize"
#define TAG_FILESNAPSHOTBEASTZID			"fileSnapShotBeastZid"
#define TAG_FILESPURGED						"filesPurged"
#define TAG_FILESSALVAGED					"filesSalvaged"
#define TAG_FILESTATS						"fileStats"
#define TAG_FILEWRITECOUNTS					"fileWriteCounts"
#define	TAG_FIND							"find"
#define TAG_FINDCONTEXT						"findContext"
#define TAG_FIRSTPARENT						"firstParent"
#define TAG_FIXCOMPSTATS                    "fixCompStats"
#define TAG_FLAGS							"flags"
#define TAG_FLUSHCOUNT						"flushCount"
#define TAG_FLUSHFILES						"flushFiles"
#define TAG_FORCE							"force"
#define TAG_FREEABLESIZE					"freeableSize"
#define TAG_FREEBYTES						"freeBytes"
#define TAG_FREESIZE						"freeSize"
#define TAG_FREESPACEID						"freeSpaceID"
#define TAG_FREESPACEINFO 					"freeSpaceInfo"
#define TAG_FREESPACES						"freeSpaces"
#define TAG_FROMNCP							"fromNCP"
#define TAG_FSMSDONE						"fsmsDone"
#define TAG_FSMSWAITING						"fsmsWaiting"
#define TAG_FSTYPE						"fsType"
#define TAG_FULLNAME						"fullName"
#define TAG_FULLYRESTRICTED					"fullyRestricted"
#define TAG_GENERALSTATS					"generalStats"
#define TAG_GET								"get"
#define TAG_GETADAPTERINFO					"getAdapterInfo"
#define TAG_GETALLEFFECTIVERIGHTS			"getAllEffectiveRights"
#define TAG_GETARCHIVESERVER				"getArchiveServer"
#define TAG_GETATTRIBUTE					"getAttribute"
#define TAG_GETBEASTFULLNAME                "getBeastFullName"
#define TAG_GETBEASTINFO					"getBeastInfo"
#define TAG_GETCREATECONTEXTLISTSTATUS		"getCreateContextListStatus"
#define TAG_GETDEFAULTCLUSTERNAMES			"getDefaultClusterNames"
#define TAG_GETDEVICEINFO					"getDeviceInfo"
#define TAG_GETDEVICEINFOSIMPLE				"getDeviceInfo2"
#define TAG_GETDEVICEINFOMULTIPLE			"getDeviceInfo3"
#define TAG_GETDFSGUID						"getDfsGUID"
#define TAG_GETDOMAINCONFIGURATION			"getDomainConfiguration"
#define TAG_GETEFLNAMESPACEID				"getEFLNameSpaceID"
#define TAG_GETEFFECTIVERIGHTSBYID			"getEffectiveRightsByID"
#define TAG_GETEFFECTIVERIGHTSBYUSER		"getEffectiveRightsByUser"
#define TAG_GETERRORNAME					"getErrorName"
#define TAG_GETALLPATHSINFO			"getAllPathsFileInfo"
#define TAG_GETFILEINFO						"getFileInfo"
#define TAG_GETIMPORTWINDOWSUSERSSTATUS		"getImportWindowsUsersStatus"
#define TAG_GETINACTIVEEPOCHINTERVAL		"getInactiveEpochInterval"
#define TAG_GETINFO							"getInfo"
#define TAG_GETINHERITEDRIGHTSFORUSER		"getInheritedRightsForUser"
#define TAG_GETJOBLIST						"getJobList"
#define	TAG_GETJOBSTATUS					"getJobStatus"
#define TAG_GETLSSINFO						"getLSSInfo"
#define TAG_GETLSSVOLUMEINFO 				"getLSSVolumeInfo"
#define TAG_GETMCCOUNT						"getMCCount"
#define TAG_GETNDSNAME						"getNDSName"
#define TAG_GETPARTITIONINFO				"getPartitionInfo"
#define TAG_GETPARTITIONMIRRORSTATS			"getPartitionMirrorStats"
#define TAG_GETPATHINFO						"getPathInfo"
#define TAG_GETPOOLDEVICES					"getPoolDevices"
#define TAG_GETPOOLINFO						"getPoolInfo"
#define TAG_GETPOOLSNAPSHOTINFO				"getPoolSnapshotInfo"
#define TAG_GETSERVERCONFIGURATION			"getServerConfiguration"
#define TAG_GETSERVERFREESPACE				"getServerFreeSpace"
#define TAG_GETSHAREPROPERTIES				"getShareProperties"
#define TAG_GETSTATE						"getState"
#define TAG_GETSTATUSMFL					"getStatusMFL"
#define TAG_GETTRADITIONALVOLUMEINFO  		"getTraditionalVolumeInfo"
#define TAG_GETVLDBINFO						"getVLDBInfo"
#define TAG_GETVOLUMEINFO					"getVolumeInfo"
#define TAG_GIVENNAME						"givenName"
#define TAG_GROUP							"group"
#define TAG_GROUPID							"groupID"
#define TAG_GROUPNAME						"groupName"
#define TAG_GROWABLE						"growable"
#define TAG_GROWSIZE						"growSize"
#define TAG_HARDLINKS                       "hardLinks"
#define TAG_HASDOS							"hasDOS"
#define TAG_HASSYS							"hasSYS"
#define TAG_HASHBUCKETS						"hashBuckets"
#define	TAG_HASHBUCKETSPRIVATE				"privateHashBuckets"
#define TAG_HIDDEN							"hidden"
#define	TAG_HIGHINTEGRITY                   "highIntegrity"
#define TAG_HIGHWATERMARK					"highWaterMark"
#define TAG_HIGHWORKSWAITINGCOUNT			"highWorksWaitingCount"
#define	TAG_HMCCACHETYPE					"cacheType"
#define TAG_HOTFIXAVAILSIZE					"hotFixAvailSize"
#define TAG_HOTFIXID						"hotFixID"
#define TAG_HOTFIXSIZE						"hotFixSize"
#define TAG_ID								"id"
#define TAG_ID1								"id1"
#define TAG_ID2								"id2"
#define TAG_ID3								"id3"
#define TAG_INFO							"info"
#define TAG_IDINFO							"idInfo"
#define TAG_IDNOTFOUND						"idNotFound"
#define TAG_IGNOREOPENFILE  				"ignoreOpenFile"
#define TAG_IGNORESHARESTATE				"ignoreShareState"
#define TAG_IMMEDIATEPURGE					"immediatePurge"
#define TAG_IMPORTWINDOWSUSERS				"importWindowsUsers"
#define TAG_INCLUDEADIDENTITIES			"includeADIdentities"
#define TAG_INHERITEDRIGHTSFILTER			"inheritedRightsFilter"
#define TAG_INITDFSGUIDS					"initDFSGUIDs"
#define TAG_INITIALIZEDEVICE 				"initializeDevice"
#define TAG_INSERT							"insert"
#define TAG_INTERNALVOLUMEID				"internalVolumeID"
#define TAG_INTERVAL						"interval"
#define TAG_INUSEBLOCKS                     "inUseBlocks"
#define TAG_INUSEOBJECTCOUNT				"inUseObjectcount"
#define TAG_IPADDRESS						"ipAddress"
#define TAG_ISONLINE						"isOnline"
#define TAG_ISVIRTUAL						"isVirtual"
#define	TAG_JOB								"job"
#define	TAG_JOBTYPE							"jobType"
#define	TAG_JOINDOMAIN						"joinDomain"
#define TAG_JUNCTION						"junction"
#define TAG_JUNCTIONDEFINITION				"junctionDefinition"
#define TAG_JUNCTIONLIST                                "listJunctions"
#define TAG_JUNCTIONNAME					"junctionName"
#define TAG_JUNCTIONPATH					"junctionPath"
#define TAG_JUNCTIONSCANINFO					"junctionScanInfo"
#define TAG_JUNCTIONSCANSTARTTIME				"junctionScanStartTime"
#define TAG_JUNCTIONSCANTIME                                 "junctionScanTime"
#define TAG_LABEL							"label"
#define TAG_LASTCOMPRATIO					"lastCompressionRatio"
#define TAG_LASTNAMEUNIQUIFIER				"lastNameUniquifier"
#define TAG_LASTSTATUS						"lastStatus"
#define TAG_LASTSTATUSSETTER				"lastStatusSetter"
#define TAG_LASTTIMENOTINUSE				"lastTimeNotInUse"
#define TAG_LASTUSERID						"lastUserID"
#define TAG_LASTZIDRETURNED					"lastZidReturned"
#define TAG_LATCH							"latch"
#define TAG_LATCHALL						"latchAll"
#define TAG_LATCHFREE						"latchFree"
#define TAG_LATCHHOLDER						"latchHolder"
#define TAG_LATCHSTATS						"latchStats"
#define TAG_LATCHWAITER						"latchWaiter"
#define TAG_LEAVEDOMAIN						"leaveDomain"
#define TAG_LINK							"link"
#define TAG_LINKVOLUMES						"linkVolumes"
#define TAG_LINUXREPLY						"linuxReply"
#define TAG_LINUXREQUEST					"linuxRequest"
#define TAG_LIST							"list"
#define TAG_LISTADAPTERS					"listAdapters"
#define TAG_LISTALLFILES					"listAllFiles"
#define TAG_LISTCONTEXTS					"listContexts"
#define TAG_LISTDEVICEPARTITIONS			"listDevicePartitions"
#define TAG_LISTDEVICEPOOLS					"listDevicePools"
#define TAG_LISTDEVICES						"listDevices"
#define TAG_LISTDOMAINCONTROLLERS			"listDomainControllers"
#define TAG_LISTEPOCHS						"listEpochs"
#define TAG_LISTFILEEVENTS					"listFileEvents"
#define TAG_LISTIMPORTEDUSERS				"listImportedUsers"
#define TAG_LISTMFL							"listMFL"
#define TAG_LISTMULTIPATHS					"listMultiPaths"
#define TAG_LISTPARTITIONS					"listPartitions"
#define TAG_LISTPOOLS						"listPools"
#define TAG_LISTPOOLSNAPSHOTS				"listPoolSnapshots"
#define TAG_LISTSHARES						"listShares"
#define TAG_LISTSKIPPEDFILES				"listSkippedFiles"
#define TAG_LISTTRUSTEES					"listTrustees"
#define TAG_LISTVOLUMES						"listVolumes"
#define TAG_LMLEVEL							"lmCompatibilityLevel"
#define TAG_LOADBALANCE						"loadBalance"
#define TAG_LOADTIME						"loadTime"
#define TAG_LOADVLDB						"loadVLDB"
#define TAG_LOGGEDPERSISTENTVOLUME          "loggedPersistentVolume"
#define TAG_LOGICALEOF						"logicalEOF"
#define TAG_LOGICALPARTITIONCAPACITY		"logicalPartitionCapacity"
#define TAG_LOGICALPARTITIONID				"logicalPartitionID"
#define TAG_LOGICALVOLUMESIZES				"logicalVolumeSizes"
#define TAG_LOOKUP							"lookup"
#define TAG_LOWWATERMARK					"lowWaterMark"
#define TAG_LSS								"LSS"
#define TAG_LSS2							"lss"
#define TAG_LSSID							"lssID"
#define TAG_LSSINFO							"lssInfo"
#define TAG_LSSNAME							"lssName"
#define TAG_LSSTYPE							"lssType"
#define TAG_LSSVOLUMEINFO 					"lssVolumeInfo"
#define TAG_MACMETADATA                     "macMetaData"
#define TAG_MAILBOXINTERRUPTSDONE			"mailboxInterruptsDone"
#define TAG_MAILBOXINTERRUPTSWAITING		"mailBoxInterruptsWaiting"
#define TAG_MAILBOXSIZE						"mailboxSize"
#define TAG_MAJORVERSION					"majorVersion"
#define TAG_MANAGEMENTCONTEXT				"managementContext"
#define TAG_MAXFILESIZE						"maxFileSize"
#define TAG_MAXIMUMENTRIES					"maximumEntries"
#define TAG_MAXIMUMHIGHWORKSWAITINGNUMBER	"maximumHighWorksWaitingNumber"
#define TAG_MAXIMUMNORMALWORKSWAITINGNUMBER	"maximumNormalWorksWaitingNumber"
#define TAG_MAXIMUMNOTINUSEOBJECTS			"maximumNotInUseObjects"
#define TAG_MAXIMUMOBJECTSINMEMORY			"maximumObjectsInmemory"
#define TAG_MAXIMUMPENDINGWORKNUMBER		"maximumPendingWorkNumber"
#define TAG_MAXKEEPTIME						"maxKeepTime"
#define TAG_MAXPARTITIONS					"maxPartitions"
#define TAG_MBSIZE							"MBsize"
#define TAG_MDHIMEMBUCKETMAXIMUMENTRIES	    "metaDataHimemBucketMaximumEntries"
#define TAG_MDHIMEMBUCKETSUSEDPERCENT     	"metaDataHimemBucketsUsedPercent"
#define TAG_MDHIMEMTOTALENTRIES   			"metaDataHimemTotalEntries"
#define TAG_MEDIALAYOUT						"mediaLayout"
#define TAG_METADATAARCHIVE					"metaDataArchive"
#define TAG_METADATABUFFERCACHESIZETARGET		"targetMetadataBlocksCacheSize"
#define TAG_METADATABUFFERCACHESIZECURRENT		"currentMetadataBlocksCacheSize"
#define TAG_METADATABUFFERCACHESIZECURRENTLOW	"currentMetadataBlocksCacheSizeLow"
#define TAG_METADATAMODIFIEDTIME			"metaDataModifiedTime"
#define TAG_METADATAMODIFIEDDOSTIME			"metaDataModifiedDOSTime"
#define TAG_METADATAMODIFIER				"metaDataModifier"
#define TAG_METADATAMODIFIERID				"metaDataModifierID"
#define TAG_METADATAPHYSSIZE                "metaDataPhysSize"
#define TAG_METADATASEQNUM					"metaDataSeqNum"
#define TAG_MFL								"mfl"
#define TAG_MIGRATION						"migration"
#define TAG_MINIMUMNETWAREBUFFERCACHESIZE	"minimumNetWareBufferCacheSize"
#define TAG_MINIMUMNSSBUFFERCACHESIZE		"minimumNSSBufferCacheSize"
#define TAG_MINIMUMNUMBEROFASYNCIOS			"minimumNumberOfAsyncIOs"
#define TAG_MINIMUMNUMBEROFBONDS			"minimumNumberOfBonds"
#define TAG_MINIMUMNUMBEROFWORKTODOS		"minimumNumberOfWorkToDos"
#define TAG_MINIMUMOSFREEBUFFERS			"minimumOSFreeBuffers"
#define TAG_MINKEEPTIME						"minKeepTime"
#define TAG_MINORVERSION					"minorVersion"
#define TAG_MIRROR							"mirror"
#define TAG_MIRRORACTIVE					"mirrorActive"
#define TAG_MIRRORED						"mirrored"
#define TAG_MIRRORGROUPPERCENT				"mirrorGroupPercent"
#define TAG_MIRRORGROUPSTATUS				"mirrorGroupStatus"
#define TAG_MIRRORID						"mirrorID"
#define TAG_MIRRORINFO						"mirrorInfo"
#define TAG_MIRRORPERCENT					"mirrorPercent"
#define TAG_MIRRORSTATUS					"mirrorStatus"
#define TAG_MODE							"mode"
#define TAG_MODIFIEDFILELIST				"modifiedFileList"
#define TAG_MODIFIEDTIME					"modifiedTime"
#define TAG_MODIFIEDDOSTIME					"modifiedDOSTime"
#define TAG_MODIFIER						"modifier"
#define TAG_MODIFIERID						"modifierID"
#define TAG_MODIFY							"modify"
#define TAG_MODIFYCONTEXTLIST				"modifyContextList"
#define TAG_MODIFYDEVICE					"modifyDevice"
#define TAG_MODIFYINHERITEDRIGHTSFILTER		"modifyInheritedRightsFilter"
#define TAG_MODIFYLINK						"modifyLink"
#define TAG_MODIFYPARTITION					"modifyPartition"
#define TAG_MODIFYPOOLINFO					"modifyPoolInfo"
#define TAG_MODIFYSHARE						"modifyShare"
#define TAG_MODIFYSTATE						"modifyState"
#define TAG_MODIFYVOLUMEINFO				"modifyVolumeInfo"
#define TAG_MODULE							"module"
#define TAG_MOUNT							"mount"
#define TAG_MOUNTOPTIONS					"mountOptions"
#define TAG_MOUNTPOINT						"mountPoint"
#define TAG_MOUNTPOINTRENAME              	"mountPointRename"
#define TAG_MOUNTEDSTATUS					"mountedStatus"
#define	TAG_MOVECOUNT						"moveCount"
#define TAG_MSAP							"msap"
#define TAG_MULTIPATH						"multiPath"
#define TAG_MULTIPATHINFO					"multiPathInfo"
#define TAG_MULTIPATHS						"multiPaths"
#define TAG_MULTIPLEVOLUMES					"multipleVolumes"
#define TAG_MYCACHE							"mycache"
#define TAG_NAME							"name"
#define TAG_NAMECACHE						"nameCache"
#define TAG_NAMECACHESIZE					"nameCacheSize"
#define TAG_NAMECASESENSITIVE				"nameCaseSensitive"
#define TAG_NAMEDBEASTINFO					"namedBeastInfo"
#define TAG_NAMEDPIPE						"namedPipe"
#define TAG_NAMEDUPLICATE					"nameDuplicate"
#define TAG_NAMEENTRY						"nameEntry"
#define TAG_NAMEFLAGS						"nameFlags"
#define TAG_NAMEFORCEDUPPERCASE				"nameForcedUpperCase"
#define TAG_NAMELENGTHMASK					"nameLengthMask"
#define TAG_NAMEOUTOFLINE					"nameOutOfLine"
#define TAG_NAMEOVERFLOW					"nameOverFlow"
#define TAG_NAMES							"names"
#define TAG_NAMESIZE						"nameSize"
#define TAG_NAMESPACE						"nameSpace"
#define TAG_NAMESPACEINFO					"nameSpaceInfo"
#define TAG_NAMESPACEMASK                   "nameSpaceMask"
#define TAG_NAMESPACES						"nameSpaces"
#define TAG_NAMETYPE						"nameType"
#define TAG_NAMEUNIQUIFIER					"nameUniquefier"
#define TAG_NEXTZID                         "nextZid"
#define TAG_NDSATTRIBUTE					"ndsAttribute"
#define TAG_NDSID							"ndsID"
#define TAG_NDSNAME							"ndsName"
#define TAG_NDSOBJECT						"ndsObject"
#define TAG_NDSPOOL							"ndsPool"
#define TAG_NDSPOOLGUID						"ndsPoolGUID"
#define TAG_NDSPOOLNAME						"ndsPoolName"
#define	TAG_NDSREPLY						"ndsReply"
#define	TAG_NDSREQUEST						"ndsRequest"
#define TAG_NDSSERVERNAME					"ndsServerName"
#define TAG_NDSUSER							"ndsUser"
#define TAG_NDSVOLUME						"ndsVolume"
#define TAG_NDSVOLUMEGUID					"ndsVolumeGUID"
#define TAG_NDSVOLUMENAME					"ndsVolumeName"
#define TAG_NEGATIVEADDS					"negativeAdds"
#define TAG_NETWAREMETADATA                 "netwareMetaData"
#define TAG_NEWEPOCH						"newEpoch"
#define TAG_NEWNAME							"newName"
#define TAG_NEWNDSNAME						"newNDSName"
#define TAG_NEWPOOLNAME						"newPoolName"
#define TAG_NEWSHARENAME					"newShareName"
#define TAG_NEWSNAPNAME				  		"newSnapName"
#define TAG_NEWVALUE						"newValue"
#define TAG_NEWVOLUMENAME					"newVolumeName"
#define TAG_NEXTCHILDZID					"nextChildZid"
#define TAG_NEXTRID							"nextRID"
#define TAG_NEXTSCANSEQUENCE				"nextScanSequence"
#define TAG_NFLADDEDTOSALVAGETREE			"nflAddedToSalvageTree"
#define TAG_NFLBLKSNOTINPURGEABLECOUNT		"nflBlksNotInPurgeableCount"
#define TAG_NFLHASDATASTREAMS				"nflHasDataStreams"
#define TAG_NFLHASEXTENDEDATTRIBUTES		"nflHasExtendedAttributes"
#define TAG_NFSINFO							"nfsInfo"
#define TAG_NFSNAME							"nfsName"
#define TAG_NOACCESSTIME 					"noAccessTime"
#define TAG_NODFSGUID						"noDFSGUID"
#define TAG_NONDSOBJECT						"noNDSObject"
#define TAG_NONFREEABLESIZE					"nonFreeableSize"
#define TAG_NONPURGEABLEBLOCKS              "nonPurgeableBlocks"
#define TAG_NOOLDDATAMATCH                  "noOldDataMatch"
#define TAG_NOQUOTA							"noQuota"
#define TAG_NORMALWORKSWAITINGCOUNT			"normalWorksWaitingCount"
#define TAG_NOSNAPSHOT						"noSnapshot"
#define TAG_NOSTREAMCOMPRESS				"noStreamCompress"
#define TAG_NOSUBALLOC						"noSuballoc"
#define TAG_NOTINUSEOBJECTCOUNT				"notInUseObjectCount"
#define TAG_NOTINUSESIZE					"notInUseSize"
#define TAG_NOTSHARED						"notShared"
#define TAG_NOTVIRTUAL						"notVirtual"
#define	TAG_NSSDATASTREAM					"nssDataStream"
#define	TAG_NSSDATASTREAMREPLY				"nssDataStreamReply"
#define	TAG_NSSREPLY						"nssReply"
#define	TAG_NSSREQUEST						"nssRequest"
#define TAG_NUMBEROFTIMES					"numberOfTimes"
#define TAG_NUMBEASTSREQUESTED				"numBeastsRequested"
#define TAG_NUMBEASTSRETURNED				"numBeastsReturned"
#define TAG_NUMBLOCKS						"numBlocks"
#define TAG_NUMCHILDZIDS					"numChildZids"
#define TAG_NUMENTRIES						"numEntries"
#define	TAG_NUMMIRRORS						"numMirrors"
#define TAG_NUMNAMES						"numNames"
#define TAG_NUMPARENTS						"numParents"
#define TAG_NUMPROCESSTHREADS 				"numProcessThreads"
#define TAG_NUMQUEUEDBGCOMPREQS				"numQueuedBGCompReqs"
#define TAG_NUMQUEUEDCOMPREQS				"numQueuedCompReqs"
#define TAG_NUMRUNNINGTHREADS 				"numRunningThreads"
#define TAG_NUMSECTORS						"numSectors"
#define TAG_NUMSEGMENTS						"numSegments"
#define TAG_NUMTHREADS						"numThreads"
#define TAG_OBJECTCACHE						"objectCache"
#define TAG_OBJECTID						"objectID"
#define TAG_OFFSET  						"offset"
#define TAG_OLDESTDELETEDTIME  				"oldestDeletedTime"
#define TAG_OLDVALUE						"oldValue"
#define TAG_ONLINEONLY						"onlineOnly"
#define TAG_OPENCOUNT						"openCount"
#define TAG_OPENFILEHASHTABLESIZE			"openFileHashTableSize"
#define TAG_OPERATION						"operation"
#define TAG_OPLOCKS							"oplocks"
#define TAG_ORIGIN							"origin"
#define TAG_ORIGINALFILELENGTH              "originalFileLength"
#define TAG_ORIGINALVOLUMEGUID				"originalVolumeGUID"
#define TAG_ORIGINALVOLUMENAME				"originalVolumeName"
#define TAG_OS								"os"
#define TAG_OSINFO							"osInfo"
#define TAG_OSMODIFY						"osModify"
#define TAG_OTHERPARENTS					"otherParents"
#define TAG_OWNEDVOLUMES					"ownedVolumes"
#define TAG_OWNER							"owner"
#define TAG_OWNERID							"ownerID"
#define TAG_OWNERNAME						"ownerName"
#define TAG_PARENT							"parent"
#define TAG_PARENTENTRY						"parentEntry"
#define TAG_PARENTFULLPATH					"parentFullPath"
#define TAG_PARENTID						"parentID"
#define TAG_PARENTPATH						"parentPath"
#define TAG_PARMINFO						"parmInfo"
#define TAG_PARMRESULT						"parmResult"
#define TAG_PARTIALRESULT					"partialResult"
#define TAG_PARTITION						"partition"
#define TAG_PARTITIONID						"partitionID"
#define TAG_PARTITIONINFO					"partitionInfo"
#define TAG_PARTITIONNAME					"partitionName"
#define TAG_PARTITIONS						"partitions"
#define TAG_PARTITIONSADDED					"partitionsAdded"
#define TAG_PARTITIONSCREATED				"partitionsCreated"
#define TAG_PARTITIONSREQUESTED				"partitionsRequested"
#define TAG_PARTITIONSSTRANDED 				"partitionsStranded"
#define TAG_PARTITIONTYPE					"partitionType"
#define TAG_PASSWORD						"password"
#define TAG_PATH							"path"
#define TAG_PATHID							"pathID"
#define TAG_PATHINFO						"pathInfo"
#define TAG_PATHNAME						"pathName"
#define TAG_PAUSE							"pause"
#define TAG_PAUSESTATE						"pauseState"
#define	TAG_PCTCOMPLETE						"pctComplete"
#define TAG_PDC								"pdc"
#define TAG_PDCENABLE						"pdcEnable"
#define TAG_PDCIPADDRESS					"pdcIPAddress"
#define TAG_PDCNAME							"pdcName"
#define TAG_PENDINGWORKSCOUNT				"pendingWorksCount"
#define TAG_PERCENTAVAILABLESPACE			"percentAvailableSpace"
#define TAG_PERCENTENTRIESUSED				"percentEntriesUsed"
#define TAG_PERCENTFREESPACE				"percentFreeSpace"
#define TAG_PERCENTFULL						"percentFull"
#define	TAG_PERSISTENTATTRIBUTES            "persistentAttributes"
#define TAG_PERSISTENTFEATURES				"persistentFeatures"
#define TAG_PERSISTENTFILE					"persistentFile"
#define TAG_PERSISTENTNAMED					"persistentNamed"
#define TAG_PERSISTENTPARENTENTRY			"persistentParentEntry"
#define TAG_PERSISTENTVOLUME                "persistentVolume"
#define TAG_PERSISTENTVOLUMESTATE			"persistentVolumeState"
#define TAG_PHYSICAL						"physical"
#define TAG_PHYSICALEOF						"physicalEOF"
#define TAG_PINGEPOCH						"pingEpoch"
#define TAG_POOL							"pool"
#define TAG_POOLAPPSTATUS					"results"
#define TAG_POOLAPPSTATUS2					"application"
#define TAG_POOLAVAILABLESIZE		  		"poolAvailableSize"
#define TAG_POOLCHANGEABLEFEATURES			"poolChangeableFeatures"
#define TAG_POOLDEFAULTFEATURES				"poolDefaultFeatures"
#define TAG_POOLFREESIZE			  		"poolFreeSize"
#define TAG_POOLFREEZE						"poolFreeze"
#define TAG_POOLFREEZEDONE					"freezeDone"
#define TAG_POOLFREEZESTATUS				"poolFreezeStatus"
#define TAG_POOLFREEZESTATUS2				"freezeStatus"
#define TAG_POOLGUID						"poolGUID"
#define TAG_POOLHOLD						"holdSeconds"
#define TAG_POOLID							"poolID"
#define TAG_POOLIDTONAME					"poolIDToName"
#define TAG_POOLINFO						"poolInfo"
#define TAG_POOLNAME						"poolName"
#define TAG_POOLTYPE						"poolType"
#define TAG_POOLNONPURGEABLESIZE			"poolNonPurgeableSize"
#define TAG_POOLPURGEABLESIZE				"poolPurgeableSize"
#define	TAG_POOLREBUILD						"poolRebuild"
#define TAG_POOLSIMPLEINFO 					"poolSimpleInfo"
#define TAG_POOLSIZE						"poolSize"
#define TAG_POOLSIZES				  		"poolSizes"
#define TAG_POOLSNAPSHOTINFO				"poolSnapshotInfo"
#define TAG_POOLSTATE						"poolState"
#define TAG_POOLSUPPORTEDFEATURES			"poolSupportedFeatures"
#define TAG_POOLTHAW						"poolThaw"
#define TAG_REFRESH                                             "refresh"
#define TAG_RIGHTSREQUEST				"rightsRequest"
#define TAG_RIGHTSREPLY					"rightsReply"
#define TAG_POOLTHAWDONE					"thawDone"
#define TAG_POOLTHAWOPRETCODE 				"thawOperationReturnCode"
#define TAG_POOLTHAWSTATUS2					"thawStatus"
#define TAG_POOLTHAWSTATUS3					"freezeThawStatus"
#define TAG_POOLTIMEOUT						"timeOut"
#define TAG_POOLTOTALSIZE			  		"poolTotalSize"
#define TAG_POOLUNAVAILABLESIZE		  		"poolUnavailableSize"
#define TAG_POOLUPDATE						"poolUpdate"
#define TAG_POOLUSEDSIZE			  		"poolUsedSize"
#define	TAG_POOLVERIFY						"poolVerify"
#define TAG_PORT							"port"
#define TAG_PRECOMPRESSIONBLOCKS			"preCompressionBlocks"
#define TAG_PRECOMPRESSIONBYTES				"preCompressionBytes"
#define TAG_PRIMARYNAMESPACEID              "primaryNameSpaceID"
#define TAG_PRIORITY						"priority"
#define TAG_PURGEDELETEDFILE				"purgeDeletedFile"
#define TAG_PURGELOG						"purgeLog"
#define TAG_PURGELOGACTIVE					"purgeLogActive"
#define TAG_PURGELOGADD						"purgeLogAdd"
#define TAG_PURGELOGPLAY					"purgeLogPlay"
#define TAG_PURGELOGREMOVE					"purgeLogRemove"
#define TAG_PURGES							"purges"
#define TAG_PURGESACTIVE					"purgesActive"
#define TAG_PURGESASYNCCLEANUPDELETEDFILECOMPLETED	"purgesAsyncCleanupDeletedFileCompleted"
#define TAG_PURGESASYNCCLEANUPDELETEDFILESTARTED	"purgesAsyncCleanupDeletedFileStarted"
#define TAG_PURGESCLEANUPOFUSEDDIRECTORY	"purgesCleanupOfUsedDirectory"
#define TAG_PURGESCOMPLETED					"purgesCompleted"
#define TAG_PURGESCOMPLETEDUNKNOWNVOLUME	"purgesCompletedUnknownVolume"
#define TAG_PURGESDELAYED					"purgesDelayed"
#define TAG_PURGESDELAYTIME					"purgesDelayTime"
#define TAG_PURGESOBJECTLIMIT				"purgesObjectLimit"
#define TAG_PURGESSTARTED					"purgesStarted"
#define TAG_PURGESSTARTEDUNKNOWNVOLUME		"purgesStartedUnknownVolume"
#define TAG_PURGEVOLUME						"purgeVolume"
#define TAG_PURGEABLEBLKS					"purgeableBlks"
#define TAG_PURGEABLEBLOCKS                 "purgeableBlocks"
#define TAG_QUEUELENGTH						"queueLength"
#define TAG_QUOTA							"quota"
#define TAG_QUOTAAMOUNT						"quotaAmount"
#define TAG_QUOTAINFO						"quotaInfo"
#define TAG_RAID							"raid"
#define TAG_RAIDACTIVE						"raidActive"
#define TAG_RAIDID							"raidID"
#define TAG_RAIDNAME						"raidName"
#define	TAG_RAIDSEGMENTS 					"raidSegments"
#define TAG_RAIDTYPE						"raidType"
#define TAG_READ							"read"
#define TAG_REALNAME						"realName"
#define TAG_READAHEADBLOCKS					"readAheadBlocks"
#define TAG_READCOUNT						"readCount"
#define TAG_READERCOUNT						"readerCount"
#define TAG_READFAILURES					"readFailures"
#define TAG_READLINK						"readLink"
#define TAG_READONLY						"readOnly"
#define TAG_READSIZE						"readSize"
#define TAG_REBUILD							"rebuild"
#define TAG_REBUILDCOUNT					"rebuildCount"
#define TAG_REBUILDTIME						"rebuildTime"
#define TAG_RELEASELEVEL					"releaseLevel"
#define TAG_RELEASENUMBER					"releaseNumber"
#define TAG_REMIRRORENABLED					"remirrorEnabled"
#define TAG_REMOTEDATAACCESS				"remoteDataAccess"
#define TAG_REMOTEDATAINHIBIT				"remoteDataInhibit"
#define TAG_REMOVEDENTRIES					"removedEntries"
#define TAG_REMOVABLE						"removable"
#define TAG_REMOVEALLTRUSTEES				"removeAllTrustees"
#define TAG_REMOVECONTEXT					"removeContext"
#define TAG_REMOVEENTRY						"removeEntry"
#define TAG_REMOVEEVENTEPOCH				"removeEventEpoch"
#define TAG_REMOVEPARTITION					"removePartition"
#define TAG_REMOVEPARTITIONFROMMIRROR		"removePartitionFromMirror"
#define TAG_REMOVEPOOL						"removePool"
#define TAG_REMOVEPOOLSIMPLE				"removePool2"
#define TAG_REMOVEPOOLSNAPSHOT				"removePoolSnapshot"
#define TAG_REMOVERAID						"removeRAID"
#define TAG_REMOVERAIDSIMPLE				"removeRAID2"
#define TAG_REMOVESHARE						"removeShare"
#define TAG_REMOVETRUSTEE					"removeTrustee"
#define TAG_REMOVEUSER						"removeUser"
#define TAG_REMOVEVOLUME					"removeVolume"
#define TAG_REMOVEVOLUMEFROMVLDB			"removeVolumeFromVLDB"
#define TAG_RENAMECOUNT						"renameCount"
#define TAG_RENAMEDEVICE					"renameDevice"
#define TAG_RENAMEINHIBIT					"renameInhibit"
#define TAG_RENAMEPOOL						"renamePool"
#define TAG_RENAMEPOOLSNAPSHOT				"renamePoolSnapshot"
#define TAG_RENAMERAID						"renameRAID"
#define TAG_RENAMESEQNUM					"renameSeqNum"
#define TAG_RENAMEVOLUME					"renameVolume"
#define	TAG_REPAIR							"repair"
#define TAG_REPAIRCOMPLETIONCODE			"repairCompletionCode"
#define TAG_REPAIRENDTIME					"repairEndTime"
#define TAG_REPAIRINFO						"repairInfo"
#define TAG_REPAIRLEVEL						"repairLevel"
#define TAG_REPAIRMFL						"repairMFL"
#define TAG_REPAIRPERCENTCOMPLETE			"repairPercentComplete"
#define TAG_REPAIRSTARTTIME					"repairStartTime"
#define TAG_REPAIRSTATE						"repairState"
#define TAG_REPAIRSTATUS					"repairStatus"
#define TAG_REPLACE							"replace"
#define TAG_REPLICAADDEDTOVLDB				"replicaAddedToVLDB"
#define TAG_REPLICAREMOVEDFROMVLDB			"replicaRemovedFromVLDB"
#define TAG_REPORTER						"reporter"
#define TAG_RESETEVENTLIST					"resetEventList"
#define TAG_RESETIDS						"resetIDs"
#define TAG_RESETREGISTRY					"resetRegistry"
#define TAG_RESETTIME						"resetTime"
#define TAG_RESTRIPEFLAG					"restripeFlag"
#define TAG_RESTRIPEENABLED					"restripeEnabled"
#define TAG_RESTRIPEPERCENT				"restripePercent"
#define TAG_RESTRIPERAID					"restripeRAID"
#define TAG_RESULT							"result"
#define TAG_RESUME							"resume"
#define TAG_RESYNCPARTITIONMIRROR			"resyncPartitionMirror"
#define TAG_RETRYCOUNT						"retryCount"
#define TAG_RIGHTS							"rights"
#define TAG_RIGHTSINFO						"rightsInfo"
#define TAG_ROOTBEASTINFO					"rootBeastInfo"
#define TAG_SALVAGE							"salvage"
#define TAG_SALVAGEDELETEDFILE				"salvageDeletedFile"
#define TAG_SALVAGEINFO						"salvageInfo"
#define TAG_SALVAGEVOLUME					"salvageVolume"
#define TAG_SCANDEVICES						"scanDevices"
#define TAG_SCANSALVAGEABLEFILES			"scanSalvageableFiles"
#define TAG_SCANSEQUENCE					"scanSequence"
#define TAG_SCHEDULEDPURGETIME 				"scheduledPurgeTime"
#define TAG_SECTORS							"sectors"
#define TAG_SECURE							"secure"
#define TAG_SECURITYEQUALS					"securityEquals"
#define	TAG_SEGMENT							"segment"
#define	TAG_SEGMENTS						"segments"
#define	TAG_SEGMENTID						"segmentID"
#define	TAG_SEGMENTINFO						"segmentInfo"
#define	TAG_SEGMENTNAME						"segmentName"
#define TAG_SELECTDEFAULTPATH				"selectDefaultPath"
#define TAG_SELECTED						"selected"
#define TAG_SELECTEDVICTIMS					"selectedVictims"
#define TAG_SELECTBEASTSALL					"selectBeastsAll"
#define TAG_SELECTBEASTSCRITERIA			"selectBeastsCriteria"
#define TAG_SELECTBEASTSDELETED			"selectBeastsDeleted"
#define TAG_SELECTBEASTSUNDELETED			"selectBeastsUnDeleted"
#define TAG_SELECTBEASTSFORBACKUP			"selectBeastsForBackup"
#define TAG_SELECTBEASTSFORCOMPRESSION		"selectBeastsForCompression"
#define TAG_SELECTBEASTSFORMIGRATION		"selectBeastsForMigration"
#define TAG_SELECTBEASTSPURGEABLE			"selectBeastsPurgeable"
#define TAG_SELECTBEASTSSALVAGEABLE			"selectBeastsSalvageable"
#define TAG_SELECTPATH						"selectPath"
#define TAG_SERVER							"server"
#define TAG_SERVERDEVICEINFO				"serverDeviceInfo"
#define TAG_SERVERIPADDRESS					"serverIPAddress"
#define TAG_SERVERNAME						"serverName"
#define TAG_SET								"set"
#define TAG_SETBEASTINFO					"setBeastInfo"
#define TAG_SETDFSGUID						"setDfsGUID"
#define TAG_SETDOMAINCONFIGURATION			"setDomainConfiguration"
#define TAG_SETEFLNAMESPACEID				"setEFLNameSpaceID"
#define TAG_SETFILEINFO						"setFileInfo"
#define TAG_SETINACTIVEEPOCHINTERVAL		"setInactiveEpochInterval"
#define TAG_SETPATHPRIORITY					"setPathPriority"
#define TAG_SETPATHSTATE					"setPathState"
#define TAG_SETSERVERCONFIGURATION			"setServerConfiguration"
#define TAG_SETVLDBCONFIGURATION			"setVLDBConfiguration"
#define TAG_SHAREABLE						"shareable"
#define TAG_SHARED							"shared"
#define TAG_SHARES							"shares"
#define TAG_SHAREINFO						"shareInfo"
#define TAG_SHARENAME						"shareName"
#define TAG_SHAREPATH						"sharePath"
#define TAG_SHAREVOLSBYDEFAULT				"shareVolsByDefault"
#define TAG_SHREDDATA                       "shredData"
#define TAG_SHREDDING						"shredding"
#define TAG_SHRINKABLE						"shrinkable"
#define TAG_SHRINKSIZE						"shrinkSize"
#define TAG_SHUTDOWNVLDB					"shutdownVLDB"
#define TAG_SID								"sid"
#define TAG_SIMULTANEOUSOBJECTREADCOUNT		"simultaneousObjectReadCount"
#define TAG_SIZE							"size"
#define TAG_SKIPPEDFILECOUNT				"skippedFileCount"
#define TAG_SMBSIGNATUREMODE 				"smbSignatureMode"
#define TAG_SNAPDATE						"snapDate"
#define TAG_SNAPNAME						"snapName"
#define TAG_SNAPPOOLNAME					"snapPoolName"
#define TAG_SNAPREADERCOUNT					"snapReaderCount"
#define TAG_SNAPSHOT						"snapshot"
#define	TAG_SOURCEPATH						"srcPath"
#define	TAG_SOURCEVOLUME					"srcVol"
#define	TAG_SPARSEFILES                     "sparseFiles"
#define TAG_SPACEUSED						"spaceUsed"
#define TAG_SPECIALTRUSTEES					"specialTrustees"
#define	TAG_SPLITCOUNT						"splitCount"
#define TAG_STANDARDINFO					"standardInfo"
#define TAG_STARTEVENTEPOCH					"startEventEpoch"
#define TAG_STARTIDX						"startIdx"
#define TAG_STARTINGSECTOR					"startingSector"
#define TAG_STARTREPAIR						"startRepair"
#define TAG_STARTSERVICE					"startService"
#define TAG_STATE							"state"
#define TAG_STATISTICS						"statistics"
#define TAG_STATISTICSINFO					"statisticsInfo"
#define TAG_STATUS							"status"
#define TAG_STOPEVENTEPOCH					"stopEventEpoch"
#define TAG_STOPREPAIR						"stopRepair"
#define TAG_STOPSERVICE						"stopService"
#define TAG_STORAGE							"storage"
#define TAG_STORAGEINFO                     "storageInfo"
#define TAG_STRING							"string"
#define TAG_STRIPESIZE						"stripeSize"
#define TAG_SUBALLOCATION					"suballocation"
#define TAG_SUBDIRECTORY					"subdirectory"
#define TAG_SUPERVISOR						"supervisor"
#define TAG_SUPPORTEDATTRIBUTES				"supportedAttributes"
#define TAG_SURNAME							"surname"
#define TAG_SWITCHES						"switches"
#define	TAG_SYMLINK							"symLink"
#define TAG_SYSTEM							"system"
#define TAG_SYSTEMIO						"systemIO"
#define	TAG_TARGETSERVER					"tgtServer"
#define TAG_TARGETTREE						"tgtTree"
#define	TAG_TARGETVOLUME					"tgtVol"
#define TAG_TARGETPATH						"tgtPath"
#define TAG_THREAD							"thread"
#define TAG_TIME							"time"
#define TAG_TIMEINFO						"timeInfo"
#define TAG_TIMERESTRICTIONS				"timeRestrictions"
#define TAG_TIMERESTRICTIONSALLOW			"timeRestrictionsAllow"
#define TAG_TIMERESTRICTIONSALLOWALL		"timeRestrictionsAllowAll"
#define TAG_TIMERESTRICTIONSARRAY			"timeRestrictionsArray"
#define TAG_TIMERESTRICTIONSDENY			"timeRestrictionsDeny"
#define TAG_TIMERESTRICTIONSDENYALL			"timeRestrictionsDenyAll"
#define TAG_TOTALATTEMPTS					"totalAttempts"
#define TAG_TOTALBLOCKS                     "totalBlocks"
#define TAG_TOTALBYTES						"totalBytes"
#define TAG_TOTALDATASIZE					"totalDataSize"
#define TAG_TOTALENTRIES					"totalEntries"
#define TAG_TOTALFILES						"totalFiles"
#define TAG_TOTALJUNCTIONS					"totalJunctions"
#define TAG_TOTALOBJECTS					"totalObjects"
#define TAG_TOTALREQUESTS					"totalRequests"
#define TAG_TOTALSIZE				  		"totalSize"
#define TAG_TOTALWORKSDONE					"totalWorksDone"
#define TAG_TOTALWORKSTODO					"totalWorksToDo"
#define TAG_TRANSACTION						"transaction"
#define TAG_TREE							"tree"
#define TAG_TRUSTEE							"trustee"
#define TAG_TRUSTEEINFO						"trusteeInfo"
#define TAG_TRUSTEELIST						"trusteeList"
#define TAG_TRUSTEES						"trustees"
#define TAG_TYPE							"type"
#define TAG_TYPEOFINFO						"typeOfInfo"
#define TAG_TYPESPECIFICPARENTENTRY         "typeSpecificParentEntry"
#define TAG_UCPRECIOUS						"ucPrecious"
#define TAG_UID								"uid"
#define TAG_UIDTOEQUIVALENTGUIDS			"uidToEquivalentGUIDs"
#define TAG_UNC								"unc"
#define TAG_UNCOMPBEASTDELETED				"uncompBeastDeleted"
#define TAG_UNCOMPPARENTZID					"uncompParentZid"
#define TAG_UNCOMPRESSED					"uncompressed"
#define TAG_UNCOMPRESSIBLEFILES				"uncompressibleFiles"
#define TAG_UNCOMPZID						"uncompZid"
#define TAG_UNITSIZE						"unitSize"
#define TAG_UNIXMETADATA                    "unixMetaData"
#define TAG_UNIXPERMISSIONS						"unixPermissions"
#define TAG_UNP								"unp"
#define TAG_UNUSEDENTRIES					"unusedEntries"
#define TAG_UP								"up"
#define TAG_UPDATEVLDB						"updateVLDB"
#define TAG_URL								"url"
#define TAG_USECOUNT						"useCount"
#define TAG_USEDAMOUNT						"usedAmount"
#define TAG_USEDCOMPACTIVITY				"usedCompActivity"
#define TAG_USEDDECOMPACTIVITY				"usedDecompActivity"
#define TAG_USEDENTRIES						"usedEntries"
#define TAG_USEDEPOCHS						"usedEpochs"
#define TAG_USEDSIZE						"usedSize"
#define TAG_USER							"user"
#define TAG_USERDESCRIPTION					"userDescription"
#define TAG_USERID							"userID"
#define TAG_USERIDTONAME					"userIDToName"
#define TAG_USERINFO						"userInfo"
#define TAG_USERIO							"userIO"
#define TAG_USERKEY							"userKey"
#define TAG_USERLIST						"userList"
#define TAG_USERNAME						"userName"
#define TAG_USERQUOTA						"userQuota"
#define TAG_USERREPLY						"userReply"
#define TAG_USERREQUEST						"userRequest"
#define TAG_USERSPACERESTRICTIONS			"userSpaceRestrictions"
#define TAG_USERTRANSACTION					"userTransaction"
#define	TAG_USERTRANSACTIONACTIVE           "userTransactionActive"
#define TAG_UTC								"utc"
#define TAG_VALUE							"value"
#define TAG_VARIABLEDATA					"variableData"
#define TAG_VARIABLEDATAMAC					"variableDataMac"
#define TAG_VARIABLEDATAUNIX				"variableDataUnix"
#define TAG_VARIABLEDATACOMP   				"variableDataComp"
#define TAG_VARIABLEDATAUNCOMP				"variableDataUncomp"
#define TAG_VCU								"vcu"
#define TAG_VCUABORT						"vcuAbort"
#define TAG_VCUANSWER						"vcuAnswer"
#define TAG_VCUCOPYSTAGE					"vcuCopyStage"
#define TAG_VCUDIRDEPTH						"vcuDirDepth"
#define TAG_VCUERRORS						"vcuErrors"
#define TAG_VCUINFONEW						"vcuInfoNew"
#define TAG_VCUISERRMSG						"vcuIsErrMsg"
#define TAG_VCUMESSAGE						"vcuMessage"
#define TAG_VCUMOVEDDIR						"vcuMovedDir"
#define TAG_VCUMOVEDFILE					"vcuMovedFile"
#define TAG_VCUNEWVOLNAME					"vcuNewVolName"
#define TAG_VCUPARAMETER					"vcuParameter"
#define TAG_VCURESUME						"vcuResume"
#define TAG_VCUSTATUS						"vcuStatus"
#define TAG_VCUWAITING						"vcuWaiting"
#define TAG_VERIFY							"verify"
#define TAG_VERIFYMFL						"verifyMFL"
#define TAG_VERIFYTIME						"verifyTime"
#define TAG_VERSION							"version"
#define TAG_VIRTUAL							"virtual"
#define	TAG_VIRTUALFILES                    "virtualFiles"
#define TAG_VIRTUALSERVERNAME				"virtualServerName"
#define TAG_VISIBILITY						"visibility"
#define TAG_VISIBILITYENTRY					"visibilityEntry"
#define TAG_VISIBILITYINFO					"visibilityInfo"
#define TAG_VLDB							"vldb"
#define TAG_VLDBAUTHERRORCOUNT				"vldbAuthErrorCount"
#define TAG_VLDBBUILDDATE					"vldbBuildDate"
#define TAG_VLDBCREATECOUNT					"vldbCreateCount"
#define TAG_VLDBDELETECOUNT					"vldbDeleteCount"
#define TAG_VLDBERRORCOUNT					"vldbErrorCount"
#define TAG_VLDBLOADTIME					"vldbLoadTime"
#define TAG_VLDBLOOKUPCOUNT					"vldbLookupCount"
#define TAG_VLDBMODIFYCOUNT					"vldbModifyCount"
#define TAG_VLDBSTATE						"vldbState"
#define TAG_VLDBTOTALREQUESTS				"vldbTotalRequests"
#define TAG_VOLATILE						"volatile"
#define TAG_VOLCHANGEABLEFEATURES			"volChangeableFeatures"
#define TAG_VOLDEFAULTFEATURES				"volDefaultFeatures"
#define	TAG_VOLMN							"volMn"
#define	TAG_VOLNEXTZID						"nextAllocatableZid"
#define	TAG_VOLNUMSECTORS					"volNumSectors"
#define	TAG_VOLSEGMENTS						"volSegments"
#define	TAG_VOLSTARTINGSECTOR				"volStartingSector"
#define TAG_VOLSUPPORTEDFEATURES			"volSupportedFeatures"
#define TAG_VOLUME							"volume"
#define TAG_VOLUMEADENABLED					"volumeADEnabled"
#define TAG_VOLUMEBEASTINFOFULL             "volumeBeastInfoFull"
#define TAG_VOLUMEBEASTINFOSIMPLE           "volumeBeastInfoSimple"
#define TAG_VOLUMECOMPRESSIONINFO			"volumeCompressionInfo"
#define TAG_VOLUMEENTRY						"volumeEntry"
#define TAG_VOLUMEENCRYPTED					"volumeEncrypted"
#define TAG_VOLUMEGUID						"volumeGUID"
#define TAG_VOLUMEHARDLINKS					"volumeHardlinks"
#define TAG_VOLUMEID						"volumeID"
#define TAG_VOLUMEIDFILEIDTOPATH			"volumeIDFileIDToPath"
#define TAG_VOLUMEIDTONAME					"volumeIDToName"
#define TAG_VOLUMEINFO						"volumeInfo"
#define TAG_VOLUMENAME						"volumeName"
#define TAG_VOLUMENONPURGEABLESIZE			"volumeNonPurgeableSize"
#define TAG_VOLUMEPASSWORD					"volumePassword"
#define TAG_VOLUMEPURGEABLESIZE				"volumePurgeableSize"
#define TAG_VOLUMEQUOTA						"volumeQuota"
#define TAG_VOLUMEQUOTAAVAILABLESIZE  		"volumeQuotaAvailableSize"
#define TAG_VOLUMEQUOTAFREESIZE		  		"volumeQuotaFreeSize"
#define TAG_VOLUMEQUOTATOTALSIZE	  		"volumeQuotaTotalSize"
#define TAG_VOLUMEREADAHEAD					"volumeReadAhead"
#define TAG_VOLUMES							"volumes"
#define TAG_VOLUMESTATE						"volumeState"
#define TAG_VOLUMEUNAVAILABLESIZE	  		"volumeUnavailableSize"
#define TAG_VOLUMEUSEDSIZE			  		"volumeUsedSize"
#define TAG_WINSIPADDRESS					"winsIPAddress"
#define TAG_WRITE							"write"
#define TAG_WRITEABLE						"writeable"
#define TAG_WRITECOUNT						"writeCount"
#define TAG_WRITERCOUNT						"writerCount"
#define TAG_WRITEFAILURES					"writeFailures"
#define TAG_WRITESIZE						"writeSize"
#define TAG_ZERROR							"zError"
#define TAG_ZID								"zid"


#define ATR_COMPATIBLE						"compatible"
#define ATR_COMPLETE						"complete"
#define ATR_COUNT							"count"
#define ATR_ENABLED							"enabled"
#define ATR_EPOCHNUMBER						"epochNumber"
#define ATR_GETCOMPBEASTINFO                "getCompBeastInfo"
#define ATR_ID								"id"
#define ATR_ID1								"id1"
#define ATR_ID2								"id2"
#define ATR_ID3								"id3"
#define ATR_LOOKUP							"lookup"
#define ATR_NAME							"name"
#define ATR_NAMESPACE						"nameSpace"
#define ATR_NUMADDERRORS					"numAddErrors"
#define ATR_NUMDELETEERRORS					"numDeleteErrors"
#define ATR_NUMEXTRAENTRIES					"numExtraEntries"
#define ATR_NUMMISSINGENTRIES				"numMissingEntries"
#define ATR_NUMMODIFIEDFILES				"numModifiedFiles"
#define ATR_OPERATION						"operation"
#define ATR_QUOTA							"quota"
#define ATR_READAHEAD						"readAhead"
#define ATR_STATE							"state"
#define ATR_SYNTAX							"syntax"
#define ATR_TYPE							"type"
#define ATR_VALUE							"value"

#endif  /* _XMLTAGS_H_ */
