/****************************************************************************
 |
 |	(C) Copyright 2001  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 NetWare Storage Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: taysom $
 | $Date: 2006-12-13 05:04:43 +0530 (Wed, 13 Dec 2006) $
 |
 | $RCSfile$
 | $Revision: 1760 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Define the message structures used by NSS and the bit masks and
 |		other values used by NSS APIs.
 +-------------------------------------------------------------------------*/
#ifndef _ZMSG_H_
#define _ZMSG_H_

#ifndef _ZOMNI_H_
#	include <zOmni.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

	/*
	 * Key properties.  'm' added because of conflicts with NWREG.H.
	 */
#define mKEY_NOTIFY			0x1
#define mKEY_DUPLICATE		0x2
#define mKEY_1_USE			0x4
#define mKEY_PASS_1_USE		0x8
#define mKEY_PASS_N_USE		0x10
#define mKEY_PASS_ANY		(mKEY_PASS_1_USE | mKEY_PASS_N_USE)
#define mKEY_REMOTE			0x20
#define mKEY_DYING			0x40
#define mKEY_DESTRUCT		0x80

/* Valid properties when creating a door */
#define mKEY_VALID_PROPERTIES	(mKEY_NOTIFY | mKEY_DUPLICATE | mKEY_1_USE	\
									| mKEY_PASS_ANY)

#define INVALID_KEY			0


/********************
 * Message Structure
 * The following definitions of SystemMsg structure have been designed to
 * allow application compiled on a 32 bit little-endian machine work on
 * a 64 bit little-endian machine.
 */

#define MAX_DATA_AREAS	2

#ifdef __LP64__
	#define zPADDING(_x)
#else
	#define zPADDING(_x)	LONG	padding ## _x ;
#endif

struct kernelDataArea_s
{
	void	*start;
	zPADDING(start);
	NINT	length;
	zPADDING(length);
};

struct kernelSystemMsg_s
{
	STATUS				status;		/* Status of the operation				*/
									/* Placed first to match genMsg			*/
	BYTE				numDataAreas;/* Number of data areas				*/
	BYTE				readMask;	/* Data areas that are readable			*/
	BYTE				writeMask;	/* Data areas that are writeable		*/
	BYTE				padding[1];

	char				*where;		/* Where in the code the status was set	*/
	zPADDING(where)

	Key_t				passedKey;	/* Key that was passed with the request	*/

	struct mDoor_s		*door;		/* Door/obj msg was send through		*/
	zPADDING(door)

	struct mManager_s	*owner;		/* Owner of the object					*/
	zPADDING(owner)

	struct kernelDataArea_s	data[MAX_DATA_AREAS];

	voidfunc_t			callback;	/* Call back function					*/
	zPADDING(callback)
};

struct userDataArea_s
{
	QUAD	start;
	QUAD	length;
};

struct userSystemMsg_s
{
	STATUS				status;		/* Status of the operation				*/
									/* Placed first to match genMsg			*/
	BYTE				numDataAreas;/* Number of data areas				*/
	BYTE				readMask;	/* Data areas that are readable			*/
	BYTE				writeMask;	/* Data areas that are writeable		*/
	BYTE				padding[1];

	QUAD				where;		/* Where in the code the status was set	*/
	Key_t				passedKey;	/* Key that was passed with the request	*/
	QUAD				door;		/* Door/obj msg was send through		*/
	QUAD				owner;		/* Owner of the object					*/
	struct userDataArea_s	data[MAX_DATA_AREAS];
	QUAD				callback;	/* Call back function					*/
};

#ifdef __KERNEL__
typedef struct kernelDataArea_s		mDataArea_s;
typedef struct kernelSystemMsg_s	mSystemMsg_s;
#else
typedef struct userDataArea_s		mDataArea_s;
typedef struct userSystemMsg_s		mSystemMsg_s;
#endif

enum {	DATA_AREA_CORRECT =
		1 / (sizeof(struct kernelDataArea_s) == sizeof(struct userDataArea_s)),
		SYSTEM_MSG_CORRECT =
		1 / (sizeof(struct kernelSystemMsg_s) == sizeof(struct userSystemMsg_s))
};
		

	/* This number should be small but engineered to the
	 * system, so the message can be passed in registers
	 * on a machine with a reasonable number of registers.
	 * (Remember, the header will have to passed in the
	 * registers too).
	 */
#define MSG_BODY_SIZE	128

typedef union mBody_u
{
	QUAD	quad[MSG_BODY_SIZE/sizeof(QUAD)];
	LONG	ulng[MSG_BODY_SIZE/sizeof(LONG)];
	WORD	word[MSG_BODY_SIZE/sizeof(WORD)];
	BYTE	byte[MSG_BODY_SIZE/sizeof(BYTE)];
} mBody_u;

typedef struct Msg_s
{
	mSystemMsg_s	sys;
	mBody_u			body;
} Msg_s;

#ifdef __cplusplus
}
#endif

#endif
