/****************************************************************************
 |
 |	(C) Copyright 2005-2006, 2013-2015 Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 Novell Storage Services (NSS) support module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: kpraveen $
 | $Date: 2015-02-05 05:24:24 +0530 (Thu, 05 Feb 2015) $
 |
 | $RCSfile$
 | $Revision: 5389 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Defines the <name, value> pairs for the netware extended attributes.
 +-------------------------------------------------------------------------*/

#ifndef _ZXATTR_H_
#define _ZXATTR_H_ 1

#ifndef _ZOMNI_H_
#include <zOmni.h>
#endif

#define zNW_PREFIX		"netware."
#define zNW_NCPSTAT		zNW_PREFIX "ncpstat"
#define zNW_QUOTA		zNW_PREFIX "quota"
#define zNW_METADATA	zNW_PREFIX "metadata"
#define zNW_USERQUOTA	zNW_PREFIX "userquota"
#define zNW_NAME	zNW_PREFIX "name"
//#define zNW_TRUSTEE		zNW_PREFIX "trustee"

#define zNW_BYTEORDER			0xfeff
#define zNW_NCPSTAT_VERSION_1	1
#define zNW_NCPSTAT_VERSION_2	2
#define zNW_NCPSTAT_VERSION		2
#define zNW_QUOTA_VERSION		3
#define zNW_METADATA_VERSION	1
#define zNW_USERQUOTA_VERSION	1
//#define zNW_TRUSTEE_VERSION		1

#define zNW_ALLOWED_MODIFY_FLAGS	(zMOD_FILE_ATTRIBUTES		\
										| zMOD_CREATED_TIME		\
										| zMOD_MODIFIED_TIME	\
										| zMOD_ACCESSED_TIME)

#define zVALID_MOD_NCPSTAT_V1_FLAGS	zNW_ALLOWED_MODIFY_FLAGS
#define zVALID_MOD_NCPSTAT_V2_FLAGS	(zVALID_MOD_NCPSTAT_V1_FLAGS		\
										| zMOD_OWNER_ID					\
										| zMOD_MODIFIER_ID				\
										| zMOD_METADATA_MODIFIER_ID		\
										| zMOD_METADATA_MODIFIED_TIME	\
										| zMOD_DONT_UPDATE_METADATA_MODIFIED_TIME)

typedef struct zNW_ncpstat_s {
	WORD	nws_byteorder;
	WORD	nws_version;
	LONG	nws_reserved_1;
	QUAD	nws_info_mask;		/* Modify information indicated by mask
								 * (see zVALID_MOD_NCPSTAT_V*_FLAGS) */
	QUAD	nws_file_attributes;/* All the NSS file attributes (see zParams.h) */
	QUAD	nws_file_attr_mask;	/* All the NSS file attributes */

	QUAD	nws_zid;			/* File ID, for hard links, this will be the secondary zid */
	QUAD	nws_zid_primary;	/* Primary ZID */
	QUAD	nws_zid_parent;		/* File id of parent */

	GUID_t	nws_volume_id;		/* 128 bit volume id */

	QUAD	nws_size_logical;	/* Logical size of the file in bytes */
	QUAD	nws_size_physical;	/* Physical size of the file in bytes */

	QUAD	nws_created;		/* UTC time created */
	QUAD	nws_modified;		/* UTC time modified */
	QUAD	nws_accessed;		/* UTC time last accessed */
/* version 2 members begin here */
	QUAD	nws_time_metadata_modified;

#define nws_time_created nws_created
#define nws_time_modified nws_modified
#define nws_time_accessed nws_accessed

	zNW_user_s	nws_id_owner;
	zNW_user_s	nws_id_modifier;
	zNW_user_s	nws_id_metadata_modifier;
} zNW_ncpstat_s;

typedef struct zNW_quota_V1_s {
	WORD	nwq_byteorder;
	WORD	nwq_version;
	LONG	nwq_reserved_1;
	QUAD	nwq_user_used;	/* Quota used by user */
	QUAD	nwq_user_limit;	/* Quota limit assigned to user */
	QUAD	nwq_dir_left;	/* Quota min left in directory ancestors */
} zNW_quota_V1_s;

typedef struct zNW_quota_s {
	WORD	nwq_byteorder;
	WORD	nwq_version;
	LONG	nwq_reserved_1;
	QUAD	nwq_user_used;	/* Quota used by user */
	QUAD	nwq_user_limit;	/* Quota limit assigned to user */
	QUAD	nwq_dir_left;	/* Quota min left in directory ancestors */
	QUAD	nwq_dir_quota;	/* Quota set on the directory */
	QUAD	nwq_vol_unavailable;  /* Unavailable space in the volume (total - used) where used = (inuse - purgeable) */
	QUAD	nwq_vol_available;   /* Available space in the volume (free + purgeable) */
} zNW_quota_s;

/* 
 * We have picked a value for zMAX_TRUSTEES that will let the 
 * structure fit in 64K.
 */
#define zMAX_TRUSTEES	2043

typedef struct zNW_trustee_s {
	GUID_t	nwt_id;
	QUAD	nwt_rights;
	QUAD	nwt_reserved_2;
} zNW_trustee_s;

/*
The positions of nwm_byteorder and nwm_version between zNW_metadata_s and zNW_metadata2_s must match
so that the input / output structures during netware.metadata or netware.metadata2 xattr calls can be
mapped and appropriate choice can be made.
*/

typedef struct zNW_metadata_s {
	WORD	nwm_byteorder;
	WORD	nwm_version;
	LONG	nwm_reserved_1;
	QUAD	nwm_modify_mask;
	QUAD	nwm_file_attributes;
	QUAD	nwm_file_attributes_mask;

	QUAD	nwm_time_created;
	QUAD	nwm_time_archived;
	QUAD	nwm_time_modified;
	QUAD	nwm_time_accessed;

	QUAD	nwm_time_meta_data_modified;
	QUAD	nwm_reserved_2;
	GUID_t	nwm_id_owner;

	GUID_t	nwm_id_archiver;
	GUID_t	nwm_id_modifier;

	GUID_t	nwm_id_metadata_modifier;
	SQUAD	nwm_quota_limit;
	LONG	nwm_inherited_rights_mask;
	LONG	nwm_trustee_num;

	zNW_trustee_s	nwm_trustee[zMAX_TRUSTEES];
} zNW_metadata_s;

/* 
 * We have picked a value for zMAX_USERS that will let the 
 * structure fit in 64K.
 */
#define zMAX_XATTR_USERS	2047

typedef struct zNW_user_restriction_s {
	GUID_t		nwur_user;
	SQUAD		nwur_restriction;
	QUAD		nwur_reserved_2;
} zNW_user_restriction_s;

typedef struct zNW_user_quota_s {
	WORD	nwuq_byteorder;
	WORD	nwuq_version;
	LONG	nwuq_num_users;
	LONG	nwuq_index;
	LONG	nwuq_reserved_1;

	zNW_user_restriction_s nwuq_user[zMAX_XATTR_USERS];
} zNW_user_quota_s;


#if 0
#define	zMAX_FDN_NAME				256
#define zMAX_XATTR_USERS			124

typedef struct zNW_user_restriction_s {
	QUAD		nwur_restriction;
	QUAD		nwur_reserved_2;
	unicode_t	nwur_dnsname[zMAX_FDN_NAME];
} zNW_user_restriction_s;

typedef struct zNW_user_quota_s {
	WORD	nwuq_byteorder;
	WORD	nwuq_version;
	LONG	nwuq_num_users;
	LONG	nwuq_index;
	LONG	nwuq_reserved_1;

	zNW_user_restriction_s nwuq_user[zMAX_XATTR_USERS];
} zNW_user_quota_s;

typedef struct zNW_user_trustee_s{
	QUAD		nwut_rights;
	QUAD		nwut_reserved_2;
	unicode_t	nwut_dnsname[zMAX_FDN_NAME];
} zNW_user_trustee_s;

typedef struct zNW_trustee_name_s {
	WORD	nwtn_byteorder;
	WORD	nwtn_version;
	LONG	nwtn_num_trustees;
	LONG	nwtn_index;
	LONG	nwtn_reserved_1;

	zNW_user_trustee_s nwtn_user[zMAX_XATTR_USERS];
} zNW_trustee_name_s;
#endif

/*
We are skipping the version 1 for zNW_metadata2_s and directly moving to version 2.
This is done because we map the version 2 of zNW_metadata_s to zNW_metadata2_s and it will
be easier and better for us to have same version across.
*/

#define zNW_METADATA2_VERSION 2
#define zMAX_TRUSTEES2	740
#define zNW_METADATA2 zNW_PREFIX "metadata2"

typedef struct zNW_trustee2_s {
	zNW_user_s	nwt_id;
	QUAD		nwt_rights;
	QUAD		nwt_reserved_2;
} zNW_trustee2_s; // 88 bytes

/*
The positions of nwm_byteorder and nwm_version between zNW_metadata_s and zNW_metadata2_s must match
so that the input / output structures during netware.metadata or netware.metadata2 xattr calls can be 
mapped and appropriate choice can be made.
*/

typedef struct zNW_metadata2_s {
	WORD		nwm_byteorder;
	WORD		nwm_version;
	WORD            nwm_trustee_more;
	WORD		nwm_reserved_1;
	QUAD		nwm_modify_mask;
	QUAD		nwm_file_attributes;
	QUAD		nwm_file_attributes_mask; //32 bytes

	QUAD		nwm_time_created;
	QUAD		nwm_time_archived;
	QUAD		nwm_time_modified;
	QUAD		nwm_time_accessed; //64 bytes

	QUAD		nwm_time_meta_data_modified;
	QUAD		nwm_reserved_2; //80 bytes

	zNW_user_s	nwm_id_owner;
	zNW_user_s	nwm_id_archiver;
	zNW_user_s	nwm_id_modifier;
	zNW_user_s	nwm_id_metadata_modifier; //368 bytes

	SQUAD		nwm_quota_limit;
	LONG		nwm_inherited_rights_mask;
	LONG		nwm_trustee_num; // 384 bytes

	zNW_trustee2_s	nwm_trustee[zMAX_TRUSTEES2]; // 740*88 bytes
} zNW_metadata2_s;

#define zNW_EFFECTIVERIGHTS_VERSION 1

typedef struct zNW_effectiverights_s {
	WORD 		nwer_byteorder;
 	WORD 		nwer_version;
 	LONG 		isVisible; // 1 if visible
 	NINT 		nwer_effectiverights;
}zNW_effectiverights_s;

#define zNW_USERQUOTA2	zNW_PREFIX "userquota2"
#define zMAX_XATTR_USERS2 744
#define zNW_USERQUOTA2_VERSION	1

typedef struct zNW_user_restriction2_s {
	zNW_user_s	nwur_user;
	SQUAD		nwur_restriction;
	QUAD		nwur_reserved_2;
} zNW_user_restriction2_s; //88bytes

typedef struct zNW_user_quota2_s {
	WORD	nwuq_byteorder;
	WORD	nwuq_version;
	LONG	nwuq_num_users;
	LONG	nwuq_index;
	LONG	nwuq_reserved_1; //16 bytes

	zNW_user_restriction2_s nwuq_user[zMAX_XATTR_USERS2]; //744*88 bytes
} zNW_user_quota2_s;

#define zMAX_DOS_COMPONENT_NAME (8+1+3+1)
typedef struct zNW_name_s {
	unicode_t macname[zMAX_COMPONENT_NAME];
	unicode_t unixname[zMAX_COMPONENT_NAME];
	unicode_t longname[zMAX_COMPONENT_NAME];
	unicode_t dosname[zMAX_DOS_COMPONENT_NAME];
} zNW_name_s;

#endif
