/*************************************************************************

  Copyright (c) 1995, 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   INETADDR.C
***************************************************************************

  INETADDR.C displays information from the specified server.  Included in 
  the list are company name, revision, revision date, copyright, number 
  of connections and the internet address (network address, node address, 
  and socket) of each object connected to the server.

  USAGE:  INETADDR <server name)
          
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <nwcalls.h>
#include <nwnet.h>

int main (int argc, char *argv[])
{
   NWCONN_HANDLE   connHandle;
   NWCCODE         ccode;
   NWINET_ADDR     addr;
   NWCONN_NUM      i;
   nuint16         suMaxConnects;
   nuint32         luID;
   nstr8           strName[130];
   nstr8           strCName[80], strCopy[80];
   nstr8           strRev[80], strRevDate[80];
   nstr8           strServer[NW_MAX_SERVER_NAME_LEN];

   if(argc != 2)
   {
      printf("\nUsage:  INETADDR <server name>\n");
      exit(1);
   }

   ccode = NWCallsInit(NULL,NULL);
   if(ccode)
   {
      printf("\nNWCallsInit returned %04X", ccode);
      exit(1);
   }

   strcpy(strServer, strupr(argv[1]));

   ccode = NWGetConnectionIDFromName(
             /* length of server name */ (nuint32)strlen(strServer),
             /* server name           */ (nuint8 *)strServer,
             /* handle to server      */  &connHandle);
   if(ccode)
   {
      printf("\nNWGetConnectionIDFromName returned %04X", ccode);
      exit(1);
   }

   ccode = NWGetFileServerDescription(
             /* handle to server  */  connHandle,
             /* company name      */  strCName,
             /* NetWare ver/rev   */  strRev,
             /* revision date     */  strRevDate,
             /* copyright string  */  strCopy);
   if(ccode)
   {
      printf("\nNWGetFileServerDescription returned %04X", ccode);
      exit(1);
   }

   printf("\nCompany Name          :  %s\
           \nRev                   :  %s\
           \nRev Date              :  %s\n",
           strCName, strRev, strRevDate);

   /* Only interested in MaxConnections, pass in NULL to other fields */
   ccode = NWGetFileServerInformation(
              /* handle to server */  connHandle,
              /* server name      */  NULL,
              /* major version #  */  NULL,
              /* minor version #  */  NULL,
              /* rev              */  NULL,
              /* max conns        */  &suMaxConnects,
              /* max conns used   */  NULL,
              /* conns in use     */  NULL,
              /* num volumes      */  NULL,
              /* SFT level        */  NULL,
              /* TTS level        */  NULL);
   if(ccode)
   {
      printf("\nNWGetFileServerInformation returned %04X", ccode);
      exit(1);
   }

   printf("Number of Connections :  %d\n\n", suMaxConnects);
   printf("Copyright Notice:\n%s\n\n", strCopy);

   for(i = 0; i < suMaxConnects; i++)
   {
      ccode = NWGetConnectionInformation(
                /* handle to server   */  connHandle,
                /* server conn number */  i,
                /* object name        */  strName,
                /* object type        */  NULL,
                /* object ID          */  &luID,
                /* Login Time         */  NULL);

      if((ccode == 0) && (luID != 0L))
      {
         ccode = NWGetInetAddr(connHandle, i, &addr);

         printf ("%d ", i);

         if(ccode == 0)
         {
            printf("%02X%02X%02X%02X:%02X%02X%02X%02X%02X%02X:%04X ",
                    addr.networkAddr[0], addr.networkAddr[1],
                    addr.networkAddr[2], addr.networkAddr[3],
                    addr.netNodeAddr[0], addr.netNodeAddr[1],
                    addr.netNodeAddr[2], addr.netNodeAddr[3],
                    addr.netNodeAddr[4], addr.netNodeAddr[5],
                    addr.socket);

            switch(addr.connType)
            {
               case 0:
               {   
                  printf ("%d ", addr.connType);
                  break;
               }
               case 2:
               {   
                  printf ("NCP ");
                  break;
               }
               case 3:
               {   
                  printf ("AFP ");
                  break;
               }
            }
         }
         else
         {
            printf ("Could not get address  ");
         }

         printf ("%s\n", strName);
      }
   }
   return(0);
}


