/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXSSCAN.C
**************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <assert.h>

void main(void)
{
   pCONVERT pconv;
   nint     icode;
   nuint    actualLen;
   nuint8   *byteIn = "abc[2620]";
   unicode  uniOut[80];

   /* Load a byte/uni converter for the current code page.
      Error checking not shown. */
   icode = NWUXLoadByteUnicodeConverter(0, &pconv);

   /* This conversion recognizes the special byte sequence "[2620]"
      and converts it to a single unicode character.  */
   icode = NWUXByteToUnicode( pconv, uniOut, 80, byteIn, &actualLen );
   assert( icode == 0  &&  uniOut[3] == 0x2620 && actualLen == 4);

   /* Disable the scan action for byte-to-unicode conversion.
      This causes it to not scan for special "[nnnn]" byte sequences.
      The scan action for unicode-to-byte conversion is left unchanged.
   */
   icode = NWUXSetScanAction(pconv, NWU_DISABLED, NWU_UNCHANGED_ACTION);
   if (icode)
      printf("NWUXSetScanAction returned error 0x%04X\n",icode);

   /* This conversion does not recognize the special byte sequence
      and just converts it to the unicode string "abc[2620]". */
   icode = NWUXByteToUnicode( pconv, uniOut, 80, byteIn, &actualLen);
   assert( icode == 0  &&  uniOut[3] == '[' && actualLen == 9);

   NWUXUnloadConverter(pconv);
} 


