/*************************************************************************

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  OEMEURO.C
***************************************************************************

  OEMEURO.C is a sample program that demonstrates how to enable a 
            Unicode converter to convert the Euro character from
            Unicode (0x20AC) to OEM codepage (0xCC). This is the
            behavior of the NetWare redirector on the client. It
            allows files and directories to be created and named
            on the NetWare server from Windows utilities and applications 
            using the Euro character.

  USAGE:  OEMEURO

**************************************************************************/
 
#include <nunicode.h> 
#include <stdio.h>
#include <string.h>
#include <assert.h>  

void main(void) 
{    
   nuint    codePage = 437;    /* U.S. OEM code page in this example. */
   pCONVERT pConv;    
   nint     icode;    
   unicode  uniStr[]  = {'T','h','e',' ','E','u','r','o',':', 0x20AC, 0x0000};
   nuint8   byteStr[] = {'T','h','e',' ','E','u','r','o',':', 0xCC, 0x00};
   nuint8   byteBuf[32];
   unicode  uniBuf[16];
   
   /* 
      Load a byte/uni converter, returning a handle to the converter.       
      Error checking not shown. 
   */
   icode = NWUXLoadByteUnicodeConverter(codePage, &pConv);     
   if (0 != icode)
   {
      printf("NWUXLoadByteUnicodeConverter: 0x%04x\n", icode);
      return;
   }

   /* Enable converter for Euro */
   icode = NWUXEnableOemEuro(pConv);
   assert(0 == icode);

   /* Convert Unicode text (with Euro) to codepage 437 */
   icode = NWUXUnicodeToByte(pConv, byteBuf, sizeof(byteBuf), uniStr, NULL);
   assert(0 == icode);
   assert(strcmp(byteStr, byteBuf) == 0);

   /* Convert multi-byte string (with Euro) to Unicode */
   icode = NWUXByteToUnicode( pConv, uniBuf, sizeof(uniBuf), byteStr, NULL);     
   assert(0 == icode);
   assert(unicmp(uniStr, uniBuf) == 0);

   printf("Conversion was successful.\n");
   NWUXUnloadConverter(pConv);
}

