/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  NCPSCAN.C
***************************************************************************

  This example demonstrates how to list registered NCP extensions using
  NWScanNCPExtensions (NLM).

**************************************************************************/
      
#include <stdio.h> 
#include <stdlib.h>
#include <nlm\nwncpx.h> 

int main(void) 
{ 
   BYTE majorVersion, minorVersion, revision; 
   char NCPExtensionName[MAX_NCP_EXTENSION_NAME_BYTES]; 
   int  cCode; 
   LONG NCPExtensionID = BEGIN_SCAN_NCP_EXTENSIONS; /* -1 */ 

   do
   { 
      cCode = NWScanNCPExtensions(&NCPExtensionID, NCPExtensionName,
                                  &majorVersion, &minorVersion, &revision, 
                                  NULL); 
      if(cCode == 0) 
      { 
         printf("\nExtension Name = %s, Extension ID = %lX",
                NCPExtensionName, NCPExtensionID); 
         printf("\nMajor Version = %d, Minor Version = %d, Revision = %d\n", 
                 majorVersion, minorVersion, revision); 
      }
   } 
   while(cCode != -1); 

   return(0);
} 
