/*************************************************************************

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   CHGPASS.C
***************************************************************************

  CHGPASS.C is a small example application that changes the password
  for a given user.

  USAGE:  CHGPASS <servername> <username> <new password>

**************************************************************************/

#include <stdio.h>
#include <string.h>

#include <nwcalls.h>
#include <nwclxcon.h>
   
void main(int argc, char *argv[ ])
{
   NWCONN_HANDLE   connHandle;
   NWCCODE         ccode;
   char            server[50],
                   objectName[50],
                   oldPassword[128],
                   newPassword[128];

   /* Check Usage */
   if (argc != 4)
   {
      printf("\nUsage: %s <server name> <username> <new password>\n", 
             strupr(argv[0]));
      printf("Note: must be logged into server you change password on.\n\n");
      return;
   }

   /* Get command-line arguments */
   oldPassword[0] = '\0';                /* ... or enter the old password */
   strcpy(server, strupr(argv[1]));      /* servers name                  */
   strcpy(objectName, strupr(argv[2]));  /* user name is upper case       */
   strcpy(newPassword, strupr(argv[3])); /* password is upper case        */


   /* Library initialization */
   ccode = NWCallsInit(NULL, NULL);
   if (ccode)
   {
      printf ("NWCallsInit failed with error=0x%04x\n",ccode);
      return;
   }

   ccode = NWCLXInit(NULL, NULL);
   if (ccode)
   {
      printf ("NWCLXInit failed with error=0x%04x\n",ccode);
      return;
   }

   ccode = NWCCOpenConnByName( 
             /* > Handle to resolve name */  0, 
             /* > Server name            */  server,
             /* > Server name format     */  NWCC_NAME_FORMAT_BIND, 
             /* > Connection open state  */  NWCC_OPEN_LICENSED, 
             /* > Transport Type         */  NWCC_TRAN_TYPE_WILD,
             /* < Connection Handle      */  &connHandle);
   if (ccode)
   {
      printf("NWCCOpenConnByName failed with error=0x%04x\n",ccode);
      return;
   }

   ccode = NWChangeObjectPassword(
             /* > connection Handle      */  connHandle,
             /* > user name              */  objectName,
             /* > Bindery object         */  OT_USER,
             /* > Old password or NULL   */  oldPassword,
             /* > New password           */  newPassword);

   /* Report success or failure */
   if (ccode)
   {
      printf ("NWChangObjectPassword failed with error=0x%04x\n",ccode);
   }
   else
   {
      printf("\nPassword has been changed.\n");
   }

   /* Clean-up */                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         
   ccode = NWCCCloseConn(connHandle);
   if (ccode)
   {
      printf("NWCCCloseConn failed with error=0x%04x\n", ccode);
   }
}
