#include <stdio.h>
#include "nwcalls.h"
#include "nwclxcon.h"

int main(int argc, char * argv[])
{

	NWCONN_HANDLE connHandle; 
	NWCCODE ccode;
	NWRCODE rcode;
	NWFSE_ACTIVE_LAN_BOARD_LIST N_FAR LANBoardList;
	NWFSE_MLID_BOARD_INFO MLIDBoardInfo;
   int i, j;

	if(argc < 2)
	{
		printf("Usage:gtmlidin serverName\n");
      printf("scnsentr KAO_IP\n");
		return -1;
	}


	ccode = NWCallsInit(NULL, NULL);
	if(0 != ccode)
	{
		printf("NWCALLSINIT is failed.\n");
		return -1;
	}
	
   rcode = NWCCOpenConnByName(0,
		                        argv[1],
							         NWCC_NAME_FORMAT_BIND,
							         NWCC_OPEN_PUBLIC,
							         NWCC_TRAN_TYPE_WILD,
							         &connHandle);

   if(0 == rcode)
   {
      /* 
         sencond parameter of NWGetActiveLANBoardList will normally be 0, 
         unless the amount of LAN Boards is greater than FSE_MAX_NUM_OF_LANS. 
         To return the extra, set startNum  to LANLoadedCount + 1.
      */
      ccode = NWGetActiveLANBoardList(connHandle,
		                                0,
									           &LANBoardList);
      if(0 == ccode)
      {
         printf("List of protocols:\n");
	      for(j = 0; j < (int)LANBoardList.LANLoadedCount; j++)
         {
            ccode = NWGetMLIDBoardInfo(connHandle,
                                       LANBoardList.boardNums[j],
                                       &MLIDBoardInfo);
            if(0 == ccode)
            {
               for(i = 0; i < MLIDBoardInfo.numberProtocols; i++)
               {
                  /* 
                     MLIDBoardInfo.MLIDBoardInfo[i].protocolName is 
                     a length preceding string 
                  */
                  printf("%s\n",MLIDBoardInfo.MLIDBoardInfo[i].protocolName + 1);
               }
            }
         }
      }

	   NWCCCloseConn(connHandle);
   }
   
   NWCallsTerm(NULL);
   return 0;
}