/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXBUNI.C
**************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <assert.h>

void main(void)
{
   nuint    codepage = 437;  /* U.S. OEM code page in this example. */
   pCONVERT pconv;
   nint     icode;
   nuint    actualLen;
   pnuint8  byteIn = "The skull and crossbones character: [2620]";
   unicode  uniOut[80];

   /* Load a byte/uni converter, returning a handle to the converter.
      Error checking not shown. */
   icode = NWUXLoadByteUnicodeConverter(codepage, &pconv);


/* Example 1:  Convert using the default converter behavior.
   The byte sequence "[2620]" is converted to a single unicode character.
*/

   icode = NWUXByteToUnicode( pconv, uniOut, 80, byteIn, &actualLen );

   if (icode)
      printf("NWUXByteToUnicode returned error: %04X\n", icode);
   else
      assert(uniOut[36] == 0x2620 && actualLen == 37);


/* Example 2:  Change the behavior of this converter to disable the
      the automatic conversion of "[nnnn]" to a unicode character.
      The "[2620]" sequence will just be converted normally to 6
      unicode characters '[', '2', '0', '2', '6', ']'.
*/

   /* Disable byte-to-uni filtering, don't change uni-to-byte behavior.
      Error checking from this routine not shown. */
   NWUXSetScanAction(pconv, NWU_DISABLED, NWU_UNCHANGED_ACTION);

   /* This conversion should produce the unicode string:
          "The skull and crossbones character: [2620]"
   */
   icode = NWUXByteToUnicode( pconv, uniOut, 80, byteIn, &actualLen );

   if (icode)
      printf("NWUXByteToUnicode returned error: %04X\n", icode);
   else
      assert(uniOut[36] == '[' && actualLen == 42);

   NWUXUnloadConverter(pconv);
} 


