/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXCHARSZ.C
**************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <assert.h>

void main(void)
{
   nuint    codepage = 932;    /* Japanese code page */
   pCONVERT pconv;
   nint     icode;
   nuint    charSize;
   nuint8   byteString[4] = { 'a', 0x82, 0xFE, 0 };
   pnuint8  inputPtr = byteString;

   /* Load a byte/uni converter, returning a handle to the converter.
      Error checking not shown. */
   icode = NWUXLoadByteUnicodeConverter(codepage, &pconv);

   /*
      The first byte of the input string should return size=1.
   */
   icode = NWUXGetCharSize( pconv, inputPtr, &charSize );
   assert (icode == 0 && charSize == 1);

   /*
      The next character is a double-byte character.
      Should return size=2.
   */
   inputPtr += charSize;
   icode = NWUXGetCharSize( pconv, inputPtr, &charSize );
   assert (icode == 0 && charSize == 2);

   NWUXUnloadConverter(pconv);
} 



