/*************************************************************************

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  EXUNIB.C
***************************************************************************

  Convert a unicode string to a byte string. 

**************************************************************************/

#include <nunicode.h>
#include <stdio.h>
#include <assert.h>
#include <string.h>

void main(void)
{
   nuint    codepage = 437;    /* U.S. OEM code page in this example. */
   pCONVERT pconv;
   nint     icode;
   nuint    actualLen;
   unicode  uniIn[5] = { 'a', 'b', 'c', 0x2620, 0};
   nuint8   byteOut[80];

   /* Load a byte/uni converter, returning a handle to the converter.
      Error checking not shown. */
   icode = NWUXLoadByteUnicodeConverter(codepage, &pconv);


/* Example 1:  Convert using the default converter behavior.
   The unmappable unicode 0x2620 character is converted to the
   6-byte string "[2620]".
*/
   icode = NWUXUnicodeToByte( pconv, byteOut, 80, uniIn, &actualLen );

   if (icode)
      printf("NWUXUnicodeToByte returned error: %04X\n", icode);
   else
      assert(strcmp(byteOut,"abc[2620]")==0 && actualLen==9);


/* Example 2:  Change the behavior of this converter to return an
   error if an unmappable character is encountered.  Leave behavior
   for byte-to-uni unmappable character unchanged.
   Error checking not shown.
*/
   icode = NWUXSetNoMapAction( pconv, NWU_UNCHANGED_ACTION,
                               NWU_RETURN_ERROR );

   /* This should return an error due to the unmappable uni char 0x2620 */
   icode = NWUXUnicodeToByte( pconv, byteOut, 80, uniIn, &actualLen );

   assert(icode == NWU_UNMAPPABLE_CHAR && actualLen == 3);


   NWUXUnloadConverter(pconv);
} 


