/*************************************************************************

  Copyright (c) 2000 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
  UTF8.C
***************************************************************************

  This example shows how to convert text from Unicode to UTF-8 and back to
  demonstrate the use of NWLUnicodeToUTF8Size, NWLUnicodeToUTF8, 
  NWLUTF8ToUnicodeSize, and NWLUTF8ToUnicode.
  
  Uses the Unicode test string "This is a test". First the string is
  converted from Unicode to UTF-8. Then it is converted from UTF-8
  to Unicode. unicmp() is used to verify that the round-trip conversion
  was done correctly.

  Expected Output:
                   NWLUnicodeToUTF8Size() returned 15
                   NWLUnicodeToUTF8() was successful: 'This is a test'
                   NWLUTF8ToUnicodeSize() passed back 30
                   UNLUTF8ToUnicode() was successful

**************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include <unicode.h>
#include <assert.h>


void main (int argc, char *argv[])
{
   unicode          sourceStr[] = L"This is a test";
   unicode        * uniPtr;
   char           * utf8Ptr;
   nuint            utf8Size;
   nuint            uniSize;
   nint             ccode;


   /* 
    * Convert string from Unicode to UTF-8 
    */
   utf8Size = NWLUnicodeToUTF8Size(sourceStr);
   printf("NWLUnicodeToUTF8Size() returned %d\n", utf8Size);
   
   utf8Ptr = malloc(utf8Size);
   if (NULL == utf8Ptr)
   {
      fprintf(stderr, "Memory allocation error\n");
      exit(1);
   }

   ccode = NWLUnicodeToUTF8(sourceStr, utf8Size, utf8Ptr, &utf8Size);
   assert(0 == ccode);
   printf("NWLUnicodeToUTF8() was successful: '%s'\n", utf8Ptr);


   /* 
    * Convert UTF-8 string to Unicode 
    */
   ccode = NWLUTF8ToUnicodeSize(utf8Ptr, &uniSize);
   assert(0 == ccode);
   printf("NWLUTF8ToUnicodeSize() passed back %d\n", uniSize);

   uniPtr = malloc(uniSize);
   if (NULL == uniPtr)
   {
      fprintf(stderr, "Memory allocation error\n");
      free(utf8Ptr);
      exit(1);
   }

   ccode = NWLUTF8ToUnicode(utf8Ptr, uniSize, uniPtr, &uniSize, NULL);
   assert(0 == ccode);
   assert(unicmp(uniPtr, sourceStr) == 0);   /* Check round-trip conversion */
   printf("NWLUTF8ToUnicode() was successful\n");


   /* 
    * Clean-up 
    */
   free(utf8Ptr);
   free(uniPtr);
}

