/* ***************************************************************************

  $Archive: $
  $Revision: $
  $Modtime: $
 
 Copyright (c) 1999 Novell, Inc. All Rights Reserved.

 THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
 USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
 ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
 PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
 ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
 PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
 DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
 PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
 CUSTOMERS WITH RESPECT TO THIS CODE.

 ****************************************************************************/
#include <stdio.h>
#include "ntypes.h"
#include "nwclxcon.h"

void main(int argc, char ** argv)
{
   NWRCODE rcode;
   NWCONN_HANDLE connHandle;
   NWCCFrag reqFrag;
   nuint8 ncppacket[3];
   
   if(argc < 2)
   {
      printf("Usage: nwccreq serverName\n");
      return;
   }

   rcode = NWCLXInit(NULL, NULL);
   if(0 != rcode)
   {
      printf("NWCLXInit was failed.\n");
      return;
   }

   rcode = NWCCOpenConnByName(0,
                              argv[1],
                              NWCC_NAME_FORMAT_BIND,
                              NWCC_OPEN_PUBLIC,
                              NWCC_TRAN_TYPE_WILD,
                              &connHandle);
   if(0 == rcode)
   {
      ncppacket[0] = 0x00;  /* SubFuncStrucLen */
      ncppacket[1] = 0x01;  /* number of bytes after this field */
      ncppacket[2] = 0xC8;  /* Sub function code 200 */
      reqFrag.length = 3;
      reqFrag.address = ncppacket;

      rcode = NWCCRequest(connHandle,
                          23,      /* Fuction Code */
                          1,       /* number of fragments */
                          &reqFrag,
                          0,
                          NULL,
                          NULL);
      if(0 == rcode)
         printf("You have console rights with the server.\n");
      else if(0x89C6 == rcode)
         printf("You do not have console rights with the server.\n");
      else
         printf("NWCCRequest was failed at %04x\n", rcode);
      
      NWCCCloseConn(connHandle);
   }


   NWCLXTerm(NULL);

}