/************************************************************************** 
  IMPSYMBL.C 
*************************************************************************** 
  This example demonstrates the use of ImportSymbol and GetNLMHandle(). 
  The ImportSymbol function allows the programmer to test if a function 
  is available before making a call to it.  This simple example tests to  
  see if printf is available before printing a message. 
 **************************************************************************/ 
#include <nwadv.h>     /* Defines ImportSymbol() */ 
#include <nwthread.h>  /* Defines GetNLMHandle() */ 

void main(void) 
{
   int (*fp_printf) (const char*, ...); 

   fp_printf=ImportSymbol(
                         /* I- NLMHandle  */ GetNLMHandle(), 
                         /* I- symbolName */ "printf"); 

   if (fp_printf == NULL)
      return;		/* SYMBOL_NOT_FOUND */

   (*fp_printf) ("printf imported successfully."); 

   UnimportSymbol(
                 /* I- NLMHandle  */ GetNLMHandle(), 
                 /* I- symbolName */ "printf"); 

   return; 
} 
