/**************************************************************************
   WHEREIS.C
***************************************************************************
  This module finds all files matching the given file specification.
  It accepts NetWare-style paths.
**************************************************************************/
#include <stdio.h>
#include <nwconio.h>
#include <nwdir.h>
#include <dirent.h>

#define   skipspace( x )  while( isspace( *x ) ) ++x
#define   nextspace( x )  while( *x && !isspace( *x ) ) ++x
#define   CWS     0
#define   CWV     1
#define   CWP     2
#define   ALL     99

/* Globals */
static      breakkey = FALSE;

char *GetWorkArea(void)
{
   static  char   cwd[_MAX_PATH];
   static  char   serverName[_MAX_SERVER];
   static  char   volumeName[_MAX_VOLUME + 1];
   static  char   dirName[_MAX_DIR];

   if (getcwd(cwd,_MAX_PATH) == NULL)
      return NULL;

   ParsePath(cwd,serverName,volumeName,dirName); /* shouldn't fail! */

   return cwd;
}

char *next_arg(char *s)
{
   char    *p;

   skipspace(s); /* ignore white */
   p = s;
   nextspace(s); /* find next blank */
   *s = NULL;
   return(p);
}

static void findit(char *what)
{
   char dir[_MAX_PATH];
   DIR *dirStructPtr;
   DIR *dirStructPtrSave;

   getcwd(dir,_MAX_PATH);
   dirStructPtrSave = dirStructPtr = opendir(what);

   while (dirStructPtr && !breakkey)
   {
      dirStructPtr = readdir(dirStructPtr);
      if ((dirStructPtr == NULL) || (dirStructPtr == (DIR *)-1))
         break;

      printf("  %s/%s\n",dir,dirStructPtr->d_name);
      if (kbhit() && getch() == 3)
         printf("^C\n",breakkey = TRUE);
   }

   if (dirStructPtrSave)
      closedir(dirStructPtrSave);

   /*  Now traverse the directories in this path */

   dirStructPtrSave = dirStructPtr = opendir("*.*");
   if (dirStructPtr == NULL)
      return;

   while (!breakkey)
   {
      dirStructPtr = readdir(dirStructPtr);
      if ((dirStructPtr == NULL) || (dirStructPtr == (DIR *)-1))
         break;

      if (dirStructPtr->d_attr & _A_SUBDIR)
      {
         chdir(dirStructPtr->d_name);
         findit(what);
         chdir("..");
      }

      if (kbhit() && getch() == 3)
         printf("^C\n",breakkey = TRUE);
   }

   if (dirStructPtrSave)
      closedir(dirStructPtrSave);
}

void dowhereis(char *s)
{
   char    dir[_MAX_PATH];
   char    fsv[_MAX_SERVER+_MAX_VOLUME+1];
   char    fdir[_MAX_PATH];
   char    fname[_MAX_FNAME],fext[_MAX_EXT], both[_MAX_FNAME+_MAX_EXT];
   char    *p = next_arg(s); /* point at argument */

   if (!*p)
   {
      printf("No filename specified!");
      return;
   }

   strcpy(dir,GetWorkArea());

   /* get the file name specification */

   _splitpath(p,fsv,fdir,fname,fext);
   sprintf(both,"%s%s",strupr(fname),strupr(fext));

   breakkey = FALSE;

   /* startup the recursive file find operation */

   chdir(fsv);
   findit(both);
}

int main(int argc, char *argv[])
{
   char fid[100];

   if (argc < 2)
   {
      ConsolePrintf("\nUsage: WHEREIS <filename>\n");
      return(1);
   }

   strupr(strcpy(fid, argv[1]));
   printf("WHEREIS: %s...\n",fid);

   dowhereis(fid);

   return(0);
}

