/*************************************************************************

  Copyright (c) 1999 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/*************************************************************************
  NWATTACH.C
**************************************************************************

  NWATTACH Demonstrates the NWAttachToFileServer API call.

  Usage:  NWATTACH <server name>

*************************************************************************/

#include <stdio.h>
#include <string.h>

#include <nwcalls.h>

void main (int argc, char *argv[])
{
   NWCONN_HANDLE  connHandle;
   char           serverName[50];
   NWCCODE        ccode;

   /* Check command-line arguments */
   if (argc != 2)
   {
      printf ("Usage:  %s <server name>", argv[0]);
      return;
   }

   /* Library initialization */
   ccode = NWCallsInit (NULL,NULL);
   if (ccode) 
   {
      printf ("NWCallsInit failed with error code=0x%04x\n", ccode);
      return;
   }

   strcpy (serverName, argv[1]);
   strupr (serverName);

   ccode = NWAttachToFileServer (
         /* > File server name  */ serverName, 
         /* > Reserved          */ 0, 
         /* < Connection handle */ &connHandle);

   if (ccode)
   {
      printf ("NWAttachToFileServer failed with error code=0x%04x\n", ccode);
   }
   else
   {
      printf ("You are attached to server %s\n", serverName);
   }
}