/*************************************************************************

  Copyright (c) 1992, 1997 Novell, Inc.  All Rights Reserved.

  With respect to this file, Novell hereby grants to Developer a 
  royalty-free, non-exclusive license to include this sample code 
  and derivative binaries in its product. Novell grants to Developer 
  worldwide distribution rights to market, distribute or sell this 
  sample code file and derivative binaries as a component of 
  Developer's product(s).  Novell shall have no obligations to 
  Developer or Developer's customers with respect to this code.
  
  DISCLAIMER:
  
  Novell disclaims and excludes any and all express, implied, and 
  statutory warranties, including, without limitation, warranties 
  of good title, warranties against infringement, and the implied 
  warranties of merchantibility and fitness for a particular purpose.  
  Novell does not warrant that the software will satisfy customer's 
  requirements or that the licensed works are without defect or error 
  or that the operation of the software will be uninterrupted.  
  Novell makes no warranties respecting any technical services or 
  support tools provided under the agreement, and disclaims all other 
  warranties, including the implied warranties of merchantability and 
  fitness for a particular purpose. */

/**************************************************************************
   NWHELLO.C
**************************************************************************/

#include <stdlib.h>
#include <stdio.h> 

#ifndef N_PLAT_NLM
   #include <ntypes.h>
   #include <nwcaldef.h>
   #include <nwapidef.h>
   #include <nwclxcon.h>  /* NWCCGetPrimConnRef */
   #include <nwmisc.h>    /* NWCallsInit        */

   NWCCODE        ccode;
   nuint32        connRef;
   NWCCConnInfo   returnInfo;
#endif

int main(void)
{  
   printf("\n Hello World!");

   /* If this example is running as a client application (and not an NLM),
      perform a simple network task to determine if the environment is 
      set up correctly.  Print the server name corresponding to the 
      workstation's primary connection */

#ifndef N_PLAT_NLM

   /* Initialize libraries */
   ccode = NWCallsInit(NULL, NULL);
   if(ccode)
   {
      printf("\nNWCallsInit returned %04X", ccode);
      exit(1);
   }

   /*  Find the workstation's primary connection reference.  */
   ccode = NWCCGetPrimConnRef(&connRef);
   if(ccode)
   {
      printf("\nNWCCGetPrimConnRef returned %04X",ccode);
      exit(1);
   }

   /*  Get information about the primary connection. */
   ccode = NWCCGetAllConnRefInfo(connRef, NWCC_INFO_VERSION, &returnInfo);
   if(ccode)
   {
      printf("\nNWCCGetAllConnRefInfo returned %04X",ccode);
      exit(1);
   }

   /*  print the primary connection server name.  */
   printf("\n\n You are attached to server %s\n\n", returnInfo.serverName);

#endif

   return(0);
} 
