/*
============================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without 
modification, are permitted provided that the following conditions 
are met:
  *  Redistributions of source code must retain the above copyright 
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above 
     copyright notice, this list of conditions and the following 
     disclaimer in the documentation and/or other materials provided 
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors 
     may be used to endorse or promote products derived from this 
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A 
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT 
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE 
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF 
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR 
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
		smsdefns.h

PURPOSE/COMMENTS:
		Definitions for SMS, this file is included by SMS.H and should not be 
		included directly.
        
NDK COMPONENT NAME AND VERSION:
		SMS Developer Components

LAST MODIFIED DATE:
		30 Oct 2005	
===============================================================
*/


#if !defined(_SMSDEFNS_H_INCLUDED)
#define _SMSDEFNS_H_INCLUDED

#include <limits.h>
#include <smstypes.h>

#if defined(STATIC)
#undef STATIC
#endif
#if defined(DEBUG_CODE)
        #define STATIC
#else
        #define STATIC static
#endif

#if !defined(TRUE)
        #define TRUE            1
        #define FALSE           0
#endif

#if !defined(NULL)
        #define NULL 0L
#endif

#ifdef N_PLAT_NLM
        #define UINT64_ZERO     { 0, 0, 0, 0 }
#elif defined(N_PLAT_UNIX)
		#define UINT64_ZERO		0
#endif
        #define UINT64_MAX      { 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF }

	/* Defines for NWSM_DATA_STREAM_TYPE fid */
        #define NWSM_CLEAR_TEXT_DATA_STREAM                     0x0
        #define NWSM_SPARSE_DATA_STREAM                         0x1
        #define NWSM_COMPRESSED_DATA_STREAM                     0x2
        #define NWSM_STUB_DATA_STREAM                           0x3

	/* Defines for NWSM_DATA_STREAM_NUMBER fid */
        #define NWSM_PRIMARY_DATA_STREAM_NUM					0x0
        #define NWSM_MAC_RESOURCE_FORK_NUM                      0x1
        #define NWSM_FTAM_DATA_STREAM_NUM                       0x2
	/* leave 3-9 for future expansion on NetWare */
        #define NWSM_EXTENDED_ATTR_STREAM_NUM         			0xA
        #define NWSM_NT_ALTERNATE_DATA                          0xB
        #define NWSM_NT_SECURITY_DATA                           0xC
        #define NWSM_NT_LINK_DATA 								0xD
        #define NWSM_NT_PROPERTY_DATA                           0xE

	/* Defines for NWSM_MEDIA_MARK_TYPE fid  */
        #define NWSM_MEDIA_MARK_HARD                            0x0     // Both file and set marks
                                                                                                        // are done by the hardware
        #define NWSM_MEDIA_MARK_SOFT                            0x1     // Both file and set marks
                                                                                                        // are simulated with a
                                                                                                        // linked list of soft
                                                                                                        // media mark fids.
        #define NWSM_MEDIA_MARK_SIM_SET                         0x2     // File marks are done by
                                                                                                        // the hardware, set marks
                                                                                                        // are multiple consecutive
                                                                                                        // file marks.

	/* Defines for address types of GetTargetServiceAddress */
	#define SPX             	1
	#define TCPIP   		2
	#define ADSP    		4

	#define SPX_INTERNET_ADDRESS_LENGTH             10


	/* Defines for versions of compression */
	#define NWSM_NOVELL_COMPRESSION_V1				0x1

	/* Defines for NWSMTSGetUnsupportedOptions */
	#define NWSM_BACK_ACCESS_DATE_TIME 		0x01
	#define NWSM_BACK_CREATE_DATE_TIME 		0x02
	#define NWSM_BACK_MODIFIED_DATE_TIME 	0x04
	#define NWSM_BACK_ARCHIVE_DATE_TIME 		0x08
	#define NWSM_BACK_SKIPPED_DATA_SETS 		0x10
	#define NWSM_BACK_MODIFY_FLAG			0x20

	#define NWSM_RESTORE_NEW_DATA_SET_NAME          0x01
	#define NWSM_RESTORE_CHILD_UPDATE_MODE          0x02
	#define NWSM_RESTORE_PARENT_UPDATE_MODE         0x04
	#define NWSM_RESTORE_PARENT_HANDLE          	0x08


	/* Generic selectionType defines */
	#define NWSM_TSA_DEFINED_RESOURCE_EXC           0x02
	#define NWSM_TSA_DEFINED_RESOURCE_INC           0x03
	#define NWSM_PARENT_TO_BE_EXCLUDED			0x04
	#define NWSM_PARENT_TO_BE_INCLUDED			0x05
	#define NWSM_CHILD_TO_BE_EXCLUDED			0x08
	#define NWSM_CHILD_TO_BE_INCLUDED			0x09
	#define NWSM_EXCLUDE_CHILD_BY_FULL_NAME        0x10
	#define NWSM_INCLUDE_CHILD_BY_FULL_NAME        0x11

	/* Generic scanType defines */
	#define NWSM_DO_NOT_TRAVERSE					0x0001
	#define NWSM_EXCLUDE_ARCHIVED_CHILDREN          0x0002
	#define NWSM_EXCLUDE_HIDDEN_CHILDREN            0x0004
	#define NWSM_EXCLUDE_HIDDEN_PARENTS				0x0008
	#define NWSM_EXCLUDE_SYSTEM_CHILDREN            0x0010
	#define NWSM_EXCLUDE_SYSTEM_PARENTS				0x0020

	#define NWSM_EXCLUDE_CHILD_TRUSTEES			0x0040
	#define NWSM_EXCLUDE_PARENT_TRUSTEES            	0x0080
	#define NWSM_EXCLUDE_ACCESS_DATABASE            	0x0100
	#define NWSM_EXCLUDE_VOLUME_RESTS			0x0200
	#define NWSM_EXCLUDE_DISK_SPACE_RESTS           	0x0400
	#define NWSM_EXCLUDE_EXTENDED_ATTRIBUTS 	0x0800
	#define NWSM_EXCLUDE_DATA_STREAMS			0x1000
	#define NWSM_EXCLUDE_MIGRATED_CHILD			0x2000
	
	/* NWSM_EXCLUDE_MIGRATED_CHILD means to exclude the data stream, but include
	all other information about the file */
	#define NWSM_EXPAND_COMPRESSED_DATA		0x4000
	#define NWSM_EXCLUDE_ARCH_CHILD_DATA            	0x8000
	#define NWSM_EXCLUDE_ARCH_CHILD_CHAR 		0x10000
	#define NWSM_FLAG_PURGE_IMMED_ON_DELETE	0x20000
	#define NWSM_EXCLUDE_MIGRATED_FILES			0x40000
	#define NWSM_INCLUDE_PATH_COMPONENT 		0x80000
	#define NWSM_EXCLUDE_HARDLINK_DATA			0x100000
	#define NWSM_EXCLUDE_SECONDARY_DATA_STREAMS 0x200000
	#define NWSM_INCLUDE_SOFTLINK_CHILD			0x400000

	/* NDS tsa scan type "Exclude objects for which user has no rights."*/
	#define NWSM_NDS_STOP_SCAN_IF_NO_RIGHTS	0x80000000


/*       Open modes for backup and restore, passed to NWSMOpenDataSetForBackup	   
              and NWSMOpenDataSetForRestore                                      
                                                                                 
             Backup                             Restore                          
         SMS Numeric modes                                                       
                                                                                 
         1:   NWSM_USE_LOCK_MODE_IF_DW_FAILS    NWSM_OVERWRITE_DATA_SET          
         2:   NWSM_NO_LOCK_NO_PROTECTION        NWSM_DO_NOT_OVERWRITE_DATA_SET   
         3:   Reserved                          NWSM_CREATE_PARENT_HANDLE        
         4:   Reserved                          NWSM_UPDATE_DATA_SET             
         5 to 15:                      Reserved                                  
         SMS Non-numeric mode options, ie., can be added (ORed) to numeric mode  
                                                                                 
         0010                          	 	 Reserved                     	  
         0020                          		 Reserved                         
         0040 Reserved                          NWSM_CLEAR_MODIFY_FLAG           
         0080 Reserved                          NWSM_RESTORE_MODIFY_FLAG         

         TSA Specific Non-numeric mode options, i.e., can be added (logical OR)	
             to numeric mode and SMS Non-numeric options.                        
                                                                                 
         0100 NWSM_NO_DATA_STREAMS              NWSM_NO_DATA_STREAMS             
         0200 NWSM_NO_EXTENDED_ATTRIBUTES       NWSM_NO_EXTENDED_ATTRIBUTES      
         0400 NWSM_NO_PARENT_TRUSTEES           NWSM_NO_PARENT_TRUSTEES          
         0800 NWSM_NO_CHILD_TRUSTEES            NWSM_NO_CHILD_TRUSTEES           
         1000 NWSM_NO_VOLUME_RESTRICTIONS       NWSM_NO_VOLUME_RESTRICTIONS      
         2000 NWSM_NO_DISK_SPACE_RESTRICTIONS   NWSM_NO_DISK_SPACE_RESTRICTIONS  
         4000 N/A                               NWSM_INCLUDE_MIGRATED_DATA               
         8000 N/A                               NWSM_DELETE_EXISTING_TRUSTEES    
        10000 NWSM_EXPAND_COMPRESSED_DATA_SET      N/A                                                      
        20000 NWSM_EXCLUDE_MIGRATED_DATA           N/A                                                          
         00040000 to 80000000:         Reserved                                  
*/

	/* Mask for numeric modes, backup and restore */
	#define NWSM_OPEN_MODE_MASK                             0x000F

	/* NWSMOpenDataSetForBackup modes */
	#define NWSM_OPEN_READ_DENY_WRITE                      	0x0000
	#define NWSM_USE_LOCK_MODE_IF_DW_FAILS     	    	0x0001
	#define NWSM_NO_LOCK_NO_PROTECTION                     	0x0002
	#define NWSM_OPEN_READ_ONLY 						0x0003

	/* TSA Specific Non-numeric mode options */
	#define NWSM_NO_DATA_STREAMS                            0x0100 /* Also used for Restore */
	#define NWSM_NO_EXTENDED_ATTRIBUTES 		0x0200 /* Also used for Restore */
	#define NWSM_NO_PARENT_TRUSTEES                       0x0400 /* Also used for Restore */
	#define NWSM_NO_CHILD_TRUSTEES                          0x0800 /* Also used for Restore */
	#define NWSM_NO_VOLUME_RESTRICTIONS                0x1000 /* Also used for Restore */
	#define NWSM_NO_DISK_SPACE_RESTRICTIONS         0x2000 /* Also used for Restore */
	#define NWSM_INCLUDE_MIGRATED_DATA                  0x4000 /* Also used for Restore */
	
	/*      #define NWSM_DELETE_EXISTING_TRUSTEES           		0x8000 */
	#define NWSM_EXPAND_COMPRESSED_DATA_SET 	0x10000
	#define NWSM_EXCLUDE_MIGRATED_DATA         		0x20000
	#define NWSM_PRESERVE_ACCESS_TIME			0x40000
	#define NWSM_NO_HARDLINK_DATA				0x80000
	#define NWSM_NO_SECONDARY_DATA_STREAMS		0x100000
	#define NWSM_INCLUDE_SOFTLINK_DATA			0x200000
	#define NWSM_NO_LINK_INFO						0x400000

	/*      NWSMOpenDataSetForRestore modes */
	#define NWSM_OVERWRITE_DATA_SET                       0x0001
	#define NWSM_DO_NOT_OVERWRITE_DATA_SET        0x0002
	#define NWSM_CREATE_PARENT_HANDLE                   0x0003
	#define NWSM_UPDATE_DATA_SET                             0x0004

	#define NWSM_SET_MODIFY_FLAG_RESTORE            	0x0000
	#define NWSM_CLEAR_MODIFY_FLAG_RESTORE         0x0040
	#define NWSM_RESTORE_MODIFY_FLAG                     0x0080

/* TSA Specific Non-numeric mode options */
/*      #define NWSM_NO_DATA_STREAMS                            0x0100  */
/*      #define NWSM_NO_EXTENDED_ATTRIBUTES                     0x0200  */
/*      #define NWSM_NO_PARENT_TRUSTEES                         0x0400  */
/*      #define NWSM_NO_CHILD_TRUSTEES                          0x0800  */
/*      #define NWSM_NO_VOLUME_RESTRICTIONS                     0x1000  */
/*      #define NWSM_NO_DISK_SPACE_RESTRICTIONS         		0x2000  */ 
/*      #define NWSM_INCLUDE_MIGRATED_DATA                      0x4000  */
	#define NWSM_DELETE_EXISTING_TRUSTEES           		0x8000  
/*      #define NWSM_EXPAND_COMPRESSED_DATA_SET  				0x10000 */
/*      #define NWSM_EXCLUDE_MIGRATED_DATA         				0x20000 */

/* NWSMTSSetArchiveStatus setFlag defines */
	#define NWSM_CLEAR_MODIFY_FLAG                          0x01
	#define NWSM_SET_ARCHIVE_DATE_AND_TIME          		0x02
	#define NWSM_SET_ARCHIVER_ID                            0x04
	#define NWSM_CLEAR_MOD_DATA_FLAG_ONLY       			0x08
	#define NWSM_CLEAR_MOD_CHAR_FLAG_ONLY       			0x10

/* Buffer Lengths */
	#define NWSM_MAX_DESCRIPTION_LEN                        80
	#define NWSM_OLD_MAX_RESOURCE_LEN                       30 /* to allow TSAs to work */
		                                                                                                        // with old smdr and engines
	#define NWSM_MAX_RESOURCE_LEN                           256 /* MAX_DN_CHARS in nwdsdefs.h */
	#define NWSM_MAX_STRING_LEN                        		60
	#define NWSM_MAX_TARGET_SRVC_NAME_LEN           		48
	#define NWSM_MAX_TARGET_SRVC_TYPE_LEN           		40
	#define NWSM_MAX_TARGET_SRVC_VER_LEN            		10
	#define NWSM_MAX_SOFTWARE_NAME_LEN                      80
	#define NWSM_MAX_SOFTWARE_TYPE_LEN                      40
	#define NWSM_MAX_SOFTWARE_VER_LEN                       10
	#define NWSM_MAX_TARGET_USER_NAME_LEN           		256 /* MAX_DN_CHARS in nwdsdefs.h */
	#define NWSM_MAX_ERROR_STRING_LEN                       255
	#define NWSM_MAX_MM_MODULE_LABEL_LEN            		64
	#define NWSM_MAX_DEVICE_LABEL_LEN                       64
	#define NWSM_MAX_MEDIA_LABEL_LEN                        64

	#define EndChar(p, b)           strchr((PSTRING)(b), *LastChar(p))
	#if defined(N_PLAT_NLM)
	#define LastChar(p)                     (NWPrevChar(p, (&(p)[strlen((PSTRING)p)])))
	#elif defined(N_PLAT_UNIX)
	#define LastChar(p)                     (&((unsigned char *)p)[strlen((PSTRING)p) - 1])
	#endif
	
        #define StrEnd(p)                       (&(p)[strlen(p)])
        #define StrEqu                          !strcmp
        #define StrNEqu                         !strncmp
        #define _min(a, b)                      ((a) < (b)) ? (a) : (b)

	/* NWSMTSConnectToTargetServiceEx options */
	#define NWSM_AUTH_LOCAL_DATA 			1
	#define NWSM_AUTH_RAW_DATA 				NWSM_AUTH_LOCAL_DATA
	#define NWSM_AUTH_UNICODE_DATA			2
	#define NWSM_AUTH_UTF8_DATA				4

	typedef enum 
	{
		NWSM_TYPE_UINT32					=	0x00000001, 
		NWSM_TYPE_ASCIIZ_STRING			=	0x00000002,
		NWSM_TYPE_UNICODEZ_STRING		=	0x00000003,
		NWSM_TYPE_END					=	INT_MAX
	}NWSMTypes;


	/* NWSMTSConfigureTargetService actionFlag defines */

	#define SMS_ACTION_FLAG_TYPE(type, flag)    	((type << 16) | flag)

	#define NWSM_CONFIGURE_SKIPPED_LOG 		SMS_ACTION_FLAG_TYPE(NWSM_TYPE_ASCIIZ_STRING, 0x0001)
	#define NWSM_CONFIGURE_ERROR_LOG 		SMS_ACTION_FLAG_TYPE(NWSM_TYPE_ASCIIZ_STRING, 0x0002)
	#define NWSM_USE_CODE_SET 			SMS_ACTION_FLAG_TYPE(NWSM_TYPE_ASCIIZ_STRING, 0x0003)
	#define NWSM_FLUSH_LOGFILES 			SMS_ACTION_FLAG_TYPE(NWSM_TYPE_UINT32, 0x0001)
	#define NWSM_DONOT_IGNORE_BACKUP_BIT 		SMS_ACTION_FLAG_TYPE(NWSM_TYPE_UINT32, 0x0002)
	#define NWSM_USE_CACHING_MODE 			SMS_ACTION_FLAG_TYPE(NWSM_TYPE_UINT32, 0x0003)
	#define NWSM_MAP_NEW_TREE_NAMES_ONLY 		SMS_ACTION_FLAG_TYPE(NWSM_TYPE_UINT32, 0x0004)
	#define NWSM_ENABLE_GWBACKUP	 		SMS_ACTION_FLAG_TYPE(NWSM_TYPE_UINT32, 0x0005)
	
	/* The following defines are left as is in order not to break compiles. 
	 * These are obseleted and will be removed in future releases */
	#define CONFIGURE_SKIPPED_LOG 			NWSM_CONFIGURE_SKIPPED_LOG
	#define CONFIGURE_ERROR_LOG 			NWSM_CONFIGURE_ERROR_LOG
	#define FLUSH_LOG_FILES 			NWSM_FLUSH_LOGFILES
	#define DONOT_IGNORE_BACKUP_BIT 		NWSM_DONOT_IGNORE_BACKUP_BIT
	#define USE_CACHING_MODE 			NWSM_USE_CACHING_MODE
	#define MAP_NEW_TREE_NAMES_ONLY 		NWSM_MAP_NEW_TREE_NAMES_ONLY

	/* NWSM_SCAN_INFORMATION extensions - Begin*/

	/* Extension TAG defines */
	#define NWSM_SCAN_INFO_EXTN_NFS_TAG							0x00000001
	#define NWSM_RESOURCE_INFO_EXTN_NETWARE_TAG				0x00000002
	#define NWSM_RESOURCE_INFO_EXTN_UNIX_TAG					0x00000003
	#define NWSM_RESOURCE_INFO_EXTN_UNSUPPORTED_TAG			0x00000004

	/* Extension versions defines */
	#define NWSM_EXTENSION_VERSION_1					0x00000001


	/* NFS information extensions */
#pragma pack ( push , 1 )
	/* NWSM_SCAN_INFO_EXTN_NFS version 1 extension structure */
	typedef struct 
	{
		UINT32 nfs_st_mode;		/* st_mode field as per POSIX definition of stat structure */
		UINT32 nfs_st_nlinks;		/* st_nlinks field as per POSIX definition of stat structure */
		UINT32 nfs_st_uid;		/* st_uid field as per POSIX definition of stat structure */
		UINT32 nfs_st_gid;		/* st_gid field as per POSIX definition of stat structure */
		UINT32 nfs_st_ctime;		/* st_ctime field as per POSIX definition of stat structure */
	} NWSM_SCAN_INFO_EXTN_NFS_DATA_1;
#pragma pack ( pop )

	/* NWSM_SCAN_INFORMATION extensions - End*/

	/* Resource information extentions - Begin */

	/* NetWare resource information extension */
	#pragma pack ( push , 1 )
	/* NWSM_RESOURCE_INFO_EXTN_NETWARE version 1 extension structure */
	typedef struct 
	{
		UINT16 		blockSize;
		UINT32 		totalBlocks;
		UINT32 		freeBlocks;
		NWBOOLEAN 	resourceIsRemovable;
		UINT32 		purgableBlocks;
		UINT32 		notYetPurgableBlocks;
		UINT32 		migratedSectors;
		UINT32 		preCompressedSectors;
		UINT32 		compressedSectors;
	} NWSM_RESOURCE_INFO_EXTN_NETWARE_DATA_1;
	#pragma pack ( pop )

	/* UNIX resource information extension */
	#pragma pack ( push , 1 )
	/* NWSM_RESOURCE_INFO_EXTN_UNIX version 1 extension structure */
	typedef struct 
	{
		char		*mnt_fsname;	/* Name of the mounted file system */
		char 	*mnt_type; 		/* Type of the mount point */
		char 	*mnt_opts;		/* Mount options */
	} NWSM_RESOURCE_INFO_EXTN_UNIX_DATA_1;
	#pragma pack ( pop )

	/* Unsupported options resource information extension */
	#pragma pack ( push , 1 )
	/* NWSM_RESOURCE_INFO_EXTN_UNSUPPORTED version 1 extension structure */
	typedef struct 
	{
		UINT32 		unsupportedBackupOptions;
		UINT32 		unsupportedRestoreOptions;
	} NWSM_RESOURCE_INFO_EXTN_UNSUPPORTED_DATA_1;
	#pragma pack ( pop )
	
	/* Resource information extentions - End */
	
#endif /* _SMSDEFNS_H_INCLUDED */
