/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	deoslib.c

PURPOSE/COMMENTS:
	Implements OS specific functionality abstraction that is required by DE.
	This file implements NetWare specific functionality.

NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	19 July 2004

===============================================================================
*/

/*
 * Headers and Defines
 */
 
#include <deoslib.h>
#include <nwconio.h>
#include <de.h>

struct cell{
	char   charValue;
	char   attribute;
}; 

/*
 * Function definitions
 */
 
/*********************************************************************
* NAME: NameScreen
*
* WHAT: Prints the active session's name on the upper right corner of screen.
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void NameScreen(char *strName)
{
    int 			count, scrColor;
	struct cell 	screenName[MAX_SCREEN_NAME_LENGTH];

	scrColor = (GetThreadID() % 7); 
	for (count = 0; count < MAX_SCREEN_NAME_LENGTH; count ++) 
	{
		screenName[count].charValue = ' '; 
		screenName[count].attribute = 0x07;
	}
	
	count = 0;
	while ((count < MAX_SCREEN_NAME_LENGTH) && (strName[count] != '\0'))
   	{
   		screenName[count].charValue = strName[count];
		screenName[count].attribute = SCREEN_ATTRIBUTES + scrColor;
		count ++;
    }
	
   	CopyToScreenMemory(1, 20, (char *)screenName, 60, 0);

	return;
}

/*********************************************************************
* NAME: DEPause
*
* WHAT: Wait until the user enters a keystroke.
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void DEPause(void)
{
	char strName[MAX_SCREEN_NAME_LENGTH];
	
	GetThreadName(GetThreadID(), strName);
	
	while (kbhit()) getch();	
	puts("\nStrike any key to continue..."); 
    NameScreen(strName);
    getch();	                        
	while (kbhit()) getch();
	printf( "\n\n" );

	return;
}

/*********************************************************************
* NAME: getun
*
* WHAT: Prompt the user to enter a user name. 
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void getun(char *user)
{
	char 	firstChar;
	int 	x, y;
	
	y = wherey(), x = wherex();
	printf("ADMIN");
	gotoxy(x, y);
	if ((firstChar = getch()) == '\r')
	{
		strcpy(user, "ADMIN");
		puts("");
	}
	else
	{
		puts("          ");
		gotoxy(x, y);
		putch(firstChar);
		*user = firstChar;
		gets(user + 1);
	}

	return;
}

/*********************************************************************
* NAME: getpw
*
* WHAT: Get a password from the user to be used in conjunction with
*	the user name.
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void getpw(char *password)
{
	int count = 2;

	while (count)
	{
		switch (password[count] = getch())
		{
		case '\r':
			*(UINT16 *)password = count - 2;
			count = 0;
			break;

		case '\b':
			if (count > 2)
				-- count;

			else
				putch('\a');
			break;

		default:
			++ count;
			break;
		}
	}

	return;
}

/*********************************************************************
* NAME: CursorPosition
*
* WHAT: Returns the horizontal and vertical position of the input cursor.
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void CursorPosition(int *x,int *y)
{
	*x = wherex();
    *y = wherey();

	return;
}

/*********************************************************************
* NAME: GetCharacter
*
* WHAT: Obtains the next available keystroke from the current screen
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void GetCharacter(char *option)
{
	*option = (char)getch();

	return;
}
	
