/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	ttdisplay.c

PURPOSE/COMMENTS:
	Display routines for TSA Test

NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	15 September 2004

===============================================================================
*/

/* Dependencies */
#include <stdio.h>
#ifdef N_PLAT_NLM
#include <nwcalls.h>
#include <nwconio.h>
#endif
#include <smstypes.h>

/* Project dependencies */
#include "tsatest.h"

/* Global state */
WORD	 LogLine = MIN_LOG_LINE;
char	 	 BlankLine[] = "                                                                                ";



/* Big character data */
int		ChrHeight = 8;
char		ClrCellLine[] = "        ";
BYTE	CellChar0[] = { 0x18, 0x24, 0x24, 0x24, 0x18, 0, 0, 0 };
BYTE	CellChar1[] = { 0x08, 0x18, 0x08, 0x08, 0x1C, 0, 0, 0 };
BYTE	CellChar2[] = { 0x1C, 0x22, 0x0C, 0x10, 0x3E, 0, 0, 0 };
BYTE	CellChar3[] = { 0x1C, 0x02, 0x0C, 0x02, 0x1C, 0, 0, 0 };
BYTE	CellChar4[] = { 0x08, 0x10, 0x24, 0x3E, 0x04, 0, 0, 0 };
BYTE	CellChar5[] = { 0x3E, 0x20, 0x3C, 0x02, 0x3C, 0, 0, 0 };
BYTE	CellChar6[] = { 0x1C, 0x20, 0x3C, 0x22, 0x1C, 0, 0, 0 };
BYTE	CellChar7[] = { 0x1E, 0x02, 0x04, 0x08, 0x08, 0, 0, 0 };
BYTE	CellChar8[] = { 0x1C, 0x22, 0x1C, 0x22, 0x1C, 0, 0, 0 };
BYTE	CellChar9[] = { 0x1C, 0x22, 0x1E, 0x02, 0x1C, 0, 0, 0 };
BYTE	CellCharB[] = { 0x3C, 0x22, 0x3C, 0x22, 0x3C, 0, 0, 0 };
BYTE	CellCharG[] = { 0x1C, 0x20, 0x16, 0x22, 0x1E, 0, 0, 0 };
BYTE	CellCharM[] = { 0x22, 0x36, 0x2A, 0x22, 0x22, 0, 0, 0 };
BYTE	CellChark[] = { 0x08, 0x08, 0x0E, 0x0C, 0x0A, 0, 0, 0 };
BYTE	CellCharlm[] = { 0x00, 0x00, 0x34, 0x2A, 0x2A, 0, 0, 0 };
BYTE	CellChari[] = { 0x08, 0x00, 0x18, 0x08, 0x1C, 0, 0, 0 };
BYTE	CellCharn[] = { 0x00, 0x00, 0x1C, 0x12, 0x12, 0, 0, 0 };
BYTE	CellCharDot[] = { 0x00, 0x00, 0x00, 0x00, 0x06, 0, 0, 0 };
BYTE	CellCharSlash[] = { 0x03, 0x06, 0x0C, 0x18, 0x30, 0x60, 0xC0, 0 };

/*
	Clear a character cell for a big character
*/
void ClearBigChar(int x, int y)
{
	int	cellLine;

	for (cellLine = ChrHeight - 1; cellLine >= 0; cellLine--)
	{
		gotoxy((unsigned short)x, (unsigned short)(y - cellLine));
		print(ClrCellLine);
		refresh();
	}
}

/*
	Print a big character
*/
void PrintBigChar(int x, int y, char ChrOut, BYTE Colour)
{
	int				 cellLine;
	int				 cellPixel;
	int				 ink = 0;
	int				 needInk;
	BYTE			*bitPattern;
	unsigned char	 bitLine;
	BYTE			 screenData[8];
	unsigned char	 currentAttr = 0x07;

	(void)Colour;

	switch (ChrOut)
	{
		case '0':
			bitPattern = CellChar0;

			break;

		case '1':
			bitPattern = CellChar1;

			break;

		case '2':
			bitPattern = CellChar2;

			break;

		case '3':
			bitPattern = CellChar3;

			break;

		case '4':
			bitPattern = CellChar4;

			break;

		case '5':
			bitPattern = CellChar5;

			break;

		case '6':
			bitPattern = CellChar6;

			break;

		case '7':
			bitPattern = CellChar7;

			break;

		case '8':
			bitPattern = CellChar8;

			break;

		case '9':
			bitPattern = CellChar9;

			break;

		case 'B':
			bitPattern = CellCharB;

			break;

		case 'G':
			bitPattern = CellCharG;

			break;

		case 'M':
			bitPattern = CellCharM;

			break;

		case 'k':
			bitPattern = CellChark;

			break;

		case 'm':
			bitPattern = CellCharlm;

			break;

		case 'i':
			bitPattern = CellChari;

			break;

		case 'n':
			bitPattern = CellCharn;

			break;

		case '.':
			bitPattern = CellCharDot;

			break;

		case '/':
			bitPattern = CellCharSlash;

			break;

		default:
			ClearBigChar(x, y);
			return;
	}

	for (cellLine = ChrHeight - 1; cellLine >= 0; cellLine--)
	{
		bitLine = bitPattern[7 - cellLine];
		if ((x > 79) || (y - cellLine > 24))
		{
			ConsolePrintf("Invalid co-ordinates: %d, %d\n", x, y - cellLine);
		}
		for (cellPixel = 0; cellPixel < 8; cellPixel++)
		{
			needInk = (bitLine & 0x80);
			if (needInk)
			{
				currentAttr = (unsigned char)0xF0;
				ink = 1;
#ifdef N_PLAT_UNIX
				move((y - cellLine),(x + cellPixel));
				printw("%c",'#');
				refresh();
#endif
			}
			if (!needInk && ink)
			{
				currentAttr = (unsigned char)0x07;
				ink = 0;
			}
							
			CopyFromScreenMemory((unsigned short)1, (
									unsigned short)1, 
									screenData, 
									(unsigned short)(x + cellPixel), 
									(unsigned short)(y - cellLine));
									
			screenData[1] = currentAttr;
			screenData[0] = ' ';
			
			CopyToScreenMemory((unsigned short)1, 
									(unsigned short)1, 
									screenData, 
									(unsigned short)(x + cellPixel), 
									(unsigned short)(y - cellLine));

			bitLine <<= 1;
		}
	}
}

void PrintBigString(int x, int y, char *strText)
{
	char *pos = strText;

	while (*pos)
	{
		if (x > 72)
		{
			y += 8;
			x = 0;
		}

		PrintBigChar(x, y, *pos, 0x0F);
		x += 8;

		pos++;
	}
}
