/*
=================================================================	
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
			smsdrapi.h

PURPOSE/COMMENTS:
			SMDR Apis

NDK COMPONENT NAME AND VERSION:
			SMS Developer Components

LAST MODIFIED DATE:
			22 Jan 2004
=================================================================
*/

#ifndef _SMSDRAPI_H_INCLUDED      /* smsdrapi.h header latch */
#define _SMSDRAPI_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#include <smsdrerr.h>

#if defined(NWWIN)
#	if defined(API)
#		undef API
#	endif
#	define	API	pascal far
#else
#	define	API
#endif

	CCODE API NWSMListTSAs(
		char *pattern, 
		NWSM_NAME_LIST **tsaNameList);

	CCODE API NWSMListSMDRs(
		char *pattern, 
		NWSM_NAME_LIST **tsaNameList);

	CCODE API NWSMTSListTargetServices(
		UINT32 connectionID, 
		char *pattern, 
		NWSM_NAME_LIST **tsNameList);

	CCODE API NWSMConvertError(
		UINT32 connectionID, 
		CCODE error, 
		STRING message);

#ifdef __cplusplus
}
#endif

#endif                            /* smsdrapi.h header latch */
