/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	decluster.h

PURPOSE/COMMENTS:
	Demo engine cluster support header file

NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	16 July 2004


===============================================================================
*/

#ifndef _DECLUSTER_H_
#define _DECLUSTER_H_

/*
 * Headers and Defines
 */

#include "sms.h"
#define DEFAULT_RE_TRIES 			10 
#define DEFAULT_RE_TRY_PERIOD 		30 
#define DEFAULT_WAIT_TIME 			1 
#define NWSMDR_WRITE_FAILURE 		0xFFFEFFCC
#define NWSMDR_READ_FAILURE 		0xFFFEFFCD
#define NWSMDR_OPEN_FAILURE  		0xFFFEFFCE
#define NWSMDR_DISCONNECTED			0xFFFEFFB1

#pragma pack(push,1)

typedef struct CluParams
{
	int reTries;
	int reTryPeriod;
	int waitTime;
}ClusterParams;

#pragma pack(pop)

#endif/* _DECLUSTER_H_ */

