/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	deoslib.h

PURPOSE/COMMENTS:
	OS specific functionality abstraction that is required by DE.

NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	16 July 2004

===============================================================================
*/

#ifndef _DEOSLIB_H_
#define _DEOSLIB_H_

/*
 * Headers and Defines
 */
 
#include <de.h>
#ifdef N_PLAT_NLM
#include <nwthread.h> 
#include <nwconio.h>
#endif

#ifdef N_PLAT_NLM
void    NameScreen(char *strName);
void 	CursorPosition(int *x, int *y);
#define	ClearModuleDontUnloadFlag(a)	(ClearNLMDontUnloadFlag((a)))
#define	GetNameOfThread(a) 				(GetThreadName(GetThreadID(),(a)))
#define	ClearScreen()					(clrscr())
#define	Delay_milliSec(a, b)			(delay((a) * (b)))
#define	SetCursor(a, b) 				(gotoxy((a), (b)))
#define	DestroyTheScreen(a)				(DestroyScreen((a)))
#define	ExitTheThread(a, b)  			(ExitThread((a), (b)))
#define	CreateNewScreen(a, b) 			(CreateScreen((a), (b)))
#define	SetTheCurrentScreen(a) 			(SetCurrentScreen((a)))
#define	DisplayTheScreen(a)				(DisplayScreen((a)))
#define	RenameTheThread(a)   			(RenameThread(GetThreadID(), (a)))
#define	GetTheCurrentScreen()			(GetCurrentScreen())
#define	ConsoleSpeakerToBeep() 			(RingTheBell())
#define	IsKeyStrokeAvailable() 			(kbhit())
#define	PutCharacter(a)					(putch(a))
#define	IntegerToString(a, b, c, d)		(itoa(a, b, c))							
#elif defined(N_PLAT_UNIX)
#define NameScreen(a)
#define CursorPosition(a, b)
#define ClearModuleDontUnloadFlag(a)
#define GetNameOfThread(a)
#define ClearScreen()					{clear(); refresh();}
#define Delay_milliSec(a, b)			sleep((a * b) /1000) 
#define SetCursor(a, b)
#define DestroyTheScreen(a)
#define ExitTheThread(a, b)
#define CreateNewScreen(a, b) 			(0)
#define SetTheCurrentScreen(a)
#define DisplayTheScreen(a)
#define RenameTheThread(a)
#define GetTheCurrentScreen() 			(0)
#define ConsoleSpeakerToBeep()
#define IsKeyStrokeAvailable() 			(FALSE)
#define PutCharacter(a) 				(putchar((a)))
#define IntegerToString(a, b, c, d)		(sprintf((b), (d), (a)))
#define strnicmp(a, b, c)				(strncasecmp((a), (b), (c)))
#endif /* N_PLAT_NLM */

/*
 * Function prototypes
 */
 
void 	DEPause(void);
void 	getun(char *user);
void 	getpw(char *password);
void	GetCharacter(char *option);
char *_NbkMessage(int index);

#endif /* _DEOSLIB_H_ */

