/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	tsatest.c

PURPOSE/COMMENTS:
	To investigate TSA operations
	
NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	15 September 2004

===============================================================================
*/

/* Dependencies */
#include <stdio.h>
#include <ctype.h>

#ifdef N_PLAT_UNIX
#include <sys/socket.h>
#include <libintl.h>
#include <locale.h>
#include <unistd.h>
#endif

#ifdef N_PLAT_NLM
#include <nwthread.h>
#include <nwclxcon.h>
#include <nwadv.h>
#include <nwconio.h>
#include <nwmisc.h>
#endif

#include <smstypes.h>
#include <smsdrapi.h>
#include <smstsapi.h>
#include <smsutapi.h>
#include <cmdline.h>
#include <signal.h>

/* Project dependencies */
#include "tsatest.h"

#define gettext_noop(String)	String
#define NBACKUP_SMS_PASSWORD "OES_SMS_PASSWORD"

/* Backup statistics */
time_t                                           backupEnd;
time_t                                           backupStart;
UINT32                                           backedUpSets = 0;
UINT32                                           bytesRead;
UINT32                                           lastElapsedTime;
UINT32                                           maSamples;
UINT32                                           maxReadTime = 0;
UINT32                                           minReadTime = 0xFFFFF;
unsigned __int64                             readCount = 0;
UINT32                                           scanCount = 0;
UINT32						 NoWait=1;
int                                              *scanHistogram = NULL;
int                                              *openHistogram = NULL;
int                                              *readHistogram = NULL;
int                                              *closeHistogram = NULL;
int                                              maInsert = 0;
unsigned __int64                          totalBytesRead = 0;
unsigned __int64                          totalCloseTime = 0;
unsigned __int64                          totalOpenTime = 0;
unsigned __int64                          totalReadTime = 0;
unsigned __int64                          totalScanTime = 0;
unsigned __int64                          totalTime = 0;
unsigned __int64                          maSetTotalBytes;
unsigned __int64                          maSetTotalTime;
unsigned __int64                          maTotalBytes;
unsigned __int64                          maTotalTime;
double                                   	 maCurrent = 0.0;
UINT32						 nameSpace;	
UINT32 						 volumeNameSpecified = 0;
UINT32				 		 linuxTSA = 0, netwareTSA = 0;
// Global to specify maximum value for last histogram bucket. This value 
// specifies the tick width of each bucket. For example, a 32 bucket histogram 
// array with a 128 as the value to this variable will result in each bucket
// storing counts of four tick values (128/32). So, the bucket ranges would
// be: 0-3;4-7;8-11;12-15...108-111;112-115;116-119;120-123;>124
int MaxHistogramBucketValue = 128;


// The number of buckets in our histogram arrays. Use a variable so that we 
// can choose to make this configurable at the command line. In that case
// bucket arrays would have to be allocated dynamically.
int MaxHistogramBuckets = 32;

// Global to specify minimum value for first histogram bucket. This value 
// combines with the other globals to specify the tick width of each bucket.
int MinHistogramBucketValue = 0;

/* Global data */
int              Aggregate = 0;
int              AllVolumes = 0;
int              Average = 0;
int              Cluster = 0;
int              DoNDS = 0;
int              FirstPass = 1;
int              FullLog = 0;
int              GrowByAmount = 0;
int              GrowByFactor = 0;
int              Helped = 0;
int              Iterations = 0;
int              LogData = 0;
int              MaxIterations;
int              Milliseconds = 0;
int              PresentationMode = 0;
int              ShowNames = 0;
int              WorkingVolume = 0;
int              retval = 1;
int 		    ParseError = 1;	
int              getPassword = FALSE, pwdStored = FALSE, uNameStored = FALSE;
int              iTmp;
unsigned long    snameLen;
unsigned short   pwLen;
int              argNum;
char             *pos;
char             *commaPos;
char			 grow[10];
char			 str[128];
int 			 cCode;
cmdLineMod_s 	 mod;
cmdLineError_s 	 err;
UINT32   		 BuffSize;
UINT32      	 DataSetSize = 0;
UINT32   		 maGroupLen = 64;
UINT32   		 ScanType = 0;
int      		 isScanTypeSpecifiedInCmdLine = FALSE;
double   		 maTolerenceLow = 0.9;
double  		 maTolerenceHigh = 1.1;
FILE    		*fErrLog = NULL;
FILE    		*fMovingAve = NULL;
char    		*AllVolNames[256];
char     		VolumeName[32];
char     		ServerName[64];
char     		UserName[128];
char     		Password[128];
char 	 	PasswordTempStr[128];
char     		ErrLog[256] = "";
char     		DirName[512] = "";
char     		maFileName[256] = ".//tsatest.ave";
char     		LogFileName[256]=".//tsatest.log";
char     		NameWorkspace[512];
char     		TSAName[512] = "";
char     		ServiceName[512] = "";
char     		ScanTypeString[NWSM_MAX_STRING_LEN] = "";
char     		TSAResourceName[NWSM_MAX_RESOURCE_LEN] = "";
int      		UseHiResTimer = FALSE;
int 	 		IsUTF8Supp=0;	
CCODE		ccode;
 UINT32		PasswordValidate=1;
 UINT32 			tsaMajorVersion=0;
 UINT32 			tsaMinorVersion=0;
 UINT32 			supportedTypes=0;
  int             foundNSSep = FALSE;
 UINT32          tsaConn;
 UINT32          typeReqd;
 UINT32          typeDisallowed;
 UINT32          tsaSeq;
 UINT32          nsSeq;
 UINT32          nsNum;
 char            nsName[61];
 char            wildName[64] = {0};
 char            nsTmp[80];
 char            nsLine[160] = "  NAMESPACES: ";
 char	      IterationsString[256];	
 NWBOOLEAN       nsRev;
STRING_BUFFER   *nsFirstSep = NULL;
STRING_BUFFER   *nsSecondSep = NULL;
MOVING_AVERAGE_NODE     *maData = NULL;
unsigned int    UnloadState = 0;
NWSM_SCAN_INFORMATION   *scanInfo;
NWSM_SELECTION_LIST     *selectionList = NULL;
NWSM_SCAN_CONTROL       scanControl =
{
   /* bufferSize */                         sizeof(NWSM_SCAN_CONTROL),
   /* scanControlSize */                    sizeof(NWSM_SCAN_CONTROL) - sizeof(UINT16) - sizeof(UINT8),
   /* scanType */                           0,
   /* firstAccessDateAndTime */             0,
   /* lastAccessDateAndTime */              0,
   /* firstCreateDateAndTime */             0,
   /* lastCreateDateAndTime */              0,
   /* firstModifiedDateAndTime */           0,
   /* lastModifiedDateAndTime */            0,
   /* firstArchivedDateAndTime */           0,
   /* lastArchivedDateAndTime */            0,
   /* returnChildTerminalNodeNameOnly */    FALSE,
   /* parentsOnly */                        FALSE,
   /* childrenOnly */                       FALSE,
   /* createSkippedDataSetsFile */          TRUE,
   /* generateCRC */                        FALSE,
   /* returnHardLinksInDataSet */           FALSE,
   /* reserved */                           { 0 },
   /* scanChildNameSpaceType */             NWSM_ALL_NAME_SPACES,
   /* returnNameSpaceType */                NWSM_ALL_NAME_SPACES,
   /* callScanFilter */                     FALSE,
   /* otherInformationSize */               0
};


__WATCOM_Prelude(){}

void *GetSystemConsoleScreen(void);

#ifdef N_PLAT_NLM
void OutputToScreenWithAttribute(struct ScreenStruct * screenID, BYTE attribute, void * controlString,...);
#endif

char *HelpMessages[]=
{
	gettext_noop("prints this help."),
	gettext_noop("prints the version."),	
	gettext_noop("Server to backup. Default is server running TSATEST."),
#ifdef N_PLAT_NLM
	"Volume to backup. Default is SYS: Note: The colon is required. /v=ALL (no colon) to backup all volumes, useful with /log ./v=NDS (no colon) to backup NDS if TSANDS is loaded.",
#else
	gettext_noop("Specify the volume name to backup for NetWare targets. Default is \"SYS:\""),
#endif
	gettext_noop("Specify the path to backup. On NetWare targets this is a path without the volume name, use -v to specify the volume. On Linux this is the fully qualified path from the root file system."),
	gettext_noop("Buffer size to use for reads. Default is 65536 bytes."),
	gettext_noop("Specify the user name to use to connect to the target service. This is the fully distinguished name of the user for NetWare targets and a user name on the Linux server for Linux targets."),
#ifdef N_PLAT_NLM
	"Write the statistics to fspec. Default is SYS:\\ETC\\TSATEST.LOG",
#else
	gettext_noop("Write the statistics to fspec. Default is tsatest.log created in the current working directory"),
#endif
	gettext_noop("Password for the specified user."),
	gettext_noop("Number of iterations to perform.  Default is 1.  Use with log option"),
	gettext_noop("Specifies the total backup data size. Use with --pres to get a progress bar."),
#ifdef N_PLAT_NLM	
	"Show filenames during backup. Max length of 8.3 DOS name marked ^",
#else
	gettext_noop("Show filenames during backup. "),
#endif	
	gettext_noop("Specifies additional scan types to use when creating a job."),
	gettext_noop("Enable the \"presentation\" mode. Displays average performance in large digits instead of the rolling log."),
#ifdef N_PLAT_NLM
	"Write an error log to file specified, e.g. /err=SYS:\\TSATEST.LOG",
#else
	gettext_noop("Write an error log to file specified, e.g. --err=/home/tsatest.err"),
#endif
	gettext_noop("Cause the rolling display to report the results of all operations."),
	gettext_noop("Backup the cluster TSA."),
	gettext_noop("Use millisecond rather than 0.1ms resolution display."),
	gettext_noop("Use microsecond rather than 0.1ms resolution timer."),
	gettext_noop("Aggregate statistical data across multiple iterations."),
	gettext_noop("Specify a method to grow the read buffer size on each iteration."),
	gettext_noop("Cause TSATEST to unload when the job completes."),
#ifdef N_PLAT_NLM
	"Enable moving average analysis. Logs the performance variation throughout the job. By default, SYS:\\ETC\\TSATEST.AVE is used with a tolerence of 10%% and a group length of 64 files.",
#else
	gettext_noop("Enable moving average analysis. Logs the performance variation throughout the job. By default, tsatest.ave will be created in the current working directory using a tolerence of 10% and a group length of 64 files."),	
#endif
	"Usage",
	"Type",
	"TRUE",
	"FALSE",
	"Value",
	"Range",
	"switch",
	"Boolean",
	"StartupOnly",
	"RunTimeOnly",
	"Informational",
	gettext_noop("The value passed to the option '%s' is out of range\n"),
	gettext_noop("The option '%s' requires an argument.\n"),
	gettext_noop("Invalid option .Try tsatest --help\n"),
	gettext_noop("The option '%s' takes no argument.\n"),
	gettext_noop("TSATEST is a Novell utility to perform statistical analysis of TSA APIs\n"),
	gettext_noop("Specify the maximum number of histogram buckets\n"),
	gettext_noop("Specify the minimum value for first histogram buckets\n"),
	gettext_noop("Specify the maximum value for last histogram bucket\n")
};

enum HelpMessagesIndex
{
	HELP_HELP,
	HELP_INDEX,
	HELP_SERVER,
	HELP_VOLUME,
	HELP_PATH,
	HELP_BUFFER,
	HELP_USER,
	HELP_LOG,
	HELP_PASSWD,
	HELP_ITER,
	HELP_SIZE,
	HELP_SHOW,
	HELP_SCAN,
	HELP_PRES,
	HELP_ERR,
	HELP_FULLLOG,
	HELP_CLUSTER,
	HELP_MS,
	HELP_MICROSEC,
	HELP_AGG,
	HELP_GROW,
	HELP_NOWAIT,
	HELP_AVE,
	HELP_Usage,
	HELP_Type,
	HELP_TRUE,
	HELP_FALSE,
	HELP_Value,
	HELP_Range,
	HELP_switch,
	HELP_Boolean,
	HELP_StartupOnly,
	HELP_RunTimeOnly,
	HELP_Informational,
	CMDLN_OUT_OF_RANGE,
	CMDLN_REQUIRES_ARG,
	CMDLN_INVALID_OPTION,
	CMDLN_NO_ARGS,
	TSATEST_DESCRIPTION,
	HELP_BCOUNT,
	HELP_BMAX,
	HELP_BMIN,
	END_OF_ENUM=INT_MAX
};

char *GetHelpMessage(int i)
{
#ifdef N_PLAT_UNIX
	return gettext(HelpMessages[i]);
#else
	/*todo: localise for other platforms*/
	return HelpMessages[i];
#endif

}

void ProcessErrors(cmdLineError_s err, void* scrHandle)
{

#ifdef N_PLAT_UNIX
#define print1(c, s, a1)			printf(s, a1)
#elif defined N_PLAT_NLM
#define print1(c, s, a1)			OutputToScreenWithAttribute(ScrId, c, s, a1)
struct ScreenStruct *ScrId = 		(struct ScreenStruct *)scrHandle;
#endif


	switch(err.err)
	{
		case CMDLN_ERR_ARG_OUT_OF_RANGE:
			print1(WHITE, GetHelpMessage(CMDLN_OUT_OF_RANGE), err.option);
			ParseError = 0;
			break;
		case CMDLN_ERR_OPTION_REQUIRES_ARG:
			print1(WHITE, GetHelpMessage(CMDLN_REQUIRES_ARG), err.option);
			ParseError = 0;
			break;
		case CMDLN_ERR_INVALID_OPTION:
			print1(WHITE, GetHelpMessage(CMDLN_INVALID_OPTION), NULL);
			ParseError = 0;
			break;
		case CMDLN_ERR_OPTION_TAKES_NO_ARG:
			print1(WHITE, GetHelpMessage(CMDLN_NO_ARGS), err.option);
			ParseError = 0;
			break;
		default:
			print1(WHITE, GetHelpMessage(CMDLN_INVALID_OPTION), err.option);
			ParseError = 0;
			break;
	}
	
}

char *display_help(cmdLineSwitchState_s *switchState)
{
	CmdLineDisplayHelp();
	Helped=1;
	return NULL;
}

/*Used for mapping the namespace from MBCS to UTF-8 */
UINT32 MapToUtf8NameSpace(UINT32 namespaceType)
{
	if (namespaceType == DOSNameSpace)
		return DOSNameSpaceUtf8Type;
	if (namespaceType == MACNameSpace)
        	return MACNameSpaceUtf8Type;
	if (namespaceType == NFSNameSpace)
        	return NFSNameSpaceUtf8Type;
	if (namespaceType == OS2NameSpace)
        	return LONGNameSpaceUtf8Type;

    	return namespaceType;
}

char *description(cmdLineSwitchState_s *switchState)
{
	char *buf;

	buf = malloc(1024);
	sprintf(buf, GetHelpMessage(TSATEST_DESCRIPTION));
	Helped=1;

	return buf;
}


char *usage(cmdLineSwitchState_s *switchState)
{
	char *buf;

	buf = malloc(1024);
	sprintf(buf, "tsatest  [OPTION] ...");
	Helped=1;

	return buf;
}

/* Procedure to process the volume name*/
char *ProcessVolumeName(cmdLineSwitchState_s *switchState)
{
	volumeNameSpecified = 1;	
	if (AllVolumes && !Cluster)
	{
 		LogText0("/v=option must only be included once\n");
		ParseError = 0;
		return NULL;
	 }
	 if ((strstr(VolumeName, "ALL") == VolumeName) && (strlen(VolumeName) == 3))
	 {
	 	VolumeName[0] = 0;
		AllVolumes = 1;  
		return NULL;             
	 }
	 if ((strstr(VolumeName, "NDS") == VolumeName) && (strlen(VolumeName) == 3))
	 {
	 	VolumeName[0] = 0;
		DoNDS = 1;
		return NULL;             
	 }

	if (VolumeName[strlen(VolumeName) - 1] != ':')
	{
#ifdef N_PLAT_NLM     	
		LogText0("Volume name must end with a colon (:)");
#else
		printf("Volume name must end with a colon (:)\n");
#endif 	 	
	    	ParseError = 0;
	 } 

	return NULL;	
		 
}

/*Procedure to parse the path name*/
char *ProcessPathName(cmdLineSwitchState_s *switchState)
{
//#ifdef N_PLAT_NLM
	 /* Guarantee it ends in a backslash */
	/*if (DirName[strlen(DirName) - 1]  !=  '\\')
     	{
     		strcat(DirName, "\\");
     	}
#endif     */
     
     return NULL;	
}


/*Procedure to parse the user name*/
char *ProcessUserName(cmdLineSwitchState_s *switchState)
{
	uNameStored = TRUE;
	return NULL;
}

/*Procedure to parse the password*/
char *ProcessPassword(cmdLineSwitchState_s *switchState)
{
	 pwLen = (unsigned short)strlen(PasswordTempStr);
     *(unsigned short *)&(Password[0]) = pwLen;
     strcpy(&(Password[2]), (PasswordTempStr));
     pwdStored = TRUE;
     return NULL;
}

char *ProcessIterations(cmdLineSwitchState_s *switchState)
{
	Iterations = atoi(IterationsString);
	if(!Iterations)
	{
		printf(GetHelpMessage(CMDLN_INVALID_OPTION), NULL);
		ParseError = 0;
	}
	return NULL;
}

char *ProcessServerName(cmdLineSwitchState_s *switchState)
{
	char            			 *wildName;

	wildName = malloc(64);
	if (!wildName)
	{
		*(char *)(switchState->switchData->value) = '\0';
		return NULL;
	}
	ParseHostName(&wildName, (char *)switchState->switchData->value);
	strcpy(ServerName, wildName);

	if(wildName)
		free(wildName);
	return NULL;
}

int ParseHostName(char **outHostName, char *inHostName)
{
	char *dotPos;
	long  inAddr;
	char *endPtr = NULL;

	/* Test if the string has a DOT delimiter */
	dotPos = strchr(inHostName, '.');

	/* If there are not DOT delimiters then there return the string as is */
	if (!dotPos)
	{
		strcpy(*outHostName, inHostName);
	}
	else
	{
		/* Check if host name is in the IP address format */
		*dotPos = '\0';
		inAddr = strtol(inHostName, &endPtr, 10);

		/* If conversion had errors, or Addr value not in 0-255 range,
		 * assume that the in name is not in IP format and return the current parse state */
		if ((endPtr != dotPos) || (inAddr < 0 || inAddr > 0xFF))
		{
			strcpy(*outHostName, inHostName);
			*dotPos = '.';
		}
		/* Assume that the in name is in the IP format and return the string as is */
		else
		{
			*dotPos = '.';
			strcpy(*outHostName, inHostName);
		}
	}
	
	return 0;
}
/*Procedure to parse the --LOG option(in Linux) or /LOG(in Netware)*/
char *getLog(cmdLineSwitchState_s *switchState)
{
	LogData = 1;
	return NULL;
}

/*Procedure to parse the scan types*/
char *SpecifyScanType(cmdLineSwitchState_s *switchState)
{
	isScanTypeSpecifiedInCmdLine = TRUE;
	return NULL;
}

/*Procedure to parse the --G(Grow) factor in Linux or /G(NLM)*/
char *GrowFunc(cmdLineSwitchState_s *switchState)
{
	if((grow[0] >= 48 && grow[0] <= 57) || grow[0] == 'X')
		if (strstr(grow, "X") == grow)
		{
		GrowByFactor = (int)atoi(&grow[1]);
		}
		else
		{
			GrowByAmount =(int)atoi(grow);
		}
	else
	{
		printf(GetHelpMessage(CMDLN_INVALID_OPTION), NULL);
		ParseError = 0;
	}	
	return NULL;
}

/*Procedure to parse the --NOWAITONEXIT*/
char *NoWaitOnExit(cmdLineSwitchState_s *switchState)
{
#ifdef N_PLAT_NLM
	SetScreenAttributes(AUTO_DESTROY_SCREEN, 1);
/*#else
	NoWait = 1;*/
#endif
    
	return NULL;
}

/*Procedure to parse the --AVE option*/
char *getAve(cmdLineSwitchState_s *switchState)
{
	/* Moving average enabled */
    Average = 1;
                                        
    /* Any parameters */
    if (strlen(str)!=0)
    {
    	/* AVE parameters are comma delimited nut may not all be present */
         pos = str;
         iTmp = 0;
         do
         {
          	commaPos = strchr(pos, ',');

          	if (commaPos != NULL)
          	{
         	 	*commaPos = 0;
          	}

          	/* We are allowed empty arguments */
           	if (pos == commaPos)
             {
            		goto NextSubArg;
             }

            /* The first two parameters are integers */
             if (iTmp < 2)
             {
    	  		snameLen = (unsigned long)atoi(pos);
			if (snameLen == 0)
                 	{
                 		ParseError = 0;
                    		break;
                 	}

                 	switch (iTmp)
                 	{
                 		case 0:
                    			maTolerenceLow = 1.0 - ((double)snameLen / 100);
                        		if (maTolerenceLow < 0.0)
                        		{
                        			maTolerenceLow = 0.0;
                        		}
                        		maTolerenceHigh = 1.0 + ((double)snameLen / 100);
                        		break;
				case 1:
                    			maGroupLen = snameLen;
                        		if (maGroupLen > 1024)
                        		{
                        			ParseError = 0;
                        		}
                        		break;
                    		default:
                        		ParseError = 0;
	                            break;
                    }
          }

           /*The last parameter is a filename */
            if (iTmp == 2)
            {
	             strcpy(maFileName, pos);
            }

NextSubArg:
            /* Next sub-argument */
            iTmp++;
            pos = commaPos + 1;
            } while (commaPos != NULL);
    }
    return NULL;
}

char *getVersion(cmdLineSwitchState_s *switchState)
{
	char *buf;

	buf = malloc(1024);
	sprintf(buf, TSATEST_VERSION);
	Helped=1;

	return buf;
}

char *non_opt_processor(cmdLineSwitchState_s *switchState)
{
	printf(GetHelpMessage(CMDLN_INVALID_OPTION), NULL);
	Helped=1;

	return NULL;
}

char *SpecifyClusterInfo(cmdLineSwitchState_s *switchState)
{
	AllVolumes=1;

	return NULL;
}

void CheckForVolumeAndTSA()
{
	NWSM_NAME_LIST  	*TSAList;
	NWSM_NAME_LIST  	*currentTSA;
	char            			 tempWildName[512];
	

		
	strcpy(tempWildName, ServerName);
	strcat(tempWildName, ".*");
	
	if (NWSMListTSAs(tempWildName, &TSAList) == 0)
	{
		currentTSA = TSAList;

		while(currentTSA != NULL)
		{
			if (strstr((const char *)currentTSA->name, ".NetWare File System") != NULL)
			{
				/* Copy the TSA name, this is the one we will connect to */
				strcpy(TSAName, (const char *)currentTSA->name);
				if(strlen(DirName) != 0)
					if (DirName[strlen(DirName) - 1]  !=  '\\')
     					{
     						strcat(DirName, "\\");
     					}
				break;
			}

			if (strstr((const char *)currentTSA->name, ".Linux File System") != NULL)
			{
				/* Copy the TSA name, this is the one we will connect to */
				strcpy(TSAName, (const char *)currentTSA->name);
				if(volumeNameSpecified)
				{
					printf("Invalid option  '-v'.Try tsatest --help for more information\n");
					ParseError = 0;
				}	
				break;
			}

			if(strstr((const char *)currentTSA->name, "NetWare Cluster File System"))
			{
				strcpy(TSAName, (const char *)currentTSA->name);
				if(strlen(DirName) != 0)
					if (DirName[strlen(DirName) - 1]  !=  '\\')
     					{
     						strcat(DirName, "\\");
     					}
				break;				
			}
			
			/* Next TSA */
			currentTSA = currentTSA->next;
		}

		
		/* Free the TSA list */
		NWSMFreeNameList(&TSAList);	

		
	}

}	
int CmdLineRegisterRoutine(int argc, char *argv[])
{
#ifdef N_PLAT_NLM
	struct ScreenStruct *scrId;
#else
	void *scrId=0;
#endif

	
	cmdLineSwitch_s	specialSwitches[] = 
	{
		{	0,
			"--*", 
			SWOPT_HIDDEN,
			non_opt_processor, 
			0, 
			{0, 0}, 
			0,
			NULL,
			0
		}, 
		{	0,
			"--?", 
			SWTYPE_HELP, 
			display_help, 
			0, 
			{0, 0}, 
			HELP_HELP,
			NULL,
			0
		}, 
		{	0,
			"--help", 
			SWTYPE_HELP, 
			display_help, 
			0, 
			{0, 0}, 
			HELP_HELP,
			NULL,
			0
		}, 
		{	0,
			"--description", 
			SWTYPE_DESCRIPTION|SWOPT_HIDDEN, 
			description, 
			0, 
			{0, 0}, 
			0,
			NULL,
			0
		}, 
		{	0,
			"--usage", 
			SWTYPE_USAGE|SWOPT_HIDDEN, 
			usage, 
			0, 
			{0, 0}, 
			0,
			NULL,
			0
		}, 
		{SW_END_OF_SWITCHES}
	};
	
       cmdLineSwitch_s	initSwitches[] = 
	{
		{	0,
			"--version",
			SWTYPE_INFO,
			getVersion,
			 0,
			{0,0},
			 HELP_INDEX,
			 NULL,
			 0
		 },
		{	"-s",
			 "--server", 
			SWTYPE_VALUE | SWVAL_STRING | SWOPT_SUPPRESS_LONG_OPT_ON_NW, 
			ProcessServerName, 
			ServerName, 
			{64, 0}, 
			HELP_SERVER,
			NULL,
			0
		 }, 
		 {	"-v",
			 "--volume", 
			SWTYPE_VALUE | SWVAL_STRING | SWOPT_SUPPRESS_LONG_OPT_ON_NW, 
			ProcessVolumeName, 
			VolumeName, 
			{32, 0}, 
			HELP_VOLUME,
			NULL,
			0
		 }, 
		 {	 0,
			 "--path", 
			SWTYPE_VALUE | SWVAL_STRING, 
			ProcessPathName, 
			DirName, 
			{512, 0}, 
			HELP_PATH,
			NULL,
			0
		}, 
		{	"-b",
			0, 
			SWTYPE_VALUE | SWVAL_UINT, 
			NULL, 
			&BuffSize, 
			{0, 12345678}, 
			HELP_BUFFER,
			NULL,
			0
		}, 
		{	 "-u",
			 0, 
			SWTYPE_VALUE | SWVAL_STRING, 
			ProcessUserName, 
			UserName, 
			{128, 0}, 
			HELP_USER,
			NULL,
			0
		}, 
		{	 "-p",
			 0, 
			SWTYPE_VALUE | SWVAL_STRING, 
			ProcessPassword, 
			PasswordTempStr, 
			{128, 0}, 
			HELP_PASSWD,
			NULL,
			0
		 }, 
		 {	0,
			 "--log", 
			SWTYPE_OPTIONAL_VALUE | SWVAL_STRING, 
			getLog, 
			LogFileName, 
			{256, 0}, 
			HELP_LOG,
			NULL,
			0
		}, 
		{	"-i",
		 	0, 
			SWTYPE_VALUE | SWVAL_STRING, 
			ProcessIterations, 
			&IterationsString, 
			{256, 0}, 
			HELP_ITER,
			NULL,
			0
		}, 
		 {	0,
			 "--size", 
			SWTYPE_VALUE | SWVAL_UINT, 
			NULL, 
			&DataSetSize, 
			{0, 12345678}, 
			HELP_SIZE,
			NULL,
			0
		},
		{	0,
		 	"--shownames", 
			SWTYPE_BOOL, 
			NULL, 
			&ShowNames, 
			{10, 0}, 
			HELP_SHOW,
			NULL,
			0
		}, 
		{	"-c",
			0, 
			SWTYPE_VALUE | SWVAL_UINT, 
			SpecifyScanType, 
			&ScanType, 
			{0, 12345678}, 
			HELP_SCAN,
			NULL,
			0
		}, 
		{	0,
			 "--pres", 
			SWTYPE_BOOL, 
			NULL , 
			&PresentationMode, 
			{10, 0}, 
			HELP_PRES,
			NULL,
			0
		}, 
		{	0,
			 "--err", 
			SWTYPE_VALUE | SWVAL_STRING, 
			NULL, 
			ErrLog, 
			{256, 0}, 
			HELP_ERR,
			NULL,
			0
		}, 
		{	0,
			 "--fulllog", 
			SWTYPE_BOOL, 
			NULL, 
			&FullLog, 
			{10, 0}, 
			HELP_FULLLOG,
			NULL,
			0
		}, 
		{	0,
			 "--cluster", 
			SWTYPE_BOOL, 
			SpecifyClusterInfo, 
			&Cluster, 
			{10, 0}, 
			HELP_CLUSTER,
			NULL,
			0
		},
		{	0,
			 "--ms", 
			SWTYPE_BOOL, 
			NULL, 
			&Milliseconds, 
			{10, 0}, 
			HELP_MS,
			NULL,
			0
		},
		{	 0,
			 "--microsec", 
			SWTYPE_BOOL, 
			NULL, 
			&UseHiResTimer, 
			{10, 0}, 
			HELP_MICROSEC,
			NULL,
			0
		}, 
		{	0,
			 "--agg", 
			SWTYPE_BOOL, 
			NULL, 
			&Aggregate, 
			{10, 0}, 
			HELP_AGG,
			NULL,
			0
		}, 
		{	"-g",
			0, 
			SWTYPE_VALUE | SWVAL_STRING, 
			GrowFunc, 
			grow, 
			{10, 0}, 
			HELP_GROW,
			NULL,
			0
		}, 
		{	0,
			"--waitonexit", 
			SWTYPE_BOOL, 
			NoWaitOnExit, 
			&NoWait, 
			{10, 0}, 
			HELP_NOWAIT,
			NULL,
			0
		}, 
		{	0,
			 "--ave", 
			SWTYPE_OPTIONAL_VALUE | SWVAL_STRING, 
			getAve, 
			str, 
			{128, 0}, 
			HELP_AVE,
			NULL,
			0
		},	
		{	0,
			 "--bucketCount", 
			SWTYPE_VALUE | SWVAL_UINT, 
			NULL , 
			&MaxHistogramBuckets, 
			{0, 12345678}, 
			HELP_BCOUNT,
			NULL,
			0
		}, 
		{	0,
			 "--maxBucketValue", 
			SWTYPE_VALUE | SWVAL_UINT, 
			NULL , 
			&MaxHistogramBucketValue, 
			{0, 12345678}, 
			HELP_BMAX,
			NULL,
			0
		},
		{	0,
			 "--minBucketValue", 
			SWTYPE_VALUE | SWVAL_UINT, 
			NULL , 
			&MinHistogramBucketValue, 
			{0, 12345678}, 
			HELP_BMIN,
			NULL,
			0
		},
		{SW_END_OF_SWITCHES}
	};

        /* Assume 64kB buffer by default */
        BuffSize = 65536;
        
	/* code for command line processing*/
	mod.headCmd="tsatest";
	mod.getMessage=GetHelpMessage;

#ifdef N_PLAT_NLM
	mod.fileName=NULL;
	mod.threadGroupId = GetThreadGroupID();
	mod.nlmHandle = GetNLMHandle();
	scrId = (struct ScreenStruct *)GetSystemConsoleScreen();
#elif N_PLAT_UNIX
	mod.fileName=NULL;
	mod.threadGroupId = 0;
	mod.nlmHandle = 0;
	

	if(!setlocale(LC_ALL, ""))
	{
		printf("Error: Unable to set the locale information\n");
		return 0;
	}
	if(!bindtextdomain(TSATEST_DOMAIN, TSATEST_LOCALE_DIR))
	{
		printf("Error: Unable to bind to the text domain\n");
		return 0;
	}
	if(!bind_textdomain_codeset(TSATEST_DOMAIN, "UTF-8"))
	{
		printf("Error: Unable to bind to the text domain\n");
		return 0;
	}
	if(!textdomain(TSATEST_DOMAIN))
	{
		printf("Error: Unable to get the domain information\n");
		return 0;
	}

#endif
	mod.help_index_Usage=HELP_Usage;
	mod.help_index_Type=HELP_Type;
	mod.help_index_TRUE=HELP_TRUE;
	mod.help_index_FALSE=HELP_FALSE;
	mod.help_index_Value=HELP_Value;
	mod.help_index_Range=HELP_Range;
	mod.help_index_switch=HELP_switch;
	mod.help_index_Boolean=HELP_Boolean;
	mod.help_index_StartupOnly=HELP_StartupOnly;
	mod.help_index_Informational=HELP_Informational;
	

	cCode=CmdLineInit(&mod);
	if(cCode)
	{
		ParseError = 0;
		return(1);
	}

	cCode = CmdLineRegisterSwitches(specialSwitches);
	if(cCode)
	{
		ParseError = 0;
		return(1);
	}


	cCode = CmdLineRegisterSwitches(initSwitches);
	if(cCode)
	{
		ParseError = 0;
		return(1);
	}

	err = CmdLineProcessData(argc, argv, CMDLN_OPTION_LOAD_TIME);
	
	if( err.err != CMDLN_SUCCESS)
	{
		ProcessErrors(err, scrId);
	}	
		
	CmdLineDeInit();

	/*checks whether volume is specified while connecting to Linux TSA*/
	CheckForVolumeAndTSA();

	
	return(1);
}


void ScreenInitialization()
{
	UINT32 cCode;
	NWSM_NAME_LIST  	*TSAList;
	NWSM_NAME_LIST  	*currentTSA;
	char 			*envPasswd = NULL;
	NWBOOLEAN isEnvSet = FALSE;
	UINT32 	      tsaTempConn;
	
	/* screen initializations in LINUX*/
#ifdef N_PLAT_UNIX
        initscr();
        clear();
        refresh();
#endif
 	/* Show a title */
 	StatText0(18, 0, "SMS - TSA Statistical Analyzer");

        /* Title the statistics */
        StatText0(X_READ_COUNT, Y_READ_COUNT, "Read Count:       ");
        StatText0(X_MIN_READ_TIME, Y_MIN_READ_TIME, "Min. Read Time:   ");
        StatText0(X_LAST_READ_SIZE, Y_LAST_READ_SIZE, "Last Read Size:   ");
        StatText0(X_LAST_READ_TIME, Y_LAST_READ_TIME, "Last Read Time:   ");
        StatText0(X_TOTAL_BYTES_READ, Y_TOTAL_BYTES_READ, "Total Bytes Read: ");
        StatText0(X_MAX_READ_TIME, Y_MAX_READ_TIME, "Max. Read Time:   ");
        StatText0(X_RAW_DATA_RATE, Y_RAW_DATA_RATE, "Raw Data MB/min:  ");
        StatText0(X_AVE_READ_TIME, Y_AVE_READ_TIME, "Avg. Read Time:   ");
        StatText0(X_BACKUP_SETS, Y_BACKUP_SETS, "Backup Sets:      ");
        StatText0(X_TSA_TIME, Y_TSA_TIME, "Total TSA Time:   ");
        StatText0(X_TOTAL_READ_TIME, Y_TOTAL_READ_TIME, "Total Read Time:  ");
        StatText0(X_AVE_OPEN_TIME, Y_AVE_OPEN_TIME, "Avg. Open Time:   ");
        StatText0(X_AVE_SCAN_TIME, Y_AVE_SCAN_TIME, "Avg. Scan Time:   ");
        StatText0(X_AVE_CLOSE_TIME, Y_AVE_CLOSE_TIME, "Avg. Close Time:  ");
        StatText0(X_EFFECTIVE_DATA_RATE, Y_EFFECTIVE_DATA_RATE, "Effective MB/min: ")
        StatText0(X_ELAPSED_TIME, Y_ELAPSED_TIME, "Elapsed Time:     ");
        StatText0(X_EST_ERROR, Y_EST_ERROR, "Max. Error:       ");
        StatText0(X_AVE_FILE_READ_TIME, Y_AVE_FILE_READ_TIME, "Avg. File Read Time: ");

        /* If we need to prompt for the user name do so */
        if (!uNameStored && ParseError)
        {
                DCLogText0("Enter User Name: ");
#ifdef N_PLAT_UNIX				
                getstr(UserName);
#elif N_PLAT_NLM
		  gets(UserName);
#endif
        }

        if( !Helped  && ParseError && strlen(Password) < 1)
	{
		
#ifdef N_PLAT_UNIX
		/* Check the environmental variable for Password */
		envPasswd = getenv(NBACKUP_SMS_PASSWORD);
		if( envPasswd && (strlen(envPasswd) > 0) )
		{
			isEnvSet = TRUE;
			pwLen = (unsigned short)strlen(envPasswd);
		     *(unsigned short *)&(Password[0]) = pwLen;
		     strcpy(&(Password[2]), envPasswd);
		}
#endif		
		if(isEnvSet)
		{
			if (NWSMConnectToTSA(TSAName, &tsaConn) == 0)
			   {
			           if (NWSMTSListTargetServices(tsaConn, "*", &TSAList) == 0)
			           {
			          	  currentTSA = TSAList;
			                   while (currentTSA != NULL)
			                   {
			                   	  /* Save the entry */
			                         strcpy(ServiceName, (const char *)currentTSA->name);
			                          /* Next entry */
			                         currentTSA = currentTSA->next;
			                    }

			                     /* Free the TSA list */
			                     NWSMFreeNameList(&TSAList);                       	
			           }
			}

			cCode = TargetServiceConnection();

			if( cCode == NWSMTS_LOGIN_DENIED && isEnvSet)
			{
				LogText0("Password specified by environment variable incorrect\n");
				pwdStored = FALSE;
			}
			if(!cCode)
				pwdStored = TRUE;

			NWSMTSReleaseTargetService(&tsaConn); 
			                                                          		
			NWSMReleaseTSA(&tsaConn); 

			tsaConn = 0;
		}
	}	
	
        /* If we need to prompt for the password do so */
        if ( !pwdStored)
        {
                if (pwdStored && getPassword)
                {
                        ConsolePrintf("Invalid Usage: Use either one of \"/P=\" or \"/P\"\n");
                        ParseError = 0;
                }
                else
                {
                        if (uNameStored)
                                DCLogText1("User: %s\n", UserName);
                        if(ParseError && !pwdStored)
                        {
                                DCLogText0("Enter Password: ");
                                getpw(Password);
                        }
                }
        }

       
        if (!Helped)
        {
                /* Show what we are doing */
                LogText3("Backing up: %s/%s with %d byte buffer", ServerName, VolumeName, BuffSize);
        }

	 return;	


}

/* Validate arguments */
int ValidateArguments(int argc, char *argv[])
{
       UINT32 bucketRange; 
	
	/*Register the arguments with command line framework*/	
	CmdLineRegisterRoutine(argc,argv);
	/*if the --? or --help is used*/
	if(Helped || !ParseError)
       {
		return 0;
       }

	if(LogData)
	{
		bucketRange = MaxHistogramBucketValue - MinHistogramBucketValue;
		if(bucketRange % MaxHistogramBuckets)
		{
			printf(" The difference between maxBucketValue and minBucketValue should be a multiple of bucketCount\n");	
			ParseError = 0;
			return 0;
		}	
	}
	/*Initialize the screen*/
	ScreenInitialization();

        return (ParseError);
}

/* Get a password from the user to be used in conjunction with the user name. */
void getpw(char *password)
{
	    int count = 2;

#ifdef N_PLAT_UNIX
	    noecho();
#endif

	    while (count)
	    {
	            switch (password[count] = getch())
	            {
	            	case '\r':
	            	case '\n':
	                    	*(UINT16 *)password = count - 2;
	                    	count = 0;
	                    	break;
	                    

	            	case '\b':
	                    	if (count > 2)
	                        	--count;
	                    	else
	                        	putch('\a');
	                   	break;

	            	default:
	                 	++count;
	                    	break;
	            }
	    }

	    fflush(stdin);

	    return;	
}

/*********************************************************************
* NAME: IsRelativePath
*
* WHAT: 
*
* SMS-SPECIFIC ROUTINES CALLED: 
*
**********************************************************************/

NWBOOLEAN IsRelativePath(char *path)
{
/*Connecting to Remote Linux system from Netware,Relative path makes no sense*/
#ifdef N_PLAT_UNIX
	char * tok = NULL;
	
	if( !strcmp(path, ".") || !strncmp(path , "./", 2) ||!strcmp(path, "..") || !strncmp(path , "../", 3) )
		return TRUE;
#endif

	return FALSE;
}


/*********************************************************************
* NAME: GetAbsoutePath
*
* WHAT: 
*
* SMS-SPECIFIC ROUTINES CALLED: 
*
**********************************************************************/

char * GetAbsoutePath(char *relPath)
{
#ifdef N_PLAT_UNIX
	char *absPath = NULL;
	char *cwd = NULL;
	int len = 0;
	cwd = getcwd(NULL, 0);
	if( cwd == NULL)
	{
		return NULL;
	}
	if( (strcmp(relPath,".") == 0) )
	{
		absPath = (char*)malloc( strlen(cwd)+1);
		if( absPath == NULL)
		{
			//PrintMsg(NBK_ERR_MSG, NBK_OUT_OF_MEMROY);
			goto Return;
		}
		strcpy(absPath, cwd);
	}
	else if (strncmp(relPath , "./", 2) == 0)
	{
		absPath = (char*) malloc( strlen(cwd)+strlen(relPath) -1);
		if( absPath == NULL)
		{
			//PrintMsg(NBK_ERR_MSG, NBK_OUT_OF_MEMROY);
			goto Return;
		}
		strcpy(absPath, cwd);
		strcat(absPath, relPath+1);
	}
	else if (strncmp(relPath , "..", 2) == 0)
	{
		char *tok = relPath;
		char *stripTo = NULL,*tail = NULL;

		tail = tok = strstr(tok, "..");
		stripTo = cwd;
		while( tok)
		{
			if((*(tok+2) != (char) '/') && (*(tok+2) != '\0')) 
				break;

			len = tok - tail;
			if(len > 3)
			{
				break;
			}
			else if((len == 2) && (strncmp(tail, "..",len) != 0)) 
			{
				break;
			}
			else if( (len == 3) && (strncmp(tail, "/..", len) != 0) )
			{
				break;
			}
			tail = tok;
			tail += 2;
			stripTo = strrchr(cwd, '/');
			if(stripTo && (strcmp(stripTo, "/") != 0))
				*stripTo = 0;
			tok = strstr(tail, "..");
		}
		absPath = (char*)malloc( strlen(cwd)+strlen(tail) +1);
		if( absPath == NULL)
		{
			//PrintMsg(NBK_ERR_MSG, NBK_OUT_OF_MEMROY);
			goto Return;
		}
		strcpy(absPath, cwd);
		strcat(absPath, tail);
	}
Return:
	if( cwd)
		free( cwd);
return absPath;
#else
	return NULL;
#endif
}

CCODE TargetServiceConnection()
{
	unsigned int	actLen;
	unsigned char	utf8Pwd[MAX_PASSWORD_SIZE * MAX_UTF8_CHAR_SIZE];

	/* Functions that will be imported */
	CCODE  (*mPtrConnectToTargetServiceEx)(UINT32 *, STRING , STRING , void *, UINT32 ) = NULL;

	/* Connect to the target service */
#ifdef N_PLAT_NLM
	/* Try the NWSMTSConnectToTargetServiceEx function first */
	mPtrConnectToTargetServiceEx = ImportSymbol(GetNLMHandle(), "NWSMTSConnectToTargetServiceEx");
#elif N_PLAT_UNIX
	/* This symbol is not dynamically resolved as it is supported on all SMS versions on Linux */
	mPtrConnectToTargetServiceEx = NWSMTSConnectToTargetServiceEx;
#endif
	if(mPtrConnectToTargetServiceEx)
	{
		/* NWSMTSConnectToTargetServiceEx exists. Convert the input to UTF-8 and attempt to connect */
		Password[*(UINT16 *)Password + sizeof(UINT16)] = 0;
		actLen = sizeof(utf8Pwd);
		ccode = SMloc2utf8(utf8Pwd, &actLen, &(Password[sizeof(UINT16)]), 
		*(UINT16 *)Password + sizeof(char), NULL);
		if (ccode)
		{
			/* Failed conversion, signal error and exit */
			LogText1("Error converting password to UTF-8 %x\n", ccode);
		}
		*((UINT16 *)(Password)) = strlen(utf8Pwd); 
		memcpy(&(Password[2]), utf8Pwd, strlen(utf8Pwd));
		/* Call NWSMTSConvertToTargetServiceEx with the UTF-8 encoded password */		
		ccode = (*mPtrConnectToTargetServiceEx)(&tsaConn, (unsigned char *)ServiceName, 
													  (unsigned char *)UserName, 
													  (unsigned char *)Password, 
													  NWSM_AUTH_UTF8_DATA );
			
		/* The function is not supported by the remote SDMR or target service, use the older API to authenticate */
		if(ccode == NWSMDR_UNSUPPORTED_FUNCTION || ccode == NWSMTS_UNSUPPORTED_FUNCTION)
		{
#ifdef N_PLAT_NLM
			UnimportSymbol(GetNLMHandle(), "NWSMTSConnectToTargetServiceEx");
#endif
			mPtrConnectToTargetServiceEx = NULL;
		}
		/* Function is supported but the UTF-8 password failed authentication */
		else if (ccode)
		{
			/* Possibly the user password may still be valid in RAW format.*/
			ccode = (*mPtrConnectToTargetServiceEx)(&tsaConn, (unsigned char *)ServiceName,
														    (unsigned char *)UserName,
														    (unsigned char *)Password, 
														    NWSM_AUTH_RAW_DATA);	
			if(ccode)										 
			{
				LogText1("Error code NWSMTSConnectToTargetServiceEx %x\n",ccode);
			}
		}
	}
	if (!mPtrConnectToTargetServiceEx)
	{
		/* Target service does not support NWSMTSConnectToTargetServiceEx, use the older NWSMTSConnectToTargetService API */
		ccode=NWSMTSConnectToTargetService(&tsaConn, (unsigned char *)ServiceName, (unsigned char *)UserName, (unsigned char *)Password);
		if(ccode)
		{	
			LogText1("Error code NWSMTSConnectToTargetService %x\n", ccode);
			/* if unable to connect to target service due tpo wrong password,stop iterations using PasswordValidate*/
			PasswordValidate=0;
		}
	}

	return(ccode);

}

void NameSpaceInfo()
{
CCODE	err;

#ifdef N_PLAT_NLM
	UINT32 (*GetSupportedNameTypes)(UINT32, UINT32 *) = 0;
	UINT32 (*GetTargetServiceApiVersion)(UINT32, UINT32 *, UINT32*) = 0;
#endif

#ifdef N_PLAT_NLM
	GetTargetServiceApiVersion= ImportSymbol(GetNLMHandle(), "NWSMTSGetTargetServiceAPIVersion");
	 if (GetTargetServiceApiVersion)
	 {
		if ((ccode = GetTargetServiceApiVersion(tsaConn, &tsaMajorVersion, &tsaMinorVersion)) == 0)
		{
			if (tsaMajorVersion > 0x2)
			{
				GetSupportedNameTypes = ImportSymbol(GetNLMHandle(), "NWSMTSGetSupportedNameTypes");
				if (GetSupportedNameTypes)
				{
					if ((ccode = GetSupportedNameTypes(tsaConn, &supportedTypes)) == 0)
					{
						if (supportedTypes & NWSM_NAME_TYPE_UTF8)
						{
							scanControl.returnNameSpaceType = NWSM_ALL_NAME_SPACES_UTF8;
							IsUTF8Supp = TRUE;
						}
					}
					UnimportSymbol(GetNLMHandle(), "NWSMTSGetSupportedNameTypes");
				}
			}
		}
		UnimportSymbol(GetNLMHandle(), "NWSMTSGetTargetServiceAPIVersion");
	}
#elif defined(N_PLAT_UNIX)
	if ((ccode = NWSMTSGetTargetServiceAPIVersion(tsaConn, &tsaMajorVersion, &tsaMinorVersion)) == 0)
	{
		if(tsaMajorVersion > 0x2)
		{
			if ((ccode = NWSMTSGetSupportedNameTypes(tsaConn, &supportedTypes)) == 0)
			{
				if(supportedTypes & NWSM_NAME_TYPE_UTF8)
				{
					scanControl.returnNameSpaceType = NWSM_ALL_NAME_SPACES_UTF8;
					IsUTF8Supp = TRUE;
				}	
			}
		}
	}
#endif
       /* Get the namespaces supported */
       nsSeq = 0;
       nsLine[0] = 0;
       while ((err = NWSMTSScanSupportedNameSpaces(tsaConn, &nsSeq, (STRING)TSAResourceName, &nsNum, (STRING)nsName)) == 0)
       {
       	sprintf(nsTmp, "%X - %s ", nsNum, nsName);
              strcat(nsLine, nsTmp);
              if (nsNum > 4)
              {
                    	if(IsUTF8Supp)
                 		nsNum=MapToUtf8NameSpace(nsNum);
	       	if ((nsFirstSep == NULL) && ((err = NWSMTSGetNameSpaceTypeInfo(tsaConn, nsNum, &nsRev, &nsFirstSep, &nsSecondSep)) != 0))
                     {
                     	 LogText1("Failed to get name space type information: %x", err);
                             if (fErrLog)
                            	 fprintf(fErrLog, "Failed to get name space type information: %x\n", err);
                             if (AllVolNames[0] != NULL)
                             {
                             	free(AllVolNames[0]);
                                   AllVolNames[0] = NULL;
                             }
                     }
                     else
                     	foundNSSep = TRUE;

			sprintf(nsTmp, "S1=%s, S2=%s, Rev=%d ", nsFirstSep->string, nsSecondSep->string, nsRev);
                     strcat(nsLine, nsTmp);
               }
               else
               {
               	if ((nsFirstSep == NULL) && ((err = NWSMTSGetNameSpaceTypeInfo(tsaConn, 0, &nsRev, &nsFirstSep, &nsSecondSep)) != 0))
               	{
                     	LogText1("Failed to get name space type information: %x", err);
                            if (fErrLog)
                            	fprintf(fErrLog, "Failed to get name space type information: %x\n", err);
                            if (AllVolNames[0] != NULL)
                            {
                            	free(AllVolNames[0]);
                                   AllVolNames[0] = NULL;
                            }
                      }
                      else
                      	foundNSSep = TRUE;
                 }                                                          
	}

	 return;   
}

int main(int argc, char *argv[])
{
       int 			retval = 0;
       NWSM_NAME_LIST  *TSAList;
       NWSM_NAME_LIST  *currentTSA;
       UINT32          startTime;
       int             scanTypeNumber;
       int             backupTerminatedBy = 0;
      	NWSM_DATA_SET_NAME_LIST         *dataSetNameList;
       NWSM_DATA_SET_NAME_LIST         *resourceName;
      	CCODE	err;
	int 			rcode;
	size_t 			destLen=0;
	utf8_t 			*dest;
	STRING_BUFFER 		*FixedNameWorkspace=NULL;
	char 				*DirPathName = NULL;
#ifdef N_PLAT_UNIX	
	int 				myThreadGroupID;	
	char 			name[64];
       UINT32 			len=64;
	NWSM_NAME_LIST  *SMDRnameList;
       NWSM_NAME_LIST  *currentName;
#endif
	
	
       signal(SIGINT, UnloadHandler);
	signal(SIGTERM, UnloadHandler);
	
#ifdef N_PLAT_NLM
	SMImportUniAPIs( GetNLMHandle());
#endif

       /* If Netware is used,change the default logfile name and moving-avg. filename*/
#ifdef N_PLAT_NLM        
         strcpy(LogFileName,"SYS:\\ETC\\TSATEST.LOG");
         strcpy(maFileName,"SYS:\\ETC\\TSATEST.AVE");
#endif        
               
	/*for hiding the cursor in Netware*/
        SetCursorShape(0x20, 0x20);
        
        /* Get the server name and namespace we are running on */
#ifdef N_PLAT_NLM
	/*Default namespace for Netware(DOS namespace) is 0*/
	nameSpace=0;
       ServerName[0] = '\0';
       snameLen = ReturnFileServerName(ServerName);
       ServerName[snameLen] = '\0';
       strcpy(ServerName, ServerName + 1);   
#endif
		
#ifdef N_PLAT_UNIX   
        /*Default namespace for Linux(NFS namespace) is 2*/
	nameSpace=2;
       gethostname(ServerName,len);
#endif

	/*Initialize the all volumes array*/	
        memset(AllVolNames, 0, sizeof(AllVolNames));
	
	
      /* Parse the arguments */
        if (ValidateArguments(argc, argv))
        {
		  if(LogData)
		  {
		  	scanHistogram = (int *)malloc((MaxHistogramBuckets + 2) * sizeof(int));
		  	openHistogram = (int *)malloc((MaxHistogramBuckets + 2) * sizeof(int));
		  	readHistogram = (int *)malloc((MaxHistogramBuckets + 2) *sizeof(int));
		  	closeHistogram = (int *)malloc((MaxHistogramBuckets + 2) * sizeof(int));
		  }
		  /* Title the log area */
                if (!PresentationMode)
                {
                        StatText0(0, MIN_LOG_LINE - 1, "LOG:");
                }

                if (ShowNames)
                        StatText0(X_CURRENT_NAME, Y_CURRENT_NAME, "Name: ");

                MaxIterations = Iterations;
                if (MaxIterations)
                {
                        StatText0(X_ITERATION, Y_ITERATION, "Iteration/Of:     ");
                }

                if (ErrLog[0])
                {
                        fErrLog = fopen(ErrLog, "wt");						
                }

                if (Average)
                {
                        maData = malloc(sizeof(MOVING_AVERAGE_NODE) * maGroupLen);
                        if (maData == NULL)
                        {
                                LogText0("Failed to allocate memory for moving average tracking");
                                goto QuickExit;
                        }

                        fMovingAve = fopen(maFileName, "wt");
                        if (fMovingAve == NULL)
                        {
                                LogText0("Failed to open file for moving average output");
                                goto QuickExit;
                        }

                        /* Write the header */
                        fprintf(fMovingAve, "Average MB/min,Files,Average File Size\n");
                }

                /* Run multiple iterations */
                do
                {
                        if (MaxIterations)
                        {
                                StatText2(X_ITERATION + X_DATA_OFFSET, Y_ITERATION, "%d/%d    ", MaxIterations - Iterations + 1, MaxIterations);
                                if (fErrLog)
                                {
                                        fprintf(fErrLog, "Iteration %d/%d\n", MaxIterations - Iterations + 1, MaxIterations);
                                }
                        }
                        
                      
                        /* No TSA found yet */
                        TSAName[0] = '\0';

                        /* Initialise the NetWare SDK */
                        if (NWCallsInit(NULL, NULL) == 0)
                        {
                                LogText0("SDK Initialised");

                                /* If no name was found */
                                if (strlen(ServerName) != 0)
                                {
                                        LogText1("SERVER NAME: %s", ServerName);
                                }
                                else
                                {
                                        LogText0("Failed to get server name");
                                        if (fErrLog)
                                                fprintf(fErrLog, "Failed to get server name\n");
#ifdef N_PLAT_NLM
                                        NWCallsTerm(NULL);
#endif
                                        UnloadState |= TSATEST_UNLOADED;
                                        return (0);
                                }
                                
                                strcpy(wildName, ServerName);
                                strcat(wildName, ".*");
                                if (NWSMListTSAs(wildName, &TSAList) == 0)
                                {
                                        /* Iterate the TSAs */
                                        LogText0("TSA LIST:");
                                        currentTSA = TSAList;
                                                
                                        while(currentTSA != NULL)
                                        {
                                                /* Show the current name */
                                                LogText1("  %s", currentTSA->name);
                                                        
                                                if ((strstr((const char *)currentTSA->name, ".NetWare File System") != NULL) && !Cluster && !DoNDS)
                                                {
                                                        /* Copy the TSA name, this is the one we will connect to */
                                                        strcpy(TSAName, (const char *)currentTSA->name);
								nameSpace = 0;
								if(volumeNameSpecified == 0)
								{
									strcpy(VolumeName, "SYS:");
								}
								/* The default behaviour of TSATEST has been changed to backup only the stubs - 26 May 04. */
                                                        scanControl.scanType |= NWSM_EXCLUDE_MIGRATED_CHILD;                                                            
                                                }

                                                if ((strstr((const char *)currentTSA->name, ".Linux File System") != NULL) && !Cluster && !DoNDS)
                                                {
                                                		/* Copy the TSA name, this is the one we will connect to */
                                                		strcpy(TSAName, (const char *)currentTSA->name);
								nameSpace = 2;
								strcpy(VolumeName, "/");
								 /* The default behaviour of TSATEST has been changed to backup only the stubs - 26 May 04. */
                                                         scanControl.scanType |= NWSM_EXCLUDE_MIGRATED_CHILD;                                                            
                                                 }
                                                        
                                                 if ((strstr((const char *)currentTSA->name, ".NetWare Cluster File System") != NULL) && Cluster)
                                                 {
                                                 	 /* Copy the TSA name, this is the one we will connect to */
                                                         strcpy(TSAName, (const char *)currentTSA->name);
								 nameSpace = 0;
								 scanControl.scanType |= NWSM_EXCLUDE_MIGRATED_CHILD;                                                            
                                                  }
                                                  if ((strstr((const char *)currentTSA->name, ".Novell Directory") != NULL) && DoNDS)
                                                  {
                                                  	/* Copy the TSA name, this is the one we will connect to */
                                                        strcpy(TSAName, (const char *)currentTSA->name);
                                                   }

                                                   /* Next TSA */
                                                   currentTSA = currentTSA->next;
                                        }

                                         /* Free the TSA list */
                                        if (NWSMFreeNameList(&TSAList) != 0)
                                        {
                                        		LogText0("Failed to free TSA list");
                                                 if (fErrLog)
                                                 	fprintf(fErrLog, "Failed to free TSA list\n");
                                        } 
                                }
                                else
                                {
                                	LogText0("Failed to list TSAs");
                                   if (fErrLog)
                                   	fprintf(fErrLog, "Failed to list TSAs\n");
                                 }

				     if (!AllVolumes)
	                    	     {
		                            if (!DoNDS)
		                            {
		                                    AllVolNames[0] = malloc(strlen(VolumeName) + 1);
					       }
		                            else
		                            {
		                                    AllVolNames[0] = malloc(24);
		                            }
		                            if (AllVolNames[0] == NULL)
		                            {
		                                    goto QuickExit;
		                            }
		                            if (!DoNDS)
		                            {
		                                    strcpy(AllVolNames[0], VolumeName);
		                            }
		                            else
		                            {
		                                    strcpy(AllVolNames[0], "Full Directory Backup");
		                            }
	                    		}
			
                
                                /* If we found a TSA */
                                if (strlen(TSAName) != 0)
                                {
                                 	/* Connect to the TSA */
                                   if (NWSMConnectToTSA(TSAName, &tsaConn) == 0)
                                   {
                                   	LogText1("Connected to TSA: %s", TSAName);
                                           /* Get the target services list */
                                           if (NWSMTSListTargetServices(tsaConn, "*", &TSAList) == 0)
                                           {
                                          	  /* Iterate the responses */
                                                   LogText1("TARGET SERVICES: %x", TSAList);
                                                   currentTSA = TSAList;
                                                   while (currentTSA != NULL)
                                                   {
                                                   	 /* Show the entry */
                                                         LogText1("  %s", currentTSA->name);
                                                         /* Save the entry */
                                                         strcpy(ServiceName, (const char *)currentTSA->name);
                                                          /* Next entry */
                                                         currentTSA = currentTSA->next;
                                                    }

                                                     /* Free the TSA list */
                                                     if (NWSMFreeNameList(&TSAList) != 0)
                                                     {
                                                     	LogText0("Failed to free Target Services list");
                                                        if (fErrLog)
                                                        	fprintf(fErrLog, "Failed to free Target Services list\n");
                                                     }
                                           }
                                           else
                                           {
                                           	LogText0("Failed to list target services");
                                                  if (fErrLog)
                                                 	fprintf(fErrLog, "Failed to list target services\n");
                                           }

                                           /* If we found a service */
                                           if (strlen(ServiceName) != 0)
                                           {
                                           	ccode=TargetServiceConnection();
							if (ccode == 0)
                                                 {
                                                 	 LogText0("SCAN TYPES:");
                                                         for (scanTypeNumber = 0; scanTypeNumber < 32; scanTypeNumber++)
                                                         {
                                                        	  /* Get the target scan types */
                                                                 if (NWSMTSGetTargetScanTypeString(tsaConn, (UINT8)scanTypeNumber, (STRING)ScanTypeString, &typeReqd, &typeDisallowed) == 0)
                                                                 {
                                                               	   LogText1("  %s", ScanTypeString);
                                                                  }
                                                         }

                                                         /* List the resources the TSA can use */
                                                         LogText0("RESOURCES:");
                                                         tsaSeq = 0;
                                                         WorkingVolume = 0;
                                                         while ((err = NWSMTSScanTargetServiceResource(tsaConn, &tsaSeq, (STRING)TSAResourceName)) == 0)
                                                         {
                                                         	/* Show the resource name */
                                                               LogText1("  %s", TSAResourceName);

									/* Show the extra resource info */
									PrintResourceExtensions();						
									                                                                                                                              
                                                               /* Save the name if we are working on all volumes */
                                                               if ((AllVolumes) 
                                                                      	&& (WorkingVolume < 256) 
                                                                             && (TSAResourceName[strlen(TSAResourceName) - 1] == ':')
                                                                             && (strstr(TSAResourceName, "NSS_ADMIN") != TSAResourceName) 
                                                                             && (strstr(TSAResourceName, "_ADMIN") != TSAResourceName))
                                                               {
                                                                	AllVolNames[WorkingVolume] = malloc(strlen(TSAResourceName) + 1);
                                                                      if (AllVolNames[WorkingVolume] != NULL)
                                                                      {
                                                                      	strcpy(AllVolNames[WorkingVolume], TSAResourceName);
                                                                             WorkingVolume++;
                                                                      }
                                                               }
									NameSpaceInfo();
                                                               LogText0(nsLine);
                                                         }

                                                          if (!foundNSSep)
                                                          {
                                                           	LogText1("Failed to get name space type information: %x", err);
                                                               if (fErrLog)
                                                               	fprintf(fErrLog, "Failed to get name space type information: %x\n", err);
                                                               if (AllVolNames[0] != NULL)
                                                               {
                                                               	 free(AllVolNames[0]);
                                                                       AllVolNames[0] = NULL;
                                                                }
                                                          }
                                                          else
                                                          	foundNSSep = FALSE;

								  delay(1000);

                                                           /* Delay for a moment */
                                                          if (!PresentationMode)
                                                          {
                                                                delay(10000);
                                                          }
								 
								    /* Backup each specified item */
                                                           for (WorkingVolume = 0; 
                                                                                (AllVolNames[WorkingVolume] != NULL) 
                                                                                        && (backupTerminatedBy != 27); 
                                                                                WorkingVolume++)
                                                            {                                                                         
                                                                        resourceName = NULL;
                                                                        dataSetNameList = NULL;
                                                                        scanInfo = NULL;
                                                                        /* 
                                                                                - If the user has specified a scanType, then it overrides all default behaviours. The users of this switch (Usually developers) 
                                                                                   need to ensure that they don't end up in demigration by using apt values.
                                                                                - Using an additional bool variable as there is correct UINT32 value that can be stored in ScanType itself
                                                                                   to indicate whether user had specified an overriding value or not.
                                                                        */
                                                                        if(isScanTypeSpecifiedInCmdLine)
                                                                                scanControl.scanType = ScanType;


										  if(strstr(TSAName, ".Linux File System") != NULL)
										  {
										  	   if(strlen(DirName) != 0)
											   {
													if(IsRelativePath(DirName))
													{
														DirPathName = GetAbsoutePath(DirName);
												 		sprintf(NameWorkspace,"%s", DirPathName);
												 		if(DirPathName)
                	                                                                                     free(DirPathName);	
													}
													else
														sprintf(NameWorkspace, "%s", DirName);
											   }
											   else
												 	sprintf(NameWorkspace,"%s",VolumeName);
										  }
										 else
                                                                       	sprintf(NameWorkspace, "%s%s", AllVolNames[WorkingVolume], DirName);
																				 	
										  ccode=NWSMTSFixDataSetName(tsaConn,NameWorkspace,nameSpace,TRUE,FALSE,&FixedNameWorkspace);
										  strcpy(NameWorkspace,FixedNameWorkspace->string);
										  free(FixedNameWorkspace);
										  FixedNameWorkspace=NULL;
										  LogText1("Backing up: %s", NameWorkspace);
                                                                        StatText1(X_CURRENT_VOLNAME, Y_CURRENT_VOLNAME, "Backing Up :%s", NameWorkspace);
                                                                        if(IsUTF8Supp)
                                                                        {																		
                                                                        	rcode = SMloc2utf8(NULL, &destLen,NameWorkspace, strlen(NameWorkspace),NULL) ;
											if (rcode)
											{
												printf("SMloc2utf8 error code:0x%x\n",rcode);
											}
				
											destLen++;
											dest= (utf8_t *)malloc(destLen);
											if (dest == NULL)
											{
												printf("\nERROR: Could not allocate Memory!\n");
											}
											rcode = SMloc2utf8(dest, &destLen,NameWorkspace, strlen(NameWorkspace),NULL) ;
											if (rcode)									
											{
												printf("SMloc2utf8 error code:0x%x\n",rcode);
												if (dest)
												{
													free(dest);
													dest = NULL;
												}
											}
											nameSpace = MapToUtf8NameSpace(nameSpace);
											ccode = NWSMPutOneName((void **)&resourceName, 
																				strlen(DirName) == 0 ? NWSM_TSA_DEFINED_RESOURCE_TYPE : nameSpace, 
																				0L, 
																				0, 
																				(unsigned char *)nsFirstSep->string, 
                                                                        										(unsigned char *)nsSecondSep->string, 
                                                                        										(unsigned char *)dest);
											if (dest)
											{
												free(dest);
												dest = NULL;
											}
											

                                                                        }
                                                                        else
                                                                        {
                                                                        	ccode = NWSMPutOneName((void **)&resourceName, 
                                                                        												strlen(DirName) == 0 ? NWSM_TSA_DEFINED_RESOURCE_TYPE : nameSpace,
                                                                        												0L,
                                                                        												0, 
                                                                        												(unsigned char *)nsFirstSep->string, 
                                                                        												(unsigned char *)nsSecondSep->string, 
                                                                        												(unsigned char *)NameWorkspace);

                                                                        }
                                                                        if (ccode == 0)
                                                                        {
                                                                                if (!Aggregate || FirstPass)
                                                                                {
                                                                                        /* Initialise state */
                                                                                        backedUpSets = 0;
                                                                                        maxReadTime = 0;
                                                                                        minReadTime = 0xFFFFF;
                                                                                        readCount = 0;
                                                                                        scanCount = 0;
                                                                                        totalBytesRead = 0;
                                                                                        totalCloseTime = 0;
                                                                                        totalOpenTime = 0;
                                                                                        totalReadTime = 0;
                                                                                        totalScanTime = 0;
                                                                                        totalTime = 0;
                                                                                        if(scanHistogram)
	                                                                                        memset(scanHistogram, 0, (MaxHistogramBuckets+2) * sizeof(int));
												    if(openHistogram)
	                                                                                        memset(openHistogram, 0, (MaxHistogramBuckets+2) * sizeof(int));
												    if(readHistogram)
	                                                                                        memset(readHistogram, 0, (MaxHistogramBuckets+2) * sizeof(int));
												    if(closeHistogram)
	                                                                                        memset(closeHistogram, 0, (MaxHistogramBuckets+2) * sizeof(int));
                                                                                        time(&backupStart);
                                                                                }

                                                                                /* No moving average data yet */
                                                                                if (Average)
                                                                                {
                                                                                        if (maData != NULL)
                                                                                        {
                                                                                            memset(maData, 0, sizeof(MOVING_AVERAGE_NODE) * maGroupLen);
                                                                                        }
                                                                                        maSamples = 0;
                                                                                        maInsert = 0;
                                                                                        maSetTotalBytes = 0;
                                                                                        maSetTotalTime = 0;
                                                                                        maTotalBytes = 0;
                                                                                        maTotalTime = 0;
                                                                                }

                                                                                /* Create a data set */
                                                                                startTime = GetTimer();
                                                                                tsaSeq = 0;
                                                                                if ((err = NWSMTSScanDataSetBegin(tsaConn, resourceName, &scanControl, selectionList, &tsaSeq, &scanInfo, &dataSetNameList)) == 0)
                                                                                {
                                                                                        LogText0("Data Set Begun");

                                                                                        backupTerminatedBy = DoBackup(tsaConn, &tsaSeq, &dataSetNameList, startTime);
                                                                                        if (backupTerminatedBy == 27)
                                                                                        {
                                                                                                LogText0("Backup set ended ");
                                                                                                if (fErrLog)
                                                                                                fprintf(fErrLog, "Backup set ended \n");

                                                                                                if ((err = NWSMTSScanDataSetEnd(tsaConn, &tsaSeq, &scanInfo, &dataSetNameList)) != 0)
                                                                                                {
                                                                                                        LogText1("Failed to end backup set: %X", err);
                                                                                                        if (fErrLog)
                                                                                                                fprintf(fErrLog, "Failed to end backup set: %X\n", err);
                                                                                                }

                                                                                                Iterations = 0;
                                                                                        }
                                                                                }
                                                                                else
                                                                                {
                                                                                        LogText1("Failed to begin data set: %X", err);
                                                                                        if (fErrLog)
                                                                                                fprintf(fErrLog, "Failed to begin data set: %X\n", err);
                                                                                }

                                                                                /* Cleanup the resource name */
                                                                                free(resourceName);
                                                                        }
                                                                        else
                                                                        {
                                                                                LogText0("Failed to put one name in resource name");
                                                                                if (fErrLog)
                                                                                        fprintf(fErrLog, "Failed to put a name in resource name structure\n");
                                                                        }
                                                                        FirstPass = 0;
                                                            }

								    if (nsFirstSep != NULL)
                                                            {
                                                            		free(nsFirstSep);
                                                                	free(nsSecondSep);
                                                                	nsFirstSep = NULL;
                                                                 	nsSecondSep = NULL;
                                                             }

                                                              /* Close the connection */
                                                              if (NWSMTSReleaseTargetService(&tsaConn) != 0)
                                                              {
                                                              		LogText0("Failed to disconnect Target Service");
                                                                      if (fErrLog)
                                                                      	fprintf(fErrLog, "Failed to disconnect Target Service\n");
                                                               }
                                                        }
                                                        else
                                                        {
                                                                LogText0("Error:Failed to connect Target Service:Username or Password invalid\n");
                                                                if (fErrLog)
                                                                        fprintf(fErrLog, "Error:Failed to connect Target Service:Username or Password invalid\n");
                                                        }
                                                }

                                                /* Disconnect from the TSA */
                                                if (NWSMReleaseTSA(&tsaConn) == 0)
                                                {
                                                        LogText0("Disconnected from TSA");
                                                }
                                                else
                                                {
                                                        LogText0("Failed to disconnected from TSA");
                                                        if (fErrLog)
                                                                fprintf(fErrLog, "Failed to disconnected from TSA\n");
                                                }
                                        }
                                        else
                                        {
                                                LogText1("Failed to connect to TSA:%s", TSAName);
                                                if (fErrLog)
                                                        fprintf(fErrLog, "Failed to connect to TSA:%s\n", TSAName);
                                        }
                                }
                                else
                                {
                                        LogText0("No TSA found");
                                        if (fErrLog)
                                                fprintf(fErrLog, "No TSA found\n");
                                }

                                /* Shutdown the SDK */
#ifdef N_PLAT_NLM
                                NWCallsTerm(NULL);
#endif
                        }
                        else
                        {
                                LogText0("Failed to initialise the SDK");
                                if (fErrLog)
                                        fprintf(fErrLog, "Failed to initialise the SDK\n");
                        }
			
			   /* Free the volume names array */
                        for (WorkingVolume = 0; WorkingVolume < 256; WorkingVolume++)
                        {
                                if (AllVolNames[WorkingVolume] == NULL)
                                        continue;
                        
                                free(AllVolNames[WorkingVolume]);
                                AllVolNames[WorkingVolume] = NULL;
                        }
                                
                        /* Be careful not to make iterations go below zero */
                        if (Iterations != 0)
                        {
                                Iterations--;
                        }
                } while (Iterations && PasswordValidate);

QuickExit:
		if(LogData)
		{
			if(scanHistogram)
			{
				free(scanHistogram);
				scanHistogram = NULL;
			}
			if(openHistogram)
			{
				free(openHistogram);
				openHistogram = NULL;
			}
			if(readHistogram)
			{
				free(readHistogram);
				readHistogram = NULL;
			}
			if(closeHistogram)
			{
				free(closeHistogram);
				closeHistogram = NULL;
			}
		}
		if (fMovingAve)
                {
                        fclose(fMovingAve);
                }
                if (maData != NULL)
                {
                        free(maData);
                }

                if (fErrLog)
                {
                        fclose(fErrLog);
                }

		if(DirPathName)
                	free(DirPathName);	
        }

        UnloadState |= TSATEST_UNLOADED;
      
#ifdef N_PLAT_UNIX
	if(!Helped && ParseError) 
	{
		/* Used to exit in case of --NOWAITONEXIT switch*/
		if(NoWait)
		{
		     LogText0("Press any key to exit");
        	     getch();
        	}
	 	echo();	
        	endwin();		
    	}    
#endif

#ifdef N_PLAT_NLM
	SMUnImportUniAPIs(GetNLMHandle());
#endif
	return (retval);
    }

void UnloadHandler(int sig)
{
	if(sig != SIGINT && sig != SIGTERM)
        return ;
	UnloadState |= TSATEST_UNLOAD_TRIGGERED;
#ifdef N_PLAT_NLM
	while(!(UnloadState & TSATEST_UNLOADED))
	{
		delay(10);
	}	
#endif
}

void PrintResourceExtensions(void)
{
	CCODE 								 retval;
	NWSM_EXTENSION_INFORMATION 		*extension = NULL;
	UINT32								 handle;
	UINT32								 resBufferSz = 0;
	void									*resBuffer = NULL;
	NWSM_RESOURCE_INFO_EXTN_UNIX_DATA_1 			*unixExtension;
	NWSM_RESOURCE_INFO_EXTN_UNSUPPORTED_DATA_1	*unsupExtension;
	NWSM_RESOURCE_INFO_EXTN_NETWARE_DATA_1		*nwresExtension;
	
	/* Functions that will be imported */
	CCODE  (*mPtrGetTargetResourceInfoEx)(UINT32 , STRING , UINT32 *, void *) = NULL;
	CCODE (*mPtrNWSMGetFirstExtension)(void *, UINT32, NWSM_EXTENSION_INFORMATION **, UINT32 *) = NULL;
	CCODE (*mPtrNWSMGetNextExtension)(UINT32 *, NWSM_EXTENSION_INFORMATION **) = NULL;
	CCODE (*mPtrNWSMCloseExtension)(UINT32 *) = NULL;

#ifdef N_PLAT_NLM
	mPtrGetTargetResourceInfoEx = ImportSymbol(GetNLMHandle(), "NWSMTSGetTargetResourceInfoEx");
	mPtrNWSMGetFirstExtension = ImportSymbol(GetNLMHandle(), "NWSMGetFirstExtension");
	mPtrNWSMGetNextExtension = ImportSymbol(GetNLMHandle(), "NWSMGetNextExtension");
	mPtrNWSMCloseExtension = ImportSymbol(GetNLMHandle(), "NWSMCloseExtension");
#elif N_PLAT_UNIX
	/* This symbol is not dynamically resolved as it is supported on all SMS versions on Linux */
	mPtrGetTargetResourceInfoEx = NWSMTSGetTargetResourceInfoEx;
	mPtrNWSMGetFirstExtension = NWSMGetFirstExtension;
	mPtrNWSMGetNextExtension = NWSMGetNextExtension;
	mPtrNWSMCloseExtension = NWSMCloseExtension;
#endif

	/* If this function is not supported then return */
	if (!mPtrGetTargetResourceInfoEx || !mPtrNWSMGetFirstExtension || !mPtrNWSMGetNextExtension || !mPtrNWSMCloseExtension)
		goto Return;

	/* Get the extended resource information SIZE from the TSA */
	retval = mPtrGetTargetResourceInfoEx(tsaConn, TSAResourceName, &resBufferSz, NULL);
	if (retval)
	{
		LogText1("Error: Unable to retrieve extended resource information :  0x%x", retval);
		goto Return;
	}
	else
	{
		/* Allocate the required size */
		resBuffer = malloc(resBufferSz);
		if (!resBuffer)
		{
			LogText1("Error: Unable to allocate memory (%d bytes) to retrieve extended resource information", resBufferSz);
			goto Return;
		}

		/* Get the extended resource information from the TSA */
		retval = mPtrGetTargetResourceInfoEx(tsaConn, TSAResourceName, &resBufferSz, resBuffer);
		if (retval)
		{
			LogText1("Error: Unable to retrieve extended resource information :  0x%x", retval);
			goto Return;
		}
		else
		{
			/* No extensions returned */
			if (resBufferSz == 0)
				goto Return;

			/* Query for the first extension */
			retval = mPtrNWSMGetFirstExtension(resBuffer, resBufferSz, &extension, &handle);
			if (retval)
			{
				LogText1("Error: Unable to retrieve first extension 0x%x\n", retval);
				goto Return;
			}

			/* Loop through till we have processed all extensions */
			while (!retval)
			{
				/* Based on extension TAG process the information */
				switch(extension->extensionTag)
				{
					case NWSM_RESOURCE_INFO_EXTN_UNIX_TAG:
						/* Check if any information is available */
						if (!extension->info)
							break;

						/* We should check the tag version before the typecast, but as we are looking for version 1 it is avoided */
						unixExtension = (NWSM_RESOURCE_INFO_EXTN_UNIX_DATA_1 *)(extension->info);
						
						/* Check for NULL pointers before access, as some fields may not have any information */
						if (unixExtension->mnt_opts && unixExtension->mnt_type)
						{
							LogText1("mount options : %s", unixExtension->mnt_opts);
							LogText1("mount type : %s", unixExtension->mnt_type);
						}
						break;

					case NWSM_RESOURCE_INFO_EXTN_UNSUPPORTED_TAG:
						/* Check if any information is available */
						if (!extension->info)
							break;

						/* We should check the tag version before the typecast, but as we are looking for version 1 it is avoided */
						unsupExtension = (NWSM_RESOURCE_INFO_EXTN_UNSUPPORTED_DATA_1 *)(extension->info);
						
						LogText1("Unsupported backup options: 0x%x\n", unsupExtension->unsupportedBackupOptions);
						break;

					case NWSM_RESOURCE_INFO_EXTN_NETWARE_TAG:
						/* Check if any information is available */
						if (!extension->info)
							break;

						/* We should check the tag version before the typecast, but as we are looking for version 1 it is avoided */
						nwresExtension = (NWSM_RESOURCE_INFO_EXTN_NETWARE_DATA_1 *)(extension->info);

						LogText2("Volume statistics: Total blocks: 0x%x Block size : 0x%x", nwresExtension->totalBlocks, nwresExtension->blockSize);
						break;
						
					default:
						LogText1("Error: Unknown extension: %x\n", extension->extensionTag);
				}

				/* Get the next extension */
				retval = mPtrNWSMGetNextExtension(&handle, &extension);
			}

			/* Close the extension handle to free the handle and the extension pointers, this is only if there are no errors */
			if (!retval)
				mPtrNWSMCloseExtension(&handle);
		}
	}							

Return:
	/* Free the allocated buffer */
	if (resBuffer)
		free(resBuffer);

	/* Unimport the imported symbols */
#ifdef N_PLAT_NLM
	if (mPtrGetTargetResourceInfoEx)
		UnimportSymbol(GetNLMHandle(), "NWSMTSGetTargetResourceInfoEx");

	if (mPtrNWSMGetFirstExtension)
		UnimportSymbol(GetNLMHandle(), "NWSMGetFirstExtension");

	if (mPtrNWSMGetNextExtension)
		UnimportSymbol(GetNLMHandle(), "NWSMGetNextExtension");

	if (mPtrNWSMCloseExtension)
		UnimportSymbol(GetNLMHandle(), "NWSMCloseExtension");
#endif

	return;
}


