/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	smuni.h

PURPOSE/COMMENTS:
	UTF-8 conversion and UTF-8 string premitives header file

NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	12 May 2005

===============================================================================
*/
 
#ifndef _SMUNI_H_
#define _SMUNI_H_

#include<stddef.h>
#include <smstypes.h>


#ifdef __cplusplus
extern "C" {
#endif


#if defined (N_PLAT_UNIX)

#ifndef _UNICODE_T
#define _UNICODE_T
#include <wchar.h>
typedef wchar_t unicode_t;
#endif

typedef unsigned short unicode;
typedef unsigned char uint8;

#elif defined (N_PLAT_NLM)
typedef int UniRuleTable_t;
typedef unsigned short unicode_t; 
#endif

#ifndef _UTF8_T
#define _UTF8_T
typedef char utf8_t;	
#endif

#pragma pack(push, 1 )
typedef struct
{
    UINT32          nameSpace;
    UINT32          fileSystem;
} UNICODE_CONTEXT;
#pragma pack(pop)

/* Compares the first n bytes of two utf8 strings */
int SMutf8ncmp     (const  utf8_t *s1, const  utf8_t  *s2, unsigned int n);

/* Converts a string from the local code page to UTF-8. */
int SMloc2utf8(utf8_t * dest, size_t *destLen,const char * src, int srclen, UNICODE_CONTEXT *uCtx) ;

/* Converts a string from the UTF8 to Local code page   */
int SMutf82loc( char * dest, size_t* destLen, const utf8_t * src,  int  srcLen, UNICODE_CONTEXT *uCtx);

#if defined (N_PLAT_NLM)
/*Import unicode APIs*/
void SMImportUniAPIs(UINT32 nlmHandle);

/*Unimport unicode APIs*/
void SMUnImportUniAPIs(UINT32 nlmHandle);
#elif defined (N_PLAT_UNIX)

int SMInitUniLibrary(void *handle);

int SMShutDownUniLibrary(void *handle);
#endif

#ifdef __cplusplus
}
#endif

#endif
