/*
=================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE: 
				smsuterr.h

PURPOSE/COMMENTS:
				Error numbers for SMS Utility Library
Prefix:   
				FFFB

NDK COMPONENT NAME AND VERSION:
				SMS Developer Components

LAST MODIFIED DATE:
				22 Jan 2004
=================================================================
*/


#ifndef _SMSUTERR_H_INCLUDED      /* smsuterr.h header latch */
#define _SMSUTERR_H_INCLUDED

	
#define NWSMUT_ERROR_CODE(err)           (0xFFFB0000L | err)
	
#define NWSMUT_BEGIN_ERROR_CODES          NWSMUT_ERROR_CODE(0xFFFF)

#define NWSMUT_INVALID_HANDLE             NWSMUT_ERROR_CODE(0xFFFF) 
/* Handle is tagged INVALID or ptr is NULL     */
	
#define NWSMUT_INVALID_OFFSET_TO_END      NWSMUT_ERROR_CODE(0xFFFE) 
/* The OffsetToEnd field did not offset to the correct end */
/* field */
   
#define NWSMUT_INVALID_PARAMETER          NWSMUT_ERROR_CODE(0xFFFD) 
/* One or more of the paremeters is NULL or invalid */
   
#define NWSMUT_NO_MORE_NAMES              NWSMUT_ERROR_CODE(0xFFFC) 
/* No more entries in list or nameSpace type does not exist */
   
#define NWSMUT_OUT_OF_MEMORY              NWSMUT_ERROR_CODE(0xFFFB) 
/* Server out of memory or memory allocation failed */
   
#define NWSMUT_BUFFER_OVERFLOW            NWSMUT_ERROR_CODE(0xFFFA) 
/* Field identifier buffer overflow */
	
#define NWSMUT_BUFFER_UNDERFLOW           NWSMUT_ERROR_CODE(0xFFF0) 
/* Field identifier buffer underflow */
	
#define NWSMUT_INVALID_FIELD_ID           NWSMUT_ERROR_CODE(0xFFF9) 
/* Invalid field identifier encountered */

#define NWSMUT_NO_MORE_EXTENSIONS           NWSMUT_ERROR_CODE(0xFFF8) 
/* No more entries in the extension list or extension tag does not exist */

#define NWSMUT_INVALID_MESSAGE_NUMBER     NWSMUT_ERROR_CODE(0xFFF7) 
/* Invalid message number encountered */

#define NWSMUT_END_ERROR_CODES            NWSMUT_ERROR_CODE(0xFFF7) 

#endif                            /* smsuterr.h header latch */
