/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	de.h

PURPOSE/COMMENTS:
	Demo engine header file for  internal strcutres and functions.
		
NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	16 July 2004

===============================================================================
*/

#ifndef _DE_H_
#define _DE_H_

/*
 * Headers and Defines
 */

#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <time.h>
#include "decluster.h"

#ifdef N_PLAT_NLM
#define status(a,b)                 				printf(a,b)
#else
#define status(a,b)                 				fprintf(stderr,a,b)
#endif
#define BUFFER_SIZE          				65535L 
#define END_OF_RECORD_MARKER 				0xFFFFFFFFL
#define NOT_ASSIGNED         				0xFFFFFFFFL
#define MAX_SCREEN_NAME_LENGTH 				25
#define ERROR_BUFFER_LENGTH 				300
#define RESOURCE_NAME_LENGTH 				300
#define MAX_TARGET_NAME_LENGTH 				300
#define MAX_USER_NAME_LENGTH 				300
#define MAX_PASSWORD_LENGTH 				50
#define MAX_SELECTION_ITEM_LENGTH 			2000
#define NAME_SPACE_TYPE_STRING_LENGTH 		50
#define SELECTION_TYPE_STRING_LENGTH 		128
#define SERVICE_RESOURCE_NAME_LENGTH 		50
#define FILE_OR_DIRECTORY_NAME_LENGTH 		50
#define MAX_FILE_NAME_LENGTH 				50
#ifdef N_PLAT_NLM
#define MAX_BUF_LEN 							256
#else
#define MAX_BUF_LEN 							4096
#endif
#define MAX_UTF8_CHAR_SIZE					8
#define SCREEN_ATTRIBUTES 					0x89
#define ONE_KB 								1024
#define SIXTY_SECONDS 						60.0
#define RECONNECT_FAIL						-1
#define PREMEMALLOC							256
#define LogSession							if(sessionInfo->logFile) fprintf
#define NBK_SUCCESS							0x000	/*success*/
#define NWSM_SYNC_DATA                 			0x5AA5
#define HEADER_ALLOC_INCREMENT   			512
#define HBUFSIZE 							512
#define SDI_MEDIA_MARK_USAGE_SH   			SMDF_BIT_ONE 
#define SDI_MEDIA_MARK_USAGE_ST  		 	SMDF_BIT_TWO
#define SDI_SIZEOF_ID_VERSION     			4
#define SECTOR_SIZE							4096

#define min(a, b)    (((a) < (b)) ? (a) : (b))


/* Message Types*/
#define NBK_NO_MESSAGES 		0  	/* No messages will be printed on the screen*/
#define NBK_ERR_MSG				1 	/* only error messages will be printed to screen*/
#define NBK_SUMMARY_MSG 		2	/* summary messages will be printed */
#define NBK_VERBOSE_MSG 		3	/* Verbose messages will be printed */
#define NBK_STATUS_MSG			4	/* Status messages will be printed */
#define NBK_DEBUG_MSG 			5	/* Error Messages will contain function names and line numbers*/
#define NBK_ALL_MESSAGES		6
#define NBK_GENERAL_MESSAGES		7

#pragma pack(push,1)

typedef struct _SinglePair SinglePair;

 struct _SinglePair
{

	UINT32	nameSpace;
	char	*source;
	char	*destination;
	SinglePair *next;
};	

 #define RESTORE	0
 #define RENAME_RESTORE	1
 #define LIST_ONLY	2
 #define VERIFY		3

typedef struct _BACKUP_CONTEXT
{
 	int scanOnly; /* FALSE for Backup, TRUE Scan  */
 	int saveBackup; /* This variable to store the GUI option for save/ don't save data */
	int appenBackup;
	UINT16 volno;
	int multiVol;
	int settapeLength;
	int extractFiles;
 	NWSM_DATA_SET_NAME_LIST *dsetList; /* this is a NULL terminated list containing  the list of files/directories for the backup. */
 	UINT32 modifedAfter; /* this will be set for Incremental backups*/
	UINT32 nameSpaceType;
}BACKUP_CONTEXT; 

typedef struct _RESTORE_CONTEXT
{
	int restoreSessionIndex; /* index of the session to be restored*/
	STRING sessionName;/* Name of the Session to be restored */
	UINT8 overwriteParent; /* over write parent  flag*/
	UINT8 overwriteChild; /*overwrite child flag*/
	UINT16 		volno;
	int 		multiVol;
	int		extractsession;
	char 	session_Name[512];
	SinglePair *renameList; /* list of rename restore pairs, each pair will contain source and destination paths*/
}RESTORE_CONTEXT;

typedef struct _NBACKUP_STATISTICS
{
	UINT32 fileCount; /* total no of files */
	UINT32 dirCount; /* total no of directories */
#ifdef N_PLAT_NLM	
	unsigned __int64   totalBytesRead;
#else
	unsigned long long   totalBytesRead;  /* total no of bytes*/
#endif
	UINT32 resCount;
	UINT32 totalTime; /* total time taken*/
}NBACKUP_STATISTICS;
 typedef struct _WRITE_SESSION_HANDLE
{            
	
	UINT32                    headerSectorNumber;
	UINT32                    sessionState;

	BUFFERPTR                 tbHeaderPtr;
	               // 0x20
	UINT32                    maxTransferBufferSize;
	UINT16                    sessionTrailerInfoOffset;
	UINT16                    sessionTrailerInfoSize;

	UINT16                    applicationAreaOffset;
	UINT16                    applicationAreaSize;

	UINT16                    tbHeaderSizeOffset;
	UINT16                    tbHeaderUnusedOffset;
	               /* 0x30 */
	UINT16                    tbHeaderSequenceOffset;
	UINT16                    tbHeaderSectorAddressOffset;
	UINT16                    tbHeaderMediaNumberOffset;
	UINT16                    tbHeaderSectorSizeOffset;

	UINT16                    tbHeaderEndFidOffset;
	UINT16                    tbHeaderSize;
	UINT16                    tbHeaderAllocSize;
	UINT16                    reserved;
	               /* 0x40 */
	BUFFERPTR                 spannedSessionHeader;

} WRITE_SESSION_HANDLE;

typedef struct _SESSION_INFORMATION
{
    int sessionNo;
	UINT32 connection;
	char sessionName[512];
	char srcName[256];
	NWSM_SELECTION_LIST *selectionList;
	NWSM_SCAN_CONTROL scanControl;
	NWSM_SCAN_INFORMATION *scanInfo;
	NWSM_RECORD_HEADER_INFO recInfo;
	NWSM_LIST *cur;
	NWBOOLEAN 	listHead;
	BUFFER 	*dataBuffer;
	BUFFER 	*transferBuffer;
	BUFFER  	*currentPtr;
	BUFFER  	*dataBufferPtr;
	BUFFER	*sessionHBuffer;
	BUFFER	*sessionHTrailer;
	BUFFER	*mediaBuffer;
	UINT32	  tUsed;
	UINT32	  tLeft;
	UINT32	dataread;
	UINT32	tape_length;
	NWBOOLEAN 	atHeader;
	int 	newDataSetFlag;
	int	dataFile;
	FILE *logFile;
	char tsaName[MAX_BUF_LEN];
	char svcName[MAX_BUF_LEN];
    char CuserName[MAX_BUF_LEN];
    char CpassWord[MAX_BUF_LEN];
	char UPassWord[MAX_BUF_LEN];
	#ifdef N_PLAT_UNIX
	char sName[MAX_SCREEN_NAME_LENGTH];
	#endif
	NWBOOLEAN verbose;
	NWBOOLEAN 		IsUTF8Supp;
    ClusterParams * clusterparams;
    RESTORE_CONTEXT *rctx;
    BACKUP_CONTEXT *bctx;
    NBACKUP_STATISTICS stats;
	WRITE_SESSION_HANDLE sHandle;
	NWSMSD_TRANSFER_BUF_INFO transferBufferInfo;
	NWSMSD_CONTROL_BLOCK	ControlBlock;
	char destFile[512];
	NWBOOLEAN append;
	UINT32 nameSpaceType;/* This will be LONG for NetWare and NFS for Linux*/
} SESSION_INFORMATION;


#pragma pack(pop)

 /*
  * Function prototypes
  */


void    	StartTimer(void);
UINT32  	ElapsedTime(void);
void    	CloseDEFiles(SESSION_INFORMATION *sessionInfo);
CCODE   	OpenDEFiles(int mode,SESSION_INFORMATION *sessionInfo);
void    	UngetEOF(void);
CCODE 		SaveSessionInfo(SESSION_INFORMATION *sessionInfo);
CCODE 		ObtainSessionInfo(int *sessionToRestore);
void 		LogSessionInfo(UINT8 *toLog, SESSION_INFORMATION *sessionInfo);
UINT32 		MapToMBCSNameSpace(UINT32 nameSpaceType);
UINT32		MapToUTF8NameSpace(UINT32 nameSpaceType);
CCODE 	OpenService(SESSION_INFORMATION *);
void 	Insert(SinglePair *, SinglePair *);
void 	FreeRenameList(SinglePair *);
CCODE 	GetNewName(SESSION_INFORMATION *, NWSM_DATA_SET_NAME_LIST *, NWSM_DATA_SET_NAME_LIST **);
CCODE CopyResourceName( UINT8 parentFlag,char *oNameList, SESSION_INFORMATION *sessionInfo,NWBOOLEAN isUTFName, char **extractPath);
CCODE IsFileExtracted( UINT8 parentFlag, NWBOOLEAN *isFirstFile, SESSION_INFORMATION *sessionInfo, char *extractPath, char **listPath, char *fileWithOutPath, NWSM_LIST **cur,NWSM_LIST **savecur, NWBOOLEAN *isParentFound,  NWBOOLEAN *isExtract);
void GetResourceName(NWSM_DATA_SET_NAME_LIST *resourceName, NWBOOLEAN checkUTF8 , NWSM_DATA_SET_NAME *nNameList,  NWBOOLEAN *isUTFName);
CCODE  PrintDataSetName( UINT8 pFlag, char **lParent, char *NextRName, SESSION_INFORMATION *sessionInfo, char *lPath, NWBOOLEAN isBackup);
SESSION_INFORMATION *GetSessionInfoBuffer(void);
CCODE PutDataSetHeader(NWSM_DATA_SET_NAME_LIST *dataSet, SESSION_INFORMATION *sessionInfo);
CCODE PutDataHeader(NWBOOLEAN subRecord, SESSION_INFORMATION *sessionInfo);
CCODE FlushTransferBuffer(SESSION_INFORMATION *sessionInfo);
CCODE PutData(SESSION_INFORMATION *sessionInfo, UINT32 size);
void DataEnd(SESSION_INFORMATION *sessionInfo);
int GetDataHeader(UINT8 *pflag, UINT8 *tflag, NWSM_DATA_SET_NAME_LIST **newList,SESSION_INFORMATION *sessionInfo ,CCODE *error);
CCODE GetRecordInfo(SESSION_INFORMATION *sessionInfo);
NWBOOLEAN GetTransferBuffer(SESSION_INFORMATION *sessionInfo);
BUFFERPTR GetData (UINT32 *size, SESSION_INFORMATION *sessionInfo);
NWBOOLEAN NewDataSet(SESSION_INFORMATION *sessionInfo);
BUFFERPTR RestoreRead(SESSION_INFORMATION *sessionInfo, UINT32 *size);
int	ProcessScanInfoExtension(NWSM_SCAN_INFORMATION *scanInformation, NWSM_SCAN_INFO_EXTN_NFS_DATA_1 *nfsInfo);
CCODE InitRestoreSession(SESSION_INFORMATION *sessionInfo);
CCODE BuildSessionAndTBHeader(SESSION_INFORMATION *sessionInfo,NWSMSD_HEADER_BUFFER  *sessionHeaderInfo,
   										NWSMSD_TRANSFER_BUF_INFO *transferBufferInfo,BUFFERPTR  *endingFidPtr,
   											UINT32   *endingBufferSize);
CCODE PutTBHeaderField(
   WRITE_SESSION_HANDLE         *sessionHandle,
   UINT32                        fid,
   void                         *data,
   UINT8                         dataSizeMap,
   UINT32                        sizeOfData,
   BUFFERPTR                    *addressOfData,
   BUFFERPTR                    *bufferPtr,
   UINT32                       *bufferSize,
   UINT32                       *bufferData);

CCODE WriteOpenSession(SESSION_INFORMATION *sessionInfo);
CCODE SessionOpenForWriting(SESSION_INFORMATION *sessionInfo,NWSMSD_HEADER_BUFFER  *sessionHeaderInfo,
   										NWSMSD_TRANSFER_BUF_INFO *transferBufferInfo);

CCODE SessionWriteData(SESSION_INFORMATION *sessionInfo);
CCODE ReadOpenSession(SESSION_INFORMATION *sessionInfo);
CCODE SessionOpenForReading(SESSION_INFORMATION *sessionInfo,NWSMSD_HEADER_BUFFER  *sessionHeaderInfo);
CCODE GetSessionHeader(SESSION_INFORMATION *sessionInfo);
CCODE  GetField(
   SMDF_FIELD_DATA              *field,
   BUFFERPTR                    *bufferPtr,
   UINT32                       *bufferSize);
CCODE SessionReadData(SESSION_INFORMATION *sessionInfo);
CCODE FMTSIDFParseTBHeader(SESSION_INFORMATION *sessionInfo);

CCODE  PutField(
   UINT32                        fid,
   void                         *data,
   UINT8                         dataSizeMap,
   UINT32                        sizeOfData,
   BUFFERPTR                    *addressOfData,
   BUFFERPTR                    *bufferPtr,
   UINT32                       *bufferSize,
   UINT32                       *bufferData);
CCODE MediaLabel(SESSION_INFORMATION *sessionInfo,NWSMSD_HEADER_BUFFER  *sessionHeaderInfo,   UINT16  *MediaNum);
CCODE ContinueToNextTape(SESSION_INFORMATION *sessionInfo,UINT16  *MediaNum);
CCODE ContinueMediaHeaderToNextTape(SESSION_INFORMATION *sessionInfo , UINT16  *MediaNum);
CCODE ContinueMediaHeaderFromNextTape(SESSION_INFORMATION *sessionInfo);
CCODE RetrieveFromNextTape(SESSION_INFORMATION *sessionInfo);
CCODE FlushMediaHeader(SESSION_INFORMATION *sessionInfo);
CCODE GetMediaHeader(SESSION_INFORMATION *sessionInfo);
CCODE MoveDataToTBHeader(
           WRITE_SESSION_HANDLE     *sessionHandle,
           BUFFERPTR                 sourceBuffer,
           UINT32                    sourceSize,
           BUFFERPTR                *bufferPtr,
           UINT32                   *bufferSize,
           UINT32                   *bufferData);


  
extern UINT32 	AfterDateSet;
extern UINT32 	AfterDateAndTime;
extern time_t 		timep;
extern UINT32	 	SetFullPath;
extern UINT32		SetExFileData;
extern UINT32		noIDs;
extern UINT32  	MoveDataSet;
extern char  		moveString[128];


#endif /*_DE_H_*/

