/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	tsatest.h

PURPOSE/COMMENTS:
	Investigate TSA operation

NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	15 September 2004


===============================================================================
*/

#ifndef TSATEST_H__
#define TSATEST_H__


/* Dependencies */
#include <time.h>
#include <smuni.h> 

#ifdef N_PLAT_UNIX
#include <ncurses.h>
#endif

#define TSATEST_VERSION				"1.2"
#define MAX_PASSWORD_SIZE 			128
#define MAX_UTF8_CHAR_SIZE			6

#ifndef _XSTDIO_H_
#define WHITE							15
#endif

#ifndef _NWCONIO_H_
#define AUTO_DESTROY_SCREEN			0x20
#endif

#ifdef N_PLAT_NLM
#define print           	printf
#define refresh()       
#define move(a,b)
#define GetTimer() \
        (UseHiResTimer? GetSuperHighResolutionTimer() : GetHighResolutionTimer())

#endif


#ifdef N_PLAT_UNIX 
#define __int64 			long long
#define print           	printw
#define ConsolePrintf   	printf
#define putch           	addch   
#define EnterDebugger(void)   
#define GetTimer()      	GetResolutionTimer()
#define SetCursorShape(a,b)  
#define NWCallsInit(x,y)    0
#define kbhit()         	0
#define gotoxy(x,y)         {move(y,x);}
#define delay(x)            sleep(x/1000)
#define ReturnFileServerName(a) ReturnFileServerName_Unix(a)
#define PressAnyKeyToContinue() 
#define strupr(a)       
#define CopyFromScreenMemory(a,b,c,d,e)
#define CopyToScreenMemory(a,b,c,d,e)
#define stricmp			strcasecmp	
#endif

/* Localization constants */
#define TSATEST_DOMAIN			"tsatest"
#define TSATEST_LOCALE_DIR		"/usr/share/locale"

/* Manifest constants */
#define TSATEST_VERSION_MAJ             1
#define TSATEST_VERSION_MIN             19

#define	MIN_LOG_LINE			(15)
#define	MAX_LOG_LINE			(23)
#define NWFA_DIRECTORY			(0x00000010)
#define	MOD_PASSES				(16)
#define	X_DATA_OFFSET			(20)
#define	X_CURRENT_VOLNAME		(0)
#define	X_READ_COUNT			(0)
#define	X_MIN_READ_TIME			(40)
#define	X_LAST_READ_SIZE		(0)
#define	X_LAST_READ_TIME		(40)
#define	X_TOTAL_BYTES_READ		(0)
#define	X_MAX_READ_TIME			(40)
#define	X_RAW_DATA_RATE			(0)
#define	X_AVE_READ_TIME			(40)
#define	X_BACKUP_SETS			(0)
#define	X_TOTAL_READ_TIME		(40)
#define	X_AVE_OPEN_TIME			(0)
#define X_AVE_SCAN_TIME			(40)
#define X_AVE_CLOSE_TIME		(0)
#define X_TSA_TIME				(40)
#define	X_EFFECTIVE_DATA_RATE	(0)
#define	X_ELAPSED_TIME			(40)
#define X_DISCOUNT_TIME			(40)
#define	X_CURRENT_NAME			(0)
#define	X_ITERATION				(0)
#define X_EST_ERROR				(40)
#define	X_AVE_FILE_READ_TIME	(40)
#define	Y_CURRENT_VOLNAME		(1)
#define	Y_READ_COUNT			(2)
#define	Y_MIN_READ_TIME			(2)
#define	Y_LAST_READ_SIZE		(3)
#define	Y_LAST_READ_TIME		(3)
#define	Y_TOTAL_BYTES_READ		(4)
#define	Y_MAX_READ_TIME			(4)
#define	Y_RAW_DATA_RATE			(5)
#define	Y_AVE_READ_TIME			(5)
#define	Y_BACKUP_SETS			(6)
#define Y_AVE_SCAN_TIME			(6)
#define	Y_AVE_OPEN_TIME			(7)
#define	Y_TOTAL_READ_TIME		(7)
#define Y_AVE_CLOSE_TIME		(8)
#define	Y_ELAPSED_TIME			(8)
#define	Y_EFFECTIVE_DATA_RATE	(9)
#define	Y_TSA_TIME				(9)
#define	Y_ITERATION				(10)
#define	Y_EST_ERROR				(10)
#define	Y_AVE_FILE_READ_TIME	(11)
#define	Y_CURRENT_NAME			(13)


#define TSATEST_UNLOAD_TRIGGERED        1
#define         TSATEST_UNLOADED                                2

/* New types */
typedef struct tagMovingAverageNode
{
        unsigned __int64        bytes;
        unsigned __int64        elapsed;
} MOVING_AVERAGE_NODE;


/* Function prototypes */
int  GetHistogramBucket(unsigned int Signal);
void PrintBigString(int x, int y, char *strText);
int  DoBackup(UINT32 tsaConn, UINT32 *tsaSeq, NWSM_DATA_SET_NAME_LIST **dataSetNameList, UINT32 ExtStartTime);
void UnloadHandler(int sig);
void RefreshDisplay();
void getpw(char *password);
void PrintResourceExtensions(void);
CCODE TargetServiceConnection();


/* External prototypes */
unsigned long ReturnFileServerName(char *nameBuffer);
unsigned long GetHighResolutionTimer();
LONG          GetSuperHighResolutionTimer();


/* Function like macros */
#define DCLogText0(theText)     \
{ \
        gotoxy(0, LogLine); \
        print(theText); \
        refresh();\
        LogLine++; \
        if (LogLine > MAX_LOG_LINE) \
        { \
                LogLine = MIN_LOG_LINE; \
        } \
}

#define DCLogText1(theText, arg1)       \
{ \
        gotoxy(0, LogLine); \
        print(theText, arg1); \
        refresh();\
        LogLine++; \
        if (LogLine > MAX_LOG_LINE) \
        { \
                LogLine = MIN_LOG_LINE; \
        } \
}


#define LogText0(theText)       \
{ \
        if (!PresentationMode) \
        { \
                gotoxy(0, LogLine); \
                print(theText); \
                refresh();\
                LogLine++; \
                if (LogLine > MAX_LOG_LINE) \
                { \
                        LogLine = MIN_LOG_LINE; \
                } \
                gotoxy(0, LogLine); \
                print(BlankLine); \
                refresh();\
        } \
}

#define LogText1(theText, arg1) \
{ \
        if (!PresentationMode) \
        { \
                gotoxy(0, LogLine); \
                print(theText, arg1); \
                refresh();\
                LogLine++; \
                if (LogLine > MAX_LOG_LINE) \
                { \
                        LogLine = MIN_LOG_LINE; \
                } \
                gotoxy(0, LogLine); \
                print(BlankLine); \
                refresh();\
        } \
}

#define LogText2(theText, arg1, arg2)   \
{ \
        if (!PresentationMode) \
        { \
                gotoxy(0, LogLine); \
                print(theText, arg1, arg2); \
                refresh();\
                LogLine++; \
                if (LogLine > MAX_LOG_LINE) \
                { \
                        LogLine = MIN_LOG_LINE; \
                } \
                gotoxy(0, LogLine); \
                print(BlankLine); \
                refresh();\
        } \
}

#define LogText3(theText, arg1, arg2, arg3)     \
{ \
        if (!PresentationMode) \
        { \
                gotoxy(0, LogLine); \
                print(theText, arg1, arg2, arg3); \
                refresh();\
                LogLine++; \
                if (LogLine > MAX_LOG_LINE) \
                { \
                        LogLine = MIN_LOG_LINE; \
                } \
                gotoxy(0, LogLine); \
                print(BlankLine); \
                refresh();\
        } \
}

#define LogText4(theText, arg1, arg2, arg3, arg4)       \
{ \
        if (!PresentationMode) \
        { \
                gotoxy(0, LogLine); \
                print(theText, arg1, arg2, arg3, arg4); \
                refresh();\
                LogLine++; \
                if (LogLine > MAX_LOG_LINE) \
                { \
                        LogLine = MIN_LOG_LINE; \
                } \
                gotoxy(0, LogLine); \
                print(BlankLine); \
                refresh();\
        } \
}

#define StatText0(X, Y, theText)        \
{ \
        gotoxy(X, Y); \
        print(theText); \
        refresh();\
}

#define StatText1(X, Y, theText, arg1)  \
{ \
        gotoxy(X, Y); \
        print(theText, arg1); \
        refresh();\
}

#define StatText2(X, Y, theText, arg1, arg2)    \
{ \
        gotoxy(X, Y); \
        print(theText, arg1, arg2); \
        refresh();\
}

#define StatText3(X, Y, theText, arg1, arg2, arg3)      \
{ \
        gotoxy(X, Y); \
        print(theText, arg1, arg2, arg3); \
        refresh();\
}

#define StatText4(X, Y, theText, arg1, arg2, arg3, arg4)        \
{ \
        gotoxy(X, Y); \
        print(theText, arg1, arg2, arg3, arg4); \
        refresh();\
}

#define StatFloatText1(X, Y, arg1)      \
{ \
        gotoxy(X, Y); \
        if (UseHiResTimer) \
                print("%.0fus      ", arg1); \
        else \
                print("%.0f00us    ", arg1); \
        refresh();\
}

#define StatIntText1(X, Y, arg1)        \
{ \
        gotoxy(X, Y); \
        if (UseHiResTimer) \
                print("%dus               ", arg1); \
        else \
                print("%d00us       ", arg1); \
        refresh();\
}

#define TimerSecFactor() \
        (UseHiResTimer? 1000000 : 10000)

/* Global state */
extern UINT32											nameSpace;
extern  int                                                      *scanHistogram;
extern  int                                                      *openHistogram;
extern  int                                                      *readHistogram;
extern  int                                                      *closeHistogram;
extern  time_t                                           backupEnd;
extern  time_t                                           backupStart;
extern  UINT32                                           backedUpSets;
extern  UINT32                                           bytesRead;
extern  UINT32                                           lastElapsedTime;
extern  UINT32                                           maSamples;
extern  UINT32                                           maxReadTime;
extern  UINT32                                           minReadTime;
extern  UINT32                                           scanCount;
extern unsigned __int64                             readCount;
extern  unsigned __int64                         totalBytesRead;
extern  unsigned __int64                         totalCloseTime;
extern  unsigned __int64                         totalOpenTime;
extern  unsigned __int64                         totalReadTime;
extern  unsigned __int64                         totalScanTime;
extern  unsigned __int64                         totalTime;
extern  unsigned __int64                         maSetTotalBytes;
extern  unsigned __int64                         maSetTotalTime;
extern  unsigned __int64                         maTotalBytes;
extern  unsigned __int64                         maTotalTime;

extern  int                                              		 Aggregate;
extern  int                                                      Average;
extern  int                                                      DoNDS;
extern  int                                                      FirstPass;
extern  int                                                      FullLog;
extern  int                                                      GrowByAmount;
extern  int                                                      GrowByFactor;
extern  int                                                      Iterations;
extern  int                                                      LogData;
extern  int                                                      maInsert;
extern  int                                                      MaxIterations;
extern  int                                                      Milliseconds;
extern  int                                                      ShowNames;
extern  int                                                      PresentationMode;
extern  int                                                      WorkingVolume;
extern  int                                                      UseHiResTimer;

extern  WORD                                             LogLine;
extern  UINT32                                           BuffSize;
extern  UINT32                                           DataSetSize;
extern  UINT32                                           maGroupLen;
extern  double                                           maCurrent;
extern  double                                           maTolerenceLow;
extern  double                                           maTolerenceHigh;
extern  NWSM_SCAN_INFORMATION           				*scanInfo;
extern  MOVING_AVERAGE_NODE                     		*maData;
extern  char                                            *AllVolNames[];
extern  char                                             BlankLine[];
extern  char                                             LogFileName[];
extern  FILE                                            *fErrLog;
extern  FILE                                            *fMovingAve;
extern int								IsUTF8Supp;	

#endif
