/*
===============================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
				smsdrerr.h

PURPOSE/COMMENTS:
				Error numbers for DRAPIs

Prefix:
				FFFE

NDK COMPONENT NAME AND VERSION:
				SMS Developer Components

LAST MODIFIED DATE:
				22 Jan 2004
=================================================================
*/

#ifndef _SMSDRERR_H_INCLUDED      /* smsdrerr.h header latch */
#define _SMSDRERR_H_INCLUDED

#define NWSMDR_ERROR_CODE(err)         (0xFFFE0000 | err)

#define NWSMDR_BEGIN_ERROR_CODES       NWSMDR_ERROR_CODE(0xFFFF)

#define NWSMDR_INVALID_CONNECTION      NWSMDR_ERROR_CODE(0xFFFF) 
/* An invalid connection handle was passed to the SMDR                     */
#define NWSMDR_INVALID_PARAMETER       NWSMDR_ERROR_CODE(0xFFFE) 
/* One or more of the paremeters is NULL or invalid                        */
#define NWSMDR_OUT_OF_MEMORY           NWSMDR_ERROR_CODE(0xFFFD) 
/* SMDR memory allocation failed                                           */
#define NWSMDR_TRANSPORT_FAILURE       NWSMDR_ERROR_CODE(0xFFFC) 
/* The transport mechanism has failed                                      */
#define NWSMDR_UNSUPPORTED_FUNCTION    NWSMDR_ERROR_CODE(0xFFFB) 
/* The requested function is not supported by the SMDR                     */

#define NWSMDR_MODULE_ALREADY_EXPORTED NWSMDR_ERROR_CODE(0xFFFA)
#define NWSMDR_DECRYPTION_FAILURE      NWSMDR_ERROR_CODE(0xFFF9)
#define NWSMDR_ENCRYPTION_FAILURE      NWSMDR_ERROR_CODE(0xFFF8)
#define NWSMDR_TSA_NOT_LOADED          NWSMDR_ERROR_CODE(0xFFF7)
#define NWSMDR_NO_SUCH_SMDR            NWSMDR_ERROR_CODE(0xFFF6)
#define NWSMDR_SMDR_CONNECT_FAILURE    NWSMDR_ERROR_CODE(0xFFF5)
#define NWSMDR_NO_MORE_DATA            NWSMDR_ERROR_CODE(0xFFF4)
#define NWSMDR_NO_SOCKETS              NWSMDR_ERROR_CODE(0xFFF3)
#define NWSMDR_INVALID_PROTOCOL        NWSMDR_ERROR_CODE(0xFFF2)
#define NWSMDR_NO_MORE_CONNECTIONS     NWSMDR_ERROR_CODE(0xFFF1)
#define NWSMDR_NO_SUCH_TSA             NWSMDR_ERROR_CODE(0xFFF0)

#define NWSMDR_INVALID_MESSAGE_NUMBER  NWSMDR_ERROR_CODE(0xFFEF)
#define NWSMDR_END_ERROR_CODES         NWSMDR_ERROR_CODE(0xFFEF)
/* Identifies the end of the SMDR error set  */

#endif                            /* smsdrerr.h header latch */
