/*
===============================================================================
ovell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	deoslib.c

PURPOSE/COMMENTS:
	Implements OS specific functionality abstraction that is required by DE.
	This file implements Linux specific functionality. 

NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	19 July 2004

===============================================================================
*/

/*
 * Headers and Defines
 */

#include<stdio.h>
#include <smstypes.h>
#include "deoslib.h"
#include <ncurses.h>
#include <strings.h>
#include <de.h>

/*
 * Function definitions
 */

/*********************************************************************
* NAME: DEPause
*
* WHAT: Wait until the user enters a keystroke.
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void DEPause(void)
	{
		status("\n", NULL);
		status("Strike any key to continue...", NULL); 
	    	getch();

		return;
	}

/*********************************************************************
* NAME: getun
*
* WHAT: Prompt the user to enter a user name. 
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void getun(char *user)
	{
		/*fgets(user,MAX_BUF_LEN,stdin);
		user[strlen(user) - 1] = 0;*/
		getnstr(user, MAX_BUF_LEN);

		return;
	}

/*********************************************************************
* NAME: getpw
*
* WHAT: Get a password from the user to be used in conjunction with
*	the user name.
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void getpw(char *password)
	{
		char pwd[80];
		int i=0;

		noecho();
		for(i=0;i<(80-1); i++)
		{
				pwd[i]= getch();
				if(pwd[i] == '\n')
					break;
		}
		pwd[i] = '\0';
		*((UINT16 *)password) = strlen(pwd);
		memcpy(password + 2, pwd, strlen(pwd));	
		echo();

		return;
	}

/*********************************************************************
* NAME: GetCharacter
*
* WHAT:Reads a character from the window.
*
* SMS-SPECIFIC ROUTINES CALLED:
*
**********************************************************************/
void GetCharacter(char *option)
	{
		
		*option=(char)getch();

		return;
	}

