/*
===============================================================================
Novell Software Developer Kit Sample Code License

Copyright (C) 2005, Novell, Inc.  All rights reserved.
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
  *  Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  *  Redistributions in binary form must reproduce the above
     copyright notice, this list of conditions and the following
     disclaimer in the documentation and/or other materials provided
     with the distribution.
  *  Neither the name of Novell, Inc. nor the names of its contributors
     may be used to endorse or promote products derived from this
     software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE, AND NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT
SHALL NOVELL, INC., THE COPYRIGHT OWNER, OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

NAME OF FILE:
	ttbackup.c

PURPOSE/COMMENTS:
	Backup related routines for TSATest

NDK COMPONENT NAME AND VERSION:
	SMS Developer Components

LAST MODIFIED DATE: 
	15 September 2004

===============================================================================
*/

/* Dependencies */
#include <stdio.h>
#ifdef N_PLAT_NLM
#include <nwcalls.h>
#include <nwclxcon.h>
#include <nwconio.h>
#endif
#include <smstypes.h>
#include <smsdrapi.h>
#include <smstsapi.h>
#include <smsutapi.h>
#include <math.h>
/* Dependencies */
#include <math.h>
#include <sys/time.h>

/* Project dependencies */
#include "tsatest.h"

extern unsigned int UnloadState;
extern int MaxHistogramBuckets;
extern int MaxHistogramBucketValue;
extern int MinHistogramBucketValue;

/*GetTimer() implementation for Unix*/
#ifdef N_PLAT_UNIX
UINT32 GetResolutionTimer()
{
        struct timeval start;
        struct timezone tz;
        UINT32 micro_sec;
        gettimeofday(&start,&tz);
        /*gettimeofday function returns time in seconds and microseconds.But,here,the entire value is converted to microsec*/
        micro_sec=start.tv_sec*1000000+start.tv_usec;
        return (UseHiResTimer?micro_sec:(micro_sec/100));
}
#endif

int  GetHistogramBucket(unsigned int Signal)
{
	int bucket;
	int bucketRange;
	int bucketWidth;

	if(UseHiResTimer)
		Signal /= 100;
	// We need the bucket number for signals shorter than the
	// maximum bucket value and longer than the minimum
	if (Signal < MinHistogramBucketValue)
	{
		// Anything shorter than the minimum is the minimum
		bucket = MaxHistogramBuckets;
	}
	else if (Signal > MaxHistogramBucketValue)
	{
		// Anything longer than the maximum value goes in the last bucket
		bucket = MaxHistogramBuckets + 1;
	}
	else
	{
		// Locate the zero based bucket for this signal
		// This could be optimised by doing the first two statements once,
		// at load time rather than every
		// time we get the bucket
		bucketRange = MaxHistogramBucketValue - MinHistogramBucketValue;
		bucketWidth = bucketRange / MaxHistogramBuckets;
		bucket = (Signal - MinHistogramBucketValue) / bucketWidth;
	}

	return bucket;
}


// Function to output the histogram header for a named histogram
void WriteHistogramHeader(FILE *f, const char *name)
{
	int bucket;
	int bucketMin;
	int bucketMax;
	int bucketWidth;
	int bucketRange;

	// The range of values covered by all buckets
	bucketRange = MaxHistogramBucketValue - MinHistogramBucketValue;

	// The width of a bucket in ticks
	bucketWidth = bucketRange / MaxHistogramBuckets;

	if(MinHistogramBucketValue)
		fprintf(f, "%s (<%d),", name, MinHistogramBucketValue);

	// Iterate the histogram
	for(bucket = 0; bucket < MaxHistogramBuckets; bucket++)
	{
		// The minimum and maximum values for this bucket
		bucketMin = MinHistogramBucketValue + bucket * bucketWidth;
		bucketMax = bucketMin + bucketWidth - 1;

		fprintf(f, "%s (%d-%d),", name, bucketMin, bucketMax);
	}

	fprintf(f, "%s (>%d),", name, MaxHistogramBucketValue);
}

/* Truncate the tenths from a integer time of 0.1 ms resolution */
UINT32 CorrectRollOverAndTruncate(UINT32 EndTimeVal, UINT32 StartTimeVal)
{
        UINT32          timeVal;
        
        timeVal = (EndTimeVal >= StartTimeVal) ? (EndTimeVal - StartTimeVal) \
                : ((0xFFFFFFFF - StartTimeVal) + EndTimeVal);
        
        /* Only do it if milliseconds is enabled */
        if (Milliseconds)
        {
                if (UseHiResTimer)
                {
                        /* Truncate the 0.001ms digit */
                        timeVal /= 1000;
                        timeVal *= 1000;
                }
                else
                {
                        /* Truncate the 0.1ms digit */
                        timeVal /= 10;
                        timeVal *= 10;
                }
        }

        return timeVal;
}


CCODE           BackupAFile(UINT32 tsaConn, UINT32 tsaSeq, void *readBuffer, int nameGood, NWSM_DATA_SET_NAME name)
{
        UINT32                                           dataSetHandle;
        UINT32                                           elapsedTime;
	unsigned __int64                              readsThisFile;
        UINT32                                           startTime;
        CCODE                                            err = 0;
    
        /* Open the data set */
        startTime = GetTimer();
        if ((err = NWSMTSOpenDataSetForBackup(tsaConn, tsaSeq, NWSM_RESTORE_MODIFY_FLAG, &dataSetHandle)) == 0)
        {
                elapsedTime = CorrectRollOverAndTruncate(GetTimer(), startTime);
                totalOpenTime += elapsedTime;
                if (LogData && openHistogram)
                {
                        openHistogram[GetHistogramBucket(elapsedTime)]++;
                        
                }
                backedUpSets++;
                if (FullLog)
                {
                        LogText0("Data set open");
                }

                /* Read data until there is no more */
                readsThisFile = 0;
                do
                {
                        startTime = GetTimer();
                        err = NWSMTSReadDataSet(tsaConn, dataSetHandle, BuffSize, &bytesRead, readBuffer);
                        elapsedTime = CorrectRollOverAndTruncate(GetTimer(), startTime);
                        if (err != 0)
                        {
                                LogText1("Read Data Set failure: %X", err);
                                if (fErrLog)
                                        fprintf(fErrLog, "Read Data Set failed: %s%s - %X\n", 
                                                                                nameGood ? (char *)name.name : "", 
                                                                                nameGood && (scanInfo->attributes & NWFA_DIRECTORY) ? "\\" : "", err);
                                break;
                        }
                        totalReadTime += elapsedTime;
                        readsThisFile++;
                         if (LogData && readHistogram)
                        {                                                               
                                readHistogram[GetHistogramBucket(elapsedTime)]++;
                        }

                        if (elapsedTime > maxReadTime)
                        {
                                maxReadTime = elapsedTime;
                        }
                        else if (elapsedTime < minReadTime)
                        {
                                minReadTime = elapsedTime;
                        }

                        /* If a key was pressed and it was escape */
                        if ( kbhit() && (getch()==27) || (UnloadState & TSATEST_UNLOAD_TRIGGERED))
                        {
                                err = NWSMTSCloseDataSet(tsaConn, &dataSetHandle);
                                if (err == 0)
                                {
                                        if (FullLog)
                                        {
                                                LogText0("Data set closed");
                                        }
                                }
                                else
                                {
                                        LogText1("Failed to close data set: %X", err);
                                        if (fErrLog)
                                        {
                                                fprintf(fErrLog, "Close Data Set failed: %s%s - %X\n", 
                                                                                        nameGood ? (char *)name.name : "", 
                                                                                        nameGood && (scanInfo->attributes & NWFA_DIRECTORY) ? "\\" : "", err);
                                        }
                                }
                                err = 27;
                                /* Break the loop */
                                return err;
                        }
                        if( readsThisFile >= 16) 
                        { // 16 reads will be Approximately 1 MB of Data
                                totalBytesRead += ((unsigned __int64)(readsThisFile - 1) * (unsigned __int64)BuffSize);
                                readCount += readsThisFile;
                                readsThisFile = 0;
                                lastElapsedTime = elapsedTime;
                                RefreshDisplay();
                        }
                } while(bytesRead == BuffSize);
                lastElapsedTime = elapsedTime;

                /* Update statistics for this file */
                readCount += readsThisFile;
                if (readsThisFile == 1)
                        totalBytesRead += (unsigned __int64)bytesRead;
                else if (readsThisFile > 1)
                        totalBytesRead += ((unsigned __int64)(readsThisFile - 1) * (unsigned __int64)BuffSize) + (unsigned __int64)bytesRead;

                /* Close the data set */
                startTime = GetTimer();
                err = NWSMTSCloseDataSet(tsaConn, &dataSetHandle);
                elapsedTime = CorrectRollOverAndTruncate(GetTimer(), startTime);
                totalCloseTime += elapsedTime;
                if (LogData && closeHistogram)
                {
                        closeHistogram[GetHistogramBucket(elapsedTime)]++;
                }

                if (err == 0)
                {
                        if (FullLog)
                        {
                                LogText0("Data set closed");
                        }
                }
                else
                {
                        LogText1("Failed to close data set: %X", err);
                        if (fErrLog)
                        {
                                fprintf(fErrLog, "Close Data Set failed: %s%s - %X\n", 
                                                                        nameGood ? (char *)name.name : "", 
                                                                        nameGood && (scanInfo->attributes & NWFA_DIRECTORY) ? "\\" : "", err);
                        }
                }
        }
        else
        {
                LogText1("Open Data Set failed: %X", err);
                if (fErrLog)
                {
                        fprintf(fErrLog, "Open Data Set failed: %s%s - %X\n", 
                                                                nameGood ? (char *)name.name : "", 
                                                                nameGood && (scanInfo->attributes & NWFA_DIRECTORY) ? "\\" : "", err);
                }

                /* Caller needs to ignore open errors */
                err = 0;
        }
        return err;
}

void RefreshDisplay()
{
        static int                                       lastSeconds = 0;
        static int                                       totalSeconds = 0;
        double                                           workspaceD = 0.0;
        double                                           wSpace;
        UINT32                                           workspace32;
        static unsigned int                      passes = 0;
        int                                                      barPos;
        BYTE                                             screenData[160];
        char                                             txt[256];
#ifdef N_PLAT_UNIX
	 UINT32                                         eraseCount;
        char							    line[80]={' '};
#endif        
        
        /* Get the time and calculate the elapsed time */
                time(&backupEnd);
                totalSeconds = (int)difftime(backupEnd, backupStart);

                /* Only update every second */
                if (totalSeconds != lastSeconds)
                {
                        /* Calculate and display the average scan time */
                        workspaceD = (double)totalScanTime;
                        workspaceD /= (double)scanCount;
                        StatFloatText1(X_AVE_SCAN_TIME + X_DATA_OFFSET, Y_AVE_SCAN_TIME, workspaceD);

                        /* Display the number of backup sets */
                        StatText1(X_BACKUP_SETS + X_DATA_OFFSET, Y_BACKUP_SETS, "%d          ", backedUpSets);

                        /* Calculate and display the average open time */
                        workspaceD = (double)totalOpenTime;
                        workspaceD /= (double)backedUpSets;
                        StatFloatText1(X_AVE_OPEN_TIME + X_DATA_OFFSET, Y_AVE_OPEN_TIME, workspaceD);

                        /* Calculate and show the average close time */
                        workspaceD = (double)totalCloseTime;
                        workspaceD /= (double)backedUpSets;
                        StatFloatText1(X_AVE_CLOSE_TIME + X_DATA_OFFSET, Y_AVE_CLOSE_TIME, workspaceD);

                        /* Show the last read size */
                        StatText1(X_LAST_READ_SIZE + X_DATA_OFFSET, Y_LAST_READ_SIZE, "%d          ", bytesRead);

                        /* Show the total bytes read */
                        workspaceD = (double)totalBytesRead;
                        StatText1(X_TOTAL_BYTES_READ + X_DATA_OFFSET, Y_TOTAL_BYTES_READ, "%.0f    ", workspaceD);
                        
                        /* Show the maximum and minimum read times */
                        StatIntText1(X_MAX_READ_TIME + X_DATA_OFFSET, Y_MAX_READ_TIME, maxReadTime);
                        StatIntText1(X_MIN_READ_TIME + X_DATA_OFFSET, Y_MIN_READ_TIME, minReadTime);
                        
                        /* Show the total number of reads performed */
                          workspaceD = (double)readCount;
                        StatText1(X_READ_COUNT + X_DATA_OFFSET, Y_READ_COUNT, "%.0f        ", workspaceD);
                        
                        /* Show the last read time */
                        StatIntText1(X_LAST_READ_TIME + X_DATA_OFFSET, Y_LAST_READ_TIME, lastElapsedTime);
                        
                        /* Calculate and show the average read time */
                        if (readCount != 0)
                        {
                                workspace32 = (UINT32)(totalReadTime / readCount);
                        }
                        else
                        {
                                workspace32 = 0;
                        }
                        StatIntText1(X_AVE_READ_TIME + X_DATA_OFFSET, Y_AVE_READ_TIME, workspace32);
                        
                        /* Calculate and show the raw data rate */
                        if (totalReadTime != 0)
                        {
                                workspaceD = (double)totalBytesRead * 60.0;
                                workspaceD /= ((1048576 / TimerSecFactor()) * (double)totalReadTime);
                        }
                        else
                        {
                                workspaceD = 1.0;
                        }
                        StatText1(X_RAW_DATA_RATE + X_DATA_OFFSET, Y_RAW_DATA_RATE, "%.2f          ", workspaceD);
                        
                        /* Show the total read time */
                        StatText1(X_TOTAL_READ_TIME + X_DATA_OFFSET, Y_TOTAL_READ_TIME, "%Lds         ", (totalReadTime / TimerSecFactor()));

                        /* Display the elapsed time */
                        StatText1(X_ELAPSED_TIME + X_DATA_OFFSET, Y_ELAPSED_TIME, "%ds         ", totalSeconds);

                        /* Calculate and display the effective data rate */
                        workspaceD = (double)totalBytesRead * 60.0;
                        totalTime = totalScanTime + totalOpenTime + totalReadTime + totalCloseTime;
                        workspaceD /= (1048576 / TimerSecFactor() * (double)totalTime + 1);
                        StatText1(X_EFFECTIVE_DATA_RATE + X_DATA_OFFSET, Y_EFFECTIVE_DATA_RATE, "%.2f          ", workspaceD);


                        /* Log the total time we spent in the TSA */
                        StatText1(X_TSA_TIME + X_DATA_OFFSET, Y_TSA_TIME, "%ds    ", (totalTime / TimerSecFactor()));

                        /* Estimate the error */

                        /* Re-calculate the throughput using a time that is increased 
                           by the timer resolution for every scan, open, read and close */
                        wSpace = (double)totalBytesRead * 60.0;
                        if (!Milliseconds)
                                totalTime += scanCount + (backedUpSets * 2) + readCount;
                        else
                                totalTime += TimerSecFactor() * (scanCount + (backedUpSets * 2) + readCount);

                        wSpace /= (1048576 / TimerSecFactor() * (double)totalTime + 1);

                        /* Use the new throughput and the old one to calculate a percentage error */
                        wSpace = workspaceD - wSpace;
                        wSpace = 100.0 * (wSpace / workspaceD);
                        workspace32 = (UINT32)wSpace;
                        StatText1(X_EST_ERROR + X_DATA_OFFSET, Y_EST_ERROR, "%.2f%%        ", wSpace);

                        /* Calculate and show the average file read time */
                        workspaceD = (double)totalReadTime;
                        workspaceD /= (double)backedUpSets;
                        StatFloatText1(X_AVE_FILE_READ_TIME + X_DATA_OFFSET, Y_AVE_FILE_READ_TIME, workspaceD);

                        /* We are up-to-date */
                        lastSeconds = totalSeconds;
                }
                if (PresentationMode)
                {
                        /* Calculate and show the raw data rate */
                        if (totalTime != 0)
                        {
                                /* Calculate and display the effective data rate */
                                workspaceD = (double)totalBytesRead * 60.0;
                                totalTime = totalScanTime + totalOpenTime + totalReadTime + totalCloseTime;
                                workspaceD /= (1048576 / TimerSecFactor() * (double)totalTime + 1);
                        }
                        else
                        {
                                workspaceD = 1.0;
                        }
                        if ((passes % MOD_PASSES == 0) && (workspaceD < 10000.0) && (workspaceD > 0.0))
                        {
                                
#ifdef N_PLAT_UNIX
                               /* for erasing the screen in Presentation Mode to avoid overlapping of previous and present big letters*/
                                for(eraseCount=0;eraseCount<480;eraseCount++)
                                {
                                 		StatText1((eraseCount%80),13+(eraseCount/80),"%c",' ');
				    }
#endif
                              
                                sprintf(txt, "  %.2f   ", workspaceD);
                                PrintBigString(0, 21, txt);
                        }

                        passes++;
                        if (DataSetSize != 0)
                        {
                                unsigned __int64 tempQ = (unsigned __int64)totalBytesRead;
                                tempQ *= 1000;
                                tempQ /= DataSetSize;
                                tempQ *= 160;   /* Screen is 80 characters, but each screen character is two bytes */
                                tempQ /= 1000;
                                CopyFromScreenMemory(1, 80, screenData, 0, 22);
                                for (barPos = 1; barPos < 160; barPos += 2)
                                {
                                        if (barPos <= tempQ)
                                        {
				                    screenData[barPos] = 0x70;
#ifdef N_PLAT_UNIX
                                                StatText1(barPos/2,22,"%c",24);
#endif
                                        }
                                        else
                                        {
                                                screenData[barPos] = 0x07;

                                        }
                                }       
                                CopyToScreenMemory(1, 80, screenData, 0, 22);
                        }
                }
}

/* Backup using linear processing */
int DoBackup(UINT32 tsaConn, UINT32 *tsaSeq,        NWSM_DATA_SET_NAME_LIST **dataSetNameList, UINT32 ExtStartTime)
{
        int                                                      retval = 0;
        int                                                      barPos;
        int                                                      maFilled;
        int                                                      nameGood = 0;
        int                                                      lastSeconds;
        int                                                      totalSeconds;
        void                                            *readBuffer;
        char                                             txt[256];
        UINT32                                           elapsedTime;
        SMS_HANDLE                                       nameHandle;
        UINT32                                           startTime = ExtStartTime;
        UINT32                                           workspace32;
        unsigned __int64                         b4BytesRead;
        unsigned __int64                         b4TotalTime = totalScanTime + totalOpenTime + totalReadTime + totalCloseTime;
        unsigned __int64                         wSpace64;
        double                                           workspaceD;
        double                                           wSpace;
        CCODE                                            err;
        FILE                                            *logFile;
        NWSM_DATA_SET_NAME                       name;
        UINT32                                           nameLen=0;
        UINT32                                           lenCount;     
        char 							*dest=NULL;
        size_t 							destLen;
        int ccode;
            
        /* Allocate a read buffer */
        if (FirstPass || ((GrowByAmount == 0) && (GrowByFactor == 0)))
                readBuffer = malloc(BuffSize);
        else
        {
                if (GrowByAmount)
                        readBuffer = malloc(BuffSize * (MaxIterations - Iterations) * GrowByAmount);
                else
                        readBuffer = malloc(BuffSize * (MaxIterations - Iterations + 1) * GrowByFactor);
        }
        if (readBuffer == NULL)
        {
                LogText0("Failed to allocate a read buffer");
                return 27;
        }

        totalSeconds = 0;
        lastSeconds = 0;

        /* Repeat until there is no more data */
        do
        {
                /* Work out the elapsed time on scan */
                elapsedTime = CorrectRollOverAndTruncate(GetTimer(), startTime);
                scanCount++;
                totalScanTime += elapsedTime;
                if (LogData && scanHistogram)
                {
                        scanHistogram[GetHistogramBucket(elapsedTime)]++;
                }

                /* Get the data set's name, if we are likely to use it */
                if (ShowNames || (fErrLog) || (Average))
                {
                        if (!DoNDS)
                        {
                         		nameGood = (NWSMGetDataSetName(*dataSetNameList, nameSpace, &name)==0);
				 	if(IsUTF8Supp)
					{
                                 		ccode = SMutf82loc(NULL, &destLen, (utf8_t *)name.name, strlen(name.name), NULL) ;
                                 		if(ccode)
						{
							printf("SMutf82loc error : 0x%x\n", ccode);
						}
						destLen ++;
						dest=(char *)malloc(destLen);
						ccode = SMutf82loc(dest, &destLen, (utf8_t *)name.name, strlen(name.name), NULL) ;
						if(ccode)
						{
							printf("SMutf82loc error : 0x%x\n", ccode);
							if(dest)
							{
								free(dest);
								dest = NULL;
							}			
						}
						if(!ShowNames)
						{
							if(dest)
							{
								free(dest);
								dest = NULL;
							}		
						}
						
					}                                                           
                        }
                        else
                        {
                                nameGood = (NWSMGetFirstName(*dataSetNameList, &name, &nameHandle) == 0);
                                if (nameGood)
                                {
                                        (void)NWSMCloseName(&nameHandle);
                                }
                        }
                }

                /* If requested, show the name, but not for directories */
                if (ShowNames)
                {
                        if (nameGood && (!(scanInfo->attributes & NWFA_DIRECTORY) || (DoNDS)))
                        {
                        	 	for(lenCount=0;lenCount<nameLen;lenCount++)
                                		StatText1(X_CURRENT_NAME + X_DATA_OFFSET+lenCount, Y_CURRENT_NAME, "%c",' ');
					if(IsUTF8Supp)
					{
						StatText1(X_CURRENT_NAME + X_DATA_OFFSET, Y_CURRENT_NAME, "%s", dest);
						nameLen = strlen(dest);
					}
					else
					{
	 	    	                     StatText1(X_CURRENT_NAME + X_DATA_OFFSET, Y_CURRENT_NAME, "%s", name.name);
          	    	                  	nameLen = strlen(name.name);
          	    	             	}
                                	StatText0(X_CURRENT_NAME + X_DATA_OFFSET + 11, Y_CURRENT_NAME + 1, "^");
                        }
                }
		if(dest)
		{
			free(dest);
			dest = NULL;
		}		

		  /* Save state we'll need for moving averate calculation */
                if (Average)
                {
                        b4BytesRead = totalBytesRead;
                }

                /* Backup the current data set */
                err = BackupAFile(tsaConn, *tsaSeq, readBuffer, nameGood, name);
	          if (err != 0)
                {
                        retval = err;
			   break;
                }

                /* If we are doing moving averages */
                if (Average)
                {
                        /* Handle moving average data */
                        maFilled = (maData[maInsert].bytes != 0);
                        if (maFilled)
                        {
                                /* Subtract the slot from the moving average state */
                                maTotalBytes -= maData[maInsert].bytes;
                                maTotalTime -= maData[maInsert].elapsed;
                        }

                        /* Update the moving average state */
                        maData[maInsert].bytes = totalBytesRead - b4BytesRead;
                        totalTime = totalScanTime + totalOpenTime + totalReadTime + totalCloseTime;
                        maData[maInsert].elapsed = totalTime - b4TotalTime;

                        /* Save the total time - we need to do this here to collect the scan time on the next pass */
                        b4TotalTime = totalTime;

                        /* Update the moving average state */
                        maTotalBytes += maData[maInsert].bytes;
                        maTotalTime += maData[maInsert].elapsed;
                        maInsert++;
                        if (maInsert >= maGroupLen)
                        {
                                maFilled = 1;
                                maInsert = 0;
                        }

                        /* If the state array is full we can look at tracking the moving average */
                        if(maFilled)
                        {
                                /* Calculate the moving average throughput for the current group */
                                workspaceD = (double)maTotalBytes * 60.0;
                                if (maTotalTime == 0)
                                {
                                        workspaceD /= 1048576 / TimerSecFactor();
                                }
                                else
                                {
                                        workspaceD /= (1048576 / TimerSecFactor() * (double)maTotalTime);
                                }

                                /* If change exceeds the tolerence */
                                if ((workspaceD < (maTolerenceLow * maCurrent)) 
                                                || (workspaceD > (maTolerenceHigh * maCurrent)))
                                {
                                        /* Save the stats for this group and reset */
                                        if ((fMovingAve != NULL) && (maCurrent != 0.0))
                                        {
                                                wSpace64 = maSetTotalBytes;
                                                wSpace64 /= maSamples;
                                                fprintf(fMovingAve, "%g,%d,%Ld", maCurrent, maSamples, wSpace64);
                                                fprintf(fMovingAve, ",%s\n", name.name);
                                        }
                                        maCurrent = workspaceD;
                                        maSamples = maGroupLen - 1;
                                        maSetTotalBytes = maTotalBytes;
                                        maSetTotalTime = maTotalTime;
                                }
                                else
                                {
                                        maSetTotalBytes += maData[maInsert].bytes;
                                        maSetTotalTime += maData[maInsert].elapsed;
                                }
                        }

                        maSamples++;
                }
                RefreshDisplay();

        /* If a key was pressed and it was escape */
                if ( kbhit() && (getch()==27)|| (UnloadState & TSATEST_UNLOAD_TRIGGERED))
                {
                        retval = 27;
			   /* Break the loop */
                        break;
                }

                /* Start timer for next scan operation and/or loop iteration */
                startTime = GetTimer();
        }while(NWSMTSScanNextDataSet(tsaConn, tsaSeq, &scanInfo, dataSetNameList) == 0);
        time(&backupEnd);
        totalSeconds = (int)difftime(backupEnd, backupStart);

        /* Calculate and display the average scan time */
        workspaceD = (double)totalScanTime;
        workspaceD /= (double)scanCount;
        StatFloatText1(X_AVE_SCAN_TIME + X_DATA_OFFSET, Y_AVE_SCAN_TIME, workspaceD);

        /* Display the number of backup sets */
        StatText1(X_BACKUP_SETS + X_DATA_OFFSET, Y_BACKUP_SETS, "%d          ", backedUpSets);

        /* Calculate and display the average open time */
        workspaceD = (double)totalOpenTime;
        workspaceD /= (double)backedUpSets;
        StatFloatText1(X_AVE_OPEN_TIME + X_DATA_OFFSET, Y_AVE_OPEN_TIME, workspaceD);

        /* Calculate and show the average close time */
        workspaceD = (double)totalCloseTime;
        workspaceD /= (double)backedUpSets;
        StatFloatText1(X_AVE_CLOSE_TIME + X_DATA_OFFSET, Y_AVE_CLOSE_TIME, workspaceD);

        /* Show the total bytes read */
        workspaceD = (double)totalBytesRead;
        StatText1(X_TOTAL_BYTES_READ + X_DATA_OFFSET, Y_TOTAL_BYTES_READ, "%.0f          ", workspaceD);
        
        /* Show the maximum and minimum read times */
        StatIntText1(X_MAX_READ_TIME + X_DATA_OFFSET, Y_MAX_READ_TIME, maxReadTime);
        StatIntText1(X_MIN_READ_TIME + X_DATA_OFFSET, Y_MIN_READ_TIME, minReadTime);
        
        /* Show the total number of reads performed */
        StatText1(X_READ_COUNT + X_DATA_OFFSET, Y_READ_COUNT, "%d          ", readCount);

        /* Calculate and show the average read time */
        if( readCount != 0 ) 
        {
                workspace32 = (UINT32)(totalReadTime / readCount);
        }
        else
        {
                workspace32 = 0;
        }

        StatIntText1(X_AVE_READ_TIME + X_DATA_OFFSET, Y_AVE_READ_TIME, workspace32);
        
        /* Calculate and show the raw data rate */
        if (totalReadTime != 0)
        {
                workspaceD = (double)totalBytesRead * 60.0;
                workspaceD /= (1048576 / TimerSecFactor() * (double)totalReadTime);
        }
        else
        {
                workspaceD = 1.0;
        }
        StatText1(X_RAW_DATA_RATE + X_DATA_OFFSET, Y_RAW_DATA_RATE, "%.2f          ", workspaceD);
        
        /* Show the total read time */
        StatText1(X_TOTAL_READ_TIME + X_DATA_OFFSET, Y_TOTAL_READ_TIME, "%Lds         ", (totalReadTime / TimerSecFactor()));

        /* Display the elapsed time */
        StatText1(X_ELAPSED_TIME + X_DATA_OFFSET, Y_ELAPSED_TIME, "%ds         ", totalSeconds);

        /* Calculate and display the effective data rate */
        workspaceD = (double)totalBytesRead * 60.0;
        totalTime = totalScanTime + totalOpenTime + totalReadTime + totalCloseTime;
        workspaceD /= (1048576 / TimerSecFactor() * (double)totalTime + 1);
        StatText1(X_EFFECTIVE_DATA_RATE + X_DATA_OFFSET, Y_EFFECTIVE_DATA_RATE, "%.2f          ", workspaceD);
        
                
        if ((PresentationMode) && (workspaceD < 10000.0) && (workspaceD > 0.0))
        {
        	int eraseCount;
		/* for erasing the screen in Presentation Mode to avoid overlapping of previous and present big letters*/
              for(eraseCount=0;eraseCount<480;eraseCount++)
              {
              	StatText1((eraseCount%80),13+(eraseCount/80),"%c",' ');
		}
                sprintf(txt, "  %.2f   ", workspaceD);
                PrintBigString(0, 21, txt);
        }

        /* Log the total time we spent in the TSA */
        StatText1(X_TSA_TIME + X_DATA_OFFSET, Y_TSA_TIME, "%ds    ", (totalTime / TimerSecFactor()));

        /* Estimate the error */

        /* Re-calculate the throughput using a time that is increased 
           by the timer resolution for every scan, open, read and close */
        wSpace = (double)totalBytesRead * 60.0;
        if (!Milliseconds)
                totalTime += scanCount + (backedUpSets * 2) + readCount;
        else
                totalTime += TimerSecFactor() * (scanCount + (backedUpSets * 2) + readCount);

        wSpace /= (1048576 / TimerSecFactor() * (double)totalTime + 1);

        /* Use the new throughput and the old one to calculate a percentage error */
        wSpace = workspaceD - wSpace;
        wSpace = 100.0 * (wSpace / workspaceD);
        workspace32 = (UINT32)wSpace;
        StatText1(X_EST_ERROR + X_DATA_OFFSET, Y_EST_ERROR, "%.2f%%        ", wSpace);

        /* Write a log file if required */
        if (LogData)
        {
                if (FirstPass)
                {
                        logFile = fopen(LogFileName, "wt");
                }
                else
                {
                        logFile = fopen(LogFileName, "r+t");
                }
                if (logFile != NULL)
                {
                     if (FirstPass)
			{
				#ifdef N_PLAT_NLM
				fprintf(logFile, "Volume,Bytes Read,Reads,Data Sets,Avg Scan Time,Avg Open Time,Avg Close Time,");
				#else				
				fprintf(logFile, "Resource,Bytes Read,Reads,Data Sets,Avg Scan Time,Avg Open Time,Avg Close Time,");
				#endif
				fprintf(logFile, "Avg Read Time,Avg File Read Time,Min Read Time,Max Read Time,Total Read Time,TSA Time,Elapsed Time,");
				/*  for(barPos = 0; barPos < 32; barPos++)
				{
				        fprintf(logFile, "scan[%d],", barPos);
				}
				for(barPos = 0; barPos < 32; barPos++)
				{
					    fprintf(logFile, "open[%d],", barPos);
				}
				for(barPos = 0; barPos < 32; barPos++)
				{
				        fprintf(logFile, "read[%d],", barPos);
				}
				for(barPos = 0; barPos < 32; barPos++)
				{
				        fprintf(logFile, "close[%d],", barPos);
				}*/

				WriteHistogramHeader(logFile, "scan");
				WriteHistogramHeader(logFile, "open");
				WriteHistogramHeader(logFile, "read");
				WriteHistogramHeader(logFile, "close");

				fprintf(logFile, "\n");
			}

                        fseek(logFile, 0, SEEK_END);

                        /* Write the data as a comma delimited file */
                        if (Aggregate)
                        {
                                fprintf(logFile, "Aggregate To End Of ");
                        }
                        fprintf(logFile, "%s,", AllVolNames[WorkingVolume]);
                        
                        workspaceD = (double)totalBytesRead;
                        fprintf(logFile, "%.0f", workspaceD);

			   workspaceD = (double)readCount;	                        
                        fprintf(logFile, ",%.0f", workspaceD);
                        fprintf(logFile,",%d,", backedUpSets);

                        workspaceD = (double)totalScanTime;
                        workspaceD /= (TimerSecFactor() * (double)scanCount);
                        fprintf(logFile, "%g,", workspaceD);
                        workspaceD = (double)totalOpenTime;
                        workspaceD /= (TimerSecFactor() * (double)backedUpSets);
                        fprintf(logFile, "%g,", workspaceD);
                        workspaceD = (double)totalCloseTime;
                        workspaceD /= (TimerSecFactor() * (double)backedUpSets);
                        fprintf(logFile, "%g,", workspaceD);
                        workspaceD = (double)totalReadTime;
                        workspaceD /= (TimerSecFactor() * (double)readCount);
                        fprintf(logFile, "%g,", workspaceD);
                        workspaceD = (double)totalReadTime;
                        workspaceD /= (TimerSecFactor() * (double)backedUpSets);
                        fprintf(logFile, "%g,", workspaceD);
                        if (minReadTime == 0)
                        {
                                workspaceD = 0.000099;
                        }
                        else
                        {
                                workspaceD = (double)minReadTime;
                                workspaceD /= TimerSecFactor();
                        }
                        fprintf(logFile, "%g,", workspaceD);
                        workspaceD = (double)maxReadTime;
                        workspaceD /= TimerSecFactor();
                        fprintf(logFile, "%g,", workspaceD);
                        workspaceD = totalReadTime;
                        workspaceD /= TimerSecFactor();
                        fprintf(logFile, "%g,", workspaceD);
                        totalTime = totalScanTime + totalOpenTime + totalReadTime + totalCloseTime;
                        workspaceD = totalTime;
                        workspaceD /= TimerSecFactor();
                        fprintf(logFile, "%g,", workspaceD);
                        fprintf(logFile, "%g,", difftime(backupEnd, backupStart));

			   if(MinHistogramBucketValue)
				   fprintf(logFile, "%d,", scanHistogram[MaxHistogramBuckets]);
			   for(barPos = 0; barPos < MaxHistogramBuckets; barPos++)
                        {
                                fprintf(logFile, "%d,", scanHistogram[barPos]);
                        }
			    fprintf(logFile, "%d,", scanHistogram[MaxHistogramBuckets + 1]);
			    
	                 if(MinHistogramBucketValue)	
				   fprintf(logFile, "%d,", openHistogram[MaxHistogramBuckets]);
                        for(barPos = 0; barPos < MaxHistogramBuckets; barPos++)
                        {
                                fprintf(logFile, "%d,", openHistogram[barPos]);                                
                        }
                        fprintf(logFile, "%d,", openHistogram[MaxHistogramBuckets + 1]);

			   if(MinHistogramBucketValue)
                        	fprintf(logFile, "%d,", readHistogram[MaxHistogramBuckets]);
                        for(barPos = 0; barPos < MaxHistogramBuckets; barPos++)
                        {
                                fprintf(logFile, "%d,", readHistogram[barPos]);
                        }
                        fprintf(logFile, "%d,", readHistogram[MaxHistogramBuckets + 1]);

			   if(MinHistogramBucketValue)	
	                        fprintf(logFile, "%d,", closeHistogram[MaxHistogramBuckets]);
                        for(barPos = 0; barPos < MaxHistogramBuckets; barPos++)
                        {
                                fprintf(logFile, "%d,", closeHistogram[barPos]);
                        }
                        fprintf(logFile, "%d", closeHistogram[MaxHistogramBuckets + 1]);
                        fprintf(logFile, "\n");

                        fclose(logFile);
                }
                else
                {
                        LogText0("Failed to open log file");
                }
        }

        /* Finished with the buffer */
        free(readBuffer);
        return(retval);
} 
