/****************************************************************************
 |
 |	(C) Copyright 2001, 2004-2014  Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is free software; you can redistribute it and/or
 |	modify it under the terms of version 2 of the GNU General Public
 |	License as published by the Free Software Foundation.
 |
 |	This program is distributed in the hope that it will be useful,
 |	but WITHOUT ANY WARRANTY; without even the implied warranty of
 |	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 |	GNU General Public License for more details.
 |
 |	You should have received a copy of the GNU General Public License
 |	along with this program; if not, contact Novell, Inc.
 |
 |	To contact Novell about this file by physical or electronic mail,
 |	you may find current contact information at www.novell.com
 |
 |***************************************************************************
 |
 |	 Novell Storage Services (NSS) module
 |
 |---------------------------------------------------------------------------
 |
 | $Author: kpraveen $
 | $Date: 2014-12-16 11:46:47 +0530 (Tue, 16 Dec 2014) $
 |
 | $RCSfile$
 | $Revision: 5342 $
 |
 |---------------------------------------------------------------------------
 |	This module is used to:
 |		Define bit masks and other values used in the NSS file system APIs
 +-------------------------------------------------------------------------*/
#ifndef _ZPARAMS_H_
#define _ZPARAMS_H_

#ifndef _ZOMNI_H_
#	include <zOmni.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifdef __LP64__
#define zPACKED	__attribute__((packed))
#else
#define zPACKED
#endif

/*=========================================================================
 *=========================================================================
 *	Defines for bit masks and values
 *=========================================================================
 *=========================================================================*/

/*-----------------------------------------------------------------------
 *	Definition of attributes for supportedAttributes and enabledAttributes
 *	fields in the volume and LSS info structures
 *-----------------------------------------------------------------------*/
#define zATTR_SALVAGE					0x00000001
#define zATTR_USER_SPACE_RESTRICTIONS	0x00000002
#define zATTR_READONLY					0x00000004
#define zATTR_COMPRESSION 				0x00000008
#define zATTR_EXTENDED_ATTRIBUTES		0x00000010
#define zATTR_DATA_STREAMS				0x00000020
#define zATTR_DOS_METADATA				0x00000040
#define zATTR_NETWARE_METADATA			0x00000080
#define zATTR_MAC_METADATA				0x00000100
#define zATTR_UNIX_METADATA				0x00000200
#define zATTR_HARD_LINKS				0x00000400
#define zATTR_TRANSACTION				0x00000800
#define zATTR_SPARSE_FILES				0x00001000
#define zATTR_PHYSICAL_EOF				0x00002000
#define zATTR_DIRECT_IO					0x00004000
#define zATTR_PERSISTENT_ATTRIBUTES		0x00008000
#define zATTR_VERIFY					0x00010000
#define zATTR_REBUILD					0x00020000
#define zATTR_COW						0x00040000
#define zATTR_VIRTUAL_FILES				0x00080000
#define zATTR_USER_TRANSACTION			0x00100000	/* indicates the volume 
													 * can be transactioned on 
													 * next activate */
#define zATTR_USER_TRANSACTION_ACTIVE	0x00200000	/* indicates the volume is 
													 * currently being 
													 * transactioned */
#define zATTR_DONT_BACKUP               0x00400000  /* Don't backup this 
													 * volume */
#define zATTR_MFL                       0x00800000  /* Volume maintains MFL 
													 * data structure */
#define zATTR_DIR_QUOTAS				0x01000000
#define zATTR_SHRED_DATA				0x02000000
#define zATTR_SHARED					0x04000000	/* Pool/Volume is part
													 * of a cluster.  I.E.
													 * multiple servers have
													 * access to the pool/vol.
													 */
#define zATTR_HIGH_INTEGRITY			0x08000000
#define zATTR_MIGRATION					0x10000000
#define zATTR_CFS_MASTER				0x20000000	/* Volume is a Master for
													 * the Cluster File System
													 */
#define zATTR_CFS_SLAVE					0x40000000	/* Volume is a Slave for
													 * the cluster File system
													 */
#define zATTR_ENCRYPTED					0x80000000	/* designated this volume is encrypted */

#define zATTR_EXTENDED_MAC_NAMESPACE	UI64_CONST(0x100000000)	/* designates this volume uses 255 char Mac names */
#define zATTR_NO_ATIME					UI64_CONST(0x200000000)	/* designates this volume do not update metadata access times */
#define zATTR_AD_ENABLED				UI64_CONST(0x400000000) /* designates this volume supports AD identities */

/*-----------------------------------------------------------------------
 *	Definition of features(attributes) for supportedFeatures and
 *	enabledFeatures fields in the pool.
 *-----------------------------------------------------------------------*/

#define zPOOL_FEATURE_PERSISTENT_FEATURES		0x00000001uL
			/* zPOOL_FEATURE_PERSISTENT_FEATURES indicates that the pool's
			 * features are stored persistently.
			 */
#define	zPOOL_FEATURE_SHARED_CLUSTER			0x00000002uL
			/* zPOOL_FEATURE_SHARED_CLUSTER indicates that the pool is
			 * part of cluster and can therefore be accessed by more
			 * than one server (although only ONE server at a time).
			 */
#define	zPOOL_FEATURE_READ_ONLY					0x00000004uL
			/* zPOOL_FEATURE_READ_ONLY indicates that the pool is
			 * read only.  This means ABSOLUTELY no writes can be
			 * attempted on the pool.  Cluster software may allow
			 * multiple servers to active the POOL for load balance.
			 */
#define	zPOOL_FEATURE_VERIFY					0x00000008uL
			/* zPOOL_FEATURE_VERIFY indicates that the pool supports
			 * a verify operation.
			 */
#define	zPOOL_FEATURE_REBUILD					0x00000010uL
			/* zPOOL_FEATURE_REBUILD indicates that the pool supports
			 * a rebuild operation.
			 */
#define	zPOOL_FEATURE_MULTIPLE_VOLUMES			0x00000020uL
			/* zPOOL_FEATURE_MULTIPLE_VOLUMES indicates that the pool can
			 * support more than a ONE-TO-ONE relationship between the
			 * POOL and a volume.
			 */
#define	zPOOL_FEATURE_SNAPSHOT					0x00000040uL
			/* zPOOL_FEATURE_SNAPSHOT indicates that the pool is a
			 * snapshot of another pool.  This bit is set by ZLSS
			 * when the nssidk snapshot API is called.
			 */
#define	zPOOL_FEATURE_MSAP						0x00000080uL
			/* When set, zPOOL_FEATURE_MSAP indicates that
			 * we should execute MSAP logic to prevent mulitpel servers accessing
			 * the pool at the same time.
			 */

		/* zPOOL_FEATURE_LIST is just a define of all the LEGAL feature
		 * bits.  Used to indicate locations that must change when a
		 * bit is added and for legal bit verification.
		 */
#define	zPOOL_FEATURE_LIST													\
		  ( zPOOL_FEATURE_PERSISTENT_FEATURES		|						\
			zPOOL_FEATURE_SHARED_CLUSTER			| 						\
			zPOOL_FEATURE_READ_ONLY					|						\
			zPOOL_FEATURE_VERIFY			 		|  						\
			zPOOL_FEATURE_REBUILD			 		|  						\
			zPOOL_FEATURE_MULTIPLE_VOLUMES			|						\
			zPOOL_FEATURE_SNAPSHOT					|						\
			zPOOL_FEATURE_MSAP)

/*---------------------------------------------------------------------------
 *	Definitions for authSystemID (authorizaton System ID)
 *---------------------------------------------------------------------------*/
#define zAUTH_SYSTEM_UNDEFINED		0
#define zAUTH_SYSTEM_NSS_DEFAULT	1


/*---------------------------------------------------------------------------
 *	Defintions of connectionID
 *---------------------------------------------------------------------------*/
#define zSYS_CONNECTION				0

#ifdef _NSS_INTERNAL_
	#define INVALID_CONNECTION_ID (-1)
#endif


/*---------------------------------------------------------------------------
 *	Definitions for contextHandleType
 *---------------------------------------------------------------------------*/
#define zCX_CONNECTION_BASED		0
#define zCX_TASK_BASED				1

#ifdef _NSS_INTERNAL_
	#define zUNDEFINED_CXHANDLE		0
	#define zINVALID_CXHANDLE		(-1)

	#define zCX_NONMAPPABLE			2		/* Legacy compatability only */
	#define zCX_ALTERNATEREPLY		0x4000	/* Legacy NCP 87.12 only */
#endif


/*---------------------------------------------------------------------------
 *	Definitions for copyOptions
 *---------------------------------------------------------------------------*/

/* TBD */


/*-------------------------------------------------------------------------
 *	Definition of createFlags
 *-------------------------------------------------------------------------*/
#define zCREATE_OPEN_IF_THERE		0x00000001
#define zCREATE_TRUNCATE_IF_THERE	0x00000002
#define zCREATE_DELETE_IF_THERE		0x00000004
#define zCREATE_KEEP_VFS_CACHE		0x00000100	/* !! FOR INTERNAL USE ONLY !! */

#ifdef _NSS_INTERNAL_
	#define zVALID_CREATE_FLAGS \
			(zCREATE_OPEN_IF_THERE | zCREATE_TRUNCATE_IF_THERE | \
			 zCREATE_DELETE_IF_THERE | zCREATE_KEEP_VFS_CACHE)
#endif


/*---------------------------------------------------------------------------
 *	Definitions for createParms
 *---------------------------------------------------------------------------*/

/* TBD */


/*---------------------------------------------------------------------------
 *	Definitions of deleteFlags
 *---------------------------------------------------------------------------*/
#define zDELETE_PURGE_IMMEDIATE		0x00000001
#define zDELETE_FORCE_DELETE		0x00000002
#define zDELETE_KEEP_VFS_CACHE		0x00000100	/* !! FOR INTERNAL USE ONLY !! */

/*-------------------------------------------------------------------------
 *	Definition of file attributes
 *-------------------------------------------------------------------------*/
#define zFA_READ_ONLY		 		0x00000001
#define	zFA_HIDDEN 					0x00000002
#define	zFA_SYSTEM 					0x00000004
#define zFA_EXECUTE					0x00000008
#define zFA_SUBDIRECTORY	 		0x00000010
#define	zFA_ARCHIVE					0x00000020
#define	zFA_SHAREABLE		 		0x00000080
#define	zFA_SMODE_BITS		 		0x00000700
#define zFA_NO_SUBALLOC				0x00000800
#define zFA_TRANSACTION				0x00001000
#define zFA_NOT_VIRTUAL_FILE		0x00002000	/* only valid on a volume with the zATTR_VIRTUAL_FILES attribute */
#define zFA_IS_FIFO					0x00004000
#define zFA_IMMEDIATE_PURGE			0x00010000
#define zFA_RENAME_INHIBIT	 		0x00020000
#define zFA_DELETE_INHIBIT	 		0x00040000
#define zFA_COPY_INHIBIT	 		0x00080000
#define zFA_IS_ADMIN_LINK			0x00100000	/* if set then the file contains persistent admin link info */
#define zFA_IS_LINK					0x00200000
#define zFS_REMOTE_DATA_ACCESS		0x00400000	/** DEPRECATED **/
#define zFA_REMOTE_DATA_ACCESS		0x00400000	/* file has been migrated */
#define zFA_REMOTE_DATA_INHIBIT		0x00800000	/* don't allow file migration */
#define zFA_COMPRESS_FILE_IMMEDIATELY 0x02000000
#define zFA_DATA_STREAM_IS_COMPRESSED 0x04000000 /* per data stream directory entry */
#define zFA_DO_NOT_COMPRESS_FILE	  0x08000000
#define zFA_HARDLINK				0x10000000	 /* if set, this is a hardlink beast, real inode is pointed to by FILE */
#define zFA_CANT_COMPRESS_DATA_STREAM 0x20000000 /* can't save any space by compressiong this data stream */
#define zFA_ATTR_ARCHIVE	 		0x40000000
#define zFA_VOLATILE				0x80000000	/* Data is volatile (no oplocks) */

#ifdef _NSS_INTERNAL_
	#define zFA_VALID_FILE_ATTRIBUTES \
			(zFA_READ_ONLY | zFA_HIDDEN | zFA_SYSTEM | zFA_EXECUTE | \
			 zFA_ARCHIVE | zFA_SHAREABLE | zFA_SMODE_BITS | zFA_NO_SUBALLOC | \
			 zFA_TRANSACTION | zFA_IMMEDIATE_PURGE | zFA_RENAME_INHIBIT | \
			 zFA_DELETE_INHIBIT | zFA_COPY_INHIBIT | zFA_IS_LINK | \
			 zFA_REMOTE_DATA_ACCESS | zFA_REMOTE_DATA_INHIBIT | \
			 zFA_COMPRESS_FILE_IMMEDIATELY | \
			 zFA_DO_NOT_COMPRESS_FILE | zFA_ATTR_ARCHIVE | \
			 zFA_NOT_VIRTUAL_FILE | zFA_VOLATILE | zFA_HARDLINK | zFA_IS_FIFO)

	#define zFA_VALID_DIRECTORY_ATTRIBUTES	\
			(zFA_VALID_FILE_ATTRIBUTES | zFA_SUBDIRECTORY)

	/* For now, don't allow any data streams to have attributes.  NOTE--
	 * there is code in COMN_Create that assumes zFA_VALID_DATA_STREAM_ATTIBUTES
	 * is always a subset of zFA_VALID_FILE_ATTRIBUTES */
	#define zFA_VALID_DATA_STREAM_ATTRIBUTES (0)
#endif

/*-------------------------------------------------------------------------
 *	Bit definitions for ID attributes
 *-------------------------------------------------------------------------*/
#define zIA_AD_OWNER						0x00000001
#define zIA_AD_MODIFIER						0x00000002
#define zIA_AD_METADATA_MODIFIER				0x00000004
#define zIA_AD_ARCHIVER						0x00000008
#define zIA_AD_DELETOR						0x00000010
#define zIA_AD_DS_EA_OWNER					zIA_AD_OWNER


/*-------------------------------------------------------------------------
 *	Bit definitions for the trustee rights and inherited rights mask
 *-------------------------------------------------------------------------*/

#define	zAUTHORIZE_READ_CONTENTS			0x0001
#define	zAUTHORIZE_WRITE_CONTENTS			0x0002
#define	zAUTHORIZE_CREATE_ENTRY				0x0008
#define	zAUTHORIZE_DELETE_ENTRY				0x0010
#define	zAUTHORIZE_ACCESS_CONTROL			0x0020
#define	zAUTHORIZE_SEE_FILES				0x0040
#define	zAUTHORIZE_MODIFY_METADATA			0x0080
#define zAUTHORIZE_SUPERVISOR				0x0100
#define zAUTHORIZE_SALVAGE					0x0200
#define zAUTHORIZE_SECURE					0x8000 /* This special right is not inherited */

#define zVALID_TRUSTEE_RIGHTS \
			(zAUTHORIZE_READ_CONTENTS | zAUTHORIZE_WRITE_CONTENTS | \
			 zAUTHORIZE_CREATE_ENTRY | zAUTHORIZE_DELETE_ENTRY | \
			 zAUTHORIZE_ACCESS_CONTROL | zAUTHORIZE_SEE_FILES | \
			 zAUTHORIZE_MODIFY_METADATA | zAUTHORIZE_SUPERVISOR)

/*-------------------------------------------------------------------------
 *	Bit definitaions for authorization attributes
 *-------------------------------------------------------------------------*/
#define zAUTHORIZE_INHERIT_DOWN       0x8000
#define zAUTHORIZE_INHERIT_UP         0x4000	/* make directories above this file visible */
#define zAUTHORIZE_NEGATIVE_RIGHTS    0x2000	/* all other bits will be ignored if set*/


#define zVALID_TRUSTEE_ATTRIBUTES \
			(zAUTHORIZE_INHERIT_DOWN | zAUTHORIZE_INHERIT_UP | \
			 zAUTHORIZE_NEGATIVE_RIGHTS)

/*---------------------------------------------------------------------------
 *	Defines for fileHandleID
 *---------------------------------------------------------------------------*/
#define zUNDEFINED_FILEHANDLE	(-1)
#define zINVALID_FILEHANDLE		(0)


/*---------------------------------------------------------------------------
 *	Definition of extentListformat
 *---------------------------------------------------------------------------*/
enum FileMapFormats_t {
	zFILEMAP_ALLOCATION,
	zFILEMAP_LOGICAL,
	zFILEMAP_PHYSICAL
};

/*---------------------------------------------------------------------------
 *	This value is returned as the unit number in a zFILEMAP_PHYSICAL filemap
 *	to represent a sparse portion of the file.
 *---------------------------------------------------------------------------*/
#define zFILEMAP_SPARSEBLOCK	-1

/*---------------------------------------------------------------------------
 *	These structures are returned for file maps
 *---------------------------------------------------------------------------*/
/* For zFILEMAP_ALLOCATION, the following is returned */
typedef struct zAllocationExtentElement_s
{
	QUAD offset;
	QUAD length;
} zAllocationExtentElement_s;

/* For zFILEMAP_LOGICAL, the following is returned */
typedef struct zLogicalExtentElement_s
{
	QUAD blockNumber;
	QUAD numBlocks;
}zLogicalExtentElement_s;

/* For zFILEMAP_PHYSICAL, the following is returned */
typedef struct zPhysicalExtent_s
{
	QUAD	length;			/* Extent length in bytes		*/
	QUAD	logicalOffset;	/* Byte offset in the file		*/
	QUAD	poolOffset;		/* Byte offset in the pool		*/
	struct
	{
		QUAD	offset;		/* Byte offset on the device				*/
		ADDR	deviceID;	/* Device ID understood by Media Manager	*/
#ifndef __x86_64__
		LONG	padding;
#endif
	} physical;
} zPhysicalExtent_s;

/************************************************************************
 *  States of the fileHandle
 ***********************************************************************/
#define FH_NEW                  0x00
#define FH_MODIFIED             0x01
#define FH_WRITE_SNAPSHOT       0x02
#define FH_READ_BACKUP          0x04
#define FH_NDS_OPEN             0x08
#define FH_CFS_OPEN             0x10 /* The open was done for a CFS slave on
									  * the master.
									  */
#define FH_CFS_ASYNC_CLOSE      0x20 /*	Pre-Close -- decrementing the 
									  * the grantedRights counts has been
									  * done synchronously, now do the 
									  * async part of the close
									  */
#define FH_PURGING              0x40 /* To track file handle for purged beasts*/

/*---------------------------------------------------------------------------
 *	Definition of fileNameUniquifier
 *
 *	A file may have multiple parents, and multiple names within each parent.
 *	This is an ID which uniquely identifies which parent/name is being 
 *	referred to for a given file.
 *
 *	A well known value of zFNU_FIRST_PARENT will always map to the first
 *	name for the first parent container.  All other parents/names must be
 *	identified by a value retrieved from another API or event.
 *---------------------------------------------------------------------------*/
#define zFNU_UNDEFINED			0
#define zFNU_FIRST_PARENT		zFNU_UNDEFINED

#ifdef _NSS_INTERNAL_
	#define zFNU_INVALID_NAME_UNIQUIFIER	0xFFFF 
#endif

/*
 * File Types -- used to create files, directories and other
 * types of beasts.  It is upto the LSS to select the correct
 * beast type that corresponds to the given file type.
 * ONLY add new types to the bottom of the list before zFILE_MAX.
 */
typedef enum FileType_t {
	zFILE_UNKNOWN,				/* Unknown file type				*/
	zFILE_REGULAR,				/* A file or directory				*/
	zFILE_EXTENDED_ATTRIBUTE,	/* An extended attribute			*/
	zFILE_NAMED_DATA_STREAM,	/* Resource forks for Macintosh		*/
	zFILE_PIPE,					/* Acts like a UNIX named pipe		*/
	zFILE_VOLUME,				/* Logical storage					*/
	zFILE_POOL,					/* Physical storage					*/
	zFILE_MAX					/* End of the range of file types	*/
} FileType_t;

/*-------------------------------------------------------------------------
 *	Definition of Beast types
 *
 * These must be a unique value for every Beast Type.  These values are
 * assigned by Novell.  To request a value send E-Mail to NSS@Novell.Com and
 * ask for a BEAST TYPE for each beast that you are defining.
 *-------------------------------------------------------------------------*/
#define zFTYPE_INVALID				-1

	/******************************************************************************/
	/* When assigning a number ensure that the zAPI table BeastToFile is updated. */
	/******************************************************************************/

#define zFTYPE_ROOT_BEAST			0
#define zFTYPE_NAMED_DATA_STREAM	1
#define zFTYPE_AUTH_BEAST			2
#define zFTYPE_FILE					3 
#define zFTYPE_ADMIN_VOL_FILE		4
#define zFTYPE_VOLUME				5
#define zFTYPE_ADMIN_VOL			6
#define zFTYPE_NAMESPACE			7
#define	zFTYPE_POOL					8
#define zFTYPE_PIPE					9
#define zFTYPE_BEAST_CLASS			10	/* this must be the last primitive beast*/

#define zFTYPE_HARDLINK_BEAST		11
#define zFTYPE_EXTENDED_ATTRIBUTE	12

#define zFTYPE_ZAS_ACL_OVERFLOW		18
#define zFTYPE_ZAS_VIS_OVERFLOW		19

#define zFTYPE_AUTH_MODEL			20
#define zFTYPE_ZAS_AUTH_MODEL		21
#define zFTYPE_UNIX_AUTH_MODEL		22

#define zFTYPE_AUTH_SPACE			30
#define zFTYPE_ZAS_AUTH_SPACE		31
#define zFTYPE_UNIX_AUTH_SPACE		32

#define zFTYPE_COMPRESSION			36	/* compression beast */
#define zFTYPE_COMPRESSION_INTERMEDIATE 37 /* intermediate compression beast - upgrading */
										   /* from rootbeast */

	/* The next 15 IDs are assigned to Novell, Inc.  Contact NSS@Novell.com
	 * They are used in Novell's ZLSS
	 */
#define zFTYPE_ZLSS_ZFSPOOL			40
#define zFTYPE_ZLSS_VOL				41
#define zFTYPE_ZLSS_BTREE			42
#define zFTYPE_ZLSS_VOLUME_DATA		43
#define zFTYPE_ZLSS_BEAST_TREE		44
#define zFTYPE_ZLSS_NAME_TREE		45
#define	zFTYPE_ZLSS_LOG				46
#define zFTYPE_ZLSS_SALVAGE			47
#define	zFTYPE_ZLSS_PURGE_LOG		48
#define zFTYPE_ZLSS_FREE_EXTENT		49
#define zFTYPE_ZLSS_USER_TREE		50
#define zFTYPE_ZLSS_VOLUME_LOCATOR	51
#define	zFTYPE_ZLSS_LOGICAL_POOL	52
#define	zFTYPE_ZLSS_MFL            	53
#define zFTYPE_ZLSS_DIR_TREE		54
#define zFTYPE_ZLSS_EFL				55
#define zFTYPE_ZLSS_ADGUID_TREE		56

	/* The next two IDs are assigned to Novell, Inc.  Contact NSS@Novell.com
	 * They were used in Novell's ???
	 */
#define zFTYPE_CDROM_VOLUME			71

	/* The next two IDs are assigned to Novell, Inc.  Contact NSS@Novell.com
	 * They are used in Novell's ISO 9660 CD LSS
	 */
#define zFTYPE_ISO9660_VOLUME 		72		/* DOS LSS Volume ID */

	/* The next two IDs are assigned to Novell, Inc.  Contact NSS@Novell.com
	 * They are used in Novell's DOS LSS
	 */
#define zFTYPE_FAT_VOLUME			88		/* DOS LSS Volume ID */

	/* The next ID is assigned to Novell, Inc.  Contact NSS@Novell.com
	 * They are used in Novell's HFS (MAC) CD LSS
	 */
#define zFTYPE_HFSCD_VOLUME			91

	/* The next ID is assigned to Novell, Inc.  Contact NSS@Novell.com
	 * They were used in Novell's UDF (DVD) LSS
	 */
#define zFTYPE_UDFCD_VOLUME			93

	/* The next ID is assigned to Novell, Inc.  Contact NSS@Novell.com
	 * They were used in Novell's 32 Bit DOS LSS
	 */
#define zFTYPE_FAT32_VOLUME			95

	/* The next IDs are assigned to IBM.  Contact NSS@Novell.com
	 * They are used in IBM's NetWare Gateway LSS.
	 */
#define zFTYPE_NWSHRFLD_VOLUME		96
#define zFTYPE_NWSHRFLD_FILE		97


	/* The next ID is assigned to Novell, Inc.  They are used in Novell's
	 * SMS Tape LSS.  Given to Sudhir Subbarao <sksubbarao@novell.com> on
	 * Nov 17, 1998 by Greg Pachner <GPachner@Novell.com>
	 */
#define zFTYPE_SMSTAPE_VOLUME		98

	/* The next ID is assigned to Novell, Inc.  They are used in Novell's
	 * NFS Gateway LSS.  Given to Giridhar V <vgiridhar@novell.com> on
	 * Mar 31, 1999 by Paul Taysom <paul_taysom@Novell.com>
	 */
#define zFTYPE_NFSGATEWAY_VOLUME	99

	/* The next ID is assigned to Novell, Inc.  They are used in Novell's
	 * Cluster File System.  Given on on December 14, 2001 and March 7, 2002.
	 */
#define zFTYPE_XLSS_VOLUME				100

/* Defined the new beast class ID's for 64 bit pools */
#define	zFTYPE_ZLSS64_ZFSPOOL			101
#define	zFTYPE_ZLSS64_VOL				102
#define	zFTYPE_ZLSS64_BTREE				103
#define	zFTYPE_ZLSS64_VOLUME_DATA		104
#define	zFTYPE_ZLSS64_BEAST_TREE		105
#define	zFTYPE_ZLSS64_NAME_TREE			106
#define	zFTYPE_ZLSS64_LOG				107
#define	zFTYPE_ZLSS64_SALVAGE			108
#define	zFTYPE_ZLSS64_PURGE_LOG			109
#define	zFTYPE_ZLSS64_FREE_EXTENT		110
#define	zFTYPE_ZLSS64_USER_TREE			111
#define	zFTYPE_ZLSS64_VOLUME_LOCATOR	112
#define	zFTYPE_ZLSS64_LOGICAL_POOL		113
#define	zFTYPE_ZLSS64_MFL				114
#define	zFTYPE_ZLSS64_DIR_TREE			115
#define	zFTYPE_ZLSS64_EFL				116
#define zFTYPE_ZLSS64_ADGUID_TREE		117


	/******************************************************************************/
	/* When assigning a number ensure that the zAPI table BeastToFile is updated. */
	/******************************************************************************/

	/* current maximum supported value*/
#define zFTYPE_MAX					255		

/*---------------------------------------------------------------------------
 *	Definition of ret_openCreateAction flags
 *---------------------------------------------------------------------------*/
#define zBEAST_EXISTED			0x00000001	/* The beast previously existed */
#define zBEAST_CREATED			0x00000002	/* The beast was created/re-created */
#define zBEAST_TRUNCATED		0x00000004	/* The beast existed and was truncated */

/*-------------------------------------------------------------------------
 *	Definition of LSS ID Types
 *
 * These must be a unique value for every LSS.  These values are assigned
 * by Novell.  To request a value send E-Mail to NSS@Novell.Com and
 * ask for a LSS ID for each LSS that you are writing.
 *
 *-------------------------------------------------------------------------*/

#define zLSS_ID_INVALID			-1

#define	zLSS_ID_ADMIN			 10	/* Owned by Novell */
#define	zLSS_ID_ZLSS   			 20	/* Owned by Novell */
#define	zLSS_ID_FAT				 30	/* Owned by Novell */
#define	zLSS_ID_ISO9660			 40	/* Owned by Novell */
#define	zLSS_ID_HFSCD			 50	/* Owned by Novell */
#define zLSS_ID_UDFCD			 60	/* Owned by Novell */
#define zLSS_ID_FAT32			 70	/* Owned by Novell */
#define zLSS_ID_SMSTAPE			 90 /* Owned by Novell (SMS Team).
									 * Given out by Greg Pachner on Nov 18,
									 * 1998 to Sudhir Subbarao
									 * <sksubbarao@novell.com>
									 */

#define	zLSS_ID_NWSHRFLD		100 /* Owned by IBM (NWSAA Development Group)
									 * for Netware for SAA.  Given out by
									 * Greg Pachner on May 5, 1998.
									 */

#define zLSS_ID_NFSGATEWAY		110	/* Owned by Novell (NFS Gateway)
									 * Given out by Paul Taysom on Mar 31,
									 * 1999 to Giridhar V <vgiridhar@novell.com>
									 */

#define zLSS_ID_XLSS			120	/* Owned by Novell (XLSS) */
#define zLSS_ID_ZLSS64			130	/* Owned by Novell (XLSS) */

/*---------------------------------------------------------------------------
 *	Definition of getNameMask
 *---------------------------------------------------------------------------*/
#define zGFN_INCLUDE_PATH			0x00000001
#define zGFN_INCLUDE_VOLUME			0x00000002

#ifdef _NSS_INTERNAL_
	#define zVALID_GFN_MASK \
			(zGFN_INCLUDE_PATH | zGFN_INCLUDE_VOLUME)
#endif


/*-------------------------------------------------------------------------
 *	Definition of getInfoMask
 *-------------------------------------------------------------------------*/

enum zGetInfoMask_t
{
		/*
		 * Get the standard information about the file.
		 */
	zGET_STD_INFO			= 0x1,
		/*
		 * Get the name of the file object for the name space and hard link
		 * used to locate the file object.
		 */
	zGET_NAME				= 0x2,
		/*
		 * Get the name of the file object for each name space in which a
		 * valid name exists. Also, get the NameSpaceID of the name which
		 * is considered the original name for the file object. For a file
		 * object with multiple hard links, this only gets the names associated
		 * with the link used to find the file object.
		 */
	zGET_ALL_NAMES			= 0x4,
		/*
		 * Get the nameSpaceID of the primary name space for this file
		 * object's name.
		 */
	zGET_PRIMARY_NAMESPACE	= 0x8,
		/*
 		 * Get the various time stamps associated with the file object
		 * in seconds.  Though time is returned in seconds, the underlying
		 * system may only keep a resolution of 2 seconds.
		 */
	zGET_TIMES_IN_SECS		= 0x10,
		/*
		 * Get the various time stamps associated with the file object in
		 * micro-seconds.  Though time is returned in micro-seconds, the
		 * underlying system may only keep a resolution of 1 or 2 seconds.
		 * Note:  Only zGET_TIMES_IN_SECS or zGET_TIMES_IN_MICROS but not
		 * both, may be set.
		 */
	zGET_TIMES_IN_MICROS	= 0x20,
		/*
		 * Get the various NDS object IDs associated with this file object.
		 */
	zGET_IDS				= 0x40,
		/*
		 * Get information for this file object about the physical disk
		 * storage that is used.
		 */
	zGET_STORAGE_USED		= 0x80,
		/*
		 * Get information about the file object's block size.
		 */
	zGET_BLOCK_SIZE			= 0x100,
		/*
		 * Get the file open count and hard link count information
		 * about the file object.
		 */
	zGET_COUNTS				= 0x200,
		/*
		 * Get summary information about extended attributes owned by
		 * this file object.
		 */
	zGET_EXTENDED_ATTRIBUTE_INFO	= 0x400,
		/*
		 * Get summary information about data streams owned by this
		 * file object.
		 */
	zGET_DATA_STREAM_INFO	= 0x800,
		/*
		 * Get deleted file information about the file.  This includes
		 * the time in micro-seconds the file was deleted and the user
		 * ID of the user that deleted the file.
		 */
	zGET_DELETED_INFO		= 0x1000,
		/*
		 * Get the file object's macintosh metadata information.
		 */
	zGET_MAC_METADATA		= 0x2000,
		/*
		 * Get the file object's Unix metadata information.
		 */
	zGET_UNIX_METADATA		= 0x4000,
		/*
		 * If the file object is an extended attribute, this bit returns
		 * the extAttrUserFlags.
		 */
	zGET_EXTATTR_FLAGS		= 0x8000,
		/*
		 * If the file object is a volume, this bit returns the basic
		 * information about the volume.
		 */
	zGET_VOLUME_INFO		= 0x10000,
		/*
		 * If the file object is a volume, this bit returns the salvage
		 * information for the volume.
		 */
	zGET_VOL_SALVAGE_INFO	= 0x20000,
		/*
		 * If the file object is a pool, this bit returns the pool
		 * information for the volume.
		 */
	zGET_POOL_INFO			= 0x40000,
		/*
		* If the file object is a directory, this bit returns the 
		* directory quota information for the directory.
		*/
	zGET_DIR_QUOTA			= 0x80000,
		/*
		* Get the value of the inherited rights mask for this file.
		*/
	zGET_INH_RIGHTS_MASK	= 0x100000,
		/*
		 * Get a full list of all assigned trustees for this file.
		 */
	zGET_ALL_TRUSTEES		= 0x200000

#ifdef _NSS_INTERNAL_
	,
	zVALID_GET_INFO_MASK = (zGET_STD_INFO | zGET_NAME | zGET_ALL_NAMES |
			zGET_PRIMARY_NAMESPACE | zGET_TIMES_IN_SECS |
			zGET_TIMES_IN_MICROS | zGET_IDS | zGET_STORAGE_USED |
			zGET_BLOCK_SIZE | zGET_COUNTS | zGET_DATA_STREAM_INFO |
			zGET_DELETED_INFO | zGET_MAC_METADATA | zGET_UNIX_METADATA |
			zGET_VOLUME_INFO | zGET_VOL_SALVAGE_INFO | zGET_POOL_INFO | 
			zGET_DIR_QUOTA | zGET_INH_RIGHTS_MASK | zGET_ALL_TRUSTEES )
#endif
};



/*-------------------------------------------------------------------------
 *	Definition of handlePathType 
 *-------------------------------------------------------------------------*/
#define	zHPT_SIMPLE						1
#define	zHPT_FULL						2
#define	zHPT_CONTEXT					3
#define	zHPT_VOLUME						4
#define	zHPT_VOLUME_ZID					5
#define	zHPT_ADMIN_VOLUME   			6
#define	zHPT_ADMIN_VOLUME_ZID 			7
#define zHPT_FILEHANDLEID				8
#define	zHPT_SEARCH_PATTERN				9
#define zHPT_BEAST						10

#ifdef _NSS_INTERNAL_
	#define zHPT_UNDEFINED				0
	#define	zHPT_VOLUME_ZID_PATH		11
	#define	zHPT_ADMIN_VOLUME_ZID_PATH	12
#endif


/*---------------------------------------------------------------------------
 *	Definition of linkFlags in zLink
 *---------------------------------------------------------------------------*/
#define zLF_HARD_LINK					0x00000001
#define zLF_KEEP_VFS_CACHE				0x00000100	/* !! FOR INTERNAL USE ONLY !! */

#ifdef _NSS_INTERNAL_
	#define zVALID_LINK_FLAGS (zLF_HARD_LINK | zLF_KEEP_VFS_CACHE)
#endif
			
/*---------------------------------------------------------------------------
 *	Definition of matchFlags in zMatchAttr_s
 *---------------------------------------------------------------------------*/
#define zMATCH_ALL_DERIVED_TYPES		0x00000001

#define zMATCH_HIDDEN			0x1		/* Match if the hidden bit is set. */
#define zMATCH_NON_HIDDEN		0x2		/* Match if the hidden bit is NOT
										 * set.  If both zMATCH_NON_HIDDEN
										 * and zMATCH_HIDDEN are set, both
										 * hidden and non-hidden files will
										 * match.  If neither is set, nothing
										 * will match.
										 */
#define zMATCH_DIRECTORY		0x4		/* Match if the file object is
										 * a directory.
										 */
#define zMATCH_NON_DIRECTORY	0x8		/* Match if the file object is NOT
										 * a directory.  If both
										 * zMATCH_NON_DIRECTORY and
										 * zMATCH_DIRECTORY are set, both
										 * directories and other files will
										 * match.  If neither is set, nothing
										 * will match.
										 */ 
#define zMATCH_SYSTEM			0x10	/* Match if a system file. */
#define zMATCH_NON_SYSTEM		0x20	/* Match if NOT a system file.
										 * If both zMATCH_NON_SYSTEM and
										 * zMATCH_SYSTEM are set, both
										 * system and non-system file will
										 * match.  If neither is set,
										 * nothing will match.
										 */
#define zMATCH_ALL		(0xffffffff)	/* A define combining all of the
										 * above flags that matches all
										 * file objects in the given directory.
										 * NOTE: if the match flag is set
										 * to 0, it is ingnored and has the
										 * same affect as zMATCH_ALL.
										 */

/*-------------------------------------------------------------------------
 *	Definition of modifyInfoMask
 *-------------------------------------------------------------------------*/
#define zMOD_FILE_ATTRIBUTES			0x00000001
#define zMOD_CREATED_TIME				0x00000002
#define zMOD_ARCHIVED_TIME				0x00000004
#define zMOD_MODIFIED_TIME				0x00000008
#define zMOD_ACCESSED_TIME				0x00000010
#define zMOD_METADATA_MODIFIED_TIME		0x00000020
#define zMOD_OWNER_ID					0x00000040
#define zMOD_ARCHIVER_ID				0x00000080
#define zMOD_MODIFIER_ID				0x00000100
#define zMOD_METADATA_MODIFIER_ID		0x00000200
#define zMOD_PRIMARY_NAMESPACE			0x00000400
#define zMOD_DELETED_INFO				0x00000800
#define zMOD_MAC_METADATA				0x00001000
#define zMOD_UNIX_METADATA				0x00002000
#define zMOD_EXTATTR_FLAGS				0x00004000
#define zMOD_VOL_ATTRIBUTES				0x00008000
#define zMOD_VOL_NDS_OBJECT_ID			0x00010000
#define zMOD_VOL_MIN_KEEP_SECONDS		0x00020000
#define zMOD_VOL_MAX_KEEP_SECONDS		0x00040000
#define zMOD_VOL_LOW_WATER_MARK			0x00080000
#define zMOD_VOL_HIGH_WATER_MARK		0x00100000
#define zMOD_POOL_ATTRIBUTES			0x00200000
#define zMOD_POOL_NDS_OBJECT_ID			0x00400000
#define zMOD_VOL_DATA_SHREDDING_COUNT	0x00800000
#define zMOD_VOL_QUOTA					0x01000000
#define zMOD_DIR_QUOTA					0x02000000
#define zMOD_READ_AHEAD_BLOCKS			0x04000000
#define	zMOD_INH_RIGHTS_MASK			0x08000000
#define zMOD_ALL_TRUSTEES				0x10000000
#define zMOD_DELETED_ID				0x20000000
#define zMOD_DONT_UPDATE_METADATA_MODIFIED_TIME    0x40000000
#define zMOD_DS_EA_OWNER_ID				0x80000000

#define zNW_METADATA_MASK	(zMOD_FILE_ATTRIBUTES			\
							| zMOD_CREATED_TIME				\
							| zMOD_ARCHIVED_TIME			\
							| zMOD_MODIFIED_TIME			\
							| zMOD_ACCESSED_TIME			\
							| zMOD_METADATA_MODIFIED_TIME	\
							| zMOD_OWNER_ID					\
							| zMOD_ARCHIVER_ID				\
							| zMOD_MODIFIER_ID				\
							| zMOD_METADATA_MODIFIER_ID		\
							| zMOD_DIR_QUOTA				\
							| zMOD_INH_RIGHTS_MASK			\
							| zMOD_ALL_TRUSTEES)

#define     zMAX_READ_AHEAD_COUNT       1024   


#ifdef _NSS_INTERNAL_
	#define zVALID_MOD_EXTATTR_INFO_MASK \
			(zMOD_EXTATTR_FLAGS)
#endif

#ifdef _NSS_INTERNAL_
	#define zVALID_MOD_VOL_INFO_MASK \
			(zMOD_VOL_ATTRIBUTES | \
			 zMOD_VOL_NDS_OBJECT_ID | \
			 zMOD_VOL_MIN_KEEP_SECONDS | \
			 zMOD_VOL_MAX_KEEP_SECONDS | \
			 zMOD_VOL_LOW_WATER_MARK | \
			 zMOD_VOL_HIGH_WATER_MARK |	\
			 zMOD_VOL_DATA_SHREDDING_COUNT| \
			 zMOD_READ_AHEAD_BLOCKS	| \
			 zMOD_VOL_QUOTA)
#endif

#ifdef _NSS_INTERNAL_
	#define zVALID_MOD_POOL_INFO_MASK \
			(zMOD_POOL_ATTRIBUTES | \
			 zMOD_POOL_NDS_OBJECT_ID)
#endif

#ifdef _NSS_INTERNAL_
	#define zVALID_MOD_INFO_MASK \
			(zMOD_FILE_ATTRIBUTES | \
			zMOD_CREATED_TIME | zMOD_ARCHIVED_TIME | \
			zMOD_MODIFIED_TIME | zMOD_ACCESSED_TIME | \
			zMOD_METADATA_MODIFIED_TIME | \
			zMOD_OWNER_ID | zMOD_ARCHIVER_ID | \
			zMOD_MODIFIER_ID | zMOD_METADATA_MODIFIER_ID | \
			zMOD_PRIMARY_NAMESPACE | zMOD_DELETED_INFO | zMOD_DELETED_ID | \
			zMOD_MAC_METADATA | zMOD_UNIX_METADATA | \
			zVALID_MOD_EXTATTR_INFO_MASK | \
			zVALID_MOD_VOL_INFO_MASK | zVALID_MOD_POOL_INFO_MASK | \
			zMOD_DIR_QUOTA | zMOD_INH_RIGHTS_MASK | zMOD_ALL_TRUSTEES | \
			zMOD_DONT_UPDATE_METADATA_MODIFIED_TIME | \
			zMOD_DS_EA_OWNER_ID)
#endif

#ifdef _NSS_INTERNAL_
#define zCONFLICT_MOD_METADATA_MODIFIED_TIME_FLAGS \
	(zMOD_METADATA_MODIFIED_TIME | zMOD_DONT_UPDATE_METADATA_MODIFIED_TIME)
#endif

/*---------------------------------------------------------------------------
 *	Definition of nameType.  This is a field that is part of the key
 *	for directories.  It provides for multiple parallel but separate naming
 *	environments in the same directory container.
 *---------------------------------------------------------------------------*/
#define zNTYPE_FILE							0
#define zNTYPE_DATA_STREAM 					1
#define zNTYPE_EXTENDED_ATTRIBUTE			2
#define zNTYPE_DELETED_FILE					3

#ifdef _NSS_INTERNAL_
	#define zNTYPE_MAX_DEFINED					3

	/*#define zNTYPE_DELETED_DATA_STREAM 		4 */
	/*#define zNTYPE_DELETED_EXTENDED_ATTRIBUTE	5 */

	#define zNTYPE_INVALID						(-1)
#endif

/*-------------------------------------------------------------------------
 *	Definitions for nameSpaceID
 *-------------------------------------------------------------------------*/
#define zNSPACE_DOS						0
#define zNSPACE_MAC						1
#define zNSPACE_UNIX					2
/*#define zNSPACE_FTAM					3	not supported*/	
#define zNSPACE_LONG					4
#define zNSPACE_DATA_STREAM				6
#define zNSPACE_EXTENDED_ATTRIBUTE		7

#define zNSPACE_INVALID					(0xffffffff)

#define zNSPACE_DOS_MASK				(1<<zNSPACE_DOS)
#define zNSPACE_MAC_MASK				(1<<zNSPACE_MAC)
#define zNSPACE_UNIX_MASK				(1<<zNSPACE_UNIX)
#define zNSPACE_LONG_MASK				(1<<zNSPACE_LONG)
#define zNSPACE_DATA_STREAM_MASK		(1<<zNSPACE_DATA_STREAM)
#define zNSPACE_EXTENDED_ATTRIBUTE_MASK (1<<zNSPACE_EXTENDED_ATTRIBUTE)

#define zNSPACE_ALL_MASK		(0xffffffff)


/*---------------------------------------------------------------------------
 *	Definitions for nameSysID (naming system ID)
 *---------------------------------------------------------------------------*/

/* TBD */


/*---------------------------------------------------------------------------
 *	Definition of special path characters
 *---------------------------------------------------------------------------*/
#ifdef _NSS_INTERNAL_
	/* The zPATH_CHANGE_NAMESPACE character is followed by a WORD nameSpaceID
	 * and a WORD nameType and a word NULL terminator.  To prevent the
	 * nameSpaceID from being a NULL, we or the following bit into the
	 * nameSpaceID. */
	#define zPATH_CHANGE_NSPACE_BIT	0x8000
#endif

/*---------------------------------------------------------------------------
 *	Definition of character formats for paths
 *---------------------------------------------------------------------------*/
#define zPFMT_ASCII					1
#define zPFMT_UNICODE				2
#define zPFMT_UTF8					6

#ifdef _NSS_INTERNAL_
	#define zPFMT_ASCII_LP			3
	#define zPFMT_ASCII_COUNTED		4
	#define zPFMT_ASCII_LEN			5
	#define zPFMT_UTF8_LP			7
	#define zPFMT_UTF8_COUNTED		8
	#define zPFMT_UTF8_LEN			9
	#define zPFMT_UNDEFINED			0
#endif

#define zMODE_VOLUME_ID			0x80000000
#define zMODE_UTF8				0x40000000
#define zMODE_DELETED			0x20000000
#define zMODE_LINK				0x10000000
#define zMODE_VFS_OPEN			0x08000000	/* !! FOR INTERNAL USE ONLY !! */


/*-------------------------------------------------------------------------
 *	Definition of renameFlags
 *-------------------------------------------------------------------------*/
#define zRENAME_ALLOW_RENAMES_TO_MYSELF		0x00000001
#define zRENAME_THIS_NAME_SPACE_ONLY		0x00000004
#define zRENAME_DELETE_FILE_IF_THERE		0x00000008
#define zRENAME_KEEP_VFS_CACHE			0x00000100	/* !! FOR INTERNAL USE ONLY !! */
#define zRENAME_SALVAGE				0x00000200	/* flag will be set while salvaging */

#ifdef _NSS_INTERNAL_
	#define zRENAME_COMPATABILITY			0x00000002 /* Matches a traditional NW value */
	#define zRENAME_DONT_RENAME_FILES		0x00000010
	#define zRENAME_DONT_RENAME_DIRECTORIES	0x00000020
	#define zRENAME_TARGET_IS_PATTERN 		0x00000040


	#define	zVALID_RENAME_FLAGS \
			(zRENAME_ALLOW_RENAMES_TO_MYSELF | \
			 zRENAME_THIS_NAME_SPACE_ONLY | \
			 zRENAME_DELETE_FILE_IF_THERE | \
			 zRENAME_COMPATABILITY | \
			 zRENAME_DONT_RENAME_FILES | \
			 zRENAME_DONT_RENAME_DIRECTORIES | \
			 zRENAME_KEEP_VFS_CACHE | \
			 zRENAME_TARGET_IS_PATTERN)
#endif



/*
 *	Definition of requestedRights:
 *
 * zRR_READ_ACCESS					Read access to file object
 *
 * zRR_WRITE_ACCESS					Write access to file object
 *
 * zRR_DENY_READ					Don't let anyone else read this file
 *									If the file is already open for reading,
 *									the open fails.
 *
 * zRR_DENY_WRITE					Don't let anyone else write this file.
 *									If the file is already open for writing,
 *									the open fails.
 *
 * zRR_SCAN_ACCESS					Scan access to file object.  Can use
 *									zWildRead to scan the
 *									files/subdirectories/attributes
 *									of a file or directory.
 *
 * zRR_DELETE_FILE_ON_CLOSE			Delete the file when it is closed.
 *
 * zRR_FLUSH_ON_CLOSE				Flush all the data blocks when the
 *									file is closed.
 *
 * zRR_PURGE_IMMEDIATE_ON_CLOSE		If file is to be deleted on close,
 *									then don't put it in salavage system.
 *
 * zRR_DIO_MODE						Open file in Direct I/O Mode.
 *									Replaces changing to direct I/O mode.
 *									Conflicts with regular open modes of
 *									the file.
 * zRR_DONT_READ_AHEAD_ON_OPEN		Open file only. Don't read ahead
 *									2(default) blocks of file data
 *									(if file size > 0).
 *									Used by SMS for performing backup, where
 *									parallel open's are done.
 * zRR_PREVENT_FS_HOOKS				Internal only use bit, if set, don't call
 *									FS_Hooks during open/close on this file.
 *									Used to prevent virus scanning of files
 *									that have been opened for scan only during
 *									backup operations.
 *
 * zRR_TRANSACTION_ACTIVE			Have the file use the default transaction.
 * 
 * zRR_CREATE_WITHOUT_READ_ACCESS	Give only write access to the file when
 *									is created.
 *
 * zRR_OPENER_CAN_DELETE_WHILE_OPEN	Only the opener of the file can
 *									delete the file while it is open.
 *
 * zRR_CANT_DELETE_WHILE_OPEN		Don't let anyone delete this file
 *									while the file is open.
 *
 * zRR_DONT_UPDATE_ACCESS_TIME		Don't update the access time. Intended
 *									to let the clients access the icon
 *									information without causing a change
 *									in the files meta-data that would
 *									eventually have to be written.
 *
 */

#define zRR_READ_ACCESS						0x00000001
#define zRR_WRITE_ACCESS					0x00000002
#define zRR_DENY_READ						0x00000004
#define zRR_DENY_WRITE						0x00000008
#define zRR_SCAN_ACCESS						0x00000010
#define zRR_ENABLE_IO_ON_COMPRESSED_DATA	0x00000100
#define zRR_LEAVE_FILE_COMPRESSED	        0x00000200
#define zRR_DELETE_FILE_ON_CLOSE			0x00000400

#define zRR_FLUSH_ON_CLOSE					0x00000800
#define zRR_PURGE_IMMEDIATE_ON_CLOSE		0x00001000
#define zRR_DIO_MODE						0x00002000
#define zRR_DONT_READ_AHEAD_ON_OPEN			0x00004000

#define zRR_ALLOW_SECURE_DIRECTORY_ACCESS	0x00020000

#define zRR_TRANSACTION_ACTIVE				0x00100000
#define zRR_PSA_CACHE						0x00200000

#define zRR_PREVENT_FS_HOOKS				0x01000000
#define zRR_MASK_READ_IN_DROP_BOXES			0x02000000
#define zRR_READ_ACCESS_TO_SNAPSHOT			0x04000000
#define zRR_DENY_RW_OPENER_CAN_REOPEN		0x08000000
#define zRR_CREATE_WITHOUT_READ_ACCESS		0x10000000
#define zRR_OPENER_CAN_DELETE_WHILE_OPEN	0x20000000
#define zRR_CANT_DELETE_WHILE_OPEN			0x40000000
#define zRR_DONT_UPDATE_ACCESS_TIME			0x80000000


#ifdef _NSS_INTERNAL_
	#define zVALID_FILE_REQ_RIGHTS 					  \
			(zRR_READ_ACCESS 						| \
			zRR_WRITE_ACCESS 						| \
			zRR_DENY_READ 							| \
			zRR_DENY_WRITE 							| \
			zRR_SCAN_ACCESS 						| \
			zRR_ENABLE_IO_ON_COMPRESSED_DATA 		| \
			zRR_LEAVE_FILE_COMPRESSED 				| \
			zRR_DELETE_FILE_ON_CLOSE 				| \
			zRR_FLUSH_ON_CLOSE 						| \
			zRR_PURGE_IMMEDIATE_ON_CLOSE 			| \
			zRR_DIO_MODE 							| \
			zRR_DONT_READ_AHEAD_ON_OPEN				| \
			zRR_ALLOW_SECURE_DIRECTORY_ACCESS 		| \
			zRR_TRANSACTION_ACTIVE					| \
			zRR_PSA_CACHE							| \
			zRR_MASK_READ_IN_DROP_BOXES				| \
			zRR_READ_ACCESS_TO_SNAPSHOT				| \
			zRR_DENY_RW_OPENER_CAN_REOPEN 			| \
			zRR_CREATE_WITHOUT_READ_ACCESS 			| \
			zRR_OPENER_CAN_DELETE_WHILE_OPEN 		| \
			zRR_CANT_DELETE_WHILE_OPEN 				| \
			zRR_DONT_UPDATE_ACCESS_TIME)


	#define zVALID_READ_ONLY_FILE_REQ_RIGHTS 		  \
			(zRR_READ_ACCESS 						| \
			zRR_DENY_READ 							| \
			zRR_DENY_WRITE 							| \
			zRR_SCAN_ACCESS 						| \
			zRR_ENABLE_IO_ON_COMPRESSED_DATA 		| \
			zRR_LEAVE_FILE_COMPRESSED 				| \
			zRR_DIO_MODE 							| \
			zRR_DONT_READ_AHEAD_ON_OPEN				| \
			zRR_ALLOW_SECURE_DIRECTORY_ACCESS 		| \
			zRR_PSA_CACHE							| \
			zRR_MASK_READ_IN_DROP_BOXES				| \
			zRR_READ_ACCESS_TO_SNAPSHOT				| \
			zRR_DENY_RW_OPENER_CAN_REOPEN 			| \
			zRR_CREATE_WITHOUT_READ_ACCESS			| \
			zRR_OPENER_CAN_DELETE_WHILE_OPEN 		| \
			zRR_CANT_DELETE_WHILE_OPEN 				| \
			zRR_DONT_UPDATE_ACCESS_TIME)
#endif


/*-------------------------------------------------------------------------
 *	Definition of setSizeFlags
 *-------------------------------------------------------------------------*/
#define	zSETSIZE_NON_SPARSE_FILE 0x00000001 /* Alloc blocks to extend the	*
											 * file  	            		*/
#define zSETSIZE_NO_ZERO_FILL	 0x00000002 /* Do not zero fill the newly	*
											 * allocated blocks   			*/
#define zSETSIZE_UNDO_ON_ERR	 0x00000004	/* In non sparse cases truncate	*
											 * back to original eof if an	*
											 * error occurs.				*/
#define zSETSIZE_PHYSICAL_ONLY	 0x00000008 /* Change the physical EOF		*
											 * only, dont change logical	*
											 * EOF. This means non sparse	*
											 *  for the expand case.		*/
#define zSETSIZE_LOGICAL_ONLY	 0x00000010	/* Change only the logical		*
											 * EOF, expand will always be	*
											 * sparse, and trucate won't	*
											 * free physical blocks			*/
#define zSETSIZE_COMPRESSED      0x00000020 /* Set size of compressed stream */
#define zSETSIZE_CONTIGUOUS      0x00000040 /* Allocate the requested blocks *
											 * as contiguous blocks on disk  */

#ifdef _NSS_INTERNAL_
	#define zVALID_SETSIZE_FLAGS \
		(zSETSIZE_NON_SPARSE_FILE | zSETSIZE_PHYSICAL_ONLY | \
	 	 zSETSIZE_UNDO_ON_ERR | zSETSIZE_NO_ZERO_FILL |  \
         zSETSIZE_LOGICAL_ONLY | zSETSIZE_COMPRESSED | zSETSIZE_CONTIGUOUS )
#endif


/*-------------------------------------------------------------------------
 *	Defintions of taskID
 *-------------------------------------------------------------------------*/
#define zNSS_TASK	50		/* We use the NSS task ID */

#define zNO_TASK	0

/*-----------------------------------------------------------------------
 *	Definition of volumeState
 *-----------------------------------------------------------------------*/
#define zVOLSTATE_UNKNOWN			0	/* Volume is new and not available 	*/
#define zVOLSTATE_DEACTIVE			2	/* Volume is not currently activated */
#define zVOLSTATE_MAINTENANCE		3	/* Volume is in a maintenance mode */
#define zVOLSTATE_ACTIVE			6	/* Volume is active and available */

/*-----------------------------------------------------------------------
 *	Byte range lock types
 *-----------------------------------------------------------------------*/

enum {
	zLOCK_SHARED    = 0x1,	/* Shared or read lock */
	zLOCK_EXCLUSIVE = 0x3	/* Exclusive or write lock */
};

/*-----------------------------------------------------------------------
 *	Definitions for user space restrictions
 *-----------------------------------------------------------------------*/
#define zUSER_NO_RESTRICTIONS		UI64_CONST(0x7FFFFFFFFFFFFFFF)
#define zDIR_NO_QUOTA				UI64_CONST(0x7FFFFFFFFFFFFFFF)

/*-------------------------------------------------------------------------
 *	Well Known ZIDs on a volume
 *-------------------------------------------------------------------------*/
#define zDEFAULT_ZID_ALLOCATION_RANGE 128	/* how many ZIDS to get when we ask the volume*/

#define zINVALID_ZID			((Zid_t)0)		/* value for an INVALID ZID*/
#define zOPEN_ENTRY_ZID			((Zid_t)-1)		/* zid for open slot in the beast b-tree */
#define zROOTDIR_ZID			((Zid_t)zFIRST_ALLOCATABLE_ZID-1)	/* ID of rootdir*/
#define	zDOT_COOKIE		(zROOTDIR_ZID-1)	/* NFS cookie for "." */
#define zDOTDOT_COOKIE	(zROOTDIR_ZID-2)	/* NFS cookie for ".." */
#define zNOMORE_COOKIES	(zROOTDIR_ZID-3)	/* NFS no more files */

/* ID of first ZID definable by users, all well known zids will be less than this */
#define zFIRST_ALLOCATABLE_ZID	((Zid_t)zDEFAULT_ZID_ALLOCATION_RANGE)

/*-------------------------------------------------------------------------
 *	Logical Volume no size quota (LV size will mirror pool size)
 *-------------------------------------------------------------------------*/
#define zLV_NO_QUOTA_SIZE	UI64_CONST(0x7FFFFFFFFFFFF000)

/*=========================================================================
 *=========================================================================
 *	"New" Structure definitions
 *=========================================================================
 *=========================================================================*/


/*=========================================================================
 *	Definition of zInfo_s used for returning/modifying information about a
 *	file object.
 *=========================================================================*/
/*-------------------------------------------------------------------------
 *  In order to allow the user to override the default size of the
 *	variableData portion of this structure, a define has been provided
 *	to specify the size of that portion.  This then allows for stack
 *	variables to be created of type zGetInfo, with those stack variables
 *	having the desired size for the variable portion.
 *-------------------------------------------------------------------------*/
#ifndef zGET_INFO_VARIABLE_DATA_SIZE
	#define zGET_INFO_VARIABLE_DATA_SIZE	(zMAX_COMPONENT_NAME*2)
#endif

typedef struct zMacInfo_s
{
	BYTE 	finderInfo[32];
	BYTE 	proDOSInfo[6];
	BYTE	filler[2];
	LONG	dirRightsMask;
} NSS_MEDIA_STRUCTURE(zMacInfo_s,dirRightsMask) zMacInfo_s;

typedef struct zUnixInfo_s
{
 	LONG	fMode;
 	LONG	rDev;
 	LONG	myFlags;
 	LONG	nfsUID;
 	LONG 	nfsGID;
	LONG	nwUID;
	LONG	nwGID;
	LONG	nwEveryone;
	LONG	nwUIDRights;
	LONG	nwGIDRights;
	LONG	nwEveryoneRights;
 	BYTE	acsFlags;
 	BYTE	firstCreated;
 	SWORD	variableSize;
	/* If variableSize is non-zero, there will be "variableSize" number of
	 * additional bytes of meta data associated with this file. The format
	 * of this variable data is unknown to NSS
	 */
} NSS_MEDIA_STRUCTURE(zUnixInfo_s,variableSize) zUnixInfo_s;

/*---------------------------------------------------------------------------
 *	Definition of typeInfo returned for zFTYPE_VOLUME
 *---------------------------------------------------------------------------*/
typedef struct zVolumeInfo_s
{
	VolumeID_t	volumeID;		/* 128 bit GUID that identifies volume. */
   	NDSid_t		ndsObjectID;	/* zMOD_VOL_NDS_OBJECT_ID
								 * 128 bit Object Id assigned by eDir */
	LONG		volumeState;	/* Current state of the volume, ACTIVE (6),
								 * DEACTIVE (2), MAINTENANCE (3) */
	LONG		nameSpaceMask;	/* Name spaces supported on this volume. */
	struct {
		QUAD	enabled;		/* zMOD_VOL_ATTRIBUTES
								 * Features currently enabled for the volume. */
		QUAD	enableModMask;	/* zMOD_VOL_ATTRIBUTES
								 * Mask of features that should be changed. */
		QUAD	supported;		/* Features that can be supported by volume */
	} zPACKED features;
	QUAD		maximumFileSize;/* Maximum file size supported by volume. */	
	QUAD		totalSpaceQuota;/* zMOD_VOL_QUOTA
								 * Maximum size of this volume
								 * (may over book pool) */
	QUAD		numUsedBytes;	/* Number of bytes in use by this volume */
	QUAD		numObjects;		/* Number of file like objects including
								 * extended attributes and data streams. */
	QUAD		numFiles;		/* Number of files in the volumes. */

	LONG		authModelID;	/* zFTYPE_ZAS_AUTH_MODEL - traditional
								 * NetWare authorization.
								 * zFTYPE_UNIX_AUTH_MODEL - Unix, rwxrwxrwx,
								 * authorization. */

	LONG		dataShreddingCount;	/* zMOD_VOL_DATA_SHREDDING_COUNT
									 * How many writes are done to the disk
									 * to obscure the original data.  Up to
									 * 7 passes can be specified. */

			/* The salvage system saves deleted files until the system
			 * needs their space.  These fields provide information about
			 * the deleted files. */
	struct {						/* zGET_VOL_SALVAGE_INFO */
		QUAD	purgeableBytes;		/* Space used by deleted files that
									 * can reclaimed. */
		QUAD	nonPurgeableBytes;	/* Space of deleted files that can't
									 * be reclaimed yet. */
		QUAD	numDeletedFiles;	/* Total number of deleted files in
									 * salvage. */
		QUAD	oldestDeletedTime;	/* Date of oldest deleted file in
									 * salvage. */
		LONG	minKeepSeconds;		/* zMOD_VOL_MIN_KEEP_SECONDS
									 * NOT SUPPORTED on ZLSS -- minimum
									 * number of seconds a file in kept
									 * in the salvage system. */
		LONG	maxKeepSeconds;		/* zMOD_VOL_MAX_KEEP_SECONDS
									 * Maximum time to keep deleted files. */

								/* When the percent of used space reaches
								 * the highWaterMark, NSS begins purging
								 * deleted files until used space drops
								 * below the lowWaterMark. */
		LONG	lowWaterMark;		/* zMOD_VOL_LOW_WATER_MARK */
		LONG	highWaterMark;		/* zMOD_VOL_HIGH_WATER_MARK */
	} zPACKED salvage;
    struct {                            /* Compression-related Statistics */
        QUAD    numCompressedFiles;	/* Number of files that have been
									 * compressed. */
        QUAD    numCompDelFiles;	/* Number of compressed deleted files. */
        QUAD    numUncompressibleFiles;	/* Number of files that cannot be
										 * compresses. */
        QUAD    numPreCompressedBytes;	/* How much space we would have used
										 * without compression. */
        QUAD    numCompressedBytes;	/* How much space used with compressions. */
    } zPACKED comp;
} zPACKED zVolumeInfo_s;

typedef struct zPoolInfo_s
{
	VolumeID_t	poolID;			/* 128 bit GUID that identifies pool. */
	NDSid_t		ndsObjectID;	/* zMOD_POOL_NDS_OBJECT_ID
								 * 128 bit Object Id assigned by eDir */
	LONG		poolState;		/* Current state of the pool, ACTIVE (6),
								 * DEACTIVE (2), MAINTENANCE (3) */
	LONG		nameSpaceMask;	/* Which name spaces are supported on
								 * this pool. */
	struct {
		QUAD	enabled;		/* zMOD_POOL_ATTRIBUTES
								 * Features that are currently enabled
								 * for the pool. */
		QUAD	enableModMask;	/* zMOD_POOL_ATTRIBUTES
								 * Mask of features that should be
								 * changed. */
		QUAD	supported;		/* Features that can be supported by
								 * this pool. */
	} zPACKED features;
	QUAD		totalSpace;		/* Total number of bytes available on
								 * pool. */
	QUAD		numUsedBytes;		/* Number of bytes used in pool. */
	QUAD		purgeableBytes;		/* Number of bytes in deleted but not
									 * purged files. */
	QUAD		nonPurgeableBytes;	/* Deleted files but can't be purged yet. */
} zPACKED zPoolInfo_s;

typedef struct zTrusteeInfo_s
{
	GUID_t		trustee;
	LONG		rights;
} zPACKED zTrusteeInfo_s;

typedef struct zTrusteeInfoEx_s
{
	zNW_id_u	trustee;
	LONG		is_aduser;
	LONG		rights;
} zPACKED zTrusteeInfoEx_s;

enum
{
	zINFO_VERSION_A = 1,
	zINFO_VERSION_B,
	zINFO_VERSION_C,
	zINFO_VERSION_D,
	zINFO_VERSION_E
};
#define zINFO_VERSION_MAX	zINFO_VERSION_E

/* Created because GCC would not compile when it was in-line. */

typedef struct Standard_s {
	Zid_t		zid;			/* Zid of the file			*/
	Zid_t		dataStreamZid;	/* Data stream Zid			*/
	Zid_t		parentZid;		/* Parent used to open file	*/
	QUAD		logicalEOF;		/* End of File (see physicalEOF)	*/
	VolumeID_t	volumeID;
	LONG		fileType;
	LONG		fileAttributes;			/* zMOD_FILE_ATTRIBUTES */
	LONG		fileAttributesModMask;	/* zMOD_FILE_ATTRIBUTES */
	LONG		padding;
} zPACKED Standard_s;

	/*
	 * Fields are arranged to make alignment easier (QUAD, LONG, WORD, BYTE)
	 */
typedef struct zInfo_s
{
	LONG	infoVersion;	/* Verion of Info structure			*/
	SLONG	totalBytes;		/* Total bytes in fixed and variable
							 * data sections.  We use both sections
							 * so we can grow the fixed area without
							 * breaking older code.
							 */
	SLONG	nextByte;		/* Next byte to use in variable area */
	LONG	idAttributes;
	QUAD	retMask;		/* Fields set in Info structure		*/
	Standard_s	std;				/* zGET_STD_INFO			*/

	struct {						/* zGET_STORAGE_USED */
		QUAD	 physicalEOF;	/* The file may have more blocks allocated
								 * than it needs, this marks of the end of
								 * extra data blocks
								 */
    	QUAD	 dataBytes;		/* Storage used by user data	*/
    	QUAD	 metaDataBytes;	/* Storage used by Meta-data	*/
	} zPACKED storageUsed;

	LONG	primaryNameSpaceID;		/* zGET_PRIMARY_NAMESPACE */
									/* zMOD_PRIMARY_NAMESPACE */
	LONG 	nameStart;				/* zGET_NAME - index into variableData */

	struct {						/* zGET_ALL_NAMES */
		LONG 	numEntries;
		LONG 	fileNameArray;		/* Index of the array of indicies in
									 * the variableData area
									 */
	} zPACKED names;

	struct {						/* zGET_TIMES */
		QUAD	created;			/* zMOD_CREATED_TIME */
		QUAD	archived;			/* zMOD_ARCHIVED_TIME */
		QUAD	modified;			/* zMOD_MODIFIED_TIME */
		QUAD	accessed;			/* zMOD_ACCESSED_TIME */
		QUAD	metaDataModified;	/* zMOD_METADATA_MODIFIED_TIME */
	} zPACKED time;

	struct {						/* zGET_IDS */
	 	UserID_t owner;				/* zMOD_OWNER_ID */
    	UserID_t archiver;			/* zMOD_ARCHIVER_ID */
    	UserID_t modifier;			/* zMOD_MODIFIER_ID */
    	UserID_t metaDataModifier;	/* zMOD_METADATA_MODIFIER_ID */
	} zPACKED id;

	struct {						/* zGET_BLOCK_SIZE */
		LONG	 size;
		LONG	 sizeShift;
	} zPACKED blockSize;

	struct {						/* zGET_COUNTS */
		LONG	 open;
		LONG	 hardLink;
	} zPACKED count;

	struct {						/* zGET_DATA_STREAM_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED dataStream;

	struct {						/* zGET_EXTENDED_ATTRIBUTE_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED extAttr;

	struct {						/* zGET_DELETED_INFO */
									/* zMOD_DELETED_INFO */
		QUAD	 time;
		UserID_t id;					/* zMOD_DELETED_ID */
	} zPACKED deleted;

	struct {						/* zGET_MAC_METADATA */
		zMacInfo_s info;			/* zMOD_MAC_METADATA */
	} zPACKED macNS;

	struct {						/* zGET_UNIX_METADATA */
		zUnixInfo_s info;			/* zMOD_UNIX_METADATA */
		LONG		offsetToData;
	} zPACKED unixNS;

	zVolumeInfo_s	vol;			/* zGET_VOLUME_INFO */

	zPoolInfo_s		pool;			/*	zGET_POOL_METADATA	*/

	LONG	extAttrUserFlags;		/* zGET_EXTATTR_FLAGS */
									/* zMOD_EXTATTR_FLAGS */

	/* The variable portion will contain all variable size optional data */
	BYTE		variableData[zGET_INFO_VARIABLE_DATA_SIZE];

} zPACKED zInfo_s;

	/*
	 * Fields are arranged to make alignment easier (QUAD, LONG, WORD, BYTE)
	 */


typedef struct zInfoB_s
{
	LONG	infoVersion;	/* Verion of Info structure			*/
	SLONG	totalBytes;		/* Total bytes in fixed and variable
							 * data sections.  We use both sections
							 * so we can grow the fixed area without
							 * breaking older code.
							 */
	SLONG	nextByte;		/* Next byte to use in variable area */
	LONG	idAttributes;
	QUAD	retMask;		/* Fields set in Info structure		*/
	Standard_s	std;				/* zGET_STD_INFO			*/

	struct {						/* zGET_STORAGE_USED */
		QUAD	 physicalEOF;	/* The file may have more blocks allocated
								 * than it needs, this marks of the end of
								 * extra data blocks
								 */
    	QUAD	 dataBytes;		/* Storage used by user data	*/
    	QUAD	 metaDataBytes;	/* Storage used by Meta-data	*/
	} zPACKED storageUsed;

	LONG	primaryNameSpaceID;		/* zGET_PRIMARY_NAMESPACE */
									/* zMOD_PRIMARY_NAMESPACE */
	LONG 	nameStart;				/* zGET_NAME - index into variableData */

	struct {						/* zGET_ALL_NAMES */
		LONG 	numEntries;
		LONG 	fileNameArray;		/* Index of the array of indicies in
									 * the variableData area
									 */
	} zPACKED names;

	struct {						/* zGET_TIMES */
		QUAD	created;			/* zMOD_CREATED_TIME */
		QUAD	archived;			/* zMOD_ARCHIVED_TIME */
		QUAD	modified;			/* zMOD_MODIFIED_TIME */
		QUAD	accessed;			/* zMOD_ACCESSED_TIME */
		QUAD	metaDataModified;	/* zMOD_METADATA_MODIFIED_TIME */
	} zPACKED time;

	struct {						/* zGET_IDS */
	 	UserID_t owner;				/* zMOD_OWNER_ID */
    	UserID_t archiver;			/* zMOD_ARCHIVER_ID */
    	UserID_t modifier;			/* zMOD_MODIFIER_ID */
    	UserID_t metaDataModifier;	/* zMOD_METADATA_MODIFIER_ID */
	} zPACKED id;

	struct {						/* zGET_BLOCK_SIZE */
		LONG	 size;
		LONG	 sizeShift;
	} zPACKED blockSize;

	struct {						/* zGET_COUNTS */
		LONG	 open;
		LONG	 hardLink;
	} zPACKED count;

	struct {						/* zGET_DATA_STREAM_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED dataStream;

	struct {						/* zGET_EXTENDED_ATTRIBUTE_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED extAttr;

	struct {						/* zGET_DELETED_INFO */
									/* zMOD_DELETED_INFO */
		QUAD	 time;
		UserID_t id;					/* zMOD_DELETED_ID */
	} zPACKED deleted;

	struct {						/* zGET_MAC_METADATA */
		zMacInfo_s info;			/* zMOD_MAC_METADATA */
	} zPACKED macNS;

	struct {						/* zGET_UNIX_METADATA */
		zUnixInfo_s info;			/* zMOD_UNIX_METADATA */
		LONG		offsetToData;
	} zPACKED unixNS;

	zVolumeInfo_s	vol;			/* zGET_VOLUME_INFO */

	zPoolInfo_s		pool;			/*	zGET_POOL_METADATA	*/

	LONG	extAttrUserFlags;		/* zGET_EXTATTR_FLAGS */
									/* zMOD_EXTATTR_FLAGS */

	struct {						/* zGET_DIR_QUOTA */
		SQUAD	quota;				/* zMOD_DIR_QUOTA */
		SQUAD	usedAmount;
	} zPACKED dirQuota;
	
									

	/* The variable portion will contain all variable size optional data */
	BYTE		variableData[zGET_INFO_VARIABLE_DATA_SIZE];

} zPACKED zInfoB_s;

	/*
	 * Fields are arranged to make alignment easier (QUAD, LONG, WORD, BYTE)
	 */
typedef struct zInfoC_s
{
	LONG	infoVersion;	/* Verion of Info structure			*/
	SLONG	totalBytes;		/* Total bytes in fixed and variable
							 * data sections.  We use both sections
							 * so we can grow the fixed area without
							 * breaking older code.
							 */
	SLONG	nextByte;		/* Next byte to use in variable area */
	LONG	idAttributes;
	QUAD	retMask;		/* Fields set in Info structure		*/
	Standard_s	std;				/* zGET_STD_INFO			*/

	struct {						/* zGET_STORAGE_USED */
		QUAD	 physicalEOF;	/* The file may have more blocks allocated
								 * than it needs, this marks of the end of
								 * extra data blocks
								 */
    	QUAD	 dataBytes;		/* Storage used by user data	*/
    	QUAD	 metaDataBytes;	/* Storage used by Meta-data	*/
	} zPACKED storageUsed;

	LONG	primaryNameSpaceID;		/* zGET_PRIMARY_NAMESPACE */
									/* zMOD_PRIMARY_NAMESPACE */
	LONG 	nameStart;				/* zGET_NAME - index into variableData */

	struct {						/* zGET_ALL_NAMES */
		LONG 	numEntries;
		LONG 	fileNameArray;		/* Index of the array of indicies in
									 * the variableData area
									 */
	} zPACKED names;

	struct {						/* zGET_TIMES */
		QUAD	created;			/* zMOD_CREATED_TIME */
		QUAD	archived;			/* zMOD_ARCHIVED_TIME */
		QUAD	modified;			/* zMOD_MODIFIED_TIME */
		QUAD	accessed;			/* zMOD_ACCESSED_TIME */
		QUAD	metaDataModified;	/* zMOD_METADATA_MODIFIED_TIME */
	} zPACKED time;

	struct {						/* zGET_IDS */
	 	UserID_t owner;				/* zMOD_OWNER_ID */
    	UserID_t archiver;			/* zMOD_ARCHIVER_ID */
    	UserID_t modifier;			/* zMOD_MODIFIER_ID */
    	UserID_t metaDataModifier;	/* zMOD_METADATA_MODIFIER_ID */
	} zPACKED id;

	struct {						/* zGET_BLOCK_SIZE */
		LONG	 size;
		LONG	 sizeShift;
	} zPACKED blockSize;

	struct {						/* zGET_COUNTS */
		LONG	 open;
		LONG	 hardLink;
	} zPACKED count;

	struct {						/* zGET_DATA_STREAM_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED dataStream;

	struct {						/* zGET_EXTENDED_ATTRIBUTE_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED extAttr;

	struct {						/* zGET_DELETED_INFO */
									/* zMOD_DELETED_INFO */
		QUAD	 time;
		UserID_t id;					/* zMOD_DELETED_ID */
	} zPACKED deleted;

	struct {						/* zGET_MAC_METADATA */
		zMacInfo_s info;			/* zMOD_MAC_METADATA */
	} zPACKED macNS;

	struct {						/* zGET_UNIX_METADATA */
		zUnixInfo_s info;			/* zMOD_UNIX_METADATA */
		LONG		offsetToData;
	} zPACKED unixNS;

	zVolumeInfo_s	vol;			/* zGET_VOLUME_INFO */

	zPoolInfo_s		pool;			/*	zGET_POOL_METADATA	*/

	LONG	extAttrUserFlags;		/* zGET_EXTATTR_FLAGS */
									/* zMOD_EXTATTR_FLAGS */

	struct {						/* zGET_DIR_QUOTA */
		SQUAD	quota;				/* zMOD_DIR_QUOTA */
		SQUAD	usedAmount;
	} zPACKED dirQuota;
	
	LONG inheritedRightsMask;		/* zGET_INH_RIGHTS_MASK */
									/* zMOD_INH_RIGHTS_MASK */

	struct {						/* zGET_ALL_TRUSTEES */
									/* zMOD_ALL_TRUSTEES */
		LONG 	numEntries;
		LONG 	trusteeArray;		/* Index of the array of zTrusteeInfo_s
									 * structures in the variableData area
									 */
	} zPACKED trustees;

	/* The variable portion will contain all variable size optional data */
	BYTE		variableData[zGET_INFO_VARIABLE_DATA_SIZE];

} zPACKED zInfoC_s;

	/*
	 * Fields are arranged to make alignment easier (QUAD, LONG, WORD, BYTE)
	 */
typedef struct zInfoD_s
{
	LONG	infoVersion;	/* Verion of Info structure			*/
	SLONG	totalBytes;		/* Total bytes in fixed and variable
							 * data sections.  We use both sections
							 * so we can grow the fixed area without
							 * breaking older code.
							 */
	SLONG	nextByte;		/* Next byte to use in variable area */
	LONG	idAttributes;
	QUAD	retMask;		/* Fields set in Info structure		*/
	Standard_s	std;				/* zGET_STD_INFO			*/

	struct {						/* zGET_STORAGE_USED */
		QUAD	 physicalEOF;	/* The file may have more blocks allocated
								 * than it needs, this marks of the end of
								 * extra data blocks
								 */
    	QUAD	 dataBytes;		/* Storage used by user data	*/
    	QUAD	 metaDataBytes;	/* Storage used by Meta-data	*/
	} zPACKED storageUsed;

	LONG	primaryNameSpaceID;		/* zGET_PRIMARY_NAMESPACE */
									/* zMOD_PRIMARY_NAMESPACE */
	LONG 	nameStart;				/* zGET_NAME - index into variableData */

	struct {						/* zGET_ALL_NAMES */
		LONG 	numEntries;
		LONG 	fileNameArray;		/* Index of the array of indicies in
									 * the variableData area
									 */
	} zPACKED names;

	struct {						/* zGET_TIMES */
		QUAD	created;			/* zMOD_CREATED_TIME */
		QUAD	archived;			/* zMOD_ARCHIVED_TIME */
		QUAD	modified;			/* zMOD_MODIFIED_TIME */
		QUAD	accessed;			/* zMOD_ACCESSED_TIME */
		QUAD	metaDataModified;	/* zMOD_METADATA_MODIFIED_TIME */
	} zPACKED time;

	struct {						/* zGET_IDS */
	 	UserID_t owner;				/* zMOD_OWNER_ID */
    	UserID_t archiver;			/* zMOD_ARCHIVER_ID */
    	UserID_t modifier;			/* zMOD_MODIFIER_ID */
    	UserID_t metaDataModifier;	/* zMOD_METADATA_MODIFIER_ID */
	} zPACKED id;

	struct {						/* zGET_BLOCK_SIZE */
		LONG	 size;
		LONG	 sizeShift;
	} zPACKED blockSize;

	struct {						/* zGET_COUNTS */
		LONG	 open;
		LONG	 hardLink;
	} zPACKED count;

	struct {						/* zGET_DATA_STREAM_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED dataStream;

	struct {						/* zGET_EXTENDED_ATTRIBUTE_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED extAttr;

	struct {						/* zGET_DELETED_INFO */
									/* zMOD_DELETED_INFO */
		QUAD	 time;
		UserID_t id;					/* zMOD_DELETED_ID */
	} zPACKED deleted;

	struct {						/* zGET_MAC_METADATA */
		zMacInfo_s info;			/* zMOD_MAC_METADATA */
	} zPACKED macNS;

	struct {						/* zGET_UNIX_METADATA */
		zUnixInfo_s info;			/* zMOD_UNIX_METADATA */
		LONG		offsetToData;
	} zPACKED unixNS;

	zVolumeInfo_s	vol;			/* zGET_VOLUME_INFO */

	zPoolInfo_s		pool;			/*	zGET_POOL_METADATA	*/

	LONG	extAttrUserFlags;		/* zGET_EXTATTR_FLAGS */
									/* zMOD_EXTATTR_FLAGS */

	struct {						/* zGET_DIR_QUOTA */
		SQUAD	quota;				/* zMOD_DIR_QUOTA */
		SQUAD	usedAmount;
	} zPACKED dirQuota;
	
	LONG inheritedRightsMask;		/* zGET_INH_RIGHTS_MASK */
									/* zMOD_INH_RIGHTS_MASK */

	struct {						/* zGET_ALL_TRUSTEES */
									/* zMOD_ALL_TRUSTEES */
		LONG 	numEntries;
		LONG 	trusteeArray;		/* Index of the array of zTrusteeInfo_s
									 * structures in the variableData area
									 */
	} zPACKED trustees;

	Zid_t		hardlinkPrimaryZid;	/* zGET_STD_INFO
									 * ZID of hardlink primary beast. Will be
									 * zINVALID_ZID if this is not a hardlink.
									 */

	/* The variable portion will contain all variable size optional data */
	BYTE		variableData[zGET_INFO_VARIABLE_DATA_SIZE];

} zPACKED zInfoD_s;

typedef struct zInfoE_s
{
	LONG	infoVersion;	/* Verion of Info structure			*/
	SLONG	totalBytes;		/* Total bytes in fixed and variable
							 * data sections.  We use both sections
							 * so we can grow the fixed area without
							 * breaking older code.
							 */
	SLONG	nextByte;		/* Next byte to use in variable area */
	LONG	idAttributes;	//TODO check name. Flags indicating if the GUID in IDs as AD or not. 
	QUAD	retMask;		/* Fields set in Info structure		*/
	Standard_s	std;				/* zGET_STD_INFO			*/

	struct {						/* zGET_STORAGE_USED */
		QUAD	 physicalEOF;	/* The file may have more blocks allocated
								 * than it needs, this marks of the end of
								 * extra data blocks
								 */
    	QUAD	 dataBytes;		/* Storage used by user data	*/
    	QUAD	 metaDataBytes;	/* Storage used by Meta-data	*/
	} zPACKED storageUsed;

	LONG	primaryNameSpaceID;		/* zGET_PRIMARY_NAMESPACE */
									/* zMOD_PRIMARY_NAMESPACE */
	LONG 	nameStart;				/* zGET_NAME - index into variableData */

	struct {						/* zGET_ALL_NAMES */
		LONG 	numEntries;
		LONG 	fileNameArray;		/* Index of the array of indicies in
									 * the variableData area
									 */
	} zPACKED names;

	struct {						/* zGET_TIMES */
		QUAD	created;			/* zMOD_CREATED_TIME */
		QUAD	archived;			/* zMOD_ARCHIVED_TIME */
		QUAD	modified;			/* zMOD_MODIFIED_TIME */
		QUAD	accessed;			/* zMOD_ACCESSED_TIME */
		QUAD	metaDataModified;	/* zMOD_METADATA_MODIFIED_TIME */
	} zPACKED time;

	struct {						/* zGET_IDS */
	 	UserID_t owner;				/* zMOD_OWNER_ID */
    	UserID_t archiver;			/* zMOD_ARCHIVER_ID */
    	UserID_t modifier;			/* zMOD_MODIFIER_ID */
    	UserID_t metaDataModifier;	/* zMOD_METADATA_MODIFIER_ID */
	} zPACKED id;

	struct {						/* zGET_BLOCK_SIZE */
		LONG	 size;
		LONG	 sizeShift;
	} zPACKED blockSize;

	struct {						/* zGET_COUNTS */
		LONG	 open;
		LONG	 hardLink;
	} zPACKED count;

	struct {						/* zGET_DATA_STREAM_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED dataStream;

	struct {						/* zGET_EXTENDED_ATTRIBUTE_INFO */
		LONG	 count;
		LONG	 totalNameSize;
		QUAD	 totalDataSize;
	} zPACKED extAttr;

	struct {						/* zGET_DELETED_INFO */
									/* zMOD_DELETED_INFO */
		QUAD	 time;
		UserID_t id;					/* zMOD_DELETED_ID */
	} zPACKED deleted;

	struct {						/* zGET_MAC_METADATA */
		zMacInfo_s info;			/* zMOD_MAC_METADATA */
	} zPACKED macNS;

	struct {						/* zGET_UNIX_METADATA */
		zUnixInfo_s info;			/* zMOD_UNIX_METADATA */
		LONG		offsetToData;
	} zPACKED unixNS;

	zVolumeInfo_s	vol;			/* zGET_VOLUME_INFO */

	zPoolInfo_s		pool;			/*	zGET_POOL_METADATA	*/

	LONG	extAttrUserFlags;		/* zGET_EXTATTR_FLAGS */
									/* zMOD_EXTATTR_FLAGS */

	struct {						/* zGET_DIR_QUOTA */
		SQUAD	quota;				/* zMOD_DIR_QUOTA */
		SQUAD	usedAmount;
	} zPACKED dirQuota;
	
	LONG inheritedRightsMask;		/* zGET_INH_RIGHTS_MASK */
									/* zMOD_INH_RIGHTS_MASK */

	struct {						/* zGET_ALL_TRUSTEES */
									/* zMOD_ALL_TRUSTEES */
		LONG 	numEntries;
		LONG 	trusteeArray;		/* Index of the array of zTrusteeInfo_s or zTrusteeInfoEx_s
									 * structures in the variableData area
									 */
	} zPACKED trustees;

	Zid_t		hardlinkPrimaryZid;	/* zGET_STD_INFO
									 * ZID of hardlink primary beast. Will be
									 * zINVALID_ZID if this is not a hardlink.
									 */

	struct {						/* zGET_IDS */
	 	SID_t owner;				/* zMOD_OWNER_ID */
    	SID_t archiver;			/* zMOD_ARCHIVER_ID */
    	SID_t modifier;			/* zMOD_MODIFIER_ID */
    	SID_t metaDataModifier;	/* zMOD_METADATA_MODIFIER_ID */
	} zPACKED adID;

	SID_t adDeletor; 		 /* zGET_DELETED_INFO, zMOD_DELETED_INFO, zMOD_DELETED_ID */

	/* The variable portion will contain all variable size optional data */
	BYTE		variableData[zGET_INFO_VARIABLE_DATA_SIZE];
}zPACKED zInfoE_s;


#define zINFO_PTR(_info, _i)	(&(((BYTE *)(_info))[(_i)]))

#define zINFO_NAME(_info)		\
	((unicode_t *)zINFO_PTR((_info), (_info)->nameStart))

#define zINFO_FILENAMES(_info)	\
	((LONG *)&((BYTE *)(_info))[(_info)->names.fileNameArray])

unicode_t *zInfoGetFileName(zInfo_s *info, NINT nameSpace);


/*---------------------------------------------------------------------------
 
 *	Definition of typeInfo returned for zFTYPE_EXTENDED_ATTRIBUTE
 *---------------------------------------------------------------------------*/
typedef struct ZnewExtAttrInfo_s
{
	NINT		extAttrUserFlags;		/* zGET_EXTATTR_FLAGS */
										/* zMOD_EXTATTR_FLAGS */
} zPACKED ZnewExtAttrInfo_s;

/*---------------------------------------------------------------------------
 *	Definition of typeInfo returned for zFTYPE_SYM_LINK
 *---------------------------------------------------------------------------*/
#ifndef zGET_SYMLINK_VARIABLE_DATA_SIZE
	#define zGET_SYMLINK_VARIABLE_DATA_SIZE	(zMAX_FULL_NAME*2)
#endif

typedef struct ZnewGetSymLinkInfo_s
{
	LONG	symLinkStart;	/* Start of path name in variableData */
	BYTE	variableData[zGET_SYMLINK_VARIABLE_DATA_SIZE];
} zPACKED ZnewGetSymLinkInfo_s;


/*=========================================================================
 *=========================================================================
 *	Structure definitions
 *=========================================================================
 *=========================================================================*/

/*=========================================================================
 *	Definition of zGetName_s used for returning name/path  information
 *	about a file object
 *=========================================================================*/
/*-------------------------------------------------------------------------
 *  In order to allow the user to override the default size of the
 *	variableData portion of this structure, a define has been provided
 *	to specify the size of that portion.  This then allows for stack
 *	variables to be created of type zGetName_s, with those stack variables
 *	having the desired size for the variable portion.
 *-------------------------------------------------------------------------*/
#ifndef zGET_NAME_VARIABLE_DATA_SIZE
	#define zGET_NAME_VARIABLE_DATA_SIZE	(zMAX_FULL_NAME*2)
#endif

typedef struct zGetName_s
{
	/* This data is always returned */
	void		*name;

	/* The variable portion will contain all variable size optional data */
	BYTE		variableData[zGET_NAME_VARIABLE_DATA_SIZE];

} zPACKED zGetName_s;


/*=========================================================================
 *	Definition of zInfo_s used for returning/modifying information about a
 *	file object.
 *=========================================================================*/
/*-------------------------------------------------------------------------
 *  In order to allow the user to override the default size of the
 *	variableData portion of this structure, a define has been provided
 *	to specify the size of that portion.  This then allows for stack
 *	variables to be created of type zGetInfo, with those stack variables
 *	having the desired size for the variable portion.
 *-------------------------------------------------------------------------*/
#ifndef zGET_INFO_VARIABLE_DATA_SIZE
	#define zGET_INFO_VARIABLE_DATA_SIZE	(zMAX_COMPONENT_NAME*2)
#endif




/*===========================================================================*/
/*===========================================================================*/
/* This is Type specific Get Info for Extended Attribute objects */
/*===========================================================================*/
/*===========================================================================*/
/*-------------------------------------------------------------------------
 *	Definition of getTypeInfoMask for zFTYPE_EXTENDED_ATTRIBUTE
 *  (zExtAttrInfo_s)
 *-------------------------------------------------------------------------*/
#define Z_GET_EXTATTR_FLAGS				0x01000000

#ifdef _NSS_INTERNAL_
	#define Z_VALID_GET_EXT_ATTR_INFO_MASK \
			(Z_GET_EXTATTR_FLAGS)
#endif

/*-------------------------------------------------------------------------
 *	Definition of modifyTypeInfoMask for zFTYPE_EXTENDED_ATTRIBUTE
 *	(ModifyExtAttrInfo_s)
 *-------------------------------------------------------------------------*/
#define Z_MOD_EXTATTR_FLAGS				0x01000000

#ifdef _NSS_INTERNAL_
	#define Z_VALID_MOD_EXTATTR_INFO_MASK \
			(Z_MOD_EXTATTR_FLAGS)
#endif

/*---------------------------------------------------------------------------
 *	Definition of typeInfo returned for zFTYPE_EXTENDED_ATTRIBUTE
 *---------------------------------------------------------------------------*/
typedef struct zExtAttrInfo_s
{
	LONG	extAttrUserFlags;		/* zGET_EXTATTR_FLAGS */
										/* zMOD_EXTATTR_FLAGS */
} zExtAttrInfo_s;

/*---------------------------------------------------------------------------
 *	Definition of typeInfo returned for zFTYPE_SYM_LINK
 *---------------------------------------------------------------------------*/
#ifndef zGET_SYMLINK_VARIABLE_DATA_SIZE
	#define zGET_SYMLINK_VARIABLE_DATA_SIZE	(zMAX_FULL_NAME*2)
#endif

typedef struct zGetSymLinkInfo_s
{
	unicode_t	*symLinkPath;
	BYTE	variableData[zGET_SYMLINK_VARIABLE_DATA_SIZE];
} zPACKED zGetSymLinkInfo_s;


/*=========================================================================
 *	This structure is used to specify match criteria to be applied to a
 *	file when identifing it via the naming information.  If a selected file
 *	does not match this naming criteria, it will be skipped over.
 *=========================================================================*/
typedef struct zMatchAttr_s
{
	NINT	matchFlags;
	NINT	matchFileType;

	NINT 	matchFileAttrSet;
	NINT	matchFileAttrNotSet;

	NINT	matchTypeAttrSet;
	NINT	matchTypeAttrNotSet;
} zPACKED zMatchAttr_s;



/*---------------------------------------------------------------------------
 *	Buffer definition for the buffer returned by AsyncRead calls
 *---------------------------------------------------------------------------*/
/*** This Buffer matches PubBuffer_s. Any modifications made here
 *** should be reflected in PubBuffer_s in xCache.h 
 ***/
typedef struct zBuffer_s
{
	BYTE *data;
	ADDR reReadHandle;
	QUAD blockNumber;
} zBuffer_s;


/*---------------------------------------------------------------------------
 * Structure to pass user restriction info from the browse routine.
 *---------------------------------------------------------------------------*/
typedef struct zUserRest_s
{
	UserID_t	userID;
	SQUAD		usedAmount;
	SQUAD		restrictionAmount;
} zPACKED zUserRest_s;


/*---------------------------------------------------------------------------
 * Structure to pass trustee IDs and restriction info for authorization model
 *---------------------------------------------------------------------------*/
typedef struct zTrustee_s
{
	UserID_t	trustee;
	LONG		rights;
	LONG		padding;
} zPACKED zTrustee_s;

/************************************************************************
 *  States of the virtual file
 ***********************************************************************/
#define FHV_NEW					0x00
#define FHV_ACTUAL_DATA			0x01	/* set if we are working with the real data */
#define FHV_RESULT_DATA			0x02	/* set when data in result buffer is good */
#define FHV_FORCE_RESULT_READ	0x04	/* read from result buffer only */
#define FHV_TEMPLATE_DEFINED	0x08	/* a template has been defined during this session */
#define FHV_FORCE_RESULT_READ_STARTED	0x10 /* Result of forced data is partly read */

/*-------------------------------------------------------------------------
 *	Structure maintained in the file handle for a virtual file
 *-------------------------------------------------------------------------*/

#define VIRT_DATASTREAM_NAME_SIZE	64
typedef struct VirtInfo_s
{
	struct GeneralMsg_s	*genMsg;	/* Pointer to the genmsg in the caller */
	NINT	resultEOF;			/* EOF for the result buffer */
	NINT	virtState;			/* state of the virtual file */
	NINT	offsetAdjustment;	/* amount to adjust the offset */
	NINT	nameSize;			/* Size of the datastream name */
	NINT	resultBufferSize;	/* Size of the result buffer in bytes */
	void	(*closeFunc)(		/* function to be called at close time */
				struct VirtInfo_s *virtInfo);
	NINT	memAllocatedSize;	/* size of memory pointed to by memPtr */
	NINT	memUsedSize;		/* amount of the memory in use */
	void	*memPtr;			/* a pointer to memory supplied by the function */
	BYTE	*resultBuffer;		/* buffer to hold data between operations */
	NINT	otherSize;			/* the size of the info in otherPtr */
	void	*otherPtr;			/* a pointer for other operations - like cookies */
	utf8_t	virtDataStreamName[VIRT_DATASTREAM_NAME_SIZE];
								/* The name of the virtual datastream */
	struct JavaInfo_s *javaInfo;/* info for doing java calls */
	struct Latch_s	*javaLatch;	/* Latch for protecting java VirtInfo fields */
	NINT	useCount;			/* Count of active users */
} VirtInfo_s;

#ifdef __cplusplus
}
#endif

#endif	/* _ZPARAMS_H_ */


